<?php

namespace Database\Seeders;

use App\Models\CompanyLicenceType;
use App\Models\DocumentType;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\App;

class DocumentTypeTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        /**
         * Reset the CompanyLicenceType table
         */
        // if (\App::environment('local')) {
        //     CompanyLicenceType::truncate();
        // }

    	$country = [
	        [
				'company_id'        => '1',
				'country_id'        => '101',
				'license_type_name' => 'TRADE LICENSE NUMBER',
				'license_code'      => 'TRADELICENSE ',
				'license_status'    => 1,
				'priority'          => 1,
				'created_at'        => date('Y-m-d H:i:s'),
				'updated_at'        => date('Y-m-d H:i:s')
	        ],
	        [
				'company_id'        => '1',
				'country_id'        => '101',
				'license_type_name' => 'CIN NUMBER',
				'license_code'      => 'CIN',
				'license_status'    => 1,
				'priority'          => 2,
				'created_at'        => date('Y-m-d H:i:s'),
				'updated_at'        => date('Y-m-d H:i:s')
	        ],
	        [
				'company_id'        => '1',
				'country_id'        => '101',
				'license_type_name' => 'GST NUMBER',
				'license_code'      => 'GST',
				'license_status'    => 1,
				'priority'          => 3,
				'created_at'        => date('Y-m-d H:i:s'),
				'updated_at'        => date('Y-m-d H:i:s')
	        ],
	        [
				'company_id'        => '1',
				'country_id'        => '101',
				'license_type_name' => 'VAT NO',
				'license_code'      => 'VAT',
				'license_status'    => 1,
				'priority'          => 4,
				'created_at'        => date('Y-m-d H:i:s'),
				'updated_at'        => date('Y-m-d H:i:s')
	        ],
	        [
				'company_id'        => '1',
				'country_id'        => '101',
				'license_type_name' => 'PAN NO',
				'license_code'      => 'PAN',
				'license_status'    => 1,
				'priority'          => 5,
				'created_at'        => date('Y-m-d H:i:s'),
				'updated_at'        => date('Y-m-d H:i:s')
	        ],
	        [
				'company_id'        => '1',
				'country_id'        => '101',
				'license_type_name' => 'TAN NO',
				'license_code'      => 'TAN',
				'license_status'    => 1,
				'priority'          => 6,
				'created_at'        => date('Y-m-d H:i:s'),
				'updated_at'        => date('Y-m-d H:i:s')
	        ],
	        [
				'company_id'        => '1',
				'country_id'        => '101',
				'license_type_name' => 'TIN NO',
				'license_code'      => 'TIN',
				'license_status'    => 1,
				'priority'          => 7,
				'created_at'        => date('Y-m-d H:i:s'),
				'updated_at'        => date('Y-m-d H:i:s')
	        ],
	        [
				'company_id'        => '1',
				'country_id'        => '101',
				'license_type_name' => 'DL NUMBER1',
				'license_code'      => 'DL1',
				'license_status'    => 1,
				'priority'          => 8,
				'created_at'        => date('Y-m-d H:i:s'),
				'updated_at'        => date('Y-m-d H:i:s')
	        ],
	        [
				'company_id'        => '1',
				'country_id'        => '101',
				'license_type_name' => 'DL NUMBER2',
				'license_code'      => 'DL2',
				'license_status'    => 1,
				'priority'          => 9,
				'created_at'        => date('Y-m-d H:i:s'),
				'updated_at'        => date('Y-m-d H:i:s')
	        ],
	        [
				'company_id'        => '1',
				'country_id'        => '101',
				'license_type_name' => 'AADHAAR NUMBER',
				'license_code'      => 'AADHAAR',
				'license_status'    => 1,
				'priority'          => 10,
				'created_at'        => date('Y-m-d H:i:s'),
				'updated_at'        => date('Y-m-d H:i:s')
	        ],
	        [
				'company_id'        => '1',
				'country_id'        => '101',
				'license_type_name' => 'TRANSPORTER ID',
				'license_code'      => 'TRANSPORTERID',
				'license_status'    => 1,
				'priority'          => 11,
				'created_at'        => date('Y-m-d H:i:s'),
				'updated_at'        => date('Y-m-d H:i:s')
	        ],
	        [
				'company_id'        => '1',
				'country_id'        => '101',
				'license_type_name' => 'RCMC REG. NO',
				'license_code'      => 'RCMCNO',
				'license_status'    => 1,
				'priority'          => 12,
				'created_at'        => date('Y-m-d H:i:s'),
				'updated_at'        => date('Y-m-d H:i:s')
	        ],
	        [
				'company_id'        => '1',
				'country_id'        => '101',
				'license_type_name' => 'IE CODE',
				'license_code'      => 'IECODE',
				'license_status'    => 1,
				'priority'          => 13,
				'created_at'        => date('Y-m-d H:i:s'),
				'updated_at'        => date('Y-m-d H:i:s')
	        ],
	        [
				'company_id'        => '1',
				'country_id'        => '101',
				'license_type_name' => 'LUT NUMBER',
				'license_code'      => 'LUT',
				'license_status'    => 1,
				'priority'          => 14,
				'created_at'        => date('Y-m-d H:i:s'),
				'updated_at'        => date('Y-m-d H:i:s')
	        ],
	        [
				'company_id'        => '1',
				'country_id'        => '101',
				'license_type_name' => 'FSSAI NO',
				'license_code'      => 'FSSAI',
				'license_status'    => 1,
				'priority'          => 15,
				'created_at'        => date('Y-m-d H:i:s'),
				'updated_at'        => date('Y-m-d H:i:s')
	        ],

	    ];
        foreach ($country as $data) {
            CompanyLicenceType::firstOrCreate(
                ['license_code' => $data['license_code']],
                $data
            );
        }
    }
}
