<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\EInvoiceApiCall;

class EInvoiceApiCallsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $data = [
            [
                'api_id'       => 1,
                'request_name' => 'authentication',
                'request_url'  => '/einvoice/authenticate',
                'request_type' => 'GET',
                'status'       => 1,
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'api_id'       => 1,
                'request_name' => 'get_gstn_details',
                'request_url'  => '/einvoice/type/GSTNDETAILS/version/V1_03',
                'request_type' => 'GET',
                'status'       => 1,
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'api_id'       => 1,
                'request_name' => 'get_sync_gstin_from_cp',
                'request_url'  => '/einvoice/type/SYNC_GSTIN_FROMCP/version/V1_03',
                'request_type' => 'GET',
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s'),
                'status'       => 1,
            ],
            [
                'api_id'       => 1,
                'request_name' => 'generate_irn',
                'request_url'  => '/einvoice/type/GENERATE/version/V1_03',
                'request_type' => 'POST',
                'status'       => 1,
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'api_id'       => 1,
                'request_name' => 'get_eInvoice_details',
                'request_url'  => '/einvoice/type/GETIRN/version/V1_03',
                'request_type' => 'GET',
                'status'       => 1,
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'api_id'       => 1,
                'request_name' => 'get_irn_details_by_doc_details',
                'request_url'  => '/einvoice/type/GETIRNBYDOCDETAILS/version/V1_03',
                'request_type' => 'GET',
                'status'       => 1,
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'api_id'       => 1,
                'request_name' => 'cancel_irn',
                'request_url'  => '/einvoice/type/CANCEL/version/V1_03',
                'request_type' => 'POST',
                'status'       => 1,
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'api_id'       => 1,
                'request_name' => 'generate_ewaybill',
                'request_url'  => '/einvoice/type/GENERATE_EWAYBILL/version/V1_03',
                'request_type' => 'POST',
                'status'       => 1,
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'api_id'       => 1,
                'request_name' => 'get_ewaybill_details_by_irn',
                'request_url'  => '/einvoice/type/GETEWAYBILLIRN/version/V1_03',
                'request_type' => 'GET',
                'status'       => 1,
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'api_id'       => 1,
                'request_name' => 'get_b2c_qr_code_details',
                'request_url'  => '/einvoice/qrcode',
                'request_type' => 'GET',
                'status'       => 1,
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
        ];

        foreach ($data as $data) {
            EInvoiceApiCall::firstOrCreate(
                ['request_name' => $data['request_name']],
                $data
            );
        }
    }
}
