<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\EWayBillApiCall;

class EWayBillApiCallsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $EWayBillApiCall =[
            [
                'api_id' => 1,
                'request_name' => 'authentication',
                'request_url' => '/ewaybillapi/v1.03/authenticate',
                'request_type' => 'GET',
                'status' => 1,
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'api_id' => 1,
                'request_name' => 'generate_e_way_bill',
                'request_url' => '/ewaybillapi/v1.03/ewayapi/genewaybill',
                'request_type' => 'POST',
                'status' => 1,
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'api_id' => 1,
                'request_name' => 'update_part_b_vehicle_no',
                'request_url' => '/ewaybillapi/v1.03/ewayapi/vehewb',
                'request_type' => 'POST',
                'status' => 1,
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'api_id' => 1,
                'request_name' => 'generate_consolidated_e_way_bill',
                'request_url' => '/ewaybillapi/v1.03/ewayapi/gencewb',
                'request_type' => 'POST',
                'status' => 1,
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'api_id' => 1,
                'request_name' => 'cancel_e_way_bill',
                'request_url' => '/ewaybillapi/v1.03/ewayapi/canewb',
                'request_type' => 'POST',
                'status' => 1,
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'api_id' => 1,
                'request_name' => 'reject_e_way_bill',
                'request_url' => '/ewaybillapi/v1.03/ewayapi/rejewb',
                'request_type' => 'POST',
                'status' => 1,
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'api_id' => 1,
                'request_name' => 'update_transporter',
                'request_url' => '/ewaybillapi/v1.03/ewayapi/updatetransporter',
                'request_type' => 'POST',
                'status' => 1,
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'api_id' => 1,
                'request_name' => 'extend_validity',
                'request_url' => '/ewaybillapi/v1.03/ewayapi/extendvalidity',
                'request_type' => 'POST',
                'status' => 1,
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'api_id' => 1,
                'request_name' => 'regenerate_consolidated_e_way_bill',
                'request_url' => '/ewaybillapi/v1.03/ewayapi/regentripsheet',
                'request_type' => 'POST',
                'status' => 1,
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'api_id' => 1,
                'request_name' => 'get_e_way_bill_details',
                'request_url' => '/ewaybillapi/v1.03/ewayapi/getewaybill',
                'request_type' => 'GET',
                'status' => 1,
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'api_id' => 1,
                'request_name' => 'get_e_way_bill_for_transporter_by_date',
                'request_url' => '/ewaybillapi/v1.03/ewayapi/getewaybillsfortransporter',
                'request_type' => 'GET',
                'status' => 1,
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'api_id' => 1,
                'request_name' => 'get_e_way_bill_by_transporter_by_state',
                'request_url' => '/ewaybillapi/v1.03/ewayapi/getewaybillsfortransporterbystate',
                'request_type' => 'GET',
                'status' => 1,
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'api_id' => 1,
                'request_name' => 'get_e_way_bill_for_transporter_by_gstin',
                'request_url' => '/ewaybillapi/v1.03/ewayapi/getewaybillsfortransporterbygstin',
                'request_type' => 'GET',
                'status' => 1,
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'api_id' => 1,
                'request_name' => 'get_e_way_bill_by_transporter_assigned_date',
                'request_url' => '/ewaybillapi/v1.03/ewayapi/getewaybillreportbytransporterassigneddate',
                'request_type' => 'GET',
                'status' => 1,
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'api_id' => 1,
                'request_name' => 'get_e_way_bills_by_date',
                'request_url' => '/ewaybillapi/v1.03/ewayapi/getewaybillsbydate',
                'request_type' => 'GET',
                'status' => 1,
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'api_id' => 1,
                'request_name' => 'get_e_way_bills_rejected_by_others',
                'request_url' => '/ewaybillapi/v1.03/ewayapi/getewaybillsrejectedbyothers',
                'request_type' => 'GET',
                'status' => 1,
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'api_id' => 1,
                'request_name' => 'get_consolidated_e_way_bill',
                'request_url' => '/ewaybillapi/v1.03/ewayapi/gettripsheet',
                'request_type' => 'GET',
                'status' => 1,
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'api_id' => 1,
                'request_name' => 'get_e_way_bill_by_consignor',
                'request_url' => '/ewaybillapi/v1.03/ewayapi/getewaybillgeneratedbyconsigner',
                'request_type' => 'GET',
                'status' => 1,
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'api_id' => 1,
                'request_name' => 'get_error_list',
                'request_url' => '/ewaybillapi/v1.03/ewayapi/geterrorlist',
                'request_type' => 'GET',
                'status' => 1,
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'api_id' => 1,
                'request_name' => 'get_gstin_details',
                'request_url' => '/ewaybillapi/v1.03/ewayapi/getgstindetails',
                'request_type' => 'GET',
                'status' => 1,
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'api_id' => 1,
                'request_name' => 'get_transin_details',
                'request_url' => '/ewaybillapi/v1.03/ewayapi/gettransporterdetails',
                'request_type' => 'GET',
                'status' => 1,
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'api_id' => 1,
                'request_name' => 'get_hsn_details',
                'request_url' => '/ewaybillapi/v1.03/ewayapi/gethsndetailsbyhsncode',
                'request_type' => 'GET',
                'status' => 1,
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'api_id' => 1,
                'request_name' => 'initiate_multi_vehicle_movement',
                'request_url' => '/ewaybillapi/v1.03/ewayapi/initmulti',
                'request_type' => 'POST',
                'status' => 1,
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'api_id' => 1,
                'request_name' => 'add_multi_vehicles',
                'request_url' => '/ewaybillapi/v1.03/ewayapi/addmulti',
                'request_type' => 'POST',
                'status' => 1,
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'api_id' => 1,
                'request_name' => 'change_multi_vehicles',
                'request_url' => '/ewaybillapi/v1.03/ewayapi/updtmulti',
                'request_type' => 'POST',
                'status' => 1,
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'api_id' => 1,
                'request_name' => 'get_e_way_bills_by_parties',
                'request_url' => '/ewaybillapi/v1.03/ewayapi/getewaybillsofotherparty',
                'request_type' => 'GET',
                'status' => 1,
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
        ];
        foreach ($EWayBillApiCall as $data) {
            EWayBillApiCall::firstOrCreate(
                ['request_name' => $data['request_name']],
                $data
            );
        }
    }
}

