<?php

namespace Database\Seeders;

use App\Models\EmployeeType;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class EmployeeTypeTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
    	$employeeType = [
			[
             'name'       => 'Full Time',
             'code'       => 'FULL_TIME',
             'status'     => 1,
             'created_at' => date('Y-m-d H:i:s'),
             'updated_at' => date('Y-m-d H:i:s'),
	        ],
			[
             'name'       => 'On Site',
             'code'       => 'ON_SITE',
             'status'     => 1,
             'created_at' => date('Y-m-d H:i:s'),
             'updated_at' => date('Y-m-d H:i:s'),
	        ],
			[
             'name'       => 'On Contract',
             'code'       => 'ON_CONTRACT',
             'status'     => 1,
             'created_at' => date('Y-m-d H:i:s'),
             'updated_at' => date('Y-m-d H:i:s'),
	        ],
			[
             'name'       => 'Internship',
             'code'       => 'INTERNSHIP',
             'status'     => 1,
             'created_at' => date('Y-m-d H:i:s'),
             'updated_at' => date('Y-m-d H:i:s'),
	        ],
			[
             'name'       => 'Trainee',
             'code'       => 'TRAINEE',
             'status'     => 1,
             'created_at' => date('Y-m-d H:i:s'),
             'updated_at' => date('Y-m-d H:i:s'),
	        ],
            [
             'name'       => 'New',
             'code'       => 'NEW',
             'status'     => 1,
             'created_at' => date('Y-m-d H:i:s'),
             'updated_at' => date('Y-m-d H:i:s'),
            ],
	    ];

        foreach ($employeeType as $data) {
            EmployeeType::firstOrCreate(
                ['code' => $data['code']],
                $data
            );
        }
    }
}
