<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\EnquiryQuality;

class EnquiryQualityTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $enquiry_quality = [
            [
                'enquiry_quality_name'        => 'Normal',
                'code'                        => 'NORMAL',
                'enquiry_quality_description' => '',
                'enquiry_quality_priority'    => 1,
                'status'                      => 1,
                'company_id'                  => 1,
                'additional3'                 => '',
                'color'                       => '#FFFFFF',
                'bg_color'                    => '#000000',
                'default'                     => 1,
                'created_at'                  => date('Y-m-d H:i:s'),
                'updated_at'                  => date('Y-m-d H:i:s'),
            ],
            [
                'enquiry_quality_name'        => 'Good',
                'code'                        => 'GOOD',
                'enquiry_quality_description' => '',
                'enquiry_quality_priority'    => 2,
                'status'                      => 1,
                'company_id'                  => 1,
                'additional3'                 => '',
                'color'                       => '#FFFFFF',
                'bg_color'                    => '#000000',
                'default'                     => 0,
                'created_at'                  => date('Y-m-d H:i:s'),
                'updated_at'                  => date('Y-m-d H:i:s'),
            ],
            [
                'enquiry_quality_name'        => 'Hot',
                'code'                        => 'HOT',
                'enquiry_quality_description' => '',
                'enquiry_quality_priority'    => 3,
                'status'                      => 1,
                'company_id'                  => 1,
                'additional3'                 => '',
                'color'                       => '#FFFFFF',
                'bg_color'                    => '#000000',
                'default'                     => 0,
                'created_at'                  => date('Y-m-d H:i:s'),
                'updated_at'                  => date('Y-m-d H:i:s'),
            ],
            [
                'enquiry_quality_name'        => 'Cold',
                'code'                        => 'COLD',
                'enquiry_quality_description' => '',
                'enquiry_quality_priority'    => 4,
                'status'                      => 1,
                'company_id'                  => 1,
                'additional3'                 => '',
                'color'                       => '#FFFFFF',
                'bg_color'                    => '#000000',
                'default'                     => 0,
                'created_at'                  => date('Y-m-d H:i:s'),
                'updated_at'                  => date('Y-m-d H:i:s'),
            ],
            [
                'enquiry_quality_name'        => 'Bad',
                'code'                        => 'BAD',
                'enquiry_quality_description' => '',
                'enquiry_quality_priority'    => 5,
                'status'                      => 1,
                'company_id'                  => 1,
                'additional3'                 => '',
                'color'                       => '#FFFFFF',
                'bg_color'                    => '#000000',
                'default'                     => 0,
                'created_at'                  => date('Y-m-d H:i:s'),
                'updated_at'                  => date('Y-m-d H:i:s'),
            ],
        ];

        foreach ($enquiry_quality as $data) {
            EnquiryQuality::firstOrCreate(
                ['code' => $data['code']],
                $data
            );
        }
    }
}
