<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\EnquirySource;

class EnquirySourcesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $enquiry_sources = [
            [
				'enquiry_source_name'     => 'N/A',
				'enquiry_source_code'     => 'N/A',
				'default'                 => 1,
				'enquiry_source_priority' => 1,
				'company_id'              => 1,
				'created_at'              => date('Y-m-d H:i:s'),
				'updated_at'              => date('Y-m-d H:i:s'),
            ],
            [
				'enquiry_source_name'     => 'Alibaba',
				'enquiry_source_code'     => 'ALIBABA',
				'default'                 => 0,
				'enquiry_source_priority' => 2,
				'company_id'              => 1,
				'created_at'              => date('Y-m-d H:i:s'),
				'updated_at'              => date('Y-m-d H:i:s'),
            ],
            [
				'enquiry_source_name'     => 'Bulk SMS',
				'enquiry_source_code'     => 'BULK SMS',
				'default'                 => 0,
				'enquiry_source_priority' => 3,
				'company_id'              => 1,
				'created_at'              => date('Y-m-d H:i:s'),
				'updated_at'              => date('Y-m-d H:i:s'),
            ],
            [
				'enquiry_source_name'     => 'Cross Selling',
				'enquiry_source_code'     => 'CROSS SELLING',
				'default'                 => 0,
				'enquiry_source_priority' => 4,
				'company_id'              => 1,
				'created_at'              => date('Y-m-d H:i:s'),
				'updated_at'              => date('Y-m-d H:i:s'),
            ],
            [
				'enquiry_source_name'     => 'Customer Reff.',
				'enquiry_source_code'     => 'CUSTOMER REFF.',
				'default'                 => 0,
				'enquiry_source_priority' => 5,
				'company_id'              => 1,
				'created_at'              => date('Y-m-d H:i:s'),
				'updated_at'              => date('Y-m-d H:i:s'),
            ],
            [
				'enquiry_source_name'     => 'Digital Board',
				'enquiry_source_code'     => 'DIGITAL BOARD',
				'default'                 => 0,
				'enquiry_source_priority' => 6,
				'company_id'              => 1,
				'created_at'              => date('Y-m-d H:i:s'),
				'updated_at'              => date('Y-m-d H:i:s'),
            ],
            [
				'enquiry_source_name'     => 'Email Marketing',
				'enquiry_source_code'     => 'EMAIL MARKETING',
				'default'                 => 0,
				'enquiry_source_priority' => 7,
				'company_id'              => 1,
				'created_at'              => date('Y-m-d H:i:s'),
				'updated_at'              => date('Y-m-d H:i:s'),
            ],
            [
				'enquiry_source_name'     => 'Facebook',
				'enquiry_source_code'     => 'FACEBOOK',
				'default'                 => 0,
				'enquiry_source_priority' => 8,
				'company_id'              => 1,
				'created_at'              => date('Y-m-d H:i:s'),
				'updated_at'              => date('Y-m-d H:i:s'),
            ],
            [
				'enquiry_source_name'     => 'Google',
				'enquiry_source_code'     => 'GOOGLE',
				'default'                 => 0,
				'enquiry_source_priority' => 9,
				'company_id'              => 1,
				'created_at'              => date('Y-m-d H:i:s'),
				'updated_at'              => date('Y-m-d H:i:s'),
            ],
            [
				'enquiry_source_name'     => 'IndiaMART',
				'enquiry_source_code'     => 'INDIAMART',
				'default'                 => 0,
				'enquiry_source_priority' => 10,
				'company_id'              => 1,
				'created_at'              => date('Y-m-d H:i:s'),
				'updated_at'              => date('Y-m-d H:i:s'),
            ],
            [
				'enquiry_source_name'     => 'Instagram',
				'enquiry_source_code'     => 'INSTAGRAM',
				'default'                 => 0,
				'enquiry_source_priority' => 11,
				'company_id'              => 1,
				'created_at'              => date('Y-m-d H:i:s'),
				'updated_at'              => date('Y-m-d H:i:s'),
            ],
            [
				'enquiry_source_name'     => 'Just Dial',
				'enquiry_source_code'     => 'JUST DIAL',
				'default'                 => 0,
				'enquiry_source_priority' => 12,
				'company_id'              => 1,
				'created_at'              => date('Y-m-d H:i:s'),
				'updated_at'              => date('Y-m-d H:i:s'),
            ],
            [
				'enquiry_source_name'     => 'LinkedIn',
				'enquiry_source_code'     => 'LINKEDIN',
				'default'                 => 0,
				'enquiry_source_priority' => 13,
				'company_id'              => 1,
				'created_at'              => date('Y-m-d H:i:s'),
				'updated_at'              => date('Y-m-d H:i:s'),
            ],
            [
				'enquiry_source_name'     => 'Paper Add',
				'enquiry_source_code'     => 'PAPER ADD',
				'default'                 => 0,
				'enquiry_source_priority' => 14,
				'company_id'              => 1,
				'created_at'              => date('Y-m-d H:i:s'),
				'updated_at'              => date('Y-m-d H:i:s'),
            ],
            [
				'enquiry_source_name'     => 'Personal',
				'enquiry_source_code'     => 'PERSONAL',
				'default'                 => 0,
				'enquiry_source_priority' => 15,
				'company_id'              => 1,
				'created_at'              => date('Y-m-d H:i:s'),
				'updated_at'              => date('Y-m-d H:i:s'),
            ],
            [
				'enquiry_source_name'     => 'Signboard',
				'enquiry_source_code'     => 'SIGNBOARD',
				'default'                 => 0,
				'enquiry_source_priority' => 16,
				'company_id'              => 1,
				'created_at'              => date('Y-m-d H:i:s'),
				'updated_at'              => date('Y-m-d H:i:s'),
            ],
            [
				'enquiry_source_name'     => 'Telecalling',
				'enquiry_source_code'     => 'TELECALLING',
				'default'                 => 0,
				'enquiry_source_priority' => 17,
				'company_id'              => 1,
				'created_at'              => date('Y-m-d H:i:s'),
				'updated_at'              => date('Y-m-d H:i:s'),
            ],
            [
				'enquiry_source_name'     => 'Telegram',
				'enquiry_source_code'     => 'TELEGRAM',
				'default'                 => 0,
				'enquiry_source_priority' => 18,
				'company_id'              => 1,
				'created_at'              => date('Y-m-d H:i:s'),
				'updated_at'              => date('Y-m-d H:i:s'),
            ],
            [
				'enquiry_source_name'     => 'Trade India',
				'enquiry_source_code'     => 'TRADE INDIA',
				'default'                 => 0,
				'enquiry_source_priority' => 19,
				'company_id'              => 1,
				'created_at'              => date('Y-m-d H:i:s'),
				'updated_at'              => date('Y-m-d H:i:s'),
            ],
            [
				'enquiry_source_name'     => 'TV-Add',
				'enquiry_source_code'     => 'TV-ADD',
				'default'                 => 0,
				'enquiry_source_priority' => 20,
				'company_id'              => 1,
				'created_at'              => date('Y-m-d H:i:s'),
				'updated_at'              => date('Y-m-d H:i:s'),
            ],
            [
				'enquiry_source_name'     => 'Twitter',
				'enquiry_source_code'     => 'TWITTER',
				'default'                 => 0,
				'enquiry_source_priority' => 21,
				'company_id'              => 1,
				'created_at'              => date('Y-m-d H:i:s'),
				'updated_at'              => date('Y-m-d H:i:s'),
            ],
            [
				'enquiry_source_name'     => 'Whatsapp',
				'enquiry_source_code'     => 'WHATSAPP',
				'default'                 => 0,
				'enquiry_source_priority' => 22,
				'company_id'              => 1,
				'created_at'              => date('Y-m-d H:i:s'),
				'updated_at'              => date('Y-m-d H:i:s'),
            ],
            [
				'enquiry_source_name'     => 'Youtube',
				'enquiry_source_code'     => 'YOUTUBE',
				'default'                 => 0,
				'enquiry_source_priority' => 23,
				'company_id'              => 1,
				'created_at'              => date('Y-m-d H:i:s'),
				'updated_at'              => date('Y-m-d H:i:s'),
            ],
			[
				'enquiry_source_name'     => 'Website',
				'enquiry_source_code'     => 'WEBSITE',
				'default'                 => 0,
				'enquiry_source_priority' => 24,
				'company_id'              => 1,
				'created_at'              => date('Y-m-d H:i:s'),
				'updated_at'              => date('Y-m-d H:i:s'),
            ],
        ];

        // EnquirySource::insert($enquiry_sources);
        foreach ($enquiry_sources as $data) {
            EnquirySource::firstOrCreate(
                ['enquiry_source_code' => $data['enquiry_source_code']],
                $data
            );
        }
    }
}
