<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\EnquiryStatus;

class EnquiryStatusTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $enquiry_status = [
            [
                'enquiry_status_name'          => 'Pending',
                'code'                         => 'PENDING',
                'enquiry_status_description'   => '',
                'enquiry_status_priority'      => 1,
                'status'                       => 1,
                'company_id'                   => 1,
                'additional3'                  => '',
                'color'                        => '#FFFFFF',
                'bg_color'                     => '#000000',
                'default'                      => 1,
                'created_at'                   => date('Y-m-d H:i:s'),
                'updated_at'                   => date('Y-m-d H:i:s'),
            ],
            [
                'enquiry_status_name'          => 'Qualified',
                'code'                         => 'QUALIFIED',
                'enquiry_status_description'   => '',
                'enquiry_status_priority'      => 2,
                'status'                       => 1,
                'company_id'                   => 1,
                'additional3'                  => '',
                'color'                        => '#FFFFFF',
                'bg_color'                     => '#000000',
                'default'                      => 0,
                'created_at'                   => date('Y-m-d H:i:s'),
                'updated_at'                   => date('Y-m-d H:i:s'),
            ],
            [
                'enquiry_status_name'          => 'Processing',
                'code'                         => 'PROCESSING',
                'enquiry_status_description'   => '',
                'enquiry_status_priority'      => 3,
                'status'                       => 1,
                'company_id'                   => 1,
                'additional3'                  => '',
                'color'                        => '#FFFFFF',
                'bg_color'                     => '#000000',
                'default'                      => 0,
                'created_at'                   => date('Y-m-d H:i:s'),
                'updated_at'                   => date('Y-m-d H:i:s'),
            ],
            [
                'enquiry_status_name'          => 'Hold',
                'code'                         => 'HOLD',
                'enquiry_status_description'   => '',
                'enquiry_status_priority'      => 4,
                'status'                       => 1,
                'company_id'                   => 1,
                'additional3'                  => '',
                'color'                        => '#FFFFFF',
                'bg_color'                     => '#000000',
                'default'                      => 0,
                'created_at'                   => date('Y-m-d H:i:s'),
                'updated_at'                   => date('Y-m-d H:i:s'),
            ],
            [
                'enquiry_status_name'          => 'Win',
                'code'                         => 'WIN',
                'enquiry_status_description'   => '',
                'enquiry_status_priority'      => 5,
                'status'                       => 1,
                'company_id'                   => 1,
                'additional3'                  => '',
                'color'                        => '#FFFFFF',
                'bg_color'                     => '#000000',
                'default'                      => 0,
                'created_at'                   => date('Y-m-d H:i:s'),
                'updated_at'                   => date('Y-m-d H:i:s'),
            ],
            [
                'enquiry_status_name'          => 'Lost',
                'code'                         => 'LOST',
                'enquiry_status_description'   => '',
                'enquiry_status_priority'      => 6,
                'status'                       => 1,
                'company_id'                   => 1,
                'additional3'                  => '',
                'color'                        => '#FFFFFF',
                'bg_color'                     => '#000000',
                'default'                      => 0,
                'created_at'                   => date('Y-m-d H:i:s'),
                'updated_at'                   => date('Y-m-d H:i:s'),
            ],
        ];
        foreach ($enquiry_status as $data) {
            EnquiryStatus::firstOrCreate(
                ['code' => $data['code']],
                $data
            );
        }
    }
}
