<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\EWayBillError;

class EwayBillApiErrorsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $EWayBillError = [
            [
                'error_code' => '100',
                'description' => 'Invalid Json',
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'error_code' => '101',
                'description' => 'Invalid Username',
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'error_code' => '102',
                'description' => 'Invalid Password',
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'error_code' => '104',
                'description' => 'Invalid Client -Id',
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'error_code' => '105',
                'description' => 'Invalid Token',
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'error_code' => '106',
                'description' => 'Token Expired',
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'error_code' => '107',
                'description' => 'Authentication failed. Pls. inform the helpdesk',
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'error_code' => '108',
                'description' => 'Invalid login credentials.',
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'error_code' => '109',
                'description' => 'Decryption of data failed',
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'error_code' => '110',
                'description' => 'Invalid Client-ID/Client-Secret',
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'error_code' => '111',
                'description' => 'GSTIN is not registered to this GSP',
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'error_code' => '112',
                'description' => 'IMEI does not belong to the user',
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'error_code' => '113',
                'description' => 'os-type is mandatory in header',
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'error_code' => '114',
                'description' => 'Invalid os-type parameter value',
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'error_code' => '201',
                'description' => 'Invalid Supply Type',
                'created_at'   => date('Y-m-d H:i:s'),
                'updated_at'   => date('Y-m-d H:i:s')
            ],
            [
                'error_code' => '202',
                'description' => 'Invalid Sub-supply Type',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '203',
                'description' => 'Sub-transaction type does not belong to transaction type',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '204',
                'description' => 'Invalid Document type',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '205',
                'description' => 'Document type does not match with transaction & Sub trans type',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '206',
                'description' => 'Invalid Invoice Number',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '207',
                'description' => 'Invalid Invoice Date',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '208',
                'description' => 'Invalid Supplier GSTIN',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '209',
                'description' => 'Blank Supplier Address',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '210',
                'description' => 'Invalid or Blank Supplier PIN Code',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '211',
                'description' => 'Invalid or Blank Supplier State Code',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '212',
                'description' => 'Invalid Consignee GSTIN',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '213',
                'description' => 'Invalid Consignee Address',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '214',
                'description' => 'Invalid Consignee PIN Code',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '215',
                'description' => 'Invalid Consignee State Code',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '216',
                'description' => 'Invalid HSN Code',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '217',
                'description' => 'Invalid UQC Code',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '218',
                'description' => 'Invalid Tax Rate for Intra State Transaction',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '219',
                'description' => 'Invalid Tax Rate for Inter State Transaction',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '220',
                'description' => 'Invalid Trans mode',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '221',
                'description' => 'Invalid Approximate Distance',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '222',
                'description' => 'Invalid Transporter Id',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '223',
                'description' => 'Invalid Transaction Document Number',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '224',
                'description' => 'Invalid Transaction Date',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '225',
                'description' => 'Invalid Vehicle Number Format',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '226',
                'description' => 'Both Transaction and Vehicle Number Blank',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '227',
                'description' => 'User GSTIN cannot be blank',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '228',
                'description' => 'User ID cannot be blank',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '229',
                'description' => 'Supplier name is required',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '230',
                'description' => 'Supplier place is required',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '231',
                'description' => 'Consignee name is required',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '232',
                'description' => 'Consignee place is required',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '233',
                'description' => 'Eway bill does not contain any items',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '234',
                'description' => 'Total amount/Taxable amount is mandatory',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '235',
                'description' => 'Tax rates for Intra state transaction is blank',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '236',
                'description' => 'Tax rates for Inter state transaction is blank',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '237',
                'description' => 'Invalid client -Id/client-secret',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '238',
                'description' => 'Invalid auth token',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '239',
                'description' => 'Invalid action',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '240',
                'description' => 'Could not generate eway bill, pls contact helpdesk',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '242',
                'description' => 'Invalid or Blank Officer StateCode',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '243',
                'description' => 'Invalid or Blank IR Number',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '244',
                'description' => 'Invalid or Blank Actual Vehicle Number Format',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '245',
                'description' => 'Invalid Verification Date Format',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '246',
                'description' => 'Invalid Vehicle Release Date Format',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '247',
                'description' => 'Invalid Verification Time Format',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '248',
                'description' => 'Invalid Vehicle Release Date Format',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '249',
                'description' => 'Actual Value cannot be less than or equal to zero',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '250',
                'description' => 'Invalid Vehicle Release Date Format',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '251',
                'description' => 'CGST and SGST TaxRate should be the same',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '252',
                'description' => 'Invalid CGST Tax Rate',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '253',
                'description' => 'Invalid SGST Tax Rate',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '254',
                'description' => 'Invalid IGST Tax Rate',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '255',
                'description' => 'Invalid CESS Rate',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '256',
                'description' => 'Invalid Cess Non Advol value',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '278',
                'description' => 'User GSTIN does not match with Transporter Id',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '280',
                'description' => 'Status is not ACTIVE',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '281',
                'description' => 'Eway Bill is already expired hence updating transporter is not allowed',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '301',
                'description' => 'Invalid eway bill number',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '302',
                'description' => 'Invalid transporter mode',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '303',
                'description' => 'Vehicle number is required',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '304',
                'description' => 'Invalid vehicle format',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '305',
                'description' => 'Place from is required',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '306',
                'description' => 'Invalid from state',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '307',
                'description' => 'Invalid reason',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '308',
                'description' => 'Invalid remarks',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '309',
                'description' => 'Could not update vehicle details, please contact helpdesk',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '311',
                'description' => 'Validity period lapsed, you cannot update vehicle details',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '312',
                'description' => 'This eway bill is either not generated by you or cancelled',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '313',
                'description' => 'Error in validating eway bill for vehicle updation',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '315',
                'description' => 'Validity period lapsed, you cannot cancel this eway bill',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '316',
                'description' => 'Eway bill is already verified, you cannot cancel it',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '317',
                'description' => 'Could not cancel eway bill, please contact helpdesk',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '320',
                'description' => 'Invalid state to',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '321',
                'description' => 'Invalid place to',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '322',
                'description' => 'Could not generate consolidated eway bill',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '325',
                'description' => 'Could not retrieve data',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '326',
                'description' => 'Could not retrieve GSTIN details for the given GSTIN number',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '327',
                'description' => 'Could not retrieve data from HSN',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '328',
                'description' => 'Could not retrieve transporter details from GSTIN',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '329',
                'description' => 'Could not retrieve States List',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '330',
                'description' => 'Could not retrieve UQC list',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '331',
                'description' => 'Could not retrieve Error code',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '334',
                'description' => 'Could not retrieve user details by userid',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '336',
                'description' => 'Could not retrieve transporter data by gstin',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '337',
                'description' => 'Could not retrieve HSN details for the given HSN number',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '338',
                'description' => 'You cannot update transporter details, as the current transporter has already entered Part B details of the e-way bill',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '339',
                'description' => 'You are not assigned to update the transporter details of this e-way bill',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '341',
                'description' => 'This e-way bill is generated by you and hence you cannot reject it',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '342',
                'description' => 'You cannot reject this e-way bill as you are not the other party to do so',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '343',
                'description' => 'This e-way bill is cancelled',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '344',
                'description' => 'Invalid e-way bill number',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '345',
                'description' => 'Validity period lapsed, you cannot reject the e-way bill',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '346',
                'description' => 'You can reject the e-way bill only within 72 hours from the generated time',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '347',
                'description' => 'Validation of e-way bill number failed while rejecting the e-way bill',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '348',
                'description' => 'Part-B is not generated for this e-way bill, hence rejection is not allowed',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '350',
                'description' => 'Could not generate consolidated e-way bill',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '351',
                'description' => 'Invalid state code',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '352',
                'description' => 'Invalid RFID date',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '353',
                'description' => 'Invalid location code',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '354',
                'description' => 'Invalid RFID number',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '355',
                'description' => 'Invalid Vehicle Number Format',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '356',
                'description' => 'Invalid weight on bridge',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '357',
                'description' => 'Could not retrieve e-way bill details, please contact helpdesk',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '358',
                'description' => 'GSTIN passed in request header does not match with the user GSTIN mentioned in payload JSON',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '359',
                'description' => 'User GSTIN should match to GSTIN (from) for outward transactions',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '360',
                'description' => 'User GSTIN should match to GSTIN (to) for inward transactions',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '361',
                'description' => 'Invalid Vehicle Type',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '362',
                'description' => 'Transporter document date cannot be earlier than the invoice date',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '363',
                'description' => 'E-way bill is not enabled for intra-state movement in your state',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '364',
                'description' => 'Error in verifying e-way bill',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '365',
                'description' => 'Error in verifying consolidated e-way bill',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '366',
                'description' => 'You will not get the e-way bills generated today; however, you can access the e-way bills of yesterdays',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '367',
                'description' => 'Could not retrieve data for officer login',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '368',
                'description' => 'Could not update transporter',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '369',
                'description' => 'GSTIN/Transin passed in request header should match with the transported Id mentioned in payload JSON',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '370',
                'description' => 'GSTIN/Transin passed in request header should not be the same as supplier(fromGSTIN) or recipient(toGSTIN)',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '371',
                'description' => 'Invalid or Blank Supplier Ship-to State Code',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '372',
                'description' => 'Invalid or Blank Consignee Ship-to State Code',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '373',
                'description' => 'The Supplier ship-to state code should be Other Country for Sub Supply Type- Export',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '374',
                'description' => 'The Consignee pin code should be 999999 for Sub Supply Type- Export',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '375',
                'description' => 'The Supplier ship-from state code should be Other Country for Sub Supply Type- Import',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '376',
                'description' => 'The Supplier pin code should be 999999 for Sub Supply Type- Import',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '377',
                'description' => 'Sub Supply Type is mentioned as Others, the description for that is mandatory',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '378',
                'description' => 'The supplier or consignee belongs to SEZ, Inter state tax rates are applicable here',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '379',
                'description' => 'Eway Bill cannot be extended. Already Cancelled',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '380',
                'description' => 'Eway Bill cannot be Extended. Not in Active State',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '381',
                'description' => 'There is No PART-B/Vehicle Entry.. So Please Update Vehicle Information',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '382',
                'description' => 'You Cannot Extend as EWB can be Extended only 8 hours before or after w.r.t Validity of EWB',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '383',
                'description' => 'Error While Extending. Please Contact Helpdesk',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '384',
                'description' => 'You are not the current transporter or Generator of the eWayBill, with no transporter details',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '385',
                'description' => 'For Rail/Ship/Air transDocDate is mandatory',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '386',
                'description' => 'Reason Code, Remarks is mandatory',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '387',
                'description' => 'No Record Found for Entered consolidated eWay bill',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '388',
                'description' => 'Exception in regeneration of consolidated eWayBill!! Please Contact helpdesk',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '389',
                'description' => 'Remaining Distance Required',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '390',
                'description' => 'Remaining Distance Cannot be greater than Actual Distance',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '391',
                'description' => 'No eWay bill of specified tripsheet, neither ACTIVE nor valid',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '392',
                'description' => 'Tripsheet is already cancelled, Hence Regeneration is not possible',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '393',
                'description' => 'Invalid GSTIN',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '394',
                'description' => 'For other than Road Transport, TransDoc number is required',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '395',
                'description' => 'Eway Bill Number should be numeric only',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '396',
                'description' => 'Either Eway Bill Number Or Consolidated Eway Bill Number is required for Verification',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '397',
                'description' => 'Error in Multi Vehicle Movement Initiation',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '398',
                'description' => 'Eway Bill Item List is Empty',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '399',
                'description' => 'Unit Code is not matching with any of the Unit Code from Item List',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '400',
                'description' => 'Total quantity is exceeding from multi vehicle movement initiation quantity',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '401',
                'description' => 'Error in inserting multi vehicle details',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '402',
                'description' => 'Total quantity cannot be less than or equal to zero',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '403',
                'description' => 'Error in multi vehicle details',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '405',
                'description' => 'No record found for multi vehicle update with specified ewbNo groupNo and old vehicleNo/transDocNo with status as ACT',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '406',
                'description' => 'Group number cannot be empty or zero',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '407',
                'description' => 'Invalid old vehicle number format',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '408',
                'description' => 'Invalid new vehicle number format',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '409',
                'description' => 'Invalid old transDoc number',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '410',
                'description' => 'Invalid new transDoc number',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '411',
                'description' => 'Multi Vehicle Initiation data is not there for specified ewayBill and group No',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '412',
                'description' => 'Multi Vehicle movement is already Initiated, hence PART B updation not allowed',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '413',
                'description' => 'Unit Code is not matching with the unit code of the first initiation',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '415',
                'description' => 'Error in fetching in verification data for officer',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '416',
                'description' => 'Date range is exceeding allowed date range',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '417',
                'description' => 'No verification data found for officer',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '418',
                'description' => 'No record found',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '419',
                'description' => 'Error in fetching search result for taxpayer/transporter',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '420',
                'description' => 'Minimum six characters required for Tradename/legalname search',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '421',
                'description' => 'Invalid pincode',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '422',
                'description' => 'Invalid mobile number',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '423',
                'description' => 'Error in fetching ewaybill list by vehicle number',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '424',
                'description' => 'Invalid PAN number',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '425',
                'description' => 'Error in fetching Part A data by IR Number',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '426',
                'description' => 'For Vehicle Released vehicle release date and time is mandatory',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '427',
                'description' => 'Error in saving Part-A verification Report',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '428',
                'description' => 'For Goods Detained, Vehicle Released field is mandatory',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '429',
                'description' => 'Error in saving Part-B verification Report',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '430',
                'description' => 'Goods Detained Field required',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '431',
                'description' => 'Part-A for this ewaybill is already generated by you',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '432',
                'description' => 'Invalid vehicle released value',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '433',
                'description' => 'Invalid goods detained parameter value',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '434',
                'description' => 'Invalid ewbNoAvailable parameter value',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '435',
                'description' => 'Part B is already updated, hence updation is not allowed',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '436',
                'description' => 'Invalid Consignee ship to State Code for the given pincode',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '437',
                'description' => 'Invalid Supplier ship from State Code for the given pincode',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '438',
                'description' => 'Invalid Latitude',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '439',
                'description' => 'Invalid Longitude',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '440',
                'description' => 'Error in inserting verification data',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '441',
                'description' => 'Invalid verification type',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '442',
                'description' => 'Error in inserting verification details',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '443',
                'description' => 'Invalid invoice available value',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '600',
                'description' => 'Invalid category',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '601',
                'description' => 'Invalid date format',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '602',
                'description' => 'Invalid File Number',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '603',
                'description' => 'For file details, file number is required',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '604',
                'description' => 'E-way bill(s) are already generated for the same document number, you cannot generate again on the same document number',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '607',
                'description' => 'dispatch from gstin is mandatory',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '608',
                'description' => 'ship to from gstin is mandatory',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '609',
                'description' => 'invalid ship to from gstin',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '610',
                'description' => 'invalid dispatch from gstin',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '611',
                'description' => 'Invalid document type for the given supply type',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '612',
                'description' => 'Invalid transaction type',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '613',
                'description' => 'Exception in getting Officer Role',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '614',
                'description' => 'Transaction type is mandatory',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '615',
                'description' => 'Dispatch From GSTIN cannot be sent as the transaction type selected is Regular',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '616',
                'description' => 'Ship to GSTIN cannot be sent as the transaction type selected is Regular',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '617',
                'description' => 'Bill-from and dispatch-from gstin should not be the same for this transaction type',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '618',
                'description' => 'Bill-to and ship-to gstin should not be the same for this transaction type',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '619',
                'description' => 'Transporter Id is mandatory for the generation of Part A slip',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '620',
                'description' => 'Total invoice value cannot be less than the sum of total assessable value and tax values',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '621',
                'description' => 'Trans mode is mandatory since the vehicle number is present',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '622',
                'description' => 'Trans mode is mandatory since the trans doc number is present',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '623',
                'description' => 'IGST value is not applicable for Intra State Transaction',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '624',
                'description' => 'SGST/CGST value is not applicable for Inter State Transaction',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '627',
                'description' => 'Total value should not be negative',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '628',
                'description' => 'Total invoice value should not be negative',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '629',
                'description' => 'IGST value should not be negative',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '630',
                'description' => 'CGST value should not be negative',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '631',
                'description' => 'SGST value should not be negative',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '632',
                'description' => 'Cess value should not be negative',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '633',
                'description' => 'Cess non advol should not be negative',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '634',
                'description' => 'Vehicle type should not be ODC when transmode is other than road',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '635',
                'description' => 'You cannot update part B, as the current transporter is already entered Part B details of the eway bill',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '636',
                'description' => 'You are not assigned to update part B',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '637',
                'description' => 'You cannot extend ewaybill, as the current transporter is already entered Part B details of the ewaybill',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '638',
                'description' => 'Transport mode is mandatory as Vehicle Number/Transport Document Number is given',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '640',
                'description' => 'Total Invoice Value is mandatory',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '641',
                'description' => 'For outward CKD/SKD/Lots supply type, Bill To state should be as Other Country, since the Bill To GSTIN given is of SEZ unit',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '642',
                'description' => 'For inward CKD/SKD/Lots supply type, Bill From state should be as Other Country, since the Bill From GSTIN given is of SEZ unit',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '643',
                'description' => 'For regular transaction, Bill from state code and Dispatch from state code should be the same',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '644',
                'description' => 'For regular transaction, Bill to state code and Ship to state code should be the same',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '645',
                'description' => 'You cannot do Multi Vehicle movement, as the current transporter already entered part B',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '646',
                'description' => 'You are not assigned to do multi vehicle movement',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '647',
                'description' => 'Could not insert RFID data, pl. contact helpdesk',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '648',
                'description' => 'Multi Vehicle movement is already Initiated, hence generation of consolidated eway bill is not allowed',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '649',
                'description' => 'You cannot generate consolidated eway bill, as the current transporter is already entered Part B details of the eway bill',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '650',
                'description' => 'You are not assigned to generate consolidated ewaybill',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '651',
                'description' => 'For Category Part-A or Part-B ewbdt is mandatory',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '652',
                'description' => 'For Category EWB03 procdt is mandatory',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '654',
                'description' => 'This GSTIN has generated a common Enrolment Number. Hence you are not allowed to generate Eway bill',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '655',
                'description' => 'This GSTIN has generated a common Enrolment Number. Hence you cannot mention it as a transporter',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '656',
                'description' => 'This Eway Bill does not belong to your state',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '657',
                'description' => 'Eway Bill Category wise details will be available after 4 days only',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '658',
                'description' => 'You are blocked for accessing this API as the allowed number of requests has been exceeded for this duration',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '659',
                'description' => 'Remarks is mandatory',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '670',
                'description' => 'Invalid Month Parameter',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '671',
                'description' => 'Invalid Year Parameter',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '672',
                'description' => 'User Id is mandatory',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '673',
                'description' => 'Error in getting officer dashboard',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '675',
                'description' => 'Error in getting EWB03 details by acknowledgement date range',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '676',
                'description' => 'Error in getting EWB Not Available List by entered date range',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '677',
                'description' => 'Error in getting EWB Not Available List by closed date range',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '678',
                'description' => 'Invalid Uniq No',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '679',
                'description' => 'Invalid EWB03 Ack No',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '680',
                'description' => 'Invalid Close Reason',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '681',
                'description' => 'Error in Closing EWB Verification Data',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '682',
                'description' => 'No Record available to Close',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '683',
                'description' => 'Error in fetching WatchList Data',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '685',
                'description' => 'Exception in fetching dashboard data',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '700',
                'description' => 'You are not assigned to extend e-waybill',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '701',
                'description' => 'Invalid Vehicle Direction',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '702',
                'description' => 'The distance between the pincodes given is too high',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '703',
                'description' => 'Since the consignor is Composite Taxpayer, inter state transactions are not allowed',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '704',
                'description' => 'Since the consignor is Composite Taxpayer, Tax rates should be zero',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '705',
                'description' => 'Invalid transit type',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '706',
                'description' => 'Address Line1 is mandatory',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '707',
                'description' => 'Address Line2 is mandatory',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '708',
                'description' => 'Address Line3 is mandatory',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '709',
                'description' => 'Pin to pin distance is not available for the given pin codes',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '710',
                'description' => 'Invalid state code for the given pincode',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '711',
                'description' => 'Invalid value for isInTransit field',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '712',
                'description' => 'Transit Type is not required as the goods are not in movement',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '713',
                'description' => 'Transit Address is not required as the goods are not in movement',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '714',
                'description' => 'Document type - Tax Invoice is not allowed for composite tax payer',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '715',
                'description' => 'The Consignor GSTIN is blocked from e-waybill generation as Return is not filed for the past 2 months',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '716',
                'description' => 'The Consignee GSTIN is blocked from e-waybill generation as Return is not filed for the past 2 months',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '717',
                'description' => 'The Transporter GSTIN is blocked from e-waybill generation as Return is not filed for the past 2 months',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '718',
                'description' => 'The User GSTIN is blocked from Transporter Updation as Return is not filed for the past 2 months',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '719',
                'description' => 'The Transporter GSTIN is blocked from Transporter Updation as Return is not filed for the past 2 months',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '720',
                'description' => 'E Way Bill should be generated as part of IRN generation or with reference to IRN in E Invoice System, Since Supplier is enabled for E Invoice.',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '721',
                'description' => 'The distance between the given pincodes is not available in the system. Please provide distance.',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '722',
                'description' => 'Consignee GSTIN is cancelled and document date is later than the De-Registration date',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '724',
                'description' => 'HSN code of at least one item should be of goods to generate e-Way Bill',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '726',
                'description' => 'Vehicle type cannot be regular when transportation mode is ship',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '727',
                'description' => 'For Ship Transport, either vehicle number or transport document number is required',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '728',
                'description' => 'You can cancel the ewaybill within 24 hours from Part B entry',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '729',
                'description' => 'TransDoc date is required for transport mode Ship as the transport document number is provided',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '813',
                'description' => 'Duplicate request at the same time',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '817',
                'description' => 'MultiVehicleMovement cannot be initiated. Eway Bill is not in Active State',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '818',
                'description' => 'Validity period lapsed. Cannot generate consolidated Eway Bill',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'error_code' => '819',
                'description' => 'Ewaybill cannot be generated for the document date which is prior to 01/07/2017',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
        ];
        foreach ($EWayBillError as $data) {
            EWayBillError::firstOrCreate(
                ['error_code' => $data['error_code']],
                $data
            );
        }
    }
}

