<?php

namespace Database\Seeders;

use App\Models\Floor;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class FloorsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
       $floor = [
            [
                'name'        => 'Ground Floor',
                'code'        => 'GROUND_FLOOR',
                'building_id' => 1,
                'priority'    => 1,
                'created_at'  => now(),
                'updated_at'  => now(),
            ],
            [
                'name'        => 'First Floor',
                'code'        => 'FIRST_FLOOR',
                'building_id' => 1,
                'priority'    => 2,
                'created_at'  => now(),
                'updated_at'  => now(),
            ],
            [
                'name'        => 'Second Floor',
                'code'        => 'SECOND_FLOOR',
                'building_id' => 1,
                'priority'    => 3,
                'created_at'  => now(),
                'updated_at'  => now(),
            ],
            [
                'name'        => 'Third Floor',
                'code'        => 'THIRD_FLOOR',
                'building_id' => 1,
                'priority'    => 4,
                'created_at'  => now(),
                'updated_at'  => now(),
            ],
            [
                'name'        => 'Fourth Floor',
                'code'        => 'FOURTH_FLOOR',
                'building_id' => 1,
                'priority'    => 5,
                'created_at'  => now(),
                'updated_at'  => now(),
            ],
            [
                'name'        => 'Fifth Floor',
                'code'        => 'FIFTH_FLOOR',
                'building_id' => 1,
                'priority'    => 6,
                'created_at'  => now(),
                'updated_at'  => now(),
            ],
        ];
        foreach ($floor as $data) {
            Floor::firstOrCreate(
                ['code' => $data['code']],
                $data
            );
        }
    }
}
