<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\FontFamily;


class FontFamilySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
    	$fonts =
        [
            [
                "font_name" => "Times New Roman, Times, serif",
                "code"      => "TIMES_NEW_ROMAN_TIMES,_SERIF"
            ],
            [
                "font_name" => "Palatino Linotype, Book Antiqua, Palatino, serif",
                "code" => "PALATINO_LINOTYPE_BOOK_ANTIQUA,_PALATINO,_SERIF"
            ],
            [
                "font_name" => "Georgia, serif",
                "code" => "GEORGIA_SERIF"
            ],
            [
                "font_name" => "Lucida Console, Monaco, monospace",
                "code" => "LUCIDA_CONSOLE_MONACO_MONOSPACE"
            ],
            [
                "font_name" => "Courier New, Courier, monospace",
                "code" => "COURIER_NEW_COURIER_MONOSPACE"
            ],
            [
                "font_name" => "Arial, Helvetica, sans-serif",
                "code" => "ARIAL,_HELVETICA,_SANS-SERIF"
            ],
            [
                "font_name" => "Lucida Sans Unicode, Lucida Grande, sans-serif",
                "code" => "LUCIDA_SANS_UNICODE_LUCIDA_GRANDE_SANS-SERIF"
            ],
            [
                "font_name" => "Trebuchet MS, Helvetica, sans-serif",
                "code" => "TREBUCHET_MS_HELVETICA_SANS-SERIF"
            ],
            [
                "font_name" => "Verdana, Geneva, sans-serif",
                "code" => "VERDANA_GENEVA_SANS-SERIF"
            ],
            [
                "font_name" => "Impact, Charcoal, sans-serif",
                "code" => "IMPACT_CHARCOAL_SANS-SERIF"
            ],
            [
                "font_name" => "Arial Black, Gadget, sans-serif",
                "code" => "ARIAL_BLACK_GADGET_SANS-SERIF"
            ],
            [
                "font_name" => "Comic Sans MS, cursive, sans-serif",
                "code" => "COMIC_SANS_MS_CURSIVE_SANS-SERIF"
            ],
            [
                "font_name" => "Tahoma, Geneva, sans-serif",
                "code" => "TAHOMA_GENEVA_SANS-SERIF"
            ]
        ];

        foreach ($fonts as $data) {
            FontFamily::firstOrCreate(
                ['code' => $data['code']],
                $data
            );
        }
    }
}
