<?php

namespace Database\Seeders;

use App\Models\IndustryType;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class IndustryTypeTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $types = [
            [
                'name'       => 'Billing CRM',
                'code'       => 'BILLINGCRM',
                'status'     => 1,
                'is_default' => 1,
                'created_at' => now(),
            ],
            [
                'name'       => 'Health Care',
                'code'       => 'HEALTHCARE',
                'status'     => 1,
                'is_default' => 0,
                'created_at' => now(),
            ],
            [
                'name'       => 'Logistics',
                'code'       => 'LOGISTICS',
                'status'     => 1,
                'is_default' => 0,
                'created_at' => now(),
            ],
            [
                'name'       => 'Education',
                'code'       => 'EDUCATION',
                'status'     => 1,
                'is_default' => 0,
                'created_at' => now(),
            ],
            [
                'name'       => 'CMS',
                'code'       => 'CMS',
                'status'     => 1,
                'is_default' => 0,
                'created_at' => now(),
            ],
        ];

        foreach ($types as $data) {
            IndustryType::firstOrCreate(
                ['code' => $data['code']],
                $data
            );
        }
    }
}
