<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Language;

class LanguageTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $languages = [
            'Ainu',
            'Arabic',
            'Armenian',
            'Avar',
            'Azerbaijani',
            'Bashkir',
            'Bengali',
            'Bulgarian',
            'Burmese',
            'Cantonese',
            'Chechen',
            'Chukchi',
            'Chukot',
            'Chuvash',
            'Dutch',
            'Enets',
            'English',
            'Erzya',
            'Estonian',
            'Even',
            'Evenki',
            'Filipino',
            'Finnish',
            'French',
            'Georgian',
            'German',
            'Greek',
            'Hebrew',
            'Hill Mari',
            'Hindi',
            'Hungarian',
            'Icelandic',
            'Irish',
            'Italian',
            'Itelmen',
            'Japanese',
            'Javanese',
            'Kamchadal',
            'Kannada',
            'Kazakh',
            'Kerek',
            'Khanty',
            'Komi',
            'Komi-Permyak',
            'Korean',
            'Koryak',
            'Kurdish',
            'Kyrgyz',
            'Lao',
            'Latvian',
            'Lezgian',
            'Lithuanian',
            'Maithili',
            'Malay',
            'Malayalam',
            'Mandarin Chinese',
            'Mansi',
            'Marathi',
            'Mari',
            'Meadow Mari',
            'Moksha',
            'Mongolian',
            'Nanai',
            'Negidal',
            'Nenets',
            'Nepali',
            'Nganas',
            'Nganasan',
            'Nivkh',
            'Norwegian',
            'Oriya',
            'Orok',
            'Pashto',
            'Polish',
            'Portuguese',
            'Punjabi',
            'Romanian',
            'Russian',
            'Selkup',
            'Serbian',
            'Sindhi',
            'Slovak',
            'Slovenian',
            'Somali',
            'Spanish',
            'Sundanese',
            'Swahili',
            'Tajik',
            'Tamil',
            'Tatar',
            'Telugu',
            'Thai',
            'Tibetan',
            'Turkish',
            'Turkmen',
            'Udege',
            'Udmurt',
            'Uighur',
            'Ukrainian',
            'Ulch',
            'Urdu',
            'Uzbek',
            'Vietnamese',
            'Yoruba',
            'Yukaghir'
        ];

        foreach ($languages as $data) {
            Language::firstOrCreate(
                ['name' => $data]
            );
        }
    }
}

