<?php

namespace Database\Seeders;

use App\Models\LibrarySetting\LibrarianGernes;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class LibraryCategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */

    public function run()
    {
        // if (\App::environment('local')) {
        //     LibrarianGernes::truncate();
        // }

        $Category = [
            [
                'name'            => 'Book',
                'code'            => 'BOOK',
                'isfeatured'      => '1',
                'status'          => '1',
                'website_view'    => '1',
            ],
            [
                'name'            => 'Magazine',
                'code'            => 'MAGAZINE',
                'isfeatured'      => '1',
                'status'          => '1',
                'website_view'    => '1',
            ],
            [
                'name'            => 'Computer Science',
                'code'            => 'COMPUTER_SCIENCE',
                'isfeatured'      => '1',
                'status'          => '1',
                'website_view'    => '1',
            ],
            [
                'name'            => 'Philosophy and Psychology',
                'code'            => 'PHILOSOPHY_AND_PSYCHOLOGY',
                'isfeatured'      => '1',
                'status'          => '1',
                'website_view'    => '1',
            ],
            [
                'name'            => 'Social Science',
                'code'            => 'SOCIAL_SCIENCE',
                'isfeatured'      => '1',
                'status'          => '1',
                'website_view'    => '1',
            ],
            [
                'name'            => 'Language',
                'code'            => 'LANGUAGE',
                'isfeatured'      => '1',
                'status'          => '1',
                'website_view'    => '1',
            ],
            [
                'name'            => 'Science',
                'code'            => 'SCIENCE',
                'isfeatured'      => '1',
                'status'          => '1',
                'website_view'    => '1',
            ],
            [
                'name'            => 'Technology',
                'code'            => 'TECHNOLOGY',
                'isfeatured'      => '1',
                'status'          => '1',
                'website_view'    => '1',
            ],
            [
                'name'            => 'Arts and Recreation',
                'code'            => 'ARTS_AND_RECREATION',
                'isfeatured'      => '1',
                'status'          => '1',
                'website_view'    => '1',
            ],
            [
                'name'            => 'Literature',
                'code'            => 'LITERATURE',
                'isfeatured'      => '1',
                'status'          => '1',
                'website_view'    => '1',
            ],
            [
                'name'            => 'History and Geography',
                'code'            => 'HISTORY_AND_GEOGRAPHY',
                'isfeatured'      => '1',
                'status'          => '1',
                'website_view'    => '1',
            ],
            [
                'name'            => 'Business',
                'code'            => 'BUSINESS',
                'isfeatured'      => '1',
                'status'          => '1',
                'website_view'    => '1',
            ],
            [
                'name'            => 'Architecture',
                'code'            => 'ARCHITECTURE',
                'isfeatured'      => '1',
                'status'          => '1',
                'website_view'    => '1',
            ],
            [
                'name'            => 'N/A',
                'code'            => 'NA',
                'isfeatured'      => '1',
                'status'          => '1',
                'website_view'    => '1',
            ],
        ];

        foreach ($Category as $data) {
            LibrarianGernes::firstOrCreate(
                ['code' => $data['code']],
                $data
            );
        }
    }
}

