<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\MasterSetting;
use App\Models\AdvanceSetting;

class MasterSettingsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        /**
         * Reset the countries table
         */
        // if (\App::environment('local')) {
        //     MasterSetting::truncate();
        //     AdvanceSetting::truncate();
        // }

        $settings = [
            [
                'field'          => 'Decimal Point',
                'code'           => 'decimal_point',
                'type'           => 'text',
                'is_readonly'    => '0',
                'default_value'  => '2',
                'status'         => '1',
                'is_mandatory'   => '1',
                'select_options' => NULL,
                'remarks'        => NULL,
            ],
            [
                'field'          => 'Doctor Signature Print Setting',
                'code'           => 'doctor_signature_print_setting',
                'type'           => 'select',
                'is_readonly'    => '0',
                'default_value'  => 'Department',
                'status'         => '1',
                'is_mandatory'   => '0',
                'select_options' => 'Department,Reviewed-Doctor',
                'remarks'        => NULL,
            ],
            [
                'field'          => 'Technician Signature Print Setting',
                'code'           => 'technician_signature_print_setting',
                'type'           => 'select',
                'is_readonly'    => '0',
                'default_value'  => 'Department',
                'status'         => '1',
                'is_mandatory'   => '0',
                'select_options' => 'Department,Update-By',
                'remarks'        => NULL,
            ],
            [
                'field'          => 'Print report with letter head',
                'code'           => 'print_report_with_letter_head',
                'type'           => 'select',
                'is_readonly'    => '0',
                'default_value'  => 'no',
                'status'         => '1',
                'is_mandatory'   => '0',
                'select_options' => 'no,yes',
                'remarks'        => NULL,
            ],
            [
                'field'          => 'Add page break after every department',
                'code'           => 'add_page_break_after_every_department',
                'type'           => 'select',
                'is_readonly'    => '0',
                'default_value'  => 'yes',
                'status'         => '1',
                'is_mandatory'   => '0',
                'select_options' => 'no,yes',
                'remarks'        => NULL,
            ],
            [
                'field'          => 'Show Flag in Lab Billing',
                'code'           => 'show_flag_in_lab_billing',
                'type'           => 'select',
                'is_readonly'    => '0',
                'default_value'  => 'no',
                'status'         => '1',
                'is_mandatory'   => '0',
                'select_options' => 'no,yes',
                'remarks'        => NULL,
            ],
            [
                'field'          => 'Print Bill with logo',
                'code'           => 'PRINT_BILL_WITH_LOGO',
                'type'           => 'select',
                'is_readonly'    => '0',
                'default_value'  => 'yes',
                'status'         => '1',
                'is_mandatory'   => '0',
                'select_options' => 'no,yes',
                'remarks'        => 'LOGO WILL DISPLAY IN INVOICE IF YOU SELECT YES',
            ],
            [
                'field'          => 'Special coupon discount',
                'code'           => 'SPECIAL_COUPON_DISCOUNT',
                'type'           => 'text',
                'is_readonly'    => '0',
                'default_value'  => '2',
                'status'         => '1',
                'is_mandatory'   => '1',
                'select_options' => NULL,
                'remarks'        => 'Please Keep this Zero If You Do Not Give Any Special Coupon Discount.',
            ],
            [
                'field'          => 'Show delivery time on bill',
                'code'           => 'SHOW_DELIVERY_TIME_ON_BILL',
                'type'           => 'select',
                'is_readonly'    => '0',
                'default_value'  => 'yes',
                'status'         => '1',
                'is_mandatory'   => '0',
                'select_options' => 'no,yes',
                'remarks'        => 'By Default Yes.',
            ],
            [
                'field'          => 'Show delivery date on report',
                'code'           => 'SHOW_DELIVERY_DATE_ON_REPORT',
                'type'           => 'select',
                'is_readonly'    => '0',
                'default_value'  => 'yes',
                'status'         => '1',
                'is_mandatory'   => '0',
                'select_options' => 'no,yes',
                'remarks'        => 'YES: Report Delivery Date Will Display in Report',
            ],
            [
                'field'          => 'Test result update work flow',
                'code'           => 'TEST_RESULT_UPDATE_WORK_FLOW',
                'type'           => 'select',
                'is_readonly'    => '0',
                'default_value'  => 'DIRECTPRINT',
                'status'         => '1',
                'is_mandatory'   => '0',
                'select_options' => 'DIRECTPRINT,BACKTOTEST,ASKQUESTION',
                'remarks'        => 'DIRECTPRINT, BACKTOTEST, ASKQUESTION',
            ],
            [
                'field'          => 'Show billing remarks',
                'code'           => 'SHOW_BILLING_REMARKS',
                'type'           => 'select',
                'is_readonly'    => '0',
                'default_value'  => 'yes',
                'status'         => '1',
                'is_mandatory'   => '0',
                'select_options' => 'no,yes',
                'remarks'        => 'SHOW_BILLING_REMARKS on Invoice',
            ],
            [
                'field'          => 'Show billing remarks',
                'code'           => 'STATIC_BILLING_REMARKS',
                'type'           => 'text',
                'is_readonly'    => '0',
                'default_value'  => 'NOTE: ONCE PAID THE ( ADVANCE/ BOOKING) AMOUNT IS NON REFUNDABLE',
                'status'         => '1',
                'is_mandatory'   => '0',
                'select_options' => NULL,
                'remarks'        => 'Note: Non Refundable',
            ],
            [
                'field'          => 'Capitalize names',
                'code'           => 'CAPAITALIZE_NAMES',
                'type'           => 'select',
                'is_readonly'    => '0',
                'default_value'  => 'yes',
                'status'         => '1',
                'is_mandatory'   => '0',
                'select_options' => 'no,yes',
                'remarks'        => NULL,
            ],
            /*[
                'field'          => 'User limit',
                'code'           => 'USER_LIMIT',
                'type'           => 'text',
                'is_readonly'    => '0',
                'default_value'  => '15',
                'status'         => '1',
                'is_mandatory'   => '0',
                'select_options' => NULL,
                'remarks'        => NULL,
            ],*/
            [
                'field'          => 'Show report ending line',
                'code'           => 'SHOW_REPORT_ENDING_LINE',
                'type'           => 'select',
                'is_readonly'    => '0',
                'default_value'  => 'no',
                'status'         => '1',
                'is_mandatory'   => '0',
                'select_options' => 'no,yes',
                'remarks'        => NULL,
            ],
            [
                'field'          => 'Show page number',
                'code'           => 'SHOW_PAGE_NUMBER',
                'type'           => 'select',
                'is_readonly'    => '0',
                'default_value'  => 'no',
                'status'         => '1',
                'is_mandatory'   => '0',
                'select_options' => 'no,yes',
                'remarks'        => NULL,
            ],
            [
                'field'          => 'Show sample name',
                'code'           => 'SHOW_SAMPLE_NAME',
                'type'           => 'select',
                'is_readonly'    => '0',
                'default_value'  => 'no',
                'status'         => '1',
                'is_mandatory'   => '0',
                'select_options' => 'no,yes',
                'remarks'        => 'SHOW SAMPLE NAME AFTER TEST PERAMETER',
            ],
            [
                'field'          => 'Dynamic signature',
                'code'           => 'DYNAMIC_SIGNATURE',
                'type'           => 'select',
                'is_readonly'    => '0',
                'default_value'  => 'yes',
                'status'         => '1',
                'is_mandatory'   => '0',
                'select_options' => 'no,yes',
                'remarks'        => NULL,
            ],
            /*[
                'field'          => 'License alert days before',
                'code'           => 'LICENSE_ALERT_DAYS_BEFORE',
                'type'           => 'text',
                'is_readonly'    => '0',
                'default_value'  => '15',
                'status'         => '1',
                'is_mandatory'   => '0',
                'select_options' => NULL,
                'remarks'        => NULL,
            ],*/
            /*[
                'field'          => 'Appointment charges collection',
                'code'           => 'APPOINTMENT_CHARGES_COLLECTION',
                'type'           => 'select',
                'is_readonly'    => '0',
                'default_value'  => 'no',
                'status'         => '1',
                'is_mandatory'   => '0',
                'select_options' => 'no,yes',
                'remarks'        => NULL,
            ],*/
            /*[
                'field'          => 'Digital report on top',
                'code'           => 'DIGITAL_REPORT_ON_TOP',
                'type'           => 'select',
                'is_readonly'    => '0',
                'default_value'  => 'no',
                'status'         => '1',
                'is_mandatory'   => '0',
                'select_options' => 'no,yes',
                'remarks'        => 'DIGITAL REPORT ON TOP OF PRINT FORMAT',
            ],*/
            /*[
                'field'          => 'User wise account access',
                'code'           => 'USER_WISE_ACCOUNT_ACCESS',
                'type'           => 'select',
                'is_readonly'    => '0',
                'default_value'  => 'no',
                'status'         => '1',
                'is_mandatory'   => '0',
                'select_options' => 'no,yes',
                'remarks'        => 'For Access Referral Lab',
            ],*/
            [
                'field'          => 'Doctor incentive with ref bill',
                'code'           => 'DOCTOR_INCENTIVE_WITH_REF_BILL',
                'type'           => 'select',
                'is_readonly'    => '0',
                'default_value'  => 'no',
                'status'         => '1',
                'is_mandatory'   => '0',
                'select_options' => 'no,yes',
                'remarks'        => 'Doctor Incentive With Referral Bill',
            ],
            [
                'field'          => 'Enable bill collection Referral Lab',
                'code'           => 'ENABLE_BILL_COLLECT_REFERRAL_LAB',
                'type'           => 'select',
                'is_readonly'    => '0',
                'default_value'  => 'no',
                'status'         => '1',
                'is_mandatory'   => '0',
                'select_options' => 'no,yes',
                'remarks'        => 'Enable Bill Collect Option for Referral Lab',
            ],
            /*[
                'field'          => 'Show particulars for cashback details',
                'code'           => 'SHOW_PARTICULARS_FOR_CASHBOOK_DETAILS',
                'type'           => 'select',
                'is_readonly'    => '0',
                'default_value'  => 'yes',
                'status'         => '1',
                'is_mandatory'   => '0',
                'select_options' => 'no,yes',
                'remarks'        => 'Show Particulars for Cash Book Details Report',
            ],
            [
                'field'          => 'Special Group Wise Multiple Summernote Setting.',
                'code'           => 'SPECIAL_GROUP_WISE_MULTIPLE_SUMMERNOTE_SETTING',
                'type'           => 'select',
                'is_readonly'    => '0',
                'default_value'  => 'no',
                'status'         => '1',
                'is_mandatory'   => '0',
                'select_options' => 'no,yes',
                'remarks'        => 'Special Group Wise Multiple Summernote Setting.',
            ],*/
            [
                'field'          => 'SHOW METHOD ON REPORT',
                'code'           => 'SHOWMETHODONREPORT',
                'type'           => 'select',
                'is_readonly'    => '0',
                'default_value'  => 'no',
                'status'         => '1',
                'is_mandatory'   => '0',
                'select_options' => 'no,yes',
                'remarks'        => 'SHOW METHOD ON REPORT YES OR NO.',
            ],
            [
                'field'          => 'Show Print Button on Due Report',
                'code'           => 'SHOW_PRINT_OPTION_ON_DUE_BILL',
                'type'           => 'select',
                'is_readonly'    => '0',
                'default_value'  => 'yes',
                'status'         => '1',
                'is_mandatory'   => '0',
                'select_options' => 'no,yes',
                'remarks'        => 'Show Print Button on Due Report',
            ],
            [
                'field'          => 'Doctor verification wise signature in report',
                'code'           => 'DOCTOR_VERIFICATION_WISE_SIGNATURE_IN_REPORT',
                'type'           => 'select',
                'is_readonly'    => '0',
                'default_value'  => 'yes',
                'status'         => '1',
                'is_mandatory'   => '0',
                'select_options' => 'no,yes',
                'remarks'        => 'DOCTOR VERIFICATION WISE SIGNATURE IN REPORT',
            ],
            [
                'field'          => 'SHOW METHOD UNDER TEST PARAMETER',
                'code'           => 'SHOWMETHODUNDERTESTPARAMETER',
                'type'           => 'select',
                'is_readonly'    => '0',
                'default_value'  => 'yes',
                'status'         => '1',
                'is_mandatory'   => '0',
                'select_options' => 'no,yes',
                'remarks'        => 'SHOW METHOD UNDER TEST PARAMETER',
            ],
            [
                'field'          => 'AFTER DOCTOR VERIFICATION REPORT PRINT',
                'code'           => 'AFTER_DOCTOR_VERIFICATION_REPORT_PRINT',
                'type'           => 'select',
                'is_readonly'    => '0',
                'default_value'  => 'no',
                'status'         => '1',
                'is_mandatory'   => '0',
                'select_options' => 'no,yes',
                'remarks'        => 'AFTER DOCTOR VERIFICATION REPORT PRINT',
            ],
            /*[
                'field'          => 'HIGH LOW TEXT SIGNAL',
                'code'           => 'HIGH_LOW_TEXT_SIGNAL',
                'type'           => 'select',
                'is_readonly'    => '0',
                'default_value'  => 'yes',
                'status'         => '1',
                'is_mandatory'   => '0',
                'select_options' => 'no,yes',
                'remarks'        => 'HIGH LOW TEXT SIGNAL',
            ],*/
        ];

        foreach($settings as $key => $value) {
            $master_setting = MasterSetting::updateOrCreate([
                    'code' => $value['code'],
                ],
                $value
            );

            AdvanceSetting::updateOrCreate([
                'master_setting_id' => $master_setting->id
            ],[
                'value' => $master_setting->default_value
            ]);
        }
    }
}
