<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ModelsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Disable foreign key checks
        \DB::statement('SET FOREIGN_KEY_CHECKS=0');
        \DB::table('menu_model_permissios')->truncate();
        // Enable foreign key checks
        \DB::statement('SET FOREIGN_KEY_CHECKS=1');

        \DB::statement("
            INSERT IGNORE INTO `menu_model_permissios` (`id`, `menu_name`,`code`, `priority`, `parent_id`, `summernote`, `icon`, `status`, `route`, `module_type`,`created_at`, `updated_at`) VALUES
            (6, 'Settings','SETTINGS',81, NULL, NULL, 'gear-fill', '1', 'master-settings', 'quick_menu','2023-09-05 08:15:00', '2023-09-05 08:15:05'),
            (7, 'Roles','ROLES', 157, 6, NULL, 'person-fill', '1', '', '','2023-08-12 05:08:51', '2023-09-05 08:15:05'),
            (8, 'Users','USERS', 218, 6, NULL, 'people-fill', '1', 'users', 'quick_menu','2023-08-12 05:11:10', '2023-09-05 08:15:18'),
            (9, 'Company','COMPANY', 122, NULL, NULL, 'building', '1', 'companies', 'quick_menu','2023-08-12 05:12:43', '2023-09-05 08:19:27'),
            (11, 'Financial Year','FINANCIAL_YEAR', 208, 6, NULL, 'list', '1', '', '','2023-08-12 05:14:22', '2023-09-05 08:15:40'),
            (12, 'SMS API','SMS_API', 23, 6, NULL, 'envelope', '1', '', '','2023-08-12 05:16:03', '2023-09-05 08:16:01'),
            (21, 'Products & Services','PRODUCT', 6, NULL, NULL, 'box-fill', '1', 'products', 'left_menu','2023-08-12 05:27:58', '2023-09-05 08:16:21'),
            -- (22, 'Enquiry','ENQUIRY', 112, 188, NULL, 'journal', '1', 'enquiries', '','2023-08-12 05:30:03', '2023-09-05 08:17:21'),
            (23, 'Permission','PERMISSION', 226, 6, NULL, 'lock-fill', '1', '', '','2023-08-16 00:26:33', '2023-09-05 08:17:15'),
            (25, 'Account License','ACCOUNT_LICENSE', 10, 38, NULL, 'file-text-fill', '1', '', '','2023-09-05 08:21:37', '2023-09-05 08:21:37'),
            (26, 'Payment TERM','PAYMENT_TERM', 11, 6, NULL, 'cash-stack', '1', '', '','2023-09-05 08:22:16', '2023-09-05 08:22:16'),
            (27, 'Blood Groups','BLOOD_GROUPS', 12, 38, NULL, 'droplet-fill', '1', '', '','2023-09-05 08:22:56', '2023-09-05 08:22:56'),
            (28, 'Genders','GENDERS', 13, 38, NULL, 'gender-ambiguous', '1', '', '','2023-09-05 08:23:21', '2023-09-05 08:23:21'),
            (29, 'Marital Status','MARITAL_STATUS', 14, 38, NULL, 'people-fill', '1', '', '','2023-09-05 08:24:24', '2023-09-05 08:24:24'),
            (30, 'Modules','MODULES', 15, 6, 6, 'boxes', '1', '', '','2023-09-05 08:25:09', '2023-09-05 08:25:09'),
            -- (31, 'Enquiry Category','ENQUIRY_CATEGORY', 16, 188, NULL, 'grid', '1', '', '','2023-09-05 08:25:57', '2023-09-05 08:25:57'),
            -- (32, 'Enquiry Types','ENQUIRY_TYPES', 17, 188, NULL, 'grid', '1', '', '','2023-09-05 08:26:15', '2023-09-05 08:26:15'),
            -- (33, 'Enquiry Sources','ENQUIRY_SOURCES', 18, 188, NULL, 'grid', '1', '', '','2023-09-05 08:26:47', '2023-09-05 08:26:47'),
            -- (34, 'Enquiry Qualities','ENQUIRY_QUALITIES', 19, 188, NULL, 'grid', '1', '', '','2023-09-05 08:27:34', '2023-09-05 08:27:34'),
            -- (35, 'Enquiry Status','ENQUIRY_STATUS', 20, 188, NULL, 'grid', '1', '', '','2023-09-05 08:28:33', '2023-09-05 08:28:33'),
            (36, 'Account Contacts','ACCOUNT_CONTACTS', 21, 38, NULL, 'person-fill', '1', '', '','2023-09-05 08:28:57', '2023-09-05 08:30:06'),
            -- (37, 'Enquiry Contacts','ENQUIRY_CONTACTS', 22, 188, NULL, 'person-fill', '1', '', '','2023-09-05 08:29:31', '2023-09-05 08:29:31'),
            (38, 'Accounts','ACCOUNTS', 9, NULL, NULL, 'person-circle', '1', 'accounts', 'left_menu','2023-09-05 08:29:54', '2023-09-05 08:29:54'),
            (39, 'Account Title','ACCOUNT_TITLE', 24, 38, NULL, 'fonts', '1', '', '','2023-09-05 08:30:42', '2023-09-05 08:30:42'),
            (40, 'Accounting Type','ACCOUNTING_TYPE', 25, 38, NULL, 'grid', '1', '', '','2023-09-05 08:31:15', '2023-09-05 08:31:15'),
            (41, 'Accounting Group','ACCOUNTING_GROUP', 26, 38, NULL, 'grid', '1', '', '','2023-09-05 08:31:37', '2023-09-05 08:31:37'),
            (42, 'Account Category','ACCOUNT_CATEGORY', 27, 38, NULL, 'grid', '1', '', '','2023-09-05 08:32:39', '2023-09-05 08:32:39'),
            (43, 'Account Type','ACCOUNT_TYPE', 28, 38, NULL, 'grid', '1', '', '','2023-09-05 08:33:03', '2023-09-05 08:33:03'),
            (44, 'Tax Register Category','TAX_REGISTER_CATEGORY', 29, 38, NULL, 'grid', '1', '', '','2023-09-05 08:33:27', '2023-09-05 08:33:27'),
            (45, 'License Type','LICENSE_TYPE', 30, 38, NULL, 'grid', '1', '', '','2023-09-05 08:33:50', '2023-09-05 08:33:50'),
            (46, 'Account Settlement Types','ACCOUNT_SETTLEMENT_TYPES', 31, 38, NULL, 'grid', '1', '', '','2023-09-05 08:34:18', '2023-09-05 08:34:18'),
            (47, 'Invoice Serial Setting','INVOICE_SERIAL_SETTING', 32, 6, NULL, 'file-text-fill', '1', '', '','2023-09-05 08:36:11', '2023-09-05 08:36:11'),
            (48, 'Storage Settings','STORAGE_SETTINGS', 33, 167, NULL, 'device-hdd-fill', '1', '', '','2023-09-05 08:37:09', '2023-09-05 08:37:09'),
            (49, 'Software Branding','SOFTWARE_BRANDING', 34, 6, NULL, 'award-fill', '1', '', '','2023-09-05 08:37:54', '2023-09-05 08:37:54'),
            (50, 'Master Settings','MASTER_SETTINGS', 35, 6, NULL, 'people-fill', '1', '', '','2023-09-05 08:38:27', '2023-09-05 08:38:27'),
            (51, 'Document Types','DOCUMENT_TYPES', 36, 9, NULL, 'grid', '1', '', '','2023-09-05 08:38:27', '2023-09-05 08:38:27'),
            (52, 'Account Address','ACCOUNT_ADDRESS', 37, 38, NULL, 'pin-map-fill', '1', '', '','2023-09-07 20:21:42', '2023-09-07 20:22:04'),
            (53, 'Account Attachments','ACCOUNT_ATTACHMENTS', 38, 38, NULL, 'pin-map', '1', '', '','2023-09-07 20:25:07', '2023-09-07 20:25:07'),
            (54, 'Account Banks','ACCOUNT_BANKS', 39, 38, NULL, 'bank2', '1', '', '','2023-09-07 20:26:54', '2023-09-07 20:26:54'),
            (55, 'Account Divisions','ACCOUNT_DIVISIONS', 40, 38, NULL, 'bank', '1', '', '','2023-09-07 20:29:00', '2023-09-07 20:29:00'),
            (56, 'Account Payment','ACCOUNT_PAYMENT', 41, 38, NULL, 'file-earmark-text-fill', '1', '', '','2023-09-07 20:32:15', '2023-09-07 20:32:15'),
            (57, 'Address Types','ADDRESS_TYPES', 42, 38, NULL, 'grid', '1', '', '','2023-09-07 20:33:31', '2023-09-07 20:43:51'),
            (58, 'Company Addresses','COMPANY_ADDRESSES', 43, 9, NULL, 'buildings-fill', '1', '', '','2023-09-07 20:35:27', '2023-09-07 20:41:39'),
            (59, 'Company Bank','COMPANY_BANK', 44, 9, NULL, 'bank', '1', '', '','2023-09-07 20:36:06', '2023-09-07 20:43:04'),
            (60, 'Company Documents','COMPANY_DOCUMENTS', 45, 9, NULL, 'file-earmark-text', '1', '', '','2023-09-07 20:38:49', '2023-09-07 20:42:52'),
            (61, 'Company Establishment Types','COMPANY_ESTABLISHMENT_TYPES', 46, 9, NULL, 'grid', '1', '', '','2023-09-07 20:40:48', '2023-09-07 20:42:23'),
            (62, 'Company Licenses','COMPANY_LICENSES', 47, 9, NULL, 'card-heading', '1', '', '','2023-09-07 20:45:51', '2023-09-07 20:45:51'),
            (63, 'Account Master Category','ACCOUNT_MASTER_CATEGORY', 48, 38, NULL, 'grid', '1', '', '','2023-09-07 20:46:35', '2023-09-07 20:46:35'),
            (64, 'Account Master Type','ACCOUNT_MASTER_TYPE', 49, 38, NULL, 'grid', '1', '', '','2023-09-07 20:47:03', '2023-09-07 20:47:03'),
            (66, 'Product Alternative Units','PRODUCT_ALTERNATIVE_UNITS', 51, 21, NULL, 'boxes', '1', '', '','2023-09-09 09:44:59', '2023-09-09 09:44:59'),
            (67, 'Product Alternative','PRODUCT_ALTERNATIVE', 52, 21, NULL, 'exclamation-square-fill', '1', '', '','2023-09-09 09:49:20', '2023-09-09 09:49:20'),
            (68, 'Product Brands','PRODUCT_BRANDS', 53, 21, NULL, 'exclamation-square-fill', '1', '', '','2023-09-09 09:49:42', '2023-09-09 09:49:42'),
            (69, 'Product Groups','PRODUCT_GROUPS', 54, 21, NULL, 'exclamation-square-fill', '1', '', '','2023-09-09 09:50:19', '2023-09-09 10:05:40'),
            (70, 'Product Category','PRODUCT_CATEGORY', 55, 21, NULL, 'exclamation-square-fill', '1', '', '','2023-09-09 09:51:05', '2023-09-09 09:51:05'),
            (71, 'Product Attribute Types','PRODUCT_ATTRIBUTE_TYPES', 56, 21, NULL, 'exclamation-square-fill', '1', '', '','2023-09-09 09:58:38', '2023-09-09 09:58:38'),
            (72, 'Product Attributes','PRODUCT_ATTRIBUTES', 57, 21, NULL, 'exclamation-square-fill', '1', '', '','2023-09-09 10:01:35', '2023-09-09 10:01:35'),
            -- (73, 'Lab Test Master','TEST_MANAGER', 58, NULL, NULL, 'file-text', '1', 'test-packages', 'left_menu','2023-09-11 03:03:24', '2023-09-11 03:03:24'),
            -- (74, 'Test List','TEST_LIST', 59, 73, NULL, 'list-check', '1', '', '','2023-09-11 03:03:45', '2023-09-11 03:03:45'),
            -- (75, 'Test Package','TEST_PACKAGE', 60, 73, NULL, 'boxes', '1', '', '','2023-09-11 03:04:00', '2023-09-11 03:04:00'),
            (76, 'Department','DEPARTMENT', 61, 73, NULL, 'grid', '1', '', '','2023-09-11 03:04:22', '2023-09-11 07:48:30'),
            -- (77, 'Collection Tube','COLLECTION_TUBE', 62, 73, NULL, 'exclamation-square-fill', '1', '', '','2023-09-11 03:04:50', '2023-09-11 03:04:50'),
            -- (78, 'Sample Type','SAMPLE_TYPE', 63, 73, NULL, 'grid', '1', '', '','2023-09-11 03:05:02', '2023-09-11 07:48:52'),
            (79, 'Primary Unit','PRIMARY_UNIT', 64, 73, NULL, 'unity', '1', '', '','2023-09-11 03:05:16', '2023-09-11 07:49:38'),
            -- (80, 'Test Method','TEST_METHOD', 65, 73, NULL, 'grid', '1', '', '','2023-09-11 03:05:26', '2023-09-11 07:49:58'),
            -- (81, 'Machine And Equipment','MACHINE_AND_EQUIPMENT', 66, 73, NULL, 'grid', '1', '', '','2023-09-11 03:05:38', '2023-09-11 07:50:35'),
            -- (82, 'Special Case','SPECIAL_CASE', 67, 73, NULL, 'layers', '1', '', '','2023-09-11 03:05:51', '2023-09-11 07:51:35'),
            (83, 'Style Type','STYLE_TYPE', 68, 73, NULL, 'border-style', '1', '', '','2023-09-11 03:06:07', '2023-09-11 07:52:04'),
            -- (84, 'Test Package Group','TEST_PACKAGE_GROUP', 69, 73, NULL, 'exclamation-square-fill', '1', '', '','2023-09-11 03:07:49', '2023-09-11 03:07:49'),
            -- (85, 'Test Item Option','TEST_ITEM_OPTION', 70, 73, NULL, 'exclamation-square-fill', '1', '', '','2023-09-11 03:08:06', '2023-09-11 03:09:25'),
            -- (86, 'Test Package Group Note','TEST_PACKAGE_GROUP_NOTE', 71, 73, NULL, 'exclamation-square-fill', '1', '', '','2023-09-11 03:08:48', '2023-09-11 03:08:48'),
            -- (87, 'Test Package Note','TEST_PACKAGE_NOTE', 72, 73, NULL, 'exclamation-square-fill', '1', '', '','2023-09-11 03:09:06', '2023-09-11 03:09:06'),
            (88, 'Product Warehouse','PRODUCT_WAREHOUSE', 73, 21, NULL, 'bi bi-journal', '1', '', '','2023-09-11 09:52:04', '2023-09-11 09:52:04'),
            (89, 'Product Location Rack','PRODUCT_LOCATION_RACK', 74, 21, NULL, 'bi bi-journal', '1', '', '','2023-09-11 09:52:35', '2023-09-11 09:52:35'),
            (90, 'Tax Master','TAX_MASTER', 75, 21, NULL, 'journal-arrow-down', '1', 'tax-masters', '','2023-09-11 10:00:56', '2023-09-11 10:00:56'),
            (91, 'Tax Category','TAX_CATEGORY',76, 21, NULL, 'list', '1', '', '','2023-09-11 10:03:47', '2023-09-11 10:03:47'),
            (92, 'Tax Master Sub','TAX_MASTER_SUB', 77, 21, NULL, 'list', '1', '', '','2023-09-11 10:17:35', '2023-09-11 10:17:35'),
            (93, 'Tax Calculation','TAX_CALCULATION', 78, 21, NULL, 'list', '1', '', '','2023-09-11 10:21:12', '2023-09-11 10:21:12'),
            (94, 'Product Item Types','PRODUCT_ITEM_TYPES', 79, 21, NULL, 'grid', '1', '', '','2023-09-12 07:04:40', '2023-09-12 07:04:40'),
            (95, 'Product Prices','PRODUCT_PRICES', 80, 21, NULL, 'cash-stack', '1', '', '','2023-09-12 07:04:40', '2023-09-12 07:04:40'),
            (96, 'OPD Schedule Type','OPD_SCHEDULE_TYPE', 210, 233, NULL, 'calendar-plus', '1', '', '','2023-09-14 04:45:37', '2023-09-14 04:45:37'),
            (97, 'Organization Department','ORGANIZATION_DEPARTMENT', 82, 6, NULL, 'building', '1', '', '','2023-09-14 06:36:44', '2023-09-14 06:36:44'),
            (98, 'Tax Masters','TAX_MASTERS', 83, 21, NULL, 'list', '1', '', '','2023-09-14 09:30:11', '2023-09-14 09:30:11'),
            -- (99, 'Test Item Normal Range','TEST_ITEM_NORMAL_RANGE', 84, 73, NULL, 'exclamation-square-fill', '1', '', '','2023-09-20 10:55:43', '2023-09-20 10:58:27'),
            (100, 'Product Business Divisions','PRODUCT_BUSINESS_DIVISIONS', 85, 21, NULL, 'grid', '1', '', '','2023-09-20 10:55:43', '2023-09-20 10:58:27'),
            -- (101, 'Doctor','DOCTOR', 86, 233, NULL, 'exclamation-square-fill', '1', '', '','2023-09-27 04:15:22', '2023-09-27 04:15:22'),
            -- (102, 'Appointment Doctor Schedule','APPOINTMENT_DOCTOR_SCHEDULE', 87, 233, NULL, 'exclamation-square-fill', '1', '', '','2023-09-27 04:28:56', '2023-09-27 04:28:56'),
            -- (103, 'Appointment Shift','APPOINTMENT_SHIFT', 88, 233, NULL, 'exclamation-square-fill', '1', '', '','2023-09-27 04:39:00', '2023-09-28 02:43:51'),
            -- (104, 'Doctor Fee','DOCTOR_FEE', 89, 233, NULL, 'exclamation-square-fill', '1', '', '','2023-09-28 02:38:35', '2023-09-28 02:40:37'),
            -- (105, 'Test Unit','TEST_UNIT', 90, 73, NULL, 'exclamation-square-fill', '1', '', '','2023-10-02 06:34:55', '2023-10-02 06:34:55'),
            -- (106, 'Enquiry Category Fields','ENQUIRY_CATEGORY_FIELDS', 91, 22, NULL, 'grid', '1', '', '','2023-10-03 07:39:55', '2023-10-03 07:40:50'),
            (107, 'Signature','SIGNATURE', 92, 73, NULL, 'x-diamond', '1', '', '','2023-10-03 09:55:56', '2023-10-03 09:56:24'),
            -- (108, 'Beds','BEDS', 93, 142, NULL, 'building-fill-add', '1', '', '','2023-10-03 09:25:24', '2023-10-03 09:34:34'),
            -- (109, 'Bed Type','BED_TYPE', 94, 142, NULL, 'grid', '1', '', '','2023-10-03 09:42:46', '2023-10-03 09:49:09'),
            -- (110, 'Bed Group','BED_GROUP', 95, 142, NULL, 'grid', '1', '', '','2023-10-03 09:49:29', '2023-10-03 09:49:29'),
            -- (111, 'Floor','FLOOR', 96, 142, NULL, 'grid', '1', '', '','2023-10-03 09:52:46', '2023-10-03 09:52:46'),
            -- (112, 'Building','BUILDING', 97, 142, NULL, 'exclamation-square-fill', '1', '', '','2023-10-03 09:58:13', '2023-10-03 09:58:13'),
            -- (113, 'Subjects','SUBJECTS', 98, 119, NULL, 'book', '1', '', '','2023-10-06 09:58:13', '2023-10-03 09:58:13'),
            -- (114, 'Course Types','COURSE_TYPES', 99, 119, NULL, 'book', '1', '', '','2023-10-09 09:58:13', '2023-10-03 09:58:13'),
            -- (115, 'Course Levels','COURSE_LEVELS', 100, 119, NULL, 'book', '1', '', '','2023-10-09 09:58:13', '2023-10-03 09:58:13'),
            -- (116, 'Languages','LANGUAGES', 100, 119, NULL, 'translate', '1', '', '','2023-10-09 09:58:13', '2023-10-03 09:58:13'),
            -- (117, 'Course Categories','COURSE_CATEGORIES', 101, 119, NULL, 'book', '1', '', '','2023-10-09 09:58:13', '2023-10-03 09:58:13'),
            -- (118, 'Tags', 'TAGS',102, 119, NULL, 'hash', '1', '', '','2023-10-09 09:58:13', '2023-10-03 09:58:13'),
            -- (119, 'Courses','COURSES', 103, NULL, NULL, 'book', '1', 'courses', 'left_menu','2023-10-09 09:58:13', '2023-10-03 09:58:13'),
            -- (120, 'Medical Settings','MEDICAL_SETTINGS', 104, NULL, NULL, 'heart-pulse-fill', '1', 'symptoms', 'left_menu','2023-10-09 09:58:13', '2023-10-03 09:58:13'),
            -- (121, 'Symptoms','SYMPTOMS', 105, 120, NULL, 'grid', '1', '', '','2023-10-09 09:58:13', '2023-10-03 09:58:13'),
            -- (122, 'Symptom Classifications','SYMPTOM_CLASSIFICATIONS', 106, 120, NULL, 'grid', '1', '', '','2023-10-09 09:58:13', '2023-10-03 09:58:13'),
            -- (123, 'Findings','FINDINGS', 107, 120, NULL, 'grid', '1', '', '','2023-10-09 09:58:13', '2023-10-03 09:58:13'),
            -- (124, 'Finding Categories','FINDING_CATEGORIES', 108, 120, NULL, 'grid', '1', '', '','2023-10-09 09:58:13', '2023-10-03 09:58:13'),
            -- (125, 'Operations','OPERATIONS', 109, 120, NULL, 'grid', '1', '', '','2023-10-09 09:58:13', '2023-10-03 09:58:13'),
            -- (126, 'Operation Categories','OPERATION_CATEGORIES', 110, 120, NULL, 'grid', '1', '', '','2023-10-09 09:58:13', '2023-10-03 09:58:13'),
            -- (127, 'Classes','CLASSES', 111, 119, NULL, 'book', '1', '', '','2023-10-09 09:58:13', '2023-10-03 09:58:13'),
            (128,'Financial Accounting','ACCOUNTING',10,NULL,NULL,'receipt','1', 'receipt-voucher', 'left_menu','2023-10-09 09:58:13', '2023-10-03 09:58:13'),
            /*(129,'Contra Voucher','CONTRA_VOUCHER',113,128 ,NULL,'exclamation-square-fill','1', '', '','2023-10-09 09:58:13', '2023-10-03 09:58:13'),
            (130,'Receipt Voucher', 'RECEIPT_VOUCHER',114,128 ,NULL,'exclamation-square-fill','1', '', '','2023-10-09 09:58:13', '2023-10-03 09:58:13'),
            (131,'Payment Voucher','PAYMENT_VOUCHER',115,128 ,NULL,'exclamation-square-fill','1', '', '','2023-10-09 09:58:13', '2023-10-03 09:58:13'),
            (132,'Journal Voucher', 'JOURNAL_VOUCHER', 116,128 ,NULL,'exclamation-square-fill','1', '', '','2023-10-09 09:58:13', '2023-10-03 09:58:13'),;*/
            (129,'Journal Voucher', 'JOURNAL_VOUCHER', 113,128 ,NULL,'exclamation-square-fill','1', '', '','2023-10-09 09:58:13', '2023-10-03 09:58:13'),
            (130,'Payment Voucher', 'PAYMENT_VOUCHER', 114,128 ,NULL,'exclamation-square-fill','1', '', '','2023-10-09 09:58:13', '2023-10-03 09:58:13'),
            (131,'Receipt Voucher', 'Receipt_VOUCHER',115,128 ,NULL,'exclamation-square-fill','1', '', '','2023-10-09 09:58:13', '2023-10-03 09:58:13'),
            (132,'Contra Voucher', 'CONTRA_VOUCHER',116,128 ,NULL,'exclamation-square-fill','1', '', '','2023-10-09 09:58:13', '2023-10-03 09:58:13'),
            (133, 'Vouchers Master','VOUCHERS_MASTER', 117, NULL, NULL, 'exclamation-square-fill', '1', '', '','2023-10-13 01:26:44', '2023-10-13 01:26:44'),
            (134, 'Voucher Types', 'VOUCHER_TYPES',118, 133, NULL, 'exclamation-square-fill', '1', '', '','2023-10-13 01:26:54', '2023-10-13 01:27:18'),
            (135, 'Voucher Series', 'VOUCHER_SERIES',119, 133, NULL, 'exclamation-square-fill', '1', '', '','2023-10-13 01:27:05', '2023-10-13 01:27:05'),
            (136, 'Price Setting', 'PRICE_SETTING',120, 21, NULL, 'exclamation-square-fill', '1', '', '','2023-10-13 05:17:04', '2023-10-13 05:17:04'),
            (137,'Sections','SECTIONS',121,119 ,NULL,'book','1', '', '','2023-10-09 09:58:13', '2023-10-03 09:58:13'),
            (138, 'Incentive Master', 'INCENTIVE_MASTER',122, 139, NULL, 'arrow-left-right', '1', '', '','2023-10-16 03:03:18', '2023-10-16 03:03:18'),
            (139, 'Incentive Manager', 'INCENTIVE_SLAB',123, NULL, NULL, 'currency-dollar', '1', 'incentive-slabs', 'left_menu','2023-10-16 03:03:48', '2023-10-16 03:03:48'),
            (140, 'Incentive Setting', 'INCENTIVE_SETTING',124, 138, NULL, 'exclamation-square-fill', '1', '', '','2023-10-16 03:04:02', '2023-10-16 03:04:02'),
            (141, 'Incentive Slab Details','INCENTIVE_SLAB_DETAILS', 125, 138, NULL, 'exclamation-square-fill', '1', '', '','2023-10-16 03:04:19', '2023-10-16 03:04:19'),
            -- (142, 'Admission List','IPD_ADMISSION', 5, NULL, NULL, 'clipboard-plus', '1', 'ipd-admissions', 'left_menu','2023-10-16 03:04:02', '2023-10-16 03:04:02'),
            (143, 'Relation Types','RELATION_TYPES', 123, 38, NULL, 'exclamation-square-fill', '1', '', '','2023-10-16 03:04:02', '2023-10-16 03:04:02'),
            (144, 'Account Relatives','ACCOUNT_RELATIVES', 124, 38, NULL, 'exclamation-square-fill', '1', '', '','2023-09-07 20:21:42', '2023-09-07 20:22:04'),
            -- (145, 'Students Manager', 'STUDENTS_MANAGER',125, NULL, NULL, 'people', '1', 'students', 'left_menu','2023-09-07 20:21:42', '2023-09-07 20:22:04'),
            -- (146, 'Student House','STUDENT_HOUSE', 126, 145, NULL, 'house-door', '1', '', '','2023-09-07 20:21:42', '2023-09-07 20:22:04'),
            -- (147, 'Students', 'STUDENTS', 127, 145, NULL, 'people', '1', 'students', '','2023-09-07 20:21:42', '2023-09-07 20:22:04'),
            -- (148, 'Faculty', 'FACULTY',128, NULL, NULL, 'people', '1', 'faculty', 'left_menu','2023-09-07 20:21:42', '2023-09-07 20:22:04'),
            -- (149, 'Settings Language', 'SETTINGS_LANGUAGE',129, 6, NULL, 'exclamation-square-fill', '1', '', '','2023-09-07 20:21:42', '2023-09-07 20:22:04'),
            (150, 'Date Format', 'DATE_FORMAT',130, 6, NULL, 'exclamation-square-fill', '1', '', '','2023-09-07 20:21:42', '2023-09-07 20:22:04'),
            (151, 'Time Format', 'TIME_FORMAT',131, 6, NULL, 'exclamation-square-fill', '1', '', '','2023-09-07 20:21:42', '2023-09-07 20:22:04'),
            (152, 'Currencies', 'CURRENCIES',132, 6, NULL, 'exclamation-square-fill', '1', '', '','2023-09-07 20:21:42', '2023-09-07 20:22:04'),
            (153, 'Timezones', 'TIMEZONES',133, 6, NULL, 'exclamation-square-fill', '1', '', '','2023-09-07 20:21:42', '2023-09-07 20:22:04'),
            -- (154, 'Library Management', 'LIBRARY MANAGEMENT',134, NULL, NULL, 'book', '1', 'books', 'left_menu','2023-09-07 20:21:42', '2023-09-07 20:22:04'),
            -- (155, 'Books', 'BOOKS',135, 154, NULL, 'book', '1', '', '','2023-09-07 20:21:42', '2023-09-07 20:22:04'),
            -- (156, 'Library Settings', 'LIBRARY_SETTINGS',136, NULL, NULL, 'journal-check', '1', 'library/genres', 'left_menu','2023-09-07 20:21:42', '2023-09-07 20:22:04'),
            -- (157, 'Library category', 'LIBRARY_CATEGORY',137, 156, NULL, 'bucket', '1', '', '','2023-09-07 20:21:42', '2023-09-07 20:22:04'),
            -- (158, 'Library Authors', 'LIBRARY_AUTHORS',138, 156, NULL, 'people', '1', '', '','2023-09-07 20:21:42', '2023-09-07 20:22:04'),
            -- (159, 'Library Publishers', 'LIBRARY_PUBLISHERS',139, 156, NULL, 'people', '1', '', '','2023-09-07 20:21:42', '2023-09-07 20:22:04'),
            -- (161, 'Library Tags', 'LIBRARY_TAGS',141, 156, NULL, 'tags', '1', '', '','2023-09-07 20:21:42', '2023-09-07 20:22:04'),
            -- (162, 'Library Places', 'LIBRARY_PLACES',142, 156, NULL, 'map', '1', '', '','2023-09-07 20:21:42', '2023-09-07 20:22:04'),
            -- (163, 'Library Editors', 'LIBRARY_EDITORS',143, 156, NULL, 'people', '1', '', '','2023-09-07 20:21:42', '2023-09-07 20:22:04'),
            -- (164, 'Library Translators', 'LIBRARY_TRANSLATORS',144, 156, NULL, 'people', '1', '', '','2023-09-07 20:21:42', '2023-09-07 20:22:04'),
            -- (165, 'Library Book Formates', 'LIBRARY_BOOK_FORMATES',145, 156, NULL, 'book', '1', '', '','2023-09-07 20:21:42', '2023-09-07 20:22:04'),
            -- (166, 'Library Classes', 'LIBRARY_CLASSES',146, 156, NULL, 'book', '1', '', '','2023-09-07 20:21:42', '2023-09-07 20:22:04'),
            (167, 'API Management', 'API_MANAGEMENT',11, NULL, NULL, 'hdd-network', '1', 'api-management', 'left_menu','2023-09-07 20:21:42', '2023-09-07 20:22:04'),
            (168, 'Body Vitals', 'BODY_VITALS',147, 120, NULL, 'file-medical', '1', '', '','2023-10-25 08:43:35', '2023-10-25 08:44:30'),
            (169, 'Card Type', 'LIBRARY_CARD_TYPES', 148, 156, NULL, 'credit-card', '1', '', '','2023-10-25 23:31:26', '2023-10-25 23:31:26'),
            (170, 'Membership Plan', 'LIBRARY_MEMBERSHIP_PLAN', 149, 156, NULL, 'credit-card', '1', '', '','2023-10-26 00:20:28', '2023-10-26 00:20:28'),
            -- (171, 'Library Stream', 'LIBRARY_STREAM', 150, 156, NULL, 'reception-4', '1', '', '','2023-10-26 01:56:43', '2023-10-26 01:57:25'),
            -- (172, 'Anesthesia Types', 'ANESTHESIA_TYPES', 151, 120, NULL, 'file-medical', '1', '', '','2023-10-26 07:42:43', '2023-10-26 07:44:25'),
            (173, 'Website Management', 'WEBSITE_MANAGEMENT', 152, NULL, NULL, 'globe', '1', 'sliders', 'left_menu','2023-10-26 06:28:26', '2023-10-26 06:28:26'),
            (174, 'Website Slider', 'WEBSITE_SLIDER', 153, 173, NULL, 'sliders', '1', 'sliders', '','2023-10-26 06:29:28', '2023-10-26 06:29:28'),
            (175, 'Website Content', 'WEBSITE_CONTENT', 154, 173, NULL, 'tag', '1', '', '','2023-10-26 06:30:33', '2023-10-26 06:30:33'),
            (176, 'Website Content Category', 'WEBSITE_CONTENT_CATEGORY', 155, 173, NULL, 'tag', '1', '', '','2023-10-26 06:31:13', '2023-10-26 06:31:13'),
            (177, 'Website Content Sub Category', 'WEBSITE_CONTENT_SUB_CATEGORY', 156, 173, NULL, 'tag', '1', '', '','2023-10-26 06:32:21', '2023-10-26 06:32:21'),
            -- (178, 'Lab Billing', 'PATHOLOGY_LAB_BILLING', 3, NULL, NULL, 'receipt', '1', 'lab-billings', 'left_menu','2023-10-26 07:42:43', '2023-10-26 07:44:25'),
            (179, 'Website Photo Gallery', 'WEBSITE_PHOTO_GALLERY', 158, 173, NULL, 'camera', '1', '', '','2023-10-28 00:25:39', '2023-10-28 00:25:39'),
            (180, 'Website Video Gallery', 'WEBSITE_VIDEO_GALLERY', 159, 173, NULL, 'camera-reels', '1', '', '','2023-10-28 00:55:15', '2023-10-28 00:55:15'),
            (181, 'Website Pages Settings', 'WEBSITE_PAGES_SETTINGS', 160, 173, NULL, 'files', '1', '', '','2023-10-28 02:40:30', '2023-10-28 02:40:30'),
            (182, 'Website Social Media', 'WEBSITE_SOCIAL_MEDIA', 161, 173, NULL, 'gear', '1', '', '','2023-10-28 04:27:03', '2023-10-28 04:27:03'),
            (183, 'Website Faq', 'WEBSITE_FAQ', 162, 173, NULL, 'patch-question', '1', '', '','2023-10-28 05:42:22', '2023-10-28 05:42:22'),
            (184, 'Website Services', 'WEBSITE_SERVICES', 163, 173, NULL, 'server', '1', '', '','2023-10-29 23:57:05', '2023-10-29 23:57:05'),
            (185, 'Website Blogs', 'WEBSITE_BLOGS', 164, 173, NULL, 'newspaper', '1', '', '','2023-10-30 00:58:06', '2023-10-30 00:58:06'),
            (186, 'Website Testimonials', 'WEBSITE_TESTIMONIALS', 165, 173, NULL, 'newspaper', '1', '', '','2023-10-30 04:57:56', '2023-10-30 04:57:56'),
            (187, 'Website Teams', 'WEBSITE_TEAMS', 166, 173, NULL, 'people', '1', '', '','2023-10-30 06:40:19', '2023-10-30 06:40:19'),
            (188, 'MARKETING', 'MARKETING', 167, NULL, NULL, 'graph-up', '1', 'enquiries', 'left_menu','2023-11-02 03:51:23', '2023-11-02 04:13:12'),
            (189, 'Business Category', 'BUSINESS_CATEGORY', 168, 188, NULL, 'exclamation-square-fill', '1', '', '','2023-11-02 04:08:12', '2023-11-02 04:08:12'),
            (190, 'Advance Settings', 'ADVANCE SETTINGS', 169, 188, NULL, 'exclamation-square-fill', '1', '', '','2023-11-02 04:08:12', '2023-11-02 04:08:12'),
            (191, 'Book Issue', 'BOOK_ISSUE', 170, 154, NULL, 'credit-card', '1', '', '','2023-11-06 07:19:57', '2023-11-06 07:19:57'),
            -- (192, 'Discharge Types', 'DISCHARGE_TYPES', 171, 142, NULL, 'exclamation-square-fill', '1', '', '','2023-11-08 05:55:28', '2023-11-08 05:56:02'),
            -- (193, 'Book Return', 'BOOK_RETURN', 172, 154, NULL, 'credit-card', '1', '', '','2023-11-08 23:32:30', '2023-11-08 23:32:30'),
            -- (194, 'Library Card', 'LIBRARY_CARD', 173, 154, NULL, 'credit-card', '1', '', '','2023-11-09 04:09:40', '2023-11-09 04:09:40'),
            (195, 'Blog Categories', 'BLOG_CATEGORIES', 174, 173, NULL, 'newspaper', '1', '', '','2023-11-09 04:09:40', '2023-11-09 04:09:40'),
            (196, 'Tags', 'TAGS', 175, 6, NULL, 'newspaper', '1', '', '','2023-11-09 04:09:40', '2023-11-09 04:09:40'),
            (197, 'Workspace', 'Workspace', 176, NULL, NULL, 'briefcase-fill', '1', 'projects', 'left_menu','2023-11-21 03:39:10', '2023-11-21 03:52:55'),
            (198, 'Projects', 'PROJECTS', 177, 197, NULL, 'exclamation-square-fill', '1', '', '','2023-11-21 03:53:46', '2023-11-21 03:53:46'),
            (199, 'Project Type', 'PROJECT_TYPE', 178, 197, NULL, 'exclamation-square-fill', '1', '', '','2023-11-21 04:07:11', '2023-11-21 04:35:59'),
            (200, 'Project Budget', 'PROJECT_BUDGET', 179, 197, NULL, 'exclamation-square-fill', '1', '', '','2023-11-21 04:13:05', '2023-11-21 04:36:14'),
            (201, 'Task Type', 'TASK_TYPE', 180, 280, NULL, 'exclamation-square-fill', '1', '', '','2023-11-21 04:18:11', '2023-11-21 04:36:25'),
            (202, 'Task Status', 'TASK_STATUS', 181, 280, NULL, 'exclamation-square-fill', '1', '', '','2023-11-21 04:30:27', '2023-11-21 04:38:59'),
            (203, 'Task Priority', 'TASK_PRIORITY', 182, 280, NULL, 'exclamation-square-fill', '1', '', '','2023-11-21 04:42:16', '2023-11-21 04:42:16'),
            (204, 'Budget Types', 'BUDGET_TYPES', 183, 197, NULL, 'exclamation-square-fill', '1', '', '','2023-11-21 04:46:53', '2023-11-21 04:46:53'),
            (205, 'Project Attachment', 'PROJECT_ATTACHMENT', 184, 197, NULL, 'exclamation-square-fill', '1', '', '','2023-11-21 04:54:23', '2023-11-21 04:54:23'),
            (206, 'Project Requirement', 'PROJECT_REQUIREMENT', 185, 197, NULL, 'exclamation-square-fill', '1', '', '','2023-11-21 05:01:27', '2023-11-21 05:01:27'),
            (207, 'Project Team', 'PROJECT_TEAM', 186, 197, NULL, 'exclamation-square-fill', '1', '', '','2023-11-21 05:08:21', '2023-11-21 05:08:21'),
            (208, 'Task', 'TASK', 187, 197, NULL, 'exclamation-square-fill', '1', '', '','2023-11-21 05:12:22', '2023-11-21 05:12:22'),
            (209, 'Task Attachment', 'TASK_ATTACHMENT', 188, 280, NULL, 'exclamation-square-fill', '1', '', '','2023-11-21 05:21:11', '2023-11-21 05:21:11'),
            (210, 'Responsible Team', 'RESPONSIBLE_TEAM', 189, 280, NULL, 'exclamation-square-fill', '1', '', '','2023-11-21 05:29:59', '2023-11-21 05:29:59'),
            (211, 'Human Resource', 'HUMAN_RESOURCE', 190, NULL, NULL, 'people-fill', '1', 'employee', 'left_menu','2023-11-24 08:35:28', '2023-11-24 08:35:28'),
            (212, 'Designation', 'Designation', 191, 211, NULL, 'exclamation-square-fill', '1', '', '','2023-11-24 08:36:57', '2023-11-24 08:36:57'),
            (213, 'Employee Type', 'EMPLOYEE_TYPE', 192, 211, NULL, 'exclamation-square-fill', '1', '', '','2023-11-24 08:45:45', '2023-11-24 08:45:45'),
            (214, 'Employee', 'EMPLOYEE', 193, 211, NULL, NULL, '1', '', '','2023-11-24 08:50:30', '2023-11-24 08:50:30'),
            (215, 'License Management', 'LICENSE_MANGEMENT', 194, NULL, NULL, 'postcard', '1', 'license-dashboard', 'left_menu','2023-11-29 09:23:46', '2023-11-29 09:23:46'),
            (216, 'Customer', 'CUSTOMER', 195, 215, NULL, 'exclamation-square-fill', '1', '', '','2023-11-29 09:25:15', '2023-11-29 09:25:15'),
            (217, 'Product Feature', 'PRODUCT_FEATURE', 196, 215, NULL, 'exclamation-square-fill', '1', '', '','2023-11-29 09:25:33', '2023-11-29 09:25:33'),
            (218, 'Client License', 'CLIENT_LICENSE', 197, 215, NULL, 'exclamation-square-fill', '1', '', '','2023-11-29 09:26:01', '2023-11-29 09:26:01'),
            (219, 'Client License Validity', 'CLIENT_LICENSE_VALIDITY', 198, 215, NULL, 'exclamation-square-fill', '1', '', '','2023-11-29 09:26:24', '2023-11-29 09:26:24'),
            (220, 'File Manager', 'FILE-MANAGER', 199, 173, NULL, 'file-earmark', '1', '', '','2023-12-07 09:11:44', '2023-12-07 09:11:44'),
            (221, 'Notice', 'NOTICE', 199, 173, NULL, 'exclamation-square-fill', '1', '', '','2023-12-07 10:40:23', '2023-12-07 10:40:23'),
            (222, 'License Registered', 'LICENSE_REGISTERED', 200, 215, NULL, 'card-text', '1', '', '','2023-12-12 02:46:38', '2023-12-12 02:46:38'),
            (223, 'License Details', 'LICENSE_DETAILS', 201, 215, NULL, 'card-text', '1', '', '','2023-12-12 02:49:05', '2023-12-12 02:49:05'),
            (224, 'License Activation History', 'LICENSE_ACTIVATION_HISTORY', 202, 222, NULL, 'card-text', '1', '', '','2023-12-12 02:50:15', '2023-12-12 02:50:15'),
            (225, 'Billing Interval', 'BILLING_INTERVAL', 200, 215, NULL, 'exclamation-square-fill', '1', '', '','2023-12-12 03:22:13', '2023-12-12 03:22:13'),
            (226, 'Server', 'SERVER', 203, 215, NULL, 'exclamation-square-fill', '1', '', '','2023-12-12 09:28:00', '2023-12-12 09:28:00'),
            (227, 'Branches', 'BRANCHES', 204, 173, NULL, 'exclamation-square-fill', '1', '', '','2023-12-12 09:28:00', '2023-12-12 09:28:00'),
            (228, 'Brands Logo', 'BRANDS_LOGO', 205, 173, NULL, 'exclamation-square-fill', '1', '', '','2023-12-12 09:28:00', '2023-12-12 09:28:00'),
            (229, 'Task Charges', 'TASK_CHARGES', 206, 280, NULL, 'exclamation-square-fill', '1', '', '','2024-01-05 10:33:01', '2024-01-05 10:33:01'),
            (230, 'Document Management', 'DOCUMENT_MANAGEMENT', 207, NULL, NULL, 'folder-symlink-fill', '1', 'documents-management', 'left_menu','2024-01-05 10:33:01', '2024-01-05 10:33:01'),
            (231, 'Sales Register', 'SALES',6, NULL, NULL, 'capsule', '1', 'sale', 'left_menu','2024-01-23 01:54:29', '2024-01-23 01:54:29'),
            (232, 'Payment Mode', 'PAYMENT_MODE', 209, 38, NULL, 'exclamation-square-fill', '1', '', '','2024-02-02 10:16:36', '2024-02-02 10:16:36'),
            -- (233, 'OPD Booking', 'OPD_BOOKING', 1, NULL, NULL, 'calendar2-check-fill', '1', 'opd-bookings', 'left_menu','2024-02-18 23:37:23', '2024-02-18 23:37:23'),
            -- (234, 'OPD APPOINTMENT', 'OPD_APPOINTMENT', 2, 233, NULL, 'person-plus-fill', '1', 'opd-appointment','left_menu','2024-02-19 05:23:51', '2024-02-19 05:23:51'),
            -- (235, 'DOCTOR CHAMBER', 'DOCTOR_CHAMBER', 212, 233, NULL, 'exclamation-square-fill', '1', '', '','2024-02-19 06:04:37', '2024-02-19 06:04:37'),
            -- (236, 'OPD DOCTOR PRESCRIPTION', 'OPD_DOCTOR_PRESCRIPTION', 213, 233, NULL, 'exclamation-square-fill', '1', '', '','2024-02-19 06:04:37', '2024-02-19 06:04:37'),
            -- (237, 'OPD DOCTOR HOLIDAY', 'OPD_DOCTOR_HOLIDAY', 214, 233, NULL, 'exclamation-square-fill', '1', '', '','2024-02-19 06:04:37', '2024-02-19 06:04:37'),
            (238, 'Industry Type', 'INDUSTRY_TYPE', 215, 215, NULL, 'exclamation-square-fill', '1', '', '','2024-02-19 06:04:37', '2024-02-19 06:04:37'),
            (239, 'Plan And Packages', 'PLANE_AND_PACKAGES', 216, 215, NULL, 'exclamation-square-fill', '1', '', '','2024-02-19 06:04:37', '2024-02-19 06:04:37'),
            (240, 'License Authentications', 'LICENSE_AUTHENTICATIONS', 217, 215, NULL, 'exclamation-square-fill', '1', '', '','2024-02-19 06:04:37', '2024-02-19 06:04:37'),
            -- (241, 'Lab Report', 'LAB_REPORTING_DASHBOARD', 4, NULL, NULL, 'clipboard-data-fill', '1', 'lab-reporting', 'left_menu','2024-02-19 06:04:37', '2024-02-19 06:04:37'),
            -- (242, 'Lab Reportings', 'LAB_REPORTING_SUB', 219, 241, NULL, 'exclamation-square-fill', '1', 'lab-reporting-dashboard', '','2024-02-19 06:04:37', '2024-02-19 06:04:37'),
            -- (243, 'Sample Collections', 'SAMPLE_COLLECTION', 220, 241, NULL, 'exclamation-square-fill', '1', 'sample-collections', '','2024-02-19 06:04:37', '2024-02-19 06:04:37'),
            -- (244, 'Result Update', 'RESULT_UPDATE', 221, 241, NULL, 'exclamation-square-fill', '1', 'result-update', '','2024-02-19 06:04:37', '2024-02-19 06:04:37'),
            -- (245, 'Doctor Reviews', 'DOCTOR_REVIEW', 222, 241, NULL, 'exclamation-square-fill', '1', 'result-update', '','2024-02-19 06:04:37', '2024-02-19 06:04:37'),
            (246, 'Voucher Track Status', 'VOUCHER_TRACK_STATUS', 223, 241, NULL, 'exclamation-square-fill', '1', 'result-update', '','2024-02-19 06:04:37', '2024-02-19 06:04:37'),
            (247, 'Company Images',  'COMPANY_IMAGES',  224,9,NULL,'exclamation-square-fill', '1', '','','2024-04-16 08:32:51', '2024-04-16 08:32:51'),
            -- (248, 'Test Item Template','TEST_ITEM_TEMPLATE',225,73,NULL,'exclamation-square-fill','1',NULL,NULL,'2024-04-19 10:34:07', '2024-04-19 10:34:07'),
            -- (250, 'Room','ROOM',227,142,NULL,'exclamation-square-fill','1','rooms',NULL,'2024-04-29 09:31:39', '2024-04-29 09:31:39' ),
            -- (251, 'Rack Location','RACK_LOCATION',228,21, NULL,'exclamation-square-fill','1','rack-locations',NULL,'2024-04-29 09:32:33', '2024-04-29 09:32:33'),
            -- (252,  'Referral Management', 'REFERRAL_MANAGEMENT', 229,NULL,NULL,'person','1','dr-referral-list','left_menu','2024-04-25 03:42:19', '2024-04-25 03:44:55'),
            /****(253, 'Dr Referral List', 'DR_REFERRAL_LIST', 230,252,NULL,'person','1','dr-referral-list-generate','left_menu','2024-04-25 03:42:19', '2024-04-25 03:44:55'),******/
            (254, 'Voucher Type Terms', 'VOUCHER_TYPE_TERM', 231,6,NULL,'person','1','','top_menu','2024-04-25 03:42:19', '2024-04-25 03:44:55'),
            (255, 'Queue Manager', 'QUEUE_MANAGER', 2,NULL,NULL,'door-open','1','queue-manager','left_menu','2024-04-25 03:42:19', '2024-04-25 03:44:55'),
            (256, 'Meta Mint API', 'METAMINTAPI', 232.00, 167, NULL, 'exclamation-square-fill','1', 'meta-mint-apis', 'top_menu', '2024-06-11 07:19:35', '2024-06-11 07:19:35'),
            (257, 'Sale Return', 'SALE_RETURN', 7,231,NULL,'arrow-counterclockwise','1','sale-return','top_menu','2024-04-25 03:42:19', '2024-04-25 03:44:55'),
            (258, 'Treatment Types', 'TREATMENT_TYPES', 232, 142, NULL,'exclamation-square-fill','1','treatment-types','top_menu','2024-06-26 08:30:59', '2024-06-26 08:41:55'),
            (259, 'Purchase Register', 'PURCHASE', 8,NULL,NULL,'shop','1','purchase','left_menu','2024-04-29 03:42:19', '2024-04-29 03:44:55'),
            (260, 'Product Packaging', 'PRODUCT_PACKAGING', 232,21,NULL,'exclamation-square-fill','1','product-packaging','top_menu','2024-07-03 09:16:38', '2024-07-03 09:16:38'),
            (261, 'Bed Status', 'BED_STATUS', 233,142,NULL,'exclamation-square-fill','1','bed-status','top_menu','2024-07-03 09:16:38', '2024-07-03 09:16:38'),
            (262, 'Inventory & Stock', 'INVENTORY_STOCK', 12,NULL,NULL,'shop','1','inventory-stock','left_menu','2024-04-29 03:42:19', '2024-04-29 03:44:55'),
            (263, 'Stock In', 'STOCK_IN', 235,262,NULL,'shop','1','stock-in','','2024-04-29 03:42:19', '2024-04-29 03:44:55'),
            (264, 'Stock Out', 'STOCK_OUT', 236,262,NULL,'shop','1','stock-out','','2024-04-29 03:42:19', '2024-04-29 03:44:55'),
            (265, 'Stock Movement Type', 'STOCK_MOVEMENT_TYPE', 237,262,NULL,'shop','1','stock-movement-type','','2024-04-29 03:42:19', '2024-04-29 03:44:55'),
            -- (266, 'Nurse-Notes', 'NURSE_NOTES', 238,142,NULL,'exclamation-square-fill','1',NULL,NULL,'2024-07-19 11:15:59', '2024-07-19 11:15:59'),
            (267, 'Referral Vouchers', 'REFERRAL_VOUCHER', 239,NULL,NULL,'exclamation-square-fill','1',NULL,NULL,'2024-07-19 11:15:59', '2024-07-19 11:15:59') ,
            (268, 'Shipping Risk', 'SHIPPING_RISK', 243,6,NULL,'truck','1','shipping-risk','top_menu','2024-08-01 11:54:26', '2024-08-01 11:54:26'),
            (269, 'Reports & Insights', 'REPORTS_AND_INSIGHTS', 13,NULL,NULL,'clipboard-data','1','reports-and-insights','left_menu','2024-08-01 11:54:26', '2024-08-01 11:54:26'),
            -- (270, 'Surgery Types', 'SURGERY_TYPES', 241,NULL,NULL,'exclamation-square-fill','1','surgery-types','top_menu','2024-08-01 11:54:26', '2024-08-01 11:54:26'),
            -- (271, 'Surgeries', 'SURGERIES', 242,NULL,NULL,'exclamation-square-fill','1','ipd-surgeries','top_menu','2024-08-01 11:54:26', '2024-08-01 11:54:26'),
            -- (272, 'Birth Register', 'BIRTH_REGISTER', 243,NULL,NULL,'exclamation-square-fill','1','birth-registers','top_menu','2024-08-01 11:54:26', '2024-08-01 11:54:26'),
            (273, 'Opening Stock', 'OPENING_STOCK', 244,262,NULL,'shop','1','opening-stock','','2024-08-19 03:42:19', '2024-08-19 03:44:55'),
            (274, 'Stock Short List', 'STOCK_SHORT_LIST', 245,262,NULL,'shop','1','stock-short-list','','2024-08-19 03:42:19', '2024-08-19 03:44:55'),
            -- (275, 'Death Register', 'DEATH_REGISTER', 245,262,NULL,'exclamation-square-fill','1','death-registers','','2024-08-19 03:42:19', '2024-08-19 03:44:55'),
            (276, 'User Types', 'USER_TYPES', 246,262,NULL,'exclamation-square-fill','1','user-types','','2024-08-19 03:42:19', '2024-08-19 03:44:55'),
            (277, 'Abdm Apis', 'ABDM_APIS', 246,262,NULL,'exclamation-square-fill','1','abdm-apis','','2024-08-19 03:42:19', '2024-08-19 03:44:55'), 
            (278, 'Abdm Api Calls', 'ABDM_API_CALLS', 246,262,NULL,'exclamation-square-fill','1','abdm-apis','','2024-08-19 03:42:19', '2024-08-19 03:44:55') ,
            (279, 'Letter Heads', 'LETTER_HEADS', 246,262,NULL,'exclamation-square-fill','1','letter-heads','','2024-08-19 03:42:19', '2024-08-19 03:44:55') ,
            (280, 'Task Manager', 'TASK_MANAGER', 247,NULL,NULL,'journal-check','1','task-manager','left_menu','2024-08-19 03:42:19', '2024-08-19 03:44:55') ,
            (281, 'Task Groups', 'TASK_GROUPS', 247,280,NULL,'exclamation-square-fill','1','task-groups','top_menu','2024-08-19 03:42:19', '2024-08-19 03:44:55'),
            (282, 'Pipeline Stages', 'PIPELINE_STAGES', 247,280,NULL,'exclamation-square-fill','1','pipeline-stages','top_menu','2024-08-19 03:42:19', '2024-08-19 03:44:55') ,
            (283, 'Task Teams', 'TASK_TEAMS', 247,280,NULL,'exclamation-square-fill','1','task-teams','top_menu','2024-08-19 03:42:19', '2024-08-19 03:44:55'),
            (284, 'Career Vacancy', 'CAREER_VACANCY', 248,173,NULL,'exclamation-square-fill','1','career-vacancy','top_menu','2024-10-02 08:49:14', '2024-10-02 08:49:14'),
            (285, 'Job Application', 'JOB_APPLICATION', 249,173,NULL,'exclamation-square-fill','1','job-application','top_menu','2024-10-02 13:20:09', '2024-10-02 13:20:09'),
            (286, 'Doubt Sessions', 'DOUBT_SESSIONS', 249,173,NULL,'exclamation-square-fill','1','doubt-sessions','top_menu','2024-10-02 13:20:09', '2024-10-02 13:20:09'),
            (287, 'Bookings Register', 'BOOKING_REGISTER', 1,NULL,NULL,'calendar2-check','1','booking-register','left_menu','2024-10-02 13:20:09', '2024-10-02 13:20:09'),
            (288, 'Shipment Register', 'SHIPMENTS', 2,NULL,NULL,'truck','1','','left_menu','2024-10-02 13:20:09', '2024-10-02 13:20:09'),
            (289, 'Dispatch Register', 'DISPATCH', 3,NULL,NULL,'truck','1','','left_menu','2024-10-02 13:20:09', '2024-10-02 13:20:09'),
            (290, 'Arrival Register', 'ARRIVAL_RECEIVE', 4,NULL,NULL,'box-seam','1','','left_menu','2024-10-02 13:20:09', '2024-10-02 13:20:09'),
            (291, 'Delivery Register', 'DELIVERY', 5,NULL,NULL,'truck','1','','left_menu','2024-10-02 13:20:09', '2024-10-02 13:20:09'),
            (292, 'Vehicle Management', 'VEHICLE_MANAGEMENT', 7,NULL,NULL,'car-front-fill','1','','left_menu','2024-10-02 13:20:09', '2024-10-02 13:20:09'),
            (266, 'Delivery Types', 'DELIVERY_TYPES', 238,6,NULL,'truck','1','delivery-types','top_menu','2024-07-20 11:31:08', '2024-07-22 11:29:51'),
            (293, 'Tax Paid By', 'TAX_PAID_BY', 239,6,NULL,'cash','1','tax-paid-by','top_menu','2024-07-22 05:58:08', '2024-07-22 11:30:54'),
            (294, 'Transportation Mode', 'TRANPORTATION_MODE', 240,6,NULL,'truck','1','transportation-mode','top_menu','2024-07-22 11:13:07', '2024-07-22 11:13:07'),
            (295, 'Rate Calculation Type', 'RATE_CALCULATION_TYPE', 241,6,NULL,'exclamation-square-fill','1','rate-calculation-type','top_menu','2024-07-23 10:07:11', '2024-07-23 10:07:11'),
            (296, 'Shipping Risk', 'SHIPPING_RISK', 243,6,NULL,'truck','1','shipping-risk','top_menu','2024-08-01 11:54:26', '2024-08-01 11:54:26'),
            (297, 'Additional Charges', 'ADDITIONAL_CHARGES', 244,6,NULL,'cash-coin','1','additional-charge','top_menu','2024-08-07 07:55:15', '2024-08-07 07:55:15'),
            (298, 'Fuel Type', 'FUEL_TYPE', 245,6,NULL,'fuel-pump','1','fuel-type','top_menu','2024-08-17 12:18:13', '2024-08-17 12:18:13'),
            (299, 'Container Size', 'CONTAINER_SIZE', 246,6,NULL,'truck','1','container-size','top_menu','2024-09-05 10:48:16', '2024-09-05 10:48:16'),
            (300, 'Container Type', 'CONTAINER_TYPE', 247,6,NULL,'truck','1','container-type','top_menu','2024-09-05 12:32:27', '2024-09-05 12:32:27') ,
            (301, 'Cargo Types', 'CARGO_TYPES', 248,6,NULL,'truck','1','cargo-types','top_menu','2024-09-05 12:32:27', '2024-09-05 12:32:27') ,
            (302, 'Container Return Status', 'CONTAINER_RETURN_STATUS', 249,6,NULL,'truck','1','container-return-status','top_menu','2024-09-05 12:32:27', '2024-09-05 12:32:27') ,
            (303, 'Custom Clearance Status', 'CUSTOM_CLEARANCE_STATUS', 249,6,NULL,'truck','1','custom-clearance-status','top_menu','2024-09-05 12:32:27', '2024-09-05 12:32:27') ,
            (304, 'Consignment Booking Status', 'CONSIGNMENT_BOOKING_STATUS', 250,6,NULL,'truck','1','consignment-booking-status','top_menu','2024-09-05 12:32:27', '2024-09-05 12:32:27'),
            (305, 'Transport Type', 'TRANSPORT_TYPE', 251,6,NULL,'truck','1','transport-type','top_menu','2024-09-09 07:00:14', '2024-09-09 07:00:14');");
    }
}
