<?php

namespace Database\Seeders;

use App\Models\NoticeType;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class NoticeTypeTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        /**
         * Reset the PrimaryUnit table
         */
        // if (\App::environment('local')) {
        //     NoticeType::truncate();
        // }

        $types = [
            [
                'title'      => 'Genral Notice',
                'code'       =>'GENRAL_NOTICE',
                'priority'   => '1',
                'status'     => 1
            ],
        ];

        foreach ($types as $data) {
            NoticeType::firstOrCreate(
                ['code' => $data['code']],
                $data
            );
        }
    }
}
