<?php

namespace Database\Seeders;

use App\Models\OrganizationDepartment;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class OrganizationDepartmentTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $data = [
            [
                'details'   => '',
                'name'      => 'Accounting',
                'code'      => 'ACCOUNTING',
                'priority'  => 1,
                'status'    => 1,
            ],
            [
                'details'  => '',
                'name'     => 'Anesthesiology',
                'code'     => 'ANESTHESIOLOGY',
                'priority' => 2,
                'status'   => 1,
            ],
            [
                'details'  => '',
                'name'     => 'Asset Management',
                'code'     => 'ASSET_MANAGEMENT',
                'priority' => 3,
                'status'   => 1,
            ],
            [
                'details'  => '',
                'name'     => 'Business Administration',
                'code'     => 'BUSINESS_ADMINISTRATION',
                'priority' => 4,
                'status'   => 1,
            ],
            [
                'name'     => 'Corporate Communication',
                'code'     => 'CORPORATE_COMMUNICATIONS',
                'details'  => '',
                'priority' => 5,
                'status'   => 1,
            ],
            [
                'name'     => 'Creativity',
                'code'     => 'CREATIVITY',
                'details'  => '',
                'priority' => 6,
                'status'   => 1,
            ],
            [
                'name'     => 'Customer Service',
                'code'     => 'CUSTOMER_SERVICE',
                'details'  => '',
                'priority' => 7,
                'status'   => 1,
            ],
            [
                'name'     => 'Dermatology',
                'code'     => 'DERMATOLOGY',
                'details'  => '',
                'priority' => 8,
                'status'   => 1,
            ],
            [
                'name'     => 'Distribution',
                'code'     => 'DISTRIBUTION',
                'details'  => '',
                'priority' => 9,
                'status'   => 1,
            ],
            [
                'name'     => 'Division',
                'code'     => 'DIVISION',
                'details'  => '',
                'priority' => 10,
                'status'   => 1,
            ],
            [
                'name'     => 'Emergency Medicine',
                'code'     => 'EMERGENCY_MEDICINE',
                'details'  => '',
                'priority' => 11,
                'status'   => 1,
            ],
            [
                'name'     => 'Engineering',
                'code'     => 'ENGINEERING',
                'details'  => '',
                'priority' => 12,
                'status'   => 1,
            ],
            [
                'name'     => 'Finance',
                'code'     => 'FINANCE',
                'details'  => '',
                'priority' => 13,
                'status'   => 1,
            ],
            [
                'name'     => 'Financial Accounting',
                'code'     => 'FINANCIAL_ACCOUNTING',
                'details'  => '',
                'priority' => 14,
                'status'   => 1,
            ],
            [
                'name'     => 'Gastroenterology',
                'code'     => 'GASTROENTEROLOGY',
                'details'  => '',
                'priority' => 15,
                'status'   => 1,
            ],
            [
                'name'     => 'General Surgery',
                'code'     => 'GENERAL_SURGERY',
                'details'  => '',
                'priority' => 16,
                'status'   => 1,
            ],
            [
                'name'     => 'Human Resources',
                'code'     => 'HUMAN_RESOURCES',
                'details'  => '',
                'priority' => 17,
                'status'   => 1,
            ],
            [
                'name'     => 'Intensive Care Medicine',
                'code'     => 'INTENSIVE_CARE_MEDICINE',
                'details'  => '',
                'priority' => 18,
                'status'   => 1,
            ],
            [
                'name'     => 'Internal Medicine',
                'code'     => 'INTERNAL_MEDICINE',
                'details'  => '',
                'priority' => 19,
                'status'   => 1,
            ],
            [
                'name'     => 'Management',
                'code'     => 'MANAGEMENT',
                'details'  => '',
                'priority' => 20,
                'status'   => 1,
            ],
            [
                'name'     => 'Marketing',
                'code'     => 'MARKETING',
                'details'  => '',
                'priority' => 21,
                'status'   => 1,
            ],
            [
                'name'     => 'Microbiology',
                'code'     => 'MICROBIOLOGY',
                'details'  => '',
                'priority' => 22,
                'status'   => 1,
            ],
            [
                'name'     => 'Nephrology',
                'code'     => 'NEPHROLOGY',
                'details'  => '',
                'priority' => 23,
                'status'   => 1,
            ],
            [
                'name'     => 'Neurology',
                'code'     => 'NEUROLOGY',
                'details'  => '',
                'priority' => 24,
                'status'   => 1,
            ],
            [
                'name'     => 'Neurosurgery',
                'code'     => 'NEUROSURGERY',
                'details'  => '',
                'priority' => 25,
                'status'   => 1,
            ],
            [
                'name'     => 'New Product Development',
                'code'     => 'NEW_PRODUCT_DEVELOPMENT',
                'details'  => '',
                'priority' => 26,
                'status'   => 1,
            ],
            [
                'name'     => 'Obstetrics And Gynecology',
                'code'     => 'OBSTETRICS_AND_GYNECOLOGY',
                'details'  => '',
                'priority' => 27,
                'status'   => 1,
            ],
            [
                'name'     => 'Operations Management',
                'code'     => 'OPERATIONS_MANAGEMENT',
                'details'  => '',
                'priority' => 28,
                'status'   => 1,
            ],
            [
                'name'     => 'Ophthalmology',
                'code'     => 'OPHTHALMOLOGY',
                'details'  => '',
                'priority' => 29,
                'status'   => 1,
            ],
            [
                'name'     => 'Orthopedics',
                'code'     => 'ORTHOPEDICS',
                'details'  => '',
                'priority' => 30,
                'status'   => 1,
            ],
            [
                'name'     => 'Otorhinolaryngology',
                'code'     => 'OTORHINOLARYNGOLOGY',
                'details'  => '',
                'priority' => 31,
                'status'   => 1,
            ],
            [
                'name'     => 'Pathology',
                'code'     => 'PATHOLOGY',
                'details'  => '',
                'priority' => 32,
                'status'   => 1,
            ],
            [
                'name'     => 'Pediatrics',
                'code'     => 'PEDIATRICS',
                'details'  => '',
                'priority' => 33,
                'status'   => 1,
            ],
            [
                'name'     => 'Production',
                'code'     => 'PRODUCTION',
                'details'  => '',
                'priority' => 34,
                'status'   => 1,
            ],
            [
                'name'     => 'Psychiatry',
                'code'     => 'PSYCHIATRY',
                'details'  => '',
                'priority' => 35,
                'status'   => 1,
            ],
            [
                'name'     => 'Pulmonology',
                'code'     => 'PULMONOLOGY',
                'details'  => '',
                'priority' => 36,
                'status'   => 1,
            ],
            [
                'name'     => 'Purchasing',
                'code'     => 'PURCHASING',
                'details'  => '',
                'priority' => 37,
                'status'   => 1,
            ],
            [
                'name'     => 'Pulmonology',
                'code'     => 'PULMONOLOGY',
                'details'  => '',
                'priority' => 38,
                'status'   => 1,
            ],
            [
                'name'     => 'Purchasing',
                'code'     => 'PURCHASING',
                'details'  => '',
                'priority' => 39,
                'status'   => 1,
            ],
            [
                'name'     => 'Quality Assurance',
                'code'     => 'QUALITY_ASSURANCE',
                'details'  => '',
                'priority' => 40,
                'status'   => 1,
            ],
            [
                'name'     => 'Quality Management',
                'code'     => 'QUALITY_MANAGEMENT',
                'details'  => '',
                'priority' => 41,
                'status'   => 1,
            ],
            [
                'name'     => 'Radiology',
                'code'     => 'RADIOLOGY',
                'details'  => '',
                'priority' => 42,
                'status'   => 1,
            ],
            [
                'name'     => 'Research And Development',
                'code'     => 'RESEARCH_AND_DEVELOPMENT',
                'details'  => '',
                'priority' => 43,
                'status'   => 1,
            ],
            [
                'name'     => 'Rheumatology',
                'code'     => 'RHEUMATOLOGY',
                'details'  => '',
                'priority' => 44,
                'status'   => 1,
            ],
            [
                'name'     => 'Sales',
                'code'     => 'SALES',
                'details'  => '',
                'priority' => 45,
                'status'   => 1,
            ],
            [
                'name'     => 'Surgery',
                'code'     => 'SURGERY',
                'details'  => '',
                'priority' => 46,
                'status'   => 1,
            ],
            [
                'name'     => 'Urology',
                'code'     => 'UROLOGY',
                'details'  => '',
                'priority' => 47,
                'status'   => 1,
            ],
        ];

        foreach ($data as $value) {
            OrganizationDepartment::firstOrCreate(
                ['code' => $value['code']],
                $value
            );
        }
    }
}
