<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\CompanyEstablishmentType;

class OrganizationTypesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $organization_types = [
            [
                "name" => "Sole Proprietorship",
                "code" => "SOLE_PROPRIETORSHIP"
            ],
            [
                "name" => "Partnership",
                "code" => "PARTNERSHIP"
            ],
            [
                "name" => "Limited Liability Partnership (LLP)",
                "code" => "LIMITED_LIABILITY_PARTNERSHIP_(LLP)"
            ],
            [
                "name" => "Private Limited Company",
                "code" => "PRIVATE_LIMITED_COMPANY"
            ],
            [
                "name" => "Public Limited Company",
                "code" => "PUBLIC_LIMITED_COMPANY"
            ],
            [
                "name" => "One Person Company (OPC)",
                "code" => "ONE_PERSON_COMPANY_(OPC)"
            ],
            [
                "name" => "Section 8 Company (Non-Profit)",
                "code" => "SECTION_8_COMPANY_(NON-PROFIT)"
            ],
            [
                "name" => "Producer Company",
                "code" => "PRODUCER_COMPANY"
            ],
            [
                "name" => "Cooperative Society",
                "code" => "COOPERATIVE_SOCIETY"
            ],
            [
                "name" => "HUF-Hindu Undivided Family",
                "code" => "HUF-HINDU_UNDIVIDED_FAMILY"
            ]
        ];

        foreach ($organization_types as $value) {
            CompanyEstablishmentType::firstOrCreate(
                ['code' => $value['code']],
                $value
            );
        }
    }
}
