<?php

namespace Database\Seeders;

use App\Models\AccountingGroup;
use App\Models\PaymentMode;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class PaymentModeTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // if (\App::environment('local')) {
        //     PaymentMode::truncate();
        // }

        $groups_cash = AccountingGroup::where('name','Cash in Hand')->first();
        $groups = AccountingGroup::where('name','Bank Account')->first();

        $paymentModes = [

            [
                'mode'                => 'Cash',
                'code'                => 'CASH',
                'is_default'          => 1,
                'priority'            => 1,
                'accounting_group_id' => $groups_cash->id,
            ],
            [
                'mode'                => 'NEFT/RTGS',
                'code'                => 'NEFT_RTGS',
                'is_default'          => 1,
                'priority'            => 2,
                'accounting_group_id' => $groups->id,
            ],
            [
                'mode'                => 'Cheque',
                'code'                => 'CHEQUE',
                'is_default'          => 0,
                'priority'            => 3,
                'accounting_group_id' => $groups->id,
            ],
            [
                'mode'                => 'UPI',
                'code'                => 'UPI',
                'is_default'          => 0,
                'priority'            => 4,
                'accounting_group_id' => $groups->id,
            ],
            [
                'mode'                => 'Payment Gateway',
                'code'                => 'PAYMENT_GATEWAY',
                'is_default'          => 0,
                'priority'            => 5,
                'accounting_group_id' => $groups->id,
            ],
            [
                'mode'                => 'Other',
                'code'                => 'OTHERS',
                'is_default'          => 0,
                'priority'            => 6,
                'accounting_group_id' => $groups->id,
            ],
        ];

        foreach ($paymentModes as $value) {
            PaymentMode::firstOrCreate(
                ['code' => $value['code']],
                $value
            );
        }
    }
}
