<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\PaymentTerm;

class PaymentTermsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $paymentTerms = [
            [
                'payment_term_name' => 'CREDIT',
                'code'              => 'CREDIT',
                'details'           => 'any description if available',
                'priority'          => 1,
                'status'            => 1,
                'is_default'        => 1
            ],
            [
                'payment_term_name' => 'PAID',
                'code'              => 'PAID',
                'details'           => null,
                'priority'          => 2,
                'status'            => 1,
                'is_default'        => 0
            ],
            [
                'payment_term_name' => 'TO PAY',
                'code'              => 'TO_PAY',
                'details'           => null,
                'priority'          => 3,
                'status'            => 1,
                'is_default'        => 0
            ],
            [
                'payment_term_name' => 'TO BE BILLED',
                'code'              => 'TO_BE_BILLED',
                'details'           => null,
                'priority'          => 4,
                'status'            => 1,
                'is_default'        => 0
            ],
            [
                'payment_term_name' => 'IMMEDIATE AGAINST SHIPMENT',
                'code'              => 'IMMEDIATE_AGAINST_SHIPMENT',
                'details'           => null,
                'priority'          => 5,
                'status'            => 1,
                'is_default'        => 0
            ],
        ];

        foreach ($paymentTerms as $value) {
            PaymentTerm::firstOrCreate(
                ['code' => $value['code']],
                $value
            );
        }
    }
}
