<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\PipelineStage;

class PipelineStagesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        if (\App::environment('local')) {
            PipelineStage::truncate();
        }

        $data = [
            [
                'name'          => 'Pending' ,
                'task_group_id' => '1' ,
                'sequence'      => '1'
            ],
            [
                'name'          => 'Backlog' ,
                'task_group_id' => '1' ,
                'sequence'      => '2'
            ],
            [
                'name'          => 'To Do', 
                'task_group_id' => '1' ,
                'sequence'      => '3'
            ],
            [
               'name'          =>  'In Progress',
               'task_group_id' =>  '1' ,
               'sequence'      =>  '4'
            ],
            [
                'name'          =>  'Review' ,
                'task_group_id' =>  '1' ,
                'sequence'      =>  '5'
            ],
            [
                'name'          =>  'Completed' ,
                'task_group_id' =>  '1' ,
                'sequence'      =>  '6'
            ] 
        ];

        foreach ($data as $key => $value) {
            PipelineStage::firstOrCreate($value);
        }
    }
}
