<?php

namespace Database\Seeders;

use App\Models\IndustryType;
use App\Models\MenuModelPermission;
use App\Models\PlaneAndPackages;
use App\Models\PlanModuleMapping;
use App\Models\PlanProductMapping;
use App\Models\Product;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class PlanAndPackagesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
    *
     * @return void
     */
    public function run()
    {
        // getting industry type  id
        $industry = IndustryType::find(1);
        $PlaneAndPackages = [
            'plan_name'        => 'Meta Mint',
            'industry_type_id' =>  $industry->id,
            'plan_code'        => 'METAMINT',
            'features_details' => null,
            'created_at'       => now(),
            'updated_at'       => now(),
        ];

        // creating plan and packages
        $PlaneAndPackagesData =    PlaneAndPackages::firstOrCreate(
            ['plan_name' => $PlaneAndPackages['plan_name']],
            $PlaneAndPackages
        );

        // creating PlanModuleMapping in foreach loop
        $moduleCodes = MenuModelPermission::with('parentModule')->get();

        foreach ($moduleCodes as $key => $value) {
            $data = [
                'plan_id'            => $PlaneAndPackagesData->id,
                'module_code'        => $value->code,
                'parent_module_code' => $value->parentModule->code ?? '',
                'priority'           => +1,
                'status'             => 1,
            ];

            PlanModuleMapping::firstOrCreate(
                ['module_code' => $data['module_code']],
                $data
            );
        }


    }
}
