<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\PrimaryUnit;

class PrimaryUnitTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        /**
         * Reset the PrimaryUnit table
         */
        // if (\App::environment('local')) {
        //     PrimaryUnit::truncate();
        // }

        $types = [

            [
                'name'       => 'Pieces',
                'unit_type'  => 'Measure',
                'code'       => 'PCS',
                'is_default' => '1',
            ],
            [
                'name'       => 'Bags',
                'unit_type'  => 'Measure',
                'code'       => 'BAG',
                'is_default' => '0',
            ],
            [
                'name'       => 'Bale',
                'unit_type'  => 'Measure',
                'code'       => 'BAL',
                'is_default' => '0',
            ],
            [
                'name'       => 'Bundles',
                'unit_type'  => 'Measure',
                'code'       => 'BDL',
                'is_default' => '0',
            ],
            [
                'name'       => 'Buckles',
                'unit_type'  => 'Measure',
                'code'       => 'BKL',
                'is_default' => '0',
            ],
            [
                'name'       => 'Billion Of Units',
                'unit_type'  => 'Measure',
                'code'       => 'BOU',
                'is_default' => '0',
            ],
            [
                'name'       => 'Box',
                'unit_type'  => 'Measure',
                'code'       => 'BOX',
                'is_default' => '0',
            ],
            [
                'name'       => 'Bottles',
                'unit_type'  => 'Measure',
                'code'       => 'BTL',
                'is_default' => '0',
            ],
            [
                'name'       => 'Bunches',
                'unit_type'  => 'Measure',
                'code'       => 'BUN',
                'is_default' => '0',
            ],
            [
                'name'       => 'Cans',
                'unit_type'  => 'Measure',
                'code'       => 'CAN',
                'is_default' => '0',
            ],
            [
                'name'       => 'Cubic Meters',
                'unit_type'  => 'Volume',
                'code'       => 'CBM',
                'is_default' => '0',
            ],
            [
                'name'       => 'Cubic Centimeters',
                'unit_type'  => 'Volume',
                'code'       => 'CCM',
                'is_default' => '0',
            ],
            [
                'name'       => 'Centi Meters',
                'unit_type'  => 'Volume',
                'code'       => 'CMS',
                'is_default' => '0',
            ],
            [
                'name'       => 'Cartons',
                'unit_type'  => 'Measure',
                'code'       => 'CTN',
                'is_default' => '0',
            ],
            [
                'name'       => 'Dozens',
                'unit_type'  => 'Measure',
                'code'       => 'DOZ',
                'is_default' => '0',
            ],
            [
                'name'       => 'Drums',
                'unit_type'  => 'Measure',
                'code'       => 'DRM',
                'is_default' => '0',
            ],
            [
                'name'       => 'Great Gross',
                'unit_type'  => 'Measure',
                'code'       => 'GGK',
                'is_default' => '0',
            ],
            [
                'name'       => 'Grammes',
                'unit_type'  => 'Weight',
                'code'       => 'GMS',
                'is_default' => '0',
            ],
            [
                'name'       => 'Gross',
                'unit_type'  => 'Measure',
                'code'       => 'GRS',
                'is_default' => '0',
            ],
            [
                'name'       => 'Gross Yards',
                'unit_type'  => 'Length',
                'code'       => 'GYD',
                'is_default' => '0',
            ],
            [
                'name'       => 'Kilograms',
                'unit_type'  => 'Weight',
                'code'       => 'KGS',
                'is_default' => '0',
            ],
            [
                'name'       => 'Kilolitre',
                'unit_type'  => 'Length',
                'code'       => 'KLR',
                'is_default' => '0',
            ],
            [
                'name'       => 'Kilometre',
                'unit_type'  => 'Length',
                'code'       => 'KME',
                'is_default' => '0',
            ],
            [
                'name'       => 'Litres',
                'unit_type'  => 'Volume ',
                'code'       => 'LTR',
                'is_default' => '0',
            ],
            [
                'name'       => 'Meters',
                'unit_type'  => 'Length',
                'code'       => 'MTR',
                'is_default' => '0',
            ],
            [
                'name'       => 'Mililitre',
                'unit_type'  => 'Volume ',
                'code'       => 'MLT',
                'is_default' => '0',
            ],
            [
                'name'       => 'Metric Ton',
                'unit_type'  => 'Weight',
                'code'       => 'MTS',
                'is_default' => '0',
            ],
            [
                'name'       => 'Numbers',
                'unit_type'  => 'Measure',
                'code'       => 'NOS',
                'is_default' => '0',
            ],
            [
                'name'       => 'Others',
                'unit_type'  => 'Others',
                'code'       => 'OTH',
                'is_default' => '0',
            ],
            [
                'name'       => 'Packs',
                'unit_type'  => 'Measure',
                'code'       => 'PAC',
                'is_default' => '0',
            ],
            [
                'name'       => 'Pairs',
                'unit_type'  => 'Measure',
                'code'       => 'PRS',
                'is_default' => '0',
            ],
            [
                'name'       => 'Quintal',
                'unit_type'  => 'Weight',
                'code'       => 'QTL',
                'is_default' => '0',
            ],
            [
                'name'       => 'Rolls',
                'unit_type'  => 'Measure',
                'code'       => 'ROL',
                'is_default' => '0',
            ],
            [
                'name'       => 'Sets',
                'unit_type'  => 'Measure',
                'code'       => 'SET',
                'is_default' => '0',
            ],
            [
                'name'       => 'Square Feet',
                'unit_type'  => 'Area',
                'code'       => 'SQF',
                'is_default' => '0',
            ],
            [
                'name'       => 'Square Meters',
                'unit_type'  => 'Area',
                'code'       => 'SQM',
                'is_default' => '0',
            ],
            [
                'name'       => 'Square Yards',
                'unit_type'  => 'Area',
                'code'       => 'SQY',
                'is_default' => '0',
            ],
            [
                'name'       => 'Tablets',
                'unit_type'  => 'Measure',
                'code'       => 'TBS',
                'is_default' => '0',
            ],
            [
                'name'       => 'Ten Gross',
                'unit_type'  => 'Measure',
                'code'       => 'TGM',
                'is_default' => '0',
            ],
            [
                'name'       => 'Thousands',
                'unit_type'  => 'Measure',
                'code'       => 'THD',
                'is_default' => '0',
            ],
            [
                'name'       => 'Tonnes',
                'unit_type'  => 'Weight',
                'code'       => 'TON',
                'is_default' => '0',
            ],
            [
                'name'       => 'Tubes',
                'unit_type'  => 'Measure',
                'code'       => 'TUB',
                'is_default' => '0',
            ],
            [
                'name'       => 'Us Gallons',
                'unit_type'  => 'Volume ',
                'code'       => 'UGS',
                'is_default' => '0',
            ],
            [
                'name'       => 'Units',
                'unit_type'  => 'Measure',
                'code'       => 'UNT',
                'is_default' => '0',
            ],
            [
                'name'       => 'Yards',
                'unit_type'  => 'Length',
                'code'       => 'YDS',
                'is_default' => '0',
            ],
            [
                'name'       => 'Day',
                'unit_type'  => 'Duration',
                'code'       => 'DAY',
                'is_default' => '0',
            ],
        ];

        foreach ($types as $value) {
            PrimaryUnit::firstOrCreate(['code' => $value['code']], $value);
        }
    }
}
