<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\ProductAlternativeUnit;

class ProductAlternativeUnitTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        /**
         * Reset the PrimaryUnit table
         */
        // if (\App::environment('local')) {
        //     ProductAlternativeUnit::truncate();
        // }

        $types = [
            [
                'name'            => 'Pieces',
                'code'            => 'PCS',
                'unit_type'       => 'Measure',
                'priority'        => '1',
                'primary_unit_id' => '1',
                'is_default'      => '1',
            ],
            [
                'name'            => 'Bags',
                'code'            => 'BAG',
                'unit_type'       => 'Measure',
                'priority'        => '2',
                'primary_unit_id' => '2',
                'is_default'      => '0',
            ],
            [
                'name'            => 'Bale',
                'code'            => 'BAL',
                'unit_type'       => 'Measure',
                'priority'        => '3',
                'primary_unit_id' => '3',
                'is_default'      => '0',
            ],
            [
                'name'            => 'Bundles',
                'code'            => 'BDL',
                'unit_type'       => 'Measure',
                'priority'        => '4',
                'primary_unit_id' => '4',
                'is_default'      => '0',
            ],
            [
                'name'            => 'Buckles',
                'code'            => 'BKL',
                'unit_type'       => 'Measure',
                'priority'        => '5',
                'primary_unit_id' => '5',
                'is_default'      => '0',
            ],
            [
                'name'            => 'Billion Of Units',
                'code'            => 'BOU',
                'unit_type'       => 'Measure',
                'priority'        => '6',
                'primary_unit_id' => '6',
                'is_default'      => '0',
            ],
            [
                'name'            => 'Box',
                'code'            => 'BOX',
                'unit_type'       => 'Measure',
                'priority'        => '7',
                'primary_unit_id' => '7',
                'is_default'      => '0',
            ],
            [
                'name'            => 'Bottles',
                'code'            => 'BTL',
                'unit_type'       => 'Measure',
                'priority'        => '8',
                'primary_unit_id' => '8',
                'is_default'      => '0',
            ],
            [
                'name'            => 'Bunches',
                'code'            => 'BUN',
                'unit_type'       => 'Measure',
                'priority'        => '9',
                'primary_unit_id' => '9',
                'is_default'      => '0',
            ],
            [
                'name'            => 'Cans',
                'code'            => 'CAN',
                'unit_type'       => 'Measure',
                'priority'        => '10',
                'primary_unit_id' => '10',
                'is_default'      => '0',
            ],
            [
                'name'            => 'Cubic Meters',
                'code'            => 'CBM',
                'unit_type'       => 'Volume',
                'priority'        => '11',
                'primary_unit_id' => '11',
                'is_default'      => '0',
            ],
            [
                'name'            => 'Cubic Centimeters',
                'code'            => 'CCM',
                'unit_type'       => 'Volume',
                'priority'        => '12',
                'primary_unit_id' => '12',
                'is_default'      => '0',
            ],
            [
                'name'            => 'Centi Meters',
                'code'            => 'CMS',
                'unit_type'       => 'Volume',
                'priority'        => '13',
                'primary_unit_id' => '13',
                'is_default'      => '0',
            ],
            [
                'name'            => 'Cartons',
                'code'            => 'CTN',
                'unit_type'       => 'Measure',
                'priority'        => '14',
                'primary_unit_id' => '14',
                'is_default'      => '0',
            ],
            [
                'name'            => 'Dozens',
                'code'            => 'DOZ',
                'unit_type'       => 'Measure',
                'priority'        => '15',
                'primary_unit_id' => '15',
                'is_default'      => '0',
            ],
            [
                'name'            => 'Drums',
                'code'            => 'DRM',
                'unit_type'       => 'Measure',
                'priority'        => '16',
                'primary_unit_id' => '16',
                'is_default'      => '0',
            ],
            [
                'name'            => 'Great Gross',
                'code'            => 'GGK',
                'unit_type'       => 'Measure',
                'priority'        => '17',
                'primary_unit_id' => '17',
                'is_default'      => '0',
            ],
            [
                  'name'            => 'Grammes',
                  'code'            => 'GMS',
                  'unit_type'       => 'Weight',
                  'priority'        => '18',
                  'primary_unit_id' => '18',
                  'is_default'      => '0',
            ],
            [
                 'name'            => 'Gross',
                 'code'            => 'GRS',
                 'unit_type'       => 'Measure',
                 'priority'        => '19',
                 'primary_unit_id' => '19',
                 'is_default'      => '0',
            ],
            [
                 'name'            => 'Gross Yards',
                 'code'            => 'GYD',
                 'unit_type'       => 'Length',
                 'priority'        => '20',
                 'primary_unit_id' => '20',
                 'is_default'      => '0',
            ],
            [
                 'name'            => 'Kilograms',
                 'code'            => 'KGS',
                 'unit_type'       => 'Weight',
                 'priority'        => '21',
                 'primary_unit_id' => '21',
                 'is_default'      => '0',
            ],
            [
                  'name'            => 'Kilolitre',
                  'code'            => 'KLR',
                  'unit_type'       => 'Length',
                  'priority'        => '22',
                  'primary_unit_id' => '22',
                  'is_default'      => '0',
            ],
            [
                 'name'            => 'Kilometre',
                 'code'            => 'KME',
                 'unit_type'       => 'Length',
                 'priority'        => '23',
                 'primary_unit_id' => '23',
                 'is_default'      => '0',
            ],
            [
                 'name'            => 'Litres',
                 'code'            => 'LTR',
                 'unit_type'       => 'Volume ',
                 'priority'        => '24',
                 'primary_unit_id' => '24',
                 'is_default'      => '0',
            ],
            [
               'name'            => 'Meters',
               'code'            => 'MTR',
               'unit_type'       => 'Length',
               'priority'        => '25',
               'primary_unit_id' => '25',
               'is_default'      => '0',
            ],
            [
                'name'            => 'Mililitre',
                'code'            => 'MLT',
                'unit_type'       => 'Volume ',
                'priority'        => '26',
                'primary_unit_id' => '26',
                'is_default'      => '0',
            ],
            [
                 'name'            => 'Metric Ton',
                 'code'            => 'MTS',
                 'unit_type'       => 'Weight',
                 'priority'        => '27',
                 'primary_unit_id' => '27',
                 'is_default'      => '0',
            ],
            [
                'name'            => 'Numbers',
                'code'            => 'NOS',
                'unit_type'       => 'Measure',
                'priority'        => '28',
                'primary_unit_id' => '28',
                'is_default'      => '0',
            ],
            [
                'name'            => 'Others',
                'code'            => 'OTH',
                'unit_type'       => 'Others',
                'priority'        => '29',
                'primary_unit_id' => '29',
                'is_default'      => '0',
            ],
            [
              'name'            => 'Packs',
              'code'            => 'PAC',
              'unit_type'       => 'Measure',
              'priority'        => '30',
              'primary_unit_id' => '30',
              'is_default'      => '0',
            ],
            [
                'name'            => 'Pairs',
                'code'            => 'PRS',
                'unit_type'       => 'Measure',
                'priority'        => '31',
                'primary_unit_id' => '31',
                'is_default'      => '0',
            ],
            [
                'name'            => 'Quintal',
                'code'            => 'QTL',
                'unit_type'       => 'Weight',
                'priority'        => '32',
                'primary_unit_id' => '32',
                'is_default'      => '0',
            ],
            [
                 'name'            => 'Rolls',
                 'code'            => 'ROL',
                 'unit_type'       => 'Measure',
                 'priority'        => '33',
                 'primary_unit_id' => '33',
                 'is_default'      => '0',
            ],
            [
                 'name'            => 'Sets',
                 'code'            => 'SET',
                 'unit_type'       => 'Measure',
                 'priority'        => '34',
                 'primary_unit_id' => '34',
                 'is_default'      => '0',
            ],
            [
               'name'            => 'Square Feet',
               'code'            => 'SQF',
               'unit_type'       => 'Area',
               'priority'        => '35',
               'primary_unit_id' => '35',
               'is_default'      => '0',
            ],
            [
               'name'            => 'Square Meters',
               'code'            => 'SQM',
               'unit_type'       => 'Area',
               'priority'        => '36',
               'primary_unit_id' => '36',
               'is_default'      => '0',
            ],
            [
               'name'            => 'Square Yards',
               'code'            => 'SQY',
               'unit_type'       => 'Area',
               'priority'        => '37',
               'primary_unit_id' => '37',
               'is_default'      => '0',
            ],
            [
              'name'            => 'Tablets',
              'code'            => 'TBS',
              'unit_type'       => 'Measure',
              'priority'        => '38',
              'primary_unit_id' => '38',
              'is_default'      => '0',
            ],
            [
              'name'            => 'Ten Gross',
              'code'            => 'TGM',
              'unit_type'       => 'Measure',
              'priority'        => '39',
              'primary_unit_id' => '39',
              'is_default'      => '0',
            ],
            [
              'name'            => 'Thousands',
              'code'            => 'THD',
              'unit_type'       => 'Measure',
              'priority'        => '40',
              'primary_unit_id' => '40',
              'is_default'      => '0',
            ],
            [
             'name'            => 'Tonnes',
             'code'            => 'TON',
             'unit_type'       => 'Weight',
             'priority'        => '41',
             'primary_unit_id' => '41',
             'is_default'      => '0',
            ],
            [
                'name'            => 'Tubes',
                'code'            => 'TUB',
                'unit_type'       => 'Measure',
                'priority'        => '42',
                'primary_unit_id' => '42',
                'is_default'      => '0',
            ],
            [
                'name'            => 'Us Gallons',
                'code'            => 'UGS',
                'unit_type'       => 'Volume ',
                'priority'        => '43',
                'primary_unit_id' => '43',
                'is_default'      => '0',
            ],
            [
                'name'            => 'Units',
                'code'            => 'UNT',
                'unit_type'       => 'Measure',
                'priority'        => '44',
                'primary_unit_id' => '44',
                'is_default'      => '0',
            ],
            [
                'name'            => 'Yards',
                'code'            => 'YDS',
                'unit_type'       => 'Length',
                'priority'        => '45',
                'primary_unit_id' => '45',
                'is_default'      => '0',
            ],
            [
                'name'            => 'Hour',
                'code'            => 'HOUR',
                'unit_type'       => 'Duration',
                'priority'        => '46',
                'primary_unit_id' => '46',
                'is_default'      => '0',
            ],
        ];

        foreach ($types as $value) {
            ProductAlternativeUnit::firstOrCreate(['code' => $value['code']], $value);
        }
    }
}
