<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\ProductItemType;

class ProductItemTypesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        /**
         * Reset the ProductItemType table
         */
        // if (\App::environment('local')) {
        //     ProductItemType::truncate();
        // }

        $types = [
            [
                'name'       => 'PRODUCT',
                'code'       =>'PRODUCT',
                'priority'   => '1',
                'status'     => '1',
                'is_default' => '1',
            ],
            [
                'name'       => 'SERVICE',
                'code'       =>'SERVICE',
                'priority'   => '2',
                'status'     => '1',
                'is_default' => '0',
            ],
            [
                'name'       => 'BOOKS',
                'code'       =>'BOOKS',
                'priority'   => '3',
                'status'     => '1',
                'is_default' => '0',
            ],
            [
                'name'       => 'RAW MATERIAL',
                'code'       =>'RAW_MATERIAL',
                'priority'   => '4',
                'status'     => '1',
                'is_default' => '0',
            ],
        ];

        foreach ($types as $value) {
            ProductItemType::firstOrCreate(
                ['code' => $value['code']],
                $value
            );
        }
    }
}
