<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Product;
use App\Models\ProductPrice;

class ProductsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        if (\App::environment('local')) {
            Product::truncate();
            ProductPrice::truncate();
        }

        $products =
            [
                [
                    "name" => "TOTAL LEUCOCYTE COUNT (TLC)",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "TLC",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "TOTAL_LEUCOCYTE_COUNT_(TLC)"
                ],
                [
                    "name" => "DIFFERENTIAL LEUCOCYTE COUNT",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "DLC",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "DIFFERENTIAL_LEUCOCYTE_COUNT"
                ],
                [
                    "name" => "ERYTHRO SEDIMENTATION RATE (ESR)",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "ESR",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "ERYTHRO_SEDIMENTATION_RATE_(ESR)"
                ],
                [
                    "name" => "HB%",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "HB",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "HB%"
                ],
                [
                    "name" => "BT, CT",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "BT,CT",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "BT,_CT"
                ],
                [
                    "name" => "BLOOD RE (Hb%, TC, DC, ESR)",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "BLOOD RE",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "BLOOD_RE_(HB%,_TC,_DC,_ESR)"
                ],
                [
                    "name" => "HbsAg",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "HBSAG"
                ],
                [
                    "name" => "Anti HCV",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "HCV",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "ANTI_HCV"
                ],
                [
                    "name" => "HIV I & II",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "HIV_I_&_II"
                ],
                [
                    "name" => "MP(Optimal)",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "MP(OPTIMAL)"
                ],
                [
                    "name" => "WIDAL Test",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "WIDAL_TEST"
                ],
                [
                    "name" => "Typhidot -Igm",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "TYPHIDOT_-IGM"
                ],
                [
                    "name" => "Urea",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "ur",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "UREA"
                ],
                [
                    "name" => "Creatinine",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "cr",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "CREATININE"
                ],
                [
                    "name" => "Uric Acid",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "URIC_ACID"
                ],
                [
                    "name" => "LFT",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "LFT"
                ],
                [
                    "name" => "Serum Bilirubin (Total)",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "SERUM_BILIRUBIN_(TOTAL)"
                ],
                [
                    "name" => "Bilirubin Direct",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "BILIRUBIN_DIRECT"
                ],
                [
                    "name" => "Bilirubin (T+D+IND)",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "BILIRUBIN_(T+D+IND)"
                ],
                [
                    "name" => "SGOT (Ast)",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "SGOT_(AST)"
                ],
                [
                    "name" => "SGPT (ALT)",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "SGPT_(ALT)"
                ],
                [
                    "name" => "Serum Alkaline Phospatase(ALP)",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "ALP",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "SERUM_ALKALINE_PHOSPATASE(ALP)"
                ],
                [
                    "name" => "Total Protein",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "TOTAL_PROTEIN"
                ],
                [
                    "name" => "ALB/ ALBUMIN",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "ALB/_ALBUMIN"
                ],
                [
                    "name" => "GLB/ GLOBUIN",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "GLB/_GLOBUIN"
                ],
                [
                    "name" => "Protein + ALB+ GLB (A:G Ratio)",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "PROTEIN_+_ALB+_GLB_(A:G_RATIO)"
                ],
                [
                    "name" => "Lipid Profile",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "LIPID_PROFILE"
                ],
                [
                    "name" => "Serum Cholesterol",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "Chol",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "SERUM_CHOLESTEROL"
                ],
                [
                    "name" => "Serum Tryglyceride",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "Tg",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "SERUM_TRYGLYCERIDE"
                ],
                [
                    "name" => "HDL",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "HDL"
                ],
                [
                    "name" => "LDL",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "LDL"
                ],
                [
                    "name" => "VLDL",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "VLDL"
                ],
                [
                    "name" => "Urine RE",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "URINE_RE"
                ],
                [
                    "name" => "Blood Sugar (F)",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "FBS",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "BLOOD_SUGAR_(F)"
                ],
                [
                    "name" => "Blood Sugar (PP)",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "PPBS",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "BLOOD_SUGAR_(PP)"
                ],
                [
                    "name" => "Platelet Count",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "PLATELET_COUNT"
                ],
                [
                    "name" => "ABSOLUTE EOSINOPHIL COUNT",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "AEC",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "ABSOLUTE_EOSINOPHIL_COUNT"
                ],
                [
                    "name" => "Stool RE",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "STOOL_RE"
                ],
                [
                    "name" => "Stool OBT",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "STOOL_OBT"
                ],
                [
                    "name" => "Stool Reducing Sugar",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "STOOL_REDUCING_SUGAR"
                ],
                [
                    "name" => "ASO Titre",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "ASO_TITRE"
                ],
                [
                    "name" => "RA FACTOR",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "RA_FACTOR"
                ],
                [
                    "name" => "CRP",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "CRP",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "CRP"
                ],
                [
                    "name" => "Trop-T",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "TROP-T"
                ],
                [
                    "name" => "Trop-I",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "TROP-I"
                ],
                [
                    "name" => " Amylase",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "_AMYLASE"
                ],
                [
                    "name" => "Lipase",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "LIPASE"
                ],
                [
                    "name" => "Sodium (Na+)",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "NA",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "SODIUM_(NA+)"
                ],
                [
                    "name" => "Potassium (K+)",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "K",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "POTASSIUM_(K+)"
                ],
                [
                    "name" => "Chloride",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "CL",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "CHLORIDE"
                ],
                [
                    "name" => "CALCIUM",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "CA",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "CALCIUM"
                ],
                [
                    "name" => "ABORH (Blood Grouping)",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "ABORH_(BLOOD_GROUPING)"
                ],
                [
                    "name" => "CBC",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "CBC",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "CBC"
                ],
                [
                    "name" => "GGT",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "GGT"
                ],
                [
                    "name" => "Urine SUGAR",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "URINE_SUGAR"
                ],
                [
                    "name" => "Ketone Bodies",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "KETONE_BODIES"
                ],
                [
                    "name" => "Semen Analysis",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "SEMEN_ANALYSIS"
                ],
                [
                    "name" => "MT Test",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "mountox",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "MT_TEST"
                ],
                [
                    "name" => "PBS",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "PBS"
                ],
                [
                    "name" => "Urine Bilesalt and Pigment",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "URINE_BILESALT_AND_PIGMENT"
                ],
                [
                    "name" => "Urine for HCG",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "Urine preg. test",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "URINE_FOR_HCG"
                ],
                [
                    "name" => "VDRL",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "VDRL"
                ],
                [
                    "name" => "T3, T4, TSH",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "T3,_T4,_TSH"
                ],
                [
                    "name" => "FT3",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "FT3"
                ],
                [
                    "name" => "FT4",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "FT4"
                ],
                [
                    "name" => "FT3, FT4, TSH",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "FT3,_FT4,_TSH"
                ],
                [
                    "name" => "HbA1C",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "HBA1C"
                ],
                [
                    "name" => "Urine ACR (U-ACR)",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "U-ACR",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "URINE_ACR_(U-ACR)"
                ],
                [
                    "name" => "Phosphorus",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "PO4",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "PHOSPHORUS"
                ],
                [
                    "name" => "Renal Function Test",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "RFT(ur,cr,na,k,uric acid,chloride,tp,alb)",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "RENAL_FUNCTION_TEST"
                ],
                [
                    "name" => "GTT (6 Tests)",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "GTT_(6_TESTS)"
                ],
                [
                    "name" => "T3",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "T3",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "T3"
                ],
                [
                    "name" => "T4",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "T4",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "T4"
                ],
                [
                    "name" => "TSH",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "TSH",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "TSH"
                ],
                [
                    "name" => "Bilirubin (Indirect)",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "BILIRUBIN_(INDIRECT)"
                ],
                [
                    "name" => "MP",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "mp",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "MP"
                ],
                [
                    "name" => "APTT/PT/INR",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "APTT/PT/INR"
                ],
                [
                    "name" => "AMH",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "AMH"
                ],
                [
                    "name" => "CA-125",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "CA-125"
                ],
                [
                    "name" => "Culture (Urine)",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "CULTURE_(URINE)"
                ],
                [
                    "name" => "FT3,FT4,TSH",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "FT3,FT4,TSH"
                ],
                [
                    "name" => "FT3,FT4,",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "FT3,FT4,"
                ],
                [
                    "name" => "FT3",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "FT3"
                ],
                [
                    "name" => "FT4",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "FT4"
                ],
                [
                    "name" => "FSH & LH",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "FSH_&_LH"
                ],
                [
                    "name" => "Megnisium (Mg++)",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "MEGNISIUM_(MG++)"
                ],
                [
                    "name" => "PT/INR",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "PT/INR"
                ],
                [
                    "name" => "PT/APTT+INR",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "PT/APTT+INR"
                ],
                [
                    "name" => "T3",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "T3"
                ],
                [
                    "name" => "T4",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "T4"
                ],
                [
                    "name" => "T3, T4",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "T3,_T4"
                ],
                [
                    "name" => "RANDOM BLOOD SUGAR",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "RBS",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "RANDOM_BLOOD_SUGAR"
                ],
                [
                    "name" => "VIT D (25OH)",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "VIT_D_(25OH)"
                ],
                [
                    "name" => "FSH",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "FSH"
                ],
                [
                    "name" => "LH",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "LH"
                ],
                [
                    "name" => "URINE- UROBILINOGEN",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "URINE-_UROBILINOGEN"
                ],
                [
                    "name" => "URINE- ACETONE",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "URINE- ACETONE",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "URINE-_ACETONE"
                ],
                [
                    "name" => "URINE-SUGAR",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "URINE-SUGAR"
                ],
                [
                    "name" => "VITAMIN D3",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "VIT D3",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "VITAMIN_D3"
                ],
                [
                    "name" => "KFT 2 (ur,cr,na+,k+,uric acid)",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "KFT",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "KFT_2_(UR,CR,NA+,K+,URIC_ACID)"
                ],
                [
                    "name" => "FT4,TSH",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "FT4TSH",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "FT4,TSH"
                ],
                [
                    "name" => "SUGAR RANDOM",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "Bs(R)",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "SUGAR_RANDOM"
                ],
                [
                    "name" => "Urine CST",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "U-CST",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "URINE_CST"
                ],
                [
                    "name" => "STOOL-CST",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "STOOL-CST",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "STOOL-CST"
                ],
                [
                    "name" => "TOTAL WBC COUNT",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "TC",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "TOTAL_WBC_COUNT"
                ],
                [
                    "name" => "COMPLETE HAEMOGRAM",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "COMPLETE_HAEMOGRAM"
                ],
                [
                    "name" => "PCV",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "PCV",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "PCV"
                ],
                [
                    "name" => "MEGNASIUM",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "Mg+",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "MEGNASIUM"
                ],
                [
                    "name" => "IGE",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "IGE",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "IGE"
                ],
                [
                    "name" => "CPK-MB",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "CPK-MB",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "CPK-MB"
                ],
                [
                    "name" => "RBC MORPHOLOGY(PBS)",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "RBC MORPHOLOGY(PBS)",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "RBC_MORPHOLOGY(PBS)"
                ],
                [
                    "name" => "MX TEST",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "MX_TEST"
                ],
                [
                    "name" => "BLOOD MP (KIT)",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "BLOOD_MP_(KIT)"
                ],
                [
                    "name" => "RBC",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "RBC"
                ],
                [
                    "name" => "RBS WITH 50 GRAM GLUCOSE",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "RBS_WITH_50_GRAM_GLUCOSE"
                ],
                [
                    "name" => "SERUM CPK(TOTAL)",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "SERUM_CPK(TOTAL)"
                ],
                [
                    "name" => "SPUTUM FUNGAL STAIN",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "FUNGAL",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "SPUTUM_FUNGAL_STAIN"
                ],
                [
                    "name" => "SPUTUM CST",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "CST",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "SPUTUM_CST"
                ],
                [
                    "name" => "OGTT",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "OGTT",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "OGTT"
                ],
                [
                    "name" => "SPUTUM AFB",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "SPUTUM_AFB"
                ],
                [
                    "name" => "BS (PP) WITH 75 GRAM GLUCOSE",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "75 GRAM GLUCOSE bs pp",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "BS_(PP)_WITH_75_GRAM_GLUCOSE"
                ],
                [
                    "name" => "SPUTUM GRAM STAIN",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "SPUTUM_GRAM_STAIN"
                ],
                [
                    "name" => "HBA1C- (HPLC Method)",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "HBA1C-_(HPLC_METHOD)"
                ],
                [
                    "name" => "DENGUE NS 1 Ag / IgM , IgG (Combo Assay)",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "DENGUE",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "DENGUE_NS_1_AG_/_IGM_,_IGG_(COMBO_ASSAY)"
                ],
                [
                    "name" => "Scrub Typhus IgM & IgG",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "Scrub",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "SCRUB_TYPHUS_IGM_&_IGG"
                ],
                [
                    "name" => "FNAC",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "FNAC",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "FNAC"
                ],
                [
                    "name" => "Eyelash Swab",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "swab",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "EYELASH_SWAB"
                ],
                [
                    "name" => "Helicocheck Device",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "HELICOCHECK_DEVICE"
                ],
                [
                    "name" => "EYE SWAB",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "EYE SWAB",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "EYE_SWAB"
                ],
                [
                    "name" => "ABSOLUTE NEUTROPHIL COUNT",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "ANC",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "ABSOLUTE__NEUTROPHIL_COUNT"
                ],
                [
                    "name" => "DRUG OF ABUSE ( DOA ) 6.1 PANNEL",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "DOA 6.1",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "DRUG_OF_ABUSE_(_DOA_)_6.1_PANNEL"
                ],
                [
                    "name" => "Sodium(Na+), Potassium(K+)",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "Na+, K+",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "SODIUM(NA+),_POTASSIUM(K+)"
                ],
                [
                    "name" => "H PYLORI",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "H PYLORI",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "H_PYLORI"
                ],
                [
                    "name" => "Prolactin",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "PRL",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "PROLACTIN"
                ],
                [
                    "name" => "ELECTROLYTES 2 PARAMETER",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "ELECTROLYTES_2_PARAMETER"
                ],
                [
                    "name" => "ELECTROLYTES 3 PARAMETER",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "ELECTROLYTES_3_PARAMETER"
                ],
                [
                    "name" => "ELECTROLYTES 4 PARAMETER",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "ELECTROLYTES_4_PARAMETER"
                ],
                [
                    "name" => "Pap Smear",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "PAP_SMEAR"
                ],
                [
                    "name" => "KFT 1 (UREA,CREATININE,URIC ACID)",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "KFT",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "KFT_1__(UREA,CREATININE,URIC_ACID)"
                ],
                [
                    "name" => "Mantoux Test",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "MANTOUX_TEST"
                ],
                [
                    "name" => "SERUM BETA HCG",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "B-HCG",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "SERUM_BETA_HCG"
                ],
                [
                    "name" => "T4 TSH",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "T4 TSH",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "T4_TSH"
                ],
                [
                    "name" => "FLUID",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "FLUID"
                ],
                [
                    "name" => "Blood Sugar (R)",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "RBS",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "BLOOD_SUGAR_(R)"
                ],
                [
                    "name" => "ANTI CCP",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "ANTI_CCP"
                ],
                [
                    "name" => "TOXIC GRANULES",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "TOXIC_GRANULES"
                ],
                [
                    "name" => "Urine Sugar",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "URINE_SUGAR"
                ],
                [
                    "name" => "Urine Protein",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "URINE_PROTEIN"
                ],
                [
                    "name" => "Urine Urobilinogen",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "URINE_UROBILINOGEN"
                ],
                [
                    "name" => "Urine KETONE BODIES",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "URINE_KETONE_BODIES"
                ],
                [
                    "name" => "USG Testing",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "USG_TESTING"
                ],
                [
                    "name" => "URINE RE/ME/CS",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "URINE_RE/ME/CS"
                ],
                [
                    "name" => "Amylase & Lipase",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "AMYLASE_&_LIPASE"
                ],
                [
                    "name" => "Urea & Creatinine",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "UREA_&_CREATININE"
                ],
                [
                    "name" => "CALCIUM - Ionized",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "ionized",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "CALCIUM_-_IONIZED"
                ],
                [
                    "name" => "testing",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "TESTING"
                ],
                [
                    "name" => "Freedom Pack",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "FREEDOM_PACK"
                ],
                [
                    "name" => "FREEDOM PACK NEW",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "FREEDOM_PACK_NEW"
                ],
                [
                    "name" => "URINE ALBUMIN",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "URINE ALBUMIN",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "URINE_ALBUMIN"
                ],
                [
                    "name" => "BILIRUBIN - DIRECT",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "BILIRUBIN_-_DIRECT"
                ],
                [
                    "name" => "BILIRUBIN -TOTAL",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "BILIRUBIN_-TOTAL"
                ],
                [
                    "name" => "HEPATITIS A ANTIBODY (AntiHAV) - IGM",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "HAV",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "HEPATITIS_A_ANTIBODY_(ANTIHAV)_-_IGM"
                ],
                [
                    "name" => "HEPATITIS E ANTIBODY (AntiHEV) - IGM ANTIBODY",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "HEV",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "HEPATITIS_E_ANTIBODY_(ANTIHEV)_-_IGM_ANTIBODY"
                ],
                [
                    "name" => "D DIMER",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "DIMER",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "D_DIMER"
                ],
                [
                    "name" => "Fasting Blood Sugar(FBS)",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "FBS",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "FASTING_BLOOD_SUGAR(FBS)"
                ],
                [
                    "name" => "Postprandial Blood Sugar(PPBS)",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "PPBS",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "POSTPRANDIAL_BLOOD_SUGAR(PPBS)"
                ],
                [
                    "name" => "HIV 1&2 RAPID",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "HIV",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "HIV_1&2_RAPID"
                ],
                [
                    "name" => "HCV RAPID",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "HCV",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "HCV_RAPID"
                ],
                [
                    "name" => "LDH",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "LDH",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "LDH"
                ],
                [
                    "name" => "PUS CULTURE",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "PUS CST",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "PUS_CULTURE"
                ],
                [
                    "name" => "Activated Partial Thromboplastin Clotting Time",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "APTT",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "ACTIVATED_PARTIAL_THROMBOPLASTIN_CLOTTING_TIME"
                ],
                [
                    "name" => "URINE SUGER",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "US",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "URINE_SUGER"
                ],
                [
                    "name" => "DENGUE IGG, IGM",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "DENGUE IGG, IGM",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "DENGUE_IGG,_IGM"
                ],
                [
                    "name" => "STOOL FOR OCCULT BLOOD",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "STOOL OBT",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "STOOL_FOR_OCCULT_BLOOD"
                ],
                [
                    "name" => "MAGNESIUM",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "MAGNESIUM",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "MAGNESIUM"
                ],
                [
                    "name" => "HAV IgM RAPID",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "HAV",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "HAV_IGM_RAPID"
                ],
                [
                    "name" => "HEV IgM RAPID",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "HEV",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "HEV_IGM_RAPID"
                ],
                [
                    "name" => "BS (PP) AFTER BREAKFAST",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "BS (PP) AFTER BREAKFAST",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "BS_(PP)_AFTER_BREAKFAST"
                ],
                [
                    "name" => "BS (PP) AFTER LUNCH",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "BS (PP) AFTER LUNCH",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "BS_(PP)_AFTER_LUNCH"
                ],
                [
                    "name" => "SEROLOGICAL ALLERGY TEST (SAT)",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "ALLERGY",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "SEROLOGICAL_ALLERGY_TEST_(SAT)"
                ],
                [
                    "name" => "ECG",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "E",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "ECG"
                ],
                [
                    "name" => "DOUBLE MARKAR",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "DOUBLE_MARKAR"
                ],
                [
                    "name" => "X-RAY RT KNEE AP,LAT",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "X-RAY_RT_KNEE_AP,LAT"
                ],
                [
                    "name" => "X RAY LT KNEE AP,LAT",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "X_RAY_LT_KNEE_AP,LAT"
                ],
                [
                    "name" => "X RAY LS SPINE AP,LAT",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "X_RAY_LS_SPINE_AP,LAT"
                ],
                [
                    "name" => "Standard Room",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "STANDARD_ROOM"
                ],
                [
                    "name" => "Normal Room",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "46",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "46",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "NORMAL_ROOM",
                    "convertion_factor" => "12.00"
                ],
                [
                    "name" => "VIP Room",
                    "brand_id" => "1",
                    "category_id" => "1",
                    "short_name" => "",
                    "tax_slab_id" => "1",
                    "primary_unit_id" => "1",
                    "company_id" => "1",
                    "business_division_id" => 2,
                    "alternative_unit_id"   => "1",
                    "item_type_id"          => 2,
                    "manage_stock"          => "No",
                    "product_code" => "VIP_ROOM"
                ]
            ];
        $productPrices = [

            [
                'sale_price' => '80',
                'mrp' => '80',
                'purchase_price'=>'0',
                'wholesale_price'=>'80',
                'min_sale_price'=>'80',
            ],
            [
                'sale_price' => '80',
                'mrp' => '80',
                'purchase_price'=>'0',
                'wholesale_price'=>'80',
                'min_sale_price'=>'80',
            ],
            [
                'sale_price' => '80',
                'mrp' => '80',
                'purchase_price'=>'0',
                'wholesale_price'=>'80',
                'min_sale_price'=>'80',
            ],
            [
                'sale_price' => '80',
                'mrp' => '80',
                'purchase_price'=>'0',
                'wholesale_price'=>'80',
                'min_sale_price'=>'80',
            ],
            [
                'sale_price' => '200',
                'mrp' => '200',
                'purchase_price'=>'0',
                'wholesale_price'=>'200',
                'min_sale_price'=>'200',
            ],
            [
                'sale_price' => '300',
                'mrp' => '300',
                'purchase_price'=>'0',
                'wholesale_price'=>'300',
                'min_sale_price'=>'300',
            ],
            [
                'sale_price' => '250',
                'mrp' => '250',
                'purchase_price'=>'0',
                'wholesale_price'=>'250',
                'min_sale_price'=>'250',
            ],
            [
                'sale_price' => '450',
                'mrp' => '450',
                'purchase_price'=>'0',
                'wholesale_price'=>'450',
                'min_sale_price'=>'450',
            ],
            [
                'sale_price' => '500',
                'mrp' => '500',
                'purchase_price'=>'0',
                'wholesale_price'=>'500',
                'min_sale_price'=>'500',
            ],
            [
                'sale_price' => '300',
                'mrp' => '300',
                'purchase_price'=>'0',
                'wholesale_price'=>'300',
                'min_sale_price'=>'300',
            ],
            [
                'sale_price' => '300',
                'mrp' => '300',
                'purchase_price'=>'0',
                'wholesale_price'=>'300',
                'min_sale_price'=>'300',
            ],
            [
                'sale_price' => '500',
                'mrp' => '500',
                'purchase_price'=>'0',
                'wholesale_price'=>'500',
                'min_sale_price'=>'500',
            ],
            [
                'sale_price' => '200',
                'mrp' => '200',
                'purchase_price'=>'0',
                'wholesale_price'=>'200',
                'min_sale_price'=>'200'
            ],
            [
                'sale_price' => '250',
                'mrp' => '250',
                'purchase_price'=>'0',
                'wholesale_price'=>'250',
                'min_sale_price'=>'250',
            ],
            [
                'sale_price' => '200',
                'mrp' => '200',
                'purchase_price'=>'0',
                'wholesale_price'=>'200',
                'min_sale_price'=>'200',
            ],
            [
                'sale_price' => '650',
                'mrp' => '650',
                'purchase_price'=>'0',
                'wholesale_price'=>'650',
                'min_sale_price'=>'650'
            ],
            [
                'sale_price' => '150',
                'mrp' => '150',
                'purchase_price'=>'0',
                'wholesale_price'=>'150',
                'min_sale_price'=>'150',
            ],
            [
                'sale_price' => '150',
                'mrp' => '150',
                'purchase_price'=>'0',
                'wholesale_price'=>'150',
                'min_sale_price'=>'150',
            ],
            [
                'sale_price' => '400',
                'mrp' => '400',
                'purchase_price'=>'0',
                'wholesale_price'=>'400',
                'min_sale_price'=>'400',
            ],
            [
                'sale_price' => '180',
                'mrp' => '180',
                'purchase_price'=>'0',
                'wholesale_price'=>'180',
                'min_sale_price'=>'180',
            ],
            [
                'sale_price' => '180',
                'mrp' => '180',
                'purchase_price'=>'0',
                'wholesale_price'=>'180',
                'min_sale_price'=>'180',
            ],
            [
                'sale_price' => '180',
                'mrp' => '180',
                'purchase_price'=>'0',
                'wholesale_price'=>'180',
                'min_sale_price'=>'180',
            ],
            [
                'sale_price' => '120',
                'mrp' => '120',
                'purchase_price'=>'0',
                'wholesale_price'=>'120',
                'min_sale_price'=>'120',
            ],
            [
                'sale_price' => '120',
                'mrp' => '120',
                'purchase_price'=>'0',
                'wholesale_price'=>'120',
                'min_sale_price'=>'120',
            ],
            [
                'sale_price' => '120',
                'mrp' => '120',
                'purchase_price'=>'0',
                'wholesale_price'=>'120',
                'min_sale_price'=>'120',
            ],
            [
                'sale_price' => '300',
                'mrp' => '300',
                'purchase_price'=>'0',
                'wholesale_price'=>'300',
                'min_sale_price'=>'300',
            ],
            [
                'sale_price' => '750',
                'mrp' => '750',
                'purchase_price'=>'0',
                'wholesale_price'=>'750',
                'min_sale_price'=>'750',
            ],
            [
                'sale_price' => '200',
                'mrp' => '200',
                'purchase_price'=>'0',
                'wholesale_price'=>'200',
                'min_sale_price'=>'200',
            ],
            [
                'sale_price' => '250',
                'mrp' => '250',
                'purchase_price'=>'0',
                'wholesale_price'=>'250',
                'min_sale_price'=>'250',
            ],
            [
                'sale_price' => '200',
                'mrp' => '200',
                'purchase_price'=>'0',
                'wholesale_price'=>'200',
                'min_sale_price'=>'200',
            ],
            [
                'sale_price' => '450',
                'mrp' => '450',
                'purchase_price'=>'0',
                'wholesale_price'=>'450',
                'min_sale_price'=>'450',
            ],
            [
                'sale_price' => '150',
                'mrp' => '150',
                'purchase_price'=>'0',
                'wholesale_price'=>'150',
                'min_sale_price'=>'150',
            ],
            [
                'sale_price' => '150',
                'mrp' => '150',
                'purchase_price'=>'0',
                'wholesale_price'=>'150',
                'min_sale_price'=>'150',
            ],
            [
                'sale_price' => '70',
                'mrp' => '70',
                'purchase_price'=>'0',
                'wholesale_price'=>'70',
                'min_sale_price'=>'70',
            ],
            [
                'sale_price' => '70',
                'mrp' => '70',
                'purchase_price'=>'0',
                'wholesale_price'=>'70',
                'min_sale_price'=>'70'
            ],
            [
                'sale_price' => '250',
                'mrp' => '250',
                'purchase_price'=>'0',
                'wholesale_price'=>'250',
                'min_sale_price'=>'250',
            ],
            [
                'sale_price' => '200',
                'mrp' => '200',
                'purchase_price'=>'0',
                'wholesale_price'=>'200',
                'min_sale_price'=>'200',
            ],
            [
                'sale_price' => '250',
                'mrp' => '250',
                'purchase_price'=>'0',
                'wholesale_price'=>'250',
                'min_sale_price'=>'250',
            ],
            [
                'sale_price' => '300',
                'mrp' => '300',
                'purchase_price'=>'0',
                'wholesale_price'=>'300',
                'min_sale_price'=>'300',
            ],
            [
                'sale_price' => '200',
                'mrp' => '200',
                'purchase_price'=>'0',
                'wholesale_price'=>'200',
                'min_sale_price'=>'200',
            ],
            [
                'sale_price' => '500',
                'mrp' => '500',
                'purchase_price'=>'0',
                'wholesale_price'=>'500',
                'min_sale_price'=>'500',
            ],
            [
                'sale_price' => '500',
                'mrp' => '500',
                'purchase_price'=>'0',
                'wholesale_price'=>'500',
                'min_sale_price'=>'500',
            ],
            [
                'sale_price' => '500',
                'mrp' => '500',
                'purchase_price'=>'0',
                'wholesale_price'=>'500',
                'min_sale_price'=>'500',
            ],
            [
                'sale_price' => '1200',
                'mrp' => '1200',
                'purchase_price'=>'0',
                'wholesale_price'=>'1200',
                'min_sale_price'=>'1200',
            ],
            [
                'sale_price' => '1200',
                'mrp' => '1200',
                'purchase_price'=>'0',
                'wholesale_price'=>'1200',
                'min_sale_price'=>'1200',
            ],
            [
                'sale_price' => '500',
                'mrp' => '500',
                'purchase_price'=>'0',
                'wholesale_price'=>'500',
                'min_sale_price'=>'500',
            ],
            [
                'sale_price' => '700',
                'mrp' => '700',
                'purchase_price'=>'0',
                'wholesale_price'=>'700',
                'min_sale_price'=>'700',
            ],
            [
                'sale_price' => '300',
                'mrp' => '300',
                'purchase_price'=>'0',
                'wholesale_price'=>'300',
                'min_sale_price'=>'300',
            ],
            [
                'sale_price' => '300',
                'mrp' => '300',
                'purchase_price'=>'0',
                'wholesale_price'=>'300',
                'min_sale_price'=>'300',
            ],
            [
                'sale_price' => '300',
                'mrp' => '300',
                'purchase_price'=>'0',
                'wholesale_price'=>'300',
                'min_sale_price'=>'300',
            ],
            [
                'sale_price' => '300',
                'mrp' => '300',
                'purchase_price'=>'0',
                'wholesale_price'=>'300',
                'min_sale_price'=>'300',
            ],
            [
                'sale_price' => '50',
                'mrp' => '50',
                'purchase_price'=>'0',
                'wholesale_price'=>'50',
                'min_sale_price'=>'50',
            ],
            [
                'sale_price' => '500',
                'mrp' => '500',
                'purchase_price'=>'0',
                'wholesale_price'=>'500',
                'min_sale_price'=>'500'
            ],
            [
                'sale_price' => '200',
                'mrp' => '200',
                'purchase_price'=>'0',
                'wholesale_price'=>'200',
                'min_sale_price'=>'200'
            ],
            [
                'sale_price' => '80',
                'mrp' => '80',
                'purchase_price'=>'0',
                'wholesale_price'=>'80',
                'min_sale_price'=>'80'
            ],
            [
                'sale_price' => '200',
                'mrp' => '200',
                'purchase_price'=>'0',
                'wholesale_price'=>'200',
                'min_sale_price'=>'200'
            ],
            [
                'sale_price' => '400',
                'mrp' => '400',
                'purchase_price'=>'0',
                'wholesale_price'=>'400',
                'min_sale_price'=>'400'
            ],
            [
                'sale_price' => '300',
                'mrp' => '300',
                'purchase_price'=>'0',
                'wholesale_price'=>'300',
                'min_sale_price'=>'300',
            ],
            [
                'sale_price' => '200',
                'mrp' => '200',
                'purchase_price'=>'0',
                'wholesale_price'=>'200',
                'min_sale_price'=>'200'
            ],
            [
                'sale_price' => '150',
                'mrp' => '150',
                'purchase_price'=>'0',
                'wholesale_price'=>'150',
                'min_sale_price'=>'150',
            ],
            [
                'sale_price' => '100',
                'mrp' => '100',
                'purchase_price'=>'0',
                'wholesale_price'=>'100',
                'min_sale_price'=>'100',
            ],
            [
                'sale_price' => '300',
                'mrp' => '300',
                'purchase_price'=>'0',
                'wholesale_price'=>'300',
                'min_sale_price'=>'300',
            ],
            [
                'sale_price' => '500',
                'mrp' => '500',
                'purchase_price'=>'0',
                'wholesale_price'=>'500',
                'min_sale_price'=>'500',
            ],
            [
                'sale_price' => '440',
                'mrp' => '440',
                'purchase_price'=>'0',
                'wholesale_price'=>'440',
                'min_sale_price'=>'440',
            ],
            [
                'sale_price' => '440',
                'mrp' => '440',
                'purchase_price'=>'0',
                'wholesale_price'=>'440',
                'min_sale_price'=>'440',
            ],
            [
                'sale_price' => '700',
                'mrp' => '700',
                'purchase_price'=>'0',
                'wholesale_price'=>'700',
                'min_sale_price'=>'700',
            ],
            [
                'sale_price' => '700',
                'mrp' => '700',
                'purchase_price'=>'0',
                'wholesale_price'=>'700',
                'min_sale_price'=>'700',
            ],
            [
                'sale_price' => '600',
                'mrp' => '600',
                'purchase_price'=>'0',
                'wholesale_price'=>'600',
                'min_sale_price'=>'600',
            ],
            [
                'sale_price' => '500',
                'mrp' => '500',
                'purchase_price'=>'0',
                'wholesale_price'=>'500',
                'min_sale_price'=>'500',
            ],
            [
                'sale_price' => '900',
                'mrp' => '900',
                'purchase_price'=>'0',
                'wholesale_price'=>'900',
                'min_sale_price'=>'900',
            ],
            [
                'sale_price' => '300',
                'mrp' => '300',
                'purchase_price'=>'0',
                'wholesale_price'=>'300',
                'min_sale_price'=>'300',
            ],
            [
                'sale_price' => '300',
                'mrp' => '300',
                'purchase_price'=>'0',
                'wholesale_price'=>'300',
                'min_sale_price'=>'300',
            ],
            [
                'sale_price' => '300',
                'mrp' => '300',
                'purchase_price'=>'0',
                'wholesale_price'=>'300',
                'min_sale_price'=>'300',
            ],
            [
                'sale_price' => '300',
                'mrp' => '300',
                'purchase_price'=>'0',
                'wholesale_price'=>'300',
                'min_sale_price'=>'300',
            ],
            [
                'sale_price' => '300',
                'mrp' => '300',
                'purchase_price'=>'0',
                'wholesale_price'=>'300',
                'min_sale_price'=>'300',
            ],
            [
                'sale_price' => '300',
                'mrp' => '300',
                'purchase_price'=>'0',
                'wholesale_price'=>'300',
                'min_sale_price'=>'300',
            ],
            [
                'sale_price' => '1200',
                'mrp' => '1200',
                'purchase_price'=>'0',
                'wholesale_price'=>'1200',
                'min_sale_price'=>'1200',
            ],
            [
                'sale_price' => '1800',
                'mrp' => '1800',
                'purchase_price'=>'0',
                'wholesale_price'=>'1800',
                'min_sale_price'=>'1800',
            ],
            [
                'sale_price' => '1250',
                'mrp' => '1250',
                'purchase_price'=>'0',
                'wholesale_price'=>'1250',
                'min_sale_price'=>'1250'
            ],
            [
                'sale_price' => '700',
                'mrp' => '700',
                'purchase_price'=>'0',
                'wholesale_price'=>'700',
                'min_sale_price'=>'700',
            ],
            [
                'sale_price' => '700',
                'mrp' => '700',
                'purchase_price'=>'0',
                'wholesale_price'=>'700',
                'min_sale_price'=>'700',
            ],
            [
                'sale_price' => '600',
                'mrp' => '600',
                'purchase_price'=>'0',
                'wholesale_price'=>'600',
                'min_sale_price'=>'600',
            ],
            [
                'sale_price' => '600',
                'mrp' => '600',
                'purchase_price'=>'0',
                'wholesale_price'=>'600',
                'min_sale_price'=>'600',
            ],
            [
                'sale_price' => '450',
                'mrp' => '450',
                'purchase_price'=>'0',
                'wholesale_price'=>'450',
                'min_sale_price'=>'450',
            ],
            [
                'sale_price' => '1200',
                'mrp' => '1200',
                'purchase_price'=>'0',
                'wholesale_price'=>'1200',
                'min_sale_price'=>'1200',
            ],
            [
                'sale_price' => '500',
                'mrp' => '500',
                'purchase_price'=>'0',
                'wholesale_price'=>'500',
                'min_sale_price'=>'500',
            ],
            [
                'sale_price' => '550',
                'mrp' => '550',
                'purchase_price'=>'0',
                'wholesale_price'=>'550',
                'min_sale_price'=>'550',
            ],
            [
                'sale_price' => '1150',
                'mrp' => '1150',
                'purchase_price'=>'0',
                'wholesale_price'=>'1150',
                'min_sale_price'=>'1150',
            ],
            [
                'sale_price' => '450',
                'mrp' => '450',
                'purchase_price'=>'0',
                'wholesale_price'=>'450',
                'min_sale_price'=>'450',
            ],
            [
                'sale_price' => '400',
                'mrp' => '400',
                'purchase_price'=>'0',
                'wholesale_price'=>'400',
                'min_sale_price'=>'400',
            ],
            [
                'sale_price' => '0',
                'mrp' => '0',
                'purchase_price'=>'0',
                'wholesale_price'=>'0',
                'min_sale_price'=>'0',
            ],
            [
                'sale_price' => '50',
                'mrp' => '50',
                'purchase_price'=>'0',
                'wholesale_price'=>'50',
                'min_sale_price'=>'50',
            ],
            [
                'sale_price' => '1200',
                'mrp' => '1200',
                'purchase_price'=>'0',
                'wholesale_price'=>'1200',
                'min_sale_price'=>'1200',
            ],
            [
                'sale_price' => '600',
                'mrp' => '600',
                'purchase_price'=>'0',
                'wholesale_price'=>'600',
                'min_sale_price'=>'600',
            ],
            [
                'sale_price' => '600',
                'mrp' => '600',
                'purchase_price'=>'0',
                'wholesale_price'=>'600',
                'min_sale_price'=>'600',
            ],
            [
                'sale_price' => '100',
                'mrp' => '100',
                'purchase_price'=>'0',
                'wholesale_price'=>'100',
                'min_sale_price'=>'100',
            ],
            [
                'sale_price' => '50',
                'mrp' => '50',
                'purchase_price'=>'0',
                'wholesale_price'=>'50',
                'min_sale_price'=>'50',
            ],
            [
                'sale_price' => '50',
                'mrp' => '50',
                'purchase_price'=>'0',
                'wholesale_price'=>'50',
                'min_sale_price'=>'50',
            ],
            [
                'sale_price' => '1600',
                'mrp' => '1600',
                'purchase_price'=>'0',
                'wholesale_price'=>'1600',
                'min_sale_price'=>'1600',
            ],
            [
                'sale_price' => '1200',
                'mrp' => '1200',
                'purchase_price'=>'0',
                'wholesale_price'=>'1200',
                'min_sale_price'=>'1200',
            ],
            [
                'sale_price' => '600',
                'mrp' => '600',
                'purchase_price'=>'0',
                'wholesale_price'=>'600',
                'min_sale_price'=>'600',
            ],
            [
                'sale_price' => '50',
                'mrp' => '50',
                'purchase_price'=>'0',
                'wholesale_price'=>'50',
                'min_sale_price'=>'50',
            ],
            [
                'sale_price' => '700',
                'mrp' => '700',
                'purchase_price'=>'0',
                'wholesale_price'=> '700',
                'min_sale_price'=> '700',
            ],
            [
                'sale_price' => '700',
                'mrp' => '700',
                'purchase_price'=>'0',
                'wholesale_price'=> '700',
                'min_sale_price'=> '700',
            ],
            [
                'sale_price' => '80',
                'mrp' => '80',
                'purchase_price'=>'0',
                'wholesale_price'=>'80',
                'min_sale_price'=>'80',
            ],
            [
                'sale_price' => '400',
                'mrp' => '400',
                'purchase_price'=>'0',
                'wholesale_price'=>'400',
                'min_sale_price'=>'400',
            ],
            [
                'sale_price' => '50',
                'mrp' => '50',
                'purchase_price'=>'0',
                'wholesale_price'=>'50',
                'min_sale_price'=>'50',
            ],
            [
                'sale_price' => '500',
                'mrp' => '500',
                'purchase_price'=>'0',
                'wholesale_price'=>'500',
                'min_sale_price'=>'500',
            ],
            [
                'sale_price' => '700',
                'mrp' => '700',
                'purchase_price'=>'0',
                'wholesale_price'=>'700',
                'min_sale_price'=>'700',
            ],
            [
                'sale_price' => '600',
                'mrp' => '600',
                'purchase_price'=>'0',
                'wholesale_price'=>'600',
                'min_sale_price'=>'600',
            ],
            [
                'sale_price' => '350',
                'mrp' => '350',
                'purchase_price'=>'0',
                'wholesale_price'=>'350',
                'min_sale_price'=>'350',
            ],
            [
                'sale_price' => '200',
                'mrp' => '200',
                'purchase_price'=>'0',
                'wholesale_price'=>'200',
                'min_sale_price'=>'200',
            ],
            [
                'sale_price' => '300',
                'mrp' => '300',
                'purchase_price'=>'0',
                'wholesale_price'=>'300',
                'min_sale_price'=>'300',
            ],
            [
                'sale_price' => '50',
                'mrp' => '50',
                'purchase_price'=>'0',
                'wholesale_price'=>'50',
                'min_sale_price'=>'50',
            ],
            [
                'sale_price' => '70',
                'mrp' => '70',
                'purchase_price'=>'0',
                'wholesale_price'=>'70',
                'min_sale_price'=>'70',
            ],
            [
                'sale_price' => '0',
                'mrp' => '0',
                'purchase_price'=>'0',
                'wholesale_price'=>'0',
                'min_sale_price'=>'0',
            ],
            [
                'sale_price' => '600',
                'mrp' => '600',
                'purchase_price'=>'0',
                'wholesale_price'=>'600',
                'min_sale_price'=>'600',
            ],
            [
                'sale_price' => '500',
                'mrp' => '500',
                'purchase_price'=>'0',
                'wholesale_price'=>'500',
                'min_sale_price'=>'500',
            ],
            [
                'sale_price' => '800',
                'mrp' => '800',
                'purchase_price'=>'0',
                'wholesale_price'=>'800',
                'min_sale_price'=>'800',
            ],
            [
                'sale_price' => '400',
                'mrp' => '400',
                'purchase_price'=>'0',
                'wholesale_price'=>'400',
                'min_sale_price'=>'400',
            ],
            [
                'sale_price' => '200',
                'mrp' => '200',
                'purchase_price'=>'0',
                'wholesale_price'=>'200',
                'min_sale_price'=>'200',
            ],
            [
                'sale_price' => '50',
                'mrp' => '50',
                'purchase_price'=>'0',
                'wholesale_price'=>'50',
                'min_sale_price'=>'50',
            ],
            [
                'sale_price' => '200',
                'mrp' => '200',
                'purchase_price'=>'0',
                'wholesale_price'=>'200',
                'min_sale_price'=>'200',
            ],
            [
                'sale_price' => '600',
                'mrp' => '600',
                'purchase_price'=>'0',
                'wholesale_price'=>'600',
                'min_sale_price'=>'600',
            ],
            [
                'sale_price' => '2000',
                'mrp' => '2000',
                'purchase_price'=>'0',
                'wholesale_price'=>'2000',
                'min_sale_price'=>'2000',
            ],
            [
                'sale_price' => '1000',
                'mrp' => '1000',
                'purchase_price'=>'0',
                'wholesale_price'=>'1000',
                'min_sale_price'=>'1000',
            ],
            [
                'sale_price' => '1000',
                'mrp' => '1000',
                'purchase_price'=>'0',
                'wholesale_price'=>'1000',
                'min_sale_price'=>'1000',
            ],
            [
                'sale_price' => '600',
                'mrp' => '600',
                'purchase_price'=>'0',
                'wholesale_price'=>'600',
                'min_sale_price'=>'600',
            ],
            [
                'sale_price' => '1500',
                'mrp' => '1500',
                'purchase_price'=>'0',
                'wholesale_price'=>'1500',
                'min_sale_price'=>'1500',
            ],
            [
                'sale_price' => '600',
                'mrp' => '600',
                'purchase_price'=>'0',
                'wholesale_price'=>'600',
                'min_sale_price'=>'600',
            ],
            [
                'sale_price' => '200',
                'mrp' => '200',
                'purchase_price'=>'0',
                'wholesale_price'=>'200',
                'min_sale_price'=>'200',
            ],
            [
                'sale_price' => '1200',
                'mrp' => '1200',
                'purchase_price'=>'0',
                'wholesale_price'=>'1200',
                'min_sale_price'=>'1200',
            ],
            [
                'sale_price' => '600',
                'mrp' => '600',
                'purchase_price'=>'0',
                'wholesale_price'=>'600',
                'min_sale_price'=>'600',
            ],
            [
                'sale_price' => '600',
                'mrp' => '600',
                'purchase_price'=>'0',
                'wholesale_price'=>'600',
                'min_sale_price'=>'600',
            ],
            [
                'sale_price' => '600',
                'mrp' => '600',
                'purchase_price'=>'0',
                'wholesale_price'=>'600',
                'min_sale_price'=>'600',
            ],
            [
                'sale_price' => '500',
                'mrp' => '500',
                'purchase_price'=>'0',
                'wholesale_price'=>'500',
                'min_sale_price'=>'500',
            ],
            [
                'sale_price' => '750',
                'mrp' => '750',
                'purchase_price'=>'0',
                'wholesale_price'=>'750',
                'min_sale_price'=>'750',
            ],
            [
                'sale_price' => '1000',
                'mrp' => '1000',
                'purchase_price'=>'0',
                'wholesale_price'=>'1000',
                'min_sale_price'=>'1000',
            ],
            [
                'sale_price' => '1300',
                'mrp' => '1300',
                'purchase_price'=>'0',
                'wholesale_price'=>'1300',
                'min_sale_price'=>'1300',
            ],
            [
                'sale_price' => '500',
                'mrp' => '500',
                'purchase_price'=>'0',
                'wholesale_price'=>'500',
                'min_sale_price'=>'500',
            ],
            [
                'sale_price' => '300',
                'mrp' => '300',
                'purchase_price'=>'0',
                'wholesale_price'=>'300',
                'min_sale_price'=>'300',
            ],
            [
                'sale_price' => '700',
                'mrp' => '700',
                'purchase_price'=>'0',
                'wholesale_price'=>'700',
                'min_sale_price'=>'700',
            ],
            [
                'sale_price' => '750',
                'mrp' => '750',
                'purchase_price'=>'0',
                'wholesale_price'=>'750',
                'min_sale_price'=>'750',
            ],
            [
                'sale_price' => '2000',
                'mrp' => '2000',
                'purchase_price'=>'0',
                'wholesale_price'=>'2000',
                'min_sale_price'=>'2000',
            ],
            [
                'sale_price' => '70',
                'mrp' => '70',
                'purchase_price'=>'0',
                'wholesale_price'=>'70',
                'min_sale_price'=>'70',
            ],
            [
                'sale_price' => '1300',
                'mrp' => '1300',
                'purchase_price'=>'0',
                'wholesale_price'=>'1300',
                'min_sale_price'=>'1300',
            ],
            [
                'sale_price' => '80',
                'mrp' => '80',
                'purchase_price'=>'0',
                'wholesale_price'=>'80',
                'min_sale_price'=>'80',
            ],
            [
                'sale_price' => '50',
                'mrp' => '50',
                'purchase_price'=>'0',
                'wholesale_price'=>'50',
                'min_sale_price'=>'50',
            ],
            [
                'sale_price' => '50',
                'mrp' => '50',
                'purchase_price'=>'0',
                'wholesale_price'=>'50',
                'min_sale_price'=>'50',
            ],
            [
                'sale_price' => '100',
                'mrp' => '100',
                'purchase_price'=>'0',
                'wholesale_price'=>'100',
                'min_sale_price'=>'100',
            ],
            [
                'sale_price' => '200',
                'mrp' => '200',
                'purchase_price'=>'0',
                'wholesale_price'=>'200',
                'min_sale_price'=>'200',
            ],
            [
                'sale_price' => '1200',
                'mrp' => '1200',
                'purchase_price'=>'0',
                'wholesale_price'=>'1200',
                'min_sale_price'=>'1200',
            ],
            [
                'sale_price' => '400',
                'mrp' => '400',
                'purchase_price'=>'0',
                'wholesale_price'=>'400',
                'min_sale_price'=>'400',
            ],
            [
                'sale_price' => '900',
                'mrp' => '900',
                'purchase_price'=>'0',
                'wholesale_price'=>'900',
                'min_sale_price'=>'900',
            ],
            [
                'sale_price' => '450',
                'mrp' => '450',
                'purchase_price'=>'0',
                'wholesale_price'=>'450',
                'min_sale_price'=>'450',
            ],
            [
                'sale_price' => '300',
                'mrp' => '300',
                'purchase_price'=>'0',
                'wholesale_price'=>'300',
                'min_sale_price'=>'300',
            ],
            [
                'sale_price' => '0',
                'mrp' => '0',
                'purchase_price'=>'0',
                'wholesale_price'=>'0',
                'min_sale_price'=>'0',
            ],
            [
                'sale_price' => '175',
                'mrp' => '175',
                'purchase_price'=>'0',
                'wholesale_price'=>'175',
                'min_sale_price'=>'175',
            ],
            [
                'sale_price' => '175',
                'mrp' => '175',
                'purchase_price'=>'0',
                'wholesale_price'=>'175',
                'min_sale_price'=>'175',
            ],
            [
                'sale_price' => '100',
                'mrp' => '100',
                'purchase_price'=>'0',
                'wholesale_price'=>'100',
                'min_sale_price'=>'100',
            ],
            [
                'sale_price' => '150',
                'mrp' => '150',
                'purchase_price'=>'0',
                'wholesale_price'=>'150',
                'min_sale_price'=>'150',
            ],
            [
                'sale_price' => '150',
                'mrp' => '150',
                'purchase_price'=>'0',
                'wholesale_price'=>'150',
                'min_sale_price'=>'150',
            ],
            [
                'sale_price' => '700',
                'mrp' => '700',
                'purchase_price'=>'0',
                'wholesale_price'=>'700',
                'min_sale_price'=>'700',
            ],
            [
                'sale_price' => '700',
                'mrp' => '700',
                'purchase_price'=>'0',
                'wholesale_price'=>'700',
                'min_sale_price'=>'700',
            ],
            [
                'sale_price' => '1050',
                'mrp' => '1050',
                'purchase_price'=>'0',
                'wholesale_price'=>'1050',
                'min_sale_price'=>'1050',
            ],
            [
                'sale_price' => '70',
                'mrp' => '70',
                'purchase_price'=>'0',
                'wholesale_price'=>'70',
                'min_sale_price'=>'70',
            ],
            [
                'sale_price' => '70',
                'mrp' => '70',
                'purchase_price'=>'0',
                'wholesale_price'=>'70',
                'min_sale_price'=>'70',
            ],
            [
                'sale_price' => '500',
                'mrp' => '500',
                'purchase_price'=>'0',
                'wholesale_price'=>'500',
                'min_sale_price'=>'500',
            ],
            [
                'sale_price' => '450',
                'mrp' => '450',
                'purchase_price'=>'0',
                'wholesale_price'=>'450',
                'min_sale_price'=>'450',
            ],
            [
                'sale_price' => '600',
                'mrp' => '600',
                'purchase_price'=>'0',
                'wholesale_price'=>'600',
                'min_sale_price'=>'600',
            ],
            [
                'sale_price' => '700',
                'mrp' => '700',
                'purchase_price'=>'0',
                'wholesale_price'=>'700',
                'min_sale_price'=>'700',
            ],
            [
                'sale_price' => '600',
                'mrp' => '600',
                'purchase_price'=>'0',
                'wholesale_price'=>'600',
                'min_sale_price'=>'600',
            ],
            [
                'sale_price' => '50',
                'mrp' => '50',
                'purchase_price'=>'0',
                'wholesale_price'=>'50',
                'min_sale_price'=>'50',
            ],
            [
                'sale_price' => '1200',
                'mrp' => '1200',
                'purchase_price'=>'0',
                'wholesale_price'=>'1200',
                'min_sale_price'=>'1200',
            ],
            [
                'sale_price' => '300',
                'mrp' => '300',
                'purchase_price'=>'0',
                'wholesale_price'=>'300',
                'min_sale_price'=>'300',
            ],
            [
                'sale_price' => '500',
                'mrp' => '500',
                'purchase_price'=>'0',
                'wholesale_price'=>'500',
                'min_sale_price'=>'500',
            ],
            [
                'sale_price' => '700',
                'mrp' => '700',
                'purchase_price'=>'0',
                'wholesale_price'=>'700',
                'min_sale_price'=>'700'
            ],
            [
                'sale_price' => '700',
                'mrp' => '700',
                'purchase_price'=>'0',
                'wholesale_price'=>'700',
                'min_sale_price'=>'700',
            ],
            [
                'sale_price' => '50',
                'mrp' => '50',
                'purchase_price'=>'0',
                'wholesale_price'=>'50',
                'min_sale_price'=>'50',
            ],
            [
                'sale_price' => '50',
                'mrp' => '50',
                'purchase_price'=>'0',
                'wholesale_price'=>'50',
                'min_sale_price'=>'50',
            ],
            [
                'sale_price' => '5000',
                'mrp' => '5000',
                'purchase_price'=>'0',
                'wholesale_price'=>'5000',
                'min_sale_price'=>'5000',
            ],
            [
                'sale_price' => '250',
                'mrp' => '250',
                'purchase_price'=>'0',
                'wholesale_price'=>'250',
                'min_sale_price'=>'250',
            ],
            [
                'sale_price' => '2750',
                'mrp' => '2750',
                'purchase_price'=>'0',
                'wholesale_price'=>'2750',
                'min_sale_price'=>'2750',
            ],
            [
                'sale_price' => '800',
                'mrp' => '800',
                'purchase_price'=>'0',
                'wholesale_price'=>'800',
                'min_sale_price'=>'800',
            ],
            [
                'sale_price' => '800',
                'mrp' => '800',
                'purchase_price'=>'0',
                'wholesale_price'=>'800',
                'min_sale_price'=>'800',
            ],
            [
                'sale_price' => '800',
                'mrp' => '800',
                'purchase_price'=>'0',
                'wholesale_price'=>'800',
                'min_sale_price'=>'800',
            ],
            [
                'sale_price' => '2000',
                'mrp' => '2000',
                'purchase_price'=>'0',
                'wholesale_price'=>'2000',
                'min_sale_price'=>'2000',
            ],
            [
                'sale_price' => '1000',
                'mrp' => '1000',
                'purchase_price'=>'0',
                'wholesale_price'=>'1000',
                'min_sale_price'=>'1000',
            ],
            [
                'sale_price' => '3000',
                'mrp' => '3000',
                'purchase_price'=>'0',
                'wholesale_price'=>'3000',
                'min_sale_price'=>'3000',
            ],
        ];

        foreach ($products as $key => $value) {
            $product = Product::firstOrCreate(['product_code' => $value['product_code']],$value);

            if ($product) {
                $productPrices[$key]['product_id'] = $product->id;
                $productPrices[$key]['batch'] = $key + 1;
                ProductPrice::firstOrCreate($productPrices[$key]);
            };
        }
    }
}
