<?php

namespace Database\Seeders;

use App\Models\ProductCategory;
use App\Models\Projects;
use App\Models\ProjectType;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ProjectTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $projectType     = ProjectType::where('title', 'General')->first();
        $productCategory = ProductCategory::where('name', 'General')->first();

       $project = [

            'title'               => 'MetaMint',
            'code'                => 'METAMINT 00001',
            'receive_date'        => now(),
            'project_type_id'     => $projectType->id,
            'about'               => null,
            'product_category_id' => $productCategory->id,
            'department_id'       => null,
            'created_at'          => now(),
            'updated_at'          => now(),
        ];

        Projects::firstOrCreate(
            ['code' => $project['code']],
            $project
        );

    }
}
