<?php

namespace Database\Seeders;

use App\Models\ProjectType;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ProjectTypeTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
       $floor = [
            [
             'title'      => 'General',
             'code'       => 'GENERAL',
             'default'    => 1,
             'created_at' => now(),
             'updated_at' => now(),
            ],
            [
            	'title' => 'Long Term',
                'code'  => 'LONG_TERM',
                'default' => 0,
            	'created_at' => now(),
            	'updated_at' => now(),
            ],
            [
            	'title' => 'Short Term',
                'code'   => 'SHORT_TERM',
                'default' => 0,
            	'created_at' => now(),
            	'updated_at' => now(),
            ],
        ];
        foreach ($floor as $data) {
            ProjectType::firstOrCreate(
                ['code' => $data['code']],
                $data
            );
        }
    }
}
