<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\RelationType;

class RelationshipTypesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        /**
         * Reset the MasterType table
         */
        // if (\App::environment('local')) {
        //     RelationType::truncate();
        // }

        $types = [
            [
                'relation_name' => 'Father',
                'code'          => 'FATHER'
            ], [
                'relation_name' => 'Mother',
                'code'          => 'MOTHER'
            ], [
                'relation_name' => 'Husband',
                'code'          => 'HUSBAND',
            ], [
                'relation_name'  => 'Wife',
                'code'          => 'WIFE',
            ], [
                'relation_name'  => 'Spouse',
                'code'          => 'SPOUSE',
            ], [
                'relation_name'  => 'Grandfather',
                'code'            => 'GRANDFATHER'
            ], [
                'relation_name'  => 'Grandmother',
                'code'          => 'GRANDMOTHER'
            ], [
                'relation_name'  => 'Guardian',
                'code'          => 'GUARDIAN'
            ], [
                'relation_name'  => 'Brother',
                'code'           => 'BROTHER'
            ], [
                'relation_name'  => 'Sister',
                'code'           => 'SISTER'
            ], [
                'relation_name'  => 'Parents',
                'code'           => 'PARENTS',
            ]
        ];

        foreach ($types as $value) {
            RelationType::firstOrCreate(
                ['code' => $value['code']],
                $value
            );
        }
    }
}
