<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\SampleCollectionTube;

class SampleCollectionTubesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $collection_tubes = [
		    [
		        'tube_name'     => 'Red Top',
                'code'          => 'RED_TOP',
		        'details'       => 'Serum tests',
		        'color_name'    => 'Red',
		        'color_code'    => '#FF0000',
		        'anticoagulant' => 'None (Clot Activator)',
		    ],
		    [
		        'tube_name'     => 'Gold/Tiger Top',
                'code'          => 'GOLD_TIGER_TOP',
		        'details'       => 'Serum tests',
		        'color_name'    => 'Gold',
		        'color_code'    => '#FFD700',
		        'anticoagulant' => 'Gel Separator',
		    ],
		    [
		        'tube_name'     => 'Light Blue Top',
                'code'          => 'LIGHT_BLUE_TOP',
		        'details'       => 'Coagulation studies (PT, APTT)',
		        'color_name'    => 'Light Blue',
		        'color_code'    => '#ADD8E6',
		        'anticoagulant' => 'Sodium Citrate',
		    ],
		    [
		        'tube_name'     => 'Green Top',
                'code'          =>   'GREEN_TOP',
		        'details'       => 'Chemistry (plasma determinations)',
		        'color_name'    => 'Green',
		        'color_code'    => '#008000',
		        'anticoagulant' => 'Heparin',
		    ],
		    [
		        'tube_name'     => 'Lavender Top',
                'code'          =>  'LAVENDER_TOP',
		        'details'       => 'Complete Blood Counts (CBC), Blood Cell Morphology',
		        'color_name'    => 'Lavender',
		        'color_code'    => '#E6E6FA',
		        'anticoagulant' => 'EDTA',
		    ],
		    [
		        'tube_name'     => 'Gray Top',
                'code'          => 'GRAY_TOP',
		        'details'       => 'Glucose testing',
		        'color_name'    => 'Gray',
		        'color_code'    => '#808080',
		        'anticoagulant' => 'Potassium Oxalate/Sodium Fluoride',
		    ],
		    [
		        'tube_name'     => 'Royal Blue Top',
                'code'          => 'ROYAL_BLUE_TOP',
		        'details'       => 'Trace element analysis, toxicology tests',
		        'color_name'    => 'Royal Blue',
		        'color_code'    => '#4169E1',
		        'anticoagulant' => 'EDTA',
		    ],
		    [
		        'tube_name'     => 'Yellow Top',
                'code'          => 'YELLOW_TOP',
		        'details'       => 'Blood bank studies, DNA testing',
		        'color_name'    => 'Yellow',
		        'color_code'    => '#FFFF00',
		        'anticoagulant' => 'ACD (Acid-Citrate-Dextrose)',
		    ],
		    [
		        'tube_name'     => 'Dark Blue Top',
                'code'          => 'DARK_BLUE_TOP',
		        'details'       => 'Trace metal analysis',
		        'color_name'    => 'Dark Blue',
		        'color_code'    => '#00008B',
		        'anticoagulant' => 'Sodium Heparin',
		    ],
		    [
		        'tube_name'     => 'Tan Top',
                'code'          => 'TAN_TOP',
		        'details'       => 'Lead analysis',
		        'color_name'    => 'Tan',
		        'color_code'    => '#D2B48C',
		        'anticoagulant' => 'Sodium Heparin',
		    ],
		    [
		        'tube_name'     => 'Pink Top',
                'code'          => 'PINK_TOP',
		        'details'       => 'Blood typing, compatibility testing',
		        'color_name'    => 'Pink',
		        'color_code'    => '#FFC0CB',
		        'anticoagulant' => 'EDTA',
		    ],
		    [
		        'tube_name'     => 'White Top',
                'code'          => 'WHITE_TOP',
		        'details'       => 'Molecular diagnostic testing (PCR)',
		        'color_name'    => 'White',
		        'color_code'    => '#FFFFFF',
		        'anticoagulant' => 'EDTA',
		    ],
		];

        foreach ($collection_tubes as $value) {
            SampleCollectionTube::firstOrCreate(
                ['code' => $value['code']],
                $value
            );
        }
    }
}
