<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\SampleType;

class SampleTypesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $sampleTypes = [
            [
                'name' => 'ASCITIC-FLUID',
                'code' => 'ASCITIC_FLUID'
            ],
            [
                'name' => 'BLOOD',
                'code' => 'BLOOD',
            ],
            [
                'name' => 'BODY FLUID',
                'code' => 'BODY_FLUID',
            ],
            [
                'name' => 'CITRATE-WB',
                'code' => 'CITRATE_WB'
            ],
            [
                'name' => 'EDTA-WB',
                'code' => 'ETDA_WB'
            ],
            [
                'name' => 'FASTING-PLASMA',
                'code' => 'FASTING_PLASMA'
            ],
            [
                'name' => 'HPLC',
                'code' => 'HPLC'
            ],
            [
                'name' => 'PLASMA-FLOURIDE',
                'code' => 'PLASMA_FLOURIDE',
            ],
            [
                'name' => 'PLASMA',
                'code' => 'PLASMA'
            ],
            [
                'name'  =>  'PLASMA-CITRATE',
                'code'  =>  'PLASMA_CITRATE'
            ],
            [
                'name'  =>  'PLEURAL-FLUID',
                'code'  =>  'PLEURAL_FLUID'
            ],
            [
                'name'  =>  'PP-PLASMA',
                'code'  =>    'PP_PLASMA'
            ],
            [
                'name'  =>  'RANDOM-PLASMA',
                'code'  =>  'RANDOM_PLASMA'
            ],
            [
                'name'  =>  'SEMEN',
                'code'  =>  'SEMEN'
            ],
            [
                'name' => 'SERUM',
                'code' => 'SERUM'
            ],
            [
                'name' => 'SPUTUM',
                'code' => 'SPUTUM'
            ],
            [
                'name' => 'STOOL',
                'code' => 'STOOL'
            ],
            [
                'name' => 'SWAB',
                'code' => 'SWAB'
            ],
            [
                'name' => 'URINE',
                'code' => 'URINE'
            ],
            [
                'name' => 'WHOLE BLOOD',
                'code' => 'WHOLE_BLOOD'
            ],
        ];

        foreach ($sampleTypes as $value) {
            SampleType::firstOrCreate(
                ['code' => $value['code']],
                $value
            );
        }
    }
}
