<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\LmsSection;

class SectionsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        /**
         * Reset the MasterType table
         */
        // if (\App::environment('local')) {
        //     LmsSection::truncate();
        // }

        $types = [
            [
                'section'  => 'A',
                'code'     => 'A',
                'priority' => '1'
            ], [
                'section'  => 'B',
                'code'     => 'B',
                'priority' => '2'
            ], [
                'section'  => 'C',
                'code'     => 'C',
                'priority' => '3'
            ], [
                'section'  => 'D',
                'code'     => 'D',
                'priority' => '4'
            ], [
                'section'  => 'E',
                'code'     => 'E',
                'priority' => '5'
            ], [
                'section'  => 'F',
                'code'     => 'F',
                'priority' => '6'
            ], [
                'section'  => 'G',
                'code'     => 'G',
                'priority' => '7'
            ], [
                'section'  => 'H',
                'code'     => 'H',
                'priority' => '8'
            ], [
                'section'  => 'I',
                'code'     => 'I',
                'priority' => '9'
            ], [
                'section'  => 'J',
                'code'     => 'J',
                'priority' => '10'
            ]
        ];

        foreach ($types as $value) {
            LmsSection::firstOrCreate(
                ['code' => $value['code']],
                $value
            );
        }

    }
}
