<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\ShippingRisk;
class ShippingRiskSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $shipping_risk = [
            [
                'name' => 'Customer Risk (CR)',
                'code' => 'CUSTOMER_RISK (CR)',
                'priority' => 1,
                'status' => 1,  
            ],
           [
                'name' => 'Transporter Risk (TR)',
                'code' => 'TRANSPORTER_RISK (TR)',
                'priority' => 2,
                'status' => 1,  
            ],
        ];

        foreach ($shipping_risk as $data) {
            ShippingRisk::firstOrCreate(
            [
                'name' => $data['name'],
                
            ],
                $data
            );
        } 
    }
}
