<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\SpecialCase;

class SpecialCaseTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $special_cases = [
		    [
				'name'       => 'Common',
				'code'       => 'COM',
				'priority'   => 1,
				'status'     => 1,
				'is_default' => 1,
		    ],
		    [
				'name'       => 'Pregnant Woman',
				'code'       => 'PGW',
				'priority'   => 2,
				'status'     => 1,
				'is_default' => 0,
		    ],
		    [
				'name'       => 'Cancer Patient',
				'code'       => 'CAN',
				'priority'   => 3,
				'status'     => 1,
				'is_default' => 0,
		    ],
		    [
				'name'       => 'Baby',
				'code'       => 'BAB',
				'priority'   => 4,
				'status'     => 1,
				'is_default' => 0,
		    ],
		];

        foreach ($special_cases as $value) {
            SpecialCase::firstOrCreate([
                'code' => $value['code']
	            ],
            	$value
            );
        }
    }
}
