<?php

namespace Database\Seeders;

use App\Models\Stocks\StockMomentType;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class StockMovementTypesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $stockMovementTypes = [
            ['name' => 'Opening', 'code' => 'OPENING', 'description' => 'Opening stock balance at the beginning of a period.', 'priority' => 1, 'status' => 1, 'calculation_type' => 'IN'],
            ['name' => 'Purchase Order Receipt', 'code' => 'PURCHASEORDERRECEIPT', 'description' => 'Receipt of goods from a supplier against a purchase order.', 'priority' => 2, 'status' => 1, 'calculation_type' => 'IN'],
            ['name' => 'Stock Transfer Receipt', 'code' => 'STOCKTRANSFERRECEIPT', 'description' => 'Receipt of stock from another location or warehouse.', 'priority' => 3, 'status' => 1, 'calculation_type' => 'IN'],
            ['name' => 'Sales Order Issue', 'code' => 'SALESORDERISSUE', 'description' => 'Issuance of stock for customer orders.', 'priority' => 4, 'status' => 1, 'calculation_type' => 'OUT'],
            ['name' => 'Stock Transfer Issue', 'code' => 'STOCKTRANSFERISSUE', 'description' => 'Sending stock to another location or warehouse.', 'priority' => 5, 'status' => 1, 'calculation_type' => 'OUT'],
            ['name' => 'Scrap/Write-Off', 'code' => 'SCRAPWRITEOFF', 'description' => 'Removing damaged or obsolete stock from inventory.', 'priority' => 6, 'status' => 1, 'calculation_type' => 'OUT'],
            ['name' => 'Internal Transfer', 'code' => 'INTERNALTRANSFER', 'description' => 'Movement of goods between different locations within the same company.', 'priority' => 7, 'status' => 1, 'calculation_type' => 'IN'],
            ['name' => 'External Transfer', 'code' => 'EXTERNALTRANSFER', 'description' => 'Transfer of goods between different companies.', 'priority' => 8, 'status' => 1, 'calculation_type' => 'OUT'],
            ['name' => 'Stock Adjustment', 'code' => 'STOCKADJUSTMENT', 'description' => 'Adjustments due to inventory discrepancies.', 'priority' => 9, 'status' => 1, 'calculation_type' => 'OUT'],
            ['name' => 'Price Adjustment', 'code' => 'PRICEADJUSTMENT', 'description' => 'Adjustments due to changes in inventory valuation.', 'priority' => 10, 'status' => 1, 'calculation_type' => 'OUT'],
            ['name' => 'Purchase Returns', 'code' => 'PURCHASERETURNS', 'description' => 'Returning goods to the supplier.', 'priority' => 11, 'status' => 1, 'calculation_type' => 'OUT'],
            ['name' => 'Sales Returns', 'code' => 'SALESRETURNS', 'description' => 'Returning goods from customers.', 'priority' => 12, 'status' => 1, 'calculation_type' => 'IN'],
            ['name' => 'Consignment In', 'code' => 'CONSIGNMENTIN', 'description' => 'Receiving consignment goods.', 'priority' => 13, 'status' => 1, 'calculation_type' => 'IN'],
            ['name' => 'Consignment Out', 'code' => 'CONSIGNMENTOUT', 'description' => 'Sending consignment goods.', 'priority' => 14, 'status' => 1, 'calculation_type' => 'OUT'],
            ['name' => 'Raw Material Issue', 'code' => 'RAWMATERIALISSUE', 'description' => 'Issuing raw materials to production.', 'priority' => 15, 'status' => 1, 'calculation_type' => 'OUT'],
            ['name' => 'Finished Goods Receipt', 'code' => 'FINISHEDGOODSRECEIPT', 'description' => 'Receiving finished goods from production.', 'priority' => 16, 'status' => 1, 'calculation_type' => 'IN'],
            ['name' => 'Reservation', 'code' => 'RESERVATION', 'description' => 'Reserving stock for specific orders.', 'priority' => 17, 'status' => 1, 'calculation_type' => 'OUT'],
            ['name' => 'Blocking', 'code' => 'BLOCKING', 'description' => 'Blocking stock for quality control.', 'priority' => 18, 'status' => 1, 'calculation_type' => 'OUT'],
            ['name' => 'Consumption', 'code' => 'CONSUMPTION', 'description' => 'Consumption of stock in production or other processes.', 'priority' => 19, 'status' => 1, 'calculation_type' => 'OUT'],
            ['name' => 'Damage', 'code' => 'DAMAGE', 'description' => 'Inventory damaged during handling or storage.', 'priority' => 20, 'status' => 1, 'calculation_type' => 'OUT'],
            ['name' => 'Work In Progress', 'code' => 'WORKINPROGRESS', 'description' => 'Items currently being processed in production.', 'priority' => 21, 'status' => 1, 'calculation_type' => 'OUT'],
            ['name' => 'Finished Goods Transfer', 'code' => 'FINISHEDGOODSTRANSFER', 'description' => 'Transfer of finished goods to another location or warehouse.', 'priority' => 22, 'status' => 1, 'calculation_type' => 'OUT'],
            ['name' => 'Waste Disposal', 'code' => 'WASTEDISPOSAL', 'description' => 'Disposal of production waste.', 'priority' => 23, 'status' => 1, 'calculation_type' => 'OUT'],
            ['name' => 'Return To Vendor', 'code' => 'RETURNTO_VENDOR', 'description' => 'Returning materials or goods to the vendor.', 'priority' => 24, 'status' => 1, 'calculation_type' => 'OUT'],
            ['name' => 'Issue for Rework', 'code' => 'ISSUEFORREWORK', 'description' => 'Issuing stock for rework or quality improvement.', 'priority' => 25, 'status' => 1, 'calculation_type' => 'OUT'],
        ];



        foreach ($stockMovementTypes as $value) {
            StockMomentType::firstOrCreate(
                ['code' => $value['code']],
                $value
            );
        }
    }
}
