<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use App\Models\StorageSetting;

class StorageSettingTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        StorageSetting::truncate();

        $data = [
            [
                'storage_type'            => 's3_bucket',
                'bucket_name'             => 'metaminthealth',
                'bucket_code'             => 'metaminthealth',
                'main_folder'             => '',
                'access_key'              => 'AKIAWTOYZ5EQ724DOF4F',
                'secret_key'              => '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',
                'region'                  => 'ap-south-1',
                'acl'                     => 'public-read',
                'storage_max_upload_size' => '5000',
                'storage_validation'      => 'docx,gif,jpeg,jpg,pdf,png,pptx,ppt,svg,img',
                'storage_limit'           => '5',
                'first_activation_date'   => date('Y-m-d'),
                'last_renewal_date'       => date('Y-m-d'),
                'next_renewal_date'       => date('Y-m-d', strtotime('+1 year')),
                'status'                  => 1,
            ],
        ];

        foreach ($data as $value) {
            StorageSetting::firstOrCreate([
                'storage_type' => $value['storage_type'],
                'bucket_name'  => $value['bucket_name'],
                'bucket_code'  => $value['bucket_code'],
                'main_folder'  => $value['main_folder'],
                'access_key'   => $value['access_key'],
                'secret_key'   => $value['secret_key'],
            ],$value);
        }
    }
}
