<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\StudentHouse;

class StudentHouseTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        /**
         * Reset the MasterType table
         */
        // if (\App::environment('local')) {
        //     StudentHouse::truncate();
        // }

        $types = [
            [
                'name'  => 'Blue',
                'code'  => 'BLUE',
            ], [
                'name'  => 'Red',
                'code'  => 'RED'
            ], [
                'name'  => 'Green',
                'code'  => 'GREEN'
            ], [
                'name'  => 'Yellow',
                'code'  => 'YELLOW'
            ]
        ];

        foreach ($types as $value) {
            StudentHouse::firstOrCreate(
                ['code' => $value['code']],
                $value
            );
        }
    }
}
