<?php

namespace Database\Seeders;

use App\Models\StudyMaterialType;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class StudyMaterialTypesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $style_types = [
		    [
				'name'            => 'Syllabus',
				'status'          => 1,
				'is_default'      => 1,
		    ],
		    [
				'name'            => 'Question Paper',
				'status'          => 1,
				'is_default'      => 0,
		    ],
		    [
				'name'            => 'Assignment',
				'status'          => 1,
				'is_default'      => 0,
		    ],
            [
				'name'            => 'Study Material',
				'status'          => 1,
				'is_default'      => 0,
		    ],
            [
				'name'            => 'Internal Examination Result',
				'status'          => 1,
				'is_default'      => 0,
		    ],
		];

        foreach ($style_types as $value) {
            StudyMaterialType::firstOrCreate(
                ['name' => $value['name']],
                $value
            );
        }
    }
}
