<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\StyleType;

class StyleTypeTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $style_types = [
		    [
				'name'            => 'NORMAL',
                'code'            => 'normal',
				'font_color'      => '#000000',
				'bg_color'        => '#ffffff',
				'font_family'     => 9,
				'text_decoration' => 'none',
				'font_size'       => '12',
				'font_style'      => 'normal',
				'font_weight'     => 'normal',
				'status'          => 1,
				'is_default'      => 1,
		    ],
		    [
				'name'            => 'LOW',
                'code'            => 'low',
				'font_color'      => '#09597c',
				'bg_color'        => '#ffffff',
				'font_family'     => 9,
				'text_decoration' => 'none',
				'font_size'       => '12',
				'font_style'      => 'normal',
				'font_weight'     => 'bold',
				'status'          => 1,
				'is_default'      => 0,
		    ],
		    [
				'name'            => 'HIGH',
                'code'            => 'high',
				'font_color'      => '#aa0916',
				'bg_color'        => '#ffffff',
				'font_family'     => 13,
				'text_decoration' => 'none',
				'font_size'       => '12',
				'font_style'      => 'normal',
				'font_weight'     => 'bold',
				'status'          => 1,
				'is_default'      => 0,
		    ],
		];

        foreach ($style_types as $value) {
            StyleType::firstOrCreate(
                ['code' => $value['code']],
                $value
            );
        }


    }
}
