<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class SymptomsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        if (\App::environment('local')) {
            \DB::table('symptoms')->truncate();
        }

        DB::statement("
        INSERT INTO `symptoms` (`id`, `symptoms_title`, `description`, `code`, `status`, `priority`, `created_at`, `updated_at`, `type`) VALUES
        (1, 'Cholera due to Vibrio cholerae 01, biovar cholerae', '', 'A000', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (2, 'Cholera due to Vibrio cholerae 01, biovar eltor', '', 'A001', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (3, 'Cholera, unspecified', '', 'A009', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (4, 'Typhoid fever, unspecified', '', 'A0100', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (5, 'Typhoid meningitis', '', 'A0101', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (6, 'Typhoid fever with heart involvement', '', 'A0102', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (7, 'Typhoid pneumonia', '', 'A0103', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (8, 'Typhoid arthritis', '', 'A0104', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (9, 'Typhoid osteomyelitis', '', 'A0105', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (10, 'Typhoid fever with other complications', '', 'A0109', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (11, 'Paratyphoid fever A', '', 'A011', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (12, 'Paratyphoid fever B', '', 'A012', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (13, 'Paratyphoid fever C', '', 'A013', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (14, 'Paratyphoid fever, unspecified', '', 'A014', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (15, 'Salmonella enteritis', '', 'A020', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (16, 'Salmonella sepsis', '', 'A021', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (17, 'Localized salmonella infection, unspecified', '', 'A0220', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (18, 'Salmonella meningitis', '', 'A0221', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (19, 'Salmonella pneumonia', '', 'A0222', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (20, 'Salmonella arthritis', '', 'A0223', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (21, 'Salmonella osteomyelitis', '', 'A0224', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (22, 'Salmonella pyelonephritis', '', 'A0225', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (23, 'Salmonella with other localized infection', '', 'A0229', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (24, 'Other specified salmonella infections', '', 'A028', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (25, 'Salmonella infection, unspecified', '', 'A029', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (26, 'Shigellosis due to Shigella dysenteriae', '', 'A030', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (27, 'Shigellosis due to Shigella flexneri', '', 'A031', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (28, 'Shigellosis due to Shigella boydii', '', 'A032', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (29, 'Shigellosis due to Shigella sonnei', '', 'A033', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (30, 'Other shigellosis', '', 'A038', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (31, 'Shigellosis, unspecified', '', 'A039', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (32, 'Enteropathogenic Escherichia coli infection', '', 'A040', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (33, 'Enterotoxigenic Escherichia coli infection', '', 'A041', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (34, 'Enteroinvasive Escherichia coli infection', '', 'A042', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (35, 'Enterohemorrhagic Escherichia coli infection', '', 'A043', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (36, 'Other intestinal Escherichia coli infections', '', 'A044', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (37, 'Campylobacter enteritis', '', 'A045', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (38, 'Enteritis due to Yersinia enterocolitica', '', 'A046', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (39, 'Enterocolitis due to Clostridium difficile', '', 'A047', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (40, 'Other specified bacterial intestinal infections', '', 'A048', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (41, 'Bacterial intestinal infection, unspecified', '', 'A049', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (42, 'Foodborne staphylococcal intoxication', '', 'A050', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (43, 'Botulism food poisoning', '', 'A051', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (44, 'Foodborne Clostridium perfringens [Clostridium welchii] intoxication', '', 'A052', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (45, 'Foodborne Vibrio parahaemolyticus intoxication', '', 'A053', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (46, 'Foodborne Bacillus cereus intoxication', '', 'A054', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (47, 'Foodborne Vibrio vulnificus intoxication', '', 'A055', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (48, 'Other specified bacterial foodborne intoxications', '', 'A058', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (49, 'Bacterial foodborne intoxication, unspecified', '', 'A059', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (50, 'Acute amebic dysentery', '', 'A060', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (51, 'Chronic intestinal amebiasis', '', 'A061', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (52, 'Amebic nondysenteric colitis', '', 'A062', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (53, 'Ameboma of intestine', '', 'A063', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (54, 'Amebic liver abscess', '', 'A064', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (55, 'Amebic lung abscess', '', 'A065', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (56, 'Amebic brain abscess', '', 'A066', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (57, 'Cutaneous amebiasis', '', 'A067', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (58, 'Amebic cystitis', '', 'A0681', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (59, 'Other amebic genitourinary infections', '', 'A0682', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (60, 'Other amebic infections', '', 'A0689', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (61, 'Amebiasis, unspecified', '', 'A069', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (62, 'Balantidiasis', '', 'A070', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (63, 'Giardiasis [lambliasis]', '', 'A071', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (64, 'Cryptosporidiosis', '', 'A072', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (65, 'Isosporiasis', '', 'A073', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (66, 'Cyclosporiasis', '', 'A074', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (67, 'Other specified protozoal intestinal diseases', '', 'A078', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (68, 'Protozoal intestinal disease, unspecified', '', 'A079', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (69, 'Rotaviral enteritis', '', 'A080', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (70, 'Acute gastroenteropathy due to Norwalk agent', '', 'A0811', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (71, 'Acute gastroenteropathy due to other small round viruses', '', 'A0819', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (72, 'Adenoviral enteritis', '', 'A082', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (73, 'Calicivirus enteritis', '', 'A0831', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (74, 'Astrovirus enteritis', '', 'A0832', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (75, 'Other viral enteritis', '', 'A0839', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (76, 'Viral intestinal infection, unspecified', '', 'A084', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (77, 'Other specified intestinal infections', '', 'A088', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (78, 'Infectious gastroenteritis and colitis, unspecified', '', 'A09', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (79, 'Tuberculosis of lung', '', 'A150', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (80, 'Tuberculosis of intrathoracic lymph nodes', '', 'A154', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (81, 'Tuberculosis of larynx, trachea and bronchus', '', 'A155', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (82, 'Tuberculous pleurisy', '', 'A156', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (83, 'Primary respiratory tuberculosis', '', 'A157', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (84, 'Other respiratory tuberculosis', '', 'A158', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (85, 'Respiratory tuberculosis unspecified', '', 'A159', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (86, 'Tuberculous meningitis', '', 'A170', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (87, 'Meningeal tuberculoma', '', 'A171', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (88, 'Tuberculoma of brain and spinal cord', '', 'A1781', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (89, 'Tuberculous meningoencephalitis', '', 'A1782', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (90, 'Tuberculous neuritis', '', 'A1783', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (91, 'Other tuberculosis of nervous system', '', 'A1789', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (92, 'Tuberculosis of nervous system, unspecified', '', 'A179', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (93, 'Tuberculosis of spine', '', 'A1801', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (94, 'Tuberculous arthritis of other joints', '', 'A1802', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (95, 'Tuberculosis of other bones', '', 'A1803', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (96, 'Other musculoskeletal tuberculosis', '', 'A1809', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (97, 'Tuberculosis of genitourinary system, unspecified', '', 'A1810', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (98, 'Tuberculosis of kidney and ureter', '', 'A1811', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (99, 'Tuberculosis of bladder', '', 'A1812', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (100, 'Tuberculosis of other urinary organs', '', 'A1813', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (101, 'Tuberculosis of prostate', '', 'A1814', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (102, 'Tuberculosis of other male genital organs', '', 'A1815', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (103, 'Tuberculosis of cervix', '', 'A1816', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (104, 'Tuberculous female pelvic inflammatory disease', '', 'A1817', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (105, 'Tuberculosis of other female genital organs', '', 'A1818', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (106, 'Tuberculous peripheral lymphadenopathy', '', 'A182', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (107, 'Tuberculous peritonitis', '', 'A1831', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (108, 'Tuberculous enteritis', '', 'A1832', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (109, 'Retroperitoneal tuberculosis', '', 'A1839', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (110, 'Tuberculosis of skin and subcutaneous tissue', '', 'A184', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (111, 'Tuberculosis of eye, unspecified', '', 'A1850', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (112, 'Tuberculous episcleritis', '', 'A1851', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (113, 'Tuberculous keratitis', '', 'A1852', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (114, 'Tuberculous chorioretinitis', '', 'A1853', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (115, 'Tuberculous iridocyclitis', '', 'A1854', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (116, 'Other tuberculosis of eye', '', 'A1859', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (117, 'Tuberculosis of (inner) (middle) ear', '', 'A186', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (118, 'Tuberculosis of adrenal glands', '', 'A187', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (119, 'Tuberculosis of thyroid gland', '', 'A1881', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (120, 'Tuberculosis of other endocrine glands', '', 'A1882', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (121, 'Tuberculosis of digestive tract organs, not elsewhere classified', '', 'A1883', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (122, 'Tuberculosis of heart', '', 'A1884', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (123, 'Tuberculosis of spleen', '', 'A1885', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (124, 'Tuberculosis of other sites', '', 'A1889', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (125, 'Acute miliary tuberculosis of a single specified site', '', 'A190', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (126, 'Acute miliary tuberculosis of multiple sites', '', 'A191', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (127, 'Acute miliary tuberculosis, unspecified', '', 'A192', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (128, 'Other miliary tuberculosis', '', 'A198', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (129, 'Miliary tuberculosis, unspecified', '', 'A199', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (130, 'Bubonic plague', '', 'A200', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (131, 'Cellulocutaneous plague', '', 'A201', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (132, 'Pneumonic plague', '', 'A202', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (133, 'Plague meningitis', '', 'A203', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (134, 'Septicemic plague', '', 'A207', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (135, 'Other forms of plague', '', 'A208', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (136, 'Plague, unspecified', '', 'A209', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (137, 'Ulceroglandular tularemia', '', 'A210', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (138, 'Oculoglandular tularemia', '', 'A211', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (139, 'Pulmonary tularemia', '', 'A212', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (140, 'Gastrointestinal tularemia', '', 'A213', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (141, 'Generalized tularemia', '', 'A217', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (142, 'Other forms of tularemia', '', 'A218', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (143, 'Tularemia, unspecified', '', 'A219', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (144, 'Cutaneous anthrax', '', 'A220', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (145, 'Pulmonary anthrax', '', 'A221', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (146, 'Gastrointestinal anthrax', '', 'A222', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (147, 'Anthrax sepsis', '', 'A227', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (148, 'Other forms of anthrax', '', 'A228', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (149, 'Anthrax, unspecified', '', 'A229', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (150, 'Brucellosis due to Brucella melitensis', '', 'A230', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (151, 'Brucellosis due to Brucella abortus', '', 'A231', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (152, 'Brucellosis due to Brucella suis', '', 'A232', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (153, 'Brucellosis due to Brucella canis', '', 'A233', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (154, 'Other brucellosis', '', 'A238', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (155, 'Brucellosis, unspecified', '', 'A239', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (156, 'Glanders', '', 'A240', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (157, 'Acute and fulminating melioidosis', '', 'A241', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (158, 'Subacute and chronic melioidosis', '', 'A242', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (159, 'Other melioidosis', '', 'A243', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (160, 'Melioidosis, unspecified', '', 'A249', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (161, 'Spirillosis', '', 'A250', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (162, 'Streptobacillosis', '', 'A251', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (163, 'Rat-bite fever, unspecified', '', 'A259', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (164, 'Cutaneous erysipeloid', '', 'A260', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (165, 'Erysipelothrix sepsis', '', 'A267', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (166, 'Other forms of erysipeloid', '', 'A268', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (167, 'Erysipeloid, unspecified', '', 'A269', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (168, 'Leptospirosis icterohemorrhagica', '', 'A270', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (169, 'Aseptic meningitis in leptospirosis', '', 'A2781', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (170, 'Other forms of leptospirosis', '', 'A2789', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (171, 'Leptospirosis, unspecified', '', 'A279', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (172, 'Pasteurellosis', '', 'A280', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (173, 'Cat-scratch disease', '', 'A281', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (174, 'Extraintestinal yersiniosis', '', 'A282', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (175, 'Other specified zoonotic bacterial diseases, not elsewhere classified', '', 'A288', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (176, 'Zoonotic bacterial disease, unspecified', '', 'A289', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (177, 'Indeterminate leprosy', '', 'A300', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (178, 'Tuberculoid leprosy', '', 'A301', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (179, 'Borderline tuberculoid leprosy', '', 'A302', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (180, 'Borderline leprosy', '', 'A303', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (181, 'Borderline lepromatous leprosy', '', 'A304', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (182, 'Lepromatous leprosy', '', 'A305', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (183, 'Other forms of leprosy', '', 'A308', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (184, 'Leprosy, unspecified', '', 'A309', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (185, 'Pulmonary mycobacterial infection', '', 'A310', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (186, 'Cutaneous mycobacterial infection', '', 'A311', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (187, 'Disseminated mycobacterium avium-intracellulare complex (DMAC)', '', 'A312', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (188, 'Other mycobacterial infections', '', 'A318', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (189, 'Mycobacterial infection, unspecified', '', 'A319', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (190, 'Cutaneous listeriosis', '', 'A320', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (191, 'Listerial meningitis', '', 'A3211', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (192, 'Listerial meningoencephalitis', '', 'A3212', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (193, 'Listerial sepsis', '', 'A327', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (194, 'Oculoglandular listeriosis', '', 'A3281', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (195, 'Listerial endocarditis', '', 'A3282', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (196, 'Other forms of listeriosis', '', 'A3289', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (197, 'Listeriosis, unspecified', '', 'A329', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (198, 'Tetanus neonatorum', '', 'A33', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (199, 'Obstetrical tetanus', '', 'A34', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (200, 'Other tetanus', '', 'A35', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (201, 'Pharyngeal diphtheria', '', 'A360', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (202, 'Nasopharyngeal diphtheria', '', 'A361', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (203, 'Laryngeal diphtheria', '', 'A362', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (204, 'Cutaneous diphtheria', '', 'A363', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (205, 'Diphtheritic cardiomyopathy', '', 'A3681', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (206, 'Diphtheritic radiculomyelitis', '', 'A3682', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (207, 'Diphtheritic polyneuritis', '', 'A3683', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (208, 'Diphtheritic tubulo-interstitial nephropathy', '', 'A3684', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (209, 'Diphtheritic cystitis', '', 'A3685', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (210, 'Diphtheritic conjunctivitis', '', 'A3686', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (211, 'Other diphtheritic complications', '', 'A3689', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (212, 'Diphtheria, unspecified', '', 'A369', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (213, 'Whooping cough due to Bordetella pertussis without pneumonia', '', 'A3700', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (214, 'Whooping cough due to Bordetella pertussis with pneumonia', '', 'A3701', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (215, 'Whooping cough due to Bordetella parapertussis without pneumonia', '', 'A3710', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (216, 'Whooping cough due to Bordetella parapertussis with pneumonia', '', 'A3711', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (217, 'Whooping cough due to other Bordetella species without pneumonia', '', 'A3780', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (218, 'Whooping cough due to other Bordetella species with pneumonia', '', 'A3781', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (219, 'Whooping cough, unspecified species without pneumonia', '', 'A3790', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (220, 'Whooping cough, unspecified species with pneumonia', '', 'A3791', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (221, 'Scarlet fever with otitis media', '', 'A380', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (222, 'Scarlet fever with myocarditis', '', 'A381', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (223, 'Scarlet fever with other complications', '', 'A388', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (224, 'Scarlet fever, uncomplicated', '', 'A389', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (225, 'Meningococcal meningitis', '', 'A390', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (226, 'Waterhouse-Friderichsen syndrome', '', 'A391', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (227, 'Acute meningococcemia', '', 'A392', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (228, 'Chronic meningococcemia', '', 'A393', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (229, 'Meningococcemia, unspecified', '', 'A394', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (230, 'Meningococcal carditis, unspecified', '', 'A3950', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (231, 'Meningococcal endocarditis', '', 'A3951', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (232, 'Meningococcal myocarditis', '', 'A3952', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (233, 'Meningococcal pericarditis', '', 'A3953', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (234, 'Meningococcal encephalitis', '', 'A3981', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (235, 'Meningococcal retrobulbar neuritis', '', 'A3982', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (236, 'Meningococcal arthritis', '', 'A3983', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (237, 'Postmeningococcal arthritis', '', 'A3984', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (238, 'Other meningococcal infections', '', 'A3989', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (239, 'Meningococcal infection, unspecified', '', 'A399', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (240, 'Sepsis due to streptococcus, group A', '', 'A400', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (241, 'Sepsis due to streptococcus, group B', '', 'A401', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (242, 'Sepsis due to Streptococcus pneumoniae', '', 'A403', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (243, 'Other streptococcal sepsis', '', 'A408', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (244, 'Streptococcal sepsis, unspecified', '', 'A409', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (245, 'Sepsis due to Methicillin susceptible Staphylococcus aureus', '', 'A4101', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (246, 'Sepsis due to Methicillin resistant Staphylococcus aureus', '', 'A4102', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (247, 'Sepsis due to other specified staphylococcus', '', 'A411', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (248, 'Sepsis due to unspecified staphylococcus', '', 'A412', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (249, 'Sepsis due to Hemophilus influenzae', '', 'A413', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (250, 'Sepsis due to anaerobes', '', 'A414', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (251, 'Gram-negative sepsis, unspecified', '', 'A4150', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (252, 'Sepsis due to Escherichia coli [E. coli]', '', 'A4151', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (253, 'Sepsis due to Pseudomonas', '', 'A4152', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (254, 'Sepsis due to Serratia', '', 'A4153', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (255, 'Other Gram-negative sepsis', '', 'A4159', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (256, 'Sepsis due to Enterococcus', '', 'A4181', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (257, 'Other specified sepsis', '', 'A4189', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (258, 'Sepsis, unspecified organism', '', 'A419', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (259, 'Pulmonary actinomycosis', '', 'A420', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (260, 'Abdominal actinomycosis', '', 'A421', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (261, 'Cervicofacial actinomycosis', '', 'A422', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (262, 'Actinomycotic sepsis', '', 'A427', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (263, 'Actinomycotic meningitis', '', 'A4281', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (264, 'Actinomycotic encephalitis', '', 'A4282', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (265, 'Other forms of actinomycosis', '', 'A4289', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (266, 'Actinomycosis, unspecified', '', 'A429', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (267, 'Pulmonary nocardiosis', '', 'A430', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (268, 'Cutaneous nocardiosis', '', 'A431', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (269, 'Other forms of nocardiosis', '', 'A438', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (270, 'Nocardiosis, unspecified', '', 'A439', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (271, 'Systemic bartonellosis', '', 'A440', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (272, 'Cutaneous and mucocutaneous bartonellosis', '', 'A441', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (273, 'Other forms of bartonellosis', '', 'A448', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (274, 'Bartonellosis, unspecified', '', 'A449', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (275, 'Erysipelas', '', 'A46', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (276, 'Gas gangrene', '', 'A480', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (277, 'Legionnaires\' disease', '', 'A481', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (278, 'Nonpneumonic Legionnaires\' disease [Pontiac fever]', '', 'A482', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (279, 'Toxic shock syndrome', '', 'A483', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (280, 'Brazilian purpuric fever', '', 'A484', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (281, 'Infant botulism', '', 'A4851', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (282, 'Wound botulism', '', 'A4852', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (283, 'Other specified bacterial diseases', '', 'A488', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (284, 'Methicillin susceptible Staphylococcus aureus infection, unspecified site', '', 'A4901', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (285, 'Methicillin resistant Staphylococcus aureus infection, unspecified site', '', 'A4902', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (286, 'Streptococcal infection, unspecified site', '', 'A491', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (287, 'Hemophilus influenzae infection, unspecified site', '', 'A492', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (288, 'Mycoplasma infection, unspecified site', '', 'A493', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (289, 'Other bacterial infections of unspecified site', '', 'A498', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (290, 'Bacterial infection, unspecified', '', 'A499', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (291, 'Early congenital syphilitic oculopathy', '', 'A5001', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (292, 'Early congenital syphilitic osteochondropathy', '', 'A5002', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (293, 'Early congenital syphilitic pharyngitis', '', 'A5003', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (294, 'Early congenital syphilitic pneumonia', '', 'A5004', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (295, 'Early congenital syphilitic rhinitis', '', 'A5005', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (296, 'Early cutaneous congenital syphilis', '', 'A5006', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (297, 'Early mucocutaneous congenital syphilis', '', 'A5007', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (298, 'Early visceral congenital syphilis', '', 'A5008', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (299, 'Other early congenital syphilis, symptomatic', '', 'A5009', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (300, 'Early congenital syphilis, latent', '', 'A501', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (301, 'Early congenital syphilis, unspecified', '', 'A502', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (302, 'Late congenital syphilitic oculopathy, unspecified', '', 'A5030', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (303, 'Late congenital syphilitic interstitial keratitis', '', 'A5031', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (304, 'Late congenital syphilitic chorioretinitis', '', 'A5032', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (305, 'Other late congenital syphilitic oculopathy', '', 'A5039', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (306, 'Late congenital neurosyphilis, unspecified', '', 'A5040', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (307, 'Late congenital syphilitic meningitis', '', 'A5041', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (308, 'Late congenital syphilitic encephalitis', '', 'A5042', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (309, 'Late congenital syphilitic polyneuropathy', '', 'A5043', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (310, 'Late congenital syphilitic optic nerve atrophy', '', 'A5044', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (311, 'Juvenile general paresis', '', 'A5045', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (312, 'Other late congenital neurosyphilis', '', 'A5049', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (313, 'Clutton\'s joints', '', 'A5051', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (314, 'Hutchinson\'s teeth', '', 'A5052', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (315, 'Hutchinson\'s triad', '', 'A5053', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (316, 'Late congenital cardiovascular syphilis', '', 'A5054', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (317, 'Late congenital syphilitic arthropathy', '', 'A5055', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (318, 'Late congenital syphilitic osteochondropathy', '', 'A5056', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (319, 'Syphilitic saddle nose', '', 'A5057', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (320, 'Other late congenital syphilis, symptomatic', '', 'A5059', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (321, 'Late congenital syphilis, latent', '', 'A506', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (322, 'Late congenital syphilis, unspecified', '', 'A507', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (323, 'Congenital syphilis, unspecified', '', 'A509', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (324, 'Primary genital syphilis', '', 'A510', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (325, 'Primary anal syphilis', '', 'A511', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (326, 'Primary syphilis of other sites', '', 'A512', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (327, 'Condyloma latum', '', 'A5131', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (328, 'Syphilitic alopecia', '', 'A5132', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (329, 'Other secondary syphilis of skin', '', 'A5139', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (330, 'Secondary syphilitic meningitis', '', 'A5141', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (331, 'Secondary syphilitic female pelvic disease', '', 'A5142', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (332, 'Secondary syphilitic oculopathy', '', 'A5143', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (333, 'Secondary syphilitic nephritis', '', 'A5144', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (334, 'Secondary syphilitic hepatitis', '', 'A5145', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (335, 'Secondary syphilitic osteopathy', '', 'A5146', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (336, 'Other secondary syphilitic conditions', '', 'A5149', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (337, 'Early syphilis, latent', '', 'A515', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (338, 'Early syphilis, unspecified', '', 'A519', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (339, 'Cardiovascular syphilis, unspecified', '', 'A5200', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (340, 'Syphilitic aneurysm of aorta', '', 'A5201', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (341, 'Syphilitic aortitis', '', 'A5202', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (342, 'Syphilitic endocarditis', '', 'A5203', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (343, 'Syphilitic cerebral arteritis', '', 'A5204', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (344, 'Other cerebrovascular syphilis', '', 'A5205', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (345, 'Other syphilitic heart involvement', '', 'A5206', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (346, 'Other cardiovascular syphilis', '', 'A5209', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (347, 'Symptomatic neurosyphilis, unspecified', '', 'A5210', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (348, 'Tabes dorsalis', '', 'A5211', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (349, 'Other cerebrospinal syphilis', '', 'A5212', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (350, 'Late syphilitic meningitis', '', 'A5213', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (351, 'Late syphilitic encephalitis', '', 'A5214', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (352, 'Late syphilitic neuropathy', '', 'A5215', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (353, 'Charcot\'s arthropathy (tabetic)', '', 'A5216', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (354, 'General paresis', '', 'A5217', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (355, 'Other symptomatic neurosyphilis', '', 'A5219', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (356, 'Asymptomatic neurosyphilis', '', 'A522', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (357, 'Neurosyphilis, unspecified', '', 'A523', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (358, 'Late syphilitic oculopathy', '', 'A5271', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (359, 'Syphilis of lung and bronchus', '', 'A5272', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (360, 'Symptomatic late syphilis of other respiratory organs', '', 'A5273', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (361, 'Syphilis of liver and other viscera', '', 'A5274', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (362, 'Syphilis of kidney and ureter', '', 'A5275', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (363, 'Other genitourinary symptomatic late syphilis', '', 'A5276', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (364, 'Syphilis of bone and joint', '', 'A5277', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (365, 'Syphilis of other musculoskeletal tissue', '', 'A5278', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (366, 'Other symptomatic late syphilis', '', 'A5279', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (367, 'Late syphilis, latent', '', 'A528', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (368, 'Late syphilis, unspecified', '', 'A529', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (369, 'Latent syphilis, unspecified as early or late', '', 'A530', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (370, 'Syphilis, unspecified', '', 'A539', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (371, 'Gonococcal infection of lower genitourinary tract, unspecified', '', 'A5400', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (372, 'Gonococcal cystitis and urethritis, unspecified', '', 'A5401', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (373, 'Gonococcal vulvovaginitis, unspecified', '', 'A5402', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (374, 'Gonococcal cervicitis, unspecified', '', 'A5403', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (375, 'Other gonococcal infection of lower genitourinary tract', '', 'A5409', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (376, 'Gonococcal infection of lower genitourinary tract with periurethral and accessory gland abscess', '', 'A541', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (377, 'Gonococcal infection of kidney and ureter', '', 'A5421', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (378, 'Gonococcal prostatitis', '', 'A5422', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (379, 'Gonococcal infection of other male genital organs', '', 'A5423', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (380, 'Gonococcal female pelvic inflammatory disease', '', 'A5424', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (381, 'Other gonococcal genitourinary infections', '', 'A5429', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (382, 'Gonococcal infection of eye, unspecified', '', 'A5430', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (383, 'Gonococcal conjunctivitis', '', 'A5431', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (384, 'Gonococcal iridocyclitis', '', 'A5432', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (385, 'Gonococcal keratitis', '', 'A5433', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (386, 'Other gonococcal eye infection', '', 'A5439', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (387, 'Gonococcal infection of musculoskeletal system, unspecified', '', 'A5440', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (388, 'Gonococcal spondylopathy', '', 'A5441', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (389, 'Gonococcal arthritis', '', 'A5442', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (390, 'Gonococcal osteomyelitis', '', 'A5443', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (391, 'Gonococcal infection of other musculoskeletal tissue', '', 'A5449', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (392, 'Gonococcal pharyngitis', '', 'A545', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (393, 'Gonococcal infection of anus and rectum', '', 'A546', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (394, 'Gonococcal meningitis', '', 'A5481', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (395, 'Gonococcal brain abscess', '', 'A5482', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (396, 'Gonococcal heart infection', '', 'A5483', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (397, 'Gonococcal pneumonia', '', 'A5484', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (398, 'Gonococcal peritonitis', '', 'A5485', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (399, 'Gonococcal sepsis', '', 'A5486', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (400, 'Other gonococcal infections', '', 'A5489', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (401, 'Gonococcal infection, unspecified', '', 'A549', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (402, 'Chlamydial lymphogranuloma (venereum)', '', 'A55', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (403, 'Chlamydial infection of lower genitourinary tract, unspecified', '', 'A5600', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (404, 'Chlamydial cystitis and urethritis', '', 'A5601', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (405, 'Chlamydial vulvovaginitis', '', 'A5602', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (406, 'Other chlamydial infection of lower genitourinary tract', '', 'A5609', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (407, 'Chlamydial female pelvic inflammatory disease', '', 'A5611', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (408, 'Other chlamydial genitourinary infection', '', 'A5619', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (409, 'Chlamydial infection of genitourinary tract, unspecified', '', 'A562', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (410, 'Chlamydial infection of anus and rectum', '', 'A563', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (411, 'Chlamydial infection of pharynx', '', 'A564', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (412, 'Sexually transmitted chlamydial infection of other sites', '', 'A568', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (413, 'Chancroid', '', 'A57', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (414, 'Granuloma inguinale', '', 'A58', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (415, 'Urogenital trichomoniasis, unspecified', '', 'A5900', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (416, 'Trichomonal vulvovaginitis', '', 'A5901', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (417, 'Trichomonal prostatitis', '', 'A5902', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (418, 'Trichomonal cystitis and urethritis', '', 'A5903', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (419, 'Other urogenital trichomoniasis', '', 'A5909', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (420, 'Trichomoniasis of other sites', '', 'A598', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (421, 'Trichomoniasis, unspecified', '', 'A599', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (422, 'Herpesviral infection of urogenital system, unspecified', '', 'A6000', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (423, 'Herpesviral infection of penis', '', 'A6001', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (424, 'Herpesviral infection of other male genital organs', '', 'A6002', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (425, 'Herpesviral cervicitis', '', 'A6003', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (426, 'Herpesviral vulvovaginitis', '', 'A6004', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (427, 'Herpesviral infection of other urogenital tract', '', 'A6009', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (428, 'Herpesviral infection of perianal skin and rectum', '', 'A601', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (429, 'Anogenital herpesviral infection, unspecified', '', 'A609', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (430, 'Anogenital (venereal) warts', '', 'A630', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (431, 'Other specified predominantly sexually transmitted diseases', '', 'A638', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (432, 'Unspecified sexually transmitted disease', '', 'A64', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (433, 'Nonvenereal syphilis', '', 'A65', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (434, 'Initial lesions of yaws', '', 'A660', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (435, 'Multiple papillomata and wet crab yaws', '', 'A661', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (436, 'Other early skin lesions of yaws', '', 'A662', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (437, 'Hyperkeratosis of yaws', '', 'A663', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (438, 'Gummata and ulcers of yaws', '', 'A664', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (439, 'Gangosa', '', 'A665', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (440, 'Bone and joint lesions of yaws', '', 'A666', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (441, 'Other manifestations of yaws', '', 'A667', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (442, 'Latent yaws', '', 'A668', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (443, 'Yaws, unspecified', '', 'A669', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (444, 'Primary lesions of pinta', '', 'A670', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (445, 'Intermediate lesions of pinta', '', 'A671', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (446, 'Late lesions of pinta', '', 'A672', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (447, 'Mixed lesions of pinta', '', 'A673', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (448, 'Pinta, unspecified', '', 'A679', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (449, 'Louse-borne relapsing fever', '', 'A680', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (450, 'Tick-borne relapsing fever', '', 'A681', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (451, 'Relapsing fever, unspecified', '', 'A689', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
        (452, 'Necrotizing ulcerative stomatitis', '', 'A690', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1);");


    DB::statement("
    INSERT INTO `symptoms` (`id`, `symptoms_title`, `description`, `code`, `status`, `priority`, `created_at`, `updated_at`, `type`) VALUES
    (453, 'Other Vincent\'s infections', '', 'A691', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (454, 'Lyme disease, unspecified', '', 'A6920', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (455, 'Meningitis due to Lyme disease', '', 'A6921', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (456, 'Other neurologic disorders in Lyme disease', '', 'A6922', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (457, 'Arthritis due to Lyme disease', '', 'A6923', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (458, 'Other conditions associated with Lyme disease', '', 'A6929', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (459, 'Other specified spirochetal infections', '', 'A698', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (460, 'Spirochetal infection, unspecified', '', 'A699', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (461, 'Chlamydia psittaci infections', '', 'A70', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (462, 'Initial stage of trachoma', '', 'A710', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (463, 'Active stage of trachoma', '', 'A711', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (464, 'Trachoma, unspecified', '', 'A719', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (465, 'Chlamydial conjunctivitis', '', 'A740', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (466, 'Chlamydial peritonitis', '', 'A7481', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (467, 'Other chlamydial diseases', '', 'A7489', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (468, 'Chlamydial infection, unspecified', '', 'A749', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (469, 'Epidemic louse-borne typhus fever due to Rickettsia prowazekii', '', 'A750', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (470, 'Recrudescent typhus [Brill\'s disease]', '', 'A751', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (471, 'Typhus fever due to Rickettsia typhi', '', 'A752', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (472, 'Typhus fever due to Rickettsia tsutsugamushi', '', 'A753', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (473, 'Typhus fever, unspecified', '', 'A759', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (474, 'Spotted fever due to Rickettsia rickettsii', '', 'A770', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (475, 'Spotted fever due to Rickettsia conorii', '', 'A771', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (476, 'Spotted fever due to Rickettsia siberica', '', 'A772', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (477, 'Spotted fever due to Rickettsia australis', '', 'A773', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (478, 'Ehrlichiosis, unspecified', '', 'A7740', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (479, 'Ehrlichiosis chafeensis [E. chafeensis]', '', 'A7741', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (480, 'Other ehrlichiosis', '', 'A7749', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (481, 'Other spotted fevers', '', 'A778', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (482, 'Spotted fever, unspecified', '', 'A779', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (483, 'Q fever', '', 'A78', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (484, 'Trench fever', '', 'A790', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (485, 'Rickettsialpox due to Rickettsia akari', '', 'A791', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (486, 'Rickettsiosis due to Ehrlichia sennetsu', '', 'A7981', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (487, 'Other specified rickettsioses', '', 'A7989', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (488, 'Rickettsiosis, unspecified', '', 'A799', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (489, 'Acute paralytic poliomyelitis, vaccine-associated', '', 'A800', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (490, 'Acute paralytic poliomyelitis, wild virus, imported', '', 'A801', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (491, 'Acute paralytic poliomyelitis, wild virus, indigenous', '', 'A802', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (492, 'Acute paralytic poliomyelitis, unspecified', '', 'A8030', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (493, 'Other acute paralytic poliomyelitis', '', 'A8039', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (494, 'Acute nonparalytic poliomyelitis', '', 'A804', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (495, 'Acute poliomyelitis, unspecified', '', 'A809', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (496, 'Creutzfeldt-Jakob disease, unspecified', '', 'A8100', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (497, 'Variant Creutzfeldt-Jakob disease', '', 'A8101', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (498, 'Other Creutzfeldt-Jakob disease', '', 'A8109', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (499, 'Subacute sclerosing panencephalitis', '', 'A811', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (500, 'Progressive multifocal leukoencephalopathy', '', 'A812', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (501, 'Kuru', '', 'A8181', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (502, 'Gerstmann-Straussler-Scheinker syndrome', '', 'A8182', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (503, 'Fatal familial insomnia', '', 'A8183', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (504, 'Other atypical virus infections of central nervous system', '', 'A8189', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (505, 'Atypical virus infection of central nervous system, unspecified', '', 'A819', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (506, 'Sylvatic rabies', '', 'A820', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (507, 'Urban rabies', '', 'A821', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (508, 'Rabies, unspecified', '', 'A829', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (509, 'Japanese encephalitis', '', 'A830', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (510, 'Western equine encephalitis', '', 'A831', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (511, 'Eastern equine encephalitis', '', 'A832', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (512, 'St Louis encephalitis', '', 'A833', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (513, 'Australian encephalitis', '', 'A834', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (514, 'California encephalitis', '', 'A835', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (515, 'Rocio virus disease', '', 'A836', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (516, 'Other mosquito-borne viral encephalitis', '', 'A838', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (517, 'Mosquito-borne viral encephalitis, unspecified', '', 'A839', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (518, 'Far Eastern tick-borne encephalitis [Russian spring-summer encephalitis]', '', 'A840', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (519, 'Central European tick-borne encephalitis', '', 'A841', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (520, 'Other tick-borne viral encephalitis', '', 'A848', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (521, 'Tick-borne viral encephalitis, unspecified', '', 'A849', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (522, 'Enteroviral encephalitis', '', 'A850', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (523, 'Adenoviral encephalitis', '', 'A851', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (524, 'Arthropod-borne viral encephalitis, unspecified', '', 'A852', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (525, 'Other specified viral encephalitis', '', 'A858', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (526, 'Unspecified viral encephalitis', '', 'A86', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (527, 'Enteroviral meningitis', '', 'A870', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (528, 'Adenoviral meningitis', '', 'A871', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (529, 'Lymphocytic choriomeningitis', '', 'A872', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (530, 'Other viral meningitis', '', 'A878', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (531, 'Viral meningitis, unspecified', '', 'A879', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (532, 'Enteroviral exanthematous fever [Boston exanthem]', '', 'A880', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (533, 'Epidemic vertigo', '', 'A881', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (534, 'Other specified viral infections of central nervous system', '', 'A888', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (535, 'Unspecified viral infection of central nervous system', '', 'A89', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (536, 'Dengue fever [classical dengue]', '', 'A90', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (537, 'Dengue hemorrhagic fever', '', 'A91', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (538, 'Chikungunya virus disease', '', 'A920', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (539, 'O\'nyong-nyong fever', '', 'A921', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (540, 'Venezuelan equine fever', '', 'A922', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (541, 'West Nile virus infection, unspecified', '', 'A9230', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (542, 'West Nile virus infection with encephalitis', '', 'A9231', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (543, 'West Nile virus infection with other neurologic manifestation', '', 'A9232', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (544, 'West Nile virus infection with other complications', '', 'A9239', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (545, 'Rift Valley fever', '', 'A924', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (546, 'Zika virus disease', '', 'A925', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (547, 'Other specified mosquito-borne viral fevers', '', 'A928', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (548, 'Mosquito-borne viral fever, unspecified', '', 'A929', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (549, 'Oropouche virus disease', '', 'A930', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (550, 'Sandfly fever', '', 'A931', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (551, 'Colorado tick fever', '', 'A932', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (552, 'Other specified arthropod-borne viral fevers', '', 'A938', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (553, 'Unspecified arthropod-borne viral fever', '', 'A94', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (554, 'Sylvatic yellow fever', '', 'A950', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (555, 'Urban yellow fever', '', 'A951', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (556, 'Yellow fever, unspecified', '', 'A959', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (557, 'Junin hemorrhagic fever', '', 'A960', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (558, 'Machupo hemorrhagic fever', '', 'A961', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (559, 'Lassa fever', '', 'A962', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (560, 'Other arenaviral hemorrhagic fevers', '', 'A968', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (561, 'Arenaviral hemorrhagic fever, unspecified', '', 'A969', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (562, 'Crimean-Congo hemorrhagic fever', '', 'A980', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (563, 'Omsk hemorrhagic fever', '', 'A981', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (564, 'Kyasanur Forest disease', '', 'A982', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (565, 'Marburg virus disease', '', 'A983', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (566, 'Ebola virus disease', '', 'A984', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (567, 'Hemorrhagic fever with renal syndrome', '', 'A985', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (568, 'Other specified viral hemorrhagic fevers', '', 'A988', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (569, 'Unspecified viral hemorrhagic fever', '', 'A99', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (570, 'Eczema herpeticum', '', 'B000', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (571, 'Herpesviral vesicular dermatitis', '', 'B001', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (572, 'Herpesviral gingivostomatitis and pharyngotonsillitis', '', 'B002', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (573, 'Herpesviral meningitis', '', 'B003', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (574, 'Herpesviral encephalitis', '', 'B004', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (575, 'Herpesviral ocular disease, unspecified', '', 'B0050', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (576, 'Herpesviral iridocyclitis', '', 'B0051', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (577, 'Herpesviral keratitis', '', 'B0052', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (578, 'Herpesviral conjunctivitis', '', 'B0053', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (579, 'Other herpesviral disease of eye', '', 'B0059', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (580, 'Disseminated herpesviral disease', '', 'B007', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (581, 'Herpesviral hepatitis', '', 'B0081', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (582, 'Herpes simplex myelitis', '', 'B0082', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (583, 'Other herpesviral infection', '', 'B0089', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (584, 'Herpesviral infection, unspecified', '', 'B009', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (585, 'Varicella meningitis', '', 'B010', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (586, 'Varicella encephalitis and encephalomyelitis', '', 'B0111', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (587, 'Varicella myelitis', '', 'B0112', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (588, 'Varicella pneumonia', '', 'B012', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (589, 'Varicella keratitis', '', 'B0181', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (590, 'Other varicella complications', '', 'B0189', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (591, 'Varicella without complication', '', 'B019', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (592, 'Zoster encephalitis', '', 'B020', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (593, 'Zoster meningitis', '', 'B021', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (594, 'Postherpetic geniculate ganglionitis', '', 'B0221', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (595, 'Postherpetic trigeminal neuralgia', '', 'B0222', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (596, 'Postherpetic polyneuropathy', '', 'B0223', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (597, 'Postherpetic myelitis', '', 'B0224', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (598, 'Other postherpetic nervous system involvement', '', 'B0229', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (599, 'Zoster ocular disease, unspecified', '', 'B0230', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (600, 'Zoster conjunctivitis', '', 'B0231', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (601, 'Zoster iridocyclitis', '', 'B0232', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (602, 'Zoster keratitis', '', 'B0233', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (603, 'Zoster scleritis', '', 'B0234', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (604, 'Other herpes zoster eye disease', '', 'B0239', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (605, 'Disseminated zoster', '', 'B027', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (606, 'Zoster with other complications', '', 'B028', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (607, 'Zoster without complications', '', 'B029', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (608, 'Smallpox', '', 'B03', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (609, 'Monkeypox', '', 'B04', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (610, 'Measles complicated by encephalitis', '', 'B050', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (611, 'Measles complicated by meningitis', '', 'B051', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (612, 'Measles complicated by pneumonia', '', 'B052', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (613, 'Measles complicated by otitis media', '', 'B053', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (614, 'Measles with intestinal complications', '', 'B054', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (615, 'Measles keratitis and keratoconjunctivitis', '', 'B0581', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (616, 'Other measles complications', '', 'B0589', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (617, 'Measles without complication', '', 'B059', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (618, 'Rubella with neurological complication, unspecified', '', 'B0600', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (619, 'Rubella encephalitis', '', 'B0601', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (620, 'Rubella meningitis', '', 'B0602', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (621, 'Other neurological complications of rubella', '', 'B0609', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (622, 'Rubella pneumonia', '', 'B0681', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (623, 'Rubella arthritis', '', 'B0682', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (624, 'Other rubella complications', '', 'B0689', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (625, 'Rubella without complication', '', 'B069', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (626, 'Plantar wart', '', 'B070', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (627, 'Other viral warts', '', 'B078', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (628, 'Viral wart, unspecified', '', 'B079', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (629, 'Cowpox', '', 'B08010', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (630, 'Vaccinia not from vaccine', '', 'B08011', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (631, 'Orf virus disease', '', 'B0802', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (632, 'Pseudocowpox [milker\'s node]', '', 'B0803', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (633, 'Paravaccinia, unspecified', '', 'B0804', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (634, 'Other orthopoxvirus infections', '', 'B0809', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (635, 'Molluscum contagiosum', '', 'B081', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (636, 'Exanthema subitum [sixth disease], unspecified', '', 'B0820', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (637, 'Exanthema subitum [sixth disease] due to human herpesvirus 6', '', 'B0821', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (638, 'Exanthema subitum [sixth disease] due to human herpesvirus 7', '', 'B0822', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (639, 'Erythema infectiosum [fifth disease]', '', 'B083', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (640, 'Enteroviral vesicular stomatitis with exanthem', '', 'B084', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (641, 'Enteroviral vesicular pharyngitis', '', 'B085', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (642, 'Parapoxvirus infection, unspecified', '', 'B0860', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (643, 'Bovine stomatitis', '', 'B0861', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (644, 'Sealpox', '', 'B0862', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (645, 'Other parapoxvirus infections', '', 'B0869', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (646, 'Yatapoxvirus infection, unspecified', '', 'B0870', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (647, 'Tanapox virus disease', '', 'B0871', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (648, 'Yaba pox virus disease', '', 'B0872', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (649, 'Other yatapoxvirus infections', '', 'B0879', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (650, 'Other specified viral infections characterized by skin and mucous membrane lesions', '', 'B088', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (651, 'Unspecified viral infection characterized by skin and mucous membrane lesions', '', 'B09', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (652, 'Human herpesvirus 6 encephalitis', '', 'B1001', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (653, 'Other human herpesvirus encephalitis', '', 'B1009', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (654, 'Human herpesvirus 6 infection', '', 'B1081', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (655, 'Human herpesvirus 7 infection', '', 'B1082', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (656, 'Other human herpesvirus infection', '', 'B1089', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (657, 'Hepatitis A with hepatic coma', '', 'B150', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (658, 'Hepatitis A without hepatic coma', '', 'B159', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (659, 'Acute hepatitis B with delta-agent with hepatic coma', '', 'B160', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (660, 'Acute hepatitis B with delta-agent without hepatic coma', '', 'B161', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (661, 'Acute hepatitis B without delta-agent with hepatic coma', '', 'B162', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (662, 'Acute hepatitis B without delta-agent and without hepatic coma', '', 'B169', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (663, 'Acute delta-(super) infection of hepatitis B carrier', '', 'B170', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (664, 'Acute hepatitis C without hepatic coma', '', 'B1710', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (665, 'Acute hepatitis C with hepatic coma', '', 'B1711', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (666, 'Acute hepatitis E', '', 'B172', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (667, 'Other specified acute viral hepatitis', '', 'B178', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (668, 'Acute viral hepatitis, unspecified', '', 'B179', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (669, 'Chronic viral hepatitis B with delta-agent', '', 'B180', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (670, 'Chronic viral hepatitis B without delta-agent', '', 'B181', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (671, 'Chronic viral hepatitis C', '', 'B182', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (672, 'Other chronic viral hepatitis', '', 'B188', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (673, 'Chronic viral hepatitis, unspecified', '', 'B189', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (674, 'Unspecified viral hepatitis with hepatic coma', '', 'B190', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (675, 'Unspecified viral hepatitis B without hepatic coma', '', 'B1910', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (676, 'Unspecified viral hepatitis B with hepatic coma', '', 'B1911', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (677, 'Unspecified viral hepatitis C without hepatic coma', '', 'B1920', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (678, 'Unspecified viral hepatitis C with hepatic coma', '', 'B1921', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (679, 'Unspecified viral hepatitis without hepatic coma', '', 'B199', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (680, 'Human immunodeficiency virus [HIV] disease', '', 'B20', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (681, 'Cytomegaloviral pneumonitis', '', 'B250', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (682, 'Cytomegaloviral hepatitis', '', 'B251', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (683, 'Cytomegaloviral pancreatitis', '', 'B252', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (684, 'Other cytomegaloviral diseases', '', 'B258', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (685, 'Cytomegaloviral disease, unspecified', '', 'B259', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (686, 'Mumps orchitis', '', 'B260', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (687, 'Mumps meningitis', '', 'B261', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (688, 'Mumps encephalitis', '', 'B262', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (689, 'Mumps pancreatitis', '', 'B263', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (690, 'Mumps hepatitis', '', 'B2681', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (691, 'Mumps myocarditis', '', 'B2682', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (692, 'Mumps nephritis', '', 'B2683', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (693, 'Mumps polyneuropathy', '', 'B2684', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (694, 'Mumps arthritis', '', 'B2685', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (695, 'Other mumps complications', '', 'B2689', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (696, 'Mumps without complication', '', 'B269', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (697, 'Gammaherpesviral mononucleosis without complication', '', 'B2700', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (698, 'Gammaherpesviral mononucleosis with polyneuropathy', '', 'B2701', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (699, 'Gammaherpesviral mononucleosis with meningitis', '', 'B2702', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (700, 'Gammaherpesviral mononucleosis with other complications', '', 'B2709', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (701, 'Cytomegaloviral mononucleosis without complications', '', 'B2710', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (702, 'Cytomegaloviral mononucleosis with polyneuropathy', '', 'B2711', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (703, 'Cytomegaloviral mononucleosis with meningitis', '', 'B2712', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (704, 'Cytomegaloviral mononucleosis with other complication', '', 'B2719', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (705, 'Other infectious mononucleosis without complication', '', 'B2780', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (706, 'Other infectious mononucleosis with polyneuropathy', '', 'B2781', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (707, 'Other infectious mononucleosis with meningitis', '', 'B2782', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (708, 'Other infectious mononucleosis with other complication', '', 'B2789', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (709, 'Infectious mononucleosis, unspecified without complication', '', 'B2790', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (710, 'Infectious mononucleosis, unspecified with polyneuropathy', '', 'B2791', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (711, 'Infectious mononucleosis, unspecified with meningitis', '', 'B2792', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (712, 'Infectious mononucleosis, unspecified with other complication', '', 'B2799', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (713, 'Keratoconjunctivitis due to adenovirus', '', 'B300', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (714, 'Conjunctivitis due to adenovirus', '', 'B301', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (715, 'Viral pharyngoconjunctivitis', '', 'B302', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (716, 'Acute epidemic hemorrhagic conjunctivitis (enteroviral)', '', 'B303', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (717, 'Other viral conjunctivitis', '', 'B308', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (718, 'Viral conjunctivitis, unspecified', '', 'B309', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (719, 'Epidemic myalgia', '', 'B330', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (720, 'Ross River disease', '', 'B331', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (721, 'Viral carditis, unspecified', '', 'B3320', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (722, 'Viral endocarditis', '', 'B3321', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (723, 'Viral myocarditis', '', 'B3322', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (724, 'Viral pericarditis', '', 'B3323', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (725, 'Viral cardiomyopathy', '', 'B3324', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (726, 'Retrovirus infections, not elsewhere classified', '', 'B333', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (727, 'Hantavirus (cardio)-pulmonary syndrome [HPS] [HCPS]', '', 'B334', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (728, 'Other specified viral diseases', '', 'B338', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (729, 'Adenovirus infection, unspecified', '', 'B340', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (730, 'Enterovirus infection, unspecified', '', 'B341', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (731, 'Coronavirus infection, unspecified', '', 'B342', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (732, 'Parvovirus infection, unspecified', '', 'B343', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (733, 'Papovavirus infection, unspecified', '', 'B344', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (734, 'Other viral infections of unspecified site', '', 'B348', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (735, 'Viral infection, unspecified', '', 'B349', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (736, 'Tinea barbae and tinea capitis', '', 'B350', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (737, 'Tinea unguium', '', 'B351', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (738, 'Tinea manuum', '', 'B352', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (739, 'Tinea pedis', '', 'B353', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (740, 'Tinea corporis', '', 'B354', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (741, 'Tinea imbricata', '', 'B355', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (742, 'Tinea cruris', '', 'B356', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (743, 'Other dermatophytoses', '', 'B358', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (744, 'Dermatophytosis, unspecified', '', 'B359', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (745, 'Pityriasis versicolor', '', 'B360', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (746, 'Tinea nigra', '', 'B361', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (747, 'White piedra', '', 'B362', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (748, 'Black piedra', '', 'B363', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (749, 'Other specified superficial mycoses', '', 'B368', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (750, 'Superficial mycosis, unspecified', '', 'B369', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (751, 'Candidal stomatitis', '', 'B370', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (752, 'Pulmonary candidiasis', '', 'B371', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (753, 'Candidiasis of skin and nail', '', 'B372', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (754, 'Candidiasis of vulva and vagina', '', 'B373', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (755, 'Candidal cystitis and urethritis', '', 'B3741', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (756, 'Candidal balanitis', '', 'B3742', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (757, 'Other urogenital candidiasis', '', 'B3749', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (758, 'Candidal meningitis', '', 'B375', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (759, 'Candidal endocarditis', '', 'B376', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (760, 'Candidal sepsis', '', 'B377', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (761, 'Candidal esophagitis', '', 'B3781', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (762, 'Candidal enteritis', '', 'B3782', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (763, 'Candidal cheilitis', '', 'B3783', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (764, 'Candidal otitis externa', '', 'B3784', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (765, 'Other sites of candidiasis', '', 'B3789', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (766, 'Candidiasis, unspecified', '', 'B379', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (767, 'Acute pulmonary coccidioidomycosis', '', 'B380', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (768, 'Chronic pulmonary coccidioidomycosis', '', 'B381', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (769, 'Pulmonary coccidioidomycosis, unspecified', '', 'B382', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (770, 'Cutaneous coccidioidomycosis', '', 'B383', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (771, 'Coccidioidomycosis meningitis', '', 'B384', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (772, 'Disseminated coccidioidomycosis', '', 'B387', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (773, 'Prostatic coccidioidomycosis', '', 'B3881', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (774, 'Other forms of coccidioidomycosis', '', 'B3889', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (775, 'Coccidioidomycosis, unspecified', '', 'B389', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (776, 'Acute pulmonary histoplasmosis capsulati', '', 'B390', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (777, 'Chronic pulmonary histoplasmosis capsulati', '', 'B391', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (778, 'Pulmonary histoplasmosis capsulati, unspecified', '', 'B392', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (779, 'Disseminated histoplasmosis capsulati', '', 'B393', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (780, 'Histoplasmosis capsulati, unspecified', '', 'B394', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (781, 'Histoplasmosis duboisii', '', 'B395', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (782, 'Histoplasmosis, unspecified', '', 'B399', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (783, 'Acute pulmonary blastomycosis', '', 'B400', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (784, 'Chronic pulmonary blastomycosis', '', 'B401', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (785, 'Pulmonary blastomycosis, unspecified', '', 'B402', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (786, 'Cutaneous blastomycosis', '', 'B403', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (787, 'Disseminated blastomycosis', '', 'B407', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (788, 'Blastomycotic meningoencephalitis', '', 'B4081', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (789, 'Other forms of blastomycosis', '', 'B4089', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (790, 'Blastomycosis, unspecified', '', 'B409', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (791, 'Pulmonary paracoccidioidomycosis', '', 'B410', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (792, 'Disseminated paracoccidioidomycosis', '', 'B417', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (793, 'Other forms of paracoccidioidomycosis', '', 'B418', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (794, 'Paracoccidioidomycosis, unspecified', '', 'B419', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (795, 'Pulmonary sporotrichosis', '', 'B420', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (796, 'Lymphocutaneous sporotrichosis', '', 'B421', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (797, 'Disseminated sporotrichosis', '', 'B427', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (798, 'Cerebral sporotrichosis', '', 'B4281', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (799, 'Sporotrichosis arthritis', '', 'B4282', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (800, 'Other forms of sporotrichosis', '', 'B4289', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (801, 'Sporotrichosis, unspecified', '', 'B429', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (802, 'Cutaneous chromomycosis', '', 'B430', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (803, 'Pheomycotic brain abscess', '', 'B431', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (804, 'Subcutaneous pheomycotic abscess and cyst', '', 'B432', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (805, 'Other forms of chromomycosis', '', 'B438', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (806, 'Chromomycosis, unspecified', '', 'B439', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (807, 'Invasive pulmonary aspergillosis', '', 'B440', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (808, 'Other pulmonary aspergillosis', '', 'B441', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (809, 'Tonsillar aspergillosis', '', 'B442', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (810, 'Disseminated aspergillosis', '', 'B447', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (811, 'Allergic bronchopulmonary aspergillosis', '', 'B4481', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (812, 'Other forms of aspergillosis', '', 'B4489', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (813, 'Aspergillosis, unspecified', '', 'B449', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (814, 'Pulmonary cryptococcosis', '', 'B450', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (815, 'Cerebral cryptococcosis', '', 'B451', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (816, 'Cutaneous cryptococcosis', '', 'B452', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (817, 'Osseous cryptococcosis', '', 'B453', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (818, 'Disseminated cryptococcosis', '', 'B457', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (819, 'Other forms of cryptococcosis', '', 'B458', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (820, 'Cryptococcosis, unspecified', '', 'B459', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (821, 'Pulmonary mucormycosis', '', 'B460', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (822, 'Rhinocerebral mucormycosis', '', 'B461', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (823, 'Gastrointestinal mucormycosis', '', 'B462', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (824, 'Cutaneous mucormycosis', '', 'B463', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (825, 'Disseminated mucormycosis', '', 'B464', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (826, 'Mucormycosis, unspecified', '', 'B465', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (827, 'Other zygomycoses', '', 'B468', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (828, 'Zygomycosis, unspecified', '', 'B469', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (829, 'Eumycetoma', '', 'B470', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (830, 'Actinomycetoma', '', 'B471', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (831, 'Mycetoma, unspecified', '', 'B479', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (832, 'Lobomycosis', '', 'B480', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (833, 'Rhinosporidiosis', '', 'B481', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (834, 'Allescheriasis', '', 'B482', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (835, 'Geotrichosis', '', 'B483', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (836, 'Penicillosis', '', 'B484', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (837, 'Other specified mycoses', '', 'B488', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (838, 'Unspecified mycosis', '', 'B49', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (839, 'Plasmodium falciparum malaria with cerebral complications', '', 'B500', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (840, 'Other severe and complicated Plasmodium falciparum malaria', '', 'B508', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (841, 'Plasmodium falciparum malaria, unspecified', '', 'B509', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (842, 'Plasmodium vivax malaria with rupture of spleen', '', 'B510', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (843, 'Plasmodium vivax malaria with other complications', '', 'B518', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (844, 'Plasmodium vivax malaria without complication', '', 'B519', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (845, 'Plasmodium malariae malaria with nephropathy', '', 'B520', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (846, 'Plasmodium malariae malaria with other complications', '', 'B528', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (847, 'Plasmodium malariae malaria without complication', '', 'B529', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (848, 'Plasmodium ovale malaria', '', 'B530', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (849, 'Malaria due to simian plasmodia', '', 'B531', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (850, 'Other malaria, not elsewhere classified', '', 'B538', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (851, 'Unspecified malaria', '', 'B54', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (852, 'Visceral leishmaniasis', '', 'B550', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (853, 'Cutaneous leishmaniasis', '', 'B551', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (854, 'Mucocutaneous leishmaniasis', '', 'B552', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (855, 'Leishmaniasis, unspecified', '', 'B559', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (856, 'Gambiense trypanosomiasis', '', 'B560', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (857, 'Rhodesiense trypanosomiasis', '', 'B561', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (858, 'African trypanosomiasis, unspecified', '', 'B569', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (859, 'Acute Chagas\' disease with heart involvement', '', 'B570', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (860, 'Acute Chagas\' disease without heart involvement', '', 'B571', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (861, 'Chagas\' disease (chronic) with heart involvement', '', 'B572', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (862, 'Chagas\' disease with digestive system involvement, unspecified', '', 'B5730', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (863, 'Megaesophagus in Chagas\' disease', '', 'B5731', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (864, 'Megacolon in Chagas\' disease', '', 'B5732', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (865, 'Other digestive system involvement in Chagas\' disease', '', 'B5739', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (866, 'Chagas\' disease with nervous system involvement, unspecified', '', 'B5740', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (867, 'Meningitis in Chagas\' disease', '', 'B5741', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (868, 'Meningoencephalitis in Chagas\' disease', '', 'B5742', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (869, 'Other nervous system involvement in Chagas\' disease', '', 'B5749', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (870, 'Chagas\' disease (chronic) with other organ involvement', '', 'B575', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (871, 'Toxoplasma oculopathy, unspecified', '', 'B5800', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (872, 'Toxoplasma chorioretinitis', '', 'B5801', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (873, 'Other toxoplasma oculopathy', '', 'B5809', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (874, 'Toxoplasma hepatitis', '', 'B581', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (875, 'Toxoplasma meningoencephalitis', '', 'B582', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (876, 'Pulmonary toxoplasmosis', '', 'B583', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (877, 'Toxoplasma myocarditis', '', 'B5881', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (878, 'Toxoplasma myositis', '', 'B5882', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (879, 'Toxoplasma tubulo-interstitial nephropathy', '', 'B5883', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (880, 'Toxoplasmosis with other organ involvement', '', 'B5889', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (881, 'Toxoplasmosis, unspecified', '', 'B589', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (882, 'Pneumocystosis', '', 'B59', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (883, 'Babesiosis', '', 'B600', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (884, 'Acanthamebiasis, unspecified', '', 'B6010', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (885, 'Meningoencephalitis due to Acanthamoeba (culbertsoni)', '', 'B6011', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (886, 'Conjunctivitis due to Acanthamoeba', '', 'B6012', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (887, 'Keratoconjunctivitis due to Acanthamoeba', '', 'B6013', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (888, 'Other acanthamebic disease', '', 'B6019', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (889, 'Naegleriasis', '', 'B602', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (890, 'Other specified protozoal diseases', '', 'B608', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (891, 'Unspecified protozoal disease', '', 'B64', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (892, 'Schistosomiasis due to Schistosoma haematobium [urinary schistosomiasis]', '', 'B650', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (893, 'Schistosomiasis due to Schistosoma mansoni [intestinal schistosomiasis]', '', 'B651', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (894, 'Schistosomiasis due to Schistosoma japonicum', '', 'B652', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (895, 'Cercarial dermatitis', '', 'B653', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (896, 'Other schistosomiasis', '', 'B658', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (897, 'Schistosomiasis, unspecified', '', 'B659', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (898, 'Opisthorchiasis', '', 'B660', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (899, 'Clonorchiasis', '', 'B661', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (900, 'Dicroceliasis', '', 'B662', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (901, 'Fascioliasis', '', 'B663', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (902, 'Paragonimiasis', '', 'B664', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (903, 'Fasciolopsiasis', '', 'B665', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
    (904, 'Other specified fluke infections', '', 'B668', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1);");


    DB::statement("
INSERT INTO `symptoms` (`id`, `symptoms_title`, `description`, `code`, `status`, `priority`, `created_at`, `updated_at`, `type`) VALUES
(905, 'Fluke infection, unspecified', '', 'B669', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(906, 'Echinococcus granulosus infection of liver', '', 'B670', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(907, 'Echinococcus granulosus infection of lung', '', 'B671', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(908, 'Echinococcus granulosus infection of bone', '', 'B672', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(909, 'Echinococcus granulosus infection, thyroid gland', '', 'B6731', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(910, 'Echinococcus granulosus infection, multiple sites', '', 'B6732', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(911, 'Echinococcus granulosus infection, other sites', '', 'B6739', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(912, 'Echinococcus granulosus infection, unspecified', '', 'B674', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(913, 'Echinococcus multilocularis infection of liver', '', 'B675', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(914, 'Echinococcus multilocularis infection, multiple sites', '', 'B6761', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(915, 'Echinococcus multilocularis infection, other sites', '', 'B6769', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(916, 'Echinococcus multilocularis infection, unspecified', '', 'B677', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(917, 'Echinococcosis, unspecified, of liver', '', 'B678', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(918, 'Echinococcosis, unspecified', '', 'B6790', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(919, 'Other echinococcosis', '', 'B6799', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(920, 'Taenia solium taeniasis', '', 'B680', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(921, 'Taenia saginata taeniasis', '', 'B681', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(922, 'Taeniasis, unspecified', '', 'B689', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(923, 'Cysticercosis of central nervous system', '', 'B690', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(924, 'Cysticercosis of eye', '', 'B691', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(925, 'Myositis in cysticercosis', '', 'B6981', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(926, 'Cysticercosis of other sites', '', 'B6989', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(927, 'Cysticercosis, unspecified', '', 'B699', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(928, 'Diphyllobothriasis', '', 'B700', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(929, 'Sparganosis', '', 'B701', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(930, 'Hymenolepiasis', '', 'B710', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(931, 'Dipylidiasis', '', 'B711', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(932, 'Other specified cestode infections', '', 'B718', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(933, 'Cestode infection, unspecified', '', 'B719', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(934, 'Dracunculiasis', '', 'B72', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(935, 'Onchocerciasis with eye involvement, unspecified', '', 'B7300', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(936, 'Onchocerciasis with endophthalmitis', '', 'B7301', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(937, 'Onchocerciasis with glaucoma', '', 'B7302', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(938, 'Onchocerciasis with other eye involvement', '', 'B7309', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(939, 'Onchocerciasis without eye disease', '', 'B731', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(940, 'Filariasis due to Wuchereria bancrofti', '', 'B740', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(941, 'Filariasis due to Brugia malayi', '', 'B741', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(942, 'Filariasis due to Brugia timori', '', 'B742', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(943, 'Loiasis', '', 'B743', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(944, 'Mansonelliasis', '', 'B744', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(945, 'Other filariases', '', 'B748', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(946, 'Filariasis, unspecified', '', 'B749', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(947, 'Trichinellosis', '', 'B75', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(948, 'Ancylostomiasis', '', 'B760', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(949, 'Necatoriasis', '', 'B761', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(950, 'Other hookworm diseases', '', 'B768', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(951, 'Hookworm disease, unspecified', '', 'B769', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(952, 'Ascariasis with intestinal complications', '', 'B770', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(953, 'Ascariasis pneumonia', '', 'B7781', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(954, 'Ascariasis with other complications', '', 'B7789', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(955, 'Ascariasis, unspecified', '', 'B779', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(956, 'Intestinal strongyloidiasis', '', 'B780', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(957, 'Cutaneous strongyloidiasis', '', 'B781', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(958, 'Disseminated strongyloidiasis', '', 'B787', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(959, 'Strongyloidiasis, unspecified', '', 'B789', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(960, 'Trichuriasis', '', 'B79', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(961, 'Enterobiasis', '', 'B80', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(962, 'Anisakiasis', '', 'B810', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(963, 'Intestinal capillariasis', '', 'B811', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(964, 'Trichostrongyliasis', '', 'B812', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(965, 'Intestinal angiostrongyliasis', '', 'B813', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(966, 'Mixed intestinal helminthiases', '', 'B814', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(967, 'Other specified intestinal helminthiases', '', 'B818', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(968, 'Intestinal helminthiasis, unspecified', '', 'B820', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(969, 'Intestinal parasitism, unspecified', '', 'B829', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(970, 'Visceral larva migrans', '', 'B830', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(971, 'Gnathostomiasis', '', 'B831', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(972, 'Angiostrongyliasis due to Parastrongylus cantonensis', '', 'B832', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(973, 'Syngamiasis', '', 'B833', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(974, 'Internal hirudiniasis', '', 'B834', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(975, 'Other specified helminthiases', '', 'B838', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(976, 'Helminthiasis, unspecified', '', 'B839', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(977, 'Pediculosis due to Pediculus humanus capitis', '', 'B850', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(978, 'Pediculosis due to Pediculus humanus corporis', '', 'B851', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(979, 'Pediculosis, unspecified', '', 'B852', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(980, 'Phthiriasis', '', 'B853', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(981, 'Mixed pediculosis and phthiriasis', '', 'B854', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(982, 'Scabies', '', 'B86', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(983, 'Cutaneous myiasis', '', 'B870', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(984, 'Wound myiasis', '', 'B871', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(985, 'Ocular myiasis', '', 'B872', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(986, 'Nasopharyngeal myiasis', '', 'B873', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(987, 'Aural myiasis', '', 'B874', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(988, 'Genitourinary myiasis', '', 'B8781', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(989, 'Intestinal myiasis', '', 'B8782', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(990, 'Myiasis of other sites', '', 'B8789', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(991, 'Myiasis, unspecified', '', 'B879', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(992, 'Other acariasis', '', 'B880', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(993, 'Tungiasis [sandflea infestation]', '', 'B881', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(994, 'Other arthropod infestations', '', 'B882', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(995, 'External hirudiniasis', '', 'B883', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(996, 'Other specified infestations', '', 'B888', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(997, 'Infestation, unspecified', '', 'B889', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(998, 'Unspecified parasitic disease', '', 'B89', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(999, 'Sequelae of central nervous system tuberculosis', '', 'B900', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1000, 'Sequelae of genitourinary tuberculosis', '', 'B901', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1001, 'Sequelae of tuberculosis of bones and joints', '', 'B902', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1002, 'Sequelae of tuberculosis of other organs', '', 'B908', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1003, 'Sequelae of respiratory and unspecified tuberculosis', '', 'B909', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1004, 'Sequelae of poliomyelitis', '', 'B91', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1005, 'Sequelae of leprosy', '', 'B92', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1006, 'Sequelae of trachoma', '', 'B940', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1007, 'Sequelae of viral encephalitis', '', 'B941', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1008, 'Sequelae of viral hepatitis', '', 'B942', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1009, 'Sequelae of other specified infectious and parasitic diseases', '', 'B948', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1010, 'Sequelae of unspecified infectious and parasitic disease', '', 'B949', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1011, 'Streptococcus, group A, as the cause of diseases classified elsewhere', '', 'B950', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1012, 'Streptococcus, group B, as the cause of diseases classified elsewhere', '', 'B951', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1013, 'Enterococcus as the cause of diseases classified elsewhere', '', 'B952', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1014, 'Streptococcus pneumoniae as the cause of diseases classified elsewhere', '', 'B953', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1015, 'Other streptococcus as the cause of diseases classified elsewhere', '', 'B954', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1016, 'Unspecified streptococcus as the cause of diseases classified elsewhere', '', 'B955', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1017, 'Methicillin susceptible Staphylococcus aureus infection as the cause of diseases classified\nelsewhere', '', 'B9561', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1018, 'Methicillin resistant Staphylococcus aureus infection as the cause of diseases classified\nelsewhere', '', 'B9562', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1019, 'Other staphylococcus as the cause of diseases classified elsewhere', '', 'B957', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1020, 'Unspecified staphylococcus as the cause of diseases classified elsewhere', '', 'B958', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1021, 'Mycoplasma pneumoniae [M. pneumoniae] as the cause of diseases classified elsewhere', '', 'B960', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1022, 'Klebsiella pneumoniae [K. pneumoniae] as the cause of diseases classified elsewhere', '', 'B961', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1023, 'Unspecified Escherichia coli [E. coli] as the cause of diseases classified elsewhere', '', 'B9620', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1024, 'Shiga toxin-producing Escherichia coli [E. coli] (STEC) O157 as the cause of diseases classified\nelsewhere', '', 'B9621', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1025, 'Other specified Shiga toxin-producing Escherichia coli [E. coli] (STEC) as the cause of diseases\nclassified elsewhere', '', 'B9622', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1026, 'Unspecified Shiga toxin-producing Escherichia coli [E. coli] (STEC) as the cause of diseases\nclassified elsewhere', '', 'B9623', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1027, 'Other Escherichia coli [E. coli] as the cause of diseases classified elsewhere', '', 'B9629', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1028, 'Hemophilus influenzae [H. influenzae] as the cause of diseases classified elsewhere', '', 'B963', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1029, 'Proteus (mirabilis) (morganii) as the cause of diseases classified elsewhere', '', 'B964', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1030, 'Pseudomonas (aeruginosa) (mallei) (pseudomallei) as the cause of diseases classified elsewhere', '', 'B965', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1031, 'Bacteroides fragilis [B. fragilis] as the cause of diseases classified elsewhere', '', 'B966', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1032, 'Clostridium perfringens [C. perfringens] as the cause of diseases classified elsewhere', '', 'B967', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1033, 'Helicobacter pylori [H. pylori] as the cause of diseases classified elsewhere', '', 'B9681', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1034, 'Vibrio vulnificus as the cause of diseases classified elsewhere', '', 'B9682', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1035, 'Other specified bacterial agents as the cause of diseases classified elsewhere', '', 'B9689', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1036, 'Adenovirus as the cause of diseases classified elsewhere', '', 'B970', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1037, 'Unspecified enterovirus as the cause of diseases classified elsewhere', '', 'B9710', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1038, 'Coxsackievirus as the cause of diseases classified elsewhere', '', 'B9711', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1039, 'Echovirus as the cause of diseases classified elsewhere', '', 'B9712', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1040, 'Other enterovirus as the cause of diseases classified elsewhere', '', 'B9719', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1041, 'SARS-associated coronavirus as the cause of diseases classified elsewhere', '', 'B9721', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1042, 'Other coronavirus as the cause of diseases classified elsewhere', '', 'B9729', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1043, 'Unspecified retrovirus as the cause of diseases classified elsewhere', '', 'B9730', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1044, 'Lentivirus as the cause of diseases classified elsewhere', '', 'B9731', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1045, 'Oncovirus as the cause of diseases classified elsewhere', '', 'B9732', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1046, 'Human T-cell lymphotrophic virus, type I [HTLV-I] as the cause of diseases classified elsewhere', '', 'B9733', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1047, 'Human T-cell lymphotrophic virus, type II [HTLV-II] as the cause of diseases classified elsewhere', '', 'B9734', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1048, 'Human immunodeficiency virus, type 2 [HIV 2] as the cause of diseases classified elsewhere', '', 'B9735', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1049, 'Other retrovirus as the cause of diseases classified elsewhere', '', 'B9739', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1050, 'Respiratory syncytial virus as the cause of diseases classified elsewhere', '', 'B974', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1051, 'Reovirus as the cause of diseases classified elsewhere', '', 'B975', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1052, 'Parvovirus as the cause of diseases classified elsewhere', '', 'B976', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1053, 'Papillomavirus as the cause of diseases classified elsewhere', '', 'B977', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1054, 'Human metapneumovirus as the cause of diseases classified elsewhere', '', 'B9781', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1055, 'Other viral agents as the cause of diseases classified elsewhere', '', 'B9789', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1056, 'Other infectious disease', '', 'B998', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1057, 'Unspecified infectious disease', '', 'B999', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1058, 'Malignant neoplasm of external upper lip', '', 'C000', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1059, 'Malignant neoplasm of external lower lip', '', 'C001', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1060, 'Malignant neoplasm of external lip, unspecified', '', 'C002', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1061, 'Malignant neoplasm of upper lip, inner aspect', '', 'C003', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1062, 'Malignant neoplasm of lower lip, inner aspect', '', 'C004', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1063, 'Malignant neoplasm of lip, unspecified, inner aspect', '', 'C005', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1064, 'Malignant neoplasm of commissure of lip, unspecified', '', 'C006', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1065, 'Malignant neoplasm of overlapping sites of lip', '', 'C008', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1066, 'Malignant neoplasm of lip, unspecified', '', 'C009', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1067, 'Malignant neoplasm of base of tongue', '', 'C01', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1068, 'Malignant neoplasm of dorsal surface of tongue', '', 'C020', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1069, 'Malignant neoplasm of border of tongue', '', 'C021', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1070, 'Malignant neoplasm of ventral surface of tongue', '', 'C022', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1071, 'Malignant neoplasm of anterior two-thirds of tongue, part unspecified', '', 'C023', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1072, 'Malignant neoplasm of lingual tonsil', '', 'C024', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1073, 'Malignant neoplasm of overlapping sites of tongue', '', 'C028', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1074, 'Malignant neoplasm of tongue, unspecified', '', 'C029', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1075, 'Malignant neoplasm of upper gum', '', 'C030', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1076, 'Malignant neoplasm of lower gum', '', 'C031', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1077, 'Malignant neoplasm of gum, unspecified', '', 'C039', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1078, 'Malignant neoplasm of anterior floor of mouth', '', 'C040', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1079, 'Malignant neoplasm of lateral floor of mouth', '', 'C041', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1080, 'Malignant neoplasm of overlapping sites of floor of mouth', '', 'C048', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1081, 'Malignant neoplasm of floor of mouth, unspecified', '', 'C049', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1082, 'Malignant neoplasm of hard palate', '', 'C050', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1083, 'Malignant neoplasm of soft palate', '', 'C051', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1084, 'Malignant neoplasm of uvula', '', 'C052', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1085, 'Malignant neoplasm of overlapping sites of palate', '', 'C058', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1086, 'Malignant neoplasm of palate, unspecified', '', 'C059', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1087, 'Malignant neoplasm of cheek mucosa', '', 'C060', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1088, 'Malignant neoplasm of vestibule of mouth', '', 'C061', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1089, 'Malignant neoplasm of retromolar area', '', 'C062', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1090, 'Malignant neoplasm of overlapping sites of unspecified parts of mouth', '', 'C0680', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1091, 'Malignant neoplasm of overlapping sites of other parts of mouth', '', 'C0689', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1092, 'Malignant neoplasm of mouth, unspecified', '', 'C069', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1093, 'Malignant neoplasm of parotid gland', '', 'C07', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1094, 'Malignant neoplasm of submandibular gland', '', 'C080', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1095, 'Malignant neoplasm of sublingual gland', '', 'C081', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1096, 'Malignant neoplasm of major salivary gland, unspecified', '', 'C089', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1097, 'Malignant neoplasm of tonsillar fossa', '', 'C090', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1098, 'Malignant neoplasm of tonsillar pillar (anterior) (posterior)', '', 'C091', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1099, 'Malignant neoplasm of overlapping sites of tonsil', '', 'C098', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1100, 'Malignant neoplasm of tonsil, unspecified', '', 'C099', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1101, 'Malignant neoplasm of vallecula', '', 'C100', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1102, 'Malignant neoplasm of anterior surface of epiglottis', '', 'C101', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1103, 'Malignant neoplasm of lateral wall of oropharynx', '', 'C102', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1104, 'Malignant neoplasm of posterior wall of oropharynx', '', 'C103', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1105, 'Malignant neoplasm of branchial cleft', '', 'C104', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1106, 'Malignant neoplasm of overlapping sites of oropharynx', '', 'C108', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1107, 'Malignant neoplasm of oropharynx, unspecified', '', 'C109', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1108, 'Malignant neoplasm of superior wall of nasopharynx', '', 'C110', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1109, 'Malignant neoplasm of posterior wall of nasopharynx', '', 'C111', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1110, 'Malignant neoplasm of lateral wall of nasopharynx', '', 'C112', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1111, 'Malignant neoplasm of anterior wall of nasopharynx', '', 'C113', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1112, 'Malignant neoplasm of overlapping sites of nasopharynx', '', 'C118', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1113, 'Malignant neoplasm of nasopharynx, unspecified', '', 'C119', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1114, 'Malignant neoplasm of pyriform sinus', '', 'C12', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1115, 'Malignant neoplasm of postcricoid region', '', 'C130', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1116, 'Malignant neoplasm of aryepiglottic fold, hypopharyngeal aspect', '', 'C131', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1117, 'Malignant neoplasm of posterior wall of hypopharynx', '', 'C132', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1118, 'Malignant neoplasm of overlapping sites of hypopharynx', '', 'C138', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1119, 'Malignant neoplasm of hypopharynx, unspecified', '', 'C139', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1120, 'Malignant neoplasm of pharynx, unspecified', '', 'C140', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1121, 'Malignant neoplasm of Waldeyer\'s ring', '', 'C142', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1122, 'Malignant neoplasm of overlapping sites of lip, oral cavity and pharynx', '', 'C148', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1123, 'Malignant neoplasm of upper third of esophagus', '', 'C153', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1124, 'Malignant neoplasm of middle third of esophagus', '', 'C154', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1125, 'Malignant neoplasm of lower third of esophagus', '', 'C155', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1126, 'Malignant neoplasm of overlapping sites of esophagus', '', 'C158', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1127, 'Malignant neoplasm of esophagus, unspecified', '', 'C159', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1128, 'Malignant neoplasm of cardia', '', 'C160', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1129, 'Malignant neoplasm of fundus of stomach', '', 'C161', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1130, 'Malignant neoplasm of body of stomach', '', 'C162', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1131, 'Malignant neoplasm of pyloric antrum', '', 'C163', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1132, 'Malignant neoplasm of pylorus', '', 'C164', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1133, 'Malignant neoplasm of lesser curvature of stomach, unspecified', '', 'C165', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1134, 'Malignant neoplasm of greater curvature of stomach, unspecified', '', 'C166', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1135, 'Malignant neoplasm of overlapping sites of stomach', '', 'C168', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1136, 'Malignant neoplasm of stomach, unspecified', '', 'C169', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1137, 'Malignant neoplasm of duodenum', '', 'C170', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1138, 'Malignant neoplasm of jejunum', '', 'C171', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1139, 'Malignant neoplasm of ileum', '', 'C172', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1140, 'Meckel\'s diverticulum, malignant', '', 'C173', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1141, 'Malignant neoplasm of overlapping sites of small intestine', '', 'C178', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1142, 'Malignant neoplasm of small intestine, unspecified', '', 'C179', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1143, 'Malignant neoplasm of cecum', '', 'C180', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1144, 'Malignant neoplasm of appendix', '', 'C181', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1145, 'Malignant neoplasm of ascending colon', '', 'C182', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1146, 'Malignant neoplasm of hepatic flexure', '', 'C183', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1147, 'Malignant neoplasm of transverse colon', '', 'C184', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1148, 'Malignant neoplasm of splenic flexure', '', 'C185', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1149, 'Malignant neoplasm of descending colon', '', 'C186', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1150, 'Malignant neoplasm of sigmoid colon', '', 'C187', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1151, 'Malignant neoplasm of overlapping sites of colon', '', 'C188', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1152, 'Malignant neoplasm of colon, unspecified', '', 'C189', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1153, 'Malignant neoplasm of rectosigmoid junction', '', 'C19', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1154, 'Malignant neoplasm of rectum', '', 'C20', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1155, 'Malignant neoplasm of anus, unspecified', '', 'C210', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1156, 'Malignant neoplasm of anal canal', '', 'C211', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1157, 'Malignant neoplasm of cloacogenic zone', '', 'C212', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1158, 'Malignant neoplasm of overlapping sites of rectum, anus and anal canal', '', 'C218', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1159, 'Liver cell carcinoma', '', 'C220', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1160, 'Intrahepatic bile duct carcinoma', '', 'C221', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1161, 'Hepatoblastoma', '', 'C222', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1162, 'Angiosarcoma of liver', '', 'C223', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1163, 'Other sarcomas of liver', '', 'C224', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1164, 'Other specified carcinomas of liver', '', 'C227', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1165, 'Malignant neoplasm of liver, primary, unspecified as to type', '', 'C228', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1166, 'Malignant neoplasm of liver, not specified as primary or secondary', '', 'C229', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1167, 'Malignant neoplasm of gallbladder', '', 'C23', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1168, 'Malignant neoplasm of extrahepatic bile duct', '', 'C240', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1169, 'Malignant neoplasm of ampulla of Vater', '', 'C241', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1170, 'Malignant neoplasm of overlapping sites of biliary tract', '', 'C248', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1171, 'Malignant neoplasm of biliary tract, unspecified', '', 'C249', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1172, 'Malignant neoplasm of head of pancreas', '', 'C250', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1173, 'Malignant neoplasm of body of pancreas', '', 'C251', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1174, 'Malignant neoplasm of tail of pancreas', '', 'C252', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1175, 'Malignant neoplasm of pancreatic duct', '', 'C253', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1176, 'Malignant neoplasm of endocrine pancreas', '', 'C254', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1177, 'Malignant neoplasm of other parts of pancreas', '', 'C257', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1178, 'Malignant neoplasm of overlapping sites of pancreas', '', 'C258', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1179, 'Malignant neoplasm of pancreas, unspecified', '', 'C259', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1180, 'Malignant neoplasm of intestinal tract, part unspecified', '', 'C260', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1181, 'Malignant neoplasm of spleen', '', 'C261', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1182, 'Malignant neoplasm of ill-defined sites within the digestive system', '', 'C269', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1183, 'Malignant neoplasm of nasal cavity', '', 'C300', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1184, 'Malignant neoplasm of middle ear', '', 'C301', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1185, 'Malignant neoplasm of maxillary sinus', '', 'C310', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1186, 'Malignant neoplasm of ethmoidal sinus', '', 'C311', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1187, 'Malignant neoplasm of frontal sinus', '', 'C312', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1188, 'Malignant neoplasm of sphenoid sinus', '', 'C313', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1189, 'Malignant neoplasm of overlapping sites of accessory sinuses', '', 'C318', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1190, 'Malignant neoplasm of accessory sinus, unspecified', '', 'C319', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1191, 'Malignant neoplasm of glottis', '', 'C320', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1192, 'Malignant neoplasm of supraglottis', '', 'C321', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1193, 'Malignant neoplasm of subglottis', '', 'C322', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1194, 'Malignant neoplasm of laryngeal cartilage', '', 'C323', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1195, 'Malignant neoplasm of overlapping sites of larynx', '', 'C328', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1196, 'Malignant neoplasm of larynx, unspecified', '', 'C329', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1197, 'Malignant neoplasm of trachea', '', 'C33', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1198, 'Malignant neoplasm of unspecified main bronchus', '', 'C3400', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1199, 'Malignant neoplasm of right main bronchus', '', 'C3401', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1200, 'Malignant neoplasm of left main bronchus', '', 'C3402', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1201, 'Malignant neoplasm of upper lobe, unspecified bronchus or lung', '', 'C3410', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1202, 'Malignant neoplasm of upper lobe, right bronchus or lung', '', 'C3411', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1203, 'Malignant neoplasm of upper lobe, left bronchus or lung', '', 'C3412', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1204, 'Malignant neoplasm of middle lobe, bronchus or lung', '', 'C342', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1205, 'Malignant neoplasm of lower lobe, unspecified bronchus or lung', '', 'C3430', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1206, 'Malignant neoplasm of lower lobe, right bronchus or lung', '', 'C3431', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1207, 'Malignant neoplasm of lower lobe, left bronchus or lung', '', 'C3432', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1208, 'Malignant neoplasm of overlapping sites of unspecified bronchus and lung', '', 'C3480', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1209, 'Malignant neoplasm of overlapping sites of right bronchus and lung', '', 'C3481', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1210, 'Malignant neoplasm of overlapping sites of left bronchus and lung', '', 'C3482', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1211, 'Malignant neoplasm of unspecified part of unspecified bronchus or lung', '', 'C3490', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1212, 'Malignant neoplasm of unspecified part of right bronchus or lung', '', 'C3491', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1213, 'Malignant neoplasm of unspecified part of left bronchus or lung', '', 'C3492', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1214, 'Malignant neoplasm of thymus', '', 'C37', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1215, 'Malignant neoplasm of heart', '', 'C380', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1216, 'Malignant neoplasm of anterior mediastinum', '', 'C381', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1217, 'Malignant neoplasm of posterior mediastinum', '', 'C382', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1218, 'Malignant neoplasm of mediastinum, part unspecified', '', 'C383', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1219, 'Malignant neoplasm of pleura', '', 'C384', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1220, 'Malignant neoplasm of overlapping sites of heart, mediastinum and pleura', '', 'C388', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1221, 'Malignant neoplasm of upper respiratory tract, part unspecified', '', 'C390', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1222, 'Malignant neoplasm of lower respiratory tract, part unspecified', '', 'C399', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1223, 'Malignant neoplasm of scapula and long bones of unspecified upper limb', '', 'C4000', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1224, 'Malignant neoplasm of scapula and long bones of right upper limb', '', 'C4001', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1225, 'Malignant neoplasm of scapula and long bones of left upper limb', '', 'C4002', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1226, 'Malignant neoplasm of short bones of unspecified upper limb', '', 'C4010', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1227, 'Malignant neoplasm of short bones of right upper limb', '', 'C4011', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1228, 'Malignant neoplasm of short bones of left upper limb', '', 'C4012', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1229, 'Malignant neoplasm of long bones of unspecified lower limb', '', 'C4020', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1230, 'Malignant neoplasm of long bones of right lower limb', '', 'C4021', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1231, 'Malignant neoplasm of long bones of left lower limb', '', 'C4022', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1232, 'Malignant neoplasm of short bones of unspecified lower limb', '', 'C4030', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1233, 'Malignant neoplasm of short bones of right lower limb', '', 'C4031', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1234, 'Malignant neoplasm of short bones of left lower limb', '', 'C4032', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1235, 'Malignant neoplasm of overlapping sites of bone and articular cartilage of unspecified limb', '', 'C4080', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1236, 'Malignant neoplasm of overlapping sites of bone and articular cartilage of right limb', '', 'C4081', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1237, 'Malignant neoplasm of overlapping sites of bone and articular cartilage of left limb', '', 'C4082', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1238, 'Malignant neoplasm of unspecified bones and articular cartilage of unspecified limb', '', 'C4090', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1239, 'Malignant neoplasm of unspecified bones and articular cartilage of right limb', '', 'C4091', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1240, 'Malignant neoplasm of unspecified bones and articular cartilage of left limb', '', 'C4092', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1241, 'Malignant neoplasm of bones of skull and face', '', 'C410', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1242, 'Malignant neoplasm of mandible', '', 'C411', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1243, 'Malignant neoplasm of vertebral column', '', 'C412', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1244, 'Malignant neoplasm of ribs, sternum and clavicle', '', 'C413', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1245, 'Malignant neoplasm of pelvic bones, sacrum and coccyx', '', 'C414', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1246, 'Malignant neoplasm of bone and articular cartilage, unspecified', '', 'C419', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1247, 'Malignant melanoma of lip', '', 'C430', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1248, 'Malignant melanoma of unspecified eyelid, including canthus', '', 'C4310', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1249, 'Malignant melanoma of right eyelid, including canthus', '', 'C4311', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1250, 'Malignant melanoma of left eyelid, including canthus', '', 'C4312', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1251, 'Malignant melanoma of unspecified ear and external auricular canal', '', 'C4320', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1252, 'Malignant melanoma of right ear and external auricular canal', '', 'C4321', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1253, 'Malignant melanoma of left ear and external auricular canal', '', 'C4322', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1254, 'Malignant melanoma of unspecified part of face', '', 'C4330', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1255, 'Malignant melanoma of nose', '', 'C4331', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1256, 'Malignant melanoma of other parts of face', '', 'C4339', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1257, 'Malignant melanoma of scalp and neck', '', 'C434', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1258, 'Malignant melanoma of anal skin', '', 'C4351', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1259, 'Malignant melanoma of skin of breast', '', 'C4352', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1260, 'Malignant melanoma of other part of trunk', '', 'C4359', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1261, 'Malignant melanoma of unspecified upper limb, including shoulder', '', 'C4360', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1262, 'Malignant melanoma of right upper limb, including shoulder', '', 'C4361', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1263, 'Malignant melanoma of left upper limb, including shoulder', '', 'C4362', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1264, 'Malignant melanoma of unspecified lower limb, including hip', '', 'C4370', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1265, 'Malignant melanoma of right lower limb, including hip', '', 'C4371', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1266, 'Malignant melanoma of left lower limb, including hip', '', 'C4372', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1267, 'Malignant melanoma of overlapping sites of skin', '', 'C438', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1268, 'Malignant melanoma of skin, unspecified', '', 'C439', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1269, 'Merkel cell carcinoma of lip', '', 'C4A0', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1270, 'Merkel cell carcinoma of unspecified eyelid, including canthus', '', 'C4A10', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1271, 'Merkel cell carcinoma of right eyelid, including canthus', '', 'C4A11', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1272, 'Merkel cell carcinoma of left eyelid, including canthus', '', 'C4A12', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1273, 'Merkel cell carcinoma of unspecified ear and external auricular canal', '', 'C4A20', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1274, 'Merkel cell carcinoma of right ear and external auricular canal', '', 'C4A21', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1275, 'Merkel cell carcinoma of left ear and external auricular canal', '', 'C4A22', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1276, 'Merkel cell carcinoma of unspecified part of face', '', 'C4A30', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1277, 'Merkel cell carcinoma of nose', '', 'C4A31', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1278, 'Merkel cell carcinoma of other parts of face', '', 'C4A39', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1279, 'Merkel cell carcinoma of scalp and neck', '', 'C4A4', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1280, 'Merkel cell carcinoma of anal skin', '', 'C4A51', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1281, 'Merkel cell carcinoma of skin of breast', '', 'C4A52', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1282, 'Merkel cell carcinoma of other part of trunk', '', 'C4A59', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1283, 'Merkel cell carcinoma of unspecified upper limb, including shoulder', '', 'C4A60', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1284, 'Merkel cell carcinoma of right upper limb, including shoulder', '', 'C4A61', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1285, 'Merkel cell carcinoma of left upper limb, including shoulder', '', 'C4A62', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1286, 'Merkel cell carcinoma of unspecified lower limb, including hip', '', 'C4A70', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1287, 'Merkel cell carcinoma of right lower limb, including hip', '', 'C4A71', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1288, 'Merkel cell carcinoma of left lower limb, including hip', '', 'C4A72', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1289, 'Merkel cell carcinoma of overlapping sites', '', 'C4A8', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1290, 'Merkel cell carcinoma, unspecified', '', 'C4A9', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1291, 'Unspecified malignant neoplasm of skin of lip', '', 'C4400', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1292, 'Basal cell carcinoma of skin of lip', '', 'C4401', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1293, 'Squamous cell carcinoma of skin of lip', '', 'C4402', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1294, 'Other specified malignant neoplasm of skin of lip', '', 'C4409', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1295, 'Unspecified malignant neoplasm of skin of unspecified eyelid, including canthus', '', 'C44101', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1296, 'Unspecified malignant neoplasm of skin of right eyelid, including canthus', '', 'C44102', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1297, 'Unspecified malignant neoplasm of skin of left eyelid, including canthus', '', 'C44109', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1298, 'Basal cell carcinoma of skin of unspecified eyelid, including canthus', '', 'C44111', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1299, 'Basal cell carcinoma of skin of right eyelid, including canthus', '', 'C44112', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1300, 'Basal cell carcinoma of skin of left eyelid, including canthus', '', 'C44119', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1301, 'Squamous cell carcinoma of skin of unspecified eyelid, including canthus', '', 'C44121', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1);");



    DB::statement("INSERT INTO `symptoms` (`id`, `symptoms_title`, `description`, `code`, `status`, `priority`, `created_at`, `updated_at`, `type`) VALUES
(1302, 'Squamous cell carcinoma of skin of right eyelid, including canthus', '', 'C44122', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1303, 'Squamous cell carcinoma of skin of left eyelid, including canthus', '', 'C44129', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1304, 'Other specified malignant neoplasm of skin of unspecified eyelid, including canthus', '', 'C44191', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1305, 'Other specified malignant neoplasm of skin of right eyelid, including canthus', '', 'C44192', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1306, 'Other specified malignant neoplasm of skin of left eyelid, including canthus', '', 'C44199', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1307, 'Unspecified malignant neoplasm of skin of unspecified ear and external auricular canal', '', 'C44201', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1308, 'Unspecified malignant neoplasm of skin of right ear and external auricular canal', '', 'C44202', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1309, 'Unspecified malignant neoplasm of skin of left ear and external auricular canal', '', 'C44209', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1310, 'Basal cell carcinoma of skin of unspecified ear and external auricular canal', '', 'C44211', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1311, 'Basal cell carcinoma of skin of right ear and external auricular canal', '', 'C44212', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1312, 'Basal cell carcinoma of skin of left ear and external auricular canal', '', 'C44219', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1313, 'Squamous cell carcinoma of skin of unspecified ear and external auricular canal', '', 'C44221', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1314, 'Squamous cell carcinoma of skin of right ear and external auricular canal', '', 'C44222', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1315, 'Squamous cell carcinoma of skin of left ear and external auricular canal', '', 'C44229', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1316, 'Other specified malignant neoplasm of skin of unspecified ear and external auricular canal', '', 'C44291', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1317, 'Other specified malignant neoplasm of skin of right ear and external auricular canal', '', 'C44292', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1318, 'Other specified malignant neoplasm of skin of left ear and external auricular canal', '', 'C44299', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1319, 'Unspecified malignant neoplasm of skin of unspecified part of face', '', 'C44300', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1320, 'Unspecified malignant neoplasm of skin of nose', '', 'C44301', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1321, 'Unspecified malignant neoplasm of skin of other parts of face', '', 'C44309', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1322, 'Basal cell carcinoma of skin of unspecified parts of face', '', 'C44310', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1323, 'Basal cell carcinoma of skin of nose', '', 'C44311', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1324, 'Basal cell carcinoma of skin of other parts of face', '', 'C44319', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1325, 'Squamous cell carcinoma of skin of unspecified parts of face', '', 'C44320', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1326, 'Squamous cell carcinoma of skin of nose', '', 'C44321', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1327, 'Squamous cell carcinoma of skin of other parts of face', '', 'C44329', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1328, 'Other specified malignant neoplasm of skin of unspecified parts of face', '', 'C44390', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1329, 'Other specified malignant neoplasm of skin of nose', '', 'C44391', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1330, 'Other specified malignant neoplasm of skin of other parts of face', '', 'C44399', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1331, 'Unspecified malignant neoplasm of skin of scalp and neck', '', 'C4440', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1332, 'Basal cell carcinoma of skin of scalp and neck', '', 'C4441', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1333, 'Squamous cell carcinoma of skin of scalp and neck', '', 'C4442', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1334, 'Other specified malignant neoplasm of skin of scalp and neck', '', 'C4449', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1335, 'Unspecified malignant neoplasm of anal skin', '', 'C44500', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1336, 'Unspecified malignant neoplasm of skin of breast', '', 'C44501', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1337, 'Unspecified malignant neoplasm of skin of other part of trunk', '', 'C44509', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1338, 'Basal cell carcinoma of anal skin', '', 'C44510', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1339, 'Basal cell carcinoma of skin of breast', '', 'C44511', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1340, 'Basal cell carcinoma of skin of other part of trunk', '', 'C44519', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1341, 'Squamous cell carcinoma of anal skin', '', 'C44520', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1342, 'Squamous cell carcinoma of skin of breast', '', 'C44521', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1343, 'Squamous cell carcinoma of skin of other part of trunk', '', 'C44529', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1344, 'Other specified malignant neoplasm of anal skin', '', 'C44590', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1345, 'Other specified malignant neoplasm of skin of breast', '', 'C44591', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1346, 'Other specified malignant neoplasm of skin of other part of trunk', '', 'C44599', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1347, 'Unspecified malignant neoplasm of skin of unspecified upper limb, including shoulder', '', 'C44601', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1348, 'Unspecified malignant neoplasm of skin of right upper limb, including shoulder', '', 'C44602', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1349, 'Unspecified malignant neoplasm of skin of left upper limb, including shoulder', '', 'C44609', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1350, 'Basal cell carcinoma of skin of unspecified upper limb, including shoulder', '', 'C44611', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1351, 'Basal cell carcinoma of skin of right upper limb, including shoulder', '', 'C44612', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1352, 'Basal cell carcinoma of skin of left upper limb, including shoulder', '', 'C44619', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1353, 'Squamous cell carcinoma of skin of unspecified upper limb, including shoulder', '', 'C44621', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1354, 'Squamous cell carcinoma of skin of right upper limb, including shoulder', '', 'C44622', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1355, 'Squamous cell carcinoma of skin of left upper limb, including shoulder', '', 'C44629', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1356, 'Other specified malignant neoplasm of skin of unspecified upper limb, including shoulder', '', 'C44691', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1357, 'Other specified malignant neoplasm of skin of right upper limb, including shoulder', '', 'C44692', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1358, 'Other specified malignant neoplasm of skin of left upper limb, including shoulder', '', 'C44699', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1359, 'Unspecified malignant neoplasm of skin of unspecified lower limb, including hip', '', 'C44701', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1360, 'Unspecified malignant neoplasm of skin of right lower limb, including hip', '', 'C44702', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1361, 'Unspecified malignant neoplasm of skin of left lower limb, including hip', '', 'C44709', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1362, 'Basal cell carcinoma of skin of unspecified lower limb, including hip', '', 'C44711', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1363, 'Basal cell carcinoma of skin of right lower limb, including hip', '', 'C44712', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1364, 'Basal cell carcinoma of skin of left lower limb, including hip', '', 'C44719', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1365, 'Squamous cell carcinoma of skin of unspecified lower limb, including hip', '', 'C44721', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1366, 'Squamous cell carcinoma of skin of right lower limb, including hip', '', 'C44722', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1367, 'Squamous cell carcinoma of skin of left lower limb, including hip', '', 'C44729', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1368, 'Other specified malignant neoplasm of skin of unspecified lower limb, including hip', '', 'C44791', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1369, 'Other specified malignant neoplasm of skin of right lower limb, including hip', '', 'C44792', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1370, 'Other specified malignant neoplasm of skin of left lower limb, including hip', '', 'C44799', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1371, 'Unspecified malignant neoplasm of overlapping sites of skin', '', 'C4480', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1372, 'Basal cell carcinoma of overlapping sites of skin', '', 'C4481', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1373, 'Squamous cell carcinoma of overlapping sites of skin', '', 'C4482', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1374, 'Other specified malignant neoplasm of overlapping sites of skin', '', 'C4489', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1375, 'Unspecified malignant neoplasm of skin, unspecified', '', 'C4490', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1376, 'Basal cell carcinoma of skin, unspecified', '', 'C4491', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1377, 'Squamous cell carcinoma of skin, unspecified', '', 'C4492', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1378, 'Other specified malignant neoplasm of skin, unspecified', '', 'C4499', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1379, 'Mesothelioma of pleura', '', 'C450', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1380, 'Mesothelioma of peritoneum', '', 'C451', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1381, 'Mesothelioma of pericardium', '', 'C452', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1382, 'Mesothelioma of other sites', '', 'C457', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1383, 'Mesothelioma, unspecified', '', 'C459', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1384, 'Kaposi\'s sarcoma of skin', '', 'C460', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1385, 'Kaposi\'s sarcoma of soft tissue', '', 'C461', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1386, 'Kaposi\'s sarcoma of palate', '', 'C462', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1387, 'Kaposi\'s sarcoma of lymph nodes', '', 'C463', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1388, 'Kaposi\'s sarcoma of gastrointestinal sites', '', 'C464', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1389, 'Kaposi\'s sarcoma of unspecified lung', '', 'C4650', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1390, 'Kaposi\'s sarcoma of right lung', '', 'C4651', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1391, 'Kaposi\'s sarcoma of left lung', '', 'C4652', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1392, 'Kaposi\'s sarcoma of other sites', '', 'C467', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1393, 'Kaposi\'s sarcoma, unspecified', '', 'C469', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1394, 'Malignant neoplasm of peripheral nerves of head, face and neck', '', 'C470', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1395, 'Malignant neoplasm of peripheral nerves of unspecified upper limb, including shoulder', '', 'C4710', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1396, 'Malignant neoplasm of peripheral nerves of right upper limb, including shoulder', '', 'C4711', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1397, 'Malignant neoplasm of peripheral nerves of left upper limb, including shoulder', '', 'C4712', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1398, 'Malignant neoplasm of peripheral nerves of unspecified lower limb, including hip', '', 'C4720', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1399, 'Malignant neoplasm of peripheral nerves of right lower limb, including hip', '', 'C4721', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1400, 'Malignant neoplasm of peripheral nerves of left lower limb, including hip', '', 'C4722', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1401, 'Malignant neoplasm of peripheral nerves of thorax', '', 'C473', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1402, 'Malignant neoplasm of peripheral nerves of abdomen', '', 'C474', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1403, 'Malignant neoplasm of peripheral nerves of pelvis', '', 'C475', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1404, 'Malignant neoplasm of peripheral nerves of trunk, unspecified', '', 'C476', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1405, 'Malignant neoplasm of overlapping sites of peripheral nerves and autonomic nervous system', '', 'C478', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1406, 'Malignant neoplasm of peripheral nerves and autonomic nervous system, unspecified', '', 'C479', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1407, 'Malignant neoplasm of retroperitoneum', '', 'C480', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1408, 'Malignant neoplasm of specified parts of peritoneum', '', 'C481', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1409, 'Malignant neoplasm of peritoneum, unspecified', '', 'C482', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1410, 'Malignant neoplasm of overlapping sites of retroperitoneum and peritoneum', '', 'C488', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1411, 'Malignant neoplasm of connective and soft tissue of head, face and neck', '', 'C490', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1412, 'Malignant neoplasm of connective and soft tissue of unspecified upper limb, including shoulder', '', 'C4910', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1413, 'Malignant neoplasm of connective and soft tissue of right upper limb, including shoulder', '', 'C4911', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1414, 'Malignant neoplasm of connective and soft tissue of left upper limb, including shoulder', '', 'C4912', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1415, 'Malignant neoplasm of connective and soft tissue of unspecified lower limb, including hip', '', 'C4920', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1416, 'Malignant neoplasm of connective and soft tissue of right lower limb, including hip', '', 'C4921', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1417, 'Malignant neoplasm of connective and soft tissue of left lower limb, including hip', '', 'C4922', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1418, 'Malignant neoplasm of connective and soft tissue of thorax', '', 'C493', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1419, 'Malignant neoplasm of connective and soft tissue of abdomen', '', 'C494', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1420, 'Malignant neoplasm of connective and soft tissue of pelvis', '', 'C495', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1421, 'Malignant neoplasm of connective and soft tissue of trunk, unspecified', '', 'C496', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1422, 'Malignant neoplasm of overlapping sites of connective and soft tissue', '', 'C498', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1423, 'Malignant neoplasm of connective and soft tissue, unspecified', '', 'C499', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1424, 'Gastrointestinal stromal tumor, unspecified site', '', 'C49A0', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1425, 'Gastrointestinal stromal tumor of esophagus', '', 'C49A1', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1426, 'Gastrointestinal stromal tumor of stomach', '', 'C49A2', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1427, 'Gastrointestinal stromal tumor of small intestine', '', 'C49A3', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1428, 'Gastrointestinal stromal tumor of large intestine', '', 'C49A4', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1429, 'Gastrointestinal stromal tumor of rectum', '', 'C49A5', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1430, 'Gastrointestinal stromal tumor of other sites', '', 'C49A9', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1431, 'Malignant neoplasm of nipple and areola, right female breast', '', 'C50011', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1432, 'Malignant neoplasm of nipple and areola, left female breast', '', 'C50012', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1433, 'Malignant neoplasm of nipple and areola, unspecified female breast', '', 'C50019', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1434, 'Malignant neoplasm of nipple and areola, right male breast', '', 'C50021', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1435, 'Malignant neoplasm of nipple and areola, left male breast', '', 'C50022', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1436, 'Malignant neoplasm of nipple and areola, unspecified male breast', '', 'C50029', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1437, 'Malignant neoplasm of central portion of right female breast', '', 'C50111', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1438, 'Malignant neoplasm of central portion of left female breast', '', 'C50112', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1439, 'Malignant neoplasm of central portion of unspecified female breast', '', 'C50119', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1440, 'Malignant neoplasm of central portion of right male breast', '', 'C50121', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1441, 'Malignant neoplasm of central portion of left male breast', '', 'C50122', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1442, 'Malignant neoplasm of central portion of unspecified male breast', '', 'C50129', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1443, 'Malignant neoplasm of upper-inner quadrant of right female breast', '', 'C50211', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1444, 'Malignant neoplasm of upper-inner quadrant of left female breast', '', 'C50212', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1445, 'Malignant neoplasm of upper-inner quadrant of unspecified female breast', '', 'C50219', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1446, 'Malignant neoplasm of upper-inner quadrant of right male breast', '', 'C50221', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1447, 'Malignant neoplasm of upper-inner quadrant of left male breast', '', 'C50222', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1448, 'Malignant neoplasm of upper-inner quadrant of unspecified male breast', '', 'C50229', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1449, 'Malignant neoplasm of lower-inner quadrant of right female breast', '', 'C50311', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1450, 'Malignant neoplasm of lower-inner quadrant of left female breast', '', 'C50312', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1451, 'Malignant neoplasm of lower-inner quadrant of unspecified female breast', '', 'C50319', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1452, 'Malignant neoplasm of lower-inner quadrant of right male breast', '', 'C50321', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1453, 'Malignant neoplasm of lower-inner quadrant of left male breast', '', 'C50322', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1454, 'Malignant neoplasm of lower-inner quadrant of unspecified male breast', '', 'C50329', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1455, 'Malignant neoplasm of upper-outer quadrant of right female breast', '', 'C50411', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1456, 'Malignant neoplasm of upper-outer quadrant of left female breast', '', 'C50412', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1457, 'Malignant neoplasm of upper-outer quadrant of unspecified female breast', '', 'C50419', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1458, 'Malignant neoplasm of upper-outer quadrant of right male breast', '', 'C50421', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1459, 'Malignant neoplasm of upper-outer quadrant of left male breast', '', 'C50422', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1460, 'Malignant neoplasm of upper-outer quadrant of unspecified male breast', '', 'C50429', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1461, 'Malignant neoplasm of lower-outer quadrant of right female breast', '', 'C50511', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1462, 'Malignant neoplasm of lower-outer quadrant of left female breast', '', 'C50512', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1463, 'Malignant neoplasm of lower-outer quadrant of unspecified female breast', '', 'C50519', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1464, 'Malignant neoplasm of lower-outer quadrant of right male breast', '', 'C50521', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1465, 'Malignant neoplasm of lower-outer quadrant of left male breast', '', 'C50522', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1466, 'Malignant neoplasm of lower-outer quadrant of unspecified male breast', '', 'C50529', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1467, 'Malignant neoplasm of axillary tail of right female breast', '', 'C50611', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1468, 'Malignant neoplasm of axillary tail of left female breast', '', 'C50612', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1469, 'Malignant neoplasm of axillary tail of unspecified female breast', '', 'C50619', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1470, 'Malignant neoplasm of axillary tail of right male breast', '', 'C50621', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1471, 'Malignant neoplasm of axillary tail of left male breast', '', 'C50622', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1472, 'Malignant neoplasm of axillary tail of unspecified male breast', '', 'C50629', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1473, 'Malignant neoplasm of overlapping sites of right female breast', '', 'C50811', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1474, 'Malignant neoplasm of overlapping sites of left female breast', '', 'C50812', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1475, 'Malignant neoplasm of overlapping sites of unspecified female breast', '', 'C50819', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1476, 'Malignant neoplasm of overlapping sites of right male breast', '', 'C50821', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1477, 'Malignant neoplasm of overlapping sites of left male breast', '', 'C50822', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1478, 'Malignant neoplasm of overlapping sites of unspecified male breast', '', 'C50829', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1479, 'Malignant neoplasm of unspecified site of right female breast', '', 'C50911', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1480, 'Malignant neoplasm of unspecified site of left female breast', '', 'C50912', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1481, 'Malignant neoplasm of unspecified site of unspecified female breast', '', 'C50919', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1482, 'Malignant neoplasm of unspecified site of right male breast', '', 'C50921', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1483, 'Malignant neoplasm of unspecified site of left male breast', '', 'C50922', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1484, 'Malignant neoplasm of unspecified site of unspecified male breast', '', 'C50929', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1485, 'Malignant neoplasm of labium majus', '', 'C510', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1486, 'Malignant neoplasm of labium minus', '', 'C511', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1487, 'Malignant neoplasm of clitoris', '', 'C512', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1488, 'Malignant neoplasm of overlapping sites of vulva', '', 'C518', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1489, 'Malignant neoplasm of vulva, unspecified', '', 'C519', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1490, 'Malignant neoplasm of vagina', '', 'C52', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1491, 'Malignant neoplasm of endocervix', '', 'C530', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1492, 'Malignant neoplasm of exocervix', '', 'C531', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1493, 'Malignant neoplasm of overlapping sites of cervix uteri', '', 'C538', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1494, 'Malignant neoplasm of cervix uteri, unspecified', '', 'C539', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1495, 'Malignant neoplasm of isthmus uteri', '', 'C540', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1496, 'Malignant neoplasm of endometrium', '', 'C541', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1497, 'Malignant neoplasm of myometrium', '', 'C542', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1498, 'Malignant neoplasm of fundus uteri', '', 'C543', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1499, 'Malignant neoplasm of overlapping sites of corpus uteri', '', 'C548', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1500, 'Malignant neoplasm of corpus uteri, unspecified', '', 'C549', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1501, 'Malignant neoplasm of uterus, part unspecified', '', 'C55', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1502, 'Malignant neoplasm of right ovary', '', 'C561', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1503, 'Malignant neoplasm of left ovary', '', 'C562', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1504, 'Malignant neoplasm of unspecified ovary', '', 'C569', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1505, 'Malignant neoplasm of unspecified fallopian tube', '', 'C5700', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1506, 'Malignant neoplasm of right fallopian tube', '', 'C5701', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1507, 'Malignant neoplasm of left fallopian tube', '', 'C5702', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1508, 'Malignant neoplasm of unspecified broad ligament', '', 'C5710', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1509, 'Malignant neoplasm of right broad ligament', '', 'C5711', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1510, 'Malignant neoplasm of left broad ligament', '', 'C5712', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1511, 'Malignant neoplasm of unspecified round ligament', '', 'C5720', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1512, 'Malignant neoplasm of right round ligament', '', 'C5721', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1513, 'Malignant neoplasm of left round ligament', '', 'C5722', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1514, 'Malignant neoplasm of parametrium', '', 'C573', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1515, 'Malignant neoplasm of uterine adnexa, unspecified', '', 'C574', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1516, 'Malignant neoplasm of other specified female genital organs', '', 'C577', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1517, 'Malignant neoplasm of overlapping sites of female genital organs', '', 'C578', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1518, 'Malignant neoplasm of female genital organ, unspecified', '', 'C579', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1519, 'Malignant neoplasm of placenta', '', 'C58', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1520, 'Malignant neoplasm of prepuce', '', 'C600', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1521, 'Malignant neoplasm of glans penis', '', 'C601', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1522, 'Malignant neoplasm of body of penis', '', 'C602', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1523, 'Malignant neoplasm of overlapping sites of penis', '', 'C608', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1524, 'Malignant neoplasm of penis, unspecified', '', 'C609', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1525, 'Malignant neoplasm of prostate', '', 'C61', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1526, 'Malignant neoplasm of unspecified undescended testis', '', 'C6200', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1527, 'Malignant neoplasm of undescended right testis', '', 'C6201', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1528, 'Malignant neoplasm of undescended left testis', '', 'C6202', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1529, 'Malignant neoplasm of unspecified descended testis', '', 'C6210', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1530, 'Malignant neoplasm of descended right testis', '', 'C6211', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1531, 'Malignant neoplasm of descended left testis', '', 'C6212', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1532, 'Malignant neoplasm of unspecified testis, unspecified whether descended or undescended', '', 'C6290', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1533, 'Malignant neoplasm of right testis, unspecified whether descended or undescended', '', 'C6291', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1534, 'Malignant neoplasm of left testis, unspecified whether descended or undescended', '', 'C6292', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1535, 'Malignant neoplasm of unspecified epididymis', '', 'C6300', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1536, 'Malignant neoplasm of right epididymis', '', 'C6301', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1537, 'Malignant neoplasm of left epididymis', '', 'C6302', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1538, 'Malignant neoplasm of unspecified spermatic cord', '', 'C6310', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1539, 'Malignant neoplasm of right spermatic cord', '', 'C6311', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1540, 'Malignant neoplasm of left spermatic cord', '', 'C6312', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1541, 'Malignant neoplasm of scrotum', '', 'C632', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1542, 'Malignant neoplasm of other specified male genital organs', '', 'C637', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1543, 'Malignant neoplasm of overlapping sites of male genital organs', '', 'C638', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1544, 'Malignant neoplasm of male genital organ, unspecified', '', 'C639', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1545, 'Malignant neoplasm of right kidney, except renal pelvis', '', 'C641', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1546, 'Malignant neoplasm of left kidney, except renal pelvis', '', 'C642', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1547, 'Malignant neoplasm of unspecified kidney, except renal pelvis', '', 'C649', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1548, 'Malignant neoplasm of right renal pelvis', '', 'C651', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1549, 'Malignant neoplasm of left renal pelvis', '', 'C652', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1550, 'Malignant neoplasm of unspecified renal pelvis', '', 'C659', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1551, 'Malignant neoplasm of right ureter', '', 'C661', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1552, 'Malignant neoplasm of left ureter', '', 'C662', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1553, 'Malignant neoplasm of unspecified ureter', '', 'C669', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1554, 'Malignant neoplasm of trigone of bladder', '', 'C670', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1555, 'Malignant neoplasm of dome of bladder', '', 'C671', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1556, 'Malignant neoplasm of lateral wall of bladder', '', 'C672', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1557, 'Malignant neoplasm of anterior wall of bladder', '', 'C673', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1558, 'Malignant neoplasm of posterior wall of bladder', '', 'C674', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1559, 'Malignant neoplasm of bladder neck', '', 'C675', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1560, 'Malignant neoplasm of ureteric orifice', '', 'C676', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1561, 'Malignant neoplasm of urachus', '', 'C677', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1562, 'Malignant neoplasm of overlapping sites of bladder', '', 'C678', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1563, 'Malignant neoplasm of bladder, unspecified', '', 'C679', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1564, 'Malignant neoplasm of urethra', '', 'C680', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1565, 'Malignant neoplasm of paraurethral glands', '', 'C681', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1566, 'Malignant neoplasm of overlapping sites of urinary organs', '', 'C688', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1567, 'Malignant neoplasm of urinary organ, unspecified', '', 'C689', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1568, 'Malignant neoplasm of unspecified conjunctiva', '', 'C6900', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1569, 'Malignant neoplasm of right conjunctiva', '', 'C6901', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1570, 'Malignant neoplasm of left conjunctiva', '', 'C6902', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1571, 'Malignant neoplasm of unspecified cornea', '', 'C6910', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1572, 'Malignant neoplasm of right cornea', '', 'C6911', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1573, 'Malignant neoplasm of left cornea', '', 'C6912', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1574, 'Malignant neoplasm of unspecified retina', '', 'C6920', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1575, 'Malignant neoplasm of right retina', '', 'C6921', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1576, 'Malignant neoplasm of left retina', '', 'C6922', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1577, 'Malignant neoplasm of unspecified choroid', '', 'C6930', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1578, 'Malignant neoplasm of right choroid', '', 'C6931', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1579, 'Malignant neoplasm of left choroid', '', 'C6932', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1580, 'Malignant neoplasm of unspecified ciliary body', '', 'C6940', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1581, 'Malignant neoplasm of right ciliary body', '', 'C6941', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1582, 'Malignant neoplasm of left ciliary body', '', 'C6942', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1583, 'Malignant neoplasm of unspecified lacrimal gland and duct', '', 'C6950', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1584, 'Malignant neoplasm of right lacrimal gland and duct', '', 'C6951', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1585, 'Malignant neoplasm of left lacrimal gland and duct', '', 'C6952', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1586, 'Malignant neoplasm of unspecified orbit', '', 'C6960', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1587, 'Malignant neoplasm of right orbit', '', 'C6961', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1588, 'Malignant neoplasm of left orbit', '', 'C6962', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1589, 'Malignant neoplasm of overlapping sites of unspecified eye and adnexa', '', 'C6980', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1590, 'Malignant neoplasm of overlapping sites of right eye and adnexa', '', 'C6981', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1591, 'Malignant neoplasm of overlapping sites of left eye and adnexa', '', 'C6982', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1592, 'Malignant neoplasm of unspecified site of unspecified eye', '', 'C6990', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1593, 'Malignant neoplasm of unspecified site of right eye', '', 'C6991', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1594, 'Malignant neoplasm of unspecified site of left eye', '', 'C6992', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1595, 'Malignant neoplasm of cerebral meninges', '', 'C700', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1596, 'Malignant neoplasm of spinal meninges', '', 'C701', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1597, 'Malignant neoplasm of meninges, unspecified', '', 'C709', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1598, 'Malignant neoplasm of cerebrum, except lobes and ventricles', '', 'C710', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1599, 'Malignant neoplasm of frontal lobe', '', 'C711', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1600, 'Malignant neoplasm of temporal lobe', '', 'C712', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1601, 'Malignant neoplasm of parietal lobe', '', 'C713', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1602, 'Malignant neoplasm of occipital lobe', '', 'C714', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1603, 'Malignant neoplasm of cerebral ventricle', '', 'C715', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1604, 'Malignant neoplasm of cerebellum', '', 'C716', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1605, 'Malignant neoplasm of brain stem', '', 'C717', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1606, 'Malignant neoplasm of overlapping sites of brain', '', 'C718', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1607, 'Malignant neoplasm of brain, unspecified', '', 'C719', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1608, 'Malignant neoplasm of spinal cord', '', 'C720', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1609, 'Malignant neoplasm of cauda equina', '', 'C721', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1610, 'Malignant neoplasm of unspecified olfactory nerve', '', 'C7220', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1611, 'Malignant neoplasm of right olfactory nerve', '', 'C7221', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1612, 'Malignant neoplasm of left olfactory nerve', '', 'C7222', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1613, 'Malignant neoplasm of unspecified optic nerve', '', 'C7230', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1614, 'Malignant neoplasm of right optic nerve', '', 'C7231', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1615, 'Malignant neoplasm of left optic nerve', '', 'C7232', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1616, 'Malignant neoplasm of unspecified acoustic nerve', '', 'C7240', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1617, 'Malignant neoplasm of right acoustic nerve', '', 'C7241', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1618, 'Malignant neoplasm of left acoustic nerve', '', 'C7242', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1619, 'Malignant neoplasm of unspecified cranial nerve', '', 'C7250', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1620, 'Malignant neoplasm of other cranial nerves', '', 'C7259', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1621, 'Malignant neoplasm of central nervous system, unspecified', '', 'C729', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1622, 'Malignant neoplasm of thyroid gland', '', 'C73', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1623, 'Malignant neoplasm of cortex of unspecified adrenal gland', '', 'C7400', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1624, 'Malignant neoplasm of cortex of right adrenal gland', '', 'C7401', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1625, 'Malignant neoplasm of cortex of left adrenal gland', '', 'C7402', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1626, 'Malignant neoplasm of medulla of unspecified adrenal gland', '', 'C7410', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1627, 'Malignant neoplasm of medulla of right adrenal gland', '', 'C7411', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1628, 'Malignant neoplasm of medulla of left adrenal gland', '', 'C7412', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1629, 'Malignant neoplasm of unspecified part of unspecified adrenal gland', '', 'C7490', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1630, 'Malignant neoplasm of unspecified part of right adrenal gland', '', 'C7491', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1631, 'Malignant neoplasm of unspecified part of left adrenal gland', '', 'C7492', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1632, 'Malignant neoplasm of parathyroid gland', '', 'C750', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1633, 'Malignant neoplasm of pituitary gland', '', 'C751', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1634, 'Malignant neoplasm of craniopharyngeal duct', '', 'C752', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1635, 'Malignant neoplasm of pineal gland', '', 'C753', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1636, 'Malignant neoplasm of carotid body', '', 'C754', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1637, 'Malignant neoplasm of aortic body and other paraganglia', '', 'C755', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1638, 'Malignant neoplasm with pluriglandular involvement, unspecified', '', 'C758', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1639, 'Malignant neoplasm of endocrine gland, unspecified', '', 'C759', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1640, 'Malignant carcinoid tumor of unspecified site', '', 'C7A00', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1641, 'Malignant carcinoid tumor of the duodenum', '', 'C7A010', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1642, 'Malignant carcinoid tumor of the jejunum', '', 'C7A011', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1643, 'Malignant carcinoid tumor of the ileum', '', 'C7A012', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1644, 'Malignant carcinoid tumor of the small intestine, unspecified portion', '', 'C7A019', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1645, 'Malignant carcinoid tumor of the appendix', '', 'C7A020', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1646, 'Malignant carcinoid tumor of the cecum', '', 'C7A021', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1647, 'Malignant carcinoid tumor of the ascending colon', '', 'C7A022', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1648, 'Malignant carcinoid tumor of the transverse colon', '', 'C7A023', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1649, 'Malignant carcinoid tumor of the descending colon', '', 'C7A024', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1650, 'Malignant carcinoid tumor of the sigmoid colon', '', 'C7A025', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1651, 'Malignant carcinoid tumor of the rectum', '', 'C7A026', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1652, 'Malignant carcinoid tumor of the large intestine, unspecified portion', '', 'C7A029', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1653, 'Malignant carcinoid tumor of the bronchus and lung', '', 'C7A090', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1654, 'Malignant carcinoid tumor of the thymus', '', 'C7A091', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1655, 'Malignant carcinoid tumor of the stomach', '', 'C7A092', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1656, 'Malignant carcinoid tumor of the kidney', '', 'C7A093', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1657, 'Malignant carcinoid tumor of the foregut, unspecified', '', 'C7A094', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1658, 'Malignant carcinoid tumor of the midgut, unspecified', '', 'C7A095', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1659, 'Malignant carcinoid tumor of the hindgut, unspecified', '', 'C7A096', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1660, 'Malignant carcinoid tumors of other sites', '', 'C7A098', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1661, 'Malignant poorly differentiated neuroendocrine tumors', '', 'C7A1', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1662, 'Other malignant neuroendocrine tumors', '', 'C7A8', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1663, 'Secondary carcinoid tumors, unspecified site', '', 'C7B00', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1664, 'Secondary carcinoid tumors of distant lymph nodes', '', 'C7B01', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1665, 'Secondary carcinoid tumors of liver', '', 'C7B02', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1666, 'Secondary carcinoid tumors of bone', '', 'C7B03', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1667, 'Secondary carcinoid tumors of peritoneum', '', 'C7B04', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1668, 'Secondary carcinoid tumors of other sites', '', 'C7B09', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1669, 'Secondary Merkel cell carcinoma', '', 'C7B1', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1670, 'Other secondary neuroendocrine tumors', '', 'C7B8', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1671, 'Malignant neoplasm of head, face and neck', '', 'C760', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1672, 'Malignant neoplasm of thorax', '', 'C761', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1673, 'Malignant neoplasm of abdomen', '', 'C762', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1674, 'Malignant neoplasm of pelvis', '', 'C763', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1675, 'Malignant neoplasm of unspecified upper limb', '', 'C7640', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1);");


DB::statement("INSERT INTO `symptoms` (`id`, `symptoms_title`, `description`, `code`, `status`, `priority`, `created_at`, `updated_at`, `type`) VALUES
(1676, 'Malignant neoplasm of right upper limb', '', 'C7641', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1677, 'Malignant neoplasm of left upper limb', '', 'C7642', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1678, 'Malignant neoplasm of unspecified lower limb', '', 'C7650', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1679, 'Malignant neoplasm of right lower limb', '', 'C7651', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1680, 'Malignant neoplasm of left lower limb', '', 'C7652', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1681, 'Malignant neoplasm of other specified ill-defined sites', '', 'C768', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1682, 'Secondary and unspecified malignant neoplasm of lymph nodes of head, face and neck', '', 'C770', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1683, 'Secondary and unspecified malignant neoplasm of intrathoracic lymph nodes', '', 'C771', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1684, 'Secondary and unspecified malignant neoplasm of intra-abdominal lymph nodes', '', 'C772', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1685, 'Secondary and unspecified malignant neoplasm of axilla and upper limb lymph nodes', '', 'C773', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1686, 'Secondary and unspecified malignant neoplasm of inguinal and lower limb lymph nodes', '', 'C774', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1687, 'Secondary and unspecified malignant neoplasm of intrapelvic lymph nodes', '', 'C775', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1688, 'Secondary and unspecified malignant neoplasm of lymph nodes of multiple regions', '', 'C778', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1689, 'Secondary and unspecified malignant neoplasm of lymph node, unspecified', '', 'C779', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1690, 'Secondary malignant neoplasm of unspecified lung', '', 'C7800', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1691, 'Secondary malignant neoplasm of right lung', '', 'C7801', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1692, 'Secondary malignant neoplasm of left lung', '', 'C7802', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1693, 'Secondary malignant neoplasm of mediastinum', '', 'C781', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1694, 'Secondary malignant neoplasm of pleura', '', 'C782', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1695, 'Secondary malignant neoplasm of unspecified respiratory organ', '', 'C7830', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1696, 'Secondary malignant neoplasm of other respiratory organs', '', 'C7839', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1697, 'Secondary malignant neoplasm of small intestine', '', 'C784', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1698, 'Secondary malignant neoplasm of large intestine and rectum', '', 'C785', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1699, 'Secondary malignant neoplasm of retroperitoneum and peritoneum', '', 'C786', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1700, 'Secondary malignant neoplasm of liver and intrahepatic bile duct', '', 'C787', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1701, 'Secondary malignant neoplasm of unspecified digestive organ', '', 'C7880', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1702, 'Secondary malignant neoplasm of other digestive organs', '', 'C7889', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1703, 'Secondary malignant neoplasm of unspecified kidney and renal pelvis', '', 'C7900', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1704, 'Secondary malignant neoplasm of right kidney and renal pelvis', '', 'C7901', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1705, 'Secondary malignant neoplasm of left kidney and renal pelvis', '', 'C7902', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1706, 'Secondary malignant neoplasm of unspecified urinary organs', '', 'C7910', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1707, 'Secondary malignant neoplasm of bladder', '', 'C7911', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1708, 'Secondary malignant neoplasm of other urinary organs', '', 'C7919', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1709, 'Secondary malignant neoplasm of skin', '', 'C792', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1710, 'Secondary malignant neoplasm of brain', '', 'C7931', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1711, 'Secondary malignant neoplasm of cerebral meninges', '', 'C7932', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1712, 'Secondary malignant neoplasm of unspecified part of nervous system', '', 'C7940', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1713, 'Secondary malignant neoplasm of other parts of nervous system', '', 'C7949', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1714, 'Secondary malignant neoplasm of bone', '', 'C7951', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1715, 'Secondary malignant neoplasm of bone marrow', '', 'C7952', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1716, 'Secondary malignant neoplasm of unspecified ovary', '', 'C7960', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1717, 'Secondary malignant neoplasm of right ovary', '', 'C7961', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1718, 'Secondary malignant neoplasm of left ovary', '', 'C7962', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1719, 'Secondary malignant neoplasm of unspecified adrenal gland', '', 'C7970', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1720, 'Secondary malignant neoplasm of right adrenal gland', '', 'C7971', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1721, 'Secondary malignant neoplasm of left adrenal gland', '', 'C7972', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1722, 'Secondary malignant neoplasm of breast', '', 'C7981', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1723, 'Secondary malignant neoplasm of genital organs', '', 'C7982', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1724, 'Secondary malignant neoplasm of other specified sites', '', 'C7989', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1725, 'Secondary malignant neoplasm of unspecified site', '', 'C799', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1726, 'Disseminated malignant neoplasm, unspecified', '', 'C800', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1727, 'Malignant (primary) neoplasm, unspecified', '', 'C801', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1728, 'Malignant neoplasm associated with transplanted organ', '', 'C802', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1729, 'Nodular lymphocyte predominant Hodgkin lymphoma, unspecified site', '', 'C8100', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1730, 'Nodular lymphocyte predominant Hodgkin lymphoma, lymph nodes of head, face, and neck', '', 'C8101', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1731, 'Nodular lymphocyte predominant Hodgkin lymphoma, intrathoracic lymph nodes', '', 'C8102', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1732, 'Nodular lymphocyte predominant Hodgkin lymphoma, intra-abdominal lymph nodes', '', 'C8103', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1733, 'Nodular lymphocyte predominant Hodgkin lymphoma, lymph nodes of axilla and upper limb', '', 'C8104', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1734, 'Nodular lymphocyte predominant Hodgkin lymphoma, lymph nodes of inguinal region and lower\nlimb', '', 'C8105', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1735, 'Nodular lymphocyte predominant Hodgkin lymphoma, intrapelvic lymph nodes', '', 'C8106', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1736, 'Nodular lymphocyte predominant Hodgkin lymphoma, spleen', '', 'C8107', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1737, 'Nodular lymphocyte predominant Hodgkin lymphoma, lymph nodes of multiple sites', '', 'C8108', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1738, 'Nodular lymphocyte predominant Hodgkin lymphoma, extranodal and solid organ sites', '', 'C8109', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1739, 'Nodular sclerosis Hodgkin lymphoma, unspecified site', '', 'C8110', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1740, 'Nodular sclerosis Hodgkin lymphoma, lymph nodes of head, face, and neck', '', 'C8111', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1741, 'Nodular sclerosis Hodgkin lymphoma, intrathoracic lymph nodes', '', 'C8112', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1742, 'Nodular sclerosis Hodgkin lymphoma, intra-abdominal lymph nodes', '', 'C8113', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1743, 'Nodular sclerosis Hodgkin lymphoma, lymph nodes of axilla and upper limb', '', 'C8114', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1744, 'Nodular sclerosis Hodgkin lymphoma, lymph nodes of inguinal region and lower limb', '', 'C8115', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1745, 'Nodular sclerosis Hodgkin lymphoma, intrapelvic lymph nodes', '', 'C8116', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1746, 'Nodular sclerosis Hodgkin lymphoma, spleen', '', 'C8117', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1747, 'Nodular sclerosis Hodgkin lymphoma, lymph nodes of multiple sites', '', 'C8118', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1748, 'Nodular sclerosis Hodgkin lymphoma, extranodal and solid organ sites', '', 'C8119', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1749, 'Mixed cellularity Hodgkin lymphoma, unspecified site', '', 'C8120', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1750, 'Mixed cellularity Hodgkin lymphoma, lymph nodes of head, face, and neck', '', 'C8121', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1751, 'Mixed cellularity Hodgkin lymphoma, intrathoracic lymph nodes', '', 'C8122', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1752, 'Mixed cellularity Hodgkin lymphoma, intra-abdominal lymph nodes', '', 'C8123', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1753, 'Mixed cellularity Hodgkin lymphoma, lymph nodes of axilla and upper limb', '', 'C8124', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1754, 'Mixed cellularity Hodgkin lymphoma, lymph nodes of inguinal region and lower limb', '', 'C8125', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1755, 'Mixed cellularity Hodgkin lymphoma, intrapelvic lymph nodes', '', 'C8126', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1756, 'Mixed cellularity Hodgkin lymphoma, spleen', '', 'C8127', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1757, 'Mixed cellularity Hodgkin lymphoma, lymph nodes of multiple sites', '', 'C8128', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1758, 'Mixed cellularity Hodgkin lymphoma, extranodal and solid organ sites', '', 'C8129', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1759, 'Lymphocyte depleted Hodgkin lymphoma, unspecified site', '', 'C8130', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1760, 'Lymphocyte depleted Hodgkin lymphoma, lymph nodes of head, face, and neck', '', 'C8131', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1761, 'Lymphocyte depleted Hodgkin lymphoma, intrathoracic lymph nodes', '', 'C8132', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1762, 'Lymphocyte depleted Hodgkin lymphoma, intra-abdominal lymph nodes', '', 'C8133', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1763, 'Lymphocyte depleted Hodgkin lymphoma, lymph nodes of axilla and upper limb', '', 'C8134', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1764, 'Lymphocyte depleted Hodgkin lymphoma, lymph nodes of inguinal region and lower limb', '', 'C8135', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1765, 'Lymphocyte depleted Hodgkin lymphoma, intrapelvic lymph nodes', '', 'C8136', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1766, 'Lymphocyte depleted Hodgkin lymphoma, spleen', '', 'C8137', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1767, 'Lymphocyte depleted Hodgkin lymphoma, lymph nodes of multiple sites', '', 'C8138', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1768, 'Lymphocyte depleted Hodgkin lymphoma, extranodal and solid organ sites', '', 'C8139', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1769, 'Lymphocyte-rich Hodgkin lymphoma, unspecified site', '', 'C8140', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1770, 'Lymphocyte-rich Hodgkin lymphoma, lymph nodes of head, face, and neck', '', 'C8141', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1771, 'Lymphocyte-rich Hodgkin lymphoma, intrathoracic lymph nodes', '', 'C8142', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1772, 'Lymphocyte-rich Hodgkin lymphoma, intra-abdominal lymph nodes', '', 'C8143', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1773, 'Lymphocyte-rich Hodgkin lymphoma, lymph nodes of axilla and upper limb', '', 'C8144', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1774, 'Lymphocyte-rich Hodgkin lymphoma, lymph nodes of inguinal region and lower limb', '', 'C8145', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1775, 'Lymphocyte-rich Hodgkin lymphoma, intrapelvic lymph nodes', '', 'C8146', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1776, 'Lymphocyte-rich Hodgkin lymphoma, spleen', '', 'C8147', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1777, 'Lymphocyte-rich Hodgkin lymphoma, lymph nodes of multiple sites', '', 'C8148', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1778, 'Lymphocyte-rich Hodgkin lymphoma, extranodal and solid organ sites', '', 'C8149', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1779, 'Other Hodgkin lymphoma, unspecified site', '', 'C8170', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1780, 'Other Hodgkin lymphoma, lymph nodes of head, face, and neck', '', 'C8171', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1781, 'Other Hodgkin lymphoma, intrathoracic lymph nodes', '', 'C8172', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1782, 'Other Hodgkin lymphoma, intra-abdominal lymph nodes', '', 'C8173', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1783, 'Other Hodgkin lymphoma, lymph nodes of axilla and upper limb', '', 'C8174', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1784, 'Other Hodgkin lymphoma, lymph nodes of inguinal region and lower limb', '', 'C8175', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1785, 'Other Hodgkin lymphoma, intrapelvic lymph nodes', '', 'C8176', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1786, 'Other Hodgkin lymphoma, spleen', '', 'C8177', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1787, 'Other Hodgkin lymphoma, lymph nodes of multiple sites', '', 'C8178', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1788, 'Other Hodgkin lymphoma, extranodal and solid organ sites', '', 'C8179', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1789, 'Hodgkin lymphoma, unspecified, unspecified site', '', 'C8190', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1790, 'Hodgkin lymphoma, unspecified, lymph nodes of head, face, and neck', '', 'C8191', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1791, 'Hodgkin lymphoma, unspecified, intrathoracic lymph nodes', '', 'C8192', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1792, 'Hodgkin lymphoma, unspecified, intra-abdominal lymph nodes', '', 'C8193', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1793, 'Hodgkin lymphoma, unspecified, lymph nodes of axilla and upper limb', '', 'C8194', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1794, 'Hodgkin lymphoma, unspecified, lymph nodes of inguinal region and lower limb', '', 'C8195', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1795, 'Hodgkin lymphoma, unspecified, intrapelvic lymph nodes', '', 'C8196', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1796, 'Hodgkin lymphoma, unspecified, spleen', '', 'C8197', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1797, 'Hodgkin lymphoma, unspecified, lymph nodes of multiple sites', '', 'C8198', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1798, 'Hodgkin lymphoma, unspecified, extranodal and solid organ sites', '', 'C8199', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1799, 'Follicular lymphoma grade I, unspecified site', '', 'C8200', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1800, 'Follicular lymphoma grade I, lymph nodes of head, face, and neck', '', 'C8201', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1801, 'Follicular lymphoma grade I, intrathoracic lymph nodes', '', 'C8202', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1802, 'Follicular lymphoma grade I, intra-abdominal lymph nodes', '', 'C8203', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1803, 'Follicular lymphoma grade I, lymph nodes of axilla and upper limb', '', 'C8204', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1804, 'Follicular lymphoma grade I, lymph nodes of inguinal region and lower limb', '', 'C8205', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1805, 'Follicular lymphoma grade I, intrapelvic lymph nodes', '', 'C8206', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1806, 'Follicular lymphoma grade I, spleen', '', 'C8207', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1807, 'Follicular lymphoma grade I, lymph nodes of multiple sites', '', 'C8208', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1808, 'Follicular lymphoma grade I, extranodal and solid organ sites', '', 'C8209', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1809, 'Follicular lymphoma grade II, unspecified site', '', 'C8210', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1810, 'Follicular lymphoma grade II, lymph nodes of head, face, and neck', '', 'C8211', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1811, 'Follicular lymphoma grade II, intrathoracic lymph nodes', '', 'C8212', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1812, 'Follicular lymphoma grade II, intra-abdominal lymph nodes', '', 'C8213', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1813, 'Follicular lymphoma grade II, lymph nodes of axilla and upper limb', '', 'C8214', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1814, 'Follicular lymphoma grade II, lymph nodes of inguinal region and lower limb', '', 'C8215', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1815, 'Follicular lymphoma grade II, intrapelvic lymph nodes', '', 'C8216', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1816, 'Follicular lymphoma grade II, spleen', '', 'C8217', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1817, 'Follicular lymphoma grade II, lymph nodes of multiple sites', '', 'C8218', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1818, 'Follicular lymphoma grade II, extranodal and solid organ sites', '', 'C8219', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1819, 'Follicular lymphoma grade III, unspecified, unspecified site', '', 'C8220', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1820, 'Follicular lymphoma grade III, unspecified, lymph nodes of head, face, and neck', '', 'C8221', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1821, 'Follicular lymphoma grade III, unspecified, intrathoracic lymph nodes', '', 'C8222', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1822, 'Follicular lymphoma grade III, unspecified, intra-abdominal lymph nodes', '', 'C8223', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1823, 'Follicular lymphoma grade III, unspecified, lymph nodes of axilla and upper limb', '', 'C8224', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1824, 'Follicular lymphoma grade III, unspecified, lymph nodes of inguinal region and lower limb', '', 'C8225', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1825, 'Follicular lymphoma grade III, unspecified, intrapelvic lymph nodes', '', 'C8226', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1826, 'Follicular lymphoma grade III, unspecified, spleen', '', 'C8227', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1827, 'Follicular lymphoma grade III, unspecified, lymph nodes of multiple sites', '', 'C8228', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1828, 'Follicular lymphoma grade III, unspecified, extranodal and solid organ sites', '', 'C8229', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1829, 'Follicular lymphoma grade IIIa, unspecified site', '', 'C8230', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1830, 'Follicular lymphoma grade IIIa, lymph nodes of head, face, and neck', '', 'C8231', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1831, 'Follicular lymphoma grade IIIa, intrathoracic lymph nodes', '', 'C8232', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1832, 'Follicular lymphoma grade IIIa, intra-abdominal lymph nodes', '', 'C8233', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1833, 'Follicular lymphoma grade IIIa, lymph nodes of axilla and upper limb', '', 'C8234', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1834, 'Follicular lymphoma grade IIIa, lymph nodes of inguinal region and lower limb', '', 'C8235', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1835, 'Follicular lymphoma grade IIIa, intrapelvic lymph nodes', '', 'C8236', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1836, 'Follicular lymphoma grade IIIa, spleen', '', 'C8237', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1837, 'Follicular lymphoma grade IIIa, lymph nodes of multiple sites', '', 'C8238', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1838, 'Follicular lymphoma grade IIIa, extranodal and solid organ sites', '', 'C8239', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1839, 'Follicular lymphoma grade IIIb, unspecified site', '', 'C8240', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1840, 'Follicular lymphoma grade IIIb, lymph nodes of head, face, and neck', '', 'C8241', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1841, 'Follicular lymphoma grade IIIb, intrathoracic lymph nodes', '', 'C8242', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1842, 'Follicular lymphoma grade IIIb, intra-abdominal lymph nodes', '', 'C8243', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1843, 'Follicular lymphoma grade IIIb, lymph nodes of axilla and upper limb', '', 'C8244', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1844, 'Follicular lymphoma grade IIIb, lymph nodes of inguinal region and lower limb', '', 'C8245', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1845, 'Follicular lymphoma grade IIIb, intrapelvic lymph nodes', '', 'C8246', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1846, 'Follicular lymphoma grade IIIb, spleen', '', 'C8247', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1847, 'Follicular lymphoma grade IIIb, lymph nodes of multiple sites', '', 'C8248', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1848, 'Follicular lymphoma grade IIIb, extranodal and solid organ sites', '', 'C8249', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1849, 'Diffuse follicle center lymphoma, unspecified site', '', 'C8250', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1850, 'Diffuse follicle center lymphoma, lymph nodes of head, face, and neck', '', 'C8251', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1851, 'Diffuse follicle center lymphoma, intrathoracic lymph nodes', '', 'C8252', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1852, 'Diffuse follicle center lymphoma, intra-abdominal lymph nodes', '', 'C8253', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1853, 'Diffuse follicle center lymphoma, lymph nodes of axilla and upper limb', '', 'C8254', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1854, 'Diffuse follicle center lymphoma, lymph nodes of inguinal region and lower limb', '', 'C8255', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1855, 'Diffuse follicle center lymphoma, intrapelvic lymph nodes', '', 'C8256', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1856, 'Diffuse follicle center lymphoma, spleen', '', 'C8257', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1857, 'Diffuse follicle center lymphoma, lymph nodes of multiple sites', '', 'C8258', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1858, 'Diffuse follicle center lymphoma, extranodal and solid organ sites', '', 'C8259', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1859, 'Cutaneous follicle center lymphoma, unspecified site', '', 'C8260', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1860, 'Cutaneous follicle center lymphoma, lymph nodes of head, face, and neck', '', 'C8261', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1861, 'Cutaneous follicle center lymphoma, intrathoracic lymph nodes', '', 'C8262', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1862, 'Cutaneous follicle center lymphoma, intra-abdominal lymph nodes', '', 'C8263', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1863, 'Cutaneous follicle center lymphoma, lymph nodes of axilla and upper limb', '', 'C8264', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1864, 'Cutaneous follicle center lymphoma, lymph nodes of inguinal region and lower limb', '', 'C8265', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1865, 'Cutaneous follicle center lymphoma, intrapelvic lymph nodes', '', 'C8266', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1866, 'Cutaneous follicle center lymphoma, spleen', '', 'C8267', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1867, 'Cutaneous follicle center lymphoma, lymph nodes of multiple sites', '', 'C8268', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1868, 'Cutaneous follicle center lymphoma, extranodal and solid organ sites', '', 'C8269', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1869, 'Other types of follicular lymphoma, unspecified site', '', 'C8280', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1870, 'Other types of follicular lymphoma, lymph nodes of head, face, and neck', '', 'C8281', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1871, 'Other types of follicular lymphoma, intrathoracic lymph nodes', '', 'C8282', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1872, 'Other types of follicular lymphoma, intra-abdominal lymph nodes', '', 'C8283', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1873, 'Other types of follicular lymphoma, lymph nodes of axilla and upper limb', '', 'C8284', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1874, 'Other types of follicular lymphoma, lymph nodes of inguinal region and lower limb', '', 'C8285', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1875, 'Other types of follicular lymphoma, intrapelvic lymph nodes', '', 'C8286', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1876, 'Other types of follicular lymphoma, spleen', '', 'C8287', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1877, 'Other types of follicular lymphoma, lymph nodes of multiple sites', '', 'C8288', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1878, 'Other types of follicular lymphoma, extranodal and solid organ sites', '', 'C8289', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1879, 'Follicular lymphoma, unspecified, unspecified site', '', 'C8290', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1880, 'Follicular lymphoma, unspecified, lymph nodes of head, face, and neck', '', 'C8291', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1881, 'Follicular lymphoma, unspecified, intrathoracic lymph nodes', '', 'C8292', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1882, 'Follicular lymphoma, unspecified, intra-abdominal lymph nodes', '', 'C8293', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1883, 'Follicular lymphoma, unspecified, lymph nodes of axilla and upper limb', '', 'C8294', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1884, 'Follicular lymphoma, unspecified, lymph nodes of inguinal region and lower limb', '', 'C8295', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1885, 'Follicular lymphoma, unspecified, intrapelvic lymph nodes', '', 'C8296', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1886, 'Follicular lymphoma, unspecified, spleen', '', 'C8297', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1887, 'Follicular lymphoma, unspecified, lymph nodes of multiple sites', '', 'C8298', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1888, 'Follicular lymphoma, unspecified, extranodal and solid organ sites', '', 'C8299', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1889, 'Small cell B-cell lymphoma, unspecified site', '', 'C8300', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1890, 'Small cell B-cell lymphoma, lymph nodes of head, face, and neck', '', 'C8301', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1891, 'Small cell B-cell lymphoma, intrathoracic lymph nodes', '', 'C8302', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1892, 'Small cell B-cell lymphoma, intra-abdominal lymph nodes', '', 'C8303', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1893, 'Small cell B-cell lymphoma, lymph nodes of axilla and upper limb', '', 'C8304', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1894, 'Small cell B-cell lymphoma, lymph nodes of inguinal region and lower limb', '', 'C8305', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1895, 'Small cell B-cell lymphoma, intrapelvic lymph nodes', '', 'C8306', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1896, 'Small cell B-cell lymphoma, spleen', '', 'C8307', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1897, 'Small cell B-cell lymphoma, lymph nodes of multiple sites', '', 'C8308', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1898, 'Small cell B-cell lymphoma, extranodal and solid organ sites', '', 'C8309', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1899, 'Mantle cell lymphoma, unspecified site', '', 'C8310', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1900, 'Mantle cell lymphoma, lymph nodes of head, face, and neck', '', 'C8311', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1901, 'Mantle cell lymphoma, intrathoracic lymph nodes', '', 'C8312', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1902, 'Mantle cell lymphoma, intra-abdominal lymph nodes', '', 'C8313', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1903, 'Mantle cell lymphoma, lymph nodes of axilla and upper limb', '', 'C8314', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1904, 'Mantle cell lymphoma, lymph nodes of inguinal region and lower limb', '', 'C8315', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1905, 'Mantle cell lymphoma, intrapelvic lymph nodes', '', 'C8316', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1906, 'Mantle cell lymphoma, spleen', '', 'C8317', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1907, 'Mantle cell lymphoma, lymph nodes of multiple sites', '', 'C8318', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1908, 'Mantle cell lymphoma, extranodal and solid organ sites', '', 'C8319', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1909, 'Diffuse large B-cell lymphoma, unspecified site', '', 'C8330', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1910, 'Diffuse large B-cell lymphoma, lymph nodes of head, face, and neck', '', 'C8331', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1911, 'Diffuse large B-cell lymphoma, intrathoracic lymph nodes', '', 'C8332', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1912, 'Diffuse large B-cell lymphoma, intra-abdominal lymph nodes', '', 'C8333', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1913, 'Diffuse large B-cell lymphoma, lymph nodes of axilla and upper limb', '', 'C8334', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1914, 'Diffuse large B-cell lymphoma, lymph nodes of inguinal region and lower limb', '', 'C8335', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1915, 'Diffuse large B-cell lymphoma, intrapelvic lymph nodes', '', 'C8336', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1916, 'Diffuse large B-cell lymphoma, spleen', '', 'C8337', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1917, 'Diffuse large B-cell lymphoma, lymph nodes of multiple sites', '', 'C8338', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1918, 'Diffuse large B-cell lymphoma, extranodal and solid organ sites', '', 'C8339', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1919, 'Lymphoblastic (diffuse) lymphoma, unspecified site', '', 'C8350', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1920, 'Lymphoblastic (diffuse) lymphoma, lymph nodes of head, face, and neck', '', 'C8351', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1921, 'Lymphoblastic (diffuse) lymphoma, intrathoracic lymph nodes', '', 'C8352', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1922, 'Lymphoblastic (diffuse) lymphoma, intra-abdominal lymph nodes', '', 'C8353', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1923, 'Lymphoblastic (diffuse) lymphoma, lymph nodes of axilla and upper limb', '', 'C8354', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1924, 'Lymphoblastic (diffuse) lymphoma, lymph nodes of inguinal region and lower limb', '', 'C8355', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1925, 'Lymphoblastic (diffuse) lymphoma, intrapelvic lymph nodes', '', 'C8356', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1926, 'Lymphoblastic (diffuse) lymphoma, spleen', '', 'C8357', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1927, 'Lymphoblastic (diffuse) lymphoma, lymph nodes of multiple sites', '', 'C8358', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1928, 'Lymphoblastic (diffuse) lymphoma, extranodal and solid organ sites', '', 'C8359', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1929, 'Burkitt lymphoma, unspecified site', '', 'C8370', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1930, 'Burkitt lymphoma, lymph nodes of head, face, and neck', '', 'C8371', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1931, 'Burkitt lymphoma, intrathoracic lymph nodes', '', 'C8372', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1932, 'Burkitt lymphoma, intra-abdominal lymph nodes', '', 'C8373', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1933, 'Burkitt lymphoma, lymph nodes of axilla and upper limb', '', 'C8374', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1934, 'Burkitt lymphoma, lymph nodes of inguinal region and lower limb', '', 'C8375', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1935, 'Burkitt lymphoma, intrapelvic lymph nodes', '', 'C8376', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1936, 'Burkitt lymphoma, spleen', '', 'C8377', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1937, 'Burkitt lymphoma, lymph nodes of multiple sites', '', 'C8378', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1938, 'Burkitt lymphoma, extranodal and solid organ sites', '', 'C8379', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1939, 'Other non-follicular lymphoma, unspecified site', '', 'C8380', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1940, 'Other non-follicular lymphoma, lymph nodes of head, face, and neck', '', 'C8381', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1941, 'Other non-follicular lymphoma, intrathoracic lymph nodes', '', 'C8382', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1942, 'Other non-follicular lymphoma, intra-abdominal lymph nodes', '', 'C8383', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1943, 'Other non-follicular lymphoma, lymph nodes of axilla and upper limb', '', 'C8384', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1944, 'Other non-follicular lymphoma, lymph nodes of inguinal region and lower limb', '', 'C8385', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1945, 'Other non-follicular lymphoma, intrapelvic lymph nodes', '', 'C8386', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1946, 'Other non-follicular lymphoma, spleen', '', 'C8387', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1947, 'Other non-follicular lymphoma, lymph nodes of multiple sites', '', 'C8388', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1948, 'Other non-follicular lymphoma, extranodal and solid organ sites', '', 'C8389', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1949, 'Non-follicular (diffuse) lymphoma, unspecified, unspecified site', '', 'C8390', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1950, 'Non-follicular (diffuse) lymphoma, unspecified, lymph nodes of head, face, and neck', '', 'C8391', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1951, 'Non-follicular (diffuse) lymphoma, unspecified, intrathoracic lymph nodes', '', 'C8392', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1952, 'Non-follicular (diffuse) lymphoma, unspecified, intra-abdominal lymph nodes', '', 'C8393', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1953, 'Non-follicular (diffuse) lymphoma, unspecified, lymph nodes of axilla and upper limb', '', 'C8394', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1954, 'Non-follicular (diffuse) lymphoma, unspecified, lymph nodes of inguinal region and lower limb', '', 'C8395', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1955, 'Non-follicular (diffuse) lymphoma, unspecified, intrapelvic lymph nodes', '', 'C8396', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1956, 'Non-follicular (diffuse) lymphoma, unspecified, spleen', '', 'C8397', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1957, 'Non-follicular (diffuse) lymphoma, unspecified, lymph nodes of multiple sites', '', 'C8398', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1958, 'Non-follicular (diffuse) lymphoma, unspecified, extranodal and solid organ sites', '', 'C8399', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1959, 'Mycosis fungoides, unspecified site', '', 'C8400', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1960, 'Mycosis fungoides, lymph nodes of head, face, and neck', '', 'C8401', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1961, 'Mycosis fungoides, intrathoracic lymph nodes', '', 'C8402', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1962, 'Mycosis fungoides, intra-abdominal lymph nodes', '', 'C8403', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1963, 'Mycosis fungoides, lymph nodes of axilla and upper limb', '', 'C8404', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1964, 'Mycosis fungoides, lymph nodes of inguinal region and lower limb', '', 'C8405', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1965, 'Mycosis fungoides, intrapelvic lymph nodes', '', 'C8406', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1966, 'Mycosis fungoides, spleen', '', 'C8407', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1967, 'Mycosis fungoides, lymph nodes of multiple sites', '', 'C8408', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1968, 'Mycosis fungoides, extranodal and solid organ sites', '', 'C8409', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1969, 'Sezary disease, unspecified site', '', 'C8410', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1970, 'Sezary disease, lymph nodes of head, face, and neck', '', 'C8411', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1971, 'Sezary disease, intrathoracic lymph nodes', '', 'C8412', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1972, 'Sezary disease, intra-abdominal lymph nodes', '', 'C8413', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1973, 'Sezary disease, lymph nodes of axilla and upper limb', '', 'C8414', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1974, 'Sezary disease, lymph nodes of inguinal region and lower limb', '', 'C8415', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1975, 'Sezary disease, intrapelvic lymph nodes', '', 'C8416', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1976, 'Sezary disease, spleen', '', 'C8417', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1977, 'Sezary disease, lymph nodes of multiple sites', '', 'C8418', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1978, 'Sezary disease, extranodal and solid organ sites', '', 'C8419', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1979, 'Peripheral T-cell lymphoma, not classified, unspecified site', '', 'C8440', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1980, 'Peripheral T-cell lymphoma, not classified, lymph nodes of head, face, and neck', '', 'C8441', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1981, 'Peripheral T-cell lymphoma, not classified, intrathoracic lymph nodes', '', 'C8442', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1982, 'Peripheral T-cell lymphoma, not classified, intra-abdominal lymph nodes', '', 'C8443', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1983, 'Peripheral T-cell lymphoma, not classified, lymph nodes of axilla and upper limb', '', 'C8444', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1984, 'Peripheral T-cell lymphoma, not classified, lymph nodes of inguinal region and lower limb', '', 'C8445', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1985, 'Peripheral T-cell lymphoma, not classified, intrapelvic lymph nodes', '', 'C8446', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1986, 'Peripheral T-cell lymphoma, not classified, spleen', '', 'C8447', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1987, 'Peripheral T-cell lymphoma, not classified, lymph nodes of multiple sites', '', 'C8448', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1988, 'Peripheral T-cell lymphoma, not classified, extranodal and solid organ sites', '', 'C8449', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1989, 'Anaplastic large cell lymphoma, ALK-positive, unspecified site', '', 'C8460', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1990, 'Anaplastic large cell lymphoma, ALK-positive, lymph nodes of head, face, and neck', '', 'C8461', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1991, 'Anaplastic large cell lymphoma, ALK-positive, intrathoracic lymph nodes', '', 'C8462', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1992, 'Anaplastic large cell lymphoma, ALK-positive, intra-abdominal lymph nodes', '', 'C8463', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1993, 'Anaplastic large cell lymphoma, ALK-positive, lymph nodes of axilla and upper limb', '', 'C8464', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1994, 'Anaplastic large cell lymphoma, ALK-positive, lymph nodes of inguinal region and lower limb', '', 'C8465', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1995, 'Anaplastic large cell lymphoma, ALK-positive, intrapelvic lymph nodes', '', 'C8466', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1996, 'Anaplastic large cell lymphoma, ALK-positive, spleen', '', 'C8467', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1997, 'Anaplastic large cell lymphoma, ALK-positive, lymph nodes of multiple sites', '', 'C8468', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1998, 'Anaplastic large cell lymphoma, ALK-positive, extranodal and solid organ sites', '', 'C8469', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(1999, 'Anaplastic large cell lymphoma, ALK-negative, unspecified site', '', 'C8470', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2000, 'Anaplastic large cell lymphoma, ALK-negative, lymph nodes of head, face, and neck', '', 'C8471', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2001, 'Anaplastic large cell lymphoma, ALK-negative, intrathoracic lymph nodes', '', 'C8472', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2002, 'Anaplastic large cell lymphoma, ALK-negative, intra-abdominal lymph nodes', '', 'C8473', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2003, 'Anaplastic large cell lymphoma, ALK-negative, lymph nodes of axilla and upper limb', '', 'C8474', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2004, 'Anaplastic large cell lymphoma, ALK-negative, lymph nodes of inguinal region and lower limb', '', 'C8475', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2005, 'Anaplastic large cell lymphoma, ALK-negative, intrapelvic lymph nodes', '', 'C8476', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2006, 'Anaplastic large cell lymphoma, ALK-negative, spleen', '', 'C8477', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2007, 'Anaplastic large cell lymphoma, ALK-negative, lymph nodes of multiple sites', '', 'C8478', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2008, 'Anaplastic large cell lymphoma, ALK-negative, extranodal and solid organ sites', '', 'C8479', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2009, 'Cutaneous T-cell lymphoma, unspecified, unspecified site', '', 'C84A0', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2010, 'Cutaneous T-cell lymphoma, unspecified lymph nodes of head, face, and neck', '', 'C84A1', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2011, 'Cutaneous T-cell lymphoma, unspecified, intrathoracic lymph nodes', '', 'C84A2', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2012, 'Cutaneous T-cell lymphoma, unspecified, intra-abdominal lymph nodes', '', 'C84A3', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2013, 'Cutaneous T-cell lymphoma, unspecified, lymph nodes of axilla and upper limb', '', 'C84A4', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2014, 'Cutaneous T-cell lymphoma, unspecified, lymph nodes of inguinal region and lower limb', '', 'C84A5', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2015, 'Cutaneous T-cell lymphoma, unspecified, intrapelvic lymph nodes', '', 'C84A6', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2016, 'Cutaneous T-cell lymphoma, unspecified, spleen', '', 'C84A7', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2017, 'Cutaneous T-cell lymphoma, unspecified, lymph nodes of multiple sites', '', 'C84A8', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2018, 'Cutaneous T-cell lymphoma, unspecified, extranodal and solid organ sites', '', 'C84A9', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2019, 'Other mature T/NK-cell lymphomas, unspecified site', '', 'C84Z0', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2020, 'Other mature T/NK-cell lymphomas, lymph nodes of head, face, and neck', '', 'C84Z1', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2021, 'Other mature T/NK-cell lymphomas, intrathoracic lymph nodes', '', 'C84Z2', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2022, 'Other mature T/NK-cell lymphomas, intra-abdominal lymph nodes', '', 'C84Z3', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2023, 'Other mature T/NK-cell lymphomas, lymph nodes of axilla and upper limb', '', 'C84Z4', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2024, 'Other mature T/NK-cell lymphomas, lymph nodes of inguinal region and lower limb', '', 'C84Z5', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2025, 'Other mature T/NK-cell lymphomas, intrapelvic lymph nodes', '', 'C84Z6', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2026, 'Other mature T/NK-cell lymphomas, spleen', '', 'C84Z7', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2027, 'Other mature T/NK-cell lymphomas, lymph nodes of multiple sites', '', 'C84Z8', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2028, 'Other mature T/NK-cell lymphomas, extranodal and solid organ sites', '', 'C84Z9', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1);");



DB::statement("INSERT INTO `symptoms` (`id`, `symptoms_title`, `description`, `code`, `status`, `priority`, `created_at`, `updated_at`, `type`) VALUES
(2029, 'Mature T/NK-cell lymphomas, unspecified, unspecified site', '', 'C8490', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2030, 'Mature T/NK-cell lymphomas, unspecified, lymph nodes of head, face, and neck', '', 'C8491', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2031, 'Mature T/NK-cell lymphomas, unspecified, intrathoracic lymph nodes', '', 'C8492', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2032, 'Mature T/NK-cell lymphomas, unspecified, intra-abdominal lymph nodes', '', 'C8493', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2033, 'Mature T/NK-cell lymphomas, unspecified, lymph nodes of axilla and upper limb', '', 'C8494', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2034, 'Mature T/NK-cell lymphomas, unspecified, lymph nodes of inguinal region and lower limb', '', 'C8495', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2035, 'Mature T/NK-cell lymphomas, unspecified, intrapelvic lymph nodes', '', 'C8496', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2036, 'Mature T/NK-cell lymphomas, unspecified, spleen', '', 'C8497', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2037, 'Mature T/NK-cell lymphomas, unspecified, lymph nodes of multiple sites', '', 'C8498', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2038, 'Mature T/NK-cell lymphomas, unspecified, extranodal and solid organ sites', '', 'C8499', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2039, 'Unspecified B-cell lymphoma, unspecified site', '', 'C8510', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2040, 'Unspecified B-cell lymphoma, lymph nodes of head, face, and neck', '', 'C8511', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2041, 'Unspecified B-cell lymphoma, intrathoracic lymph nodes', '', 'C8512', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2042, 'Unspecified B-cell lymphoma, intra-abdominal lymph nodes', '', 'C8513', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2043, 'Unspecified B-cell lymphoma, lymph nodes of axilla and upper limb', '', 'C8514', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2044, 'Unspecified B-cell lymphoma, lymph nodes of inguinal region and lower limb', '', 'C8515', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2045, 'Unspecified B-cell lymphoma, intrapelvic lymph nodes', '', 'C8516', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2046, 'Unspecified B-cell lymphoma, spleen', '', 'C8517', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2047, 'Unspecified B-cell lymphoma, lymph nodes of multiple sites', '', 'C8518', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2048, 'Unspecified B-cell lymphoma, extranodal and solid organ sites', '', 'C8519', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2049, 'Mediastinal (thymic) large B-cell lymphoma, unspecified site', '', 'C8520', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2050, 'Mediastinal (thymic) large B-cell lymphoma, lymph nodes of head, face, and neck', '', 'C8521', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2051, 'Mediastinal (thymic) large B-cell lymphoma, intrathoracic lymph nodes', '', 'C8522', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2052, 'Mediastinal (thymic) large B-cell lymphoma, intra-abdominal lymph nodes', '', 'C8523', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2053, 'Mediastinal (thymic) large B-cell lymphoma, lymph nodes of axilla and upper limb', '', 'C8524', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2054, 'Mediastinal (thymic) large B-cell lymphoma, lymph nodes of inguinal region and lower limb', '', 'C8525', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2055, 'Mediastinal (thymic) large B-cell lymphoma, intrapelvic lymph nodes', '', 'C8526', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2056, 'Mediastinal (thymic) large B-cell lymphoma, spleen', '', 'C8527', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2057, 'Mediastinal (thymic) large B-cell lymphoma, lymph nodes of multiple sites', '', 'C8528', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2058, 'Mediastinal (thymic) large B-cell lymphoma, extranodal and solid organ sites', '', 'C8529', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2059, 'Other specified types of non-Hodgkin lymphoma, unspecified site', '', 'C8580', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2060, 'Other specified types of non-Hodgkin lymphoma, lymph nodes of head, face, and neck', '', 'C8581', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2061, 'Other specified types of non-Hodgkin lymphoma, intrathoracic lymph nodes', '', 'C8582', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2062, 'Other specified types of non-Hodgkin lymphoma, intra-abdominal lymph nodes', '', 'C8583', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2063, 'Other specified types of non-Hodgkin lymphoma, lymph nodes of axilla and upper limb', '', 'C8584', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2064, 'Other specified types of non-Hodgkin lymphoma, lymph nodes of inguinal region and lower limb', '', 'C8585', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2065, 'Other specified types of non-Hodgkin lymphoma, intrapelvic lymph nodes', '', 'C8586', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2066, 'Other specified types of non-Hodgkin lymphoma, spleen', '', 'C8587', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2067, 'Other specified types of non-Hodgkin lymphoma, lymph nodes of multiple sites', '', 'C8588', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2068, 'Other specified types of non-Hodgkin lymphoma, extranodal and solid organ sites', '', 'C8589', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2069, 'Non-Hodgkin lymphoma, unspecified, unspecified site', '', 'C8590', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2070, 'Non-Hodgkin lymphoma, unspecified, lymph nodes of head, face, and neck', '', 'C8591', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2071, 'Non-Hodgkin lymphoma, unspecified, intrathoracic lymph nodes', '', 'C8592', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2072, 'Non-Hodgkin lymphoma, unspecified, intra-abdominal lymph nodes', '', 'C8593', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2073, 'Non-Hodgkin lymphoma, unspecified, lymph nodes of axilla and upper limb', '', 'C8594', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2074, 'Non-Hodgkin lymphoma, unspecified, lymph nodes of inguinal region and lower limb', '', 'C8595', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2075, 'Non-Hodgkin lymphoma, unspecified, intrapelvic lymph nodes', '', 'C8596', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2076, 'Non-Hodgkin lymphoma, unspecified, spleen', '', 'C8597', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2077, 'Non-Hodgkin lymphoma, unspecified, lymph nodes of multiple sites', '', 'C8598', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2078, 'Non-Hodgkin lymphoma, unspecified, extranodal and solid organ sites', '', 'C8599', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2079, 'Extranodal NK/T-cell lymphoma, nasal type', '', 'C860', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2080, 'Hepatosplenic T-cell lymphoma', '', 'C861', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2081, 'Enteropathy-type (intestinal) T-cell lymphoma', '', 'C862', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2082, 'Subcutaneous panniculitis-like T-cell lymphoma', '', 'C863', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2083, 'Blastic NK-cell lymphoma', '', 'C864', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2084, 'Angioimmunoblastic T-cell lymphoma', '', 'C865', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2085, 'Primary cutaneous CD30-positive T-cell proliferations', '', 'C866', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2086, 'Waldenstrom macroglobulinemia', '', 'C880', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2087, 'Heavy chain disease', '', 'C882', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2088, 'Immunoproliferative small intestinal disease', '', 'C883', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2089, 'Extranodal marginal zone B-cell lymphoma of mucosa-associated lymphoid tissue [MALT-\nlymphoma]', '', 'C884', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2090, 'Other malignant immunoproliferative diseases', '', 'C888', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2091, 'Malignant immunoproliferative disease, unspecified', '', 'C889', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2092, 'Multiple myeloma not having achieved remission', '', 'C9000', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2093, 'Multiple myeloma in remission', '', 'C9001', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2094, 'Multiple myeloma in relapse', '', 'C9002', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2095, 'Plasma cell leukemia not having achieved remission', '', 'C9010', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2096, 'Plasma cell leukemia in remission', '', 'C9011', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2097, 'Plasma cell leukemia in relapse', '', 'C9012', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2098, 'Extramedullary plasmacytoma not having achieved remission', '', 'C9020', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2099, 'Extramedullary plasmacytoma in remission', '', 'C9021', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2100, 'Extramedullary plasmacytoma in relapse', '', 'C9022', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2101, 'Solitary plasmacytoma not having achieved remission', '', 'C9030', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2102, 'Solitary plasmacytoma in remission', '', 'C9031', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2103, 'Solitary plasmacytoma in relapse', '', 'C9032', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2104, 'Acute lymphoblastic leukemia not having achieved remission', '', 'C9100', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2105, 'Acute lymphoblastic leukemia, in remission', '', 'C9101', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2106, 'Acute lymphoblastic leukemia, in relapse', '', 'C9102', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2107, 'Chronic lymphocytic leukemia of B-cell type not having achieved remission', '', 'C9110', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2108, 'Chronic lymphocytic leukemia of B-cell type in remission', '', 'C9111', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2109, 'Chronic lymphocytic leukemia of B-cell type in relapse', '', 'C9112', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2110, 'Prolymphocytic leukemia of B-cell type not having achieved remission', '', 'C9130', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2111, 'Prolymphocytic leukemia of B-cell type, in remission', '', 'C9131', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2112, 'Prolymphocytic leukemia of B-cell type, in relapse', '', 'C9132', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2113, 'Hairy cell leukemia not having achieved remission', '', 'C9140', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2114, 'Hairy cell leukemia, in remission', '', 'C9141', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2115, 'Hairy cell leukemia, in relapse', '', 'C9142', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2116, 'Adult T-cell lymphoma/leukemia (HTLV-1-associated) not having achieved remission', '', 'C9150', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2117, 'Adult T-cell lymphoma/leukemia (HTLV-1-associated), in remission', '', 'C9151', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2118, 'Adult T-cell lymphoma/leukemia (HTLV-1-associated), in relapse', '', 'C9152', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2119, 'Prolymphocytic leukemia of T-cell type not having achieved remission', '', 'C9160', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2120, 'Prolymphocytic leukemia of T-cell type, in remission', '', 'C9161', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2121, 'Prolymphocytic leukemia of T-cell type, in relapse', '', 'C9162', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2122, 'Mature B-cell leukemia Burkitt-type not having achieved remission', '', 'C91A0', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2123, 'Mature B-cell leukemia Burkitt-type, in remission', '', 'C91A1', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2124, 'Mature B-cell leukemia Burkitt-type, in relapse', '', 'C91A2', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2125, 'Other lymphoid leukemia not having achieved remission', '', 'C91Z0', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2126, 'Other lymphoid leukemia, in remission', '', 'C91Z1', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2127, 'Other lymphoid leukemia, in relapse', '', 'C91Z2', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2128, 'Lymphoid leukemia, unspecified not having achieved remission', '', 'C9190', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2129, 'Lymphoid leukemia, unspecified, in remission', '', 'C9191', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2130, 'Lymphoid leukemia, unspecified, in relapse', '', 'C9192', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2131, 'Acute myeloblastic leukemia, not having achieved remission', '', 'C9200', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2132, 'Acute myeloblastic leukemia, in remission', '', 'C9201', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2133, 'Acute myeloblastic leukemia, in relapse', '', 'C9202', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2134, 'Chronic myeloid leukemia, BCR/ABL-positive, not having achieved remission', '', 'C9210', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2135, 'Chronic myeloid leukemia, BCR/ABL-positive, in remission', '', 'C9211', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2136, 'Chronic myeloid leukemia, BCR/ABL-positive, in relapse', '', 'C9212', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2137, 'Atypical chronic myeloid leukemia, BCR/ABL-negative, not having achieved remission', '', 'C9220', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2138, 'Atypical chronic myeloid leukemia, BCR/ABL-negative, in remission', '', 'C9221', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2139, 'Atypical chronic myeloid leukemia, BCR/ABL-negative, in relapse', '', 'C9222', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2140, 'Myeloid sarcoma, not having achieved remission', '', 'C9230', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2141, 'Myeloid sarcoma, in remission', '', 'C9231', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2142, 'Myeloid sarcoma, in relapse', '', 'C9232', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2143, 'Acute promyelocytic leukemia, not having achieved remission', '', 'C9240', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2144, 'Acute promyelocytic leukemia, in remission', '', 'C9241', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2145, 'Acute promyelocytic leukemia, in relapse', '', 'C9242', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2146, 'Acute myelomonocytic leukemia, not having achieved remission', '', 'C9250', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2147, 'Acute myelomonocytic leukemia, in remission', '', 'C9251', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2148, 'Acute myelomonocytic leukemia, in relapse', '', 'C9252', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2149, 'Acute myeloid leukemia with 11q23-abnormality not having achieved remission', '', 'C9260', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2150, 'Acute myeloid leukemia with 11q23-abnormality in remission', '', 'C9261', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2151, 'Acute myeloid leukemia with 11q23-abnormality in relapse', '', 'C9262', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2152, 'Acute myeloid leukemia with multilineage dysplasia, not having achieved remission', '', 'C92A0', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2153, 'Acute myeloid leukemia with multilineage dysplasia, in remission', '', 'C92A1', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2154, 'Acute myeloid leukemia with multilineage dysplasia, in relapse', '', 'C92A2', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2155, 'Other myeloid leukemia not having achieved remission', '', 'C92Z0', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2156, 'Other myeloid leukemia, in remission', '', 'C92Z1', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2157, 'Other myeloid leukemia, in relapse', '', 'C92Z2', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2158, 'Myeloid leukemia, unspecified, not having achieved remission', '', 'C9290', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2159, 'Myeloid leukemia, unspecified in remission', '', 'C9291', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2160, 'Myeloid leukemia, unspecified in relapse', '', 'C9292', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2161, 'Acute monoblastic/monocytic leukemia, not having achieved remission', '', 'C9300', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2162, 'Acute monoblastic/monocytic leukemia, in remission', '', 'C9301', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2163, 'Acute monoblastic/monocytic leukemia, in relapse', '', 'C9302', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2164, 'Chronic myelomonocytic leukemia not having achieved remission', '', 'C9310', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2165, 'Chronic myelomonocytic leukemia, in remission', '', 'C9311', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2166, 'Chronic myelomonocytic leukemia, in relapse', '', 'C9312', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2167, 'Juvenile myelomonocytic leukemia, not having achieved remission', '', 'C9330', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2168, 'Juvenile myelomonocytic leukemia, in remission', '', 'C9331', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2169, 'Juvenile myelomonocytic leukemia, in relapse', '', 'C9332', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2170, 'Other monocytic leukemia, not having achieved remission', '', 'C93Z0', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2171, 'Other monocytic leukemia, in remission', '', 'C93Z1', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2172, 'Other monocytic leukemia, in relapse', '', 'C93Z2', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2173, 'Monocytic leukemia, unspecified, not having achieved remission', '', 'C9390', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2174, 'Monocytic leukemia, unspecified in remission', '', 'C9391', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2175, 'Monocytic leukemia, unspecified in relapse', '', 'C9392', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2176, 'Acute erythroid leukemia, not having achieved remission', '', 'C9400', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2177, 'Acute erythroid leukemia, in remission', '', 'C9401', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2178, 'Acute erythroid leukemia, in relapse', '', 'C9402', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2179, 'Acute megakaryoblastic leukemia not having achieved remission', '', 'C9420', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2180, 'Acute megakaryoblastic leukemia, in remission', '', 'C9421', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2181, 'Acute megakaryoblastic leukemia, in relapse', '', 'C9422', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2182, 'Mast cell leukemia not having achieved remission', '', 'C9430', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2183, 'Mast cell leukemia, in remission', '', 'C9431', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2184, 'Mast cell leukemia, in relapse', '', 'C9432', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2185, 'Acute panmyelosis with myelofibrosis not having achieved remission', '', 'C9440', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2186, 'Acute panmyelosis with myelofibrosis, in remission', '', 'C9441', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2187, 'Acute panmyelosis with myelofibrosis, in relapse', '', 'C9442', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2188, 'Myelodysplastic disease, not classified', '', 'C946', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2189, 'Other specified leukemias not having achieved remission', '', 'C9480', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2190, 'Other specified leukemias, in remission', '', 'C9481', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2191, 'Other specified leukemias, in relapse', '', 'C9482', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2192, 'Acute leukemia of unspecified cell type not having achieved remission', '', 'C9500', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2193, 'Acute leukemia of unspecified cell type, in remission', '', 'C9501', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2194, 'Acute leukemia of unspecified cell type, in relapse', '', 'C9502', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2195, 'Chronic leukemia of unspecified cell type not having achieved remission', '', 'C9510', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2196, 'Chronic leukemia of unspecified cell type, in remission', '', 'C9511', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2197, 'Chronic leukemia of unspecified cell type, in relapse', '', 'C9512', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2198, 'Leukemia, unspecified not having achieved remission', '', 'C9590', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2199, 'Leukemia, unspecified, in remission', '', 'C9591', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2200, 'Leukemia, unspecified, in relapse', '', 'C9592', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2201, 'Multifocal and multisystemic (disseminated) Langerhans-cell histiocytosis', '', 'C960', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2202, 'Malignant mast cell tumor', '', 'C962', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2203, 'Sarcoma of dendritic cells (accessory cells)', '', 'C964', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2204, 'Multifocal and unisystemic Langerhans-cell histiocytosis', '', 'C965', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2205, 'Unifocal Langerhans-cell histiocytosis', '', 'C966', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2206, 'Histiocytic sarcoma', '', 'C96A', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2207, 'Other specified malignant neoplasms of lymphoid, hematopoietic and related tissue', '', 'C96Z', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2208, 'Malignant neoplasm of lymphoid, hematopoietic and related tissue, unspecified', '', 'C969', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2209, 'Carcinoma in situ of oral cavity, unspecified site', '', 'D0000', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2210, 'Carcinoma in situ of labial mucosa and vermilion border', '', 'D0001', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2211, 'Carcinoma in situ of buccal mucosa', '', 'D0002', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2212, 'Carcinoma in situ of gingiva and edentulous alveolar ridge', '', 'D0003', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2213, 'Carcinoma in situ of soft palate', '', 'D0004', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2214, 'Carcinoma in situ of hard palate', '', 'D0005', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2215, 'Carcinoma in situ of floor of mouth', '', 'D0006', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2216, 'Carcinoma in situ of tongue', '', 'D0007', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2217, 'Carcinoma in situ of pharynx', '', 'D0008', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2218, 'Carcinoma in situ of esophagus', '', 'D001', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2219, 'Carcinoma in situ of stomach', '', 'D002', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2220, 'Carcinoma in situ of colon', '', 'D010', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2221, 'Carcinoma in situ of rectosigmoid junction', '', 'D011', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2222, 'Carcinoma in situ of rectum', '', 'D012', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2223, 'Carcinoma in situ of anus and anal canal', '', 'D013', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2224, 'Carcinoma in situ of unspecified part of intestine', '', 'D0140', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2225, 'Carcinoma in situ of other parts of intestine', '', 'D0149', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2226, 'Carcinoma in situ of liver, gallbladder and bile ducts', '', 'D015', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2227, 'Carcinoma in situ of other specified digestive organs', '', 'D017', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2228, 'Carcinoma in situ of digestive organ, unspecified', '', 'D019', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2229, 'Carcinoma in situ of larynx', '', 'D020', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2230, 'Carcinoma in situ of trachea', '', 'D021', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2231, 'Carcinoma in situ of unspecified bronchus and lung', '', 'D0220', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2232, 'Carcinoma in situ of right bronchus and lung', '', 'D0221', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2233, 'Carcinoma in situ of left bronchus and lung', '', 'D0222', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2234, 'Carcinoma in situ of other parts of respiratory system', '', 'D023', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2235, 'Carcinoma in situ of respiratory system, unspecified', '', 'D024', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2236, 'Melanoma in situ of lip', '', 'D030', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2237, 'Melanoma in situ of unspecified eyelid, including canthus', '', 'D0310', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2238, 'Melanoma in situ of right eyelid, including canthus', '', 'D0311', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2239, 'Melanoma in situ of left eyelid, including canthus', '', 'D0312', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2240, 'Melanoma in situ of unspecified ear and external auricular canal', '', 'D0320', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2241, 'Melanoma in situ of right ear and external auricular canal', '', 'D0321', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2242, 'Melanoma in situ of left ear and external auricular canal', '', 'D0322', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2243, 'Melanoma in situ of unspecified part of face', '', 'D0330', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2244, 'Melanoma in situ of other parts of face', '', 'D0339', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2245, 'Melanoma in situ of scalp and neck', '', 'D034', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2246, 'Melanoma in situ of anal skin', '', 'D0351', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2247, 'Melanoma in situ of breast (skin) (soft tissue)', '', 'D0352', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2248, 'Melanoma in situ of other part of trunk', '', 'D0359', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2249, 'Melanoma in situ of unspecified upper limb, including shoulder', '', 'D0360', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2250, 'Melanoma in situ of right upper limb, including shoulder', '', 'D0361', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2251, 'Melanoma in situ of left upper limb, including shoulder', '', 'D0362', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2252, 'Melanoma in situ of unspecified lower limb, including hip', '', 'D0370', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2253, 'Melanoma in situ of right lower limb, including hip', '', 'D0371', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2254, 'Melanoma in situ of left lower limb, including hip', '', 'D0372', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2255, 'Melanoma in situ of other sites', '', 'D038', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2256, 'Melanoma in situ, unspecified', '', 'D039', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2257, 'Carcinoma in situ of skin of lip', '', 'D040', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2258, 'Carcinoma in situ of skin of unspecified eyelid, including canthus', '', 'D0410', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2259, 'Carcinoma in situ of skin of right eyelid, including canthus', '', 'D0411', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2260, 'Carcinoma in situ of skin of left eyelid, including canthus', '', 'D0412', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2261, 'Carcinoma in situ of skin of unspecified ear and external auricular canal', '', 'D0420', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2262, 'Carcinoma in situ of skin of right ear and external auricular canal', '', 'D0421', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2263, 'Carcinoma in situ of skin of left ear and external auricular canal', '', 'D0422', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2264, 'Carcinoma in situ of skin of unspecified part of face', '', 'D0430', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2265, 'Carcinoma in situ of skin of other parts of face', '', 'D0439', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2266, 'Carcinoma in situ of skin of scalp and neck', '', 'D044', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2267, 'Carcinoma in situ of skin of trunk', '', 'D045', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2268, 'Carcinoma in situ of skin of unspecified upper limb, including shoulder', '', 'D0460', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2269, 'Carcinoma in situ of skin of right upper limb, including shoulder', '', 'D0461', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2270, 'Carcinoma in situ of skin of left upper limb, including shoulder', '', 'D0462', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2271, 'Carcinoma in situ of skin of unspecified lower limb, including hip', '', 'D0470', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2272, 'Carcinoma in situ of skin of right lower limb, including hip', '', 'D0471', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2273, 'Carcinoma in situ of skin of left lower limb, including hip', '', 'D0472', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2274, 'Carcinoma in situ of skin of other sites', '', 'D048', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2275, 'Carcinoma in situ of skin, unspecified', '', 'D049', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2276, 'Lobular carcinoma in situ of unspecified breast', '', 'D0500', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2277, 'Lobular carcinoma in situ of right breast', '', 'D0501', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2278, 'Lobular carcinoma in situ of left breast', '', 'D0502', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2279, 'Intraductal carcinoma in situ of unspecified breast', '', 'D0510', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2280, 'Intraductal carcinoma in situ of right breast', '', 'D0511', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2281, 'Intraductal carcinoma in situ of left breast', '', 'D0512', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2282, 'Other specified type of carcinoma in situ of unspecified breast', '', 'D0580', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2283, 'Other specified type of carcinoma in situ of right breast', '', 'D0581', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2284, 'Other specified type of carcinoma in situ of left breast', '', 'D0582', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2285, 'Unspecified type of carcinoma in situ of unspecified breast', '', 'D0590', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2286, 'Unspecified type of carcinoma in situ of right breast', '', 'D0591', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2287, 'Unspecified type of carcinoma in situ of left breast', '', 'D0592', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2288, 'Carcinoma in situ of endocervix', '', 'D060', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2289, 'Carcinoma in situ of exocervix', '', 'D061', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2290, 'Carcinoma in situ of other parts of cervix', '', 'D067', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2291, 'Carcinoma in situ of cervix, unspecified', '', 'D069', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2292, 'Carcinoma in situ of endometrium', '', 'D070', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2293, 'Carcinoma in situ of vulva', '', 'D071', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2294, 'Carcinoma in situ of vagina', '', 'D072', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2295, 'Carcinoma in situ of unspecified female genital organs', '', 'D0730', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2296, 'Carcinoma in situ of other female genital organs', '', 'D0739', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2297, 'Carcinoma in situ of penis', '', 'D074', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2298, 'Carcinoma in situ of prostate', '', 'D075', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2299, 'Carcinoma in situ of unspecified male genital organs', '', 'D0760', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2300, 'Carcinoma in situ of scrotum', '', 'D0761', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2301, 'Carcinoma in situ of other male genital organs', '', 'D0769', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2302, 'Carcinoma in situ of bladder', '', 'D090', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2303, 'Carcinoma in situ of unspecified urinary organ', '', 'D0910', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2304, 'Carcinoma in situ of other urinary organs', '', 'D0919', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2305, 'Carcinoma in situ of unspecified eye', '', 'D0920', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2306, 'Carcinoma in situ of right eye', '', 'D0921', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2307, 'Carcinoma in situ of left eye', '', 'D0922', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2308, 'Carcinoma in situ of thyroid and other endocrine glands', '', 'D093', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2309, 'Carcinoma in situ of other specified sites', '', 'D098', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2310, 'Carcinoma in situ, unspecified', '', 'D099', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2311, 'Benign neoplasm of lip', '', 'D100', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2312, 'Benign neoplasm of tongue', '', 'D101', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2313, 'Benign neoplasm of floor of mouth', '', 'D102', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2314, 'Benign neoplasm of unspecified part of mouth', '', 'D1030', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2315, 'Benign neoplasm of other parts of mouth', '', 'D1039', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2316, 'Benign neoplasm of tonsil', '', 'D104', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2317, 'Benign neoplasm of other parts of oropharynx', '', 'D105', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2318, 'Benign neoplasm of nasopharynx', '', 'D106', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2319, 'Benign neoplasm of hypopharynx', '', 'D107', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2320, 'Benign neoplasm of pharynx, unspecified', '', 'D109', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2321, 'Benign neoplasm of parotid gland', '', 'D110', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2322, 'Benign neoplasm of other major salivary glands', '', 'D117', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2323, 'Benign neoplasm of major salivary gland, unspecified', '', 'D119', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2324, 'Benign neoplasm of cecum', '', 'D120', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2325, 'Benign neoplasm of appendix', '', 'D121', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2326, 'Benign neoplasm of ascending colon', '', 'D122', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2327, 'Benign neoplasm of transverse colon', '', 'D123', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2328, 'Benign neoplasm of descending colon', '', 'D124', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2329, 'Benign neoplasm of sigmoid colon', '', 'D125', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2330, 'Benign neoplasm of colon, unspecified', '', 'D126', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2331, 'Benign neoplasm of rectosigmoid junction', '', 'D127', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2332, 'Benign neoplasm of rectum', '', 'D128', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2333, 'Benign neoplasm of anus and anal canal', '', 'D129', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2334, 'Benign neoplasm of esophagus', '', 'D130', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2335, 'Benign neoplasm of stomach', '', 'D131', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2336, 'Benign neoplasm of duodenum', '', 'D132', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2337, 'Benign neoplasm of unspecified part of small intestine', '', 'D1330', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2338, 'Benign neoplasm of other parts of small intestine', '', 'D1339', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2339, 'Benign neoplasm of liver', '', 'D134', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2340, 'Benign neoplasm of extrahepatic bile ducts', '', 'D135', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2341, 'Benign neoplasm of pancreas', '', 'D136', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2342, 'Benign neoplasm of endocrine pancreas', '', 'D137', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2343, 'Benign neoplasm of ill-defined sites within the digestive system', '', 'D139', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2344, 'Benign neoplasm of middle ear, nasal cavity and accessory sinuses', '', 'D140', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2345, 'Benign neoplasm of larynx', '', 'D141', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2346, 'Benign neoplasm of trachea', '', 'D142', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2347, 'Benign neoplasm of unspecified bronchus and lung', '', 'D1430', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2348, 'Benign neoplasm of right bronchus and lung', '', 'D1431', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2349, 'Benign neoplasm of left bronchus and lung', '', 'D1432', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2350, 'Benign neoplasm of respiratory system, unspecified', '', 'D144', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2351, 'Benign neoplasm of thymus', '', 'D150', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2352, 'Benign neoplasm of heart', '', 'D151', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2353, 'Benign neoplasm of mediastinum', '', 'D152', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2354, 'Benign neoplasm of other specified intrathoracic organs', '', 'D157', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2355, 'Benign neoplasm of intrathoracic organ, unspecified', '', 'D159', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2356, 'Benign neoplasm of scapula and long bones of unspecified upper limb', '', 'D1600', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2357, 'Benign neoplasm of scapula and long bones of right upper limb', '', 'D1601', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2358, 'Benign neoplasm of scapula and long bones of left upper limb', '', 'D1602', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2359, 'Benign neoplasm of short bones of unspecified upper limb', '', 'D1610', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2360, 'Benign neoplasm of short bones of right upper limb', '', 'D1611', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2361, 'Benign neoplasm of short bones of left upper limb', '', 'D1612', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2362, 'Benign neoplasm of long bones of unspecified lower limb', '', 'D1620', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2363, 'Benign neoplasm of long bones of right lower limb', '', 'D1621', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2364, 'Benign neoplasm of long bones of left lower limb', '', 'D1622', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2365, 'Benign neoplasm of short bones of unspecified lower limb', '', 'D1630', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2366, 'Benign neoplasm of short bones of right lower limb', '', 'D1631', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2367, 'Benign neoplasm of short bones of left lower limb', '', 'D1632', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2368, 'Benign neoplasm of bones of skull and face', '', 'D164', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2369, 'Benign neoplasm of lower jaw bone', '', 'D165', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2370, 'Benign neoplasm of vertebral column', '', 'D166', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2371, 'Benign neoplasm of ribs, sternum and clavicle', '', 'D167', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2372, 'Benign neoplasm of pelvic bones, sacrum and coccyx', '', 'D168', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2373, 'Benign neoplasm of bone and articular cartilage, unspecified', '', 'D169', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2374, 'Benign lipomatous neoplasm of skin and subcutaneous tissue of head, face and neck', '', 'D170', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2375, 'Benign lipomatous neoplasm of skin and subcutaneous tissue of trunk', '', 'D171', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2376, 'Benign lipomatous neoplasm of skin and subcutaneous tissue of unspecified limb', '', 'D1720', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2377, 'Benign lipomatous neoplasm of skin and subcutaneous tissue of right arm', '', 'D1721', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2378, 'Benign lipomatous neoplasm of skin and subcutaneous tissue of left arm', '', 'D1722', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2379, 'Benign lipomatous neoplasm of skin and subcutaneous tissue of right leg', '', 'D1723', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2380, 'Benign lipomatous neoplasm of skin and subcutaneous tissue of left leg', '', 'D1724', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2381, 'Benign lipomatous neoplasm of skin and subcutaneous tissue of unspecified sites', '', 'D1730', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2382, 'Benign lipomatous neoplasm of skin and subcutaneous tissue of other sites', '', 'D1739', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2383, 'Benign lipomatous neoplasm of intrathoracic organs', '', 'D174', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2384, 'Benign lipomatous neoplasm of intra-abdominal organs', '', 'D175', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2385, 'Benign lipomatous neoplasm of spermatic cord', '', 'D176', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2386, 'Benign lipomatous neoplasm of kidney', '', 'D1771', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2387, 'Benign lipomatous neoplasm of other genitourinary organ', '', 'D1772', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2388, 'Benign lipomatous neoplasm of other sites', '', 'D1779', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2389, 'Benign lipomatous neoplasm, unspecified', '', 'D179', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2390, 'Hemangioma unspecified site', '', 'D1800', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2391, 'Hemangioma of skin and subcutaneous tissue', '', 'D1801', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2392, 'Hemangioma of intracranial structures', '', 'D1802', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2393, 'Hemangioma of intra-abdominal structures', '', 'D1803', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2394, 'Hemangioma of other sites', '', 'D1809', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2395, 'Lymphangioma, any site', '', 'D181', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2396, 'Benign neoplasm of mesothelial tissue of pleura', '', 'D190', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2397, 'Benign neoplasm of mesothelial tissue of peritoneum', '', 'D191', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2398, 'Benign neoplasm of mesothelial tissue of other sites', '', 'D197', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2399, 'Benign neoplasm of mesothelial tissue, unspecified', '', 'D199', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2400, 'Benign neoplasm of soft tissue of retroperitoneum', '', 'D200', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2401, 'Benign neoplasm of soft tissue of peritoneum', '', 'D201', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2402, 'Benign neoplasm of connective and other soft tissue of head, face and neck', '', 'D210', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2403, 'Benign neoplasm of connective and other soft tissue of unspecified upper limb, including\nshoulder', '', 'D2110', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2404, 'Benign neoplasm of connective and other soft tissue of right upper limb, including shoulder', '', 'D2111', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2405, 'Benign neoplasm of connective and other soft tissue of left upper limb, including shoulder', '', 'D2112', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2406, 'Benign neoplasm of connective and other soft tissue of unspecified lower limb, including hip', '', 'D2120', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2407, 'Benign neoplasm of connective and other soft tissue of right lower limb, including hip', '', 'D2121', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2408, 'Benign neoplasm of connective and other soft tissue of left lower limb, including hip', '', 'D2122', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2409, 'Benign neoplasm of connective and other soft tissue of thorax', '', 'D213', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1);");

DB::statement("INSERT INTO `symptoms` (`id`, `symptoms_title`, `description`, `code`, `status`, `priority`, `created_at`, `updated_at`, `type`) VALUES
(2410, 'Benign neoplasm of connective and other soft tissue of abdomen', '', 'D214', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2411, 'Benign neoplasm of connective and other soft tissue of pelvis', '', 'D215', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2412, 'Benign neoplasm of connective and other soft tissue of trunk, unspecified', '', 'D216', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2413, 'Benign neoplasm of connective and other soft tissue, unspecified', '', 'D219', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2414, 'Melanocytic nevi of lip', '', 'D220', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2415, 'Melanocytic nevi of unspecified eyelid, including canthus', '', 'D2210', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2416, 'Melanocytic nevi of right eyelid, including canthus', '', 'D2211', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2417, 'Melanocytic nevi of left eyelid, including canthus', '', 'D2212', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2418, 'Melanocytic nevi of unspecified ear and external auricular canal', '', 'D2220', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2419, 'Melanocytic nevi of right ear and external auricular canal', '', 'D2221', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2420, 'Melanocytic nevi of left ear and external auricular canal', '', 'D2222', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2421, 'Melanocytic nevi of unspecified part of face', '', 'D2230', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2422, 'Melanocytic nevi of other parts of face', '', 'D2239', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2423, 'Melanocytic nevi of scalp and neck', '', 'D224', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2424, 'Melanocytic nevi of trunk', '', 'D225', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2425, 'Melanocytic nevi of unspecified upper limb, including shoulder', '', 'D2260', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2426, 'Melanocytic nevi of right upper limb, including shoulder', '', 'D2261', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2427, 'Melanocytic nevi of left upper limb, including shoulder', '', 'D2262', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2428, 'Melanocytic nevi of unspecified lower limb, including hip', '', 'D2270', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2429, 'Melanocytic nevi of right lower limb, including hip', '', 'D2271', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2430, 'Melanocytic nevi of left lower limb, including hip', '', 'D2272', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2431, 'Melanocytic nevi, unspecified', '', 'D229', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2432, 'Other benign neoplasm of skin of lip', '', 'D230', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2433, 'Other benign neoplasm of skin of unspecified eyelid, including canthus', '', 'D2310', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2434, 'Other benign neoplasm of skin of right eyelid, including canthus', '', 'D2311', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2435, 'Other benign neoplasm of skin of left eyelid, including canthus', '', 'D2312', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2436, 'Other benign neoplasm of skin of unspecified ear and external auricular canal', '', 'D2320', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2437, 'Other benign neoplasm of skin of right ear and external auricular canal', '', 'D2321', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2438, 'Other benign neoplasm of skin of left ear and external auricular canal', '', 'D2322', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2439, 'Other benign neoplasm of skin of unspecified part of face', '', 'D2330', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2440, 'Other benign neoplasm of skin of other parts of face', '', 'D2339', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2441, 'Other benign neoplasm of skin of scalp and neck', '', 'D234', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2442, 'Other benign neoplasm of skin of trunk', '', 'D235', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2443, 'Other benign neoplasm of skin of unspecified upper limb, including shoulder', '', 'D2360', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2444, 'Other benign neoplasm of skin of right upper limb, including shoulder', '', 'D2361', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2445, 'Other benign neoplasm of skin of left upper limb, including shoulder', '', 'D2362', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2446, 'Other benign neoplasm of skin of unspecified lower limb, including hip', '', 'D2370', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2447, 'Other benign neoplasm of skin of right lower limb, including hip', '', 'D2371', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2448, 'Other benign neoplasm of skin of left lower limb, including hip', '', 'D2372', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2449, 'Other benign neoplasm of skin, unspecified', '', 'D239', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2450, 'Benign neoplasm of right breast', '', 'D241', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2451, 'Benign neoplasm of left breast', '', 'D242', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2452, 'Benign neoplasm of unspecified breast', '', 'D249', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2453, 'Submucous leiomyoma of uterus', '', 'D250', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2454, 'Intramural leiomyoma of uterus', '', 'D251', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2455, 'Subserosal leiomyoma of uterus', '', 'D252', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2456, 'Leiomyoma of uterus, unspecified', '', 'D259', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2457, 'Other benign neoplasm of cervix uteri', '', 'D260', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2458, 'Other benign neoplasm of corpus uteri', '', 'D261', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2459, 'Other benign neoplasm of other parts of uterus', '', 'D267', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2460, 'Other benign neoplasm of uterus, unspecified', '', 'D269', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2461, 'Benign neoplasm of right ovary', '', 'D270', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2462, 'Benign neoplasm of left ovary', '', 'D271', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2463, 'Benign neoplasm of unspecified ovary', '', 'D279', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2464, 'Benign neoplasm of vulva', '', 'D280', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2465, 'Benign neoplasm of vagina', '', 'D281', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2466, 'Benign neoplasm of uterine tubes and ligaments', '', 'D282', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2467, 'Benign neoplasm of other specified female genital organs', '', 'D287', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2468, 'Benign neoplasm of female genital organ, unspecified', '', 'D289', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2469, 'Benign neoplasm of penis', '', 'D290', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2470, 'Benign neoplasm of prostate', '', 'D291', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2471, 'Benign neoplasm of unspecified testis', '', 'D2920', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2472, 'Benign neoplasm of right testis', '', 'D2921', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2473, 'Benign neoplasm of left testis', '', 'D2922', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2474, 'Benign neoplasm of unspecified epididymis', '', 'D2930', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2475, 'Benign neoplasm of right epididymis', '', 'D2931', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2476, 'Benign neoplasm of left epididymis', '', 'D2932', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2477, 'Benign neoplasm of scrotum', '', 'D294', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2478, 'Benign neoplasm of other specified male genital organs', '', 'D298', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2479, 'Benign neoplasm of male genital organ, unspecified', '', 'D299', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2480, 'Benign neoplasm of unspecified kidney', '', 'D3000', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2481, 'Benign neoplasm of right kidney', '', 'D3001', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2482, 'Benign neoplasm of left kidney', '', 'D3002', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2483, 'Benign neoplasm of unspecified renal pelvis', '', 'D3010', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2484, 'Benign neoplasm of right renal pelvis', '', 'D3011', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2485, 'Benign neoplasm of left renal pelvis', '', 'D3012', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2486, 'Benign neoplasm of unspecified ureter', '', 'D3020', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2487, 'Benign neoplasm of right ureter', '', 'D3021', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2488, 'Benign neoplasm of left ureter', '', 'D3022', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2489, 'Benign neoplasm of bladder', '', 'D303', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2490, 'Benign neoplasm of urethra', '', 'D304', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2491, 'Benign neoplasm of other specified urinary organs', '', 'D308', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2492, 'Benign neoplasm of urinary organ, unspecified', '', 'D309', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2493, 'Benign neoplasm of unspecified conjunctiva', '', 'D3100', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2494, 'Benign neoplasm of right conjunctiva', '', 'D3101', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2495, 'Benign neoplasm of left conjunctiva', '', 'D3102', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2496, 'Benign neoplasm of unspecified cornea', '', 'D3110', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2497, 'Benign neoplasm of right cornea', '', 'D3111', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2498, 'Benign neoplasm of left cornea', '', 'D3112', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2499, 'Benign neoplasm of unspecified retina', '', 'D3120', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2500, 'Benign neoplasm of right retina', '', 'D3121', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2501, 'Benign neoplasm of left retina', '', 'D3122', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2502, 'Benign neoplasm of unspecified choroid', '', 'D3130', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2503, 'Benign neoplasm of right choroid', '', 'D3131', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2504, 'Benign neoplasm of left choroid', '', 'D3132', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2505, 'Benign neoplasm of unspecified ciliary body', '', 'D3140', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2506, 'Benign neoplasm of right ciliary body', '', 'D3141', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2507, 'Benign neoplasm of left ciliary body', '', 'D3142', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2508, 'Benign neoplasm of unspecified lacrimal gland and duct', '', 'D3150', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2509, 'Benign neoplasm of right lacrimal gland and duct', '', 'D3151', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2510, 'Benign neoplasm of left lacrimal gland and duct', '', 'D3152', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2511, 'Benign neoplasm of unspecified site of unspecified orbit', '', 'D3160', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2512, 'Benign neoplasm of unspecified site of right orbit', '', 'D3161', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2513, 'Benign neoplasm of unspecified site of left orbit', '', 'D3162', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2514, 'Benign neoplasm of unspecified part of unspecified eye', '', 'D3190', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2515, 'Benign neoplasm of unspecified part of right eye', '', 'D3191', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2516, 'Benign neoplasm of unspecified part of left eye', '', 'D3192', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2517, 'Benign neoplasm of cerebral meninges', '', 'D320', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2518, 'Benign neoplasm of spinal meninges', '', 'D321', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2519, 'Benign neoplasm of meninges, unspecified', '', 'D329', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2520, 'Benign neoplasm of brain, supratentorial', '', 'D330', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2521, 'Benign neoplasm of brain, infratentorial', '', 'D331', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2522, 'Benign neoplasm of brain, unspecified', '', 'D332', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2523, 'Benign neoplasm of cranial nerves', '', 'D333', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2524, 'Benign neoplasm of spinal cord', '', 'D334', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2525, 'Benign neoplasm of other specified parts of central nervous system', '', 'D337', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2526, 'Benign neoplasm of central nervous system, unspecified', '', 'D339', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2527, 'Benign neoplasm of thyroid gland', '', 'D34', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2528, 'Benign neoplasm of unspecified adrenal gland', '', 'D3500', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2529, 'Benign neoplasm of right adrenal gland', '', 'D3501', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2530, 'Benign neoplasm of left adrenal gland', '', 'D3502', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2531, 'Benign neoplasm of parathyroid gland', '', 'D351', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2532, 'Benign neoplasm of pituitary gland', '', 'D352', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2533, 'Benign neoplasm of craniopharyngeal duct', '', 'D353', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2534, 'Benign neoplasm of pineal gland', '', 'D354', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2535, 'Benign neoplasm of carotid body', '', 'D355', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2536, 'Benign neoplasm of aortic body and other paraganglia', '', 'D356', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2537, 'Benign neoplasm of other specified endocrine glands', '', 'D357', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2538, 'Benign neoplasm of endocrine gland, unspecified', '', 'D359', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2539, 'Benign neoplasm of lymph nodes', '', 'D360', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2540, 'Benign neoplasm of peripheral nerves and autonomic nervous system, unspecified', '', 'D3610', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2541, 'Benign neoplasm of peripheral nerves and autonomic nervous system of face, head, and neck', '', 'D3611', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2542, 'Benign neoplasm of peripheral nerves and autonomic nervous system, upper limb, including\nshoulder', '', 'D3612', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2543, 'Benign neoplasm of peripheral nerves and autonomic nervous system of lower limb, including\nhip', '', 'D3613', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2544, 'Benign neoplasm of peripheral nerves and autonomic nervous system of thorax', '', 'D3614', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2545, 'Benign neoplasm of peripheral nerves and autonomic nervous system of abdomen', '', 'D3615', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2546, 'Benign neoplasm of peripheral nerves and autonomic nervous system of pelvis', '', 'D3616', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2547, 'Benign neoplasm of peripheral nerves and autonomic nervous system of trunk, unspecified', '', 'D3617', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2548, 'Benign neoplasm of other specified sites', '', 'D367', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2549, 'Benign neoplasm, unspecified site', '', 'D369', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2550, 'Benign carcinoid tumor of unspecified site', '', 'D3A00', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2551, 'Benign carcinoid tumor of the duodenum', '', 'D3A010', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2552, 'Benign carcinoid tumor of the jejunum', '', 'D3A011', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2553, 'Benign carcinoid tumor of the ileum', '', 'D3A012', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2554, 'Benign carcinoid tumor of the small intestine, unspecified portion', '', 'D3A019', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2555, 'Benign carcinoid tumor of the appendix', '', 'D3A020', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2556, 'Benign carcinoid tumor of the cecum', '', 'D3A021', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2557, 'Benign carcinoid tumor of the ascending colon', '', 'D3A022', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2558, 'Benign carcinoid tumor of the transverse colon', '', 'D3A023', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2559, 'Benign carcinoid tumor of the descending colon', '', 'D3A024', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2560, 'Benign carcinoid tumor of the sigmoid colon', '', 'D3A025', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2561, 'Benign carcinoid tumor of the rectum', '', 'D3A026', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2562, 'Benign carcinoid tumor of the large intestine, unspecified portion', '', 'D3A029', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2563, 'Benign carcinoid tumor of the bronchus and lung', '', 'D3A090', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2564, 'Benign carcinoid tumor of the thymus', '', 'D3A091', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2565, 'Benign carcinoid tumor of the stomach', '', 'D3A092', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2566, 'Benign carcinoid tumor of the kidney', '', 'D3A093', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2567, 'Benign carcinoid tumor of the foregut, unspecified', '', 'D3A094', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2568, 'Benign carcinoid tumor of the midgut, unspecified', '', 'D3A095', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2569, 'Benign carcinoid tumor of the hindgut, unspecified', '', 'D3A096', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2570, 'Benign carcinoid tumors of other sites', '', 'D3A098', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2571, 'Other benign neuroendocrine tumors', '', 'D3A8', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2572, 'Neoplasm of uncertain behavior of lip', '', 'D3701', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2573, 'Neoplasm of uncertain behavior of tongue', '', 'D3702', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2574, 'Neoplasm of uncertain behavior of the parotid salivary glands', '', 'D37030', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2575, 'Neoplasm of uncertain behavior of the sublingual salivary glands', '', 'D37031', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2576, 'Neoplasm of uncertain behavior of the submandibular salivary glands', '', 'D37032', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2577, 'Neoplasm of uncertain behavior of the major salivary glands, unspecified', '', 'D37039', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2578, 'Neoplasm of uncertain behavior of the minor salivary glands', '', 'D3704', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2579, 'Neoplasm of uncertain behavior of pharynx', '', 'D3705', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2580, 'Neoplasm of uncertain behavior of other specified sites of the oral cavity', '', 'D3709', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2581, 'Neoplasm of uncertain behavior of stomach', '', 'D371', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2582, 'Neoplasm of uncertain behavior of small intestine', '', 'D372', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2583, 'Neoplasm of uncertain behavior of appendix', '', 'D373', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2584, 'Neoplasm of uncertain behavior of colon', '', 'D374', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2585, 'Neoplasm of uncertain behavior of rectum', '', 'D375', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2586, 'Neoplasm of uncertain behavior of liver, gallbladder and bile ducts', '', 'D376', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2587, 'Neoplasm of uncertain behavior of other specified digestive organs', '', 'D378', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2588, 'Neoplasm of uncertain behavior of digestive organ, unspecified', '', 'D379', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2589, 'Neoplasm of uncertain behavior of larynx', '', 'D380', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2590, 'Neoplasm of uncertain behavior of trachea, bronchus and lung', '', 'D381', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2591, 'Neoplasm of uncertain behavior of pleura', '', 'D382', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2592, 'Neoplasm of uncertain behavior of mediastinum', '', 'D383', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2593, 'Neoplasm of uncertain behavior of thymus', '', 'D384', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2594, 'Neoplasm of uncertain behavior of other respiratory organs', '', 'D385', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2595, 'Neoplasm of uncertain behavior of respiratory organ, unspecified', '', 'D386', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2596, 'Neoplasm of uncertain behavior of uterus', '', 'D390', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2597, 'Neoplasm of uncertain behavior of unspecified ovary', '', 'D3910', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2598, 'Neoplasm of uncertain behavior of right ovary', '', 'D3911', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2599, 'Neoplasm of uncertain behavior of left ovary', '', 'D3912', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2600, 'Neoplasm of uncertain behavior of placenta', '', 'D392', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2601, 'Neoplasm of uncertain behavior of other specified female genital organs', '', 'D398', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2602, 'Neoplasm of uncertain behavior of female genital organ, unspecified', '', 'D399', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2603, 'Neoplasm of uncertain behavior of prostate', '', 'D400', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2604, 'Neoplasm of uncertain behavior of unspecified testis', '', 'D4010', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2605, 'Neoplasm of uncertain behavior of right testis', '', 'D4011', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2606, 'Neoplasm of uncertain behavior of left testis', '', 'D4012', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2607, 'Neoplasm of uncertain behavior of other specified male genital organs', '', 'D408', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2608, 'Neoplasm of uncertain behavior of male genital organ, unspecified', '', 'D409', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2609, 'Neoplasm of uncertain behavior of unspecified kidney', '', 'D4100', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2610, 'Neoplasm of uncertain behavior of right kidney', '', 'D4101', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2611, 'Neoplasm of uncertain behavior of left kidney', '', 'D4102', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2612, 'Neoplasm of uncertain behavior of unspecified renal pelvis', '', 'D4110', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2613, 'Neoplasm of uncertain behavior of right renal pelvis', '', 'D4111', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2614, 'Neoplasm of uncertain behavior of left renal pelvis', '', 'D4112', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2615, 'Neoplasm of uncertain behavior of unspecified ureter', '', 'D4120', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2616, 'Neoplasm of uncertain behavior of right ureter', '', 'D4121', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2617, 'Neoplasm of uncertain behavior of left ureter', '', 'D4122', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2618, 'Neoplasm of uncertain behavior of urethra', '', 'D413', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2619, 'Neoplasm of uncertain behavior of bladder', '', 'D414', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2620, 'Neoplasm of uncertain behavior of other specified urinary organs', '', 'D418', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2621, 'Neoplasm of uncertain behavior of unspecified urinary organ', '', 'D419', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2622, 'Neoplasm of uncertain behavior of cerebral meninges', '', 'D420', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2623, 'Neoplasm of uncertain behavior of spinal meninges', '', 'D421', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2624, 'Neoplasm of uncertain behavior of meninges, unspecified', '', 'D429', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2625, 'Neoplasm of uncertain behavior of brain, supratentorial', '', 'D430', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2626, 'Neoplasm of uncertain behavior of brain, infratentorial', '', 'D431', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2627, 'Neoplasm of uncertain behavior of brain, unspecified', '', 'D432', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2628, 'Neoplasm of uncertain behavior of cranial nerves', '', 'D433', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2629, 'Neoplasm of uncertain behavior of spinal cord', '', 'D434', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2630, 'Neoplasm of uncertain behavior of other specified parts of central nervous system', '', 'D438', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2631, 'Neoplasm of uncertain behavior of central nervous system, unspecified', '', 'D439', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2632, 'Neoplasm of uncertain behavior of thyroid gland', '', 'D440', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2633, 'Neoplasm of uncertain behavior of unspecified adrenal gland', '', 'D4410', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2634, 'Neoplasm of uncertain behavior of right adrenal gland', '', 'D4411', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2635, 'Neoplasm of uncertain behavior of left adrenal gland', '', 'D4412', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2636, 'Neoplasm of uncertain behavior of parathyroid gland', '', 'D442', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2637, 'Neoplasm of uncertain behavior of pituitary gland', '', 'D443', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2638, 'Neoplasm of uncertain behavior of craniopharyngeal duct', '', 'D444', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2639, 'Neoplasm of uncertain behavior of pineal gland', '', 'D445', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2640, 'Neoplasm of uncertain behavior of carotid body', '', 'D446', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2641, 'Neoplasm of uncertain behavior of aortic body and other paraganglia', '', 'D447', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2642, 'Neoplasm of uncertain behavior of unspecified endocrine gland', '', 'D449', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2643, 'Polycythemia vera', '', 'D45', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2644, 'Refractory anemia without ring sideroblasts, so stated', '', 'D460', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2645, 'Refractory anemia with ring sideroblasts', '', 'D461', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2646, 'Refractory anemia with excess of blasts, unspecified', '', 'D4620', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2647, 'Refractory anemia with excess of blasts 1', '', 'D4621', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2648, 'Refractory anemia with excess of blasts 2', '', 'D4622', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2649, 'Refractory cytopenia with multilineage dysplasia', '', 'D46A', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2650, 'Refractory cytopenia with multilineage dysplasia and ring sideroblasts', '', 'D46B', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2651, 'Myelodysplastic syndrome with isolated del(5q) chromosomal abnormality', '', 'D46C', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2652, 'Refractory anemia, unspecified', '', 'D464', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2653, 'Other myelodysplastic syndromes', '', 'D46Z', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2654, 'Myelodysplastic syndrome, unspecified', '', 'D469', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2655, 'Histiocytic and mast cell tumors of uncertain behavior', '', 'D470', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2656, 'Chronic myeloproliferative disease', '', 'D471', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2657, 'Monoclonal gammopathy', '', 'D472', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2658, 'Essential (hemorrhagic) thrombocythemia', '', 'D473', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2659, 'Osteomyelofibrosis', '', 'D474', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2660, 'Post-transplant lymphoproliferative disorder (PTLD)', '', 'D47Z1', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2661, 'Castleman disease', '', 'D47Z2', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2662, 'Other specified neoplasms of uncertain behavior of lymphoid, hematopoietic and related tissue', '', 'D47Z9', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2663, 'Neoplasm of uncertain behavior of lymphoid, hematopoietic and related tissue, unspecified', '', 'D479', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2664, 'Neoplasm of uncertain behavior of bone and articular cartilage', '', 'D480', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2665, 'Neoplasm of uncertain behavior of connective and other soft tissue', '', 'D481', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2666, 'Neoplasm of uncertain behavior of peripheral nerves and autonomic nervous system', '', 'D482', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2667, 'Neoplasm of uncertain behavior of retroperitoneum', '', 'D483', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2668, 'Neoplasm of uncertain behavior of peritoneum', '', 'D484', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2669, 'Neoplasm of uncertain behavior of skin', '', 'D485', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2670, 'Neoplasm of uncertain behavior of unspecified breast', '', 'D4860', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2671, 'Neoplasm of uncertain behavior of right breast', '', 'D4861', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2672, 'Neoplasm of uncertain behavior of left breast', '', 'D4862', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2673, 'Neoplasm of uncertain behavior of other specified sites', '', 'D487', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2674, 'Neoplasm of uncertain behavior, unspecified', '', 'D489', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2675, 'Neoplasm of unspecified behavior of digestive system', '', 'D490', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2676, 'Neoplasm of unspecified behavior of respiratory system', '', 'D491', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2677, 'Neoplasm of unspecified behavior of bone, soft tissue, and skin', '', 'D492', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2678, 'Neoplasm of unspecified behavior of breast', '', 'D493', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2679, 'Neoplasm of unspecified behavior of bladder', '', 'D494', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2680, 'Neoplasm of unspecified behavior of right kidney', '', 'D49511', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2681, 'Neoplasm of unspecified behavior of left kidney', '', 'D49512', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2682, 'Neoplasm of unspecified behavior of unspecified kidney', '', 'D49519', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2683, 'Neoplasm of unspecified behavior of other genitourinary organ', '', 'D4959', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2684, 'Neoplasm of unspecified behavior of brain', '', 'D496', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2685, 'Neoplasm of unspecified behavior of endocrine glands and other parts of nervous system', '', 'D497', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2686, 'Neoplasm of unspecified behavior of retina and choroid', '', 'D4981', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2687, 'Neoplasm of unspecified behavior of other specified sites', '', 'D4989', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2688, 'Neoplasm of unspecified behavior of unspecified site', '', 'D499', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2689, 'Iron deficiency anemia secondary to blood loss (chronic)', '', 'D500', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2690, 'Sideropenic dysphagia', '', 'D501', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2691, 'Other iron deficiency anemias', '', 'D508', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2692, 'Iron deficiency anemia, unspecified', '', 'D509', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2693, 'Vitamin B12 deficiency anemia due to intrinsic factor deficiency', '', 'D510', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2694, 'Vitamin B12 deficiency anemia due to selective vitamin B12 malabsorption with proteinuria', '', 'D511', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2695, 'Transcobalamin II deficiency', '', 'D512', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2696, 'Other dietary vitamin B12 deficiency anemia', '', 'D513', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2697, 'Other vitamin B12 deficiency anemias', '', 'D518', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2698, 'Vitamin B12 deficiency anemia, unspecified', '', 'D519', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2699, 'Dietary folate deficiency anemia', '', 'D520', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2700, 'Drug-induced folate deficiency anemia', '', 'D521', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2701, 'Other folate deficiency anemias', '', 'D528', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2702, 'Folate deficiency anemia, unspecified', '', 'D529', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2703, 'Protein deficiency anemia', '', 'D530', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2704, 'Other megaloblastic anemias, not elsewhere classified', '', 'D531', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2705, 'Scorbutic anemia', '', 'D532', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2706, 'Other specified nutritional anemias', '', 'D538', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2707, 'Nutritional anemia, unspecified', '', 'D539', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2708, 'Anemia due to glucose-6-phosphate dehydrogenase [G6PD] deficiency', '', 'D550', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2709, 'Anemia due to other disorders of glutathione metabolism', '', 'D551', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2710, 'Anemia due to disorders of glycolytic enzymes', '', 'D552', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2711, 'Anemia due to disorders of nucleotide metabolism', '', 'D553', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2712, 'Other anemias due to enzyme disorders', '', 'D558', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2713, 'Anemia due to enzyme disorder, unspecified', '', 'D559', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2714, 'Alpha thalassemia', '', 'D560', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2715, 'Beta thalassemia', '', 'D561', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2716, 'Delta-beta thalassemia', '', 'D562', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2717, 'Thalassemia minor', '', 'D563', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2718, 'Hereditary persistence of fetal hemoglobin [HPFH]', '', 'D564', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2719, 'Hemoglobin E-beta thalassemia', '', 'D565', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2720, 'Other thalassemias', '', 'D568', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2721, 'Thalassemia, unspecified', '', 'D569', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2722, 'Hb-SS disease with crisis, unspecified', '', 'D5700', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2723, 'Hb-SS disease with acute chest syndrome', '', 'D5701', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2724, 'Hb-SS disease with splenic sequestration', '', 'D5702', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2725, 'Sickle-cell disease without crisis', '', 'D571', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2726, 'Sickle-cell/Hb-C disease without crisis', '', 'D5720', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2727, 'Sickle-cell/Hb-C disease with acute chest syndrome', '', 'D57211', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2728, 'Sickle-cell/Hb-C disease with splenic sequestration', '', 'D57212', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2729, 'Sickle-cell/Hb-C disease with crisis, unspecified', '', 'D57219', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2730, 'Sickle-cell trait', '', 'D573', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2731, 'Sickle-cell thalassemia without crisis', '', 'D5740', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2732, 'Sickle-cell thalassemia with acute chest syndrome', '', 'D57411', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2733, 'Sickle-cell thalassemia with splenic sequestration', '', 'D57412', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2734, 'Sickle-cell thalassemia with crisis, unspecified', '', 'D57419', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2735, 'Other sickle-cell disorders without crisis', '', 'D5780', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2736, 'Other sickle-cell disorders with acute chest syndrome', '', 'D57811', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2737, 'Other sickle-cell disorders with splenic sequestration', '', 'D57812', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2738, 'Other sickle-cell disorders with crisis, unspecified', '', 'D57819', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2739, 'Hereditary spherocytosis', '', 'D580', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2740, 'Hereditary elliptocytosis', '', 'D581', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2741, 'Other hemoglobinopathies', '', 'D582', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2742, 'Other specified hereditary hemolytic anemias', '', 'D588', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2743, 'Hereditary hemolytic anemia, unspecified', '', 'D589', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2744, 'Drug-induced autoimmune hemolytic anemia', '', 'D590', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2745, 'Other autoimmune hemolytic anemias', '', 'D591', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2746, 'Drug-induced nonautoimmune hemolytic anemia', '', 'D592', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2747, 'Hemolytic-uremic syndrome', '', 'D593', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2748, 'Other nonautoimmune hemolytic anemias', '', 'D594', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2749, 'Paroxysmal nocturnal hemoglobinuria [Marchiafava-Micheli]', '', 'D595', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2750, 'Hemoglobinuria due to hemolysis from other external causes', '', 'D596', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2751, 'Other acquired hemolytic anemias', '', 'D598', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2752, 'Acquired hemolytic anemia, unspecified', '', 'D599', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2753, 'Chronic acquired pure red cell aplasia', '', 'D600', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2754, 'Transient acquired pure red cell aplasia', '', 'D601', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2755, 'Other acquired pure red cell aplasias', '', 'D608', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2756, 'Acquired pure red cell aplasia, unspecified', '', 'D609', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2757, 'Constitutional (pure) red blood cell aplasia', '', 'D6101', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2758, 'Other constitutional aplastic anemia', '', 'D6109', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2759, 'Drug-induced aplastic anemia', '', 'D611', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2760, 'Aplastic anemia due to other external agents', '', 'D612', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2761, 'Idiopathic aplastic anemia', '', 'D613', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2762, 'Antineoplastic chemotherapy induced pancytopenia', '', 'D61810', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2763, 'Other drug-induced pancytopenia', '', 'D61811', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2764, 'Other pancytopenia', '', 'D61818', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2765, 'Myelophthisis', '', 'D6182', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2766, 'Other specified aplastic anemias and other bone marrow failure syndromes', '', 'D6189', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2767, 'Aplastic anemia, unspecified', '', 'D619', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2768, 'Acute posthemorrhagic anemia', '', 'D62', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2769, 'Anemia in neoplastic disease', '', 'D630', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2770, 'Anemia in chronic kidney disease', '', 'D631', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2771, 'Anemia in other chronic diseases classified elsewhere', '', 'D638', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2772, 'Hereditary sideroblastic anemia', '', 'D640', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2773, 'Secondary sideroblastic anemia due to disease', '', 'D641', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2774, 'Secondary sideroblastic anemia due to drugs and toxins', '', 'D642', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2775, 'Other sideroblastic anemias', '', 'D643', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2776, 'Congenital dyserythropoietic anemia', '', 'D644', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2777, 'Anemia due to antineoplastic chemotherapy', '', 'D6481', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2778, 'Other specified anemias', '', 'D6489', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2779, 'Anemia, unspecified', '', 'D649', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2780, 'Disseminated intravascular coagulation [defibrination syndrome]', '', 'D65', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2781, 'Hereditary factor VIII deficiency', '', 'D66', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2782, 'Hereditary factor IX deficiency', '', 'D67', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2783, 'Von Willebrand\'s disease', '', 'D680', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2784, 'Hereditary factor XI deficiency', '', 'D681', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2785, 'Hereditary deficiency of other clotting factors', '', 'D682', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2786, 'Acquired hemophilia', '', 'D68311', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2787, 'Antiphospholipid antibody with hemorrhagic disorder', '', 'D68312', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2788, 'Other hemorrhagic disorder due to intrinsic circulating anticoagulants, antibodies, or inhibitors', '', 'D68318', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2789, 'Hemorrhagic disorder due to extrinsic circulating anticoagulants', '', 'D6832', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2790, 'Acquired coagulation factor deficiency', '', 'D684', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2791, 'Activated protein C resistance', '', 'D6851', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2792, 'Prothrombin gene mutation', '', 'D6852', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2793, 'Other primary thrombophilia', '', 'D6859', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2794, 'Antiphospholipid syndrome', '', 'D6861', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2795, 'Lupus anticoagulant syndrome', '', 'D6862', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2796, 'Other thrombophilia', '', 'D6869', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2797, 'Other specified coagulation defects', '', 'D688', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2798, 'Coagulation defect, unspecified', '', 'D689', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2799, 'Allergic purpura', '', 'D690', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2800, 'Qualitative platelet defects', '', 'D691', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2801, 'Other nonthrombocytopenic purpura', '', 'D692', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2802, 'Immune thrombocytopenic purpura', '', 'D693', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2803, 'Evans syndrome', '', 'D6941', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2804, 'Congenital and hereditary thrombocytopenia purpura', '', 'D6942', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2805, 'Other primary thrombocytopenia', '', 'D6949', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2806, 'Posttransfusion purpura', '', 'D6951', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2807, 'Other secondary thrombocytopenia', '', 'D6959', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1);");




DB::statement("INSERT INTO `symptoms` (`id`, `symptoms_title`, `description`, `code`, `status`, `priority`, `created_at`, `updated_at`, `type`) VALUES
(2808, 'Thrombocytopenia, unspecified', '', 'D696', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2809, 'Other specified hemorrhagic conditions', '', 'D698', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2810, 'Hemorrhagic condition, unspecified', '', 'D699', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2811, 'Congenital agranulocytosis', '', 'D700', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2812, 'Agranulocytosis secondary to cancer chemotherapy', '', 'D701', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2813, 'Other drug-induced agranulocytosis', '', 'D702', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2814, 'Neutropenia due to infection', '', 'D703', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2815, 'Cyclic neutropenia', '', 'D704', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2816, 'Other neutropenia', '', 'D708', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2817, 'Neutropenia, unspecified', '', 'D709', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2818, 'Functional disorders of polymorphonuclear neutrophils', '', 'D71', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2819, 'Genetic anomalies of leukocytes', '', 'D720', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2820, 'Eosinophilia', '', 'D721', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2821, 'Lymphocytopenia', '', 'D72810', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2822, 'Other decreased white blood cell count', '', 'D72818', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2823, 'Decreased white blood cell count, unspecified', '', 'D72819', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2824, 'Lymphocytosis (symptomatic)', '', 'D72820', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2825, 'Monocytosis (symptomatic)', '', 'D72821', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2826, 'Plasmacytosis', '', 'D72822', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2827, 'Leukemoid reaction', '', 'D72823', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2828, 'Basophilia', '', 'D72824', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2829, 'Bandemia', '', 'D72825', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2830, 'Other elevated white blood cell count', '', 'D72828', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2831, 'Elevated white blood cell count, unspecified', '', 'D72829', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2832, 'Other specified disorders of white blood cells', '', 'D7289', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2833, 'Disorder of white blood cells, unspecified', '', 'D729', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2834, 'Hyposplenism', '', 'D730', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2835, 'Hypersplenism', '', 'D731', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2836, 'Chronic congestive splenomegaly', '', 'D732', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2837, 'Abscess of spleen', '', 'D733', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2838, 'Cyst of spleen', '', 'D734', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2839, 'Infarction of spleen', '', 'D735', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2840, 'Neutropenic splenomegaly', '', 'D7381', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2841, 'Other diseases of spleen', '', 'D7389', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2842, 'Disease of spleen, unspecified', '', 'D739', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2843, 'Congenital methemoglobinemia', '', 'D740', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2844, 'Other methemoglobinemias', '', 'D748', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2845, 'Methemoglobinemia, unspecified', '', 'D749', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2846, 'Familial erythrocytosis', '', 'D750', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2847, 'Secondary polycythemia', '', 'D751', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2848, 'Myelofibrosis', '', 'D7581', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2849, 'Heparin induced thrombocytopenia (HIT)', '', 'D7582', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2850, 'Other specified diseases of blood and blood-forming organs', '', 'D7589', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2851, 'Disease of blood and blood-forming organs, unspecified', '', 'D759', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2852, 'Hemophagocytic lymphohistiocytosis', '', 'D761', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2853, 'Hemophagocytic syndrome, infection-associated', '', 'D762', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2854, 'Other histiocytosis syndromes', '', 'D763', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2855, 'Other disorders of blood and blood-forming organs in diseases classified elsewhere', '', 'D77', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2856, 'Intraoperative hemorrhage and hematoma of the spleen complicating a procedure on the\nspleen', '', 'D7801', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2857, 'Intraoperative hemorrhage and hematoma of the spleen complicating other procedure', '', 'D7802', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2858, 'Accidental puncture and laceration of the spleen during a procedure on the spleen', '', 'D7811', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2859, 'Accidental puncture and laceration of the spleen during other procedure', '', 'D7812', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2860, 'Postprocedural hemorrhage of the spleen following a procedure on the spleen', '', 'D7821', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2861, 'Postprocedural hemorrhage of the spleen following other procedure', '', 'D7822', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2862, 'Postprocedural hematoma of the spleen following a procedure on the spleen', '', 'D7831', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2863, 'Postprocedural hematoma of the spleen following other procedure', '', 'D7832', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2864, 'Postprocedural seroma of the spleen following a procedure on the spleen', '', 'D7833', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2865, 'Postprocedural seroma of the spleen following other procedure', '', 'D7834', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2866, 'Other intraoperative complications of the spleen', '', 'D7881', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2867, 'Other postprocedural complications of the spleen', '', 'D7889', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2868, 'Hereditary hypogammaglobulinemia', '', 'D800', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2869, 'Nonfamilial hypogammaglobulinemia', '', 'D801', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2870, 'Selective deficiency of immunoglobulin A [IgA]', '', 'D802', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2871, 'Selective deficiency of immunoglobulin G [IgG] subclasses', '', 'D803', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2872, 'Selective deficiency of immunoglobulin M [IgM]', '', 'D804', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2873, 'Immunodeficiency with increased immunoglobulin M [IgM]', '', 'D805', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2874, 'Antibody deficiency with near-normal immunoglobulins or with hyperimmunoglobulinemia', '', 'D806', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2875, 'Transient hypogammaglobulinemia of infancy', '', 'D807', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2876, 'Other immunodeficiencies with predominantly antibody defects', '', 'D808', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2877, 'Immunodeficiency with predominantly antibody defects, unspecified', '', 'D809', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2878, 'Severe combined immunodeficiency [SCID] with reticular dysgenesis', '', 'D810', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2879, 'Severe combined immunodeficiency [SCID] with low T- and B-cell numbers', '', 'D811', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2880, 'Severe combined immunodeficiency [SCID] with low or normal B-cell numbers', '', 'D812', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2881, 'Adenosine deaminase [ADA] deficiency', '', 'D813', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2882, 'Nezelof\'s syndrome', '', 'D814', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2883, 'Purine nucleoside phosphorylase [PNP] deficiency', '', 'D815', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2884, 'Major histocompatibility complex class I deficiency', '', 'D816', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2885, 'Major histocompatibility complex class II deficiency', '', 'D817', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2886, 'Biotinidase deficiency', '', 'D81810', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2887, 'Other biotin-dependent carboxylase deficiency', '', 'D81818', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2888, 'Biotin-dependent carboxylase deficiency, unspecified', '', 'D81819', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2889, 'Other combined immunodeficiencies', '', 'D8189', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2890, 'Combined immunodeficiency, unspecified', '', 'D819', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2891, 'Wiskott-Aldrich syndrome', '', 'D820', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2892, 'Di George\'s syndrome', '', 'D821', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2893, 'Immunodeficiency with short-limbed stature', '', 'D822', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2894, 'Immunodeficiency following hereditary defective response to Epstein-Barr virus', '', 'D823', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2895, 'Hyperimmunoglobulin E [IgE] syndrome', '', 'D824', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2896, 'Immunodeficiency associated with other specified major defects', '', 'D828', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2897, 'Immunodeficiency associated with major defect, unspecified', '', 'D829', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2898, 'Common variable immunodeficiency with predominant abnormalities of B-cell numbers and\nfunction', '', 'D830', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2899, 'Common variable immunodeficiency with predominant immunoregulatory T-cell disorders', '', 'D831', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2900, 'Common variable immunodeficiency with autoantibodies to B- or T-cells', '', 'D832', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2901, 'Other common variable immunodeficiencies', '', 'D838', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2902, 'Common variable immunodeficiency, unspecified', '', 'D839', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2903, 'Lymphocyte function antigen-1 [LFA-1] defect', '', 'D840', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2904, 'Defects in the complement system', '', 'D841', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2905, 'Other specified immunodeficiencies', '', 'D848', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2906, 'Immunodeficiency, unspecified', '', 'D849', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2907, 'Sarcoidosis of lung', '', 'D860', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2908, 'Sarcoidosis of lymph nodes', '', 'D861', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2909, 'Sarcoidosis of lung with sarcoidosis of lymph nodes', '', 'D862', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2910, 'Sarcoidosis of skin', '', 'D863', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2911, 'Sarcoid meningitis', '', 'D8681', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2912, 'Multiple cranial nerve palsies in sarcoidosis', '', 'D8682', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2913, 'Sarcoid iridocyclitis', '', 'D8683', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2914, 'Sarcoid pyelonephritis', '', 'D8684', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2915, 'Sarcoid myocarditis', '', 'D8685', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2916, 'Sarcoid arthropathy', '', 'D8686', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2917, 'Sarcoid myositis', '', 'D8687', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2918, 'Sarcoidosis of other sites', '', 'D8689', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2919, 'Sarcoidosis, unspecified', '', 'D869', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2920, 'Polyclonal hypergammaglobulinemia', '', 'D890', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2921, 'Cryoglobulinemia', '', 'D891', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2922, 'Hypergammaglobulinemia, unspecified', '', 'D892', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2923, 'Immune reconstitution syndrome', '', 'D893', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2924, 'Mast cell activation, unspecified', '', 'D8940', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2925, 'Monoclonal mast cell activation syndrome', '', 'D8941', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2926, 'Idiopathic mast cell activation syndrome', '', 'D8942', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2927, 'Secondary mast cell activation', '', 'D8943', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2928, 'Other mast cell activation disorder', '', 'D8949', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2929, 'Acute graft-versus-host disease', '', 'D89810', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2930, 'Chronic graft-versus-host disease', '', 'D89811', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2931, 'Acute on chronic graft-versus-host disease', '', 'D89812', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2932, 'Graft-versus-host disease, unspecified', '', 'D89813', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2933, 'Autoimmune lymphoproliferative syndrome [ALPS]', '', 'D8982', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2934, 'Other specified disorders involving the immune mechanism, not elsewhere classified', '', 'D8989', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2935, 'Disorder involving the immune mechanism, unspecified', '', 'D899', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2936, 'Congenital iodine-deficiency syndrome, neurological type', '', 'E000', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2937, 'Congenital iodine-deficiency syndrome, myxedematous type', '', 'E001', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2938, 'Congenital iodine-deficiency syndrome, mixed type', '', 'E002', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2939, 'Congenital iodine-deficiency syndrome, unspecified', '', 'E009', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2940, 'Iodine-deficiency related diffuse (endemic) goiter', '', 'E010', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2941, 'Iodine-deficiency related multinodular (endemic) goiter', '', 'E011', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2942, 'Iodine-deficiency related (endemic) goiter, unspecified', '', 'E012', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2943, 'Other iodine-deficiency related thyroid disorders and allied conditions', '', 'E018', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2944, 'Subclinical iodine-deficiency hypothyroidism', '', 'E02', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2945, 'Congenital hypothyroidism with diffuse goiter', '', 'E030', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2946, 'Congenital hypothyroidism without goiter', '', 'E031', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2947, 'Hypothyroidism due to medicaments and other exogenous substances', '', 'E032', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2948, 'Postinfectious hypothyroidism', '', 'E033', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2949, 'Atrophy of thyroid (acquired)', '', 'E034', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2950, 'Myxedema coma', '', 'E035', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2951, 'Other specified hypothyroidism', '', 'E038', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2952, 'Hypothyroidism, unspecified', '', 'E039', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2953, 'Nontoxic diffuse goiter', '', 'E040', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2954, 'Nontoxic single thyroid nodule', '', 'E041', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2955, 'Nontoxic multinodular goiter', '', 'E042', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2956, 'Other specified nontoxic goiter', '', 'E048', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2957, 'Nontoxic goiter, unspecified', '', 'E049', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2958, 'Thyrotoxicosis with diffuse goiter without thyrotoxic crisis or storm', '', 'E0500', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2959, 'Thyrotoxicosis with diffuse goiter with thyrotoxic crisis or storm', '', 'E0501', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2960, 'Thyrotoxicosis with toxic single thyroid nodule without thyrotoxic crisis or storm', '', 'E0510', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2961, 'Thyrotoxicosis with toxic single thyroid nodule with thyrotoxic crisis or storm', '', 'E0511', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2962, 'Thyrotoxicosis with toxic multinodular goiter without thyrotoxic crisis or storm', '', 'E0520', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2963, 'Thyrotoxicosis with toxic multinodular goiter with thyrotoxic crisis or storm', '', 'E0521', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2964, 'Thyrotoxicosis from ectopic thyroid tissue without thyrotoxic crisis or storm', '', 'E0530', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2965, 'Thyrotoxicosis from ectopic thyroid tissue with thyrotoxic crisis or storm', '', 'E0531', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2966, 'Thyrotoxicosis factitia without thyrotoxic crisis or storm', '', 'E0540', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2967, 'Thyrotoxicosis factitia with thyrotoxic crisis or storm', '', 'E0541', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2968, 'Other thyrotoxicosis without thyrotoxic crisis or storm', '', 'E0580', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2969, 'Other thyrotoxicosis with thyrotoxic crisis or storm', '', 'E0581', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2970, 'Thyrotoxicosis, unspecified without thyrotoxic crisis or storm', '', 'E0590', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2971, 'Thyrotoxicosis, unspecified with thyrotoxic crisis or storm', '', 'E0591', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2972, 'Acute thyroiditis', '', 'E060', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2973, 'Subacute thyroiditis', '', 'E061', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2974, 'Chronic thyroiditis with transient thyrotoxicosis', '', 'E062', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2975, 'Autoimmune thyroiditis', '', 'E063', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2976, 'Drug-induced thyroiditis', '', 'E064', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2977, 'Other chronic thyroiditis', '', 'E065', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2978, 'Thyroiditis, unspecified', '', 'E069', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2979, 'Hypersecretion of calcitonin', '', 'E070', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2980, 'Dyshormogenetic goiter', '', 'E071', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2981, 'Sick-euthyroid syndrome', '', 'E0781', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2982, 'Other specified disorders of thyroid', '', 'E0789', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2983, 'Disorder of thyroid, unspecified', '', 'E079', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2984, 'Diabetes mellitus due to underlying condition with hyperosmolarity without nonketotic\nhyperglycemic-hyperosmolar coma (NKHHC)', '', 'E0800', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2985, 'Diabetes mellitus due to underlying condition with hyperosmolarity with coma', '', 'E0801', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2986, 'Diabetes mellitus due to underlying condition with ketoacidosis without coma', '', 'E0810', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2987, 'Diabetes mellitus due to underlying condition with ketoacidosis with coma', '', 'E0811', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2988, 'Diabetes mellitus due to underlying condition with diabetic nephropathy', '', 'E0821', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2989, 'Diabetes mellitus due to underlying condition with diabetic chronic kidney disease', '', 'E0822', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2990, 'Diabetes mellitus due to underlying condition with other diabetic kidney complication', '', 'E0829', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2991, 'Diabetes mellitus due to underlying condition with unspecified diabetic retinopathy with\nmacular edema', '', 'E08311', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2992, 'Diabetes mellitus due to underlying condition with unspecified diabetic retinopathy without\nmacular edema', '', 'E08319', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2993, 'Diabetes mellitus due to underlying condition with mild nonproliferative diabetic retinopathy\nwith macular edema, right eye', '', 'E083211', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2994, 'Diabetes mellitus due to underlying condition with mild nonproliferative diabetic retinopathy\nwith macular edema, left eye', '', 'E083212', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2995, 'Diabetes mellitus due to underlying condition with mild nonproliferative diabetic retinopathy\nwith macular edema, bilateral', '', 'E083213', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2996, 'Diabetes mellitus due to underlying condition with mild nonproliferative diabetic retinopathy\nwith macular edema, unspecified eye', '', 'E083219', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2997, 'Diabetes mellitus due to underlying condition with mild nonproliferative diabetic retinopathy\nwithout macular edema, right eye', '', 'E083291', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2998, 'Diabetes mellitus due to underlying condition with mild nonproliferative diabetic retinopathy\nwithout macular edema, left eye', '', 'E083292', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(2999, 'Diabetes mellitus due to underlying condition with mild nonproliferative diabetic retinopathy\nwithout macular edema, bilateral', '', 'E083293', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3000, 'Diabetes mellitus due to underlying condition with mild nonproliferative diabetic retinopathy\nwithout macular edema, unspecified eye', '', 'E083299', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3001, 'Diabetes mellitus due to underlying condition with moderate nonproliferative diabetic\nretinopathy with macular edema, right eye', '', 'E083311', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3002, 'Diabetes mellitus due to underlying condition with moderate nonproliferative diabetic\nretinopathy with macular edema, left eye', '', 'E083312', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3003, 'Diabetes mellitus due to underlying condition with moderate nonproliferative diabetic\nretinopathy with macular edema, bilateral', '', 'E083313', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3004, 'Diabetes mellitus due to underlying condition with moderate nonproliferative diabetic\nretinopathy with macular edema, unspecified eye', '', 'E083319', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3005, 'Diabetes mellitus due to underlying condition with moderate nonproliferative diabetic\nretinopathy without macular edema, right eye', '', 'E083391', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3006, 'Diabetes mellitus due to underlying condition with moderate nonproliferative diabetic\nretinopathy without macular edema, left eye', '', 'E083392', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3007, 'Diabetes mellitus due to underlying condition with moderate nonproliferative diabetic\nretinopathy without macular edema, bilateral', '', 'E083393', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3008, 'Diabetes mellitus due to underlying condition with moderate nonproliferative diabetic\nretinopathy without macular edema, unspecified eye', '', 'E083399', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3009, 'Diabetes mellitus due to underlying condition with severe nonproliferative diabetic retinopathy\nwith macular edema, right eye', '', 'E083411', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3010, 'Diabetes mellitus due to underlying condition with severe nonproliferative diabetic retinopathy\nwith macular edema, left eye', '', 'E083412', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3011, 'Diabetes mellitus due to underlying condition with severe nonproliferative diabetic retinopathy\nwith macular edema, bilateral', '', 'E083413', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3012, 'Diabetes mellitus due to underlying condition with severe nonproliferative diabetic retinopathy\nwith macular edema, unspecified eye', '', 'E083419', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3013, 'Diabetes mellitus due to underlying condition with severe nonproliferative diabetic retinopathy\nwithout macular edema, right eye', '', 'E083491', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3014, 'Diabetes mellitus due to underlying condition with severe nonproliferative diabetic retinopathy\nwithout macular edema, left eye', '', 'E083492', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3015, 'Diabetes mellitus due to underlying condition with severe nonproliferative diabetic retinopathy\nwithout macular edema, bilateral', '', 'E083493', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3016, 'Diabetes mellitus due to underlying condition with severe nonproliferative diabetic retinopathy\nwithout macular edema, unspecified eye', '', 'E083499', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3017, 'Diabetes mellitus due to underlying condition with proliferative diabetic retinopathy with\nmacular edema, right eye', '', 'E083511', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3018, 'Diabetes mellitus due to underlying condition with proliferative diabetic retinopathy with\nmacular edema, left eye', '', 'E083512', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3019, 'Diabetes mellitus due to underlying condition with proliferative diabetic retinopathy with\nmacular edema, bilateral', '', 'E083513', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3020, 'Diabetes mellitus due to underlying condition with proliferative diabetic retinopathy with\nmacular edema, unspecified eye', '', 'E083519', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3021, 'Diabetes mellitus due to underlying condition with proliferative diabetic retinopathy with\ntraction retinal detachment involving the macula, right eye', '', 'E083521', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3022, 'Diabetes mellitus due to underlying condition with proliferative diabetic retinopathy with\ntraction retinal detachment involving the macula, left eye', '', 'E083522', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3023, 'Diabetes mellitus due to underlying condition with proliferative diabetic retinopathy with\ntraction retinal detachment involving the macula, bilateral', '', 'E083523', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3024, 'Diabetes mellitus due to underlying condition with proliferative diabetic retinopathy with\ntraction retinal detachment involving the macula, unspecified eye', '', 'E083529', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3025, 'Diabetes mellitus due to underlying condition with proliferative diabetic retinopathy with\ntraction retinal detachment not involving the macula, right eye', '', 'E083531', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3026, 'Diabetes mellitus due to underlying condition with proliferative diabetic retinopathy with\ntraction retinal detachment not involving the macula, left eye', '', 'E083532', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3027, 'Diabetes mellitus due to underlying condition with proliferative diabetic retinopathy with\ntraction retinal detachment not involving the macula, bilateral', '', 'E083533', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3028, 'Diabetes mellitus due to underlying condition with proliferative diabetic retinopathy with\ntraction retinal detachment not involving the macula, unspecified eye', '', 'E083539', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3029, 'Diabetes mellitus due to underlying condition with proliferative diabetic retinopathy with\ncombined traction retinal detachment and rhegmatogenous retinal detachment, right eye', '', 'E083541', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3030, 'Diabetes mellitus due to underlying condition with proliferative diabetic retinopathy with\ncombined traction retinal detachment and rhegmatogenous retinal detachment, left eye', '', 'E083542', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3031, 'Diabetes mellitus due to underlying condition with proliferative diabetic retinopathy with\ncombined traction retinal detachment and rhegmatogenous retinal detachment, bilateral', '', 'E083543', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3032, 'Diabetes mellitus due to underlying condition with proliferative diabetic retinopathy with\ncombined traction retinal detachment and rhegmatogenous retinal detachment, unspecified eye', '', 'E083549', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3033, 'Diabetes mellitus due to underlying condition with stable proliferative diabetic retinopathy,\nright eye', '', 'E083551', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3034, 'Diabetes mellitus due to underlying condition with stable proliferative diabetic retinopathy, left\neye', '', 'E083552', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3035, 'Diabetes mellitus due to underlying condition with stable proliferative diabetic retinopathy,\nbilateral', '', 'E083553', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3036, 'Diabetes mellitus due to underlying condition with stable proliferative diabetic retinopathy,\nunspecified eye', '', 'E083559', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3037, 'Diabetes mellitus due to underlying condition with proliferative diabetic retinopathy without\nmacular edema, right eye', '', 'E083591', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3038, 'Diabetes mellitus due to underlying condition with proliferative diabetic retinopathy without\nmacular edema, left eye', '', 'E083592', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3039, 'Diabetes mellitus due to underlying condition with proliferative diabetic retinopathy without\nmacular edema, bilateral', '', 'E083593', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3040, 'Diabetes mellitus due to underlying condition with proliferative diabetic retinopathy without\nmacular edema, unspecified eye', '', 'E083599', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3041, 'Diabetes mellitus due to underlying condition with diabetic cataract', '', 'E0836', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3042, 'Diabetes mellitus due to underlying condition with diabetic macular edema, resolved following\ntreatment, right eye', '', 'E0837X1', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3043, 'Diabetes mellitus due to underlying condition with diabetic macular edema, resolved following\ntreatment, left eye', '', 'E0837X2', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3044, 'Diabetes mellitus due to underlying condition with diabetic macular edema, resolved following\ntreatment, bilateral', '', 'E0837X3', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3045, 'Diabetes mellitus due to underlying condition with diabetic macular edema, resolved following\ntreatment, unspecified eye', '', 'E0837X9', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3046, 'Diabetes mellitus due to underlying condition with other diabetic ophthalmic complication', '', 'E0839', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3047, 'Diabetes mellitus due to underlying condition with diabetic neuropathy, unspecified', '', 'E0840', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3048, 'Diabetes mellitus due to underlying condition with diabetic mononeuropathy', '', 'E0841', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3049, 'Diabetes mellitus due to underlying condition with diabetic polyneuropathy', '', 'E0842', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3050, 'Diabetes mellitus due to underlying condition with diabetic autonomic (poly)neuropathy', '', 'E0843', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3051, 'Diabetes mellitus due to underlying condition with diabetic amyotrophy', '', 'E0844', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3052, 'Diabetes mellitus due to underlying condition with other diabetic neurological complication', '', 'E0849', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3053, 'Diabetes mellitus due to underlying condition with diabetic peripheral angiopathy without\ngangrene', '', 'E0851', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3054, 'Diabetes mellitus due to underlying condition with diabetic peripheral angiopathy with gangrene', '', 'E0852', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3055, 'Diabetes mellitus due to underlying condition with other circulatory complications', '', 'E0859', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3056, 'Diabetes mellitus due to underlying condition with diabetic neuropathic arthropathy', '', 'E08610', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3057, 'Diabetes mellitus due to underlying condition with other diabetic arthropathy', '', 'E08618', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3058, 'Diabetes mellitus due to underlying condition with diabetic dermatitis', '', 'E08620', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3059, 'Diabetes mellitus due to underlying condition with foot ulcer', '', 'E08621', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3060, 'Diabetes mellitus due to underlying condition with other skin ulcer', '', 'E08622', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3061, 'Diabetes mellitus due to underlying condition with other skin complications', '', 'E08628', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3062, 'Diabetes mellitus due to underlying condition with periodontal disease', '', 'E08630', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3063, 'Diabetes mellitus due to underlying condition with other oral complications', '', 'E08638', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3064, 'Diabetes mellitus due to underlying condition with hypoglycemia with coma', '', 'E08641', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3065, 'Diabetes mellitus due to underlying condition with hypoglycemia without coma', '', 'E08649', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3066, 'Diabetes mellitus due to underlying condition with hyperglycemia', '', 'E0865', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3067, 'Diabetes mellitus due to underlying condition with other specified complication', '', 'E0869', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3068, 'Diabetes mellitus due to underlying condition with unspecified complications', '', 'E088', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3069, 'Diabetes mellitus due to underlying condition without complications', '', 'E089', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3070, 'Drug or chemical induced diabetes mellitus with hyperosmolarity without nonketotic\nhyperglycemic-hyperosmolar coma (NKHHC)', '', 'E0900', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3071, 'Drug or chemical induced diabetes mellitus with hyperosmolarity with coma', '', 'E0901', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3072, 'Drug or chemical induced diabetes mellitus with ketoacidosis without coma', '', 'E0910', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3073, 'Drug or chemical induced diabetes mellitus with ketoacidosis with coma', '', 'E0911', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3074, 'Drug or chemical induced diabetes mellitus with diabetic nephropathy', '', 'E0921', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3075, 'Drug or chemical induced diabetes mellitus with diabetic chronic kidney disease', '', 'E0922', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3076, 'Drug or chemical induced diabetes mellitus with other diabetic kidney complication', '', 'E0929', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3077, 'Drug or chemical induced diabetes mellitus with unspecified diabetic retinopathy with macular\nedema', '', 'E09311', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3078, 'Drug or chemical induced diabetes mellitus with unspecified diabetic retinopathy without\nmacular edema', '', 'E09319', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3079, 'Drug or chemical induced diabetes mellitus with mild nonproliferative diabetic retinopathy\nwith macular edema, right eye', '', 'E093211', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3080, 'Drug or chemical induced diabetes mellitus with mild nonproliferative diabetic retinopathy\nwith macular edema, left eye', '', 'E093212', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3081, 'Drug or chemical induced diabetes mellitus with mild nonproliferative diabetic retinopathy\nwith macular edema, bilateral', '', 'E093213', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3082, 'Drug or chemical induced diabetes mellitus with mild nonproliferative diabetic retinopathy\nwith macular edema, unspecified eye', '', 'E093219', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3083, 'Drug or chemical induced diabetes mellitus with mild nonproliferative diabetic retinopathy\nwithout macular edema, right eye', '', 'E093291', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3084, 'Drug or chemical induced diabetes mellitus with mild nonproliferative diabetic retinopathy\nwithout macular edema, left eye', '', 'E093292', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3085, 'Drug or chemical induced diabetes mellitus with mild nonproliferative diabetic retinopathy\nwithout macular edema, bilateral', '', 'E093293', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3086, 'Drug or chemical induced diabetes mellitus with mild nonproliferative diabetic retinopathy\nwithout macular edema, unspecified eye', '', 'E093299', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3087, 'Drug or chemical induced diabetes mellitus with moderate nonproliferative diabetic\nretinopathy with macular edema, right eye', '', 'E093311', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3088, 'Drug or chemical induced diabetes mellitus with moderate nonproliferative diabetic\nretinopathy with macular edema, left eye', '', 'E093312', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3089, 'Drug or chemical induced diabetes mellitus with moderate nonproliferative diabetic\nretinopathy with macular edema, bilateral', '', 'E093313', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3090, 'Drug or chemical induced diabetes mellitus with moderate nonproliferative diabetic\nretinopathy with macular edema, unspecified eye', '', 'E093319', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3091, 'Drug or chemical induced diabetes mellitus with moderate nonproliferative diabetic\nretinopathy without macular edema, right eye', '', 'E093391', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3092, 'Drug or chemical induced diabetes mellitus with moderate nonproliferative diabetic\nretinopathy without macular edema, left eye', '', 'E093392', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3093, 'Drug or chemical induced diabetes mellitus with moderate nonproliferative diabetic\nretinopathy without macular edema, bilateral', '', 'E093393', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3094, 'Drug or chemical induced diabetes mellitus with moderate nonproliferative diabetic\nretinopathy without macular edema, unspecified eye', '', 'E093399', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3095, 'Drug or chemical induced diabetes mellitus with severe nonproliferative diabetic retinopathy\nwith macular edema, right eye', '', 'E093411', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3096, 'Drug or chemical induced diabetes mellitus with severe nonproliferative diabetic retinopathy\nwith macular edema, left eye', '', 'E093412', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3097, 'Drug or chemical induced diabetes mellitus with severe nonproliferative diabetic retinopathy\nwith macular edema, bilateral', '', 'E093413', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3098, 'Drug or chemical induced diabetes mellitus with severe nonproliferative diabetic retinopathy\nwith macular edema, unspecified eye', '', 'E093419', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3099, 'Drug or chemical induced diabetes mellitus with severe nonproliferative diabetic retinopathy\nwithout macular edema, right eye', '', 'E093491', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3100, 'Drug or chemical induced diabetes mellitus with severe nonproliferative diabetic retinopathy\nwithout macular edema, left eye', '', 'E093492', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3101, 'Drug or chemical induced diabetes mellitus with severe nonproliferative diabetic retinopathy\nwithout macular edema, bilateral', '', 'E093493', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3102, 'Drug or chemical induced diabetes mellitus with severe nonproliferative diabetic retinopathy\nwithout macular edema, unspecified eye', '', 'E093499', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3103, 'Drug or chemical induced diabetes mellitus with proliferative diabetic retinopathy with\nmacular edema, right eye', '', 'E093511', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3104, 'Drug or chemical induced diabetes mellitus with proliferative diabetic retinopathy with\nmacular edema, left eye', '', 'E093512', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3105, 'Drug or chemical induced diabetes mellitus with proliferative diabetic retinopathy with\nmacular edema, bilateral', '', 'E093513', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3106, 'Drug or chemical induced diabetes mellitus with proliferative diabetic retinopathy with\nmacular edema, unspecified eye', '', 'E093519', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3107, 'Drug or chemical induced diabetes mellitus with proliferative diabetic retinopathy with traction\nretinal detachment involving the macula, right eye', '', 'E093521', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3108, 'Drug or chemical induced diabetes mellitus with proliferative diabetic retinopathy with traction\nretinal detachment involving the macula, left eye', '', 'E093522', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3109, 'Drug or chemical induced diabetes mellitus with proliferative diabetic retinopathy with traction\nretinal detachment involving the macula, bilateral', '', 'E093523', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3110, 'Drug or chemical induced diabetes mellitus with proliferative diabetic retinopathy with traction\nretinal detachment involving the macula, unspecified eye', '', 'E093529', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3111, 'Drug or chemical induced diabetes mellitus with proliferative diabetic retinopathy with traction\nretinal detachment not involving the macula, right eye', '', 'E093531', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3112, 'Drug or chemical induced diabetes mellitus with proliferative diabetic retinopathy with traction\nretinal detachment not involving the macula, left eye', '', 'E093532', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3113, 'Drug or chemical induced diabetes mellitus with proliferative diabetic retinopathy with traction\nretinal detachment not involving the macula, bilateral', '', 'E093533', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3114, 'Drug or chemical induced diabetes mellitus with proliferative diabetic retinopathy with traction\nretinal detachment not involving the macula, unspecified eye', '', 'E093539', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3115, 'Drug or chemical induced diabetes mellitus with proliferative diabetic retinopathy with\ncombined traction retinal detachment and rhegmatogenous retinal detachment, right eye', '', 'E093541', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3116, 'Drug or chemical induced diabetes mellitus with proliferative diabetic retinopathy with\ncombined traction retinal detachment and rhegmatogenous retinal detachment, left eye', '', 'E093542', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3117, 'Drug or chemical induced diabetes mellitus with proliferative diabetic retinopathy with\ncombined traction retinal detachment and rhegmatogenous retinal detachment, bilateral', '', 'E093543', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3118, 'Drug or chemical induced diabetes mellitus with proliferative diabetic retinopathy with\ncombined traction retinal detachment and rhegmatogenous retinal detachment, unspecified eye', '', 'E093549', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3119, 'Drug or chemical induced diabetes mellitus with stable proliferative diabetic retinopathy, right\neye', '', 'E093551', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3120, 'Drug or chemical induced diabetes mellitus with stable proliferative diabetic retinopathy, left\neye', '', 'E093552', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3121, 'Drug or chemical induced diabetes mellitus with stable proliferative diabetic retinopathy,\nbilateral', '', 'E093553', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3122, 'Drug or chemical induced diabetes mellitus with stable proliferative diabetic retinopathy,\nunspecified eye', '', 'E093559', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3123, 'Drug or chemical induced diabetes mellitus with proliferative diabetic retinopathy without\nmacular edema, right eye', '', 'E093591', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3124, 'Drug or chemical induced diabetes mellitus with proliferative diabetic retinopathy without\nmacular edema, left eye', '', 'E093592', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3125, 'Drug or chemical induced diabetes mellitus with proliferative diabetic retinopathy without\nmacular edema, bilateral', '', 'E093593', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1);");


DB::statement("INSERT INTO `symptoms` (`id`, `symptoms_title`, `description`, `code`, `status`, `priority`, `created_at`, `updated_at`, `type`) VALUES
(3126, 'Drug or chemical induced diabetes mellitus with proliferative diabetic retinopathy without\nmacular edema, unspecified eye', '', 'E093599', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3127, 'Drug or chemical induced diabetes mellitus with diabetic cataract', '', 'E0936', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3128, 'Drug or chemical induced diabetes mellitus with diabetic macular edema, resolved following\ntreatment, right eye', '', 'E0937X1', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3129, 'Drug or chemical induced diabetes mellitus with diabetic macular edema, resolved following\ntreatment, left eye', '', 'E0937X2', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3130, 'Drug or chemical induced diabetes mellitus with diabetic macular edema, resolved following\ntreatment, bilateral', '', 'E0937X3', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3131, 'Drug or chemical induced diabetes mellitus with diabetic macular edema, resolved following\ntreatment, unspecified eye', '', 'E0937X9', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3132, 'Drug or chemical induced diabetes mellitus with other diabetic ophthalmic complication', '', 'E0939', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3133, 'Drug or chemical induced diabetes mellitus with neurological complications with diabetic\nneuropathy, unspecified', '', 'E0940', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3134, 'Drug or chemical induced diabetes mellitus with neurological complications with diabetic\nmononeuropathy', '', 'E0941', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3135, 'Drug or chemical induced diabetes mellitus with neurological complications with diabetic\npolyneuropathy', '', 'E0942', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3136, 'Drug or chemical induced diabetes mellitus with neurological complications with diabetic\nautonomic (poly)neuropathy', '', 'E0943', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3137, 'Drug or chemical induced diabetes mellitus with neurological complications with diabetic\namyotrophy', '', 'E0944', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3138, 'Drug or chemical induced diabetes mellitus with neurological complications with other diabetic\nneurological complication', '', 'E0949', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3139, 'Drug or chemical induced diabetes mellitus with diabetic peripheral angiopathy without\ngangrene', '', 'E0951', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3140, 'Drug or chemical induced diabetes mellitus with diabetic peripheral angiopathy with gangrene', '', 'E0952', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3141, 'Drug or chemical induced diabetes mellitus with other circulatory complications', '', 'E0959', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3142, 'Drug or chemical induced diabetes mellitus with diabetic neuropathic arthropathy', '', 'E09610', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3143, 'Drug or chemical induced diabetes mellitus with other diabetic arthropathy', '', 'E09618', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3144, 'Drug or chemical induced diabetes mellitus with diabetic dermatitis', '', 'E09620', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3145, 'Drug or chemical induced diabetes mellitus with foot ulcer', '', 'E09621', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3146, 'Drug or chemical induced diabetes mellitus with other skin ulcer', '', 'E09622', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3147, 'Drug or chemical induced diabetes mellitus with other skin complications', '', 'E09628', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3148, 'Drug or chemical induced diabetes mellitus with periodontal disease', '', 'E09630', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3149, 'Drug or chemical induced diabetes mellitus with other oral complications', '', 'E09638', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3150, 'Drug or chemical induced diabetes mellitus with hypoglycemia with coma', '', 'E09641', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3151, 'Drug or chemical induced diabetes mellitus with hypoglycemia without coma', '', 'E09649', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3152, 'Drug or chemical induced diabetes mellitus with hyperglycemia', '', 'E0965', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3153, 'Drug or chemical induced diabetes mellitus with other specified complication', '', 'E0969', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3154, 'Drug or chemical induced diabetes mellitus with unspecified complications', '', 'E098', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3155, 'Drug or chemical induced diabetes mellitus without complications', '', 'E099', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3156, 'Type 1 diabetes mellitus with ketoacidosis without coma', '', 'E1010', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3157, 'Type 1 diabetes mellitus with ketoacidosis with coma', '', 'E1011', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3158, 'Type 1 diabetes mellitus with diabetic nephropathy', '', 'E1021', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3159, 'Type 1 diabetes mellitus with diabetic chronic kidney disease', '', 'E1022', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3160, 'Type 1 diabetes mellitus with other diabetic kidney complication', '', 'E1029', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3161, 'Type 1 diabetes mellitus with unspecified diabetic retinopathy with macular edema', '', 'E10311', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3162, 'Type 1 diabetes mellitus with unspecified diabetic retinopathy without macular edema', '', 'E10319', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3163, 'Type 1 diabetes mellitus with mild nonproliferative diabetic retinopathy with macular edema,\nright eye', '', 'E103211', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3164, 'Type 1 diabetes mellitus with mild nonproliferative diabetic retinopathy with macular edema,\nleft eye', '', 'E103212', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3165, 'Type 1 diabetes mellitus with mild nonproliferative diabetic retinopathy with macular edema,\nbilateral', '', 'E103213', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3166, 'Type 1 diabetes mellitus with mild nonproliferative diabetic retinopathy with macular edema,\nunspecified eye', '', 'E103219', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3167, 'Type 1 diabetes mellitus with mild nonproliferative diabetic retinopathy without macular\nedema, right eye', '', 'E103291', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3168, 'Type 1 diabetes mellitus with mild nonproliferative diabetic retinopathy without macular\nedema, left eye', '', 'E103292', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3169, 'Type 1 diabetes mellitus with mild nonproliferative diabetic retinopathy without macular\nedema, bilateral', '', 'E103293', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3170, 'Type 1 diabetes mellitus with mild nonproliferative diabetic retinopathy without macular\nedema, unspecified eye', '', 'E103299', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3171, 'Type 1 diabetes mellitus with moderate nonproliferative diabetic retinopathy with macular\nedema, right eye', '', 'E103311', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3172, 'Type 1 diabetes mellitus with moderate nonproliferative diabetic retinopathy with macular\nedema, left eye', '', 'E103312', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3173, 'Type 1 diabetes mellitus with moderate nonproliferative diabetic retinopathy with macular\nedema, bilateral', '', 'E103313', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3174, 'Type 1 diabetes mellitus with moderate nonproliferative diabetic retinopathy with macular\nedema, unspecified eye', '', 'E103319', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3175, 'Type 1 diabetes mellitus with moderate nonproliferative diabetic retinopathy without macular\nedema, right eye', '', 'E103391', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3176, 'Type 1 diabetes mellitus with moderate nonproliferative diabetic retinopathy without macular\nedema, left eye', '', 'E103392', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3177, 'Type 1 diabetes mellitus with moderate nonproliferative diabetic retinopathy without macular\nedema, bilateral', '', 'E103393', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3178, 'Type 1 diabetes mellitus with moderate nonproliferative diabetic retinopathy without macular\nedema, unspecified eye', '', 'E103399', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3179, 'Type 1 diabetes mellitus with severe nonproliferative diabetic retinopathy with macular\nedema, right eye', '', 'E103411', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3180, 'Type 1 diabetes mellitus with severe nonproliferative diabetic retinopathy with macular\nedema, left eye', '', 'E103412', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3181, 'Type 1 diabetes mellitus with severe nonproliferative diabetic retinopathy with macular\nedema, bilateral', '', 'E103413', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3182, 'Type 1 diabetes mellitus with severe nonproliferative diabetic retinopathy with macular\nedema, unspecified eye', '', 'E103419', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3183, 'Type 1 diabetes mellitus with severe nonproliferative diabetic retinopathy without macular\nedema, right eye', '', 'E103491', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3184, 'Type 1 diabetes mellitus with severe nonproliferative diabetic retinopathy without macular\nedema, left eye', '', 'E103492', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3185, 'Type 1 diabetes mellitus with severe nonproliferative diabetic retinopathy without macular\nedema, bilateral', '', 'E103493', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3186, 'Type 1 diabetes mellitus with severe nonproliferative diabetic retinopathy without macular\nedema, unspecified eye', '', 'E103499', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3187, 'Type 1 diabetes mellitus with proliferative diabetic retinopathy with macular edema, right eye', '', 'E103511', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3188, 'Type 1 diabetes mellitus with proliferative diabetic retinopathy with macular edema, left eye', '', 'E103512', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3189, 'Type 1 diabetes mellitus with proliferative diabetic retinopathy with macular edema, bilateral', '', 'E103513', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3190, 'Type 1 diabetes mellitus with proliferative diabetic retinopathy with macular edema,\nunspecified eye', '', 'E103519', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3191, 'Type 1 diabetes mellitus with proliferative diabetic retinopathy with traction retinal\ndetachment involving the macula, right eye', '', 'E103521', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3192, 'Type 1 diabetes mellitus with proliferative diabetic retinopathy with traction retinal\ndetachment involving the macula, left eye', '', 'E103522', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3193, 'Type 1 diabetes mellitus with proliferative diabetic retinopathy with traction retinal\ndetachment involving the macula, bilateral', '', 'E103523', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3194, 'Type 1 diabetes mellitus with proliferative diabetic retinopathy with traction retinal\ndetachment involving the macula, unspecified eye', '', 'E103529', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3195, 'Type 1 diabetes mellitus with proliferative diabetic retinopathy with traction retinal\ndetachment not involving the macula, right eye', '', 'E103531', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3196, 'Type 1 diabetes mellitus with proliferative diabetic retinopathy with traction retinal\ndetachment not involving the macula, left eye', '', 'E103532', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3197, 'Type 1 diabetes mellitus with proliferative diabetic retinopathy with traction retinal\ndetachment not involving the macula, bilateral', '', 'E103533', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3198, 'Type 1 diabetes mellitus with proliferative diabetic retinopathy with traction retinal\ndetachment not involving the macula, unspecified eye', '', 'E103539', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3199, 'Type 1 diabetes mellitus with proliferative diabetic retinopathy with combined traction retinal\ndetachment and rhegmatogenous retinal detachment, right eye', '', 'E103541', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3200, 'Type 1 diabetes mellitus with proliferative diabetic retinopathy with combined traction retinal\ndetachment and rhegmatogenous retinal detachment, left eye', '', 'E103542', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3201, 'Type 1 diabetes mellitus with proliferative diabetic retinopathy with combined traction retinal\ndetachment and rhegmatogenous retinal detachment, bilateral', '', 'E103543', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3202, 'Type 1 diabetes mellitus with proliferative diabetic retinopathy with combined traction retinal\ndetachment and rhegmatogenous retinal detachment, unspecified eye', '', 'E103549', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3203, 'Type 1 diabetes mellitus with stable proliferative diabetic retinopathy, right eye', '', 'E103551', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3204, 'Type 1 diabetes mellitus with stable proliferative diabetic retinopathy, left eye', '', 'E103552', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3205, 'Type 1 diabetes mellitus with stable proliferative diabetic retinopathy, bilateral', '', 'E103553', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3206, 'Type 1 diabetes mellitus with stable proliferative diabetic retinopathy, unspecified eye', '', 'E103559', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3207, 'Type 1 diabetes mellitus with proliferative diabetic retinopathy without macular edema, right\neye', '', 'E103591', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3208, 'Type 1 diabetes mellitus with proliferative diabetic retinopathy without macular edema, left\neye', '', 'E103592', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3209, 'Type 1 diabetes mellitus with proliferative diabetic retinopathy without macular edema,\nbilateral', '', 'E103593', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3210, 'Type 1 diabetes mellitus with proliferative diabetic retinopathy without macular edema,\nunspecified eye', '', 'E103599', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3211, 'Type 1 diabetes mellitus with diabetic cataract', '', 'E1036', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3212, 'Type 1 diabetes mellitus with diabetic macular edema, resolved following treatment, right eye', '', 'E1037X1', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3213, 'Type 1 diabetes mellitus with diabetic macular edema, resolved following treatment, left eye', '', 'E1037X2', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3214, 'Type 1 diabetes mellitus with diabetic macular edema, resolved following treatment, bilateral', '', 'E1037X3', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3215, 'Type 1 diabetes mellitus with diabetic macular edema, resolved following treatment,\nunspecified eye', '', 'E1037X9', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3216, 'Type 1 diabetes mellitus with other diabetic ophthalmic complication', '', 'E1039', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3217, 'Type 1 diabetes mellitus with diabetic neuropathy, unspecified', '', 'E1040', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3218, 'Type 1 diabetes mellitus with diabetic mononeuropathy', '', 'E1041', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3219, 'Type 1 diabetes mellitus with diabetic polyneuropathy', '', 'E1042', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3220, 'Type 1 diabetes mellitus with diabetic autonomic (poly)neuropathy', '', 'E1043', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3221, 'Type 1 diabetes mellitus with diabetic amyotrophy', '', 'E1044', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3222, 'Type 1 diabetes mellitus with other diabetic neurological complication', '', 'E1049', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3223, 'Type 1 diabetes mellitus with diabetic peripheral angiopathy without gangrene', '', 'E1051', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3224, 'Type 1 diabetes mellitus with diabetic peripheral angiopathy with gangrene', '', 'E1052', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3225, 'Type 1 diabetes mellitus with other circulatory complications', '', 'E1059', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3226, 'Type 1 diabetes mellitus with diabetic neuropathic arthropathy', '', 'E10610', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3227, 'Type 1 diabetes mellitus with other diabetic arthropathy', '', 'E10618', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3228, 'Type 1 diabetes mellitus with diabetic dermatitis', '', 'E10620', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3229, 'Type 1 diabetes mellitus with foot ulcer', '', 'E10621', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3230, 'Type 1 diabetes mellitus with other skin ulcer', '', 'E10622', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3231, 'Type 1 diabetes mellitus with other skin complications', '', 'E10628', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3232, 'Type 1 diabetes mellitus with periodontal disease', '', 'E10630', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3233, 'Type 1 diabetes mellitus with other oral complications', '', 'E10638', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3234, 'Type 1 diabetes mellitus with hypoglycemia with coma', '', 'E10641', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3235, 'Type 1 diabetes mellitus with hypoglycemia without coma', '', 'E10649', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3236, 'Type 1 diabetes mellitus with hyperglycemia', '', 'E1065', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3237, 'Type 1 diabetes mellitus with other specified complication', '', 'E1069', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3238, 'Type 1 diabetes mellitus with unspecified complications', '', 'E108', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3239, 'Type 1 diabetes mellitus without complications', '', 'E109', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3240, 'Type 2 diabetes mellitus with hyperosmolarity without nonketotic hyperglycemic-hyperosmolar\ncoma (NKHHC)', '', 'E1100', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3241, 'Type 2 diabetes mellitus with hyperosmolarity with coma', '', 'E1101', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3242, 'Type 2 diabetes mellitus with diabetic nephropathy', '', 'E1121', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3243, 'Type 2 diabetes mellitus with diabetic chronic kidney disease', '', 'E1122', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3244, 'Type 2 diabetes mellitus with other diabetic kidney complication', '', 'E1129', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3245, 'Type 2 diabetes mellitus with unspecified diabetic retinopathy with macular edema', '', 'E11311', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3246, 'Type 2 diabetes mellitus with unspecified diabetic retinopathy without macular edema', '', 'E11319', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3247, 'Type 2 diabetes mellitus with mild nonproliferative diabetic retinopathy with macular edema,\nright eye', '', 'E113211', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3248, 'Type 2 diabetes mellitus with mild nonproliferative diabetic retinopathy with macular edema,\nleft eye', '', 'E113212', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3249, 'Type 2 diabetes mellitus with mild nonproliferative diabetic retinopathy with macular edema,\nbilateral', '', 'E113213', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3250, 'Type 2 diabetes mellitus with mild nonproliferative diabetic retinopathy with macular edema,\nunspecified eye', '', 'E113219', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3251, 'Type 2 diabetes mellitus with mild nonproliferative diabetic retinopathy without macular\nedema, right eye', '', 'E113291', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3252, 'Type 2 diabetes mellitus with mild nonproliferative diabetic retinopathy without macular\nedema, left eye', '', 'E113292', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3253, 'Type 2 diabetes mellitus with mild nonproliferative diabetic retinopathy without macular\nedema, bilateral', '', 'E113293', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3254, 'Type 2 diabetes mellitus with mild nonproliferative diabetic retinopathy without macular\nedema, unspecified eye', '', 'E113299', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3255, 'Type 2 diabetes mellitus with moderate nonproliferative diabetic retinopathy with macular\nedema, right eye', '', 'E113311', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3256, 'Type 2 diabetes mellitus with moderate nonproliferative diabetic retinopathy with macular\nedema, left eye', '', 'E113312', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3257, 'Type 2 diabetes mellitus with moderate nonproliferative diabetic retinopathy with macular\nedema, bilateral', '', 'E113313', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3258, 'Type 2 diabetes mellitus with moderate nonproliferative diabetic retinopathy with macular\nedema, unspecified eye', '', 'E113319', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3259, 'Type 2 diabetes mellitus with moderate nonproliferative diabetic retinopathy without macular\nedema, right eye', '', 'E113391', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3260, 'Type 2 diabetes mellitus with moderate nonproliferative diabetic retinopathy without macular\nedema, left eye', '', 'E113392', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3261, 'Type 2 diabetes mellitus with moderate nonproliferative diabetic retinopathy without macular\nedema, bilateral', '', 'E113393', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3262, 'Type 2 diabetes mellitus with moderate nonproliferative diabetic retinopathy without macular\nedema, unspecified eye', '', 'E113399', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3263, 'Type 2 diabetes mellitus with severe nonproliferative diabetic retinopathy with macular\nedema, right eye', '', 'E113411', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3264, 'Type 2 diabetes mellitus with severe nonproliferative diabetic retinopathy with macular\nedema, left eye', '', 'E113412', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3265, 'Type 2 diabetes mellitus with severe nonproliferative diabetic retinopathy with macular\nedema, bilateral', '', 'E113413', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3266, 'Type 2 diabetes mellitus with severe nonproliferative diabetic retinopathy with macular\nedema, unspecified eye', '', 'E113419', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3267, 'Type 2 diabetes mellitus with severe nonproliferative diabetic retinopathy without macular\nedema, right eye', '', 'E113491', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3268, 'Type 2 diabetes mellitus with severe nonproliferative diabetic retinopathy without macular\nedema, left eye', '', 'E113492', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3269, 'Type 2 diabetes mellitus with severe nonproliferative diabetic retinopathy without macular\nedema, bilateral', '', 'E113493', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3270, 'Type 2 diabetes mellitus with severe nonproliferative diabetic retinopathy without macular\nedema, unspecified eye', '', 'E113499', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3271, 'Type 2 diabetes mellitus with proliferative diabetic retinopathy with macular edema, right eye', '', 'E113511', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3272, 'Type 2 diabetes mellitus with proliferative diabetic retinopathy with macular edema, left eye', '', 'E113512', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3273, 'Type 2 diabetes mellitus with proliferative diabetic retinopathy with macular edema, bilateral', '', 'E113513', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3274, 'Type 2 diabetes mellitus with proliferative diabetic retinopathy with macular edema,\nunspecified eye', '', 'E113519', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3275, 'Type 2 diabetes mellitus with proliferative diabetic retinopathy with traction retinal\ndetachment involving the macula, right eye', '', 'E113521', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3276, 'Type 2 diabetes mellitus with proliferative diabetic retinopathy with traction retinal\ndetachment involving the macula, left eye', '', 'E113522', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3277, 'Type 2 diabetes mellitus with proliferative diabetic retinopathy with traction retinal\ndetachment involving the macula, bilateral', '', 'E113523', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3278, 'Type 2 diabetes mellitus with proliferative diabetic retinopathy with traction retinal\ndetachment involving the macula, unspecified eye', '', 'E113529', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3279, 'Type 2 diabetes mellitus with proliferative diabetic retinopathy with traction retinal\ndetachment not involving the macula, right eye', '', 'E113531', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3280, 'Type 2 diabetes mellitus with proliferative diabetic retinopathy with traction retinal\ndetachment not involving the macula, left eye', '', 'E113532', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3281, 'Type 2 diabetes mellitus with proliferative diabetic retinopathy with traction retinal\ndetachment not involving the macula, bilateral', '', 'E113533', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3282, 'Type 2 diabetes mellitus with proliferative diabetic retinopathy with traction retinal\ndetachment not involving the macula, unspecified eye', '', 'E113539', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3283, 'Type 2 diabetes mellitus with proliferative diabetic retinopathy with combined traction retinal\ndetachment and rhegmatogenous retinal detachment, right eye', '', 'E113541', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3284, 'Type 2 diabetes mellitus with proliferative diabetic retinopathy with combined traction retinal\ndetachment and rhegmatogenous retinal detachment, left eye', '', 'E113542', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3285, 'Type 2 diabetes mellitus with proliferative diabetic retinopathy with combined traction retinal\ndetachment and rhegmatogenous retinal detachment, bilateral', '', 'E113543', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3286, 'Type 2 diabetes mellitus with proliferative diabetic retinopathy with combined traction retinal\ndetachment and rhegmatogenous retinal detachment, unspecified eye', '', 'E113549', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3287, 'Type 2 diabetes mellitus with stable proliferative diabetic retinopathy, right eye', '', 'E113551', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3288, 'Type 2 diabetes mellitus with stable proliferative diabetic retinopathy, left eye', '', 'E113552', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3289, 'Type 2 diabetes mellitus with stable proliferative diabetic retinopathy, bilateral', '', 'E113553', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3290, 'Type 2 diabetes mellitus with stable proliferative diabetic retinopathy, unspecified eye', '', 'E113559', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3291, 'Type 2 diabetes mellitus with proliferative diabetic retinopathy without macular edema, right\neye', '', 'E113591', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3292, 'Type 2 diabetes mellitus with proliferative diabetic retinopathy without macular edema, left\neye', '', 'E113592', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3293, 'Type 2 diabetes mellitus with proliferative diabetic retinopathy without macular edema,\nbilateral', '', 'E113593', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3294, 'Type 2 diabetes mellitus with proliferative diabetic retinopathy without macular edema,\nunspecified eye', '', 'E113599', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3295, 'Type 2 diabetes mellitus with diabetic cataract', '', 'E1136', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3296, 'Type 2 diabetes mellitus with diabetic macular edema, resolved following treatment, right eye', '', 'E1137X1', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3297, 'Type 2 diabetes mellitus with diabetic macular edema, resolved following treatment, left eye', '', 'E1137X2', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3298, 'Type 2 diabetes mellitus with diabetic macular edema, resolved following treatment, bilateral', '', 'E1137X3', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3299, 'Type 2 diabetes mellitus with diabetic macular edema, resolved following treatment,\nunspecified eye', '', 'E1137X9', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3300, 'Type 2 diabetes mellitus with other diabetic ophthalmic complication', '', 'E1139', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3301, 'Type 2 diabetes mellitus with diabetic neuropathy, unspecified', '', 'E1140', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3302, 'Type 2 diabetes mellitus with diabetic mononeuropathy', '', 'E1141', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3303, 'Type 2 diabetes mellitus with diabetic polyneuropathy', '', 'E1142', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3304, 'Type 2 diabetes mellitus with diabetic autonomic (poly)neuropathy', '', 'E1143', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3305, 'Type 2 diabetes mellitus with diabetic amyotrophy', '', 'E1144', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3306, 'Type 2 diabetes mellitus with other diabetic neurological complication', '', 'E1149', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3307, 'Type 2 diabetes mellitus with diabetic peripheral angiopathy without gangrene', '', 'E1151', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3308, 'Type 2 diabetes mellitus with diabetic peripheral angiopathy with gangrene', '', 'E1152', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3309, 'Type 2 diabetes mellitus with other circulatory complications', '', 'E1159', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3310, 'Type 2 diabetes mellitus with diabetic neuropathic arthropathy', '', 'E11610', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3311, 'Type 2 diabetes mellitus with other diabetic arthropathy', '', 'E11618', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3312, 'Type 2 diabetes mellitus with diabetic dermatitis', '', 'E11620', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3313, 'Type 2 diabetes mellitus with foot ulcer', '', 'E11621', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3314, 'Type 2 diabetes mellitus with other skin ulcer', '', 'E11622', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3315, 'Type 2 diabetes mellitus with other skin complications', '', 'E11628', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3316, 'Type 2 diabetes mellitus with periodontal disease', '', 'E11630', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3317, 'Type 2 diabetes mellitus with other oral complications', '', 'E11638', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3318, 'Type 2 diabetes mellitus with hypoglycemia with coma', '', 'E11641', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3319, 'Type 2 diabetes mellitus with hypoglycemia without coma', '', 'E11649', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3320, 'Type 2 diabetes mellitus with hyperglycemia', '', 'E1165', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3321, 'Type 2 diabetes mellitus with other specified complication', '', 'E1169', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3322, 'Type 2 diabetes mellitus with unspecified complications', '', 'E118', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3323, 'Type 2 diabetes mellitus without complications', '', 'E119', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3324, 'Other specified diabetes mellitus with hyperosmolarity without nonketotic hyperglycemic-\nhyperosmolar coma (NKHHC)', '', 'E1300', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3325, 'Other specified diabetes mellitus with hyperosmolarity with coma', '', 'E1301', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3326, 'Other specified diabetes mellitus with ketoacidosis without coma', '', 'E1310', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3327, 'Other specified diabetes mellitus with ketoacidosis with coma', '', 'E1311', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3328, 'Other specified diabetes mellitus with diabetic nephropathy', '', 'E1321', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3329, 'Other specified diabetes mellitus with diabetic chronic kidney disease', '', 'E1322', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3330, 'Other specified diabetes mellitus with other diabetic kidney complication', '', 'E1329', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3331, 'Other specified diabetes mellitus with unspecified diabetic retinopathy with macular edema', '', 'E13311', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3332, 'Other specified diabetes mellitus with unspecified diabetic retinopathy without macular edema', '', 'E13319', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3333, 'Other specified diabetes mellitus with mild nonproliferative diabetic retinopathy with macular\nedema, right eye', '', 'E133211', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3334, 'Other specified diabetes mellitus with mild nonproliferative diabetic retinopathy with macular\nedema, left eye', '', 'E133212', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3335, 'Other specified diabetes mellitus with mild nonproliferative diabetic retinopathy with macular\nedema, bilateral', '', 'E133213', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3336, 'Other specified diabetes mellitus with mild nonproliferative diabetic retinopathy with macular\nedema, unspecified eye', '', 'E133219', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3337, 'Other specified diabetes mellitus with mild nonproliferative diabetic retinopathy without\nmacular edema, right eye', '', 'E133291', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3338, 'Other specified diabetes mellitus with mild nonproliferative diabetic retinopathy without\nmacular edema, left eye', '', 'E133292', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3339, 'Other specified diabetes mellitus with mild nonproliferative diabetic retinopathy without\nmacular edema, bilateral', '', 'E133293', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3340, 'Other specified diabetes mellitus with mild nonproliferative diabetic retinopathy without\nmacular edema, unspecified eye', '', 'E133299', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3341, 'Other specified diabetes mellitus with moderate nonproliferative diabetic retinopathy with\nmacular edema, right eye', '', 'E133311', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3342, 'Other specified diabetes mellitus with moderate nonproliferative diabetic retinopathy with\nmacular edema, left eye', '', 'E133312', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3343, 'Other specified diabetes mellitus with moderate nonproliferative diabetic retinopathy with\nmacular edema, bilateral', '', 'E133313', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3344, 'Other specified diabetes mellitus with moderate nonproliferative diabetic retinopathy with\nmacular edema, unspecified eye', '', 'E133319', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3345, 'Other specified diabetes mellitus with moderate nonproliferative diabetic retinopathy without\nmacular edema, right eye', '', 'E133391', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3346, 'Other specified diabetes mellitus with moderate nonproliferative diabetic retinopathy without\nmacular edema, left eye', '', 'E133392', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3347, 'Other specified diabetes mellitus with moderate nonproliferative diabetic retinopathy without\nmacular edema, bilateral', '', 'E133393', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3348, 'Other specified diabetes mellitus with moderate nonproliferative diabetic retinopathy without\nmacular edema, unspecified eye', '', 'E133399', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3349, 'Other specified diabetes mellitus with severe nonproliferative diabetic retinopathy with\nmacular edema, right eye', '', 'E133411', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3350, 'Other specified diabetes mellitus with severe nonproliferative diabetic retinopathy with\nmacular edema, left eye', '', 'E133412', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3351, 'Other specified diabetes mellitus with severe nonproliferative diabetic retinopathy with\nmacular edema, bilateral', '', 'E133413', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3352, 'Other specified diabetes mellitus with severe nonproliferative diabetic retinopathy with\nmacular edema, unspecified eye', '', 'E133419', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3353, 'Other specified diabetes mellitus with severe nonproliferative diabetic retinopathy without\nmacular edema, right eye', '', 'E133491', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3354, 'Other specified diabetes mellitus with severe nonproliferative diabetic retinopathy without\nmacular edema, left eye', '', 'E133492', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3355, 'Other specified diabetes mellitus with severe nonproliferative diabetic retinopathy without\nmacular edema, bilateral', '', 'E133493', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3356, 'Other specified diabetes mellitus with severe nonproliferative diabetic retinopathy without\nmacular edema, unspecified eye', '', 'E133499', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3357, 'Other specified diabetes mellitus with proliferative diabetic retinopathy with macular edema,\nright eye', '', 'E133511', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3358, 'Other specified diabetes mellitus with proliferative diabetic retinopathy with macular edema,\nleft eye', '', 'E133512', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3359, 'Other specified diabetes mellitus with proliferative diabetic retinopathy with macular edema,\nbilateral', '', 'E133513', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3360, 'Other specified diabetes mellitus with proliferative diabetic retinopathy with macular edema,\nunspecified eye', '', 'E133519', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3361, 'Other specified diabetes mellitus with proliferative diabetic retinopathy with traction retinal\ndetachment involving the macula, right eye', '', 'E133521', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3362, 'Other specified diabetes mellitus with proliferative diabetic retinopathy with traction retinal\ndetachment involving the macula, left eye', '', 'E133522', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3363, 'Other specified diabetes mellitus with proliferative diabetic retinopathy with traction retinal\ndetachment involving the macula, bilateral', '', 'E133523', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3364, 'Other specified diabetes mellitus with proliferative diabetic retinopathy with traction retinal\ndetachment involving the macula, unspecified eye', '', 'E133529', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3365, 'Other specified diabetes mellitus with proliferative diabetic retinopathy with traction retinal\ndetachment not involving the macula, right eye', '', 'E133531', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3366, 'Other specified diabetes mellitus with proliferative diabetic retinopathy with traction retinal\ndetachment not involving the macula, left eye', '', 'E133532', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3367, 'Other specified diabetes mellitus with proliferative diabetic retinopathy with traction retinal\ndetachment not involving the macula, bilateral', '', 'E133533', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3368, 'Other specified diabetes mellitus with proliferative diabetic retinopathy with traction retinal\ndetachment not involving the macula, unspecified eye', '', 'E133539', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3369, 'Other specified diabetes mellitus with proliferative diabetic retinopathy with combined\ntraction retinal detachment and rhegmatogenous retinal detachment, right eye', '', 'E133541', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3370, 'Other specified diabetes mellitus with proliferative diabetic retinopathy with combined\ntraction retinal detachment and rhegmatogenous retinal detachment, left eye', '', 'E133542', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3371, 'Other specified diabetes mellitus with proliferative diabetic retinopathy with combined\ntraction retinal detachment and rhegmatogenous retinal detachment, bilateral', '', 'E133543', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3372, 'Other specified diabetes mellitus with proliferative diabetic retinopathy with combined\ntraction retinal detachment and rhegmatogenous retinal detachment, unspecified eye', '', 'E133549', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3373, 'Other specified diabetes mellitus with stable proliferative diabetic retinopathy, right eye', '', 'E133551', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3374, 'Other specified diabetes mellitus with stable proliferative diabetic retinopathy, left eye', '', 'E133552', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3375, 'Other specified diabetes mellitus with stable proliferative diabetic retinopathy, bilateral', '', 'E133553', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3376, 'Other specified diabetes mellitus with stable proliferative diabetic retinopathy, unspecified eye', '', 'E133559', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3377, 'Other specified diabetes mellitus with proliferative diabetic retinopathy without macular\nedema, right eye', '', 'E133591', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3378, 'Other specified diabetes mellitus with proliferative diabetic retinopathy without macular\nedema, left eye', '', 'E133592', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3379, 'Other specified diabetes mellitus with proliferative diabetic retinopathy without macular\nedema, bilateral', '', 'E133593', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3380, 'Other specified diabetes mellitus with proliferative diabetic retinopathy without macular\nedema, unspecified eye', '', 'E133599', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3381, 'Other specified diabetes mellitus with diabetic cataract', '', 'E1336', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3382, 'Other specified diabetes mellitus with diabetic macular edema, resolved following treatment,\nright eye', '', 'E1337X1', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3383, 'Other specified diabetes mellitus with diabetic macular edema, resolved following treatment,\nleft eye', '', 'E1337X2', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3384, 'Other specified diabetes mellitus with diabetic macular edema, resolved following treatment,\nbilateral', '', 'E1337X3', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3385, 'Other specified diabetes mellitus with diabetic macular edema, resolved following treatment,\nunspecified eye', '', 'E1337X9', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3386, 'Other specified diabetes mellitus with other diabetic ophthalmic complication', '', 'E1339', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3387, 'Other specified diabetes mellitus with diabetic neuropathy, unspecified', '', 'E1340', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3388, 'Other specified diabetes mellitus with diabetic mononeuropathy', '', 'E1341', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3389, 'Other specified diabetes mellitus with diabetic polyneuropathy', '', 'E1342', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3390, 'Other specified diabetes mellitus with diabetic autonomic (poly)neuropathy', '', 'E1343', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3391, 'Other specified diabetes mellitus with diabetic amyotrophy', '', 'E1344', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3392, 'Other specified diabetes mellitus with other diabetic neurological complication', '', 'E1349', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3393, 'Other specified diabetes mellitus with diabetic peripheral angiopathy without gangrene', '', 'E1351', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3394, 'Other specified diabetes mellitus with diabetic peripheral angiopathy with gangrene', '', 'E1352', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3395, 'Other specified diabetes mellitus with other circulatory complications', '', 'E1359', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3396, 'Other specified diabetes mellitus with diabetic neuropathic arthropathy', '', 'E13610', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3397, 'Other specified diabetes mellitus with other diabetic arthropathy', '', 'E13618', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3398, 'Other specified diabetes mellitus with diabetic dermatitis', '', 'E13620', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3399, 'Other specified diabetes mellitus with foot ulcer', '', 'E13621', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3400, 'Other specified diabetes mellitus with other skin ulcer', '', 'E13622', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3401, 'Other specified diabetes mellitus with other skin complications', '', 'E13628', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3402, 'Other specified diabetes mellitus with periodontal disease', '', 'E13630', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3403, 'Other specified diabetes mellitus with other oral complications', '', 'E13638', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3404, 'Other specified diabetes mellitus with hypoglycemia with coma', '', 'E13641', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3405, 'Other specified diabetes mellitus with hypoglycemia without coma', '', 'E13649', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3406, 'Other specified diabetes mellitus with hyperglycemia', '', 'E1365', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3407, 'Other specified diabetes mellitus with other specified complication', '', 'E1369', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3408, 'Other specified diabetes mellitus with unspecified complications', '', 'E138', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3409, 'Other specified diabetes mellitus without complications', '', 'E139', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1);");


DB::statement("INSERT INTO `symptoms` (`id`, `symptoms_title`, `description`, `code`, `status`, `priority`, `created_at`, `updated_at`, `type`) VALUES
(3410, 'Nondiabetic hypoglycemic coma', '', 'E15', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3411, 'Drug-induced hypoglycemia without coma', '', 'E160', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3412, 'Other hypoglycemia', '', 'E161', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3413, 'Hypoglycemia, unspecified', '', 'E162', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3414, 'Increased secretion of glucagon', '', 'E163', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3415, 'Increased secretion of gastrin', '', 'E164', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3416, 'Other specified disorders of pancreatic internal secretion', '', 'E168', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3417, 'Disorder of pancreatic internal secretion, unspecified', '', 'E169', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3418, 'Idiopathic hypoparathyroidism', '', 'E200', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3419, 'Pseudohypoparathyroidism', '', 'E201', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3420, 'Other hypoparathyroidism', '', 'E208', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3421, 'Hypoparathyroidism, unspecified', '', 'E209', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3422, 'Primary hyperparathyroidism', '', 'E210', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3423, 'Secondary hyperparathyroidism, not elsewhere classified', '', 'E211', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3424, 'Other hyperparathyroidism', '', 'E212', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3425, 'Hyperparathyroidism, unspecified', '', 'E213', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3426, 'Other specified disorders of parathyroid gland', '', 'E214', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3427, 'Disorder of parathyroid gland, unspecified', '', 'E215', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3428, 'Acromegaly and pituitary gigantism', '', 'E220', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3429, 'Hyperprolactinemia', '', 'E221', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3430, 'Syndrome of inappropriate secretion of antidiuretic hormone', '', 'E222', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3431, 'Other hyperfunction of pituitary gland', '', 'E228', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3432, 'Hyperfunction of pituitary gland, unspecified', '', 'E229', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3433, 'Hypopituitarism', '', 'E230', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3434, 'Drug-induced hypopituitarism', '', 'E231', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3435, 'Diabetes insipidus', '', 'E232', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3436, 'Hypothalamic dysfunction, not elsewhere classified', '', 'E233', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3437, 'Other disorders of pituitary gland', '', 'E236', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3438, 'Disorder of pituitary gland, unspecified', '', 'E237', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3439, 'Pituitary-dependent Cushing\'s disease', '', 'E240', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3440, 'Nelson\'s syndrome', '', 'E241', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3441, 'Drug-induced Cushing\'s syndrome', '', 'E242', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3442, 'Ectopic ACTH syndrome', '', 'E243', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3443, 'Alcohol-induced pseudo-Cushing\'s syndrome', '', 'E244', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3444, 'Other Cushing\'s syndrome', '', 'E248', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3445, 'Cushing\'s syndrome, unspecified', '', 'E249', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3446, 'Congenital adrenogenital disorders associated with enzyme deficiency', '', 'E250', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3447, 'Other adrenogenital disorders', '', 'E258', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3448, 'Adrenogenital disorder, unspecified', '', 'E259', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3449, 'Conn\'s syndrome', '', 'E2601', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3450, 'Glucocorticoid-remediable aldosteronism', '', 'E2602', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3451, 'Other primary hyperaldosteronism', '', 'E2609', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3452, 'Secondary hyperaldosteronism', '', 'E261', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3453, 'Bartter\'s syndrome', '', 'E2681', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3454, 'Other hyperaldosteronism', '', 'E2689', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3455, 'Hyperaldosteronism, unspecified', '', 'E269', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3456, 'Other adrenocortical overactivity', '', 'E270', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3457, 'Primary adrenocortical insufficiency', '', 'E271', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3458, 'Addisonian crisis', '', 'E272', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3459, 'Drug-induced adrenocortical insufficiency', '', 'E273', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3460, 'Unspecified adrenocortical insufficiency', '', 'E2740', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3461, 'Other adrenocortical insufficiency', '', 'E2749', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3462, 'Adrenomedullary hyperfunction', '', 'E275', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3463, 'Other specified disorders of adrenal gland', '', 'E278', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3464, 'Disorder of adrenal gland, unspecified', '', 'E279', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3465, 'Estrogen excess', '', 'E280', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3466, 'Androgen excess', '', 'E281', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3467, 'Polycystic ovarian syndrome', '', 'E282', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3468, 'Symptomatic premature menopause', '', 'E28310', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3469, 'Asymptomatic premature menopause', '', 'E28319', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3470, 'Other primary ovarian failure', '', 'E2839', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3471, 'Other ovarian dysfunction', '', 'E288', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3472, 'Ovarian dysfunction, unspecified', '', 'E289', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3473, 'Testicular hyperfunction', '', 'E290', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3474, 'Testicular hypofunction', '', 'E291', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3475, 'Other testicular dysfunction', '', 'E298', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3476, 'Testicular dysfunction, unspecified', '', 'E299', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3477, 'Delayed puberty', '', 'E300', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3478, 'Precocious puberty', '', 'E301', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3479, 'Other disorders of puberty', '', 'E308', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3480, 'Disorder of puberty, unspecified', '', 'E309', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3481, 'Autoimmune polyglandular failure', '', 'E310', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3482, 'Polyglandular hyperfunction', '', 'E311', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3483, 'Multiple endocrine neoplasia [MEN] syndrome, unspecified', '', 'E3120', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3484, 'Multiple endocrine neoplasia [MEN] type I', '', 'E3121', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3485, 'Multiple endocrine neoplasia [MEN] type IIA', '', 'E3122', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3486, 'Multiple endocrine neoplasia [MEN] type IIB', '', 'E3123', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3487, 'Other polyglandular dysfunction', '', 'E318', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3488, 'Polyglandular dysfunction, unspecified', '', 'E319', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3489, 'Persistent hyperplasia of thymus', '', 'E320', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3490, 'Abscess of thymus', '', 'E321', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3491, 'Other diseases of thymus', '', 'E328', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3492, 'Disease of thymus, unspecified', '', 'E329', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3493, 'Carcinoid syndrome', '', 'E340', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3494, 'Other hypersecretion of intestinal hormones', '', 'E341', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3495, 'Ectopic hormone secretion, not elsewhere classified', '', 'E342', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3496, 'Short stature due to endocrine disorder', '', 'E343', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3497, 'Constitutional tall stature', '', 'E344', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3498, 'Androgen insensitivity syndrome, unspecified', '', 'E3450', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3499, 'Complete androgen insensitivity syndrome', '', 'E3451', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3500, 'Partial androgen insensitivity syndrome', '', 'E3452', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3501, 'Other specified endocrine disorders', '', 'E348', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3502, 'Endocrine disorder, unspecified', '', 'E349', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3503, 'Disorders of endocrine glands in diseases classified elsewhere', '', 'E35', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3504, 'Intraoperative hemorrhage and hematoma of an endocrine system organ or structure\ncomplicating an endocrine system procedure', '', 'E3601', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3505, 'Intraoperative hemorrhage and hematoma of an endocrine system organ or structure\ncomplicating other procedure', '', 'E3602', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3506, 'Accidental puncture and laceration of an endocrine system organ or structure during an\nendocrine system procedure', '', 'E3611', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3507, 'Accidental puncture and laceration of an endocrine system organ or structure during other\nprocedure', '', 'E3612', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3508, 'Other intraoperative complications of endocrine system', '', 'E368', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3509, 'Kwashiorkor', '', 'E40', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3510, 'Nutritional marasmus', '', 'E41', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3511, 'Marasmic kwashiorkor', '', 'E42', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3512, 'Unspecified severe protein-calorie malnutrition', '', 'E43', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3513, 'Moderate protein-calorie malnutrition', '', 'E440', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3514, 'Mild protein-calorie malnutrition', '', 'E441', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3515, 'Retarded development following protein-calorie malnutrition', '', 'E45', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3516, 'Unspecified protein-calorie malnutrition', '', 'E46', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3517, 'Vitamin A deficiency with conjunctival xerosis', '', 'E500', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3518, 'Vitamin A deficiency with Bitot\'s spot and conjunctival xerosis', '', 'E501', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3519, 'Vitamin A deficiency with corneal xerosis', '', 'E502', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3520, 'Vitamin A deficiency with corneal ulceration and xerosis', '', 'E503', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3521, 'Vitamin A deficiency with keratomalacia', '', 'E504', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3522, 'Vitamin A deficiency with night blindness', '', 'E505', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3523, 'Vitamin A deficiency with xerophthalmic scars of cornea', '', 'E506', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3524, 'Other ocular manifestations of vitamin A deficiency', '', 'E507', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3525, 'Other manifestations of vitamin A deficiency', '', 'E508', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3526, 'Vitamin A deficiency, unspecified', '', 'E509', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3527, 'Dry beriberi', '', 'E5111', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3528, 'Wet beriberi', '', 'E5112', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3529, 'Wernicke\'s encephalopathy', '', 'E512', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3530, 'Other manifestations of thiamine deficiency', '', 'E518', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3531, 'Thiamine deficiency, unspecified', '', 'E519', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3532, 'Niacin deficiency [pellagra]', '', 'E52', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3533, 'Riboflavin deficiency', '', 'E530', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3534, 'Pyridoxine deficiency', '', 'E531', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3535, 'Deficiency of other specified B group vitamins', '', 'E538', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3536, 'Vitamin B deficiency, unspecified', '', 'E539', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3537, 'Ascorbic acid deficiency', '', 'E54', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3538, 'Rickets, active', '', 'E550', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3539, 'Vitamin D deficiency, unspecified', '', 'E559', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3540, 'Deficiency of vitamin E', '', 'E560', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3541, 'Deficiency of vitamin K', '', 'E561', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3542, 'Deficiency of other vitamins', '', 'E568', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3543, 'Vitamin deficiency, unspecified', '', 'E569', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3544, 'Dietary calcium deficiency', '', 'E58', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3545, 'Dietary selenium deficiency', '', 'E59', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3546, 'Dietary zinc deficiency', '', 'E60', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3547, 'Copper deficiency', '', 'E610', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3548, 'Iron deficiency', '', 'E611', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3549, 'Magnesium deficiency', '', 'E612', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3550, 'Manganese deficiency', '', 'E613', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3551, 'Chromium deficiency', '', 'E614', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3552, 'Molybdenum deficiency', '', 'E615', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3553, 'Vanadium deficiency', '', 'E616', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3554, 'Deficiency of multiple nutrient elements', '', 'E617', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3555, 'Deficiency of other specified nutrient elements', '', 'E618', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3556, 'Deficiency of nutrient element, unspecified', '', 'E619', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3557, 'Essential fatty acid [EFA] deficiency', '', 'E630', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3558, 'Imbalance of constituents of food intake', '', 'E631', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3559, 'Other specified nutritional deficiencies', '', 'E638', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3560, 'Nutritional deficiency, unspecified', '', 'E639', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3561, 'Sequelae of protein-calorie malnutrition', '', 'E640', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3562, 'Sequelae of vitamin A deficiency', '', 'E641', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3563, 'Sequelae of vitamin C deficiency', '', 'E642', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3564, 'Sequelae of rickets', '', 'E643', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3565, 'Sequelae of other nutritional deficiencies', '', 'E648', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3566, 'Sequelae of unspecified nutritional deficiency', '', 'E649', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3567, 'Localized adiposity', '', 'E65', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3568, 'Morbid (severe) obesity due to excess calories', '', 'E6601', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3569, 'Other obesity due to excess calories', '', 'E6609', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3570, 'Drug-induced obesity', '', 'E661', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3571, 'Morbid (severe) obesity with alveolar hypoventilation', '', 'E662', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3572, 'Overweight', '', 'E663', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3573, 'Other obesity', '', 'E668', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3574, 'Obesity, unspecified', '', 'E669', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3575, 'Hypervitaminosis A', '', 'E670', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3576, 'Hypercarotinemia', '', 'E671', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3577, 'Megavitamin-B6 syndrome', '', 'E672', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3578, 'Hypervitaminosis D', '', 'E673', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3579, 'Other specified hyperalimentation', '', 'E678', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3580, 'Sequelae of hyperalimentation', '', 'E68', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3581, 'Classical phenylketonuria', '', 'E700', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3582, 'Other hyperphenylalaninemias', '', 'E701', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3583, 'Disorder of tyrosine metabolism, unspecified', '', 'E7020', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3584, 'Tyrosinemia', '', 'E7021', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3585, 'Other disorders of tyrosine metabolism', '', 'E7029', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3586, 'Albinism, unspecified', '', 'E7030', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3587, 'X-linked ocular albinism', '', 'E70310', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3588, 'Autosomal recessive ocular albinism', '', 'E70311', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3589, 'Other ocular albinism', '', 'E70318', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3590, 'Ocular albinism, unspecified', '', 'E70319', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3591, 'Tyrosinase negative oculocutaneous albinism', '', 'E70320', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3592, 'Tyrosinase positive oculocutaneous albinism', '', 'E70321', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3593, 'Other oculocutaneous albinism', '', 'E70328', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3594, 'Oculocutaneous albinism, unspecified', '', 'E70329', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3595, 'Chediak-Higashi syndrome', '', 'E70330', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3596, 'Hermansky-Pudlak syndrome', '', 'E70331', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3597, 'Other albinism with hematologic abnormality', '', 'E70338', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3598, 'Albinism with hematologic abnormality, unspecified', '', 'E70339', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3599, 'Other specified albinism', '', 'E7039', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3600, 'Disorders of histidine metabolism, unspecified', '', 'E7040', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3601, 'Histidinemia', '', 'E7041', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3602, 'Other disorders of histidine metabolism', '', 'E7049', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3603, 'Disorders of tryptophan metabolism', '', 'E705', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3604, 'Other disorders of aromatic amino-acid metabolism', '', 'E708', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3605, 'Disorder of aromatic amino-acid metabolism, unspecified', '', 'E709', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3606, 'Maple-syrup-urine disease', '', 'E710', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3607, 'Isovaleric acidemia', '', 'E71110', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3608, '3-methylglutaconic aciduria', '', 'E71111', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3609, 'Other branched-chain organic acidurias', '', 'E71118', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3610, 'Methylmalonic acidemia', '', 'E71120', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3611, 'Propionic acidemia', '', 'E71121', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3612, 'Other disorders of propionate metabolism', '', 'E71128', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3613, 'Other disorders of branched-chain amino-acid metabolism', '', 'E7119', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3614, 'Disorder of branched-chain amino-acid metabolism, unspecified', '', 'E712', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3615, 'Disorder of fatty-acid metabolism, unspecified', '', 'E7130', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3616, 'Long chain/very long chain acyl CoA dehydrogenase deficiency', '', 'E71310', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3617, 'Medium chain acyl CoA dehydrogenase deficiency', '', 'E71311', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3618, 'Short chain acyl CoA dehydrogenase deficiency', '', 'E71312', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3619, 'Glutaric aciduria type II', '', 'E71313', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3620, 'Muscle carnitine palmitoyltransferase deficiency', '', 'E71314', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3621, 'Other disorders of fatty-acid oxidation', '', 'E71318', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3622, 'Disorders of ketone metabolism', '', 'E7132', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3623, 'Other disorders of fatty-acid metabolism', '', 'E7139', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3624, 'Disorder of carnitine metabolism, unspecified', '', 'E7140', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3625, 'Primary carnitine deficiency', '', 'E7141', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3626, 'Carnitine deficiency due to inborn errors of metabolism', '', 'E7142', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3627, 'Iatrogenic carnitine deficiency', '', 'E7143', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3628, 'Ruvalcaba-Myhre-Smith syndrome', '', 'E71440', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3629, 'Other secondary carnitine deficiency', '', 'E71448', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3630, 'Peroxisomal disorder, unspecified', '', 'E7150', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3631, 'Zellweger syndrome', '', 'E71510', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3632, 'Neonatal adrenoleukodystrophy', '', 'E71511', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3633, 'Other disorders of peroxisome biogenesis', '', 'E71518', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3634, 'Childhood cerebral X-linked adrenoleukodystrophy', '', 'E71520', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3635, 'Adolescent X-linked adrenoleukodystrophy', '', 'E71521', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3636, 'Adrenomyeloneuropathy', '', 'E71522', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3637, 'Other X-linked adrenoleukodystrophy', '', 'E71528', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3638, 'X-linked adrenoleukodystrophy, unspecified type', '', 'E71529', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3639, 'Other group 2 peroxisomal disorders', '', 'E7153', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3640, 'Rhizomelic chondrodysplasia punctata', '', 'E71540', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3641, 'Zellweger-like syndrome', '', 'E71541', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3642, 'Other group 3 peroxisomal disorders', '', 'E71542', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3643, 'Other peroxisomal disorders', '', 'E71548', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3644, 'Disorders of amino-acid transport, unspecified', '', 'E7200', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3645, 'Cystinuria', '', 'E7201', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3646, 'Hartnup\'s disease', '', 'E7202', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3647, 'Lowe\'s syndrome', '', 'E7203', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3648, 'Cystinosis', '', 'E7204', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3649, 'Other disorders of amino-acid transport', '', 'E7209', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3650, 'Disorders of sulfur-bearing amino-acid metabolism, unspecified', '', 'E7210', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3651, 'Homocystinuria', '', 'E7211', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3652, 'Methylenetetrahydrofolate reductase deficiency', '', 'E7212', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3653, 'Other disorders of sulfur-bearing amino-acid metabolism', '', 'E7219', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3654, 'Disorder of urea cycle metabolism, unspecified', '', 'E7220', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3655, 'Argininemia', '', 'E7221', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3656, 'Arginosuccinic aciduria', '', 'E7222', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3657, 'Citrullinemia', '', 'E7223', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3658, 'Other disorders of urea cycle metabolism', '', 'E7229', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3659, 'Disorders of lysine and hydroxylysine metabolism', '', 'E723', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3660, 'Disorders of ornithine metabolism', '', 'E724', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3661, 'Disorder of glycine metabolism, unspecified', '', 'E7250', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3662, 'Non-ketotic hyperglycinemia', '', 'E7251', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3663, 'Trimethylaminuria', '', 'E7252', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3664, 'Hyperoxaluria', '', 'E7253', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3665, 'Other disorders of glycine metabolism', '', 'E7259', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3666, 'Other specified disorders of amino-acid metabolism', '', 'E728', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3667, 'Disorder of amino-acid metabolism, unspecified', '', 'E729', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3668, 'Congenital lactase deficiency', '', 'E730', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3669, 'Secondary lactase deficiency', '', 'E731', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3670, 'Other lactose intolerance', '', 'E738', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3671, 'Lactose intolerance, unspecified', '', 'E739', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3672, 'Glycogen storage disease, unspecified', '', 'E7400', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3673, 'von Gierke disease', '', 'E7401', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3674, 'Pompe disease', '', 'E7402', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3675, 'Cori disease', '', 'E7403', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3676, 'McArdle disease', '', 'E7404', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3677, 'Other glycogen storage disease', '', 'E7409', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3678, 'Disorder of fructose metabolism, unspecified', '', 'E7410', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3679, 'Essential fructosuria', '', 'E7411', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3680, 'Hereditary fructose intolerance', '', 'E7412', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3681, 'Other disorders of fructose metabolism', '', 'E7419', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3682, 'Disorders of galactose metabolism, unspecified', '', 'E7420', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3683, 'Galactosemia', '', 'E7421', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3684, 'Other disorders of galactose metabolism', '', 'E7429', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3685, 'Sucrase-isomaltase deficiency', '', 'E7431', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3686, 'Other disorders of intestinal carbohydrate absorption', '', 'E7439', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3687, 'Disorders of pyruvate metabolism and gluconeogenesis', '', 'E744', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3688, 'Other specified disorders of carbohydrate metabolism', '', 'E748', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3689, 'Disorder of carbohydrate metabolism, unspecified', '', 'E749', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3690, 'GM2 gangliosidosis, unspecified', '', 'E7500', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3691, 'Sandhoff disease', '', 'E7501', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3692, 'Tay-Sachs disease', '', 'E7502', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3693, 'Other GM2 gangliosidosis', '', 'E7509', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3694, 'Unspecified gangliosidosis', '', 'E7510', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3695, 'Mucolipidosis IV', '', 'E7511', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3696, 'Other gangliosidosis', '', 'E7519', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3697, 'Fabry (-Anderson) disease', '', 'E7521', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3698, 'Gaucher disease', '', 'E7522', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3699, 'Krabbe disease', '', 'E7523', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3700, 'Niemann-Pick disease type A', '', 'E75240', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3701, 'Niemann-Pick disease type B', '', 'E75241', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3702, 'Niemann-Pick disease type C', '', 'E75242', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3703, 'Niemann-Pick disease type D', '', 'E75243', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3704, 'Other Niemann-Pick disease', '', 'E75248', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3705, 'Niemann-Pick disease, unspecified', '', 'E75249', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3706, 'Metachromatic leukodystrophy', '', 'E7525', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3707, 'Other sphingolipidosis', '', 'E7529', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3708, 'Sphingolipidosis, unspecified', '', 'E753', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3709, 'Neuronal ceroid lipofuscinosis', '', 'E754', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3710, 'Other lipid storage disorders', '', 'E755', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3711, 'Lipid storage disorder, unspecified', '', 'E756', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3712, 'Hurler\'s syndrome', '', 'E7601', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3713, 'Hurler-Scheie syndrome', '', 'E7602', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3714, 'Scheie\'s syndrome', '', 'E7603', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3715, 'Mucopolysaccharidosis, type II', '', 'E761', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3716, 'Morquio A mucopolysaccharidoses', '', 'E76210', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3717, 'Morquio B mucopolysaccharidoses', '', 'E76211', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3718, 'Morquio mucopolysaccharidoses, unspecified', '', 'E76219', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3719, 'Sanfilippo mucopolysaccharidoses', '', 'E7622', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3720, 'Other mucopolysaccharidoses', '', 'E7629', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3721, 'Mucopolysaccharidosis, unspecified', '', 'E763', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3722, 'Other disorders of glucosaminoglycan metabolism', '', 'E768', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3723, 'Glucosaminoglycan metabolism disorder, unspecified', '', 'E769', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3724, 'Defects in post-translational modification of lysosomal enzymes', '', 'E770', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3725, 'Defects in glycoprotein degradation', '', 'E771', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3726, 'Other disorders of glycoprotein metabolism', '', 'E778', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3727, 'Disorder of glycoprotein metabolism, unspecified', '', 'E779', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3728, 'Pure hypercholesterolemia, unspecified', '', 'E7800', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3729, 'Familial hypercholesterolemia', '', 'E7801', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3730, 'Pure hyperglyceridemia', '', 'E781', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3731, 'Mixed hyperlipidemia', '', 'E782', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3732, 'Hyperchylomicronemia', '', 'E783', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3733, 'Other hyperlipidemia', '', 'E784', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3734, 'Hyperlipidemia, unspecified', '', 'E785', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3735, 'Lipoprotein deficiency', '', 'E786', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3736, 'Disorder of bile acid and cholesterol metabolism, unspecified', '', 'E7870', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3737, 'Barth syndrome', '', 'E7871', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3738, 'Smith-Lemli-Opitz syndrome', '', 'E7872', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3739, 'Other disorders of bile acid and cholesterol metabolism', '', 'E7879', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3740, 'Lipoid dermatoarthritis', '', 'E7881', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3741, 'Other lipoprotein metabolism disorders', '', 'E7889', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3742, 'Disorder of lipoprotein metabolism, unspecified', '', 'E789', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3743, 'Hyperuricemia without signs of inflammatory arthritis and tophaceous disease', '', 'E790', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3744, 'Lesch-Nyhan syndrome', '', 'E791', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3745, 'Myoadenylate deaminase deficiency', '', 'E792', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3746, 'Other disorders of purine and pyrimidine metabolism', '', 'E798', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3747, 'Disorder of purine and pyrimidine metabolism, unspecified', '', 'E799', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3748, 'Hereditary erythropoietic porphyria', '', 'E800', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3749, 'Porphyria cutanea tarda', '', 'E801', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3750, 'Unspecified porphyria', '', 'E8020', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3751, 'Acute intermittent (hepatic) porphyria', '', 'E8021', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3752, 'Other porphyria', '', 'E8029', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3753, 'Defects of catalase and peroxidase', '', 'E803', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3754, 'Gilbert syndrome', '', 'E804', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3755, 'Crigler-Najjar syndrome', '', 'E805', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3756, 'Other disorders of bilirubin metabolism', '', 'E806', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3757, 'Disorder of bilirubin metabolism, unspecified', '', 'E807', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3758, 'Disorder of copper metabolism, unspecified', '', 'E8300', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3759, 'Wilson\'s disease', '', 'E8301', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3760, 'Other disorders of copper metabolism', '', 'E8309', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3761, 'Disorder of iron metabolism, unspecified', '', 'E8310', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3762, 'Hereditary hemochromatosis', '', 'E83110', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3763, 'Hemochromatosis due to repeated red blood cell transfusions', '', 'E83111', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3764, 'Other hemochromatosis', '', 'E83118', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3765, 'Hemochromatosis, unspecified', '', 'E83119', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3766, 'Other disorders of iron metabolism', '', 'E8319', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3767, 'Disorders of zinc metabolism', '', 'E832', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3768, 'Disorder of phosphorus metabolism, unspecified', '', 'E8330', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3769, 'Familial hypophosphatemia', '', 'E8331', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3770, 'Hereditary vitamin D-dependent rickets (type 1) (type 2)', '', 'E8332', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3771, 'Other disorders of phosphorus metabolism', '', 'E8339', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3772, 'Disorders of magnesium metabolism, unspecified', '', 'E8340', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3773, 'Hypermagnesemia', '', 'E8341', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3774, 'Hypomagnesemia', '', 'E8342', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3775, 'Other disorders of magnesium metabolism', '', 'E8349', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3776, 'Unspecified disorder of calcium metabolism', '', 'E8350', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3777, 'Hypocalcemia', '', 'E8351', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3778, 'Hypercalcemia', '', 'E8352', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3779, 'Other disorders of calcium metabolism', '', 'E8359', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3780, 'Hungry bone syndrome', '', 'E8381', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3781, 'Other disorders of mineral metabolism', '', 'E8389', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3782, 'Disorder of mineral metabolism, unspecified', '', 'E839', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3783, 'Cystic fibrosis with pulmonary manifestations', '', 'E840', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3784, 'Meconium ileus in cystic fibrosis', '', 'E8411', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3785, 'Cystic fibrosis with other intestinal manifestations', '', 'E8419', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3786, 'Cystic fibrosis with other manifestations', '', 'E848', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3787, 'Cystic fibrosis, unspecified', '', 'E849', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3788, 'Non-neuropathic heredofamilial amyloidosis', '', 'E850', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3789, 'Neuropathic heredofamilial amyloidosis', '', 'E851', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3790, 'Heredofamilial amyloidosis, unspecified', '', 'E852', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3791, 'Secondary systemic amyloidosis', '', 'E853', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3792, 'Organ-limited amyloidosis', '', 'E854', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3793, 'Other amyloidosis', '', 'E858', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3794, 'Amyloidosis, unspecified', '', 'E859', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3795, 'Dehydration', '', 'E860', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3796, 'Hypovolemia', '', 'E861', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3797, 'Volume depletion, unspecified', '', 'E869', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3798, 'Hyperosmolality and hypernatremia', '', 'E870', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3799, 'Hypo-osmolality and hyponatremia', '', 'E871', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3800, 'Acidosis', '', 'E872', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3801, 'Alkalosis', '', 'E873', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3802, 'Mixed disorder of acid-base balance', '', 'E874', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3803, 'Hyperkalemia', '', 'E875', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3804, 'Hypokalemia', '', 'E876', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3805, 'Fluid overload, unspecified', '', 'E8770', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3806, 'Transfusion associated circulatory overload', '', 'E8771', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3807, 'Other fluid overload', '', 'E8779', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3808, 'Other disorders of electrolyte and fluid balance, not elsewhere classified', '', 'E878', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3809, 'Alpha-1-antitrypsin deficiency', '', 'E8801', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3810, 'Other disorders of plasma-protein metabolism, not elsewhere classified', '', 'E8809', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3811, 'Lipodystrophy, not elsewhere classified', '', 'E881', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3812, 'Lipomatosis, not elsewhere classified', '', 'E882', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3813, 'Tumor lysis syndrome', '', 'E883', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3814, 'Mitochondrial metabolism disorder, unspecified', '', 'E8840', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3815, 'MELAS syndrome', '', 'E8841', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3816, 'MERRF syndrome', '', 'E8842', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3817, 'Other mitochondrial metabolism disorders', '', 'E8849', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3818, 'Metabolic syndrome', '', 'E8881', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3819, 'Other specified metabolic disorders', '', 'E8889', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3820, 'Metabolic disorder, unspecified', '', 'E889', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3821, 'Postprocedural hypothyroidism', '', 'E890', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3822, 'Postprocedural hypoinsulinemia', '', 'E891', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3823, 'Postprocedural hypoparathyroidism', '', 'E892', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3824, 'Postprocedural hypopituitarism', '', 'E893', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3825, 'Asymptomatic postprocedural ovarian failure', '', 'E8940', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3826, 'Symptomatic postprocedural ovarian failure', '', 'E8941', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3827, 'Postprocedural testicular hypofunction', '', 'E895', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3828, 'Postprocedural adrenocortical (-medullary) hypofunction', '', 'E896', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3829, 'Postprocedural hemorrhage of an endocrine system organ or structure following an endocrine\nsystem procedure', '', 'E89810', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3830, 'Postprocedural hemorrhage of an endocrine system organ or structure following other\nprocedure', '', 'E89811', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3831, 'Postprocedural hematoma of an endocrine system organ or structure following an endocrine\nsystem procedure', '', 'E89820', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3832, 'Postprocedural hematoma of an endocrine system organ or structure following other\nprocedure', '', 'E89821', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3833, 'Postprocedural seroma of an endocrine system organ or structure following an endocrine\nsystem procedure', '', 'E89822', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3834, 'Postprocedural seroma of an endocrine system organ or structure following other procedure', '', 'E89823', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3835, 'Other postprocedural endocrine and metabolic complications and disorders', '', 'E8989', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3836, 'Vascular dementia without behavioral disturbance', '', 'F0150', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3837, 'Vascular dementia with behavioral disturbance', '', 'F0151', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3838, 'Dementia in other diseases classified elsewhere without behavioral disturbance', '', 'F0280', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3839, 'Dementia in other diseases classified elsewhere with behavioral disturbance', '', 'F0281', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3840, 'Unspecified dementia without behavioral disturbance', '', 'F0390', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3841, 'Unspecified dementia with behavioral disturbance', '', 'F0391', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3842, 'Amnestic disorder due to known physiological condition', '', 'F04', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1);");


DB::statement("INSERT INTO `symptoms` (`id`, `symptoms_title`, `description`, `code`, `status`, `priority`, `created_at`, `updated_at`, `type`) VALUES
(3843, 'Delirium due to known physiological condition', '', 'F05', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3844, 'Psychotic disorder with hallucinations due to known physiological condition', '', 'F060', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3845, 'Catatonic disorder due to known physiological condition', '', 'F061', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3846, 'Psychotic disorder with delusions due to known physiological condition', '', 'F062', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3847, 'Mood disorder due to known physiological condition, unspecified', '', 'F0630', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3848, 'Mood disorder due to known physiological condition with depressive features', '', 'F0631', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3849, 'Mood disorder due to known physiological condition with major depressive-like episode', '', 'F0632', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3850, 'Mood disorder due to known physiological condition with manic features', '', 'F0633', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3851, 'Mood disorder due to known physiological condition with mixed features', '', 'F0634', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3852, 'Anxiety disorder due to known physiological condition', '', 'F064', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3853, 'Other specified mental disorders due to known physiological condition', '', 'F068', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3854, 'Personality change due to known physiological condition', '', 'F070', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3855, 'Postconcussional syndrome', '', 'F0781', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3856, 'Other personality and behavioral disorders due to known physiological condition', '', 'F0789', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3857, 'Unspecified personality and behavioral disorder due to known physiological condition', '', 'F079', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3858, 'Unspecified mental disorder due to known physiological condition', '', 'F09', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3859, 'Alcohol abuse, uncomplicated', '', 'F1010', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3860, 'Alcohol abuse with intoxication, uncomplicated', '', 'F10120', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3861, 'Alcohol abuse with intoxication delirium', '', 'F10121', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3862, 'Alcohol abuse with intoxication, unspecified', '', 'F10129', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3863, 'Alcohol abuse with alcohol-induced mood disorder', '', 'F1014', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3864, 'Alcohol abuse with alcohol-induced psychotic disorder with delusions', '', 'F10150', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3865, 'Alcohol abuse with alcohol-induced psychotic disorder with hallucinations', '', 'F10151', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3866, 'Alcohol abuse with alcohol-induced psychotic disorder, unspecified', '', 'F10159', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3867, 'Alcohol abuse with alcohol-induced anxiety disorder', '', 'F10180', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3868, 'Alcohol abuse with alcohol-induced sexual dysfunction', '', 'F10181', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3869, 'Alcohol abuse with alcohol-induced sleep disorder', '', 'F10182', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3870, 'Alcohol abuse with other alcohol-induced disorder', '', 'F10188', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3871, 'Alcohol abuse with unspecified alcohol-induced disorder', '', 'F1019', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3872, 'Alcohol dependence, uncomplicated', '', 'F1020', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3873, 'Alcohol dependence, in remission', '', 'F1021', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3874, 'Alcohol dependence with intoxication, uncomplicated', '', 'F10220', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3875, 'Alcohol dependence with intoxication delirium', '', 'F10221', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3876, 'Alcohol dependence with intoxication, unspecified', '', 'F10229', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3877, 'Alcohol dependence with withdrawal, uncomplicated', '', 'F10230', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3878, 'Alcohol dependence with withdrawal delirium', '', 'F10231', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3879, 'Alcohol dependence with withdrawal with perceptual disturbance', '', 'F10232', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3880, 'Alcohol dependence with withdrawal, unspecified', '', 'F10239', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3881, 'Alcohol dependence with alcohol-induced mood disorder', '', 'F1024', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3882, 'Alcohol dependence with alcohol-induced psychotic disorder with delusions', '', 'F10250', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3883, 'Alcohol dependence with alcohol-induced psychotic disorder with hallucinations', '', 'F10251', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3884, 'Alcohol dependence with alcohol-induced psychotic disorder, unspecified', '', 'F10259', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3885, 'Alcohol dependence with alcohol-induced persisting amnestic disorder', '', 'F1026', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3886, 'Alcohol dependence with alcohol-induced persisting dementia', '', 'F1027', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3887, 'Alcohol dependence with alcohol-induced anxiety disorder', '', 'F10280', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3888, 'Alcohol dependence with alcohol-induced sexual dysfunction', '', 'F10281', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3889, 'Alcohol dependence with alcohol-induced sleep disorder', '', 'F10282', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3890, 'Alcohol dependence with other alcohol-induced disorder', '', 'F10288', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3891, 'Alcohol dependence with unspecified alcohol-induced disorder', '', 'F1029', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3892, 'Alcohol use, unspecified with intoxication, uncomplicated', '', 'F10920', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3893, 'Alcohol use, unspecified with intoxication delirium', '', 'F10921', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3894, 'Alcohol use, unspecified with intoxication, unspecified', '', 'F10929', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3895, 'Alcohol use, unspecified with alcohol-induced mood disorder', '', 'F1094', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3896, 'Alcohol use, unspecified with alcohol-induced psychotic disorder with delusions', '', 'F10950', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3897, 'Alcohol use, unspecified with alcohol-induced psychotic disorder with hallucinations', '', 'F10951', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3898, 'Alcohol use, unspecified with alcohol-induced psychotic disorder, unspecified', '', 'F10959', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3899, 'Alcohol use, unspecified with alcohol-induced persisting amnestic disorder', '', 'F1096', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3900, 'Alcohol use, unspecified with alcohol-induced persisting dementia', '', 'F1097', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3901, 'Alcohol use, unspecified with alcohol-induced anxiety disorder', '', 'F10980', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3902, 'Alcohol use, unspecified with alcohol-induced sexual dysfunction', '', 'F10981', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3903, 'Alcohol use, unspecified with alcohol-induced sleep disorder', '', 'F10982', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3904, 'Alcohol use, unspecified with other alcohol-induced disorder', '', 'F10988', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3905, 'Alcohol use, unspecified with unspecified alcohol-induced disorder', '', 'F1099', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3906, 'Opioid abuse, uncomplicated', '', 'F1110', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3907, 'Opioid abuse with intoxication, uncomplicated', '', 'F11120', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3908, 'Opioid abuse with intoxication delirium', '', 'F11121', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3909, 'Opioid abuse with intoxication with perceptual disturbance', '', 'F11122', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3910, 'Opioid abuse with intoxication, unspecified', '', 'F11129', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3911, 'Opioid abuse with opioid-induced mood disorder', '', 'F1114', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3912, 'Opioid abuse with opioid-induced psychotic disorder with delusions', '', 'F11150', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3913, 'Opioid abuse with opioid-induced psychotic disorder with hallucinations', '', 'F11151', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3914, 'Opioid abuse with opioid-induced psychotic disorder, unspecified', '', 'F11159', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3915, 'Opioid abuse with opioid-induced sexual dysfunction', '', 'F11181', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3916, 'Opioid abuse with opioid-induced sleep disorder', '', 'F11182', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3917, 'Opioid abuse with other opioid-induced disorder', '', 'F11188', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3918, 'Opioid abuse with unspecified opioid-induced disorder', '', 'F1119', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3919, 'Opioid dependence, uncomplicated', '', 'F1120', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3920, 'Opioid dependence, in remission', '', 'F1121', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3921, 'Opioid dependence with intoxication, uncomplicated', '', 'F11220', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3922, 'Opioid dependence with intoxication delirium', '', 'F11221', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3923, 'Opioid dependence with intoxication with perceptual disturbance', '', 'F11222', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3924, 'Opioid dependence with intoxication, unspecified', '', 'F11229', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3925, 'Opioid dependence with withdrawal', '', 'F1123', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3926, 'Opioid dependence with opioid-induced mood disorder', '', 'F1124', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3927, 'Opioid dependence with opioid-induced psychotic disorder with delusions', '', 'F11250', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3928, 'Opioid dependence with opioid-induced psychotic disorder with hallucinations', '', 'F11251', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3929, 'Opioid dependence with opioid-induced psychotic disorder, unspecified', '', 'F11259', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3930, 'Opioid dependence with opioid-induced sexual dysfunction', '', 'F11281', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3931, 'Opioid dependence with opioid-induced sleep disorder', '', 'F11282', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3932, 'Opioid dependence with other opioid-induced disorder', '', 'F11288', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3933, 'Opioid dependence with unspecified opioid-induced disorder', '', 'F1129', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3934, 'Opioid use, unspecified, uncomplicated', '', 'F1190', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3935, 'Opioid use, unspecified with intoxication, uncomplicated', '', 'F11920', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3936, 'Opioid use, unspecified with intoxication delirium', '', 'F11921', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3937, 'Opioid use, unspecified with intoxication with perceptual disturbance', '', 'F11922', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3938, 'Opioid use, unspecified with intoxication, unspecified', '', 'F11929', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3939, 'Opioid use, unspecified with withdrawal', '', 'F1193', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3940, 'Opioid use, unspecified with opioid-induced mood disorder', '', 'F1194', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3941, 'Opioid use, unspecified with opioid-induced psychotic disorder with delusions', '', 'F11950', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3942, 'Opioid use, unspecified with opioid-induced psychotic disorder with hallucinations', '', 'F11951', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3943, 'Opioid use, unspecified with opioid-induced psychotic disorder, unspecified', '', 'F11959', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3944, 'Opioid use, unspecified with opioid-induced sexual dysfunction', '', 'F11981', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3945, 'Opioid use, unspecified with opioid-induced sleep disorder', '', 'F11982', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3946, 'Opioid use, unspecified with other opioid-induced disorder', '', 'F11988', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3947, 'Opioid use, unspecified with unspecified opioid-induced disorder', '', 'F1199', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3948, 'Cannabis abuse, uncomplicated', '', 'F1210', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3949, 'Cannabis abuse with intoxication, uncomplicated', '', 'F12120', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3950, 'Cannabis abuse with intoxication delirium', '', 'F12121', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3951, 'Cannabis abuse with intoxication with perceptual disturbance', '', 'F12122', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3952, 'Cannabis abuse with intoxication, unspecified', '', 'F12129', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3953, 'Cannabis abuse with psychotic disorder with delusions', '', 'F12150', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3954, 'Cannabis abuse with psychotic disorder with hallucinations', '', 'F12151', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3955, 'Cannabis abuse with psychotic disorder, unspecified', '', 'F12159', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3956, 'Cannabis abuse with cannabis-induced anxiety disorder', '', 'F12180', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3957, 'Cannabis abuse with other cannabis-induced disorder', '', 'F12188', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3958, 'Cannabis abuse with unspecified cannabis-induced disorder', '', 'F1219', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3959, 'Cannabis dependence, uncomplicated', '', 'F1220', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3960, 'Cannabis dependence, in remission', '', 'F1221', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3961, 'Cannabis dependence with intoxication, uncomplicated', '', 'F12220', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3962, 'Cannabis dependence with intoxication delirium', '', 'F12221', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3963, 'Cannabis dependence with intoxication with perceptual disturbance', '', 'F12222', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3964, 'Cannabis dependence with intoxication, unspecified', '', 'F12229', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3965, 'Cannabis dependence with psychotic disorder with delusions', '', 'F12250', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3966, 'Cannabis dependence with psychotic disorder with hallucinations', '', 'F12251', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3967, 'Cannabis dependence with psychotic disorder, unspecified', '', 'F12259', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3968, 'Cannabis dependence with cannabis-induced anxiety disorder', '', 'F12280', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3969, 'Cannabis dependence with other cannabis-induced disorder', '', 'F12288', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3970, 'Cannabis dependence with unspecified cannabis-induced disorder', '', 'F1229', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3971, 'Cannabis use, unspecified, uncomplicated', '', 'F1290', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3972, 'Cannabis use, unspecified with intoxication, uncomplicated', '', 'F12920', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3973, 'Cannabis use, unspecified with intoxication delirium', '', 'F12921', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3974, 'Cannabis use, unspecified with intoxication with perceptual disturbance', '', 'F12922', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3975, 'Cannabis use, unspecified with intoxication, unspecified', '', 'F12929', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3976, 'Cannabis use, unspecified with psychotic disorder with delusions', '', 'F12950', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3977, 'Cannabis use, unspecified with psychotic disorder with hallucinations', '', 'F12951', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3978, 'Cannabis use, unspecified with psychotic disorder, unspecified', '', 'F12959', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3979, 'Cannabis use, unspecified with anxiety disorder', '', 'F12980', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3980, 'Cannabis use, unspecified with other cannabis-induced disorder', '', 'F12988', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3981, 'Cannabis use, unspecified with unspecified cannabis-induced disorder', '', 'F1299', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3982, 'Sedative, hypnotic or anxiolytic abuse, uncomplicated', '', 'F1310', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3983, 'Sedative, hypnotic or anxiolytic abuse with intoxication, uncomplicated', '', 'F13120', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3984, 'Sedative, hypnotic or anxiolytic abuse with intoxication delirium', '', 'F13121', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3985, 'Sedative, hypnotic or anxiolytic abuse with intoxication, unspecified', '', 'F13129', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3986, 'Sedative, hypnotic or anxiolytic abuse with sedative, hypnotic or anxiolytic-induced mood\ndisorder', '', 'F1314', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3987, 'Sedative, hypnotic or anxiolytic abuse with sedative, hypnotic or anxiolytic-induced psychotic\ndisorder with delusions', '', 'F13150', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3988, 'Sedative, hypnotic or anxiolytic abuse with sedative, hypnotic or anxiolytic-induced psychotic\ndisorder with hallucinations', '', 'F13151', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3989, 'Sedative, hypnotic or anxiolytic abuse with sedative, hypnotic or anxiolytic-induced psychotic\ndisorder, unspecified', '', 'F13159', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3990, 'Sedative, hypnotic or anxiolytic abuse with sedative, hypnotic or anxiolytic-induced anxiety\ndisorder', '', 'F13180', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3991, 'Sedative, hypnotic or anxiolytic abuse with sedative, hypnotic or anxiolytic-induced sexual\ndysfunction', '', 'F13181', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3992, 'Sedative, hypnotic or anxiolytic abuse with sedative, hypnotic or anxiolytic-induced sleep\ndisorder', '', 'F13182', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3993, 'Sedative, hypnotic or anxiolytic abuse with other sedative, hypnotic or anxiolytic-induced\ndisorder', '', 'F13188', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3994, 'Sedative, hypnotic or anxiolytic abuse with unspecified sedative, hypnotic or anxiolytic-induced\ndisorder', '', 'F1319', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3995, 'Sedative, hypnotic or anxiolytic dependence, uncomplicated', '', 'F1320', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3996, 'Sedative, hypnotic or anxiolytic dependence, in remission', '', 'F1321', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3997, 'Sedative, hypnotic or anxiolytic dependence with intoxication, uncomplicated', '', 'F13220', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3998, 'Sedative, hypnotic or anxiolytic dependence with intoxication delirium', '', 'F13221', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(3999, 'Sedative, hypnotic or anxiolytic dependence with intoxication, unspecified', '', 'F13229', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4000, 'Sedative, hypnotic or anxiolytic dependence with withdrawal, uncomplicated', '', 'F13230', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4001, 'Sedative, hypnotic or anxiolytic dependence with withdrawal delirium', '', 'F13231', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4002, 'Sedative, hypnotic or anxiolytic dependence with withdrawal with perceptual disturbance', '', 'F13232', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4003, 'Sedative, hypnotic or anxiolytic dependence with withdrawal, unspecified', '', 'F13239', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4004, 'Sedative, hypnotic or anxiolytic dependence with sedative, hypnotic or anxiolytic-induced mood\ndisorder', '', 'F1324', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4005, 'Sedative, hypnotic or anxiolytic dependence with sedative, hypnotic or anxiolytic-induced\npsychotic disorder with delusions', '', 'F13250', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4006, 'Sedative, hypnotic or anxiolytic dependence with sedative, hypnotic or anxiolytic-induced\npsychotic disorder with hallucinations', '', 'F13251', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4007, 'Sedative, hypnotic or anxiolytic dependence with sedative, hypnotic or anxiolytic-induced\npsychotic disorder, unspecified', '', 'F13259', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4008, 'Sedative, hypnotic or anxiolytic dependence with sedative, hypnotic or anxiolytic-induced\npersisting amnestic disorder', '', 'F1326', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4009, 'Sedative, hypnotic or anxiolytic dependence with sedative, hypnotic or anxiolytic-induced\npersisting dementia', '', 'F1327', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4010, 'Sedative, hypnotic or anxiolytic dependence with sedative, hypnotic or anxiolytic-induced\nanxiety disorder', '', 'F13280', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4011, 'Sedative, hypnotic or anxiolytic dependence with sedative, hypnotic or anxiolytic-induced\nsexual dysfunction', '', 'F13281', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4012, 'Sedative, hypnotic or anxiolytic dependence with sedative, hypnotic or anxiolytic-induced sleep\ndisorder', '', 'F13282', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4013, 'Sedative, hypnotic or anxiolytic dependence with other sedative, hypnotic or anxiolytic-induced\ndisorder', '', 'F13288', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4014, 'Sedative, hypnotic or anxiolytic dependence with unspecified sedative, hypnotic or anxiolytic-\ninduced disorder', '', 'F1329', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4015, 'Sedative, hypnotic, or anxiolytic use, unspecified, uncomplicated', '', 'F1390', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4016, 'Sedative, hypnotic or anxiolytic use, unspecified with intoxication, uncomplicated', '', 'F13920', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4017, 'Sedative, hypnotic or anxiolytic use, unspecified with intoxication delirium', '', 'F13921', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4018, 'Sedative, hypnotic or anxiolytic use, unspecified with intoxication, unspecified', '', 'F13929', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4019, 'Sedative, hypnotic or anxiolytic use, unspecified with withdrawal, uncomplicated', '', 'F13930', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4020, 'Sedative, hypnotic or anxiolytic use, unspecified with withdrawal delirium', '', 'F13931', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4021, 'Sedative, hypnotic or anxiolytic use, unspecified with withdrawal with perceptual disturbances', '', 'F13932', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4022, 'Sedative, hypnotic or anxiolytic use, unspecified with withdrawal, unspecified', '', 'F13939', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4023, 'Sedative, hypnotic or anxiolytic use, unspecified with sedative, hypnotic or anxiolytic-induced\nmood disorder', '', 'F1394', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4024, 'Sedative, hypnotic or anxiolytic use, unspecified with sedative, hypnotic or anxiolytic-induced\npsychotic disorder with delusions', '', 'F13950', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4025, 'Sedative, hypnotic or anxiolytic use, unspecified with sedative, hypnotic or anxiolytic-induced\npsychotic disorder with hallucinations', '', 'F13951', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4026, 'Sedative, hypnotic or anxiolytic use, unspecified with sedative, hypnotic or anxiolytic-induced\npsychotic disorder, unspecified', '', 'F13959', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4027, 'Sedative, hypnotic or anxiolytic use, unspecified with sedative, hypnotic or anxiolytic-induced\npersisting amnestic disorder', '', 'F1396', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4028, 'Sedative, hypnotic or anxiolytic use, unspecified with sedative, hypnotic or anxiolytic-induced\npersisting dementia', '', 'F1397', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4029, 'Sedative, hypnotic or anxiolytic use, unspecified with sedative, hypnotic or anxiolytic-induced\nanxiety disorder', '', 'F13980', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4030, 'Sedative, hypnotic or anxiolytic use, unspecified with sedative, hypnotic or anxiolytic-induced\nsexual dysfunction', '', 'F13981', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4031, 'Sedative, hypnotic or anxiolytic use, unspecified with sedative, hypnotic or anxiolytic-induced\nsleep disorder', '', 'F13982', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4032, 'Sedative, hypnotic or anxiolytic use, unspecified with other sedative, hypnotic or anxiolytic-\ninduced disorder', '', 'F13988', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4033, 'Sedative, hypnotic or anxiolytic use, unspecified with unspecified sedative, hypnotic or\nanxiolytic-induced disorder', '', 'F1399', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4034, 'Cocaine abuse, uncomplicated', '', 'F1410', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4035, 'Cocaine abuse with intoxication, uncomplicated', '', 'F14120', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4036, 'Cocaine abuse with intoxication with delirium', '', 'F14121', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4037, 'Cocaine abuse with intoxication with perceptual disturbance', '', 'F14122', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4038, 'Cocaine abuse with intoxication, unspecified', '', 'F14129', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4039, 'Cocaine abuse with cocaine-induced mood disorder', '', 'F1414', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4040, 'Cocaine abuse with cocaine-induced psychotic disorder with delusions', '', 'F14150', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4041, 'Cocaine abuse with cocaine-induced psychotic disorder with hallucinations', '', 'F14151', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4042, 'Cocaine abuse with cocaine-induced psychotic disorder, unspecified', '', 'F14159', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4043, 'Cocaine abuse with cocaine-induced anxiety disorder', '', 'F14180', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4044, 'Cocaine abuse with cocaine-induced sexual dysfunction', '', 'F14181', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4045, 'Cocaine abuse with cocaine-induced sleep disorder', '', 'F14182', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4046, 'Cocaine abuse with other cocaine-induced disorder', '', 'F14188', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4047, 'Cocaine abuse with unspecified cocaine-induced disorder', '', 'F1419', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4048, 'Cocaine dependence, uncomplicated', '', 'F1420', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4049, 'Cocaine dependence, in remission', '', 'F1421', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4050, 'Cocaine dependence with intoxication, uncomplicated', '', 'F14220', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4051, 'Cocaine dependence with intoxication delirium', '', 'F14221', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4052, 'Cocaine dependence with intoxication with perceptual disturbance', '', 'F14222', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4053, 'Cocaine dependence with intoxication, unspecified', '', 'F14229', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4054, 'Cocaine dependence with withdrawal', '', 'F1423', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4055, 'Cocaine dependence with cocaine-induced mood disorder', '', 'F1424', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4056, 'Cocaine dependence with cocaine-induced psychotic disorder with delusions', '', 'F14250', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4057, 'Cocaine dependence with cocaine-induced psychotic disorder with hallucinations', '', 'F14251', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4058, 'Cocaine dependence with cocaine-induced psychotic disorder, unspecified', '', 'F14259', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4059, 'Cocaine dependence with cocaine-induced anxiety disorder', '', 'F14280', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4060, 'Cocaine dependence with cocaine-induced sexual dysfunction', '', 'F14281', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4061, 'Cocaine dependence with cocaine-induced sleep disorder', '', 'F14282', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4062, 'Cocaine dependence with other cocaine-induced disorder', '', 'F14288', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4063, 'Cocaine dependence with unspecified cocaine-induced disorder', '', 'F1429', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4064, 'Cocaine use, unspecified, uncomplicated', '', 'F1490', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4065, 'Cocaine use, unspecified with intoxication, uncomplicated', '', 'F14920', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4066, 'Cocaine use, unspecified with intoxication delirium', '', 'F14921', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4067, 'Cocaine use, unspecified with intoxication with perceptual disturbance', '', 'F14922', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4068, 'Cocaine use, unspecified with intoxication, unspecified', '', 'F14929', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4069, 'Cocaine use, unspecified with cocaine-induced mood disorder', '', 'F1494', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4070, 'Cocaine use, unspecified with cocaine-induced psychotic disorder with delusions', '', 'F14950', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4071, 'Cocaine use, unspecified with cocaine-induced psychotic disorder with hallucinations', '', 'F14951', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4072, 'Cocaine use, unspecified with cocaine-induced psychotic disorder, unspecified', '', 'F14959', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4073, 'Cocaine use, unspecified with cocaine-induced anxiety disorder', '', 'F14980', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4074, 'Cocaine use, unspecified with cocaine-induced sexual dysfunction', '', 'F14981', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4075, 'Cocaine use, unspecified with cocaine-induced sleep disorder', '', 'F14982', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4076, 'Cocaine use, unspecified with other cocaine-induced disorder', '', 'F14988', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4077, 'Cocaine use, unspecified with unspecified cocaine-induced disorder', '', 'F1499', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4078, 'Other stimulant abuse, uncomplicated', '', 'F1510', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4079, 'Other stimulant abuse with intoxication, uncomplicated', '', 'F15120', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4080, 'Other stimulant abuse with intoxication delirium', '', 'F15121', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4081, 'Other stimulant abuse with intoxication with perceptual disturbance', '', 'F15122', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4082, 'Other stimulant abuse with intoxication, unspecified', '', 'F15129', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4083, 'Other stimulant abuse with stimulant-induced mood disorder', '', 'F1514', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4084, 'Other stimulant abuse with stimulant-induced psychotic disorder with delusions', '', 'F15150', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4085, 'Other stimulant abuse with stimulant-induced psychotic disorder with hallucinations', '', 'F15151', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4086, 'Other stimulant abuse with stimulant-induced psychotic disorder, unspecified', '', 'F15159', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4087, 'Other stimulant abuse with stimulant-induced anxiety disorder', '', 'F15180', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4088, 'Other stimulant abuse with stimulant-induced sexual dysfunction', '', 'F15181', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4089, 'Other stimulant abuse with stimulant-induced sleep disorder', '', 'F15182', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4090, 'Other stimulant abuse with other stimulant-induced disorder', '', 'F15188', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4091, 'Other stimulant abuse with unspecified stimulant-induced disorder', '', 'F1519', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4092, 'Other stimulant dependence, uncomplicated', '', 'F1520', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4093, 'Other stimulant dependence, in remission', '', 'F1521', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4094, 'Other stimulant dependence with intoxication, uncomplicated', '', 'F15220', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4095, 'Other stimulant dependence with intoxication delirium', '', 'F15221', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4096, 'Other stimulant dependence with intoxication with perceptual disturbance', '', 'F15222', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4097, 'Other stimulant dependence with intoxication, unspecified', '', 'F15229', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4098, 'Other stimulant dependence with withdrawal', '', 'F1523', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4099, 'Other stimulant dependence with stimulant-induced mood disorder', '', 'F1524', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4100, 'Other stimulant dependence with stimulant-induced psychotic disorder with delusions', '', 'F15250', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4101, 'Other stimulant dependence with stimulant-induced psychotic disorder with hallucinations', '', 'F15251', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4102, 'Other stimulant dependence with stimulant-induced psychotic disorder, unspecified', '', 'F15259', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4103, 'Other stimulant dependence with stimulant-induced anxiety disorder', '', 'F15280', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4104, 'Other stimulant dependence with stimulant-induced sexual dysfunction', '', 'F15281', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4105, 'Other stimulant dependence with stimulant-induced sleep disorder', '', 'F15282', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4106, 'Other stimulant dependence with other stimulant-induced disorder', '', 'F15288', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4107, 'Other stimulant dependence with unspecified stimulant-induced disorder', '', 'F1529', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4108, 'Other stimulant use, unspecified, uncomplicated', '', 'F1590', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4109, 'Other stimulant use, unspecified with intoxication, uncomplicated', '', 'F15920', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4110, 'Other stimulant use, unspecified with intoxication delirium', '', 'F15921', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4111, 'Other stimulant use, unspecified with intoxication with perceptual disturbance', '', 'F15922', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4112, 'Other stimulant use, unspecified with intoxication, unspecified', '', 'F15929', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4113, 'Other stimulant use, unspecified with withdrawal', '', 'F1593', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4114, 'Other stimulant use, unspecified with stimulant-induced mood disorder', '', 'F1594', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4115, 'Other stimulant use, unspecified with stimulant-induced psychotic disorder with delusions', '', 'F15950', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4116, 'Other stimulant use, unspecified with stimulant-induced psychotic disorder with hallucinations', '', 'F15951', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4117, 'Other stimulant use, unspecified with stimulant-induced psychotic disorder, unspecified', '', 'F15959', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4118, 'Other stimulant use, unspecified with stimulant-induced anxiety disorder', '', 'F15980', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4119, 'Other stimulant use, unspecified with stimulant-induced sexual dysfunction', '', 'F15981', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4120, 'Other stimulant use, unspecified with stimulant-induced sleep disorder', '', 'F15982', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4121, 'Other stimulant use, unspecified with other stimulant-induced disorder', '', 'F15988', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4122, 'Other stimulant use, unspecified with unspecified stimulant-induced disorder', '', 'F1599', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4123, 'Hallucinogen abuse, uncomplicated', '', 'F1610', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4124, 'Hallucinogen abuse with intoxication, uncomplicated', '', 'F16120', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4125, 'Hallucinogen abuse with intoxication with delirium', '', 'F16121', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4126, 'Hallucinogen abuse with intoxication with perceptual disturbance', '', 'F16122', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4127, 'Hallucinogen abuse with intoxication, unspecified', '', 'F16129', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4128, 'Hallucinogen abuse with hallucinogen-induced mood disorder', '', 'F1614', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4129, 'Hallucinogen abuse with hallucinogen-induced psychotic disorder with delusions', '', 'F16150', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4130, 'Hallucinogen abuse with hallucinogen-induced psychotic disorder with hallucinations', '', 'F16151', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4131, 'Hallucinogen abuse with hallucinogen-induced psychotic disorder, unspecified', '', 'F16159', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4132, 'Hallucinogen abuse with hallucinogen-induced anxiety disorder', '', 'F16180', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4133, 'Hallucinogen abuse with hallucinogen persisting perception disorder (flashbacks)', '', 'F16183', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4134, 'Hallucinogen abuse with other hallucinogen-induced disorder', '', 'F16188', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4135, 'Hallucinogen abuse with unspecified hallucinogen-induced disorder', '', 'F1619', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4136, 'Hallucinogen dependence, uncomplicated', '', 'F1620', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4137, 'Hallucinogen dependence, in remission', '', 'F1621', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4138, 'Hallucinogen dependence with intoxication, uncomplicated', '', 'F16220', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4139, 'Hallucinogen dependence with intoxication with delirium', '', 'F16221', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4140, 'Hallucinogen dependence with intoxication, unspecified', '', 'F16229', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4141, 'Hallucinogen dependence with hallucinogen-induced mood disorder', '', 'F1624', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4142, 'Hallucinogen dependence with hallucinogen-induced psychotic disorder with delusions', '', 'F16250', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4143, 'Hallucinogen dependence with hallucinogen-induced psychotic disorder with hallucinations', '', 'F16251', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4144, 'Hallucinogen dependence with hallucinogen-induced psychotic disorder, unspecified', '', 'F16259', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4145, 'Hallucinogen dependence with hallucinogen-induced anxiety disorder', '', 'F16280', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4146, 'Hallucinogen dependence with hallucinogen persisting perception disorder (flashbacks)', '', 'F16283', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4147, 'Hallucinogen dependence with other hallucinogen-induced disorder', '', 'F16288', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4148, 'Hallucinogen dependence with unspecified hallucinogen-induced disorder', '', 'F1629', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4149, 'Hallucinogen use, unspecified, uncomplicated', '', 'F1690', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4150, 'Hallucinogen use, unspecified with intoxication, uncomplicated', '', 'F16920', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4151, 'Hallucinogen use, unspecified with intoxication with delirium', '', 'F16921', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4152, 'Hallucinogen use, unspecified with intoxication, unspecified', '', 'F16929', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4153, 'Hallucinogen use, unspecified with hallucinogen-induced mood disorder', '', 'F1694', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4154, 'Hallucinogen use, unspecified with hallucinogen-induced psychotic disorder with delusions', '', 'F16950', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4155, 'Hallucinogen use, unspecified with hallucinogen-induced psychotic disorder with hallucinations', '', 'F16951', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4156, 'Hallucinogen use, unspecified with hallucinogen-induced psychotic disorder, unspecified', '', 'F16959', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4157, 'Hallucinogen use, unspecified with hallucinogen-induced anxiety disorder', '', 'F16980', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4158, 'Hallucinogen use, unspecified with hallucinogen persisting perception disorder (flashbacks)', '', 'F16983', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4159, 'Hallucinogen use, unspecified with other hallucinogen-induced disorder', '', 'F16988', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4160, 'Hallucinogen use, unspecified with unspecified hallucinogen-induced disorder', '', 'F1699', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4161, 'Nicotine dependence, unspecified, uncomplicated', '', 'F17200', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4162, 'Nicotine dependence, unspecified, in remission', '', 'F17201', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4163, 'Nicotine dependence unspecified, with withdrawal', '', 'F17203', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4164, 'Nicotine dependence, unspecified, with other nicotine-induced disorders', '', 'F17208', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4165, 'Nicotine dependence, unspecified, with unspecified nicotine-induced disorders', '', 'F17209', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4166, 'Nicotine dependence, cigarettes, uncomplicated', '', 'F17210', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4167, 'Nicotine dependence, cigarettes, in remission', '', 'F17211', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4168, 'Nicotine dependence, cigarettes, with withdrawal', '', 'F17213', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4169, 'Nicotine dependence, cigarettes, with other nicotine-induced disorders', '', 'F17218', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4170, 'Nicotine dependence, cigarettes, with unspecified nicotine-induced disorders', '', 'F17219', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4171, 'Nicotine dependence, chewing tobacco, uncomplicated', '', 'F17220', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4172, 'Nicotine dependence, chewing tobacco, in remission', '', 'F17221', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4173, 'Nicotine dependence, chewing tobacco, with withdrawal', '', 'F17223', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4174, 'Nicotine dependence, chewing tobacco, with other nicotine-induced disorders', '', 'F17228', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4175, 'Nicotine dependence, chewing tobacco, with unspecified nicotine-induced disorders', '', 'F17229', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4176, 'Nicotine dependence, other tobacco product, uncomplicated', '', 'F17290', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4177, 'Nicotine dependence, other tobacco product, in remission', '', 'F17291', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4178, 'Nicotine dependence, other tobacco product, with withdrawal', '', 'F17293', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4179, 'Nicotine dependence, other tobacco product, with other nicotine-induced disorders', '', 'F17298', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4180, 'Nicotine dependence, other tobacco product, with unspecified nicotine-induced disorders', '', 'F17299', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4181, 'Inhalant abuse, uncomplicated', '', 'F1810', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1);");


DB::statement("INSERT INTO `symptoms` (`id`, `symptoms_title`, `description`, `code`, `status`, `priority`, `created_at`, `updated_at`, `type`) VALUES
(4182, 'Inhalant abuse with intoxication, uncomplicated', '', 'F18120', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4183, 'Inhalant abuse with intoxication delirium', '', 'F18121', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4184, 'Inhalant abuse with intoxication, unspecified', '', 'F18129', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4185, 'Inhalant abuse with inhalant-induced mood disorder', '', 'F1814', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4186, 'Inhalant abuse with inhalant-induced psychotic disorder with delusions', '', 'F18150', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4187, 'Inhalant abuse with inhalant-induced psychotic disorder with hallucinations', '', 'F18151', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4188, 'Inhalant abuse with inhalant-induced psychotic disorder, unspecified', '', 'F18159', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4189, 'Inhalant abuse with inhalant-induced dementia', '', 'F1817', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4190, 'Inhalant abuse with inhalant-induced anxiety disorder', '', 'F18180', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4191, 'Inhalant abuse with other inhalant-induced disorder', '', 'F18188', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4192, 'Inhalant abuse with unspecified inhalant-induced disorder', '', 'F1819', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4193, 'Inhalant dependence, uncomplicated', '', 'F1820', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4194, 'Inhalant dependence, in remission', '', 'F1821', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4195, 'Inhalant dependence with intoxication, uncomplicated', '', 'F18220', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4196, 'Inhalant dependence with intoxication delirium', '', 'F18221', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4197, 'Inhalant dependence with intoxication, unspecified', '', 'F18229', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4198, 'Inhalant dependence with inhalant-induced mood disorder', '', 'F1824', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4199, 'Inhalant dependence with inhalant-induced psychotic disorder with delusions', '', 'F18250', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4200, 'Inhalant dependence with inhalant-induced psychotic disorder with hallucinations', '', 'F18251', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4201, 'Inhalant dependence with inhalant-induced psychotic disorder, unspecified', '', 'F18259', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4202, 'Inhalant dependence with inhalant-induced dementia', '', 'F1827', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4203, 'Inhalant dependence with inhalant-induced anxiety disorder', '', 'F18280', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4204, 'Inhalant dependence with other inhalant-induced disorder', '', 'F18288', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4205, 'Inhalant dependence with unspecified inhalant-induced disorder', '', 'F1829', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4206, 'Inhalant use, unspecified, uncomplicated', '', 'F1890', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4207, 'Inhalant use, unspecified with intoxication, uncomplicated', '', 'F18920', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4208, 'Inhalant use, unspecified with intoxication with delirium', '', 'F18921', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4209, 'Inhalant use, unspecified with intoxication, unspecified', '', 'F18929', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4210, 'Inhalant use, unspecified with inhalant-induced mood disorder', '', 'F1894', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4211, 'Inhalant use, unspecified with inhalant-induced psychotic disorder with delusions', '', 'F18950', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4212, 'Inhalant use, unspecified with inhalant-induced psychotic disorder with hallucinations', '', 'F18951', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4213, 'Inhalant use, unspecified with inhalant-induced psychotic disorder, unspecified', '', 'F18959', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4214, 'Inhalant use, unspecified with inhalant-induced persisting dementia', '', 'F1897', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4215, 'Inhalant use, unspecified with inhalant-induced anxiety disorder', '', 'F18980', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4216, 'Inhalant use, unspecified with other inhalant-induced disorder', '', 'F18988', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4217, 'Inhalant use, unspecified with unspecified inhalant-induced disorder', '', 'F1899', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4218, 'Other psychoactive substance abuse, uncomplicated', '', 'F1910', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4219, 'Other psychoactive substance abuse with intoxication, uncomplicated', '', 'F19120', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4220, 'Other psychoactive substance abuse with intoxication delirium', '', 'F19121', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4221, 'Other psychoactive substance abuse with intoxication with perceptual disturbances', '', 'F19122', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4222, 'Other psychoactive substance abuse with intoxication, unspecified', '', 'F19129', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4223, 'Other psychoactive substance abuse with psychoactive substance-induced mood disorder', '', 'F1914', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4224, 'Other psychoactive substance abuse with psychoactive substance-induced psychotic disorder\nwith delusions', '', 'F19150', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4225, 'Other psychoactive substance abuse with psychoactive substance-induced psychotic disorder\nwith hallucinations', '', 'F19151', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4226, 'Other psychoactive substance abuse with psychoactive substance-induced psychotic disorder,\nunspecified', '', 'F19159', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4227, 'Other psychoactive substance abuse with psychoactive substance-induced persisting amnestic\ndisorder', '', 'F1916', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4228, 'Other psychoactive substance abuse with psychoactive substance-induced persisting dementia', '', 'F1917', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4229, 'Other psychoactive substance abuse with psychoactive substance-induced anxiety disorder', '', 'F19180', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4230, 'Other psychoactive substance abuse with psychoactive substance-induced sexual dysfunction', '', 'F19181', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4231, 'Other psychoactive substance abuse with psychoactive substance-induced sleep disorder', '', 'F19182', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4232, 'Other psychoactive substance abuse with other psychoactive substance-induced disorder', '', 'F19188', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4233, 'Other psychoactive substance abuse with unspecified psychoactive substance-induced disorder', '', 'F1919', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4234, 'Other psychoactive substance dependence, uncomplicated', '', 'F1920', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4235, 'Other psychoactive substance dependence, in remission', '', 'F1921', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4236, 'Other psychoactive substance dependence with intoxication, uncomplicated', '', 'F19220', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4237, 'Other psychoactive substance dependence with intoxication delirium', '', 'F19221', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4238, 'Other psychoactive substance dependence with intoxication with perceptual disturbance', '', 'F19222', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4239, 'Other psychoactive substance dependence with intoxication, unspecified', '', 'F19229', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4240, 'Other psychoactive substance dependence with withdrawal, uncomplicated', '', 'F19230', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4241, 'Other psychoactive substance dependence with withdrawal delirium', '', 'F19231', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4242, 'Other psychoactive substance dependence with withdrawal with perceptual disturbance', '', 'F19232', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4243, 'Other psychoactive substance dependence with withdrawal, unspecified', '', 'F19239', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4244, 'Other psychoactive substance dependence with psychoactive substance-induced mood disorder', '', 'F1924', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4245, 'Other psychoactive substance dependence with psychoactive substance-induced psychotic\ndisorder with delusions', '', 'F19250', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4246, 'Other psychoactive substance dependence with psychoactive substance-induced psychotic\ndisorder with hallucinations', '', 'F19251', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4247, 'Other psychoactive substance dependence with psychoactive substance-induced psychotic\ndisorder, unspecified', '', 'F19259', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4248, 'Other psychoactive substance dependence with psychoactive substance-induced persisting\namnestic disorder', '', 'F1926', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4249, 'Other psychoactive substance dependence with psychoactive substance-induced persisting\ndementia', '', 'F1927', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4250, 'Other psychoactive substance dependence with psychoactive substance-induced anxiety\ndisorder', '', 'F19280', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4251, 'Other psychoactive substance dependence with psychoactive substance-induced sexual\ndysfunction', '', 'F19281', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4252, 'Other psychoactive substance dependence with psychoactive substance-induced sleep disorder', '', 'F19282', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4253, 'Other psychoactive substance dependence with other psychoactive substance-induced disorder', '', 'F19288', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4254, 'Other psychoactive substance dependence with unspecified psychoactive substance-induced\ndisorder', '', 'F1929', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4255, 'Other psychoactive substance use, unspecified, uncomplicated', '', 'F1990', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4256, 'Other psychoactive substance use, unspecified with intoxication, uncomplicated', '', 'F19920', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4257, 'Other psychoactive substance use, unspecified with intoxication with delirium', '', 'F19921', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4258, 'Other psychoactive substance use, unspecified with intoxication with perceptual disturbance', '', 'F19922', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4259, 'Other psychoactive substance use, unspecified with intoxication, unspecified', '', 'F19929', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4260, 'Other psychoactive substance use, unspecified with withdrawal, uncomplicated', '', 'F19930', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4261, 'Other psychoactive substance use, unspecified with withdrawal delirium', '', 'F19931', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4262, 'Other psychoactive substance use, unspecified with withdrawal with perceptual disturbance', '', 'F19932', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4263, 'Other psychoactive substance use, unspecified with withdrawal, unspecified', '', 'F19939', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4264, 'Other psychoactive substance use, unspecified with psychoactive substance-induced mood\ndisorder', '', 'F1994', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4265, 'Other psychoactive substance use, unspecified with psychoactive substance-induced psychotic\ndisorder with delusions', '', 'F19950', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4266, 'Other psychoactive substance use, unspecified with psychoactive substance-induced psychotic\ndisorder with hallucinations', '', 'F19951', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4267, 'Other psychoactive substance use, unspecified with psychoactive substance-induced psychotic\ndisorder, unspecified', '', 'F19959', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4268, 'Other psychoactive substance use, unspecified with psychoactive substance-induced persisting\namnestic disorder', '', 'F1996', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4269, 'Other psychoactive substance use, unspecified with psychoactive substance-induced persisting\ndementia', '', 'F1997', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4270, 'Other psychoactive substance use, unspecified with psychoactive substance-induced anxiety\ndisorder', '', 'F19980', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4271, 'Other psychoactive substance use, unspecified with psychoactive substance-induced sexual\ndysfunction', '', 'F19981', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4272, 'Other psychoactive substance use, unspecified with psychoactive substance-induced sleep\ndisorder', '', 'F19982', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4273, 'Other psychoactive substance use, unspecified with other psychoactive substance-induced\ndisorder', '', 'F19988', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4274, 'Other psychoactive substance use, unspecified with unspecified psychoactive substance-induced\ndisorder', '', 'F1999', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4275, 'Paranoid schizophrenia', '', 'F200', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4276, 'Disorganized schizophrenia', '', 'F201', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4277, 'Catatonic schizophrenia', '', 'F202', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4278, 'Undifferentiated schizophrenia', '', 'F203', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4279, 'Residual schizophrenia', '', 'F205', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4280, 'Schizophreniform disorder', '', 'F2081', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4281, 'Other schizophrenia', '', 'F2089', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4282, 'Schizophrenia, unspecified', '', 'F209', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4283, 'Schizotypal disorder', '', 'F21', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4284, 'Delusional disorders', '', 'F22', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4285, 'Brief psychotic disorder', '', 'F23', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4286, 'Shared psychotic disorder', '', 'F24', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4287, 'Schizoaffective disorder, bipolar type', '', 'F250', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4288, 'Schizoaffective disorder, depressive type', '', 'F251', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4289, 'Other schizoaffective disorders', '', 'F258', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4290, 'Schizoaffective disorder, unspecified', '', 'F259', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4291, 'Other psychotic disorder not due to a substance or known physiological condition', '', 'F28', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4292, 'Unspecified psychosis not due to a substance or known physiological condition', '', 'F29', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4293, 'Manic episode without psychotic symptoms, unspecified', '', 'F3010', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4294, 'Manic episode without psychotic symptoms, mild', '', 'F3011', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4295, 'Manic episode without psychotic symptoms, moderate', '', 'F3012', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4296, 'Manic episode, severe, without psychotic symptoms', '', 'F3013', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4297, 'Manic episode, severe with psychotic symptoms', '', 'F302', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4298, 'Manic episode in partial remission', '', 'F303', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4299, 'Manic episode in full remission', '', 'F304', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4300, 'Other manic episodes', '', 'F308', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4301, 'Manic episode, unspecified', '', 'F309', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4302, 'Bipolar disorder, current episode hypomanic', '', 'F310', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4303, 'Bipolar disorder, current episode manic without psychotic features, unspecified', '', 'F3110', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4304, 'Bipolar disorder, current episode manic without psychotic features, mild', '', 'F3111', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4305, 'Bipolar disorder, current episode manic without psychotic features, moderate', '', 'F3112', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4306, 'Bipolar disorder, current episode manic without psychotic features, severe', '', 'F3113', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4307, 'Bipolar disorder, current episode manic severe with psychotic features', '', 'F312', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4308, 'Bipolar disorder, current episode depressed, mild or moderate severity, unspecified', '', 'F3130', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4309, 'Bipolar disorder, current episode depressed, mild', '', 'F3131', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4310, 'Bipolar disorder, current episode depressed, moderate', '', 'F3132', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4311, 'Bipolar disorder, current episode depressed, severe, without psychotic features', '', 'F314', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4312, 'Bipolar disorder, current episode depressed, severe, with psychotic features', '', 'F315', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4313, 'Bipolar disorder, current episode mixed, unspecified', '', 'F3160', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4314, 'Bipolar disorder, current episode mixed, mild', '', 'F3161', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4315, 'Bipolar disorder, current episode mixed, moderate', '', 'F3162', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4316, 'Bipolar disorder, current episode mixed, severe, without psychotic features', '', 'F3163', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4317, 'Bipolar disorder, current episode mixed, severe, with psychotic features', '', 'F3164', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4318, 'Bipolar disorder, currently in remission, most recent episode unspecified', '', 'F3170', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4319, 'Bipolar disorder, in partial remission, most recent episode hypomanic', '', 'F3171', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4320, 'Bipolar disorder, in full remission, most recent episode hypomanic', '', 'F3172', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4321, 'Bipolar disorder, in partial remission, most recent episode manic', '', 'F3173', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4322, 'Bipolar disorder, in full remission, most recent episode manic', '', 'F3174', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4323, 'Bipolar disorder, in partial remission, most recent episode depressed', '', 'F3175', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4324, 'Bipolar disorder, in full remission, most recent episode depressed', '', 'F3176', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4325, 'Bipolar disorder, in partial remission, most recent episode mixed', '', 'F3177', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4326, 'Bipolar disorder, in full remission, most recent episode mixed', '', 'F3178', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4327, 'Bipolar II disorder', '', 'F3181', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4328, 'Other bipolar disorder', '', 'F3189', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4329, 'Bipolar disorder, unspecified', '', 'F319', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4330, 'Major depressive disorder, single episode, mild', '', 'F320', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4331, 'Major depressive disorder, single episode, moderate', '', 'F321', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4332, 'Major depressive disorder, single episode, severe without psychotic features', '', 'F322', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4333, 'Major depressive disorder, single episode, severe with psychotic features', '', 'F323', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4334, 'Major depressive disorder, single episode, in partial remission', '', 'F324', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4335, 'Major depressive disorder, single episode, in full remission', '', 'F325', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4336, 'Premenstrual dysphoric disorder', '', 'F3281', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4337, 'Other specified depressive episodes', '', 'F3289', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4338, 'Major depressive disorder, single episode, unspecified', '', 'F329', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4339, 'Major depressive disorder, recurrent, mild', '', 'F330', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4340, 'Major depressive disorder, recurrent, moderate', '', 'F331', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4341, 'Major depressive disorder, recurrent severe without psychotic features', '', 'F332', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4342, 'Major depressive disorder, recurrent, severe with psychotic symptoms', '', 'F333', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4343, 'Major depressive disorder, recurrent, in remission, unspecified', '', 'F3340', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4344, 'Major depressive disorder, recurrent, in partial remission', '', 'F3341', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4345, 'Major depressive disorder, recurrent, in full remission', '', 'F3342', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4346, 'Other recurrent depressive disorders', '', 'F338', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4347, 'Major depressive disorder, recurrent, unspecified', '', 'F339', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4348, 'Cyclothymic disorder', '', 'F340', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4349, 'Dysthymic disorder', '', 'F341', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4350, 'Disruptive mood dysregulation disorder', '', 'F3481', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4351, 'Other specified persistent mood disorders', '', 'F3489', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4352, 'Persistent mood [affective] disorder, unspecified', '', 'F349', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4353, 'Unspecified mood [affective] disorder', '', 'F39', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4354, 'Agoraphobia, unspecified', '', 'F4000', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4355, 'Agoraphobia with panic disorder', '', 'F4001', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4356, 'Agoraphobia without panic disorder', '', 'F4002', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4357, 'Social phobia, unspecified', '', 'F4010', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4358, 'Social phobia, generalized', '', 'F4011', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4359, 'Arachnophobia', '', 'F40210', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4360, 'Other animal type phobia', '', 'F40218', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4361, 'Fear of thunderstorms', '', 'F40220', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4362, 'Other natural environment type phobia', '', 'F40228', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4363, 'Fear of blood', '', 'F40230', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4364, 'Fear of injections and transfusions', '', 'F40231', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4365, 'Fear of other medical care', '', 'F40232', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4366, 'Fear of injury', '', 'F40233', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4367, 'Claustrophobia', '', 'F40240', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4368, 'Acrophobia', '', 'F40241', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4369, 'Fear of bridges', '', 'F40242', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4370, 'Fear of flying', '', 'F40243', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4371, 'Other situational type phobia', '', 'F40248', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4372, 'Androphobia', '', 'F40290', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4373, 'Gynephobia', '', 'F40291', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4374, 'Other specified phobia', '', 'F40298', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4375, 'Other phobic anxiety disorders', '', 'F408', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4376, 'Phobic anxiety disorder, unspecified', '', 'F409', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4377, 'Panic disorder [episodic paroxysmal anxiety] without agoraphobia', '', 'F410', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4378, 'Generalized anxiety disorder', '', 'F411', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4379, 'Other mixed anxiety disorders', '', 'F413', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4380, 'Other specified anxiety disorders', '', 'F418', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4381, 'Anxiety disorder, unspecified', '', 'F419', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4382, 'Mixed obsessional thoughts and acts', '', 'F422', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4383, 'Hoarding disorder', '', 'F423', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4384, 'Excoriation (skin-picking) disorder', '', 'F424', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4385, 'Other obsessive-compulsive disorder', '', 'F428', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4386, 'Obsessive-compulsive disorder, unspecified', '', 'F429', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4387, 'Acute stress reaction', '', 'F430', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4388, 'Post-traumatic stress disorder, unspecified', '', 'F4310', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4389, 'Post-traumatic stress disorder, acute', '', 'F4311', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4390, 'Post-traumatic stress disorder, chronic', '', 'F4312', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4391, 'Adjustment disorder, unspecified', '', 'F4320', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4392, 'Adjustment disorder with depressed mood', '', 'F4321', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4393, 'Adjustment disorder with anxiety', '', 'F4322', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4394, 'Adjustment disorder with mixed anxiety and depressed mood', '', 'F4323', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4395, 'Adjustment disorder with disturbance of conduct', '', 'F4324', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4396, 'Adjustment disorder with mixed disturbance of emotions and conduct', '', 'F4325', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4397, 'Adjustment disorder with other symptoms', '', 'F4329', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4398, 'Other reactions to severe stress', '', 'F438', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4399, 'Reaction to severe stress, unspecified', '', 'F439', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4400, 'Dissociative amnesia', '', 'F440', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4401, 'Dissociative fugue', '', 'F441', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4402, 'Dissociative stupor', '', 'F442', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4403, 'Conversion disorder with motor symptom or deficit', '', 'F444', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4404, 'Conversion disorder with seizures or convulsions', '', 'F445', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4405, 'Conversion disorder with sensory symptom or deficit', '', 'F446', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4406, 'Conversion disorder with mixed symptom presentation', '', 'F447', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4407, 'Dissociative identity disorder', '', 'F4481', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4408, 'Other dissociative and conversion disorders', '', 'F4489', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4409, 'Dissociative and conversion disorder, unspecified', '', 'F449', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4410, 'Somatization disorder', '', 'F450', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4411, 'Undifferentiated somatoform disorder', '', 'F451', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4412, 'Hypochondriacal disorder, unspecified', '', 'F4520', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4413, 'Hypochondriasis', '', 'F4521', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4414, 'Body dysmorphic disorder', '', 'F4522', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4415, 'Other hypochondriacal disorders', '', 'F4529', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4416, 'Pain disorder exclusively related to psychological factors', '', 'F4541', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4417, 'Pain disorder with related psychological factors', '', 'F4542', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4418, 'Other somatoform disorders', '', 'F458', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4419, 'Somatoform disorder, unspecified', '', 'F459', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4420, 'Depersonalization-derealization syndrome', '', 'F481', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4421, 'Pseudobulbar affect', '', 'F482', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4422, 'Other specified nonpsychotic mental disorders', '', 'F488', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4423, 'Nonpsychotic mental disorder, unspecified', '', 'F489', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4424, 'Anorexia nervosa, unspecified', '', 'F5000', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4425, 'Anorexia nervosa, restricting type', '', 'F5001', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4426, 'Anorexia nervosa, binge eating/purging type', '', 'F5002', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4427, 'Bulimia nervosa', '', 'F502', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4428, 'Binge eating disorder', '', 'F5081', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4429, 'Other specified eating disorder', '', 'F5089', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4430, 'Eating disorder, unspecified', '', 'F509', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4431, 'Primary insomnia', '', 'F5101', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4432, 'Adjustment insomnia', '', 'F5102', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4433, 'Paradoxical insomnia', '', 'F5103', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4434, 'Psychophysiologic insomnia', '', 'F5104', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4435, 'Insomnia due to other mental disorder', '', 'F5105', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4436, 'Other insomnia not due to a substance or known physiological condition', '', 'F5109', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4437, 'Primary hypersomnia', '', 'F5111', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4438, 'Insufficient sleep syndrome', '', 'F5112', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4439, 'Hypersomnia due to other mental disorder', '', 'F5113', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4440, 'Other hypersomnia not due to a substance or known physiological condition', '', 'F5119', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4441, 'Sleepwalking [somnambulism]', '', 'F513', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4442, 'Sleep terrors [night terrors]', '', 'F514', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4443, 'Nightmare disorder', '', 'F515', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4444, 'Other sleep disorders not due to a substance or known physiological condition', '', 'F518', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4445, 'Sleep disorder not due to a substance or known physiological condition, unspecified', '', 'F519', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4446, 'Hypoactive sexual desire disorder', '', 'F520', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4447, 'Sexual aversion disorder', '', 'F521', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4448, 'Male erectile disorder', '', 'F5221', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4449, 'Female sexual arousal disorder', '', 'F5222', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4450, 'Female orgasmic disorder', '', 'F5231', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4451, 'Male orgasmic disorder', '', 'F5232', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4452, 'Premature ejaculation', '', 'F524', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4453, 'Vaginismus not due to a substance or known physiological condition', '', 'F525', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4454, 'Dyspareunia not due to a substance or known physiological condition', '', 'F526', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4455, 'Other sexual dysfunction not due to a substance or known physiological condition', '', 'F528', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4456, 'Unspecified sexual dysfunction not due to a substance or known physiological condition', '', 'F529', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4457, 'Puerperal psychosis', '', 'F53', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4458, 'Psychological and behavioral factors associated with disorders or diseases classified elsewhere', '', 'F54', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4459, 'Abuse of antacids', '', 'F550', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4460, 'Abuse of herbal or folk remedies', '', 'F551', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4461, 'Abuse of laxatives', '', 'F552', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4462, 'Abuse of steroids or hormones', '', 'F553', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4463, 'Abuse of vitamins', '', 'F554', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4464, 'Abuse of other non-psychoactive substances', '', 'F558', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4465, 'Unspecified behavioral syndromes associated with physiological disturbances and physical factors', '', 'F59', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4466, 'Paranoid personality disorder', '', 'F600', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4467, 'Schizoid personality disorder', '', 'F601', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4468, 'Antisocial personality disorder', '', 'F602', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4469, 'Borderline personality disorder', '', 'F603', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4470, 'Histrionic personality disorder', '', 'F604', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4471, 'Obsessive-compulsive personality disorder', '', 'F605', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4472, 'Avoidant personality disorder', '', 'F606', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4473, 'Dependent personality disorder', '', 'F607', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4474, 'Narcissistic personality disorder', '', 'F6081', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4475, 'Other specific personality disorders', '', 'F6089', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4476, 'Personality disorder, unspecified', '', 'F609', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4477, 'Pathological gambling', '', 'F630', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4478, 'Pyromania', '', 'F631', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4479, 'Kleptomania', '', 'F632', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4480, 'Trichotillomania', '', 'F633', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4481, 'Intermittent explosive disorder', '', 'F6381', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4482, 'Other impulse disorders', '', 'F6389', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4483, 'Impulse disorder, unspecified', '', 'F639', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4484, 'Transsexualism', '', 'F640', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4485, 'Dual role transvestism', '', 'F641', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4486, 'Gender identity disorder of childhood', '', 'F642', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4487, 'Other gender identity disorders', '', 'F648', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4488, 'Gender identity disorder, unspecified', '', 'F649', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4489, 'Fetishism', '', 'F650', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4490, 'Transvestic fetishism', '', 'F651', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4491, 'Exhibitionism', '', 'F652', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4492, 'Voyeurism', '', 'F653', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4493, 'Pedophilia', '', 'F654', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4494, 'Sadomasochism, unspecified', '', 'F6550', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4495, 'Sexual masochism', '', 'F6551', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4496, 'Sexual sadism', '', 'F6552', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4497, 'Frotteurism', '', 'F6581', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4498, 'Other paraphilias', '', 'F6589', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4499, 'Paraphilia, unspecified', '', 'F659', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4500, 'Other sexual disorders', '', 'F66', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4501, 'Factitious disorder, unspecified', '', 'F6810', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4502, 'Factitious disorder with predominantly psychological signs and symptoms', '', 'F6811', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4503, 'Factitious disorder with predominantly physical signs and symptoms', '', 'F6812', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4504, 'Factitious disorder with combined psychological and physical signs and symptoms', '', 'F6813', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4505, 'Other specified disorders of adult personality and behavior', '', 'F688', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4506, 'Unspecified disorder of adult personality and behavior', '', 'F69', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4507, 'Mild intellectual disabilities', '', 'F70', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4508, 'Moderate intellectual disabilities', '', 'F71', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4509, 'Severe intellectual disabilities', '', 'F72', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4510, 'Profound intellectual disabilities', '', 'F73', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4511, 'Other intellectual disabilities', '', 'F78', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4512, 'Unspecified intellectual disabilities', '', 'F79', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4513, 'Phonological disorder', '', 'F800', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4514, 'Expressive language disorder', '', 'F801', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4515, 'Mixed receptive-expressive language disorder', '', 'F802', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4516, 'Speech and language development delay due to hearing loss', '', 'F804', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4517, 'Childhood onset fluency disorder', '', 'F8081', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4518, 'Social pragmatic communication disorder', '', 'F8082', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4519, 'Other developmental disorders of speech and language', '', 'F8089', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4520, 'Developmental disorder of speech and language, unspecified', '', 'F809', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4521, 'Specific reading disorder', '', 'F810', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4522, 'Mathematics disorder', '', 'F812', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4523, 'Disorder of written expression', '', 'F8181', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4524, 'Other developmental disorders of scholastic skills', '', 'F8189', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4525, 'Developmental disorder of scholastic skills, unspecified', '', 'F819', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4526, 'Specific developmental disorder of motor function', '', 'F82', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4527, 'Autistic disorder', '', 'F840', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4528, 'Rett\'s syndrome', '', 'F842', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4529, 'Other childhood disintegrative disorder', '', 'F843', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4530, 'Asperger\'s syndrome', '', 'F845', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4531, 'Other pervasive developmental disorders', '', 'F848', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4532, 'Pervasive developmental disorder, unspecified', '', 'F849', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4533, 'Other disorders of psychological development', '', 'F88', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4534, 'Unspecified disorder of psychological development', '', 'F89', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4535, 'Attention-deficit hyperactivity disorder, predominantly inattentive type', '', 'F900', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4536, 'Attention-deficit hyperactivity disorder, predominantly hyperactive type', '', 'F901', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4537, 'Attention-deficit hyperactivity disorder, combined type', '', 'F902', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4538, 'Attention-deficit hyperactivity disorder, other type', '', 'F908', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4539, 'Attention-deficit hyperactivity disorder, unspecified type', '', 'F909', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4540, 'Conduct disorder confined to family context', '', 'F910', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4541, 'Conduct disorder, childhood-onset type', '', 'F911', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4542, 'Conduct disorder, adolescent-onset type', '', 'F912', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4543, 'Oppositional defiant disorder', '', 'F913', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4544, 'Other conduct disorders', '', 'F918', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4545, 'Conduct disorder, unspecified', '', 'F919', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4546, 'Separation anxiety disorder of childhood', '', 'F930', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4547, 'Other childhood emotional disorders', '', 'F938', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4548, 'Childhood emotional disorder, unspecified', '', 'F939', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4549, 'Selective mutism', '', 'F940', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4550, 'Reactive attachment disorder of childhood', '', 'F941', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4551, 'Disinhibited attachment disorder of childhood', '', 'F942', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4552, 'Other childhood disorders of social functioning', '', 'F948', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4553, 'Childhood disorder of social functioning, unspecified', '', 'F949', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4554, 'Transient tic disorder', '', 'F950', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4555, 'Chronic motor or vocal tic disorder', '', 'F951', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4556, 'Tourette\'s disorder', '', 'F952', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4557, 'Other tic disorders', '', 'F958', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4558, 'Tic disorder, unspecified', '', 'F959', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4559, 'Enuresis not due to a substance or known physiological condition', '', 'F980', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4560, 'Encopresis not due to a substance or known physiological condition', '', 'F981', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4561, 'Rumination disorder of infancy', '', 'F9821', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4562, 'Other feeding disorders of infancy and early childhood', '', 'F9829', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4563, 'Pica of infancy and childhood', '', 'F983', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4564, 'Stereotyped movement disorders', '', 'F984', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4565, 'Adult onset fluency disorder', '', 'F985', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4566, 'Other specified behavioral and emotional disorders with onset usually occurring in childhood and\nadolescence', '', 'F988', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4567, 'Unspecified behavioral and emotional disorders with onset usually occurring in childhood and\nadolescence', '', 'F989', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4568, 'Mental disorder, not otherwise specified', '', 'F99', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4569, 'Hemophilus meningitis', '', 'G000', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1);");

DB::statement("INSERT INTO `symptoms` (`id`, `symptoms_title`, `description`, `code`, `status`, `priority`, `created_at`, `updated_at`, `type`) VALUES
(4570, 'Pneumococcal meningitis', '', 'G001', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4571, 'Streptococcal meningitis', '', 'G002', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4572, 'Staphylococcal meningitis', '', 'G003', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4573, 'Other bacterial meningitis', '', 'G008', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4574, 'Bacterial meningitis, unspecified', '', 'G009', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4575, 'Meningitis in bacterial diseases classified elsewhere', '', 'G01', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4576, 'Meningitis in other infectious and parasitic diseases classified elsewhere', '', 'G02', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4577, 'Nonpyogenic meningitis', '', 'G030', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4578, 'Chronic meningitis', '', 'G031', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4579, 'Benign recurrent meningitis [Mollaret]', '', 'G032', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4580, 'Meningitis due to other specified causes', '', 'G038', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4581, 'Meningitis, unspecified', '', 'G039', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4582, 'Acute disseminated encephalitis and encephalomyelitis, unspecified', '', 'G0400', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4583, 'Postinfectious acute disseminated encephalitis and encephalomyelitis (postinfectious ADEM)', '', 'G0401', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4584, 'Postimmunization acute disseminated encephalitis, myelitis and encephalomyelitis', '', 'G0402', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4585, 'Tropical spastic paraplegia', '', 'G041', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4586, 'Bacterial meningoencephalitis and meningomyelitis, not elsewhere classified', '', 'G042', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4587, 'Acute necrotizing hemorrhagic encephalopathy, unspecified', '', 'G0430', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4588, 'Postinfectious acute necrotizing hemorrhagic encephalopathy', '', 'G0431', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4589, 'Postimmunization acute necrotizing hemorrhagic encephalopathy', '', 'G0432', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4590, 'Other acute necrotizing hemorrhagic encephalopathy', '', 'G0439', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4591, 'Other encephalitis and encephalomyelitis', '', 'G0481', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4592, 'Other myelitis', '', 'G0489', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4593, 'Encephalitis and encephalomyelitis, unspecified', '', 'G0490', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4594, 'Myelitis, unspecified', '', 'G0491', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4595, 'Encephalitis and encephalomyelitis in diseases classified elsewhere', '', 'G053', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4596, 'Myelitis in diseases classified elsewhere', '', 'G054', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4597, 'Intracranial abscess and granuloma', '', 'G060', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4598, 'Intraspinal abscess and granuloma', '', 'G061', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4599, 'Extradural and subdural abscess, unspecified', '', 'G062', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4600, 'Intracranial and intraspinal abscess and granuloma in diseases classified elsewhere', '', 'G07', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4601, 'Intracranial and intraspinal phlebitis and thrombophlebitis', '', 'G08', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4602, 'Sequelae of inflammatory diseases of central nervous system', '', 'G09', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4603, 'Huntington\'s disease', '', 'G10', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4604, 'Congenital nonprogressive ataxia', '', 'G110', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4605, 'Early-onset cerebellar ataxia', '', 'G111', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4606, 'Late-onset cerebellar ataxia', '', 'G112', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4607, 'Cerebellar ataxia with defective DNA repair', '', 'G113', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4608, 'Hereditary spastic paraplegia', '', 'G114', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4609, 'Other hereditary ataxias', '', 'G118', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4610, 'Hereditary ataxia, unspecified', '', 'G119', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4611, 'Infantile spinal muscular atrophy, type I [Werdnig-Hoffman]', '', 'G120', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4612, 'Other inherited spinal muscular atrophy', '', 'G121', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4613, 'Motor neuron disease, unspecified', '', 'G1220', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4614, 'Amyotrophic lateral sclerosis', '', 'G1221', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4615, 'Progressive bulbar palsy', '', 'G1222', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4616, 'Other motor neuron disease', '', 'G1229', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4617, 'Other spinal muscular atrophies and related syndromes', '', 'G128', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4618, 'Spinal muscular atrophy, unspecified', '', 'G129', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4619, 'Paraneoplastic neuromyopathy and neuropathy', '', 'G130', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4620, 'Other systemic atrophy primarily affecting central nervous system in neoplastic disease', '', 'G131', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4621, 'Systemic atrophy primarily affecting the central nervous system in myxedema', '', 'G132', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4622, 'Systemic atrophy primarily affecting central nervous system in other diseases classified\nelsewhere', '', 'G138', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4623, 'Postpolio syndrome', '', 'G14', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4624, 'Parkinson\'s disease', '', 'G20', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4625, 'Malignant neuroleptic syndrome', '', 'G210', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4626, 'Neuroleptic induced parkinsonism', '', 'G2111', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4627, 'Other drug induced secondary parkinsonism', '', 'G2119', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4628, 'Secondary parkinsonism due to other external agents', '', 'G212', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4629, 'Postencephalitic parkinsonism', '', 'G213', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4630, 'Vascular parkinsonism', '', 'G214', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4631, 'Other secondary parkinsonism', '', 'G218', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4632, 'Secondary parkinsonism, unspecified', '', 'G219', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4633, 'Hallervorden-Spatz disease', '', 'G230', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4634, 'Progressive supranuclear ophthalmoplegia [Steele-Richardson-Olszewski]', '', 'G231', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4635, 'Striatonigral degeneration', '', 'G232', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4636, 'Other specified degenerative diseases of basal ganglia', '', 'G238', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4637, 'Degenerative disease of basal ganglia, unspecified', '', 'G239', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4638, 'Drug induced subacute dyskinesia', '', 'G2401', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4639, 'Drug induced acute dystonia', '', 'G2402', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4640, 'Other drug induced dystonia', '', 'G2409', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4641, 'Genetic torsion dystonia', '', 'G241', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4642, 'Idiopathic nonfamilial dystonia', '', 'G242', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4643, 'Spasmodic torticollis', '', 'G243', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4644, 'Idiopathic orofacial dystonia', '', 'G244', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4645, 'Blepharospasm', '', 'G245', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4646, 'Other dystonia', '', 'G248', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4647, 'Dystonia, unspecified', '', 'G249', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4648, 'Essential tremor', '', 'G250', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4649, 'Drug-induced tremor', '', 'G251', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4650, 'Other specified forms of tremor', '', 'G252', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4651, 'Myoclonus', '', 'G253', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4652, 'Drug-induced chorea', '', 'G254', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4653, 'Other chorea', '', 'G255', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4654, 'Drug induced tics', '', 'G2561', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4655, 'Other tics of organic origin', '', 'G2569', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4656, 'Drug induced movement disorder, unspecified', '', 'G2570', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4657, 'Drug induced akathisia', '', 'G2571', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4658, 'Other drug induced movement disorders', '', 'G2579', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4659, 'Restless legs syndrome', '', 'G2581', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4660, 'Stiff-man syndrome', '', 'G2582', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4661, 'Benign shuddering attacks', '', 'G2583', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4662, 'Other specified extrapyramidal and movement disorders', '', 'G2589', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4663, 'Extrapyramidal and movement disorder, unspecified', '', 'G259', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4664, 'Extrapyramidal and movement disorders in diseases classified elsewhere', '', 'G26', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4665, 'Alzheimer\'s disease with early onset', '', 'G300', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4666, 'Alzheimer\'s disease with late onset', '', 'G301', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4667, 'Other Alzheimer\'s disease', '', 'G308', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4668, 'Alzheimer\'s disease, unspecified', '', 'G309', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4669, 'Pick\'s disease', '', 'G3101', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4670, 'Other frontotemporal dementia', '', 'G3109', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4671, 'Senile degeneration of brain, not elsewhere classified', '', 'G311', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4672, 'Degeneration of nervous system due to alcohol', '', 'G312', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4673, 'Alpers disease', '', 'G3181', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4674, 'Leigh\'s disease', '', 'G3182', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4675, 'Dementia with Lewy bodies', '', 'G3183', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4676, 'Mild cognitive impairment, so stated', '', 'G3184', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4677, 'Corticobasal degeneration', '', 'G3185', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4678, 'Other specified degenerative diseases of nervous system', '', 'G3189', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4679, 'Degenerative disease of nervous system, unspecified', '', 'G319', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4680, 'Subacute combined degeneration of spinal cord in diseases classified elsewhere', '', 'G320', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4681, 'Cerebellar ataxia in diseases classified elsewhere', '', 'G3281', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4682, 'Other specified degenerative disorders of nervous system in diseases classified elsewhere', '', 'G3289', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4683, 'Multiple sclerosis', '', 'G35', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4684, 'Neuromyelitis optica [Devic]', '', 'G360', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4685, 'Acute and subacute hemorrhagic leukoencephalitis [Hurst]', '', 'G361', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4686, 'Other specified acute disseminated demyelination', '', 'G368', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4687, 'Acute disseminated demyelination, unspecified', '', 'G369', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4688, 'Diffuse sclerosis of central nervous system', '', 'G370', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4689, 'Central demyelination of corpus callosum', '', 'G371', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4690, 'Central pontine myelinolysis', '', 'G372', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4691, 'Acute transverse myelitis in demyelinating disease of central nervous system', '', 'G373', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4692, 'Subacute necrotizing myelitis of central nervous system', '', 'G374', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4693, 'Concentric sclerosis [Balo] of central nervous system', '', 'G375', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4694, 'Other specified demyelinating diseases of central nervous system', '', 'G378', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4695, 'Demyelinating disease of central nervous system, unspecified', '', 'G379', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4696, 'Localization-related (focal) (partial) idiopathic epilepsy and epileptic syndromes with seizures of\nlocalized onset, not intractable, with status epilepticus', '', 'G40001', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4697, 'Localization-related (focal) (partial) idiopathic epilepsy and epileptic syndromes with seizures of\nlocalized onset, not intractable, without status epilepticus', '', 'G40009', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4698, 'Localization-related (focal) (partial) idiopathic epilepsy and epileptic syndromes with seizures of\nlocalized onset, intractable, with status epilepticus', '', 'G40011', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4699, 'Localization-related (focal) (partial) idiopathic epilepsy and epileptic syndromes with seizures of\nlocalized onset, intractable, without status epilepticus', '', 'G40019', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4700, 'Localization-related (focal) (partial) symptomatic epilepsy and epileptic syndromes with simple\npartial seizures, not intractable, with status epilepticus', '', 'G40101', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4701, 'Localization-related (focal) (partial) symptomatic epilepsy and epileptic syndromes with simple\npartial seizures, not intractable, without status epilepticus', '', 'G40109', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4702, 'Localization-related (focal) (partial) symptomatic epilepsy and epileptic syndromes with simple\npartial seizures, intractable, with status epilepticus', '', 'G40111', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4703, 'Localization-related (focal) (partial) symptomatic epilepsy and epileptic syndromes with simple\npartial seizures, intractable, without status epilepticus', '', 'G40119', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4704, 'Localization-related (focal) (partial) symptomatic epilepsy and epileptic syndromes with\ncomplex partial seizures, not intractable, with status epilepticus', '', 'G40201', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4705, 'Localization-related (focal) (partial) symptomatic epilepsy and epileptic syndromes with\ncomplex partial seizures, not intractable, without status epilepticus', '', 'G40209', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4706, 'Localization-related (focal) (partial) symptomatic epilepsy and epileptic syndromes with\ncomplex partial seizures, intractable, with status epilepticus', '', 'G40211', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4707, 'Localization-related (focal) (partial) symptomatic epilepsy and epileptic syndromes with\ncomplex partial seizures, intractable, without status epilepticus', '', 'G40219', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4708, 'Generalized idiopathic epilepsy and epileptic syndromes, not intractable, with status\nepilepticus', '', 'G40301', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4709, 'Generalized idiopathic epilepsy and epileptic syndromes, not intractable, without status\nepilepticus', '', 'G40309', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4710, 'Generalized idiopathic epilepsy and epileptic syndromes, intractable, with status epilepticus', '', 'G40311', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4711, 'Generalized idiopathic epilepsy and epileptic syndromes, intractable, without status epilepticus', '', 'G40319', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4712, 'Absence epileptic syndrome, not intractable, with status epilepticus', '', 'G40A01', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4713, 'Absence epileptic syndrome, not intractable, without status epilepticus', '', 'G40A09', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4714, 'Absence epileptic syndrome, intractable, with status epilepticus', '', 'G40A11', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4715, 'Absence epileptic syndrome, intractable, without status epilepticus', '', 'G40A19', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4716, 'Juvenile myoclonic epilepsy, not intractable, with status epilepticus', '', 'G40B01', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4717, 'Juvenile myoclonic epilepsy, not intractable, without status epilepticus', '', 'G40B09', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4718, 'Juvenile myoclonic epilepsy, intractable, with status epilepticus', '', 'G40B11', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4719, 'Juvenile myoclonic epilepsy, intractable, without status epilepticus', '', 'G40B19', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4720, 'Other generalized epilepsy and epileptic syndromes, not intractable, with status epilepticus', '', 'G40401', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4721, 'Other generalized epilepsy and epileptic syndromes, not intractable, without status epilepticus', '', 'G40409', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4722, 'Other generalized epilepsy and epileptic syndromes, intractable, with status epilepticus', '', 'G40411', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4723, 'Other generalized epilepsy and epileptic syndromes, intractable, without status epilepticus', '', 'G40419', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4724, 'Epileptic seizures related to external causes, not intractable, with status epilepticus', '', 'G40501', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4725, 'Epileptic seizures related to external causes, not intractable, without status epilepticus', '', 'G40509', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4726, 'Other epilepsy, not intractable, with status epilepticus', '', 'G40801', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4727, 'Other epilepsy, not intractable, without status epilepticus', '', 'G40802', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4728, 'Other epilepsy, intractable, with status epilepticus', '', 'G40803', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4729, 'Other epilepsy, intractable, without status epilepticus', '', 'G40804', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4730, 'Lennox-Gastaut syndrome, not intractable, with status epilepticus', '', 'G40811', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4731, 'Lennox-Gastaut syndrome, not intractable, without status epilepticus', '', 'G40812', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4732, 'Lennox-Gastaut syndrome, intractable, with status epilepticus', '', 'G40813', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4733, 'Lennox-Gastaut syndrome, intractable, without status epilepticus', '', 'G40814', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4734, 'Epileptic spasms, not intractable, with status epilepticus', '', 'G40821', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4735, 'Epileptic spasms, not intractable, without status epilepticus', '', 'G40822', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4736, 'Epileptic spasms, intractable, with status epilepticus', '', 'G40823', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4737, 'Epileptic spasms, intractable, without status epilepticus', '', 'G40824', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4738, 'Other seizures', '', 'G4089', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4739, 'Epilepsy, unspecified, not intractable, with status epilepticus', '', 'G40901', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4740, 'Epilepsy, unspecified, not intractable, without status epilepticus', '', 'G40909', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4741, 'Epilepsy, unspecified, intractable, with status epilepticus', '', 'G40911', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4742, 'Epilepsy, unspecified, intractable, without status epilepticus', '', 'G40919', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4743, 'Migraine without aura, not intractable, with status migrainosus', '', 'G43001', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4744, 'Migraine without aura, not intractable, without status migrainosus', '', 'G43009', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4745, 'Migraine without aura, intractable, with status migrainosus', '', 'G43011', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4746, 'Migraine without aura, intractable, without status migrainosus', '', 'G43019', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4747, 'Migraine with aura, not intractable, with status migrainosus', '', 'G43101', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4748, 'Migraine with aura, not intractable, without status migrainosus', '', 'G43109', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4749, 'Migraine with aura, intractable, with status migrainosus', '', 'G43111', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4750, 'Migraine with aura, intractable, without status migrainosus', '', 'G43119', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4751, 'Hemiplegic migraine, not intractable, with status migrainosus', '', 'G43401', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4752, 'Hemiplegic migraine, not intractable, without status migrainosus', '', 'G43409', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4753, 'Hemiplegic migraine, intractable, with status migrainosus', '', 'G43411', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4754, 'Hemiplegic migraine, intractable, without status migrainosus', '', 'G43419', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4755, 'Persistent migraine aura without cerebral infarction, not intractable, with status migrainosus', '', 'G43501', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4756, 'Persistent migraine aura without cerebral infarction, not intractable, without status\nmigrainosus', '', 'G43509', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4757, 'Persistent migraine aura without cerebral infarction, intractable, with status migrainosus', '', 'G43511', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4758, 'Persistent migraine aura without cerebral infarction, intractable, without status migrainosus', '', 'G43519', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4759, 'Persistent migraine aura with cerebral infarction, not intractable, with status migrainosus', '', 'G43601', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4760, 'Persistent migraine aura with cerebral infarction, not intractable, without status migrainosus', '', 'G43609', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4761, 'Persistent migraine aura with cerebral infarction, intractable, with status migrainosus', '', 'G43611', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4762, 'Persistent migraine aura with cerebral infarction, intractable, without status migrainosus', '', 'G43619', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4763, 'Chronic migraine without aura, not intractable, with status migrainosus', '', 'G43701', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4764, 'Chronic migraine without aura, not intractable, without status migrainosus', '', 'G43709', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4765, 'Chronic migraine without aura, intractable, with status migrainosus', '', 'G43711', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4766, 'Chronic migraine without aura, intractable, without status migrainosus', '', 'G43719', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4767, 'Cyclical vomiting, not intractable', '', 'G43A0', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4768, 'Cyclical vomiting, intractable', '', 'G43A1', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4769, 'Ophthalmoplegic migraine, not intractable', '', 'G43B0', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4770, 'Ophthalmoplegic migraine, intractable', '', 'G43B1', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4771, 'Periodic headache syndromes in child or adult, not intractable', '', 'G43C0', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4772, 'Periodic headache syndromes in child or adult, intractable', '', 'G43C1', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4773, 'Abdominal migraine, not intractable', '', 'G43D0', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4774, 'Abdominal migraine, intractable', '', 'G43D1', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4775, 'Other migraine, not intractable, with status migrainosus', '', 'G43801', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4776, 'Other migraine, not intractable, without status migrainosus', '', 'G43809', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4777, 'Other migraine, intractable, with status migrainosus', '', 'G43811', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4778, 'Other migraine, intractable, without status migrainosus', '', 'G43819', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4779, 'Menstrual migraine, not intractable, with status migrainosus', '', 'G43821', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4780, 'Menstrual migraine, not intractable, without status migrainosus', '', 'G43829', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4781, 'Menstrual migraine, intractable, with status migrainosus', '', 'G43831', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4782, 'Menstrual migraine, intractable, without status migrainosus', '', 'G43839', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4783, 'Migraine, unspecified, not intractable, with status migrainosus', '', 'G43901', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4784, 'Migraine, unspecified, not intractable, without status migrainosus', '', 'G43909', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4785, 'Migraine, unspecified, intractable, with status migrainosus', '', 'G43911', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4786, 'Migraine, unspecified, intractable, without status migrainosus', '', 'G43919', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4787, 'Cluster headache syndrome, unspecified, intractable', '', 'G44001', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4788, 'Cluster headache syndrome, unspecified, not intractable', '', 'G44009', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4789, 'Episodic cluster headache, intractable', '', 'G44011', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4790, 'Episodic cluster headache, not intractable', '', 'G44019', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4791, 'Chronic cluster headache, intractable', '', 'G44021', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4792, 'Chronic cluster headache, not intractable', '', 'G44029', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4793, 'Episodic paroxysmal hemicrania, intractable', '', 'G44031', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4794, 'Episodic paroxysmal hemicrania, not intractable', '', 'G44039', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4795, 'Chronic paroxysmal hemicrania, intractable', '', 'G44041', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4796, 'Chronic paroxysmal hemicrania, not intractable', '', 'G44049', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4797, 'Short lasting unilateral neuralgiform headache with conjunctival injection and tearing (SUNCT),\nintractable', '', 'G44051', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4798, 'Short lasting unilateral neuralgiform headache with conjunctival injection and tearing (SUNCT),\nnot intractable', '', 'G44059', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4799, 'Other trigeminal autonomic cephalgias (TAC), intractable', '', 'G44091', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4800, 'Other trigeminal autonomic cephalgias (TAC), not intractable', '', 'G44099', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4801, 'Vascular headache, not elsewhere classified', '', 'G441', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4802, 'Tension-type headache, unspecified, intractable', '', 'G44201', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4803, 'Tension-type headache, unspecified, not intractable', '', 'G44209', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4804, 'Episodic tension-type headache, intractable', '', 'G44211', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4805, 'Episodic tension-type headache, not intractable', '', 'G44219', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4806, 'Chronic tension-type headache, intractable', '', 'G44221', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4807, 'Chronic tension-type headache, not intractable', '', 'G44229', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4808, 'Post-traumatic headache, unspecified, intractable', '', 'G44301', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4809, 'Post-traumatic headache, unspecified, not intractable', '', 'G44309', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4810, 'Acute post-traumatic headache, intractable', '', 'G44311', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4811, 'Acute post-traumatic headache, not intractable', '', 'G44319', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4812, 'Chronic post-traumatic headache, intractable', '', 'G44321', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4813, 'Chronic post-traumatic headache, not intractable', '', 'G44329', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4814, 'Drug-induced headache, not elsewhere classified, not intractable', '', 'G4440', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4815, 'Drug-induced headache, not elsewhere classified, intractable', '', 'G4441', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4816, 'Hemicrania continua', '', 'G4451', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4817, 'New daily persistent headache (NDPH)', '', 'G4452', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4818, 'Primary thunderclap headache', '', 'G4453', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4819, 'Other complicated headache syndrome', '', 'G4459', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4820, 'Hypnic headache', '', 'G4481', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4821, 'Headache associated with sexual activity', '', 'G4482', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4822, 'Primary cough headache', '', 'G4483', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4823, 'Primary exertional headache', '', 'G4484', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4824, 'Primary stabbing headache', '', 'G4485', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4825, 'Other headache syndrome', '', 'G4489', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4826, 'Vertebro-basilar artery syndrome', '', 'G450', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4827, 'Carotid artery syndrome (hemispheric)', '', 'G451', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4828, 'Multiple and bilateral precerebral artery syndromes', '', 'G452', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4829, 'Amaurosis fugax', '', 'G453', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4830, 'Transient global amnesia', '', 'G454', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4831, 'Other transient cerebral ischemic attacks and related syndromes', '', 'G458', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4832, 'Transient cerebral ischemic attack, unspecified', '', 'G459', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4833, 'Middle cerebral artery syndrome', '', 'G460', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4834, 'Anterior cerebral artery syndrome', '', 'G461', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4835, 'Posterior cerebral artery syndrome', '', 'G462', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4836, 'Brain stem stroke syndrome', '', 'G463', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4837, 'Cerebellar stroke syndrome', '', 'G464', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4838, 'Pure motor lacunar syndrome', '', 'G465', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4839, 'Pure sensory lacunar syndrome', '', 'G466', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4840, 'Other lacunar syndromes', '', 'G467', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4841, 'Other vascular syndromes of brain in cerebrovascular diseases', '', 'G468', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4842, 'Insomnia, unspecified', '', 'G4700', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4843, 'Insomnia due to medical condition', '', 'G4701', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4844, 'Other insomnia', '', 'G4709', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4845, 'Hypersomnia, unspecified', '', 'G4710', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4846, 'Idiopathic hypersomnia with long sleep time', '', 'G4711', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4847, 'Idiopathic hypersomnia without long sleep time', '', 'G4712', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4848, 'Recurrent hypersomnia', '', 'G4713', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4849, 'Hypersomnia due to medical condition', '', 'G4714', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4850, 'Other hypersomnia', '', 'G4719', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4851, 'Circadian rhythm sleep disorder, unspecified type', '', 'G4720', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4852, 'Circadian rhythm sleep disorder, delayed sleep phase type', '', 'G4721', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4853, 'Circadian rhythm sleep disorder, advanced sleep phase type', '', 'G4722', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4854, 'Circadian rhythm sleep disorder, irregular sleep wake type', '', 'G4723', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4855, 'Circadian rhythm sleep disorder, free running type', '', 'G4724', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4856, 'Circadian rhythm sleep disorder, jet lag type', '', 'G4725', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4857, 'Circadian rhythm sleep disorder, shift work type', '', 'G4726', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4858, 'Circadian rhythm sleep disorder in conditions classified elsewhere', '', 'G4727', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4859, 'Other circadian rhythm sleep disorder', '', 'G4729', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4860, 'Sleep apnea, unspecified', '', 'G4730', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4861, 'Primary central sleep apnea', '', 'G4731', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4862, 'High altitude periodic breathing', '', 'G4732', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4863, 'Obstructive sleep apnea (adult) (pediatric)', '', 'G4733', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4864, 'Idiopathic sleep related nonobstructive alveolar hypoventilation', '', 'G4734', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4865, 'Congenital central alveolar hypoventilation syndrome', '', 'G4735', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4866, 'Sleep related hypoventilation in conditions classified elsewhere', '', 'G4736', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4867, 'Central sleep apnea in conditions classified elsewhere', '', 'G4737', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4868, 'Other sleep apnea', '', 'G4739', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4869, 'Narcolepsy with cataplexy', '', 'G47411', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4870, 'Narcolepsy without cataplexy', '', 'G47419', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4871, 'Narcolepsy in conditions classified elsewhere with cataplexy', '', 'G47421', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4872, 'Narcolepsy in conditions classified elsewhere without cataplexy', '', 'G47429', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4873, 'Parasomnia, unspecified', '', 'G4750', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4874, 'Confusional arousals', '', 'G4751', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4875, 'REM sleep behavior disorder', '', 'G4752', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4876, 'Recurrent isolated sleep paralysis', '', 'G4753', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4877, 'Parasomnia in conditions classified elsewhere', '', 'G4754', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4878, 'Other parasomnia', '', 'G4759', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4879, 'Periodic limb movement disorder', '', 'G4761', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4880, 'Sleep related leg cramps', '', 'G4762', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4881, 'Sleep related bruxism', '', 'G4763', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4882, 'Other sleep related movement disorders', '', 'G4769', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4883, 'Other sleep disorders', '', 'G478', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4884, 'Sleep disorder, unspecified', '', 'G479', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4885, 'Trigeminal neuralgia', '', 'G500', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4886, 'Atypical facial pain', '', 'G501', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4887, 'Other disorders of trigeminal nerve', '', 'G508', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4888, 'Disorder of trigeminal nerve, unspecified', '', 'G509', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4889, 'Bell\'s palsy', '', 'G510', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4890, 'Geniculate ganglionitis', '', 'G511', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4891, 'Melkersson\'s syndrome', '', 'G512', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4892, 'Clonic hemifacial spasm', '', 'G513', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4893, 'Facial myokymia', '', 'G514', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4894, 'Other disorders of facial nerve', '', 'G518', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4895, 'Disorder of facial nerve, unspecified', '', 'G519', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4896, 'Disorders of olfactory nerve', '', 'G520', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4897, 'Disorders of glossopharyngeal nerve', '', 'G521', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4898, 'Disorders of vagus nerve', '', 'G522', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4899, 'Disorders of hypoglossal nerve', '', 'G523', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4900, 'Disorders of multiple cranial nerves', '', 'G527', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4901, 'Disorders of other specified cranial nerves', '', 'G528', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4902, 'Cranial nerve disorder, unspecified', '', 'G529', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4903, 'Cranial nerve disorders in diseases classified elsewhere', '', 'G53', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4904, 'Brachial plexus disorders', '', 'G540', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4905, 'Lumbosacral plexus disorders', '', 'G541', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4906, 'Cervical root disorders, not elsewhere classified', '', 'G542', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4907, 'Thoracic root disorders, not elsewhere classified', '', 'G543', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4908, 'Lumbosacral root disorders, not elsewhere classified', '', 'G544', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4909, 'Neuralgic amyotrophy', '', 'G545', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4910, 'Phantom limb syndrome with pain', '', 'G546', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4911, 'Phantom limb syndrome without pain', '', 'G547', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4912, 'Other nerve root and plexus disorders', '', 'G548', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4913, 'Nerve root and plexus disorder, unspecified', '', 'G549', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4914, 'Nerve root and plexus compressions in diseases classified elsewhere', '', 'G55', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4915, 'Carpal tunnel syndrome, unspecified upper limb', '', 'G5600', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4916, 'Carpal tunnel syndrome, right upper limb', '', 'G5601', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4917, 'Carpal tunnel syndrome, left upper limb', '', 'G5602', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4918, 'Carpal tunnel syndrome, bilateral upper limbs', '', 'G5603', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4919, 'Other lesions of median nerve, unspecified upper limb', '', 'G5610', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4920, 'Other lesions of median nerve, right upper limb', '', 'G5611', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4921, 'Other lesions of median nerve, left upper limb', '', 'G5612', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4922, 'Other lesions of median nerve, bilateral upper limbs', '', 'G5613', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4923, 'Lesion of ulnar nerve, unspecified upper limb', '', 'G5620', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4924, 'Lesion of ulnar nerve, right upper limb', '', 'G5621', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4925, 'Lesion of ulnar nerve, left upper limb', '', 'G5622', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4926, 'Lesion of ulnar nerve, bilateral upper limbs', '', 'G5623', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4927, 'Lesion of radial nerve, unspecified upper limb', '', 'G5630', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4928, 'Lesion of radial nerve, right upper limb', '', 'G5631', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4929, 'Lesion of radial nerve, left upper limb', '', 'G5632', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4930, 'Lesion of radial nerve, bilateral upper limbs', '', 'G5633', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4931, 'Causalgia of unspecified upper limb', '', 'G5640', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4932, 'Causalgia of right upper limb', '', 'G5641', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4933, 'Causalgia of left upper limb', '', 'G5642', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4934, 'Causalgia of bilateral upper limbs', '', 'G5643', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4935, 'Other specified mononeuropathies of unspecified upper limb', '', 'G5680', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4936, 'Other specified mononeuropathies of right upper limb', '', 'G5681', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4937, 'Other specified mononeuropathies of left upper limb', '', 'G5682', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4938, 'Other specified mononeuropathies of bilateral upper limbs', '', 'G5683', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4939, 'Unspecified mononeuropathy of unspecified upper limb', '', 'G5690', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4940, 'Unspecified mononeuropathy of right upper limb', '', 'G5691', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4941, 'Unspecified mononeuropathy of left upper limb', '', 'G5692', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4942, 'Unspecified mononeuropathy of bilateral upper limbs', '', 'G5693', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4943, 'Lesion of sciatic nerve, unspecified lower limb', '', 'G5700', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4944, 'Lesion of sciatic nerve, right lower limb', '', 'G5701', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4945, 'Lesion of sciatic nerve, left lower limb', '', 'G5702', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4946, 'Lesion of sciatic nerve, bilateral lower limbs', '', 'G5703', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4947, 'Meralgia paresthetica, unspecified lower limb', '', 'G5710', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4948, 'Meralgia paresthetica, right lower limb', '', 'G5711', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4949, 'Meralgia paresthetica, left lower limb', '', 'G5712', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4950, 'Meralgia paresthetica, bilateral lower limbs', '', 'G5713', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4951, 'Lesion of femoral nerve, unspecified lower limb', '', 'G5720', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4952, 'Lesion of femoral nerve, right lower limb', '', 'G5721', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4953, 'Lesion of femoral nerve, left lower limb', '', 'G5722', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1);");


DB::statement("INSERT INTO `symptoms` (`id`, `symptoms_title`, `description`, `code`, `status`, `priority`, `created_at`, `updated_at`, `type`) VALUES
(4954, 'Lesion of femoral nerve, bilateral lower limbs', '', 'G5723', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4955, 'Lesion of lateral popliteal nerve, unspecified lower limb', '', 'G5730', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4956, 'Lesion of lateral popliteal nerve, right lower limb', '', 'G5731', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4957, 'Lesion of lateral popliteal nerve, left lower limb', '', 'G5732', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4958, 'Lesion of lateral popliteal nerve, bilateral lower limbs', '', 'G5733', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4959, 'Lesion of medial popliteal nerve, unspecified lower limb', '', 'G5740', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4960, 'Lesion of medial popliteal nerve, right lower limb', '', 'G5741', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4961, 'Lesion of medial popliteal nerve, left lower limb', '', 'G5742', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4962, 'Lesion of medial popliteal nerve, bilateral lower limbs', '', 'G5743', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4963, 'Tarsal tunnel syndrome, unspecified lower limb', '', 'G5750', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4964, 'Tarsal tunnel syndrome, right lower limb', '', 'G5751', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4965, 'Tarsal tunnel syndrome, left lower limb', '', 'G5752', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4966, 'Tarsal tunnel syndrome, bilateral lower limbs', '', 'G5753', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4967, 'Lesion of plantar nerve, unspecified lower limb', '', 'G5760', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4968, 'Lesion of plantar nerve, right lower limb', '', 'G5761', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4969, 'Lesion of plantar nerve, left lower limb', '', 'G5762', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4970, 'Lesion of plantar nerve, bilateral lower limbs', '', 'G5763', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4971, 'Causalgia of unspecified lower limb', '', 'G5770', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4972, 'Causalgia of right lower limb', '', 'G5771', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4973, 'Causalgia of left lower limb', '', 'G5772', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4974, 'Causalgia of bilateral lower limbs', '', 'G5773', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4975, 'Other specified mononeuropathies of unspecified lower limb', '', 'G5780', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4976, 'Other specified mononeuropathies of right lower limb', '', 'G5781', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4977, 'Other specified mononeuropathies of left lower limb', '', 'G5782', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4978, 'Other specified mononeuropathies of bilateral lower limbs', '', 'G5783', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4979, 'Unspecified mononeuropathy of unspecified lower limb', '', 'G5790', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4980, 'Unspecified mononeuropathy of right lower limb', '', 'G5791', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4981, 'Unspecified mononeuropathy of left lower limb', '', 'G5792', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4982, 'Unspecified mononeuropathy of bilateral lower limbs', '', 'G5793', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4983, 'Intercostal neuropathy', '', 'G580', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4984, 'Mononeuritis multiplex', '', 'G587', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4985, 'Other specified mononeuropathies', '', 'G588', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4986, 'Mononeuropathy, unspecified', '', 'G589', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4987, 'Mononeuropathy in diseases classified elsewhere', '', 'G59', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4988, 'Hereditary motor and sensory neuropathy', '', 'G600', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4989, 'Refsum\'s disease', '', 'G601', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4990, 'Neuropathy in association with hereditary ataxia', '', 'G602', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4991, 'Idiopathic progressive neuropathy', '', 'G603', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4992, 'Other hereditary and idiopathic neuropathies', '', 'G608', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4993, 'Hereditary and idiopathic neuropathy, unspecified', '', 'G609', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4994, 'Guillain-Barre syndrome', '', 'G610', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4995, 'Serum neuropathy', '', 'G611', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4996, 'Chronic inflammatory demyelinating polyneuritis', '', 'G6181', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4997, 'Multifocal motor neuropathy', '', 'G6182', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4998, 'Other inflammatory polyneuropathies', '', 'G6189', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(4999, 'Inflammatory polyneuropathy, unspecified', '', 'G619', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5000, 'Drug-induced polyneuropathy', '', 'G620', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5001, 'Alcoholic polyneuropathy', '', 'G621', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5002, 'Polyneuropathy due to other toxic agents', '', 'G622', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5003, 'Critical illness polyneuropathy', '', 'G6281', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5004, 'Radiation-induced polyneuropathy', '', 'G6282', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5005, 'Other specified polyneuropathies', '', 'G6289', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5006, 'Polyneuropathy, unspecified', '', 'G629', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5007, 'Polyneuropathy in diseases classified elsewhere', '', 'G63', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5008, 'Other disorders of peripheral nervous system', '', 'G64', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5009, 'Sequelae of Guillain-Barre syndrome', '', 'G650', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5010, 'Sequelae of other inflammatory polyneuropathy', '', 'G651', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5011, 'Sequelae of toxic polyneuropathy', '', 'G652', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5012, 'Myasthenia gravis without (acute) exacerbation', '', 'G7000', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5013, 'Myasthenia gravis with (acute) exacerbation', '', 'G7001', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5014, 'Toxic myoneural disorders', '', 'G701', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5015, 'Congenital and developmental myasthenia', '', 'G702', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5016, 'Lambert-Eaton syndrome, unspecified', '', 'G7080', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5017, 'Lambert-Eaton syndrome in disease classified elsewhere', '', 'G7081', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5018, 'Other specified myoneural disorders', '', 'G7089', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5019, 'Myoneural disorder, unspecified', '', 'G709', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5020, 'Muscular dystrophy', '', 'G710', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5021, 'Myotonic muscular dystrophy', '', 'G7111', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5022, 'Myotonia congenita', '', 'G7112', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5023, 'Myotonic chondrodystrophy', '', 'G7113', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5024, 'Drug induced myotonia', '', 'G7114', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5025, 'Other specified myotonic disorders', '', 'G7119', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5026, 'Congenital myopathies', '', 'G712', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5027, 'Mitochondrial myopathy, not elsewhere classified', '', 'G713', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5028, 'Other primary disorders of muscles', '', 'G718', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5029, 'Primary disorder of muscle, unspecified', '', 'G719', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5030, 'Drug-induced myopathy', '', 'G720', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5031, 'Alcoholic myopathy', '', 'G721', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5032, 'Myopathy due to other toxic agents', '', 'G722', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5033, 'Periodic paralysis', '', 'G723', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5034, 'Inclusion body myositis [IBM]', '', 'G7241', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5035, 'Other inflammatory and immune myopathies, not elsewhere classified', '', 'G7249', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5036, 'Critical illness myopathy', '', 'G7281', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5037, 'Other specified myopathies', '', 'G7289', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5038, 'Myopathy, unspecified', '', 'G729', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5039, 'Lambert-Eaton syndrome in neoplastic disease', '', 'G731', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5040, 'Myasthenic syndromes in other diseases classified elsewhere', '', 'G733', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5041, 'Myopathy in diseases classified elsewhere', '', 'G737', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5042, 'Spastic quadriplegic cerebral palsy', '', 'G800', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5043, 'Spastic diplegic cerebral palsy', '', 'G801', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5044, 'Spastic hemiplegic cerebral palsy', '', 'G802', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5045, 'Athetoid cerebral palsy', '', 'G803', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5046, 'Ataxic cerebral palsy', '', 'G804', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5047, 'Other cerebral palsy', '', 'G808', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5048, 'Cerebral palsy, unspecified', '', 'G809', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5049, 'Flaccid hemiplegia affecting unspecified side', '', 'G8100', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5050, 'Flaccid hemiplegia affecting right dominant side', '', 'G8101', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5051, 'Flaccid hemiplegia affecting left dominant side', '', 'G8102', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5052, 'Flaccid hemiplegia affecting right nondominant side', '', 'G8103', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5053, 'Flaccid hemiplegia affecting left nondominant side', '', 'G8104', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5054, 'Spastic hemiplegia affecting unspecified side', '', 'G8110', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5055, 'Spastic hemiplegia affecting right dominant side', '', 'G8111', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5056, 'Spastic hemiplegia affecting left dominant side', '', 'G8112', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5057, 'Spastic hemiplegia affecting right nondominant side', '', 'G8113', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5058, 'Spastic hemiplegia affecting left nondominant side', '', 'G8114', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5059, 'Hemiplegia, unspecified affecting unspecified side', '', 'G8190', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5060, 'Hemiplegia, unspecified affecting right dominant side', '', 'G8191', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5061, 'Hemiplegia, unspecified affecting left dominant side', '', 'G8192', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5062, 'Hemiplegia, unspecified affecting right nondominant side', '', 'G8193', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5063, 'Hemiplegia, unspecified affecting left nondominant side', '', 'G8194', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5064, 'Paraplegia, unspecified', '', 'G8220', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5065, 'Paraplegia, complete', '', 'G8221', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5066, 'Paraplegia, incomplete', '', 'G8222', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5067, 'Quadriplegia, unspecified', '', 'G8250', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5068, 'Quadriplegia, C1-C4 complete', '', 'G8251', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5069, 'Quadriplegia, C1-C4 incomplete', '', 'G8252', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5070, 'Quadriplegia, C5-C7 complete', '', 'G8253', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5071, 'Quadriplegia, C5-C7 incomplete', '', 'G8254', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5072, 'Diplegia of upper limbs', '', 'G830', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5073, 'Monoplegia of lower limb affecting unspecified side', '', 'G8310', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5074, 'Monoplegia of lower limb affecting right dominant side', '', 'G8311', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5075, 'Monoplegia of lower limb affecting left dominant side', '', 'G8312', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5076, 'Monoplegia of lower limb affecting right nondominant side', '', 'G8313', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5077, 'Monoplegia of lower limb affecting left nondominant side', '', 'G8314', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5078, 'Monoplegia of upper limb affecting unspecified side', '', 'G8320', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5079, 'Monoplegia of upper limb affecting right dominant side', '', 'G8321', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5080, 'Monoplegia of upper limb affecting left dominant side', '', 'G8322', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5081, 'Monoplegia of upper limb affecting right nondominant side', '', 'G8323', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5082, 'Monoplegia of upper limb affecting left nondominant side', '', 'G8324', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5083, 'Monoplegia, unspecified affecting unspecified side', '', 'G8330', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5084, 'Monoplegia, unspecified affecting right dominant side', '', 'G8331', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5085, 'Monoplegia, unspecified affecting left dominant side', '', 'G8332', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5086, 'Monoplegia, unspecified affecting right nondominant side', '', 'G8333', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5087, 'Monoplegia, unspecified affecting left nondominant side', '', 'G8334', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5088, 'Cauda equina syndrome', '', 'G834', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5089, 'Locked-in state', '', 'G835', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5090, 'Brown-Sequard syndrome', '', 'G8381', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5091, 'Anterior cord syndrome', '', 'G8382', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5092, 'Posterior cord syndrome', '', 'G8383', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5093, 'Todd\'s paralysis (postepileptic)', '', 'G8384', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5094, 'Other specified paralytic syndromes', '', 'G8389', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5095, 'Paralytic syndrome, unspecified', '', 'G839', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5096, 'Central pain syndrome', '', 'G890', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5097, 'Acute pain due to trauma', '', 'G8911', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5098, 'Acute post-thoracotomy pain', '', 'G8912', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5099, 'Other acute postprocedural pain', '', 'G8918', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5100, 'Chronic pain due to trauma', '', 'G8921', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5101, 'Chronic post-thoracotomy pain', '', 'G8922', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5102, 'Other chronic postprocedural pain', '', 'G8928', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5103, 'Other chronic pain', '', 'G8929', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5104, 'Neoplasm related pain (acute) (chronic)', '', 'G893', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5105, 'Chronic pain syndrome', '', 'G894', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5106, 'Carotid sinus syncope', '', 'G9001', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5107, 'Other idiopathic peripheral autonomic neuropathy', '', 'G9009', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5108, 'Familial dysautonomia [Riley-Day]', '', 'G901', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5109, 'Horner\'s syndrome', '', 'G902', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5110, 'Multi-system degeneration of the autonomic nervous system', '', 'G903', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5111, 'Autonomic dysreflexia', '', 'G904', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5112, 'Complex regional pain syndrome I, unspecified', '', 'G9050', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5113, 'Complex regional pain syndrome I of right upper limb', '', 'G90511', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5114, 'Complex regional pain syndrome I of left upper limb', '', 'G90512', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5115, 'Complex regional pain syndrome I of upper limb, bilateral', '', 'G90513', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5116, 'Complex regional pain syndrome I of unspecified upper limb', '', 'G90519', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5117, 'Complex regional pain syndrome I of right lower limb', '', 'G90521', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5118, 'Complex regional pain syndrome I of left lower limb', '', 'G90522', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5119, 'Complex regional pain syndrome I of lower limb, bilateral', '', 'G90523', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5120, 'Complex regional pain syndrome I of unspecified lower limb', '', 'G90529', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5121, 'Complex regional pain syndrome I of other specified site', '', 'G9059', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5122, 'Other disorders of autonomic nervous system', '', 'G908', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5123, 'Disorder of the autonomic nervous system, unspecified', '', 'G909', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5124, 'Communicating hydrocephalus', '', 'G910', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5125, 'Obstructive hydrocephalus', '', 'G911', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5126, '(Idiopathic) normal pressure hydrocephalus', '', 'G912', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5127, 'Post-traumatic hydrocephalus, unspecified', '', 'G913', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5128, 'Hydrocephalus in diseases classified elsewhere', '', 'G914', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5129, 'Other hydrocephalus', '', 'G918', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5130, 'Hydrocephalus, unspecified', '', 'G919', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5131, 'Toxic encephalopathy', '', 'G92', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5132, 'Cerebral cysts', '', 'G930', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5133, 'Anoxic brain damage, not elsewhere classified', '', 'G931', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5134, 'Benign intracranial hypertension', '', 'G932', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5135, 'Postviral fatigue syndrome', '', 'G933', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5136, 'Encephalopathy, unspecified', '', 'G9340', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5137, 'Metabolic encephalopathy', '', 'G9341', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5138, 'Other encephalopathy', '', 'G9349', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5139, 'Compression of brain', '', 'G935', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5140, 'Cerebral edema', '', 'G936', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5141, 'Reye\'s syndrome', '', 'G937', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5142, 'Temporal sclerosis', '', 'G9381', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5143, 'Brain death', '', 'G9382', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5144, 'Other specified disorders of brain', '', 'G9389', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5145, 'Disorder of brain, unspecified', '', 'G939', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5146, 'Other disorders of brain in diseases classified elsewhere', '', 'G94', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5147, 'Syringomyelia and syringobulbia', '', 'G950', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5148, 'Acute infarction of spinal cord (embolic) (nonembolic)', '', 'G9511', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5149, 'Other vascular myelopathies', '', 'G9519', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5150, 'Unspecified cord compression', '', 'G9520', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5151, 'Other cord compression', '', 'G9529', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5152, 'Conus medullaris syndrome', '', 'G9581', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5153, 'Other specified diseases of spinal cord', '', 'G9589', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5154, 'Disease of spinal cord, unspecified', '', 'G959', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5155, 'Cerebrospinal fluid leak', '', 'G960', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5156, 'Dural tear', '', 'G9611', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5157, 'Meningeal adhesions (cerebral) (spinal)', '', 'G9612', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5158, 'Other disorders of meninges, not elsewhere classified', '', 'G9619', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5159, 'Other specified disorders of central nervous system', '', 'G968', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5160, 'Disorder of central nervous system, unspecified', '', 'G969', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5161, 'Cerebrospinal fluid leak from spinal puncture', '', 'G970', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5162, 'Other reaction to spinal and lumbar puncture', '', 'G971', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5163, 'Intracranial hypotension following ventricular shunting', '', 'G972', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5164, 'Intraoperative hemorrhage and hematoma of a nervous system organ or structure complicating\na nervous system procedure', '', 'G9731', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5165, 'Intraoperative hemorrhage and hematoma of a nervous system organ or structure complicating\nother procedure', '', 'G9732', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5166, 'Accidental puncture or laceration of dura during a procedure', '', 'G9741', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5167, 'Accidental puncture and laceration of other nervous system organ or structure during a nervous\nsystem procedure', '', 'G9748', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5168, 'Accidental puncture and laceration of other nervous system organ or structure during other\nprocedure', '', 'G9749', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5169, 'Postprocedural hemorrhage of a nervous system organ or structure following a nervous system\nprocedure', '', 'G9751', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5170, 'Postprocedural hemorrhage of a nervous system organ or structure following other procedure', '', 'G9752', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5171, 'Postprocedural hematoma of a nervous system organ or structure following a nervous system\nprocedure', '', 'G9761', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5172, 'Postprocedural hematoma of a nervous system organ or structure following other procedure', '', 'G9762', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5173, 'Postprocedural seroma of a nervous system organ or structure following a nervous system\nprocedure', '', 'G9763', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5174, 'Postprocedural seroma of a nervous system organ or structure following other procedure', '', 'G9764', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5175, 'Other intraoperative complications of nervous system', '', 'G9781', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5176, 'Other postprocedural complications and disorders of nervous system', '', 'G9782', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5177, 'Neurogenic arthritis, not elsewhere classified', '', 'G980', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5178, 'Other disorders of nervous system', '', 'G988', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5179, 'Autonomic neuropathy in diseases classified elsewhere', '', 'G990', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5180, 'Myelopathy in diseases classified elsewhere', '', 'G992', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5181, 'Other specified disorders of nervous system in diseases classified elsewhere', '', 'G998', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5182, 'Hordeolum externum right upper eyelid', '', 'H00011', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5183, 'Hordeolum externum right lower eyelid', '', 'H00012', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5184, 'Hordeolum externum right eye, unspecified eyelid', '', 'H00013', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5185, 'Hordeolum externum left upper eyelid', '', 'H00014', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5186, 'Hordeolum externum left lower eyelid', '', 'H00015', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5187, 'Hordeolum externum left eye, unspecified eyelid', '', 'H00016', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5188, 'Hordeolum externum unspecified eye, unspecified eyelid', '', 'H00019', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5189, 'Hordeolum internum right upper eyelid', '', 'H00021', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5190, 'Hordeolum internum right lower eyelid', '', 'H00022', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5191, 'Hordeolum internum right eye, unspecified eyelid', '', 'H00023', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5192, 'Hordeolum internum left upper eyelid', '', 'H00024', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5193, 'Hordeolum internum left lower eyelid', '', 'H00025', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5194, 'Hordeolum internum left eye, unspecified eyelid', '', 'H00026', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5195, 'Hordeolum internum unspecified eye, unspecified eyelid', '', 'H00029', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5196, 'Abscess of right upper eyelid', '', 'H00031', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5197, 'Abscess of right lower eyelid', '', 'H00032', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5198, 'Abscess of eyelid right eye, unspecified eyelid', '', 'H00033', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5199, 'Abscess of left upper eyelid', '', 'H00034', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5200, 'Abscess of left lower eyelid', '', 'H00035', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5201, 'Abscess of eyelid left eye, unspecified eyelid', '', 'H00036', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5202, 'Abscess of eyelid unspecified eye, unspecified eyelid', '', 'H00039', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5203, 'Chalazion right upper eyelid', '', 'H0011', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5204, 'Chalazion right lower eyelid', '', 'H0012', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5205, 'Chalazion right eye, unspecified eyelid', '', 'H0013', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5206, 'Chalazion left upper eyelid', '', 'H0014', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5207, 'Chalazion left lower eyelid', '', 'H0015', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5208, 'Chalazion left eye, unspecified eyelid', '', 'H0016', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5209, 'Chalazion unspecified eye, unspecified eyelid', '', 'H0019', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5210, 'Unspecified blepharitis right upper eyelid', '', 'H01001', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5211, 'Unspecified blepharitis right lower eyelid', '', 'H01002', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5212, 'Unspecified blepharitis right eye, unspecified eyelid', '', 'H01003', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5213, 'Unspecified blepharitis left upper eyelid', '', 'H01004', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5214, 'Unspecified blepharitis left lower eyelid', '', 'H01005', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5215, 'Unspecified blepharitis left eye, unspecified eyelid', '', 'H01006', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5216, 'Unspecified blepharitis unspecified eye, unspecified eyelid', '', 'H01009', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5217, 'Ulcerative blepharitis right upper eyelid', '', 'H01011', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5218, 'Ulcerative blepharitis right lower eyelid', '', 'H01012', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5219, 'Ulcerative blepharitis right eye, unspecified eyelid', '', 'H01013', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5220, 'Ulcerative blepharitis left upper eyelid', '', 'H01014', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5221, 'Ulcerative blepharitis left lower eyelid', '', 'H01015', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5222, 'Ulcerative blepharitis left eye, unspecified eyelid', '', 'H01016', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5223, 'Ulcerative blepharitis unspecified eye, unspecified eyelid', '', 'H01019', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5224, 'Squamous blepharitis right upper eyelid', '', 'H01021', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5225, 'Squamous blepharitis right lower eyelid', '', 'H01022', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5226, 'Squamous blepharitis right eye, unspecified eyelid', '', 'H01023', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5227, 'Squamous blepharitis left upper eyelid', '', 'H01024', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5228, 'Squamous blepharitis left lower eyelid', '', 'H01025', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5229, 'Squamous blepharitis left eye, unspecified eyelid', '', 'H01026', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5230, 'Squamous blepharitis unspecified eye, unspecified eyelid', '', 'H01029', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5231, 'Allergic dermatitis of right upper eyelid', '', 'H01111', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5232, 'Allergic dermatitis of right lower eyelid', '', 'H01112', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5233, 'Allergic dermatitis of right eye, unspecified eyelid', '', 'H01113', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5234, 'Allergic dermatitis of left upper eyelid', '', 'H01114', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5235, 'Allergic dermatitis of left lower eyelid', '', 'H01115', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5236, 'Allergic dermatitis of left eye, unspecified eyelid', '', 'H01116', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5237, 'Allergic dermatitis of unspecified eye, unspecified eyelid', '', 'H01119', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5238, 'Discoid lupus erythematosus of right upper eyelid', '', 'H01121', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5239, 'Discoid lupus erythematosus of right lower eyelid', '', 'H01122', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5240, 'Discoid lupus erythematosus of right eye, unspecified eyelid', '', 'H01123', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5241, 'Discoid lupus erythematosus of left upper eyelid', '', 'H01124', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5242, 'Discoid lupus erythematosus of left lower eyelid', '', 'H01125', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5243, 'Discoid lupus erythematosus of left eye, unspecified eyelid', '', 'H01126', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5244, 'Discoid lupus erythematosus of unspecified eye, unspecified eyelid', '', 'H01129', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5245, 'Eczematous dermatitis of right upper eyelid', '', 'H01131', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5246, 'Eczematous dermatitis of right lower eyelid', '', 'H01132', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5247, 'Eczematous dermatitis of right eye, unspecified eyelid', '', 'H01133', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5248, 'Eczematous dermatitis of left upper eyelid', '', 'H01134', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5249, 'Eczematous dermatitis of left lower eyelid', '', 'H01135', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5250, 'Eczematous dermatitis of left eye, unspecified eyelid', '', 'H01136', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5251, 'Eczematous dermatitis of unspecified eye, unspecified eyelid', '', 'H01139', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5252, 'Xeroderma of right upper eyelid', '', 'H01141', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5253, 'Xeroderma of right lower eyelid', '', 'H01142', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5254, 'Xeroderma of right eye, unspecified eyelid', '', 'H01143', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5255, 'Xeroderma of left upper eyelid', '', 'H01144', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5256, 'Xeroderma of left lower eyelid', '', 'H01145', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5257, 'Xeroderma of left eye, unspecified eyelid', '', 'H01146', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5258, 'Xeroderma of unspecified eye, unspecified eyelid', '', 'H01149', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5259, 'Other specified inflammations of eyelid', '', 'H018', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5260, 'Unspecified inflammation of eyelid', '', 'H019', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5261, 'Unspecified entropion of right upper eyelid', '', 'H02001', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5262, 'Unspecified entropion of right lower eyelid', '', 'H02002', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5263, 'Unspecified entropion of right eye, unspecified eyelid', '', 'H02003', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5264, 'Unspecified entropion of left upper eyelid', '', 'H02004', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5265, 'Unspecified entropion of left lower eyelid', '', 'H02005', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5266, 'Unspecified entropion of left eye, unspecified eyelid', '', 'H02006', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5267, 'Unspecified entropion of unspecified eye, unspecified eyelid', '', 'H02009', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5268, 'Cicatricial entropion of right upper eyelid', '', 'H02011', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5269, 'Cicatricial entropion of right lower eyelid', '', 'H02012', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5270, 'Cicatricial entropion of right eye, unspecified eyelid', '', 'H02013', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5271, 'Cicatricial entropion of left upper eyelid', '', 'H02014', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5272, 'Cicatricial entropion of left lower eyelid', '', 'H02015', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5273, 'Cicatricial entropion of left eye, unspecified eyelid', '', 'H02016', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5274, 'Cicatricial entropion of unspecified eye, unspecified eyelid', '', 'H02019', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5275, 'Mechanical entropion of right upper eyelid', '', 'H02021', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5276, 'Mechanical entropion of right lower eyelid', '', 'H02022', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5277, 'Mechanical entropion of right eye, unspecified eyelid', '', 'H02023', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5278, 'Mechanical entropion of left upper eyelid', '', 'H02024', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5279, 'Mechanical entropion of left lower eyelid', '', 'H02025', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5280, 'Mechanical entropion of left eye, unspecified eyelid', '', 'H02026', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5281, 'Mechanical entropion of unspecified eye, unspecified eyelid', '', 'H02029', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5282, 'Senile entropion of right upper eyelid', '', 'H02031', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5283, 'Senile entropion of right lower eyelid', '', 'H02032', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5284, 'Senile entropion of right eye, unspecified eyelid', '', 'H02033', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5285, 'Senile entropion of left upper eyelid', '', 'H02034', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5286, 'Senile entropion of left lower eyelid', '', 'H02035', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5287, 'Senile entropion of left eye, unspecified eyelid', '', 'H02036', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5288, 'Senile entropion of unspecified eye, unspecified eyelid', '', 'H02039', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5289, 'Spastic entropion of right upper eyelid', '', 'H02041', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5290, 'Spastic entropion of right lower eyelid', '', 'H02042', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5291, 'Spastic entropion of right eye, unspecified eyelid', '', 'H02043', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5292, 'Spastic entropion of left upper eyelid', '', 'H02044', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5293, 'Spastic entropion of left lower eyelid', '', 'H02045', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5294, 'Spastic entropion of left eye, unspecified eyelid', '', 'H02046', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5295, 'Spastic entropion of unspecified eye, unspecified eyelid', '', 'H02049', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5296, 'Trichiasis without entropian right upper eyelid', '', 'H02051', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5297, 'Trichiasis without entropian right lower eyelid', '', 'H02052', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5298, 'Trichiasis without entropian right eye, unspecified eyelid', '', 'H02053', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5299, 'Trichiasis without entropian left upper eyelid', '', 'H02054', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5300, 'Trichiasis without entropian left lower eyelid', '', 'H02055', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5301, 'Trichiasis without entropian left eye, unspecified eyelid', '', 'H02056', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5302, 'Trichiasis without entropian unspecified eye, unspecified eyelid', '', 'H02059', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5303, 'Unspecified ectropion of right upper eyelid', '', 'H02101', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5304, 'Unspecified ectropion of right lower eyelid', '', 'H02102', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5305, 'Unspecified ectropion of right eye, unspecified eyelid', '', 'H02103', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5306, 'Unspecified ectropion of left upper eyelid', '', 'H02104', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5307, 'Unspecified ectropion of left lower eyelid', '', 'H02105', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5308, 'Unspecified ectropion of left eye, unspecified eyelid', '', 'H02106', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5309, 'Unspecified ectropion of unspecified eye, unspecified eyelid', '', 'H02109', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5310, 'Cicatricial ectropion of right upper eyelid', '', 'H02111', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5311, 'Cicatricial ectropion of right lower eyelid', '', 'H02112', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5312, 'Cicatricial ectropion of right eye, unspecified eyelid', '', 'H02113', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5313, 'Cicatricial ectropion of left upper eyelid', '', 'H02114', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5314, 'Cicatricial ectropion of left lower eyelid', '', 'H02115', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5315, 'Cicatricial ectropion of left eye, unspecified eyelid', '', 'H02116', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5316, 'Cicatricial ectropion of unspecified eye, unspecified eyelid', '', 'H02119', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5317, 'Mechanical ectropion of right upper eyelid', '', 'H02121', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5318, 'Mechanical ectropion of right lower eyelid', '', 'H02122', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5319, 'Mechanical ectropion of right eye, unspecified eyelid', '', 'H02123', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5320, 'Mechanical ectropion of left upper eyelid', '', 'H02124', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5321, 'Mechanical ectropion of left lower eyelid', '', 'H02125', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5322, 'Mechanical ectropion of left eye, unspecified eyelid', '', 'H02126', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5323, 'Mechanical ectropion of unspecified eye, unspecified eyelid', '', 'H02129', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5324, 'Senile ectropion of right upper eyelid', '', 'H02131', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5325, 'Senile ectropion of right lower eyelid', '', 'H02132', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5326, 'Senile ectropion of right eye, unspecified eyelid', '', 'H02133', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5327, 'Senile ectropion of left upper eyelid', '', 'H02134', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5328, 'Senile ectropion of left lower eyelid', '', 'H02135', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5329, 'Senile ectropion of left eye, unspecified eyelid', '', 'H02136', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5330, 'Senile ectropion of unspecified eye, unspecified eyelid', '', 'H02139', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5331, 'Spastic ectropion of right upper eyelid', '', 'H02141', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5332, 'Spastic ectropion of right lower eyelid', '', 'H02142', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5333, 'Spastic ectropion of right eye, unspecified eyelid', '', 'H02143', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5334, 'Spastic ectropion of left upper eyelid', '', 'H02144', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5335, 'Spastic ectropion of left lower eyelid', '', 'H02145', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5336, 'Spastic ectropion of left eye, unspecified eyelid', '', 'H02146', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5337, 'Spastic ectropion of unspecified eye, unspecified eyelid', '', 'H02149', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5338, 'Unspecified lagophthalmos right upper eyelid', '', 'H02201', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5339, 'Unspecified lagophthalmos right lower eyelid', '', 'H02202', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5340, 'Unspecified lagophthalmos right eye, unspecified eyelid', '', 'H02203', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5341, 'Unspecified lagophthalmos left upper eyelid', '', 'H02204', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5342, 'Unspecified lagophthalmos left lower eyelid', '', 'H02205', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5343, 'Unspecified lagophthalmos left eye, unspecified eyelid', '', 'H02206', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5344, 'Unspecified lagophthalmos unspecified eye, unspecified eyelid', '', 'H02209', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5345, 'Cicatricial lagophthalmos right upper eyelid', '', 'H02211', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5346, 'Cicatricial lagophthalmos right lower eyelid', '', 'H02212', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5347, 'Cicatricial lagophthalmos right eye, unspecified eyelid', '', 'H02213', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5348, 'Cicatricial lagophthalmos left upper eyelid', '', 'H02214', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5349, 'Cicatricial lagophthalmos left lower eyelid', '', 'H02215', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5350, 'Cicatricial lagophthalmos left eye, unspecified eyelid', '', 'H02216', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5351, 'Cicatricial lagophthalmos unspecified eye, unspecified eyelid', '', 'H02219', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5352, 'Mechanical lagophthalmos right upper eyelid', '', 'H02221', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5353, 'Mechanical lagophthalmos right lower eyelid', '', 'H02222', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5354, 'Mechanical lagophthalmos right eye, unspecified eyelid', '', 'H02223', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5355, 'Mechanical lagophthalmos left upper eyelid', '', 'H02224', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1);");


DB::statement("INSERT INTO `symptoms` (`id`, `symptoms_title`, `description`, `code`, `status`, `priority`, `created_at`, `updated_at`, `type`) VALUES
(5356, 'Mechanical lagophthalmos left lower eyelid', '', 'H02225', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5357, 'Mechanical lagophthalmos left eye, unspecified eyelid', '', 'H02226', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5358, 'Mechanical lagophthalmos unspecified eye, unspecified eyelid', '', 'H02229', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5359, 'Paralytic lagophthalmos right upper eyelid', '', 'H02231', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5360, 'Paralytic lagophthalmos right lower eyelid', '', 'H02232', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5361, 'Paralytic lagophthalmos right eye, unspecified eyelid', '', 'H02233', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5362, 'Paralytic lagophthalmos left upper eyelid', '', 'H02234', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5363, 'Paralytic lagophthalmos left lower eyelid', '', 'H02235', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5364, 'Paralytic lagophthalmos left eye, unspecified eyelid', '', 'H02236', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5365, 'Paralytic lagophthalmos unspecified eye, unspecified eyelid', '', 'H02239', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5366, 'Blepharochalasis unspecified eye, unspecified eyelid', '', 'H0230', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5367, 'Blepharochalasis right upper eyelid', '', 'H0231', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5368, 'Blepharochalasis right lower eyelid', '', 'H0232', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5369, 'Blepharochalasis right eye, unspecified eyelid', '', 'H0233', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5370, 'Blepharochalasis left upper eyelid', '', 'H0234', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5371, 'Blepharochalasis left lower eyelid', '', 'H0235', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5372, 'Blepharochalasis left eye, unspecified eyelid', '', 'H0236', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5373, 'Unspecified ptosis of right eyelid', '', 'H02401', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5374, 'Unspecified ptosis of left eyelid', '', 'H02402', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5375, 'Unspecified ptosis of bilateral eyelids', '', 'H02403', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5376, 'Unspecified ptosis of unspecified eyelid', '', 'H02409', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5377, 'Mechanical ptosis of right eyelid', '', 'H02411', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5378, 'Mechanical ptosis of left eyelid', '', 'H02412', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5379, 'Mechanical ptosis of bilateral eyelids', '', 'H02413', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5380, 'Mechanical ptosis of unspecified eyelid', '', 'H02419', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5381, 'Myogenic ptosis of right eyelid', '', 'H02421', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5382, 'Myogenic ptosis of left eyelid', '', 'H02422', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5383, 'Myogenic ptosis of bilateral eyelids', '', 'H02423', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5384, 'Myogenic ptosis of unspecified eyelid', '', 'H02429', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5385, 'Paralytic ptosis of right eyelid', '', 'H02431', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5386, 'Paralytic ptosis of left eyelid', '', 'H02432', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5387, 'Paralytic ptosis of bilateral eyelids', '', 'H02433', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5388, 'Paralytic ptosis unspecified eyelid', '', 'H02439', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5389, 'Abnormal innervation syndrome right upper eyelid', '', 'H02511', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5390, 'Abnormal innervation syndrome right lower eyelid', '', 'H02512', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5391, 'Abnormal innervation syndrome right eye, unspecified eyelid', '', 'H02513', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5392, 'Abnormal innervation syndrome left upper eyelid', '', 'H02514', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5393, 'Abnormal innervation syndrome left lower eyelid', '', 'H02515', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5394, 'Abnormal innervation syndrome left eye, unspecified eyelid', '', 'H02516', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5395, 'Abnormal innervation syndrome unspecified eye, unspecified eyelid', '', 'H02519', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5396, 'Blepharophimosis right upper eyelid', '', 'H02521', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5397, 'Blepharophimosis right lower eyelid', '', 'H02522', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5398, 'Blepharophimosis right eye, unspecified eyelid', '', 'H02523', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5399, 'Blepharophimosis left upper eyelid', '', 'H02524', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5400, 'Blepharophimosis left lower eyelid', '', 'H02525', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5401, 'Blepharophimosis left eye, unspecified eyelid', '', 'H02526', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5402, 'Blepharophimosis unspecified eye, unspecified lid', '', 'H02529', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5403, 'Eyelid retraction right upper eyelid', '', 'H02531', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5404, 'Eyelid retraction right lower eyelid', '', 'H02532', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5405, 'Eyelid retraction right eye, unspecified eyelid', '', 'H02533', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5406, 'Eyelid retraction left upper eyelid', '', 'H02534', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5407, 'Eyelid retraction left lower eyelid', '', 'H02535', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5408, 'Eyelid retraction left eye, unspecified eyelid', '', 'H02536', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5409, 'Eyelid retraction unspecified eye, unspecified lid', '', 'H02539', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5410, 'Other disorders affecting eyelid function', '', 'H0259', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5411, 'Xanthelasma of unspecified eye, unspecified eyelid', '', 'H0260', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5412, 'Xanthelasma of right upper eyelid', '', 'H0261', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5413, 'Xanthelasma of right lower eyelid', '', 'H0262', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5414, 'Xanthelasma of right eye, unspecified eyelid', '', 'H0263', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5415, 'Xanthelasma of left upper eyelid', '', 'H0264', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5416, 'Xanthelasma of left lower eyelid', '', 'H0265', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5417, 'Xanthelasma of left eye, unspecified eyelid', '', 'H0266', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5418, 'Unspecified degenerative disorders of eyelid and periocular area', '', 'H0270', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5419, 'Chloasma of right upper eyelid and periocular area', '', 'H02711', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5420, 'Chloasma of right lower eyelid and periocular area', '', 'H02712', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5421, 'Chloasma of right eye, unspecified eyelid and periocular area', '', 'H02713', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5422, 'Chloasma of left upper eyelid and periocular area', '', 'H02714', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5423, 'Chloasma of left lower eyelid and periocular area', '', 'H02715', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5424, 'Chloasma of left eye, unspecified eyelid and periocular area', '', 'H02716', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5425, 'Chloasma of unspecified eye, unspecified eyelid and periocular area', '', 'H02719', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5426, 'Madarosis of right upper eyelid and periocular area', '', 'H02721', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5427, 'Madarosis of right lower eyelid and periocular area', '', 'H02722', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5428, 'Madarosis of right eye, unspecified eyelid and periocular area', '', 'H02723', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5429, 'Madarosis of left upper eyelid and periocular area', '', 'H02724', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5430, 'Madarosis of left lower eyelid and periocular area', '', 'H02725', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5431, 'Madarosis of left eye, unspecified eyelid and periocular area', '', 'H02726', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5432, 'Madarosis of unspecified eye, unspecified eyelid and periocular area', '', 'H02729', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5433, 'Vitiligo of right upper eyelid and periocular area', '', 'H02731', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5434, 'Vitiligo of right lower eyelid and periocular area', '', 'H02732', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5435, 'Vitiligo of right eye, unspecified eyelid and periocular area', '', 'H02733', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5436, 'Vitiligo of left upper eyelid and periocular area', '', 'H02734', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5437, 'Vitiligo of left lower eyelid and periocular area', '', 'H02735', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5438, 'Vitiligo of left eye, unspecified eyelid and periocular area', '', 'H02736', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5439, 'Vitiligo of unspecified eye, unspecified eyelid and periocular area', '', 'H02739', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5440, 'Other degenerative disorders of eyelid and periocular area', '', 'H0279', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5441, 'Retained foreign body in right upper eyelid', '', 'H02811', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5442, 'Retained foreign body in right lower eyelid', '', 'H02812', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5443, 'Retained foreign body in right eye, unspecified eyelid', '', 'H02813', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5444, 'Retained foreign body in left upper eyelid', '', 'H02814', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5445, 'Retained foreign body in left lower eyelid', '', 'H02815', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5446, 'Retained foreign body in left eye, unspecified eyelid', '', 'H02816', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5447, 'Retained foreign body in unspecified eye, unspecified eyelid', '', 'H02819', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5448, 'Cysts of right upper eyelid', '', 'H02821', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5449, 'Cysts of right lower eyelid', '', 'H02822', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5450, 'Cysts of right eye, unspecified eyelid', '', 'H02823', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5451, 'Cysts of left upper eyelid', '', 'H02824', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5452, 'Cysts of left lower eyelid', '', 'H02825', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5453, 'Cysts of left eye, unspecified eyelid', '', 'H02826', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5454, 'Cysts of unspecified eye, unspecified eyelid', '', 'H02829', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5455, 'Dermatochalasis of right upper eyelid', '', 'H02831', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5456, 'Dermatochalasis of right lower eyelid', '', 'H02832', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5457, 'Dermatochalasis of right eye, unspecified eyelid', '', 'H02833', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5458, 'Dermatochalasis of left upper eyelid', '', 'H02834', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5459, 'Dermatochalasis of left lower eyelid', '', 'H02835', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5460, 'Dermatochalasis of left eye, unspecified eyelid', '', 'H02836', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5461, 'Dermatochalasis of unspecified eye, unspecified eyelid', '', 'H02839', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5462, 'Edema of right upper eyelid', '', 'H02841', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5463, 'Edema of right lower eyelid', '', 'H02842', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5464, 'Edema of right eye, unspecified eyelid', '', 'H02843', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5465, 'Edema of left upper eyelid', '', 'H02844', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5466, 'Edema of left lower eyelid', '', 'H02845', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5467, 'Edema of left eye, unspecified eyelid', '', 'H02846', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5468, 'Edema of unspecified eye, unspecified eyelid', '', 'H02849', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5469, 'Elephantiasis of right upper eyelid', '', 'H02851', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5470, 'Elephantiasis of right lower eyelid', '', 'H02852', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5471, 'Elephantiasis of right eye, unspecified eyelid', '', 'H02853', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5472, 'Elephantiasis of left upper eyelid', '', 'H02854', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5473, 'Elephantiasis of left lower eyelid', '', 'H02855', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5474, 'Elephantiasis of left eye, unspecified eyelid', '', 'H02856', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5475, 'Elephantiasis of unspecified eye, unspecified eyelid', '', 'H02859', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5476, 'Hypertrichosis of right upper eyelid', '', 'H02861', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5477, 'Hypertrichosis of right lower eyelid', '', 'H02862', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5478, 'Hypertrichosis of right eye, unspecified eyelid', '', 'H02863', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5479, 'Hypertrichosis of left upper eyelid', '', 'H02864', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5480, 'Hypertrichosis of left lower eyelid', '', 'H02865', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5481, 'Hypertrichosis of left eye, unspecified eyelid', '', 'H02866', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5482, 'Hypertrichosis of unspecified eye, unspecified eyelid', '', 'H02869', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5483, 'Vascular anomalies of right upper eyelid', '', 'H02871', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5484, 'Vascular anomalies of right lower eyelid', '', 'H02872', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5485, 'Vascular anomalies of right eye, unspecified eyelid', '', 'H02873', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5486, 'Vascular anomalies of left upper eyelid', '', 'H02874', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5487, 'Vascular anomalies of left lower eyelid', '', 'H02875', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5488, 'Vascular anomalies of left eye, unspecified eyelid', '', 'H02876', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5489, 'Vascular anomalies of unspecified eye, unspecified eyelid', '', 'H02879', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5490, 'Other specified disorders of eyelid', '', 'H0289', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5491, 'Unspecified disorder of eyelid', '', 'H029', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5492, 'Unspecified dacryoadenitis, right lacrimal gland', '', 'H04001', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5493, 'Unspecified dacryoadenitis, left lacrimal gland', '', 'H04002', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5494, 'Unspecified dacryoadenitis, bilateral lacrimal glands', '', 'H04003', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5495, 'Unspecified dacryoadenitis, unspecified lacrimal gland', '', 'H04009', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5496, 'Acute dacryoadenitis, right lacrimal gland', '', 'H04011', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5497, 'Acute dacryoadenitis, left lacrimal gland', '', 'H04012', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5498, 'Acute dacryoadenitis, bilateral lacrimal glands', '', 'H04013', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5499, 'Acute dacryoadenitis, unspecified lacrimal gland', '', 'H04019', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5500, 'Chronic dacryoadenitis, right lacrimal gland', '', 'H04021', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5501, 'Chronic dacryoadenitis, left lacrimal gland', '', 'H04022', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5502, 'Chronic dacryoadenitis, bilateral lacrimal gland', '', 'H04023', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5503, 'Chronic dacryoadenitis, unspecified lacrimal gland', '', 'H04029', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5504, 'Chronic enlargement of right lacrimal gland', '', 'H04031', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5505, 'Chronic enlargement of left lacrimal gland', '', 'H04032', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5506, 'Chronic enlargement of bilateral lacrimal glands', '', 'H04033', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5507, 'Chronic enlargement of unspecified lacrimal gland', '', 'H04039', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5508, 'Dacryops of right lacrimal gland', '', 'H04111', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5509, 'Dacryops of left lacrimal gland', '', 'H04112', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5510, 'Dacryops of bilateral lacrimal glands', '', 'H04113', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5511, 'Dacryops of unspecified lacrimal gland', '', 'H04119', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5512, 'Dry eye syndrome of right lacrimal gland', '', 'H04121', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5513, 'Dry eye syndrome of left lacrimal gland', '', 'H04122', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5514, 'Dry eye syndrome of bilateral lacrimal glands', '', 'H04123', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5515, 'Dry eye syndrome of unspecified lacrimal gland', '', 'H04129', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5516, 'Lacrimal cyst, right lacrimal gland', '', 'H04131', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5517, 'Lacrimal cyst, left lacrimal gland', '', 'H04132', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5518, 'Lacrimal cyst, bilateral lacrimal glands', '', 'H04133', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5519, 'Lacrimal cyst, unspecified lacrimal gland', '', 'H04139', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5520, 'Primary lacrimal gland atrophy, right lacrimal gland', '', 'H04141', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5521, 'Primary lacrimal gland atrophy, left lacrimal gland', '', 'H04142', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5522, 'Primary lacrimal gland atrophy, bilateral lacrimal glands', '', 'H04143', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5523, 'Primary lacrimal gland atrophy, unspecified lacrimal gland', '', 'H04149', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5524, 'Secondary lacrimal gland atrophy, right lacrimal gland', '', 'H04151', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5525, 'Secondary lacrimal gland atrophy, left lacrimal gland', '', 'H04152', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5526, 'Secondary lacrimal gland atrophy, bilateral lacrimal glands', '', 'H04153', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5527, 'Secondary lacrimal gland atrophy, unspecified lacrimal gland', '', 'H04159', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5528, 'Lacrimal gland dislocation, right lacrimal gland', '', 'H04161', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5529, 'Lacrimal gland dislocation, left lacrimal gland', '', 'H04162', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5530, 'Lacrimal gland dislocation, bilateral lacrimal glands', '', 'H04163', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5531, 'Lacrimal gland dislocation, unspecified lacrimal gland', '', 'H04169', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5532, 'Other specified disorders of lacrimal gland', '', 'H0419', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5533, 'Unspecified epiphora, right lacrimal gland', '', 'H04201', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5534, 'Unspecified epiphora, left lacrimal gland', '', 'H04202', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5535, 'Unspecified epiphora, bilateral lacrimal glands', '', 'H04203', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5536, 'Unspecified epiphora, unspecified lacrimal gland', '', 'H04209', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5537, 'Epiphora due to excess lacrimation, right lacrimal gland', '', 'H04211', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5538, 'Epiphora due to excess lacrimation, left lacrimal gland', '', 'H04212', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5539, 'Epiphora due to excess lacrimation, bilateral lacrimal glands', '', 'H04213', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5540, 'Epiphora due to excess lacrimation, unspecified lacrimal gland', '', 'H04219', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5541, 'Epiphora due to insufficient drainage, right lacrimal gland', '', 'H04221', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5542, 'Epiphora due to insufficient drainage, left lacrimal gland', '', 'H04222', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5543, 'Epiphora due to insufficient drainage, bilateral lacrimal glands', '', 'H04223', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5544, 'Epiphora due to insufficient drainage, unspecified lacrimal gland', '', 'H04229', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5545, 'Unspecified dacryocystitis of right lacrimal passage', '', 'H04301', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5546, 'Unspecified dacryocystitis of left lacrimal passage', '', 'H04302', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5547, 'Unspecified dacryocystitis of bilateral lacrimal passages', '', 'H04303', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5548, 'Unspecified dacryocystitis of unspecified lacrimal passage', '', 'H04309', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5549, 'Phlegmonous dacryocystitis of right lacrimal passage', '', 'H04311', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5550, 'Phlegmonous dacryocystitis of left lacrimal passage', '', 'H04312', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5551, 'Phlegmonous dacryocystitis of bilateral lacrimal passages', '', 'H04313', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5552, 'Phlegmonous dacryocystitis of unspecified lacrimal passage', '', 'H04319', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5553, 'Acute dacryocystitis of right lacrimal passage', '', 'H04321', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5554, 'Acute dacryocystitis of left lacrimal passage', '', 'H04322', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5555, 'Acute dacryocystitis of bilateral lacrimal passages', '', 'H04323', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5556, 'Acute dacryocystitis of unspecified lacrimal passage', '', 'H04329', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5557, 'Acute lacrimal canaliculitis of right lacrimal passage', '', 'H04331', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5558, 'Acute lacrimal canaliculitis of left lacrimal passage', '', 'H04332', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5559, 'Acute lacrimal canaliculitis of bilateral lacrimal passages', '', 'H04333', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5560, 'Acute lacrimal canaliculitis of unspecified lacrimal passage', '', 'H04339', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5561, 'Chronic dacryocystitis of right lacrimal passage', '', 'H04411', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5562, 'Chronic dacryocystitis of left lacrimal passage', '', 'H04412', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5563, 'Chronic dacryocystitis of bilateral lacrimal passages', '', 'H04413', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5564, 'Chronic dacryocystitis of unspecified lacrimal passage', '', 'H04419', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5565, 'Chronic lacrimal canaliculitis of right lacrimal passage', '', 'H04421', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5566, 'Chronic lacrimal canaliculitis of left lacrimal passage', '', 'H04422', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5567, 'Chronic lacrimal canaliculitis of bilateral lacrimal passages', '', 'H04423', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5568, 'Chronic lacrimal canaliculitis of unspecified lacrimal passage', '', 'H04429', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5569, 'Chronic lacrimal mucocele of right lacrimal passage', '', 'H04431', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5570, 'Chronic lacrimal mucocele of left lacrimal passage', '', 'H04432', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5571, 'Chronic lacrimal mucocele of bilateral lacrimal passages', '', 'H04433', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5572, 'Chronic lacrimal mucocele of unspecified lacrimal passage', '', 'H04439', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5573, 'Dacryolith of right lacrimal passage', '', 'H04511', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5574, 'Dacryolith of left lacrimal passage', '', 'H04512', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5575, 'Dacryolith of bilateral lacrimal passages', '', 'H04513', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5576, 'Dacryolith of unspecified lacrimal passage', '', 'H04519', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5577, 'Eversion of right lacrimal punctum', '', 'H04521', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5578, 'Eversion of left lacrimal punctum', '', 'H04522', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5579, 'Eversion of bilateral lacrimal punctum', '', 'H04523', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5580, 'Eversion of unspecified lacrimal punctum', '', 'H04529', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5581, 'Neonatal obstruction of right nasolacrimal duct', '', 'H04531', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5582, 'Neonatal obstruction of left nasolacrimal duct', '', 'H04532', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5583, 'Neonatal obstruction of bilateral nasolacrimal duct', '', 'H04533', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5584, 'Neonatal obstruction of unspecified nasolacrimal duct', '', 'H04539', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5585, 'Stenosis of right lacrimal canaliculi', '', 'H04541', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5586, 'Stenosis of left lacrimal canaliculi', '', 'H04542', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5587, 'Stenosis of bilateral lacrimal canaliculi', '', 'H04543', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5588, 'Stenosis of unspecified lacrimal canaliculi', '', 'H04549', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5589, 'Acquired stenosis of right nasolacrimal duct', '', 'H04551', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5590, 'Acquired stenosis of left nasolacrimal duct', '', 'H04552', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5591, 'Acquired stenosis of bilateral nasolacrimal duct', '', 'H04553', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5592, 'Acquired stenosis of unspecified nasolacrimal duct', '', 'H04559', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5593, 'Stenosis of right lacrimal punctum', '', 'H04561', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5594, 'Stenosis of left lacrimal punctum', '', 'H04562', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5595, 'Stenosis of bilateral lacrimal punctum', '', 'H04563', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5596, 'Stenosis of unspecified lacrimal punctum', '', 'H04569', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5597, 'Stenosis of right lacrimal sac', '', 'H04571', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5598, 'Stenosis of left lacrimal sac', '', 'H04572', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5599, 'Stenosis of bilateral lacrimal sac', '', 'H04573', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5600, 'Stenosis of unspecified lacrimal sac', '', 'H04579', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5601, 'Lacrimal fistula right lacrimal passage', '', 'H04611', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5602, 'Lacrimal fistula left lacrimal passage', '', 'H04612', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5603, 'Lacrimal fistula bilateral lacrimal passages', '', 'H04613', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5604, 'Lacrimal fistula unspecified lacrimal passage', '', 'H04619', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5605, 'Other changes of lacrimal passages', '', 'H0469', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5606, 'Granuloma of right lacrimal passage', '', 'H04811', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5607, 'Granuloma of left lacrimal passage', '', 'H04812', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5608, 'Granuloma of bilateral lacrimal passages', '', 'H04813', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5609, 'Granuloma of unspecified lacrimal passage', '', 'H04819', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5610, 'Other disorders of lacrimal system', '', 'H0489', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5611, 'Disorder of lacrimal system, unspecified', '', 'H049', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5612, 'Unspecified acute inflammation of orbit', '', 'H0500', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5613, 'Cellulitis of right orbit', '', 'H05011', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5614, 'Cellulitis of left orbit', '', 'H05012', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5615, 'Cellulitis of bilateral orbits', '', 'H05013', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5616, 'Cellulitis of unspecified orbit', '', 'H05019', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5617, 'Osteomyelitis of right orbit', '', 'H05021', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5618, 'Osteomyelitis of left orbit', '', 'H05022', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5619, 'Osteomyelitis of bilateral orbits', '', 'H05023', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5620, 'Osteomyelitis of unspecified orbit', '', 'H05029', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5621, 'Periostitis of right orbit', '', 'H05031', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5622, 'Periostitis of left orbit', '', 'H05032', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5623, 'Periostitis of bilateral orbits', '', 'H05033', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5624, 'Periostitis of unspecified orbit', '', 'H05039', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5625, 'Tenonitis of right orbit', '', 'H05041', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5626, 'Tenonitis of left orbit', '', 'H05042', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5627, 'Tenonitis of bilateral orbits', '', 'H05043', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5628, 'Tenonitis of unspecified orbit', '', 'H05049', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5629, 'Unspecified chronic inflammatory disorders of orbit', '', 'H0510', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5630, 'Granuloma of right orbit', '', 'H05111', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5631, 'Granuloma of left orbit', '', 'H05112', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5632, 'Granuloma of bilateral orbits', '', 'H05113', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5633, 'Granuloma of unspecified orbit', '', 'H05119', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5634, 'Orbital myositis, right orbit', '', 'H05121', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5635, 'Orbital myositis, left orbit', '', 'H05122', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5636, 'Orbital myositis, bilateral', '', 'H05123', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5637, 'Orbital myositis, unspecified orbit', '', 'H05129', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5638, 'Unspecified exophthalmos', '', 'H0520', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5639, 'Displacement (lateral) of globe, right eye', '', 'H05211', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5640, 'Displacement (lateral) of globe, left eye', '', 'H05212', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5641, 'Displacement (lateral) of globe, bilateral', '', 'H05213', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5642, 'Displacement (lateral) of globe, unspecified eye', '', 'H05219', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5643, 'Edema of right orbit', '', 'H05221', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5644, 'Edema of left orbit', '', 'H05222', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5645, 'Edema of bilateral orbit', '', 'H05223', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5646, 'Edema of unspecified orbit', '', 'H05229', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5647, 'Hemorrhage of right orbit', '', 'H05231', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5648, 'Hemorrhage of left orbit', '', 'H05232', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5649, 'Hemorrhage of bilateral orbit', '', 'H05233', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5650, 'Hemorrhage of unspecified orbit', '', 'H05239', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5651, 'Constant exophthalmos, right eye', '', 'H05241', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5652, 'Constant exophthalmos, left eye', '', 'H05242', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5653, 'Constant exophthalmos, bilateral', '', 'H05243', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5654, 'Constant exophthalmos, unspecified eye', '', 'H05249', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5655, 'Intermittent exophthalmos, right eye', '', 'H05251', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5656, 'Intermittent exophthalmos, left eye', '', 'H05252', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5657, 'Intermittent exophthalmos, bilateral', '', 'H05253', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5658, 'Intermittent exophthalmos, unspecified eye', '', 'H05259', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5659, 'Pulsating exophthalmos, right eye', '', 'H05261', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5660, 'Pulsating exophthalmos, left eye', '', 'H05262', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5661, 'Pulsating exophthalmos, bilateral', '', 'H05263', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5662, 'Pulsating exophthalmos, unspecified eye', '', 'H05269', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5663, 'Unspecified deformity of orbit', '', 'H0530', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5664, 'Atrophy of right orbit', '', 'H05311', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5665, 'Atrophy of left orbit', '', 'H05312', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5666, 'Atrophy of bilateral orbit', '', 'H05313', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5667, 'Atrophy of unspecified orbit', '', 'H05319', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5668, 'Deformity of right orbit due to bone disease', '', 'H05321', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5669, 'Deformity of left orbit due to bone disease', '', 'H05322', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5670, 'Deformity of bilateral orbits due to bone disease', '', 'H05323', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5671, 'Deformity of unspecified orbit due to bone disease', '', 'H05329', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5672, 'Deformity of right orbit due to trauma or surgery', '', 'H05331', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5673, 'Deformity of left orbit due to trauma or surgery', '', 'H05332', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5674, 'Deformity of bilateral orbits due to trauma or surgery', '', 'H05333', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5675, 'Deformity of unspecified orbit due to trauma or surgery', '', 'H05339', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5676, 'Enlargement of right orbit', '', 'H05341', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5677, 'Enlargement of left orbit', '', 'H05342', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5678, 'Enlargement of bilateral orbits', '', 'H05343', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5679, 'Enlargement of unspecified orbit', '', 'H05349', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5680, 'Exostosis of right orbit', '', 'H05351', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5681, 'Exostosis of left orbit', '', 'H05352', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5682, 'Exostosis of bilateral orbits', '', 'H05353', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5683, 'Exostosis of unspecified orbit', '', 'H05359', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5684, 'Unspecified enophthalmos, right eye', '', 'H05401', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5685, 'Unspecified enophthalmos, left eye', '', 'H05402', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5686, 'Unspecified enophthalmos, bilateral', '', 'H05403', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5687, 'Unspecified enophthalmos, unspecified eye', '', 'H05409', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5688, 'Enophthalmos due to atrophy of orbital tissue, right eye', '', 'H05411', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5689, 'Enophthalmos due to atrophy of orbital tissue, left eye', '', 'H05412', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5690, 'Enophthalmos due to atrophy of orbital tissue, bilateral', '', 'H05413', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5691, 'Enophthalmos due to atrophy of orbital tissue, unspecified eye', '', 'H05419', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5692, 'Enophthalmos due to trauma or surgery, right eye', '', 'H05421', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5693, 'Enophthalmos due to trauma or surgery, left eye', '', 'H05422', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5694, 'Enophthalmos due to trauma or surgery, bilateral', '', 'H05423', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5695, 'Enophthalmos due to trauma or surgery, unspecified eye', '', 'H05429', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5696, 'Retained (old) foreign body following penetrating wound of unspecified orbit', '', 'H0550', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5697, 'Retained (old) foreign body following penetrating wound of right orbit', '', 'H0551', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5698, 'Retained (old) foreign body following penetrating wound of left orbit', '', 'H0552', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5699, 'Retained (old) foreign body following penetrating wound of bilateral orbits', '', 'H0553', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5700, 'Cyst of right orbit', '', 'H05811', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5701, 'Cyst of left orbit', '', 'H05812', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5702, 'Cyst of bilateral orbits', '', 'H05813', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5703, 'Cyst of unspecified orbit', '', 'H05819', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5704, 'Myopathy of extraocular muscles, right orbit', '', 'H05821', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5705, 'Myopathy of extraocular muscles, left orbit', '', 'H05822', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5706, 'Myopathy of extraocular muscles, bilateral', '', 'H05823', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5707, 'Myopathy of extraocular muscles, unspecified orbit', '', 'H05829', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5708, 'Other disorders of orbit', '', 'H0589', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5709, 'Unspecified disorder of orbit', '', 'H059', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5710, 'Acute follicular conjunctivitis, right eye', '', 'H10011', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5711, 'Acute follicular conjunctivitis, left eye', '', 'H10012', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5712, 'Acute follicular conjunctivitis, bilateral', '', 'H10013', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5713, 'Acute follicular conjunctivitis, unspecified eye', '', 'H10019', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5714, 'Other mucopurulent conjunctivitis, right eye', '', 'H10021', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5715, 'Other mucopurulent conjunctivitis, left eye', '', 'H10022', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5716, 'Other mucopurulent conjunctivitis, bilateral', '', 'H10023', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5717, 'Other mucopurulent conjunctivitis, unspecified eye', '', 'H10029', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5718, 'Acute atopic conjunctivitis, unspecified eye', '', 'H1010', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5719, 'Acute atopic conjunctivitis, right eye', '', 'H1011', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5720, 'Acute atopic conjunctivitis, left eye', '', 'H1012', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5721, 'Acute atopic conjunctivitis, bilateral', '', 'H1013', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5722, 'Acute toxic conjunctivitis, right eye', '', 'H10211', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5723, 'Acute toxic conjunctivitis, left eye', '', 'H10212', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5724, 'Acute toxic conjunctivitis, bilateral', '', 'H10213', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5725, 'Acute toxic conjunctivitis, unspecified eye', '', 'H10219', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5726, 'Pseudomembranous conjunctivitis, right eye', '', 'H10221', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5727, 'Pseudomembranous conjunctivitis, left eye', '', 'H10222', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5728, 'Pseudomembranous conjunctivitis, bilateral', '', 'H10223', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5729, 'Pseudomembranous conjunctivitis, unspecified eye', '', 'H10229', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5730, 'Serous conjunctivitis, except viral, right eye', '', 'H10231', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5731, 'Serous conjunctivitis, except viral, left eye', '', 'H10232', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5732, 'Serous conjunctivitis, except viral, bilateral', '', 'H10233', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5733, 'Serous conjunctivitis, except viral, unspecified eye', '', 'H10239', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5734, 'Unspecified acute conjunctivitis, unspecified eye', '', 'H1030', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5735, 'Unspecified acute conjunctivitis, right eye', '', 'H1031', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5736, 'Unspecified acute conjunctivitis, left eye', '', 'H1032', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5737, 'Unspecified acute conjunctivitis, bilateral', '', 'H1033', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5738, 'Unspecified chronic conjunctivitis, right eye', '', 'H10401', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5739, 'Unspecified chronic conjunctivitis, left eye', '', 'H10402', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5740, 'Unspecified chronic conjunctivitis, bilateral', '', 'H10403', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5741, 'Unspecified chronic conjunctivitis, unspecified eye', '', 'H10409', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5742, 'Chronic giant papillary conjunctivitis, right eye', '', 'H10411', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5743, 'Chronic giant papillary conjunctivitis, left eye', '', 'H10412', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5744, 'Chronic giant papillary conjunctivitis, bilateral', '', 'H10413', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5745, 'Chronic giant papillary conjunctivitis, unspecified eye', '', 'H10419', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5746, 'Simple chronic conjunctivitis, right eye', '', 'H10421', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5747, 'Simple chronic conjunctivitis, left eye', '', 'H10422', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5748, 'Simple chronic conjunctivitis, bilateral', '', 'H10423', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5749, 'Simple chronic conjunctivitis, unspecified eye', '', 'H10429', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5750, 'Chronic follicular conjunctivitis, right eye', '', 'H10431', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5751, 'Chronic follicular conjunctivitis, left eye', '', 'H10432', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5752, 'Chronic follicular conjunctivitis, bilateral', '', 'H10433', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5753, 'Chronic follicular conjunctivitis, unspecified eye', '', 'H10439', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5754, 'Vernal conjunctivitis', '', 'H1044', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5755, 'Other chronic allergic conjunctivitis', '', 'H1045', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5756, 'Unspecified blepharoconjunctivitis, right eye', '', 'H10501', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1);");


DB::statement("INSERT INTO `symptoms` (`id`, `symptoms_title`, `description`, `code`, `status`, `priority`, `created_at`, `updated_at`, `type`) VALUES
(5757, 'Unspecified blepharoconjunctivitis, left eye', '', 'H10502', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5758, 'Unspecified blepharoconjunctivitis, bilateral', '', 'H10503', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5759, 'Unspecified blepharoconjunctivitis, unspecified eye', '', 'H10509', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5760, 'Ligneous conjunctivitis, right eye', '', 'H10511', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5761, 'Ligneous conjunctivitis, left eye', '', 'H10512', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5762, 'Ligneous conjunctivitis, bilateral', '', 'H10513', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5763, 'Ligneous conjunctivitis, unspecified eye', '', 'H10519', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5764, 'Angular blepharoconjunctivitis, right eye', '', 'H10521', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5765, 'Angular blepharoconjunctivitis, left eye', '', 'H10522', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5766, 'Angular blepharoconjunctivitis, bilateral', '', 'H10523', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5767, 'Angular blepharoconjunctivitis, unspecified eye', '', 'H10529', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5768, 'Contact blepharoconjunctivitis, right eye', '', 'H10531', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5769, 'Contact blepharoconjunctivitis, left eye', '', 'H10532', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5770, 'Contact blepharoconjunctivitis, bilateral', '', 'H10533', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5771, 'Contact blepharoconjunctivitis, unspecified eye', '', 'H10539', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5772, 'Pingueculitis, right eye', '', 'H10811', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5773, 'Pingueculitis, left eye', '', 'H10812', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5774, 'Pingueculitis, bilateral', '', 'H10813', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5775, 'Pingueculitis, unspecified eye', '', 'H10819', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5776, 'Other conjunctivitis', '', 'H1089', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5777, 'Unspecified conjunctivitis', '', 'H109', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5778, 'Unspecified pterygium of right eye', '', 'H11001', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5779, 'Unspecified pterygium of left eye', '', 'H11002', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5780, 'Unspecified pterygium of eye, bilateral', '', 'H11003', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5781, 'Unspecified pterygium of unspecified eye', '', 'H11009', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5782, 'Amyloid pterygium of right eye', '', 'H11011', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5783, 'Amyloid pterygium of left eye', '', 'H11012', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5784, 'Amyloid pterygium of eye, bilateral', '', 'H11013', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5785, 'Amyloid pterygium of unspecified eye', '', 'H11019', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5786, 'Central pterygium of right eye', '', 'H11021', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5787, 'Central pterygium of left eye', '', 'H11022', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5788, 'Central pterygium of eye, bilateral', '', 'H11023', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5789, 'Central pterygium of unspecified eye', '', 'H11029', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5790, 'Double pterygium of right eye', '', 'H11031', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5791, 'Double pterygium of left eye', '', 'H11032', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5792, 'Double pterygium of eye, bilateral', '', 'H11033', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5793, 'Double pterygium of unspecified eye', '', 'H11039', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5794, 'Peripheral pterygium, stationary, right eye', '', 'H11041', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5795, 'Peripheral pterygium, stationary, left eye', '', 'H11042', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5796, 'Peripheral pterygium, stationary, bilateral', '', 'H11043', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5797, 'Peripheral pterygium, stationary, unspecified eye', '', 'H11049', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5798, 'Peripheral pterygium, progressive, right eye', '', 'H11051', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5799, 'Peripheral pterygium, progressive, left eye', '', 'H11052', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5800, 'Peripheral pterygium, progressive, bilateral', '', 'H11053', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5801, 'Peripheral pterygium, progressive, unspecified eye', '', 'H11059', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5802, 'Recurrent pterygium of right eye', '', 'H11061', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5803, 'Recurrent pterygium of left eye', '', 'H11062', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5804, 'Recurrent pterygium of eye, bilateral', '', 'H11063', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5805, 'Recurrent pterygium of unspecified eye', '', 'H11069', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5806, 'Unspecified conjunctival degenerations', '', 'H1110', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5807, 'Conjunctival deposits, right eye', '', 'H11111', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5808, 'Conjunctival deposits, left eye', '', 'H11112', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5809, 'Conjunctival deposits, bilateral', '', 'H11113', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5810, 'Conjunctival deposits, unspecified eye', '', 'H11119', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5811, 'Conjunctival concretions, right eye', '', 'H11121', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5812, 'Conjunctival concretions, left eye', '', 'H11122', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5813, 'Conjunctival concretions, bilateral', '', 'H11123', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5814, 'Conjunctival concretions, unspecified eye', '', 'H11129', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5815, 'Conjunctival pigmentations, right eye', '', 'H11131', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5816, 'Conjunctival pigmentations, left eye', '', 'H11132', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5817, 'Conjunctival pigmentations, bilateral', '', 'H11133', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5818, 'Conjunctival pigmentations, unspecified eye', '', 'H11139', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5819, 'Conjunctival xerosis, unspecified, right eye', '', 'H11141', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5820, 'Conjunctival xerosis, unspecified, left eye', '', 'H11142', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5821, 'Conjunctival xerosis, unspecified, bilateral', '', 'H11143', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5822, 'Conjunctival xerosis, unspecified, unspecified eye', '', 'H11149', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5823, 'Pinguecula, right eye', '', 'H11151', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5824, 'Pinguecula, left eye', '', 'H11152', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5825, 'Pinguecula, bilateral', '', 'H11153', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5826, 'Pinguecula, unspecified eye', '', 'H11159', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5827, 'Conjunctival adhesions and strands (localized), right eye', '', 'H11211', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5828, 'Conjunctival adhesions and strands (localized), left eye', '', 'H11212', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5829, 'Conjunctival adhesions and strands (localized), bilateral', '', 'H11213', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5830, 'Conjunctival adhesions and strands (localized), unspecified eye', '', 'H11219', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5831, 'Conjunctival granuloma, right eye', '', 'H11221', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5832, 'Conjunctival granuloma, left eye', '', 'H11222', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5833, 'Conjunctival granuloma, bilateral', '', 'H11223', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5834, 'Conjunctival granuloma, unspecified', '', 'H11229', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5835, 'Symblepharon, right eye', '', 'H11231', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5836, 'Symblepharon, left eye', '', 'H11232', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5837, 'Symblepharon, bilateral', '', 'H11233', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5838, 'Symblepharon, unspecified eye', '', 'H11239', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5839, 'Scarring of conjunctiva, right eye', '', 'H11241', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5840, 'Scarring of conjunctiva, left eye', '', 'H11242', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5841, 'Scarring of conjunctiva, bilateral', '', 'H11243', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5842, 'Scarring of conjunctiva, unspecified eye', '', 'H11249', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5843, 'Conjunctival hemorrhage, unspecified eye', '', 'H1130', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5844, 'Conjunctival hemorrhage, right eye', '', 'H1131', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5845, 'Conjunctival hemorrhage, left eye', '', 'H1132', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5846, 'Conjunctival hemorrhage, bilateral', '', 'H1133', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5847, 'Vascular abnormalities of conjunctiva, right eye', '', 'H11411', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5848, 'Vascular abnormalities of conjunctiva, left eye', '', 'H11412', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5849, 'Vascular abnormalities of conjunctiva, bilateral', '', 'H11413', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5850, 'Vascular abnormalities of conjunctiva, unspecified eye', '', 'H11419', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5851, 'Conjunctival edema, right eye', '', 'H11421', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5852, 'Conjunctival edema, left eye', '', 'H11422', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5853, 'Conjunctival edema, bilateral', '', 'H11423', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5854, 'Conjunctival edema, unspecified eye', '', 'H11429', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5855, 'Conjunctival hyperemia, right eye', '', 'H11431', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5856, 'Conjunctival hyperemia, left eye', '', 'H11432', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5857, 'Conjunctival hyperemia, bilateral', '', 'H11433', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5858, 'Conjunctival hyperemia, unspecified eye', '', 'H11439', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5859, 'Conjunctival cysts, right eye', '', 'H11441', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5860, 'Conjunctival cysts, left eye', '', 'H11442', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5861, 'Conjunctival cysts, bilateral', '', 'H11443', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5862, 'Conjunctival cysts, unspecified eye', '', 'H11449', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5863, 'Pseudopterygium of conjunctiva, right eye', '', 'H11811', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5864, 'Pseudopterygium of conjunctiva, left eye', '', 'H11812', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5865, 'Pseudopterygium of conjunctiva, bilateral', '', 'H11813', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5866, 'Pseudopterygium of conjunctiva, unspecified eye', '', 'H11819', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5867, 'Conjunctivochalasis, right eye', '', 'H11821', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5868, 'Conjunctivochalasis, left eye', '', 'H11822', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5869, 'Conjunctivochalasis, bilateral', '', 'H11823', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5870, 'Conjunctivochalasis, unspecified eye', '', 'H11829', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5871, 'Other specified disorders of conjunctiva', '', 'H1189', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5872, 'Unspecified disorder of conjunctiva', '', 'H119', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5873, 'Unspecified scleritis, right eye', '', 'H15001', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5874, 'Unspecified scleritis, left eye', '', 'H15002', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5875, 'Unspecified scleritis, bilateral', '', 'H15003', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5876, 'Unspecified scleritis, unspecified eye', '', 'H15009', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5877, 'Anterior scleritis, right eye', '', 'H15011', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5878, 'Anterior scleritis, left eye', '', 'H15012', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5879, 'Anterior scleritis, bilateral', '', 'H15013', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5880, 'Anterior scleritis, unspecified eye', '', 'H15019', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5881, 'Brawny scleritis, right eye', '', 'H15021', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5882, 'Brawny scleritis, left eye', '', 'H15022', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5883, 'Brawny scleritis, bilateral', '', 'H15023', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5884, 'Brawny scleritis, unspecified eye', '', 'H15029', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5885, 'Posterior scleritis, right eye', '', 'H15031', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5886, 'Posterior scleritis, left eye', '', 'H15032', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5887, 'Posterior scleritis, bilateral', '', 'H15033', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5888, 'Posterior scleritis, unspecified eye', '', 'H15039', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5889, 'Scleritis with corneal involvement, right eye', '', 'H15041', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5890, 'Scleritis with corneal involvement, left eye', '', 'H15042', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5891, 'Scleritis with corneal involvement, bilateral', '', 'H15043', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5892, 'Scleritis with corneal involvement, unspecified eye', '', 'H15049', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5893, 'Scleromalacia perforans, right eye', '', 'H15051', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5894, 'Scleromalacia perforans, left eye', '', 'H15052', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5895, 'Scleromalacia perforans, bilateral', '', 'H15053', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5896, 'Scleromalacia perforans, unspecified eye', '', 'H15059', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5897, 'Other scleritis, right eye', '', 'H15091', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5898, 'Other scleritis, left eye', '', 'H15092', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5899, 'Other scleritis, bilateral', '', 'H15093', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5900, 'Other scleritis, unspecified eye', '', 'H15099', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5901, 'Unspecified episcleritis, right eye', '', 'H15101', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5902, 'Unspecified episcleritis, left eye', '', 'H15102', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5903, 'Unspecified episcleritis, bilateral', '', 'H15103', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5904, 'Unspecified episcleritis, unspecified eye', '', 'H15109', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5905, 'Episcleritis periodica fugax, right eye', '', 'H15111', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5906, 'Episcleritis periodica fugax, left eye', '', 'H15112', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5907, 'Episcleritis periodica fugax, bilateral', '', 'H15113', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5908, 'Episcleritis periodica fugax, unspecified eye', '', 'H15119', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5909, 'Nodular episcleritis, right eye', '', 'H15121', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5910, 'Nodular episcleritis, left eye', '', 'H15122', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5911, 'Nodular episcleritis, bilateral', '', 'H15123', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5912, 'Nodular episcleritis, unspecified eye', '', 'H15129', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5913, 'Equatorial staphyloma, right eye', '', 'H15811', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5914, 'Equatorial staphyloma, left eye', '', 'H15812', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5915, 'Equatorial staphyloma, bilateral', '', 'H15813', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5916, 'Equatorial staphyloma, unspecified eye', '', 'H15819', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5917, 'Localized anterior staphyloma, right eye', '', 'H15821', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5918, 'Localized anterior staphyloma, left eye', '', 'H15822', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5919, 'Localized anterior staphyloma, bilateral', '', 'H15823', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5920, 'Localized anterior staphyloma, unspecified eye', '', 'H15829', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5921, 'Staphyloma posticum, right eye', '', 'H15831', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5922, 'Staphyloma posticum, left eye', '', 'H15832', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5923, 'Staphyloma posticum, bilateral', '', 'H15833', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5924, 'Staphyloma posticum, unspecified eye', '', 'H15839', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5925, 'Scleral ectasia, right eye', '', 'H15841', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5926, 'Scleral ectasia, left eye', '', 'H15842', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5927, 'Scleral ectasia, bilateral', '', 'H15843', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5928, 'Scleral ectasia, unspecified eye', '', 'H15849', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5929, 'Ring staphyloma, right eye', '', 'H15851', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5930, 'Ring staphyloma, left eye', '', 'H15852', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5931, 'Ring staphyloma, bilateral', '', 'H15853', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5932, 'Ring staphyloma, unspecified eye', '', 'H15859', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5933, 'Other disorders of sclera', '', 'H1589', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5934, 'Unspecified disorder of sclera', '', 'H159', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5935, 'Unspecified corneal ulcer, right eye', '', 'H16001', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5936, 'Unspecified corneal ulcer, left eye', '', 'H16002', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5937, 'Unspecified corneal ulcer, bilateral', '', 'H16003', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5938, 'Unspecified corneal ulcer, unspecified eye', '', 'H16009', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5939, 'Central corneal ulcer, right eye', '', 'H16011', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5940, 'Central corneal ulcer, left eye', '', 'H16012', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5941, 'Central corneal ulcer, bilateral', '', 'H16013', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5942, 'Central corneal ulcer, unspecified eye', '', 'H16019', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5943, 'Ring corneal ulcer, right eye', '', 'H16021', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5944, 'Ring corneal ulcer, left eye', '', 'H16022', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5945, 'Ring corneal ulcer, bilateral', '', 'H16023', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5946, 'Ring corneal ulcer, unspecified eye', '', 'H16029', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5947, 'Corneal ulcer with hypopyon, right eye', '', 'H16031', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5948, 'Corneal ulcer with hypopyon, left eye', '', 'H16032', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5949, 'Corneal ulcer with hypopyon, bilateral', '', 'H16033', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5950, 'Corneal ulcer with hypopyon, unspecified eye', '', 'H16039', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5951, 'Marginal corneal ulcer, right eye', '', 'H16041', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5952, 'Marginal corneal ulcer, left eye', '', 'H16042', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5953, 'Marginal corneal ulcer, bilateral', '', 'H16043', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5954, 'Marginal corneal ulcer, unspecified eye', '', 'H16049', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5955, 'Mooren\'s corneal ulcer, right eye', '', 'H16051', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5956, 'Mooren\'s corneal ulcer, left eye', '', 'H16052', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5957, 'Mooren\'s corneal ulcer, bilateral', '', 'H16053', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5958, 'Mooren\'s corneal ulcer, unspecified eye', '', 'H16059', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5959, 'Mycotic corneal ulcer, right eye', '', 'H16061', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5960, 'Mycotic corneal ulcer, left eye', '', 'H16062', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5961, 'Mycotic corneal ulcer, bilateral', '', 'H16063', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5962, 'Mycotic corneal ulcer, unspecified eye', '', 'H16069', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5963, 'Perforated corneal ulcer, right eye', '', 'H16071', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5964, 'Perforated corneal ulcer, left eye', '', 'H16072', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5965, 'Perforated corneal ulcer, bilateral', '', 'H16073', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5966, 'Perforated corneal ulcer, unspecified eye', '', 'H16079', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5967, 'Unspecified superficial keratitis, right eye', '', 'H16101', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5968, 'Unspecified superficial keratitis, left eye', '', 'H16102', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5969, 'Unspecified superficial keratitis, bilateral', '', 'H16103', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5970, 'Unspecified superficial keratitis, unspecified eye', '', 'H16109', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5971, 'Macular keratitis, right eye', '', 'H16111', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5972, 'Macular keratitis, left eye', '', 'H16112', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5973, 'Macular keratitis, bilateral', '', 'H16113', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5974, 'Macular keratitis, unspecified eye', '', 'H16119', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5975, 'Filamentary keratitis, right eye', '', 'H16121', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5976, 'Filamentary keratitis, left eye', '', 'H16122', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5977, 'Filamentary keratitis, bilateral', '', 'H16123', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5978, 'Filamentary keratitis, unspecified eye', '', 'H16129', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5979, 'Photokeratitis, right eye', '', 'H16131', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5980, 'Photokeratitis, left eye', '', 'H16132', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5981, 'Photokeratitis, bilateral', '', 'H16133', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5982, 'Photokeratitis, unspecified eye', '', 'H16139', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5983, 'Punctate keratitis, right eye', '', 'H16141', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5984, 'Punctate keratitis, left eye', '', 'H16142', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5985, 'Punctate keratitis, bilateral', '', 'H16143', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5986, 'Punctate keratitis, unspecified eye', '', 'H16149', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5987, 'Unspecified keratoconjunctivitis, right eye', '', 'H16201', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5988, 'Unspecified keratoconjunctivitis, left eye', '', 'H16202', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5989, 'Unspecified keratoconjunctivitis, bilateral', '', 'H16203', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5990, 'Unspecified keratoconjunctivitis, unspecified eye', '', 'H16209', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5991, 'Exposure keratoconjunctivitis, right eye', '', 'H16211', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5992, 'Exposure keratoconjunctivitis, left eye', '', 'H16212', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5993, 'Exposure keratoconjunctivitis, bilateral', '', 'H16213', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5994, 'Exposure keratoconjunctivitis, unspecified eye', '', 'H16219', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5995, 'Keratoconjunctivitis sicca, not specified as Sjogren\'s, right eye', '', 'H16221', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5996, 'Keratoconjunctivitis sicca, not specified as Sjogren\'s, left eye', '', 'H16222', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5997, 'Keratoconjunctivitis sicca, not specified as Sjogren\'s, bilateral', '', 'H16223', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5998, 'Keratoconjunctivitis sicca, not specified as Sjogren\'s, unspecified eye', '', 'H16229', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(5999, 'Neurotrophic keratoconjunctivitis, right eye', '', 'H16231', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6000, 'Neurotrophic keratoconjunctivitis, left eye', '', 'H16232', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6001, 'Neurotrophic keratoconjunctivitis, bilateral', '', 'H16233', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6002, 'Neurotrophic keratoconjunctivitis, unspecified eye', '', 'H16239', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6003, 'Ophthalmia nodosa, right eye', '', 'H16241', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6004, 'Ophthalmia nodosa, left eye', '', 'H16242', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6005, 'Ophthalmia nodosa, bilateral', '', 'H16243', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6006, 'Ophthalmia nodosa, unspecified eye', '', 'H16249', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6007, 'Phlyctenular keratoconjunctivitis, right eye', '', 'H16251', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6008, 'Phlyctenular keratoconjunctivitis, left eye', '', 'H16252', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6009, 'Phlyctenular keratoconjunctivitis, bilateral', '', 'H16253', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6010, 'Phlyctenular keratoconjunctivitis, unspecified eye', '', 'H16259', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6011, 'Vernal keratoconjunctivitis, with limbar and corneal involvement, right eye', '', 'H16261', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6012, 'Vernal keratoconjunctivitis, with limbar and corneal involvement, left eye', '', 'H16262', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6013, 'Vernal keratoconjunctivitis, with limbar and corneal involvement, bilateral', '', 'H16263', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6014, 'Vernal keratoconjunctivitis, with limbar and corneal involvement, unspecified eye', '', 'H16269', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6015, 'Other keratoconjunctivitis, right eye', '', 'H16291', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6016, 'Other keratoconjunctivitis, left eye', '', 'H16292', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6017, 'Other keratoconjunctivitis, bilateral', '', 'H16293', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6018, 'Other keratoconjunctivitis, unspecified eye', '', 'H16299', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6019, 'Unspecified interstitial keratitis, right eye', '', 'H16301', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6020, 'Unspecified interstitial keratitis, left eye', '', 'H16302', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6021, 'Unspecified interstitial keratitis, bilateral', '', 'H16303', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6022, 'Unspecified interstitial keratitis, unspecified eye', '', 'H16309', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6023, 'Corneal abscess, right eye', '', 'H16311', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6024, 'Corneal abscess, left eye', '', 'H16312', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6025, 'Corneal abscess, bilateral', '', 'H16313', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6026, 'Corneal abscess, unspecified eye', '', 'H16319', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6027, 'Diffuse interstitial keratitis, right eye', '', 'H16321', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6028, 'Diffuse interstitial keratitis, left eye', '', 'H16322', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6029, 'Diffuse interstitial keratitis, bilateral', '', 'H16323', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6030, 'Diffuse interstitial keratitis, unspecified eye', '', 'H16329', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6031, 'Sclerosing keratitis, right eye', '', 'H16331', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6032, 'Sclerosing keratitis, left eye', '', 'H16332', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6033, 'Sclerosing keratitis, bilateral', '', 'H16333', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6034, 'Sclerosing keratitis, unspecified eye', '', 'H16339', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6035, 'Other interstitial and deep keratitis, right eye', '', 'H16391', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6036, 'Other interstitial and deep keratitis, left eye', '', 'H16392', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6037, 'Other interstitial and deep keratitis, bilateral', '', 'H16393', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6038, 'Other interstitial and deep keratitis, unspecified eye', '', 'H16399', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6039, 'Unspecified corneal neovascularization, right eye', '', 'H16401', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6040, 'Unspecified corneal neovascularization, left eye', '', 'H16402', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6041, 'Unspecified corneal neovascularization, bilateral', '', 'H16403', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6042, 'Unspecified corneal neovascularization, unspecified eye', '', 'H16409', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6043, 'Ghost vessels (corneal), right eye', '', 'H16411', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6044, 'Ghost vessels (corneal), left eye', '', 'H16412', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6045, 'Ghost vessels (corneal), bilateral', '', 'H16413', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6046, 'Ghost vessels (corneal), unspecified eye', '', 'H16419', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6047, 'Pannus (corneal), right eye', '', 'H16421', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6048, 'Pannus (corneal), left eye', '', 'H16422', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6049, 'Pannus (corneal), bilateral', '', 'H16423', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6050, 'Pannus (corneal), unspecified eye', '', 'H16429', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6051, 'Localized vascularization of cornea, right eye', '', 'H16431', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6052, 'Localized vascularization of cornea, left eye', '', 'H16432', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6053, 'Localized vascularization of cornea, bilateral', '', 'H16433', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6054, 'Localized vascularization of cornea, unspecified eye', '', 'H16439', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6055, 'Deep vascularization of cornea, right eye', '', 'H16441', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6056, 'Deep vascularization of cornea, left eye', '', 'H16442', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6057, 'Deep vascularization of cornea, bilateral', '', 'H16443', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6058, 'Deep vascularization of cornea, unspecified eye', '', 'H16449', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6059, 'Other keratitis', '', 'H168', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6060, 'Unspecified keratitis', '', 'H169', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6061, 'Adherent leukoma, unspecified eye', '', 'H1700', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6062, 'Adherent leukoma, right eye', '', 'H1701', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6063, 'Adherent leukoma, left eye', '', 'H1702', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6064, 'Adherent leukoma, bilateral', '', 'H1703', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6065, 'Central corneal opacity, unspecified eye', '', 'H1710', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6066, 'Central corneal opacity, right eye', '', 'H1711', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6067, 'Central corneal opacity, left eye', '', 'H1712', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6068, 'Central corneal opacity, bilateral', '', 'H1713', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6069, 'Minor opacity of cornea, right eye', '', 'H17811', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6070, 'Minor opacity of cornea, left eye', '', 'H17812', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6071, 'Minor opacity of cornea, bilateral', '', 'H17813', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6072, 'Minor opacity of cornea, unspecified eye', '', 'H17819', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6073, 'Peripheral opacity of cornea, right eye', '', 'H17821', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6074, 'Peripheral opacity of cornea, left eye', '', 'H17822', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6075, 'Peripheral opacity of cornea, bilateral', '', 'H17823', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6076, 'Peripheral opacity of cornea, unspecified eye', '', 'H17829', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6077, 'Other corneal scars and opacities', '', 'H1789', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6078, 'Unspecified corneal scar and opacity', '', 'H179', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6079, 'Unspecified corneal deposit, right eye', '', 'H18001', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6080, 'Unspecified corneal deposit, left eye', '', 'H18002', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6081, 'Unspecified corneal deposit, bilateral', '', 'H18003', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6082, 'Unspecified corneal deposit, unspecified eye', '', 'H18009', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6083, 'Anterior corneal pigmentations, right eye', '', 'H18011', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6084, 'Anterior corneal pigmentations, left eye', '', 'H18012', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6085, 'Anterior corneal pigmentations, bilateral', '', 'H18013', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6086, 'Anterior corneal pigmentations, unspecified eye', '', 'H18019', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6087, 'Argentous corneal deposits, right eye', '', 'H18021', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6088, 'Argentous corneal deposits, left eye', '', 'H18022', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6089, 'Argentous corneal deposits, bilateral', '', 'H18023', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6090, 'Argentous corneal deposits, unspecified eye', '', 'H18029', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6091, 'Corneal deposits in metabolic disorders, right eye', '', 'H18031', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6092, 'Corneal deposits in metabolic disorders, left eye', '', 'H18032', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6093, 'Corneal deposits in metabolic disorders, bilateral', '', 'H18033', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6094, 'Corneal deposits in metabolic disorders, unspecified eye', '', 'H18039', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6095, 'Kayser-Fleischer ring, right eye', '', 'H18041', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6096, 'Kayser-Fleischer ring, left eye', '', 'H18042', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6097, 'Kayser-Fleischer ring, bilateral', '', 'H18043', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6098, 'Kayser-Fleischer ring, unspecified eye', '', 'H18049', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6099, 'Posterior corneal pigmentations, right eye', '', 'H18051', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6100, 'Posterior corneal pigmentations, left eye', '', 'H18052', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6101, 'Posterior corneal pigmentations, bilateral', '', 'H18053', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6102, 'Posterior corneal pigmentations, unspecified eye', '', 'H18059', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6103, 'Stromal corneal pigmentations, right eye', '', 'H18061', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6104, 'Stromal corneal pigmentations, left eye', '', 'H18062', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6105, 'Stromal corneal pigmentations, bilateral', '', 'H18063', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6106, 'Stromal corneal pigmentations, unspecified eye', '', 'H18069', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6107, 'Bullous keratopathy, unspecified eye', '', 'H1810', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6108, 'Bullous keratopathy, right eye', '', 'H1811', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6109, 'Bullous keratopathy, left eye', '', 'H1812', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6110, 'Bullous keratopathy, bilateral', '', 'H1813', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6111, 'Unspecified corneal edema', '', 'H1820', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6112, 'Corneal edema secondary to contact lens, right eye', '', 'H18211', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6113, 'Corneal edema secondary to contact lens, left eye', '', 'H18212', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6114, 'Corneal edema secondary to contact lens, bilateral', '', 'H18213', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6115, 'Corneal edema secondary to contact lens, unspecified eye', '', 'H18219', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6116, 'Idiopathic corneal edema, right eye', '', 'H18221', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6117, 'Idiopathic corneal edema, left eye', '', 'H18222', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6118, 'Idiopathic corneal edema, bilateral', '', 'H18223', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6119, 'Idiopathic corneal edema, unspecified eye', '', 'H18229', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6120, 'Secondary corneal edema, right eye', '', 'H18231', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6121, 'Secondary corneal edema, left eye', '', 'H18232', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6122, 'Secondary corneal edema, bilateral', '', 'H18233', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6123, 'Secondary corneal edema, unspecified eye', '', 'H18239', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6124, 'Unspecified corneal membrane change', '', 'H1830', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6125, 'Folds and rupture in Bowman\'s membrane, right eye', '', 'H18311', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6126, 'Folds and rupture in Bowman\'s membrane, left eye', '', 'H18312', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6127, 'Folds and rupture in Bowman\'s membrane, bilateral', '', 'H18313', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6128, 'Folds and rupture in Bowman\'s membrane, unspecified eye', '', 'H18319', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6129, 'Folds in Descemet\'s membrane, right eye', '', 'H18321', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6130, 'Folds in Descemet\'s membrane, left eye', '', 'H18322', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6131, 'Folds in Descemet\'s membrane, bilateral', '', 'H18323', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6132, 'Folds in Descemet\'s membrane, unspecified eye', '', 'H18329', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6133, 'Rupture in Descemet\'s membrane, right eye', '', 'H18331', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6134, 'Rupture in Descemet\'s membrane, left eye', '', 'H18332', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6135, 'Rupture in Descemet\'s membrane, bilateral', '', 'H18333', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6136, 'Rupture in Descemet\'s membrane, unspecified eye', '', 'H18339', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6137, 'Unspecified corneal degeneration', '', 'H1840', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6138, 'Arcus senilis, right eye', '', 'H18411', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6139, 'Arcus senilis, left eye', '', 'H18412', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6140, 'Arcus senilis, bilateral', '', 'H18413', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6141, 'Arcus senilis, unspecified eye', '', 'H18419', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6142, 'Band keratopathy, right eye', '', 'H18421', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6143, 'Band keratopathy, left eye', '', 'H18422', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6144, 'Band keratopathy, bilateral', '', 'H18423', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6145, 'Band keratopathy, unspecified eye', '', 'H18429', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6146, 'Other calcerous corneal degeneration', '', 'H1843', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6147, 'Keratomalacia, right eye', '', 'H18441', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6148, 'Keratomalacia, left eye', '', 'H18442', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6149, 'Keratomalacia, bilateral', '', 'H18443', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6150, 'Keratomalacia, unspecified eye', '', 'H18449', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6151, 'Nodular corneal degeneration, right eye', '', 'H18451', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6152, 'Nodular corneal degeneration, left eye', '', 'H18452', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6153, 'Nodular corneal degeneration, bilateral', '', 'H18453', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6154, 'Nodular corneal degeneration, unspecified eye', '', 'H18459', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6155, 'Peripheral corneal degeneration, right eye', '', 'H18461', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6156, 'Peripheral corneal degeneration, left eye', '', 'H18462', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6157, 'Peripheral corneal degeneration, bilateral', '', 'H18463', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6158, 'Peripheral corneal degeneration, unspecified eye', '', 'H18469', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6159, 'Other corneal degeneration', '', 'H1849', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6160, 'Unspecified hereditary corneal dystrophies', '', 'H1850', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6161, 'Endothelial corneal dystrophy', '', 'H1851', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6162, 'Epithelial (juvenile) corneal dystrophy', '', 'H1852', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6163, 'Granular corneal dystrophy', '', 'H1853', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6164, 'Lattice corneal dystrophy', '', 'H1854', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6165, 'Macular corneal dystrophy', '', 'H1855', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6166, 'Other hereditary corneal dystrophies', '', 'H1859', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6167, 'Keratoconus, unspecified, right eye', '', 'H18601', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6168, 'Keratoconus, unspecified, left eye', '', 'H18602', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6169, 'Keratoconus, unspecified, bilateral', '', 'H18603', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6170, 'Keratoconus, unspecified, unspecified eye', '', 'H18609', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6171, 'Keratoconus, stable, right eye', '', 'H18611', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6172, 'Keratoconus, stable, left eye', '', 'H18612', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6173, 'Keratoconus, stable, bilateral', '', 'H18613', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6174, 'Keratoconus, stable, unspecified eye', '', 'H18619', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6175, 'Keratoconus, unstable, right eye', '', 'H18621', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1);");

DB::statement("INSERT INTO `symptoms` (`id`, `symptoms_title`, `description`, `code`, `status`, `priority`, `created_at`, `updated_at`, `type`) VALUES
(6176, 'Keratoconus, unstable, left eye', '', 'H18622', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6177, 'Keratoconus, unstable, bilateral', '', 'H18623', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6178, 'Keratoconus, unstable, unspecified eye', '', 'H18629', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6179, 'Unspecified corneal deformity', '', 'H1870', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6180, 'Corneal ectasia, right eye', '', 'H18711', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6181, 'Corneal ectasia, left eye', '', 'H18712', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6182, 'Corneal ectasia, bilateral', '', 'H18713', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6183, 'Corneal ectasia, unspecified eye', '', 'H18719', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6184, 'Corneal staphyloma, right eye', '', 'H18721', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6185, 'Corneal staphyloma, left eye', '', 'H18722', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6186, 'Corneal staphyloma, bilateral', '', 'H18723', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6187, 'Corneal staphyloma, unspecified eye', '', 'H18729', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6188, 'Descemetocele, right eye', '', 'H18731', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6189, 'Descemetocele, left eye', '', 'H18732', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6190, 'Descemetocele, bilateral', '', 'H18733', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6191, 'Descemetocele, unspecified eye', '', 'H18739', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6192, 'Other corneal deformities, right eye', '', 'H18791', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6193, 'Other corneal deformities, left eye', '', 'H18792', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6194, 'Other corneal deformities, bilateral', '', 'H18793', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6195, 'Other corneal deformities, unspecified eye', '', 'H18799', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6196, 'Anesthesia and hypoesthesia of cornea, right eye', '', 'H18811', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6197, 'Anesthesia and hypoesthesia of cornea, left eye', '', 'H18812', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6198, 'Anesthesia and hypoesthesia of cornea, bilateral', '', 'H18813', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6199, 'Anesthesia and hypoesthesia of cornea, unspecified eye', '', 'H18819', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6200, 'Corneal disorder due to contact lens, right eye', '', 'H18821', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6201, 'Corneal disorder due to contact lens, left eye', '', 'H18822', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6202, 'Corneal disorder due to contact lens, bilateral', '', 'H18823', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6203, 'Corneal disorder due to contact lens, unspecified eye', '', 'H18829', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6204, 'Recurrent erosion of cornea, right eye', '', 'H18831', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6205, 'Recurrent erosion of cornea, left eye', '', 'H18832', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6206, 'Recurrent erosion of cornea, bilateral', '', 'H18833', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6207, 'Recurrent erosion of cornea, unspecified eye', '', 'H18839', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6208, 'Other specified disorders of cornea, right eye', '', 'H18891', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6209, 'Other specified disorders of cornea, left eye', '', 'H18892', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6210, 'Other specified disorders of cornea, bilateral', '', 'H18893', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6211, 'Other specified disorders of cornea, unspecified eye', '', 'H18899', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6212, 'Unspecified disorder of cornea', '', 'H189', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6213, 'Unspecified acute and subacute iridocyclitis', '', 'H2000', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6214, 'Primary iridocyclitis, right eye', '', 'H20011', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6215, 'Primary iridocyclitis, left eye', '', 'H20012', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6216, 'Primary iridocyclitis, bilateral', '', 'H20013', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6217, 'Primary iridocyclitis, unspecified eye', '', 'H20019', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6218, 'Recurrent acute iridocyclitis, right eye', '', 'H20021', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6219, 'Recurrent acute iridocyclitis, left eye', '', 'H20022', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6220, 'Recurrent acute iridocyclitis, bilateral', '', 'H20023', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6221, 'Recurrent acute iridocyclitis, unspecified eye', '', 'H20029', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6222, 'Secondary infectious iridocyclitis, right eye', '', 'H20031', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6223, 'Secondary infectious iridocyclitis, left eye', '', 'H20032', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6224, 'Secondary infectious iridocyclitis, bilateral', '', 'H20033', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6225, 'Secondary infectious iridocyclitis, unspecified eye', '', 'H20039', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6226, 'Secondary noninfectious iridocyclitis, right eye', '', 'H20041', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6227, 'Secondary noninfectious iridocyclitis, left eye', '', 'H20042', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6228, 'Secondary noninfectious iridocyclitis, bilateral', '', 'H20043', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6229, 'Secondary noninfectious iridocyclitis, unspecified eye', '', 'H20049', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6230, 'Hypopyon, right eye', '', 'H20051', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6231, 'Hypopyon, left eye', '', 'H20052', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6232, 'Hypopyon, bilateral', '', 'H20053', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6233, 'Hypopyon, unspecified eye', '', 'H20059', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6234, 'Chronic iridocyclitis, unspecified eye', '', 'H2010', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6235, 'Chronic iridocyclitis, right eye', '', 'H2011', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6236, 'Chronic iridocyclitis, left eye', '', 'H2012', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6237, 'Chronic iridocyclitis, bilateral', '', 'H2013', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6238, 'Lens-induced iridocyclitis, unspecified eye', '', 'H2020', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6239, 'Lens-induced iridocyclitis, right eye', '', 'H2021', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6240, 'Lens-induced iridocyclitis, left eye', '', 'H2022', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6241, 'Lens-induced iridocyclitis, bilateral', '', 'H2023', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6242, 'Fuchs\' heterochromic cyclitis, right eye', '', 'H20811', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6243, 'Fuchs\' heterochromic cyclitis, left eye', '', 'H20812', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6244, 'Fuchs\' heterochromic cyclitis, bilateral', '', 'H20813', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6245, 'Fuchs\' heterochromic cyclitis, unspecified eye', '', 'H20819', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6246, 'Vogt-Koyanagi syndrome, right eye', '', 'H20821', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6247, 'Vogt-Koyanagi syndrome, left eye', '', 'H20822', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6248, 'Vogt-Koyanagi syndrome, bilateral', '', 'H20823', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6249, 'Vogt-Koyanagi syndrome, unspecified eye', '', 'H20829', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6250, 'Unspecified iridocyclitis', '', 'H209', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6251, 'Hyphema, unspecified eye', '', 'H2100', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6252, 'Hyphema, right eye', '', 'H2101', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6253, 'Hyphema, left eye', '', 'H2102', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6254, 'Hyphema, bilateral', '', 'H2103', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6255, 'Other vascular disorders of iris and ciliary body, right eye', '', 'H211X1', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6256, 'Other vascular disorders of iris and ciliary body, left eye', '', 'H211X2', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6257, 'Other vascular disorders of iris and ciliary body, bilateral', '', 'H211X3', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6258, 'Other vascular disorders of iris and ciliary body, unspecified eye', '', 'H211X9', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6259, 'Degeneration of chamber angle, right eye', '', 'H21211', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6260, 'Degeneration of chamber angle, left eye', '', 'H21212', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6261, 'Degeneration of chamber angle, bilateral', '', 'H21213', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6262, 'Degeneration of chamber angle, unspecified eye', '', 'H21219', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6263, 'Degeneration of ciliary body, right eye', '', 'H21221', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6264, 'Degeneration of ciliary body, left eye', '', 'H21222', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6265, 'Degeneration of ciliary body, bilateral', '', 'H21223', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6266, 'Degeneration of ciliary body, unspecified eye', '', 'H21229', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6267, 'Degeneration of iris (pigmentary), right eye', '', 'H21231', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6268, 'Degeneration of iris (pigmentary), left eye', '', 'H21232', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6269, 'Degeneration of iris (pigmentary), bilateral', '', 'H21233', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6270, 'Degeneration of iris (pigmentary), unspecified eye', '', 'H21239', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6271, 'Degeneration of pupillary margin, right eye', '', 'H21241', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6272, 'Degeneration of pupillary margin, left eye', '', 'H21242', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6273, 'Degeneration of pupillary margin, bilateral', '', 'H21243', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6274, 'Degeneration of pupillary margin, unspecified eye', '', 'H21249', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6275, 'Iridoschisis, right eye', '', 'H21251', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6276, 'Iridoschisis, left eye', '', 'H21252', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6277, 'Iridoschisis, bilateral', '', 'H21253', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6278, 'Iridoschisis, unspecified eye', '', 'H21259', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6279, 'Iris atrophy (essential) (progressive), right eye', '', 'H21261', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6280, 'Iris atrophy (essential) (progressive), left eye', '', 'H21262', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6281, 'Iris atrophy (essential) (progressive), bilateral', '', 'H21263', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6282, 'Iris atrophy (essential) (progressive), unspecified eye', '', 'H21269', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6283, 'Miotic pupillary cyst, right eye', '', 'H21271', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6284, 'Miotic pupillary cyst, left eye', '', 'H21272', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6285, 'Miotic pupillary cyst, bilateral', '', 'H21273', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6286, 'Miotic pupillary cyst, unspecified eye', '', 'H21279', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6287, 'Other iris atrophy', '', 'H2129', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6288, 'Idiopathic cysts of iris, ciliary body or anterior chamber, right eye', '', 'H21301', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6289, 'Idiopathic cysts of iris, ciliary body or anterior chamber, left eye', '', 'H21302', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6290, 'Idiopathic cysts of iris, ciliary body or anterior chamber, bilateral', '', 'H21303', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6291, 'Idiopathic cysts of iris, ciliary body or anterior chamber, unspecified eye', '', 'H21309', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6292, 'Exudative cysts of iris or anterior chamber, right eye', '', 'H21311', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6293, 'Exudative cysts of iris or anterior chamber, left eye', '', 'H21312', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6294, 'Exudative cysts of iris or anterior chamber, bilateral', '', 'H21313', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6295, 'Exudative cysts of iris or anterior chamber, unspecified eye', '', 'H21319', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6296, 'Implantation cysts of iris, ciliary body or anterior chamber, right eye', '', 'H21321', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6297, 'Implantation cysts of iris, ciliary body or anterior chamber, left eye', '', 'H21322', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6298, 'Implantation cysts of iris, ciliary body or anterior chamber, bilateral', '', 'H21323', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6299, 'Implantation cysts of iris, ciliary body or anterior chamber, unspecified eye', '', 'H21329', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6300, 'Parasitic cyst of iris, ciliary body or anterior chamber, right eye', '', 'H21331', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6301, 'Parasitic cyst of iris, ciliary body or anterior chamber, left eye', '', 'H21332', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6302, 'Parasitic cyst of iris, ciliary body or anterior chamber, bilateral', '', 'H21333', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6303, 'Parasitic cyst of iris, ciliary body or anterior chamber, unspecified eye', '', 'H21339', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6304, 'Primary cyst of pars plana, right eye', '', 'H21341', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6305, 'Primary cyst of pars plana, left eye', '', 'H21342', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6306, 'Primary cyst of pars plana, bilateral', '', 'H21343', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6307, 'Primary cyst of pars plana, unspecified eye', '', 'H21349', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6308, 'Exudative cyst of pars plana, right eye', '', 'H21351', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6309, 'Exudative cyst of pars plana, left eye', '', 'H21352', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6310, 'Exudative cyst of pars plana, bilateral', '', 'H21353', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6311, 'Exudative cyst of pars plana, unspecified eye', '', 'H21359', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6312, 'Pupillary membranes, unspecified eye', '', 'H2140', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6313, 'Pupillary membranes, right eye', '', 'H2141', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6314, 'Pupillary membranes, left eye', '', 'H2142', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6315, 'Pupillary membranes, bilateral', '', 'H2143', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6316, 'Unspecified adhesions of iris, right eye', '', 'H21501', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6317, 'Unspecified adhesions of iris, left eye', '', 'H21502', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6318, 'Unspecified adhesions of iris, bilateral', '', 'H21503', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6319, 'Unspecified adhesions of iris and ciliary body, unspecified eye', '', 'H21509', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6320, 'Anterior synechiae (iris), right eye', '', 'H21511', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6321, 'Anterior synechiae (iris), left eye', '', 'H21512', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6322, 'Anterior synechiae (iris), bilateral', '', 'H21513', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6323, 'Anterior synechiae (iris), unspecified eye', '', 'H21519', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6324, 'Goniosynechiae, right eye', '', 'H21521', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6325, 'Goniosynechiae, left eye', '', 'H21522', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6326, 'Goniosynechiae, bilateral', '', 'H21523', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6327, 'Goniosynechiae, unspecified eye', '', 'H21529', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6328, 'Iridodialysis, right eye', '', 'H21531', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6329, 'Iridodialysis, left eye', '', 'H21532', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6330, 'Iridodialysis, bilateral', '', 'H21533', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6331, 'Iridodialysis, unspecified eye', '', 'H21539', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6332, 'Posterior synechiae (iris), right eye', '', 'H21541', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6333, 'Posterior synechiae (iris), left eye', '', 'H21542', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6334, 'Posterior synechiae (iris), bilateral', '', 'H21543', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6335, 'Posterior synechiae (iris), unspecified eye', '', 'H21549', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6336, 'Recession of chamber angle, right eye', '', 'H21551', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6337, 'Recession of chamber angle, left eye', '', 'H21552', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6338, 'Recession of chamber angle, bilateral', '', 'H21553', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6339, 'Recession of chamber angle, unspecified eye', '', 'H21559', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6340, 'Pupillary abnormality, right eye', '', 'H21561', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6341, 'Pupillary abnormality, left eye', '', 'H21562', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6342, 'Pupillary abnormality, bilateral', '', 'H21563', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6343, 'Pupillary abnormality, unspecified eye', '', 'H21569', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6344, 'Floppy iris syndrome', '', 'H2181', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6345, 'Plateau iris syndrome (post-iridectomy) (postprocedural)', '', 'H2182', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6346, 'Other specified disorders of iris and ciliary body', '', 'H2189', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6347, 'Unspecified disorder of iris and ciliary body', '', 'H219', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6348, 'Disorders of iris and ciliary body in diseases classified elsewhere', '', 'H22', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6349, 'Cortical age-related cataract, right eye', '', 'H25011', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6350, 'Cortical age-related cataract, left eye', '', 'H25012', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6351, 'Cortical age-related cataract, bilateral', '', 'H25013', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6352, 'Cortical age-related cataract, unspecified eye', '', 'H25019', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6353, 'Anterior subcapsular polar age-related cataract, right eye', '', 'H25031', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6354, 'Anterior subcapsular polar age-related cataract, left eye', '', 'H25032', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6355, 'Anterior subcapsular polar age-related cataract, bilateral', '', 'H25033', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6356, 'Anterior subcapsular polar age-related cataract, unspecified eye', '', 'H25039', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6357, 'Posterior subcapsular polar age-related cataract, right eye', '', 'H25041', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6358, 'Posterior subcapsular polar age-related cataract, left eye', '', 'H25042', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6359, 'Posterior subcapsular polar age-related cataract, bilateral', '', 'H25043', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6360, 'Posterior subcapsular polar age-related cataract, unspecified eye', '', 'H25049', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6361, 'Other age-related incipient cataract, right eye', '', 'H25091', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6362, 'Other age-related incipient cataract, left eye', '', 'H25092', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6363, 'Other age-related incipient cataract, bilateral', '', 'H25093', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6364, 'Other age-related incipient cataract, unspecified eye', '', 'H25099', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6365, 'Age-related nuclear cataract, unspecified eye', '', 'H2510', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6366, 'Age-related nuclear cataract, right eye', '', 'H2511', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6367, 'Age-related nuclear cataract, left eye', '', 'H2512', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6368, 'Age-related nuclear cataract, bilateral', '', 'H2513', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6369, 'Age-related cataract, morgagnian type, unspecified eye', '', 'H2520', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6370, 'Age-related cataract, morgagnian type, right eye', '', 'H2521', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6371, 'Age-related cataract, morgagnian type, left eye', '', 'H2522', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6372, 'Age-related cataract, morgagnian type, bilateral', '', 'H2523', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6373, 'Combined forms of age-related cataract, right eye', '', 'H25811', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6374, 'Combined forms of age-related cataract, left eye', '', 'H25812', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6375, 'Combined forms of age-related cataract, bilateral', '', 'H25813', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6376, 'Combined forms of age-related cataract, unspecified eye', '', 'H25819', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6377, 'Other age-related cataract', '', 'H2589', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6378, 'Unspecified age-related cataract', '', 'H259', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6379, 'Unspecified infantile and juvenile cataract, right eye', '', 'H26001', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6380, 'Unspecified infantile and juvenile cataract, left eye', '', 'H26002', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6381, 'Unspecified infantile and juvenile cataract, bilateral', '', 'H26003', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6382, 'Unspecified infantile and juvenile cataract, unspecified eye', '', 'H26009', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6383, 'Infantile and juvenile cortical, lamellar, or zonular cataract, right eye', '', 'H26011', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6384, 'Infantile and juvenile cortical, lamellar, or zonular cataract, left eye', '', 'H26012', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6385, 'Infantile and juvenile cortical, lamellar, or zonular cataract, bilateral', '', 'H26013', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6386, 'Infantile and juvenile cortical, lamellar, or zonular cataract, unspecified eye', '', 'H26019', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6387, 'Infantile and juvenile nuclear cataract, right eye', '', 'H26031', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6388, 'Infantile and juvenile nuclear cataract, left eye', '', 'H26032', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6389, 'Infantile and juvenile nuclear cataract, bilateral', '', 'H26033', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6390, 'Infantile and juvenile nuclear cataract, unspecified eye', '', 'H26039', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6391, 'Anterior subcapsular polar infantile and juvenile cataract, right eye', '', 'H26041', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6392, 'Anterior subcapsular polar infantile and juvenile cataract, left eye', '', 'H26042', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6393, 'Anterior subcapsular polar infantile and juvenile cataract, bilateral', '', 'H26043', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6394, 'Anterior subcapsular polar infantile and juvenile cataract, unspecified eye', '', 'H26049', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6395, 'Posterior subcapsular polar infantile and juvenile cataract, right eye', '', 'H26051', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6396, 'Posterior subcapsular polar infantile and juvenile cataract, left eye', '', 'H26052', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6397, 'Posterior subcapsular polar infantile and juvenile cataract, bilateral', '', 'H26053', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6398, 'Posterior subcapsular polar infantile and juvenile cataract, unspecified eye', '', 'H26059', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6399, 'Combined forms of infantile and juvenile cataract, right eye', '', 'H26061', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6400, 'Combined forms of infantile and juvenile cataract, left eye', '', 'H26062', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6401, 'Combined forms of infantile and juvenile cataract, bilateral', '', 'H26063', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6402, 'Combined forms of infantile and juvenile cataract, unspecified eye', '', 'H26069', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6403, 'Other infantile and juvenile cataract', '', 'H2609', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6404, 'Unspecified traumatic cataract, right eye', '', 'H26101', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6405, 'Unspecified traumatic cataract, left eye', '', 'H26102', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6406, 'Unspecified traumatic cataract, bilateral', '', 'H26103', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6407, 'Unspecified traumatic cataract, unspecified eye', '', 'H26109', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6408, 'Localized traumatic opacities, right eye', '', 'H26111', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6409, 'Localized traumatic opacities, left eye', '', 'H26112', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6410, 'Localized traumatic opacities, bilateral', '', 'H26113', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6411, 'Localized traumatic opacities, unspecified eye', '', 'H26119', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6412, 'Partially resolved traumatic cataract, right eye', '', 'H26121', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6413, 'Partially resolved traumatic cataract, left eye', '', 'H26122', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6414, 'Partially resolved traumatic cataract, bilateral', '', 'H26123', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6415, 'Partially resolved traumatic cataract, unspecified eye', '', 'H26129', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6416, 'Total traumatic cataract, right eye', '', 'H26131', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6417, 'Total traumatic cataract, left eye', '', 'H26132', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6418, 'Total traumatic cataract, bilateral', '', 'H26133', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6419, 'Total traumatic cataract, unspecified eye', '', 'H26139', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6420, 'Unspecified complicated cataract', '', 'H2620', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6421, 'Cataract with neovascularization, right eye', '', 'H26211', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6422, 'Cataract with neovascularization, left eye', '', 'H26212', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6423, 'Cataract with neovascularization, bilateral', '', 'H26213', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6424, 'Cataract with neovascularization, unspecified eye', '', 'H26219', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6425, 'Cataract secondary to ocular disorders (degenerative) (inflammatory), right eye', '', 'H26221', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6426, 'Cataract secondary to ocular disorders (degenerative) (inflammatory), left eye', '', 'H26222', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6427, 'Cataract secondary to ocular disorders (degenerative) (inflammatory), bilateral', '', 'H26223', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6428, 'Cataract secondary to ocular disorders (degenerative) (inflammatory), unspecified eye', '', 'H26229', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6429, 'Glaucomatous flecks (subcapsular), right eye', '', 'H26231', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6430, 'Glaucomatous flecks (subcapsular), left eye', '', 'H26232', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6431, 'Glaucomatous flecks (subcapsular), bilateral', '', 'H26233', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6432, 'Glaucomatous flecks (subcapsular), unspecified eye', '', 'H26239', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6433, 'Drug-induced cataract, unspecified eye', '', 'H2630', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6434, 'Drug-induced cataract, right eye', '', 'H2631', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6435, 'Drug-induced cataract, left eye', '', 'H2632', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6436, 'Drug-induced cataract, bilateral', '', 'H2633', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6437, 'Unspecified secondary cataract', '', 'H2640', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6438, 'Soemmering\'s ring, right eye', '', 'H26411', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6439, 'Soemmering\'s ring, left eye', '', 'H26412', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6440, 'Soemmering\'s ring, bilateral', '', 'H26413', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6441, 'Soemmering\'s ring, unspecified eye', '', 'H26419', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6442, 'Other secondary cataract, right eye', '', 'H26491', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6443, 'Other secondary cataract, left eye', '', 'H26492', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6444, 'Other secondary cataract, bilateral', '', 'H26493', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6445, 'Other secondary cataract, unspecified eye', '', 'H26499', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6446, 'Other specified cataract', '', 'H268', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6447, 'Unspecified cataract', '', 'H269', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6448, 'Aphakia, unspecified eye', '', 'H2700', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6449, 'Aphakia, right eye', '', 'H2701', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6450, 'Aphakia, left eye', '', 'H2702', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6451, 'Aphakia, bilateral', '', 'H2703', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6452, 'Unspecified dislocation of lens', '', 'H2710', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6453, 'Subluxation of lens, right eye', '', 'H27111', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6454, 'Subluxation of lens, left eye', '', 'H27112', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6455, 'Subluxation of lens, bilateral', '', 'H27113', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6456, 'Subluxation of lens, unspecified eye', '', 'H27119', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6457, 'Anterior dislocation of lens, right eye', '', 'H27121', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6458, 'Anterior dislocation of lens, left eye', '', 'H27122', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6459, 'Anterior dislocation of lens, bilateral', '', 'H27123', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6460, 'Anterior dislocation of lens, unspecified eye', '', 'H27129', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6461, 'Posterior dislocation of lens, right eye', '', 'H27131', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6462, 'Posterior dislocation of lens, left eye', '', 'H27132', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6463, 'Posterior dislocation of lens, bilateral', '', 'H27133', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6464, 'Posterior dislocation of lens, unspecified eye', '', 'H27139', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6465, 'Other specified disorders of lens', '', 'H278', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6466, 'Unspecified disorder of lens', '', 'H279', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6467, 'Cataract in diseases classified elsewhere', '', 'H28', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6468, 'Unspecified focal chorioretinal inflammation, right eye', '', 'H30001', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6469, 'Unspecified focal chorioretinal inflammation, left eye', '', 'H30002', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6470, 'Unspecified focal chorioretinal inflammation, bilateral', '', 'H30003', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6471, 'Unspecified focal chorioretinal inflammation, unspecified eye', '', 'H30009', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6472, 'Focal chorioretinal inflammation, juxtapapillary, right eye', '', 'H30011', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6473, 'Focal chorioretinal inflammation, juxtapapillary, left eye', '', 'H30012', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6474, 'Focal chorioretinal inflammation, juxtapapillary, bilateral', '', 'H30013', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6475, 'Focal chorioretinal inflammation, juxtapapillary, unspecified eye', '', 'H30019', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6476, 'Focal chorioretinal inflammation of posterior pole, right eye', '', 'H30021', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6477, 'Focal chorioretinal inflammation of posterior pole, left eye', '', 'H30022', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6478, 'Focal chorioretinal inflammation of posterior pole, bilateral', '', 'H30023', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6479, 'Focal chorioretinal inflammation of posterior pole, unspecified eye', '', 'H30029', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6480, 'Focal chorioretinal inflammation, peripheral, right eye', '', 'H30031', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6481, 'Focal chorioretinal inflammation, peripheral, left eye', '', 'H30032', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6482, 'Focal chorioretinal inflammation, peripheral, bilateral', '', 'H30033', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6483, 'Focal chorioretinal inflammation, peripheral, unspecified eye', '', 'H30039', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6484, 'Focal chorioretinal inflammation, macular or paramacular, right eye', '', 'H30041', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6485, 'Focal chorioretinal inflammation, macular or paramacular, left eye', '', 'H30042', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6486, 'Focal chorioretinal inflammation, macular or paramacular, bilateral', '', 'H30043', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6487, 'Focal chorioretinal inflammation, macular or paramacular, unspecified eye', '', 'H30049', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6488, 'Unspecified disseminated chorioretinal inflammation, right eye', '', 'H30101', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6489, 'Unspecified disseminated chorioretinal inflammation, left eye', '', 'H30102', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6490, 'Unspecified disseminated chorioretinal inflammation, bilateral', '', 'H30103', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6491, 'Unspecified disseminated chorioretinal inflammation, unspecified eye', '', 'H30109', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6492, 'Disseminated chorioretinal inflammation of posterior pole, right eye', '', 'H30111', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6493, 'Disseminated chorioretinal inflammation of posterior pole, left eye', '', 'H30112', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6494, 'Disseminated chorioretinal inflammation of posterior pole, bilateral', '', 'H30113', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6495, 'Disseminated chorioretinal inflammation of posterior pole, unspecified eye', '', 'H30119', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6496, 'Disseminated chorioretinal inflammation, peripheral right eye', '', 'H30121', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6497, 'Disseminated chorioretinal inflammation, peripheral, left eye', '', 'H30122', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6498, 'Disseminated chorioretinal inflammation, peripheral, bilateral', '', 'H30123', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6499, 'Disseminated chorioretinal inflammation, peripheral, unspecified eye', '', 'H30129', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6500, 'Disseminated chorioretinal inflammation, generalized, right eye', '', 'H30131', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6501, 'Disseminated chorioretinal inflammation, generalized, left eye', '', 'H30132', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6502, 'Disseminated chorioretinal inflammation, generalized, bilateral', '', 'H30133', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6503, 'Disseminated chorioretinal inflammation, generalized, unspecified eye', '', 'H30139', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6504, 'Acute posterior multifocal placoid pigment epitheliopathy, right eye', '', 'H30141', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6505, 'Acute posterior multifocal placoid pigment epitheliopathy, left eye', '', 'H30142', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6506, 'Acute posterior multifocal placoid pigment epitheliopathy, bilateral', '', 'H30143', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6507, 'Acute posterior multifocal placoid pigment epitheliopathy, unspecified eye', '', 'H30149', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6508, 'Posterior cyclitis, unspecified eye', '', 'H3020', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6509, 'Posterior cyclitis, right eye', '', 'H3021', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6510, 'Posterior cyclitis, left eye', '', 'H3022', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6511, 'Posterior cyclitis, bilateral', '', 'H3023', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6512, 'Harada\'s disease, right eye', '', 'H30811', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6513, 'Harada\'s disease, left eye', '', 'H30812', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6514, 'Harada\'s disease, bilateral', '', 'H30813', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6515, 'Harada\'s disease, unspecified eye', '', 'H30819', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6516, 'Other chorioretinal inflammations, right eye', '', 'H30891', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6517, 'Other chorioretinal inflammations, left eye', '', 'H30892', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6518, 'Other chorioretinal inflammations, bilateral', '', 'H30893', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6519, 'Other chorioretinal inflammations, unspecified eye', '', 'H30899', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6520, 'Unspecified chorioretinal inflammation, unspecified eye', '', 'H3090', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6521, 'Unspecified chorioretinal inflammation, right eye', '', 'H3091', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6522, 'Unspecified chorioretinal inflammation, left eye', '', 'H3092', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6523, 'Unspecified chorioretinal inflammation, bilateral', '', 'H3093', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6524, 'Unspecified chorioretinal scars, right eye', '', 'H31001', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6525, 'Unspecified chorioretinal scars, left eye', '', 'H31002', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6526, 'Unspecified chorioretinal scars, bilateral', '', 'H31003', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6527, 'Unspecified chorioretinal scars, unspecified eye', '', 'H31009', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6528, 'Macula scars of posterior pole (postinflammatory) (post-traumatic), right eye', '', 'H31011', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6529, 'Macula scars of posterior pole (postinflammatory) (post-traumatic), left eye', '', 'H31012', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6530, 'Macula scars of posterior pole (postinflammatory) (post-traumatic), bilateral', '', 'H31013', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6531, 'Macula scars of posterior pole (postinflammatory) (post-traumatic), unspecified eye', '', 'H31019', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6532, 'Solar retinopathy, right eye', '', 'H31021', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6533, 'Solar retinopathy, left eye', '', 'H31022', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6534, 'Solar retinopathy, bilateral', '', 'H31023', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6535, 'Solar retinopathy, unspecified eye', '', 'H31029', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6536, 'Other chorioretinal scars, right eye', '', 'H31091', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6537, 'Other chorioretinal scars, left eye', '', 'H31092', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6538, 'Other chorioretinal scars, bilateral', '', 'H31093', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6539, 'Other chorioretinal scars, unspecified eye', '', 'H31099', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6540, 'Choroidal degeneration, unspecified, right eye', '', 'H31101', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6541, 'Choroidal degeneration, unspecified, left eye', '', 'H31102', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6542, 'Choroidal degeneration, unspecified, bilateral', '', 'H31103', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6543, 'Choroidal degeneration, unspecified, unspecified eye', '', 'H31109', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6544, 'Age-related choroidal atrophy, right eye', '', 'H31111', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6545, 'Age-related choroidal atrophy, left eye', '', 'H31112', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6546, 'Age-related choroidal atrophy, bilateral', '', 'H31113', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6547, 'Age-related choroidal atrophy, unspecified eye', '', 'H31119', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6548, 'Diffuse secondary atrophy of choroid, right eye', '', 'H31121', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6549, 'Diffuse secondary atrophy of choroid, left eye', '', 'H31122', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6550, 'Diffuse secondary atrophy of choroid, bilateral', '', 'H31123', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6551, 'Diffuse secondary atrophy of choroid, unspecified eye', '', 'H31129', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6552, 'Hereditary choroidal dystrophy, unspecified', '', 'H3120', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6553, 'Choroideremia', '', 'H3121', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6554, 'Choroidal dystrophy (central areolar) (generalized) (peripapillary)', '', 'H3122', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6555, 'Gyrate atrophy, choroid', '', 'H3123', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6556, 'Other hereditary choroidal dystrophy', '', 'H3129', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6557, 'Unspecified choroidal hemorrhage, right eye', '', 'H31301', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6558, 'Unspecified choroidal hemorrhage, left eye', '', 'H31302', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6559, 'Unspecified choroidal hemorrhage, bilateral', '', 'H31303', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6560, 'Unspecified choroidal hemorrhage, unspecified eye', '', 'H31309', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6561, 'Expulsive choroidal hemorrhage, right eye', '', 'H31311', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6562, 'Expulsive choroidal hemorrhage, left eye', '', 'H31312', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6563, 'Expulsive choroidal hemorrhage, bilateral', '', 'H31313', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6564, 'Expulsive choroidal hemorrhage, unspecified eye', '', 'H31319', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6565, 'Choroidal rupture, right eye', '', 'H31321', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6566, 'Choroidal rupture, left eye', '', 'H31322', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6567, 'Choroidal rupture, bilateral', '', 'H31323', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6568, 'Choroidal rupture, unspecified eye', '', 'H31329', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1);");

DB::statement("INSERT INTO `symptoms` (`id`, `symptoms_title`, `description`, `code`, `status`, `priority`, `created_at`, `updated_at`, `type`) VALUES
(6569, 'Unspecified choroidal detachment, right eye', '', 'H31401', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6570, 'Unspecified choroidal detachment, left eye', '', 'H31402', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6571, 'Unspecified choroidal detachment, bilateral', '', 'H31403', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6572, 'Unspecified choroidal detachment, unspecified eye', '', 'H31409', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6573, 'Hemorrhagic choroidal detachment, right eye', '', 'H31411', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6574, 'Hemorrhagic choroidal detachment, left eye', '', 'H31412', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6575, 'Hemorrhagic choroidal detachment, bilateral', '', 'H31413', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6576, 'Hemorrhagic choroidal detachment, unspecified eye', '', 'H31419', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6577, 'Serous choroidal detachment, right eye', '', 'H31421', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6578, 'Serous choroidal detachment, left eye', '', 'H31422', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6579, 'Serous choroidal detachment, bilateral', '', 'H31423', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6580, 'Serous choroidal detachment, unspecified eye', '', 'H31429', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6581, 'Other specified disorders of choroid', '', 'H318', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6582, 'Unspecified disorder of choroid', '', 'H319', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6583, 'Chorioretinal disorders in diseases classified elsewhere', '', 'H32', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6584, 'Unspecified retinal detachment with retinal break, right eye', '', 'H33001', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6585, 'Unspecified retinal detachment with retinal break, left eye', '', 'H33002', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6586, 'Unspecified retinal detachment with retinal break, bilateral', '', 'H33003', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6587, 'Unspecified retinal detachment with retinal break, unspecified eye', '', 'H33009', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6588, 'Retinal detachment with single break, right eye', '', 'H33011', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6589, 'Retinal detachment with single break, left eye', '', 'H33012', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6590, 'Retinal detachment with single break, bilateral', '', 'H33013', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6591, 'Retinal detachment with single break, unspecified eye', '', 'H33019', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6592, 'Retinal detachment with multiple breaks, right eye', '', 'H33021', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6593, 'Retinal detachment with multiple breaks, left eye', '', 'H33022', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6594, 'Retinal detachment with multiple breaks, bilateral', '', 'H33023', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6595, 'Retinal detachment with multiple breaks, unspecified eye', '', 'H33029', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6596, 'Retinal detachment with giant retinal tear, right eye', '', 'H33031', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6597, 'Retinal detachment with giant retinal tear, left eye', '', 'H33032', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6598, 'Retinal detachment with giant retinal tear, bilateral', '', 'H33033', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6599, 'Retinal detachment with giant retinal tear, unspecified eye', '', 'H33039', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6600, 'Retinal detachment with retinal dialysis, right eye', '', 'H33041', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6601, 'Retinal detachment with retinal dialysis, left eye', '', 'H33042', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6602, 'Retinal detachment with retinal dialysis, bilateral', '', 'H33043', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6603, 'Retinal detachment with retinal dialysis, unspecified eye', '', 'H33049', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6604, 'Total retinal detachment, right eye', '', 'H33051', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6605, 'Total retinal detachment, left eye', '', 'H33052', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6606, 'Total retinal detachment, bilateral', '', 'H33053', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6607, 'Total retinal detachment, unspecified eye', '', 'H33059', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6608, 'Unspecified retinoschisis, right eye', '', 'H33101', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6609, 'Unspecified retinoschisis, left eye', '', 'H33102', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6610, 'Unspecified retinoschisis, bilateral', '', 'H33103', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6611, 'Unspecified retinoschisis, unspecified eye', '', 'H33109', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6612, 'Cyst of ora serrata, right eye', '', 'H33111', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6613, 'Cyst of ora serrata, left eye', '', 'H33112', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6614, 'Cyst of ora serrata, bilateral', '', 'H33113', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6615, 'Cyst of ora serrata, unspecified eye', '', 'H33119', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6616, 'Parasitic cyst of retina, right eye', '', 'H33121', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6617, 'Parasitic cyst of retina, left eye', '', 'H33122', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6618, 'Parasitic cyst of retina, bilateral', '', 'H33123', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6619, 'Parasitic cyst of retina, unspecified eye', '', 'H33129', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6620, 'Other retinoschisis and retinal cysts, right eye', '', 'H33191', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6621, 'Other retinoschisis and retinal cysts, left eye', '', 'H33192', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6622, 'Other retinoschisis and retinal cysts, bilateral', '', 'H33193', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6623, 'Other retinoschisis and retinal cysts, unspecified eye', '', 'H33199', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6624, 'Serous retinal detachment, unspecified eye', '', 'H3320', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6625, 'Serous retinal detachment, right eye', '', 'H3321', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6626, 'Serous retinal detachment, left eye', '', 'H3322', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6627, 'Serous retinal detachment, bilateral', '', 'H3323', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6628, 'Unspecified retinal break, right eye', '', 'H33301', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6629, 'Unspecified retinal break, left eye', '', 'H33302', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6630, 'Unspecified retinal break, bilateral', '', 'H33303', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6631, 'Unspecified retinal break, unspecified eye', '', 'H33309', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6632, 'Horseshoe tear of retina without detachment, right eye', '', 'H33311', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6633, 'Horseshoe tear of retina without detachment, left eye', '', 'H33312', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6634, 'Horseshoe tear of retina without detachment, bilateral', '', 'H33313', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6635, 'Horseshoe tear of retina without detachment, unspecified eye', '', 'H33319', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6636, 'Round hole, right eye', '', 'H33321', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6637, 'Round hole, left eye', '', 'H33322', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6638, 'Round hole, bilateral', '', 'H33323', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6639, 'Round hole, unspecified eye', '', 'H33329', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6640, 'Multiple defects of retina without detachment, right eye', '', 'H33331', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6641, 'Multiple defects of retina without detachment, left eye', '', 'H33332', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6642, 'Multiple defects of retina without detachment, bilateral', '', 'H33333', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6643, 'Multiple defects of retina without detachment, unspecified eye', '', 'H33339', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6644, 'Traction detachment of retina, unspecified eye', '', 'H3340', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6645, 'Traction detachment of retina, right eye', '', 'H3341', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6646, 'Traction detachment of retina, left eye', '', 'H3342', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6647, 'Traction detachment of retina, bilateral', '', 'H3343', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6648, 'Other retinal detachments', '', 'H338', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6649, 'Transient retinal artery occlusion, unspecified eye', '', 'H3400', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6650, 'Transient retinal artery occlusion, right eye', '', 'H3401', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6651, 'Transient retinal artery occlusion, left eye', '', 'H3402', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6652, 'Transient retinal artery occlusion, bilateral', '', 'H3403', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6653, 'Central retinal artery occlusion, unspecified eye', '', 'H3410', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6654, 'Central retinal artery occlusion, right eye', '', 'H3411', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6655, 'Central retinal artery occlusion, left eye', '', 'H3412', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6656, 'Central retinal artery occlusion, bilateral', '', 'H3413', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6657, 'Partial retinal artery occlusion, right eye', '', 'H34211', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6658, 'Partial retinal artery occlusion, left eye', '', 'H34212', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6659, 'Partial retinal artery occlusion, bilateral', '', 'H34213', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6660, 'Partial retinal artery occlusion, unspecified eye', '', 'H34219', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6661, 'Retinal artery branch occlusion, right eye', '', 'H34231', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6662, 'Retinal artery branch occlusion, left eye', '', 'H34232', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6663, 'Retinal artery branch occlusion, bilateral', '', 'H34233', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6664, 'Retinal artery branch occlusion, unspecified eye', '', 'H34239', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6665, 'Central retinal vein occlusion, right eye, with macular edema', '', 'H348110', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6666, 'Central retinal vein occlusion, right eye, with retinal neovascularization', '', 'H348111', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6667, 'Central retinal vein occlusion, right eye, stable', '', 'H348112', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6668, 'Central retinal vein occlusion, left eye, with macular edema', '', 'H348120', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6669, 'Central retinal vein occlusion, left eye, with retinal neovascularization', '', 'H348121', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6670, 'Central retinal vein occlusion, left eye, stable', '', 'H348122', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6671, 'Central retinal vein occlusion, bilateral, with macular edema', '', 'H348130', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6672, 'Central retinal vein occlusion, bilateral, with retinal neovascularization', '', 'H348131', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6673, 'Central retinal vein occlusion, bilateral, stable', '', 'H348132', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6674, 'Central retinal vein occlusion, unspecified eye, with macular edema', '', 'H348190', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6675, 'Central retinal vein occlusion, unspecified eye, with retinal neovascularization', '', 'H348191', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6676, 'Central retinal vein occlusion, unspecified eye, stable', '', 'H348192', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6677, 'Venous engorgement, right eye', '', 'H34821', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6678, 'Venous engorgement, left eye', '', 'H34822', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6679, 'Venous engorgement, bilateral', '', 'H34823', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6680, 'Venous engorgement, unspecified eye', '', 'H34829', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6681, 'Tributary (branch) retinal vein occlusion, right eye, with macular edema', '', 'H348310', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6682, 'Tributary (branch) retinal vein occlusion, right eye, with retinal neovascularization', '', 'H348311', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6683, 'Tributary (branch) retinal vein occlusion, right eye, stable', '', 'H348312', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6684, 'Tributary (branch) retinal vein occlusion, left eye, with macular edema', '', 'H348320', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6685, 'Tributary (branch) retinal vein occlusion, left eye, with retinal neovascularization', '', 'H348321', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6686, 'Tributary (branch) retinal vein occlusion, left eye, stable', '', 'H348322', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6687, 'Tributary (branch) retinal vein occlusion, bilateral, with macular edema', '', 'H348330', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6688, 'Tributary (branch) retinal vein occlusion, bilateral, with retinal neovascularization', '', 'H348331', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6689, 'Tributary (branch) retinal vein occlusion, bilateral, stable', '', 'H348332', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6690, 'Tributary (branch) retinal vein occlusion, unspecified eye, with macular edema', '', 'H348390', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6691, 'Tributary (branch) retinal vein occlusion, unspecified eye, with retinal neovascularization', '', 'H348391', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6692, 'Tributary (branch) retinal vein occlusion, unspecified eye, stable', '', 'H348392', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6693, 'Unspecified retinal vascular occlusion', '', 'H349', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6694, 'Unspecified background retinopathy', '', 'H3500', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6695, 'Changes in retinal vascular appearance, right eye', '', 'H35011', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6696, 'Changes in retinal vascular appearance, left eye', '', 'H35012', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6697, 'Changes in retinal vascular appearance, bilateral', '', 'H35013', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6698, 'Changes in retinal vascular appearance, unspecified eye', '', 'H35019', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6699, 'Exudative retinopathy, right eye', '', 'H35021', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6700, 'Exudative retinopathy, left eye', '', 'H35022', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6701, 'Exudative retinopathy, bilateral', '', 'H35023', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6702, 'Exudative retinopathy, unspecified eye', '', 'H35029', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6703, 'Hypertensive retinopathy, right eye', '', 'H35031', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6704, 'Hypertensive retinopathy, left eye', '', 'H35032', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6705, 'Hypertensive retinopathy, bilateral', '', 'H35033', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6706, 'Hypertensive retinopathy, unspecified eye', '', 'H35039', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6707, 'Retinal micro-aneurysms, unspecified, right eye', '', 'H35041', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6708, 'Retinal micro-aneurysms, unspecified, left eye', '', 'H35042', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6709, 'Retinal micro-aneurysms, unspecified, bilateral', '', 'H35043', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6710, 'Retinal micro-aneurysms, unspecified, unspecified eye', '', 'H35049', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6711, 'Retinal neovascularization, unspecified, right eye', '', 'H35051', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6712, 'Retinal neovascularization, unspecified, left eye', '', 'H35052', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6713, 'Retinal neovascularization, unspecified, bilateral', '', 'H35053', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6714, 'Retinal neovascularization, unspecified, unspecified eye', '', 'H35059', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6715, 'Retinal vasculitis, right eye', '', 'H35061', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6716, 'Retinal vasculitis, left eye', '', 'H35062', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6717, 'Retinal vasculitis, bilateral', '', 'H35063', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6718, 'Retinal vasculitis, unspecified eye', '', 'H35069', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6719, 'Retinal telangiectasis, right eye', '', 'H35071', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6720, 'Retinal telangiectasis, left eye', '', 'H35072', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6721, 'Retinal telangiectasis, bilateral', '', 'H35073', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6722, 'Retinal telangiectasis, unspecified eye', '', 'H35079', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6723, 'Other intraretinal microvascular abnormalities', '', 'H3509', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6724, 'Retinopathy of prematurity, unspecified, right eye', '', 'H35101', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6725, 'Retinopathy of prematurity, unspecified, left eye', '', 'H35102', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6726, 'Retinopathy of prematurity, unspecified, bilateral', '', 'H35103', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6727, 'Retinopathy of prematurity, unspecified, unspecified eye', '', 'H35109', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6728, 'Retinopathy of prematurity, stage 0, right eye', '', 'H35111', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6729, 'Retinopathy of prematurity, stage 0, left eye', '', 'H35112', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6730, 'Retinopathy of prematurity, stage 0, bilateral', '', 'H35113', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6731, 'Retinopathy of prematurity, stage 0, unspecified eye', '', 'H35119', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6732, 'Retinopathy of prematurity, stage 1, right eye', '', 'H35121', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6733, 'Retinopathy of prematurity, stage 1, left eye', '', 'H35122', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6734, 'Retinopathy of prematurity, stage 1, bilateral', '', 'H35123', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6735, 'Retinopathy of prematurity, stage 1, unspecified eye', '', 'H35129', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6736, 'Retinopathy of prematurity, stage 2, right eye', '', 'H35131', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6737, 'Retinopathy of prematurity, stage 2, left eye', '', 'H35132', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6738, 'Retinopathy of prematurity, stage 2, bilateral', '', 'H35133', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6739, 'Retinopathy of prematurity, stage 2, unspecified eye', '', 'H35139', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6740, 'Retinopathy of prematurity, stage 3, right eye', '', 'H35141', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6741, 'Retinopathy of prematurity, stage 3, left eye', '', 'H35142', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6742, 'Retinopathy of prematurity, stage 3, bilateral', '', 'H35143', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6743, 'Retinopathy of prematurity, stage 3, unspecified eye', '', 'H35149', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6744, 'Retinopathy of prematurity, stage 4, right eye', '', 'H35151', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6745, 'Retinopathy of prematurity, stage 4, left eye', '', 'H35152', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6746, 'Retinopathy of prematurity, stage 4, bilateral', '', 'H35153', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6747, 'Retinopathy of prematurity, stage 4, unspecified eye', '', 'H35159', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6748, 'Retinopathy of prematurity, stage 5, right eye', '', 'H35161', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6749, 'Retinopathy of prematurity, stage 5, left eye', '', 'H35162', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6750, 'Retinopathy of prematurity, stage 5, bilateral', '', 'H35163', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6751, 'Retinopathy of prematurity, stage 5, unspecified eye', '', 'H35169', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6752, 'Retrolental fibroplasia, right eye', '', 'H35171', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6753, 'Retrolental fibroplasia, left eye', '', 'H35172', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6754, 'Retrolental fibroplasia, bilateral', '', 'H35173', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6755, 'Retrolental fibroplasia, unspecified eye', '', 'H35179', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6756, 'Other non-diabetic proliferative retinopathy, unspecified eye', '', 'H3520', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6757, 'Other non-diabetic proliferative retinopathy, right eye', '', 'H3521', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6758, 'Other non-diabetic proliferative retinopathy, left eye', '', 'H3522', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6759, 'Other non-diabetic proliferative retinopathy, bilateral', '', 'H3523', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6760, 'Unspecified macular degeneration', '', 'H3530', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6761, 'Nonexudative age-related macular degeneration, right eye, stage unspecified', '', 'H353110', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6762, 'Nonexudative age-related macular degeneration, right eye, early dry stage', '', 'H353111', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6763, 'Nonexudative age-related macular degeneration, right eye, intermediate dry stage', '', 'H353112', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6764, 'Nonexudative age-related macular degeneration, right eye, advanced atrophic without\nsubfoveal involvement', '', 'H353113', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6765, 'Nonexudative age-related macular degeneration, right eye, advanced atrophic with subfoveal\ninvolvement', '', 'H353114', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6766, 'Nonexudative age-related macular degeneration, left eye, stage unspecified', '', 'H353120', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6767, 'Nonexudative age-related macular degeneration, left eye, early dry stage', '', 'H353121', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6768, 'Nonexudative age-related macular degeneration, left eye, intermediate dry stage', '', 'H353122', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6769, 'Nonexudative age-related macular degeneration, left eye, advanced atrophic without\nsubfoveal involvement', '', 'H353123', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6770, 'Nonexudative age-related macular degeneration, left eye, advanced atrophic with subfoveal\ninvolvement', '', 'H353124', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6771, 'Nonexudative age-related macular degeneration, bilateral, stage unspecified', '', 'H353130', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6772, 'Nonexudative age-related macular degeneration, bilateral, early dry stage', '', 'H353131', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6773, 'Nonexudative age-related macular degeneration, bilateral, intermediate dry stage', '', 'H353132', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6774, 'Nonexudative age-related macular degeneration, bilateral, advanced atrophic without\nsubfoveal involvement', '', 'H353133', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6775, 'Nonexudative age-related macular degeneration, bilateral, advanced atrophic with subfoveal\ninvolvement', '', 'H353134', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6776, 'Nonexudative age-related macular degeneration, unspecified eye, stage unspecified', '', 'H353190', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6777, 'Nonexudative age-related macular degeneration, unspecified eye, early dry stage', '', 'H353191', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6778, 'Nonexudative age-related macular degeneration, unspecified eye, intermediate dry stage', '', 'H353192', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6779, 'Nonexudative age-related macular degeneration, unspecified eye, advanced atrophic without\nsubfoveal involvement', '', 'H353193', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6780, 'Nonexudative age-related macular degeneration, unspecified eye, advanced atrophic with\nsubfoveal involvement', '', 'H353194', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6781, 'Exudative age-related macular degeneration, right eye, stage unspecified', '', 'H353210', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6782, 'Exudative age-related macular degeneration, right eye, with active choroidal\nneovascularization', '', 'H353211', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6783, 'Exudative age-related macular degeneration, right eye, with inactive choroidal\nneovascularization', '', 'H353212', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6784, 'Exudative age-related macular degeneration, right eye, with inactive scar', '', 'H353213', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6785, 'Exudative age-related macular degeneration, left eye, stage unspecified', '', 'H353220', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6786, 'Exudative age-related macular degeneration, left eye, with active choroidal neovascularization', '', 'H353221', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6787, 'Exudative age-related macular degeneration, left eye, with inactive choroidal\nneovascularization', '', 'H353222', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6788, 'Exudative age-related macular degeneration, left eye, with inactive scar', '', 'H353223', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6789, 'Exudative age-related macular degeneration, bilateral, stage unspecified', '', 'H353230', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6790, 'Exudative age-related macular degeneration, bilateral, with active choroidal\nneovascularization', '', 'H353231', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6791, 'Exudative age-related macular degeneration, bilateral, with inactive choroidal\nneovascularization', '', 'H353232', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6792, 'Exudative age-related macular degeneration, bilateral, with inactive scar', '', 'H353233', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6793, 'Exudative age-related macular degeneration, unspecified eye, stage unspecified', '', 'H353290', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6794, 'Exudative age-related macular degeneration, unspecified eye, with active choroidal\nneovascularization', '', 'H353291', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6795, 'Exudative age-related macular degeneration, unspecified eye, with inactive choroidal\nneovascularization', '', 'H353292', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6796, 'Exudative age-related macular degeneration, unspecified eye, with inactive scar', '', 'H353293', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6797, 'Angioid streaks of macula', '', 'H3533', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6798, 'Macular cyst, hole, or pseudohole, right eye', '', 'H35341', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6799, 'Macular cyst, hole, or pseudohole, left eye', '', 'H35342', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6800, 'Macular cyst, hole, or pseudohole, bilateral', '', 'H35343', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6801, 'Macular cyst, hole, or pseudohole, unspecified eye', '', 'H35349', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6802, 'Cystoid macular degeneration, right eye', '', 'H35351', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6803, 'Cystoid macular degeneration, left eye', '', 'H35352', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6804, 'Cystoid macular degeneration, bilateral', '', 'H35353', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6805, 'Cystoid macular degeneration, unspecified eye', '', 'H35359', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6806, 'Drusen (degenerative) of macula, right eye', '', 'H35361', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6807, 'Drusen (degenerative) of macula, left eye', '', 'H35362', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6808, 'Drusen (degenerative) of macula, bilateral', '', 'H35363', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6809, 'Drusen (degenerative) of macula, unspecified eye', '', 'H35369', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6810, 'Puckering of macula, right eye', '', 'H35371', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6811, 'Puckering of macula, left eye', '', 'H35372', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6812, 'Puckering of macula, bilateral', '', 'H35373', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6813, 'Puckering of macula, unspecified eye', '', 'H35379', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6814, 'Toxic maculopathy, right eye', '', 'H35381', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6815, 'Toxic maculopathy, left eye', '', 'H35382', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6816, 'Toxic maculopathy, bilateral', '', 'H35383', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6817, 'Toxic maculopathy, unspecified eye', '', 'H35389', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6818, 'Unspecified peripheral retinal degeneration', '', 'H3540', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6819, 'Lattice degeneration of retina, right eye', '', 'H35411', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6820, 'Lattice degeneration of retina, left eye', '', 'H35412', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6821, 'Lattice degeneration of retina, bilateral', '', 'H35413', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6822, 'Lattice degeneration of retina, unspecified eye', '', 'H35419', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6823, 'Microcystoid degeneration of retina, right eye', '', 'H35421', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6824, 'Microcystoid degeneration of retina, left eye', '', 'H35422', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6825, 'Microcystoid degeneration of retina, bilateral', '', 'H35423', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6826, 'Microcystoid degeneration of retina, unspecified eye', '', 'H35429', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6827, 'Paving stone degeneration of retina, right eye', '', 'H35431', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6828, 'Paving stone degeneration of retina, left eye', '', 'H35432', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6829, 'Paving stone degeneration of retina, bilateral', '', 'H35433', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6830, 'Paving stone degeneration of retina, unspecified eye', '', 'H35439', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6831, 'Age-related reticular degeneration of retina, right eye', '', 'H35441', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6832, 'Age-related reticular degeneration of retina, left eye', '', 'H35442', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6833, 'Age-related reticular degeneration of retina, bilateral', '', 'H35443', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6834, 'Age-related reticular degeneration of retina, unspecified eye', '', 'H35449', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6835, 'Secondary pigmentary degeneration, right eye', '', 'H35451', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6836, 'Secondary pigmentary degeneration, left eye', '', 'H35452', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6837, 'Secondary pigmentary degeneration, bilateral', '', 'H35453', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6838, 'Secondary pigmentary degeneration, unspecified eye', '', 'H35459', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6839, 'Secondary vitreoretinal degeneration, right eye', '', 'H35461', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6840, 'Secondary vitreoretinal degeneration, left eye', '', 'H35462', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6841, 'Secondary vitreoretinal degeneration, bilateral', '', 'H35463', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6842, 'Secondary vitreoretinal degeneration, unspecified eye', '', 'H35469', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6843, 'Unspecified hereditary retinal dystrophy', '', 'H3550', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6844, 'Vitreoretinal dystrophy', '', 'H3551', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6845, 'Pigmentary retinal dystrophy', '', 'H3552', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6846, 'Other dystrophies primarily involving the sensory retina', '', 'H3553', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6847, 'Dystrophies primarily involving the retinal pigment epithelium', '', 'H3554', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6848, 'Retinal hemorrhage, unspecified eye', '', 'H3560', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6849, 'Retinal hemorrhage, right eye', '', 'H3561', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6850, 'Retinal hemorrhage, left eye', '', 'H3562', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6851, 'Retinal hemorrhage, bilateral', '', 'H3563', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6852, 'Unspecified separation of retinal layers', '', 'H3570', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6853, 'Central serous chorioretinopathy, right eye', '', 'H35711', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6854, 'Central serous chorioretinopathy, left eye', '', 'H35712', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6855, 'Central serous chorioretinopathy, bilateral', '', 'H35713', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6856, 'Central serous chorioretinopathy, unspecified eye', '', 'H35719', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6857, 'Serous detachment of retinal pigment epithelium, right eye', '', 'H35721', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6858, 'Serous detachment of retinal pigment epithelium, left eye', '', 'H35722', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6859, 'Serous detachment of retinal pigment epithelium, bilateral', '', 'H35723', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6860, 'Serous detachment of retinal pigment epithelium, unspecified eye', '', 'H35729', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6861, 'Hemorrhagic detachment of retinal pigment epithelium, right eye', '', 'H35731', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6862, 'Hemorrhagic detachment of retinal pigment epithelium, left eye', '', 'H35732', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6863, 'Hemorrhagic detachment of retinal pigment epithelium, bilateral', '', 'H35733', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6864, 'Hemorrhagic detachment of retinal pigment epithelium, unspecified eye', '', 'H35739', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6865, 'Retinal edema', '', 'H3581', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6866, 'Retinal ischemia', '', 'H3582', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6867, 'Other specified retinal disorders', '', 'H3589', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6868, 'Unspecified retinal disorder', '', 'H359', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6869, 'Retinal disorders in diseases classified elsewhere', '', 'H36', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6870, 'Preglaucoma, unspecified, right eye', '', 'H40001', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6871, 'Preglaucoma, unspecified, left eye', '', 'H40002', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6872, 'Preglaucoma, unspecified, bilateral', '', 'H40003', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6873, 'Preglaucoma, unspecified, unspecified eye', '', 'H40009', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6874, 'Open angle with borderline findings, low risk, right eye', '', 'H40011', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6875, 'Open angle with borderline findings, low risk, left eye', '', 'H40012', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6876, 'Open angle with borderline findings, low risk, bilateral', '', 'H40013', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6877, 'Open angle with borderline findings, low risk, unspecified eye', '', 'H40019', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6878, 'Open angle with borderline findings, high risk, right eye', '', 'H40021', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6879, 'Open angle with borderline findings, high risk, left eye', '', 'H40022', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6880, 'Open angle with borderline findings, high risk, bilateral', '', 'H40023', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6881, 'Open angle with borderline findings, high risk, unspecified eye', '', 'H40029', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6882, 'Anatomical narrow angle, right eye', '', 'H40031', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6883, 'Anatomical narrow angle, left eye', '', 'H40032', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6884, 'Anatomical narrow angle, bilateral', '', 'H40033', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6885, 'Anatomical narrow angle, unspecified eye', '', 'H40039', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6886, 'Steroid responder, right eye', '', 'H40041', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6887, 'Steroid responder, left eye', '', 'H40042', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6888, 'Steroid responder, bilateral', '', 'H40043', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6889, 'Steroid responder, unspecified eye', '', 'H40049', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6890, 'Ocular hypertension, right eye', '', 'H40051', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6891, 'Ocular hypertension, left eye', '', 'H40052', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6892, 'Ocular hypertension, bilateral', '', 'H40053', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6893, 'Ocular hypertension, unspecified eye', '', 'H40059', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6894, 'Primary angle closure without glaucoma damage, right eye', '', 'H40061', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6895, 'Primary angle closure without glaucoma damage, left eye', '', 'H40062', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6896, 'Primary angle closure without glaucoma damage, bilateral', '', 'H40063', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6897, 'Primary angle closure without glaucoma damage, unspecified eye', '', 'H40069', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6898, 'Unspecified open-angle glaucoma, stage unspecified', '', 'H4010X0', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6899, 'Unspecified open-angle glaucoma, mild stage', '', 'H4010X1', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6900, 'Unspecified open-angle glaucoma, moderate stage', '', 'H4010X2', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6901, 'Unspecified open-angle glaucoma, severe stage', '', 'H4010X3', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6902, 'Unspecified open-angle glaucoma, indeterminate stage', '', 'H4010X4', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6903, 'Primary open-angle glaucoma, right eye, stage unspecified', '', 'H401110', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6904, 'Primary open-angle glaucoma, right eye, mild stage', '', 'H401111', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6905, 'Primary open-angle glaucoma, right eye, moderate stage', '', 'H401112', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6906, 'Primary open-angle glaucoma, right eye, severe stage', '', 'H401113', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6907, 'Primary open-angle glaucoma, right eye, indeterminate stage', '', 'H401114', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6908, 'Primary open-angle glaucoma, left eye, stage unspecified', '', 'H401120', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6909, 'Primary open-angle glaucoma, left eye, mild stage', '', 'H401121', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6910, 'Primary open-angle glaucoma, left eye, moderate stage', '', 'H401122', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6911, 'Primary open-angle glaucoma, left eye, severe stage', '', 'H401123', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6912, 'Primary open-angle glaucoma, left eye, indeterminate stage', '', 'H401124', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6913, 'Primary open-angle glaucoma, bilateral, stage unspecified', '', 'H401130', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6914, 'Primary open-angle glaucoma, bilateral, mild stage', '', 'H401131', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6915, 'Primary open-angle glaucoma, bilateral, moderate stage', '', 'H401132', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6916, 'Primary open-angle glaucoma, bilateral, severe stage', '', 'H401133', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6917, 'Primary open-angle glaucoma, bilateral, indeterminate stage', '', 'H401134', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6918, 'Primary open-angle glaucoma, unspecified eye, stage unspecified', '', 'H401190', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6919, 'Primary open-angle glaucoma, unspecified eye, mild stage', '', 'H401191', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6920, 'Primary open-angle glaucoma, unspecified eye, moderate stage', '', 'H401192', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6921, 'Primary open-angle glaucoma, unspecified eye, severe stage', '', 'H401193', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6922, 'Primary open-angle glaucoma, unspecified eye, indeterminate stage', '', 'H401194', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6923, 'Low-tension glaucoma, right eye, stage unspecified', '', 'H401210', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6924, 'Low-tension glaucoma, right eye, mild stage', '', 'H401211', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6925, 'Low-tension glaucoma, right eye, moderate stage', '', 'H401212', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6926, 'Low-tension glaucoma, right eye, severe stage', '', 'H401213', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6927, 'Low-tension glaucoma, right eye, indeterminate stage', '', 'H401214', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6928, 'Low-tension glaucoma, left eye, stage unspecified', '', 'H401220', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6929, 'Low-tension glaucoma, left eye, mild stage', '', 'H401221', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6930, 'Low-tension glaucoma, left eye, moderate stage', '', 'H401222', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6931, 'Low-tension glaucoma, left eye, severe stage', '', 'H401223', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6932, 'Low-tension glaucoma, left eye, indeterminate stage', '', 'H401224', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6933, 'Low-tension glaucoma, bilateral, stage unspecified', '', 'H401230', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6934, 'Low-tension glaucoma, bilateral, mild stage', '', 'H401231', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6935, 'Low-tension glaucoma, bilateral, moderate stage', '', 'H401232', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6936, 'Low-tension glaucoma, bilateral, severe stage', '', 'H401233', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6937, 'Low-tension glaucoma, bilateral, indeterminate stage', '', 'H401234', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6938, 'Low-tension glaucoma, unspecified eye, stage unspecified', '', 'H401290', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6939, 'Low-tension glaucoma, unspecified eye, mild stage', '', 'H401291', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6940, 'Low-tension glaucoma, unspecified eye, moderate stage', '', 'H401292', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6941, 'Low-tension glaucoma, unspecified eye, severe stage', '', 'H401293', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6942, 'Low-tension glaucoma, unspecified eye, indeterminate stage', '', 'H401294', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6943, 'Pigmentary glaucoma, right eye, stage unspecified', '', 'H401310', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6944, 'Pigmentary glaucoma, right eye, mild stage', '', 'H401311', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1);");


DB::statement("INSERT INTO `symptoms` (`id`, `symptoms_title`, `description`, `code`, `status`, `priority`, `created_at`, `updated_at`, `type`) VALUES
(6945, 'Pigmentary glaucoma, right eye, moderate stage', '', 'H401312', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6946, 'Pigmentary glaucoma, right eye, severe stage', '', 'H401313', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6947, 'Pigmentary glaucoma, right eye, indeterminate stage', '', 'H401314', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6948, 'Pigmentary glaucoma, left eye, stage unspecified', '', 'H401320', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6949, 'Pigmentary glaucoma, left eye, mild stage', '', 'H401321', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6950, 'Pigmentary glaucoma, left eye, moderate stage', '', 'H401322', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6951, 'Pigmentary glaucoma, left eye, severe stage', '', 'H401323', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6952, 'Pigmentary glaucoma, left eye, indeterminate stage', '', 'H401324', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6953, 'Pigmentary glaucoma, bilateral, stage unspecified', '', 'H401330', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6954, 'Pigmentary glaucoma, bilateral, mild stage', '', 'H401331', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6955, 'Pigmentary glaucoma, bilateral, moderate stage', '', 'H401332', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6956, 'Pigmentary glaucoma, bilateral, severe stage', '', 'H401333', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6957, 'Pigmentary glaucoma, bilateral, indeterminate stage', '', 'H401334', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6958, 'Pigmentary glaucoma, unspecified eye, stage unspecified', '', 'H401390', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6959, 'Pigmentary glaucoma, unspecified eye, mild stage', '', 'H401391', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6960, 'Pigmentary glaucoma, unspecified eye, moderate stage', '', 'H401392', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6961, 'Pigmentary glaucoma, unspecified eye, severe stage', '', 'H401393', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6962, 'Pigmentary glaucoma, unspecified eye, indeterminate stage', '', 'H401394', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6963, 'Capsular glaucoma with pseudoexfoliation of lens, right eye, stage unspecified', '', 'H401410', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6964, 'Capsular glaucoma with pseudoexfoliation of lens, right eye, mild stage', '', 'H401411', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6965, 'Capsular glaucoma with pseudoexfoliation of lens, right eye, moderate stage', '', 'H401412', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6966, 'Capsular glaucoma with pseudoexfoliation of lens, right eye, severe stage', '', 'H401413', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6967, 'Capsular glaucoma with pseudoexfoliation of lens, right eye, indeterminate stage', '', 'H401414', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6968, 'Capsular glaucoma with pseudoexfoliation of lens, left eye, stage unspecified', '', 'H401420', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6969, 'Capsular glaucoma with pseudoexfoliation of lens, left eye, mild stage', '', 'H401421', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6970, 'Capsular glaucoma with pseudoexfoliation of lens, left eye, moderate stage', '', 'H401422', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6971, 'Capsular glaucoma with pseudoexfoliation of lens, left eye, severe stage', '', 'H401423', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6972, 'Capsular glaucoma with pseudoexfoliation of lens, left eye, indeterminate stage', '', 'H401424', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6973, 'Capsular glaucoma with pseudoexfoliation of lens, bilateral, stage unspecified', '', 'H401430', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6974, 'Capsular glaucoma with pseudoexfoliation of lens, bilateral, mild stage', '', 'H401431', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6975, 'Capsular glaucoma with pseudoexfoliation of lens, bilateral, moderate stage', '', 'H401432', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6976, 'Capsular glaucoma with pseudoexfoliation of lens, bilateral, severe stage', '', 'H401433', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6977, 'Capsular glaucoma with pseudoexfoliation of lens, bilateral, indeterminate stage', '', 'H401434', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6978, 'Capsular glaucoma with pseudoexfoliation of lens, unspecified eye, stage unspecified', '', 'H401490', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6979, 'Capsular glaucoma with pseudoexfoliation of lens, unspecified eye, mild stage', '', 'H401491', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6980, 'Capsular glaucoma with pseudoexfoliation of lens, unspecified eye, moderate stage', '', 'H401492', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6981, 'Capsular glaucoma with pseudoexfoliation of lens, unspecified eye, severe stage', '', 'H401493', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6982, 'Capsular glaucoma with pseudoexfoliation of lens, unspecified eye, indeterminate stage', '', 'H401494', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6983, 'Residual stage of open-angle glaucoma, right eye', '', 'H40151', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6984, 'Residual stage of open-angle glaucoma, left eye', '', 'H40152', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6985, 'Residual stage of open-angle glaucoma, bilateral', '', 'H40153', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6986, 'Residual stage of open-angle glaucoma, unspecified eye', '', 'H40159', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6987, 'Unspecified primary angle-closure glaucoma, stage unspecified', '', 'H4020X0', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6988, 'Unspecified primary angle-closure glaucoma, mild stage', '', 'H4020X1', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6989, 'Unspecified primary angle-closure glaucoma, moderate stage', '', 'H4020X2', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6990, 'Unspecified primary angle-closure glaucoma, severe stage', '', 'H4020X3', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6991, 'Unspecified primary angle-closure glaucoma, indeterminate stage', '', 'H4020X4', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6992, 'Acute angle-closure glaucoma, right eye', '', 'H40211', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6993, 'Acute angle-closure glaucoma, left eye', '', 'H40212', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6994, 'Acute angle-closure glaucoma, bilateral', '', 'H40213', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6995, 'Acute angle-closure glaucoma, unspecified eye', '', 'H40219', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6996, 'Chronic angle-closure glaucoma, right eye, stage unspecified', '', 'H402210', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6997, 'Chronic angle-closure glaucoma, right eye, mild stage', '', 'H402211', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6998, 'Chronic angle-closure glaucoma, right eye, moderate stage', '', 'H402212', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(6999, 'Chronic angle-closure glaucoma, right eye, severe stage', '', 'H402213', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7000, 'Chronic angle-closure glaucoma, right eye, indeterminate stage', '', 'H402214', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7001, 'Chronic angle-closure glaucoma, left eye, stage unspecified', '', 'H402220', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7002, 'Chronic angle-closure glaucoma, left eye, mild stage', '', 'H402221', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7003, 'Chronic angle-closure glaucoma, left eye, moderate stage', '', 'H402222', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7004, 'Chronic angle-closure glaucoma, left eye, severe stage', '', 'H402223', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7005, 'Chronic angle-closure glaucoma, left eye, indeterminate stage', '', 'H402224', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7006, 'Chronic angle-closure glaucoma, bilateral, stage unspecified', '', 'H402230', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7007, 'Chronic angle-closure glaucoma, bilateral, mild stage', '', 'H402231', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7008, 'Chronic angle-closure glaucoma, bilateral, moderate stage', '', 'H402232', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7009, 'Chronic angle-closure glaucoma, bilateral, severe stage', '', 'H402233', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7010, 'Chronic angle-closure glaucoma, bilateral, indeterminate stage', '', 'H402234', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7011, 'Chronic angle-closure glaucoma, unspecified eye, stage unspecified', '', 'H402290', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7012, 'Chronic angle-closure glaucoma, unspecified eye, mild stage', '', 'H402291', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7013, 'Chronic angle-closure glaucoma, unspecified eye, moderate stage', '', 'H402292', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7014, 'Chronic angle-closure glaucoma, unspecified eye, severe stage', '', 'H402293', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7015, 'Chronic angle-closure glaucoma, unspecified eye, indeterminate stage', '', 'H402294', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7016, 'Intermittent angle-closure glaucoma, right eye', '', 'H40231', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7017, 'Intermittent angle-closure glaucoma, left eye', '', 'H40232', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7018, 'Intermittent angle-closure glaucoma, bilateral', '', 'H40233', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7019, 'Intermittent angle-closure glaucoma, unspecified eye', '', 'H40239', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7020, 'Residual stage of angle-closure glaucoma, right eye', '', 'H40241', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7021, 'Residual stage of angle-closure glaucoma, left eye', '', 'H40242', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7022, 'Residual stage of angle-closure glaucoma, bilateral', '', 'H40243', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7023, 'Residual stage of angle-closure glaucoma, unspecified eye', '', 'H40249', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7024, 'Glaucoma secondary to eye trauma, unspecified eye, stage unspecified', '', 'H4030X0', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7025, 'Glaucoma secondary to eye trauma, unspecified eye, mild stage', '', 'H4030X1', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7026, 'Glaucoma secondary to eye trauma, unspecified eye, moderate stage', '', 'H4030X2', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7027, 'Glaucoma secondary to eye trauma, unspecified eye, severe stage', '', 'H4030X3', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7028, 'Glaucoma secondary to eye trauma, unspecified eye, indeterminate stage', '', 'H4030X4', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7029, 'Glaucoma secondary to eye trauma, right eye, stage unspecified', '', 'H4031X0', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7030, 'Glaucoma secondary to eye trauma, right eye, mild stage', '', 'H4031X1', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7031, 'Glaucoma secondary to eye trauma, right eye, moderate stage', '', 'H4031X2', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7032, 'Glaucoma secondary to eye trauma, right eye, severe stage', '', 'H4031X3', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7033, 'Glaucoma secondary to eye trauma, right eye, indeterminate stage', '', 'H4031X4', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7034, 'Glaucoma secondary to eye trauma, left eye, stage unspecified', '', 'H4032X0', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7035, 'Glaucoma secondary to eye trauma, left eye, mild stage', '', 'H4032X1', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7036, 'Glaucoma secondary to eye trauma, left eye, moderate stage', '', 'H4032X2', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7037, 'Glaucoma secondary to eye trauma, left eye, severe stage', '', 'H4032X3', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7038, 'Glaucoma secondary to eye trauma, left eye, indeterminate stage', '', 'H4032X4', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7039, 'Glaucoma secondary to eye trauma, bilateral, stage unspecified', '', 'H4033X0', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7040, 'Glaucoma secondary to eye trauma, bilateral, mild stage', '', 'H4033X1', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7041, 'Glaucoma secondary to eye trauma, bilateral, moderate stage', '', 'H4033X2', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7042, 'Glaucoma secondary to eye trauma, bilateral, severe stage', '', 'H4033X3', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7043, 'Glaucoma secondary to eye trauma, bilateral, indeterminate stage', '', 'H4033X4', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7044, 'Glaucoma secondary to eye inflammation, unspecified eye, stage unspecified', '', 'H4040X0', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7045, 'Glaucoma secondary to eye inflammation, unspecified eye, mild stage', '', 'H4040X1', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7046, 'Glaucoma secondary to eye inflammation, unspecified eye, moderate stage', '', 'H4040X2', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7047, 'Glaucoma secondary to eye inflammation, unspecified eye, severe stage', '', 'H4040X3', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7048, 'Glaucoma secondary to eye inflammation, unspecified eye, indeterminate stage', '', 'H4040X4', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7049, 'Glaucoma secondary to eye inflammation, right eye, stage unspecified', '', 'H4041X0', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7050, 'Glaucoma secondary to eye inflammation, right eye, mild stage', '', 'H4041X1', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7051, 'Glaucoma secondary to eye inflammation, right eye, moderate stage', '', 'H4041X2', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7052, 'Glaucoma secondary to eye inflammation, right eye, severe stage', '', 'H4041X3', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7053, 'Glaucoma secondary to eye inflammation, right eye, indeterminate stage', '', 'H4041X4', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7054, 'Glaucoma secondary to eye inflammation, left eye, stage unspecified', '', 'H4042X0', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7055, 'Glaucoma secondary to eye inflammation, left eye, mild stage', '', 'H4042X1', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7056, 'Glaucoma secondary to eye inflammation, left eye, moderate stage', '', 'H4042X2', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7057, 'Glaucoma secondary to eye inflammation, left eye, severe stage', '', 'H4042X3', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7058, 'Glaucoma secondary to eye inflammation, left eye, indeterminate stage', '', 'H4042X4', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7059, 'Glaucoma secondary to eye inflammation, bilateral, stage unspecified', '', 'H4043X0', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7060, 'Glaucoma secondary to eye inflammation, bilateral, mild stage', '', 'H4043X1', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7061, 'Glaucoma secondary to eye inflammation, bilateral, moderate stage', '', 'H4043X2', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7062, 'Glaucoma secondary to eye inflammation, bilateral, severe stage', '', 'H4043X3', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7063, 'Glaucoma secondary to eye inflammation, bilateral, indeterminate stage', '', 'H4043X4', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7064, 'Glaucoma secondary to other eye disorders, unspecified eye, stage unspecified', '', 'H4050X0', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7065, 'Glaucoma secondary to other eye disorders, unspecified eye, mild stage', '', 'H4050X1', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7066, 'Glaucoma secondary to other eye disorders, unspecified eye, moderate stage', '', 'H4050X2', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7067, 'Glaucoma secondary to other eye disorders, unspecified eye, severe stage', '', 'H4050X3', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7068, 'Glaucoma secondary to other eye disorders, unspecified eye, indeterminate stage', '', 'H4050X4', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7069, 'Glaucoma secondary to other eye disorders, right eye, stage unspecified', '', 'H4051X0', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7070, 'Glaucoma secondary to other eye disorders, right eye, mild stage', '', 'H4051X1', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7071, 'Glaucoma secondary to other eye disorders, right eye, moderate stage', '', 'H4051X2', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7072, 'Glaucoma secondary to other eye disorders, right eye, severe stage', '', 'H4051X3', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7073, 'Glaucoma secondary to other eye disorders, right eye, indeterminate stage', '', 'H4051X4', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7074, 'Glaucoma secondary to other eye disorders, left eye, stage unspecified', '', 'H4052X0', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7075, 'Glaucoma secondary to other eye disorders, left eye, mild stage', '', 'H4052X1', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7076, 'Glaucoma secondary to other eye disorders, left eye, moderate stage', '', 'H4052X2', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7077, 'Glaucoma secondary to other eye disorders, left eye, severe stage', '', 'H4052X3', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7078, 'Glaucoma secondary to other eye disorders, left eye, indeterminate stage', '', 'H4052X4', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7079, 'Glaucoma secondary to other eye disorders, bilateral, stage unspecified', '', 'H4053X0', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7080, 'Glaucoma secondary to other eye disorders, bilateral, mild stage', '', 'H4053X1', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7081, 'Glaucoma secondary to other eye disorders, bilateral, moderate stage', '', 'H4053X2', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7082, 'Glaucoma secondary to other eye disorders, bilateral, severe stage', '', 'H4053X3', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7083, 'Glaucoma secondary to other eye disorders, bilateral, indeterminate stage', '', 'H4053X4', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7084, 'Glaucoma secondary to drugs, unspecified eye, stage unspecified', '', 'H4060X0', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7085, 'Glaucoma secondary to drugs, unspecified eye, mild stage', '', 'H4060X1', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7086, 'Glaucoma secondary to drugs, unspecified eye, moderate stage', '', 'H4060X2', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7087, 'Glaucoma secondary to drugs, unspecified eye, severe stage', '', 'H4060X3', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7088, 'Glaucoma secondary to drugs, unspecified eye, indeterminate stage', '', 'H4060X4', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7089, 'Glaucoma secondary to drugs, right eye, stage unspecified', '', 'H4061X0', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7090, 'Glaucoma secondary to drugs, right eye, mild stage', '', 'H4061X1', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7091, 'Glaucoma secondary to drugs, right eye, moderate stage', '', 'H4061X2', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7092, 'Glaucoma secondary to drugs, right eye, severe stage', '', 'H4061X3', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7093, 'Glaucoma secondary to drugs, right eye, indeterminate stage', '', 'H4061X4', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7094, 'Glaucoma secondary to drugs, left eye, stage unspecified', '', 'H4062X0', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7095, 'Glaucoma secondary to drugs, left eye, mild stage', '', 'H4062X1', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7096, 'Glaucoma secondary to drugs, left eye, moderate stage', '', 'H4062X2', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7097, 'Glaucoma secondary to drugs, left eye, severe stage', '', 'H4062X3', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7098, 'Glaucoma secondary to drugs, left eye, indeterminate stage', '', 'H4062X4', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7099, 'Glaucoma secondary to drugs, bilateral, stage unspecified', '', 'H4063X0', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7100, 'Glaucoma secondary to drugs, bilateral, mild stage', '', 'H4063X1', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7101, 'Glaucoma secondary to drugs, bilateral, moderate stage', '', 'H4063X2', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7102, 'Glaucoma secondary to drugs, bilateral, severe stage', '', 'H4063X3', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7103, 'Glaucoma secondary to drugs, bilateral, indeterminate stage', '', 'H4063X4', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7104, 'Glaucoma with increased episcleral venous pressure, right eye', '', 'H40811', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7105, 'Glaucoma with increased episcleral venous pressure, left eye', '', 'H40812', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7106, 'Glaucoma with increased episcleral venous pressure, bilateral', '', 'H40813', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7107, 'Glaucoma with increased episcleral venous pressure, unspecified eye', '', 'H40819', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7108, 'Hypersecretion glaucoma, right eye', '', 'H40821', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7109, 'Hypersecretion glaucoma, left eye', '', 'H40822', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7110, 'Hypersecretion glaucoma, bilateral', '', 'H40823', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7111, 'Hypersecretion glaucoma, unspecified eye', '', 'H40829', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7112, 'Aqueous misdirection, right eye', '', 'H40831', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7113, 'Aqueous misdirection, left eye', '', 'H40832', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7114, 'Aqueous misdirection, bilateral', '', 'H40833', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7115, 'Aqueous misdirection, unspecified eye', '', 'H40839', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7116, 'Other specified glaucoma', '', 'H4089', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7117, 'Unspecified glaucoma', '', 'H409', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7118, 'Glaucoma in diseases classified elsewhere', '', 'H42', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7119, 'Vitreous prolapse, unspecified eye', '', 'H4300', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7120, 'Vitreous prolapse, right eye', '', 'H4301', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7121, 'Vitreous prolapse, left eye', '', 'H4302', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7122, 'Vitreous prolapse, bilateral', '', 'H4303', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7123, 'Vitreous hemorrhage, unspecified eye', '', 'H4310', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7124, 'Vitreous hemorrhage, right eye', '', 'H4311', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7125, 'Vitreous hemorrhage, left eye', '', 'H4312', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7126, 'Vitreous hemorrhage, bilateral', '', 'H4313', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7127, 'Crystalline deposits in vitreous body, unspecified eye', '', 'H4320', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7128, 'Crystalline deposits in vitreous body, right eye', '', 'H4321', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7129, 'Crystalline deposits in vitreous body, left eye', '', 'H4322', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7130, 'Crystalline deposits in vitreous body, bilateral', '', 'H4323', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7131, 'Vitreous membranes and strands, right eye', '', 'H43311', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7132, 'Vitreous membranes and strands, left eye', '', 'H43312', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7133, 'Vitreous membranes and strands, bilateral', '', 'H43313', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7134, 'Vitreous membranes and strands, unspecified eye', '', 'H43319', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7135, 'Other vitreous opacities, right eye', '', 'H43391', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7136, 'Other vitreous opacities, left eye', '', 'H43392', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7137, 'Other vitreous opacities, bilateral', '', 'H43393', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7138, 'Other vitreous opacities, unspecified eye', '', 'H43399', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7139, 'Vitreous degeneration, right eye', '', 'H43811', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7140, 'Vitreous degeneration, left eye', '', 'H43812', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7141, 'Vitreous degeneration, bilateral', '', 'H43813', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7142, 'Vitreous degeneration, unspecified eye', '', 'H43819', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7143, 'Vitreomacular adhesion, right eye', '', 'H43821', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7144, 'Vitreomacular adhesion, left eye', '', 'H43822', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7145, 'Vitreomacular adhesion, bilateral', '', 'H43823', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7146, 'Vitreomacular adhesion, unspecified eye', '', 'H43829', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7147, 'Other disorders of vitreous body', '', 'H4389', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7148, 'Unspecified disorder of vitreous body', '', 'H439', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7149, 'Unspecified purulent endophthalmitis, right eye', '', 'H44001', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7150, 'Unspecified purulent endophthalmitis, left eye', '', 'H44002', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7151, 'Unspecified purulent endophthalmitis, bilateral', '', 'H44003', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7152, 'Unspecified purulent endophthalmitis, unspecified eye', '', 'H44009', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7153, 'Panophthalmitis (acute), right eye', '', 'H44011', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7154, 'Panophthalmitis (acute), left eye', '', 'H44012', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7155, 'Panophthalmitis (acute), bilateral', '', 'H44013', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7156, 'Panophthalmitis (acute), unspecified eye', '', 'H44019', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7157, 'Vitreous abscess (chronic), right eye', '', 'H44021', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7158, 'Vitreous abscess (chronic), left eye', '', 'H44022', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7159, 'Vitreous abscess (chronic), bilateral', '', 'H44023', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7160, 'Vitreous abscess (chronic), unspecified eye', '', 'H44029', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7161, 'Panuveitis, right eye', '', 'H44111', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7162, 'Panuveitis, left eye', '', 'H44112', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7163, 'Panuveitis, bilateral', '', 'H44113', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7164, 'Panuveitis, unspecified eye', '', 'H44119', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7165, 'Parasitic endophthalmitis, unspecified, right eye', '', 'H44121', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7166, 'Parasitic endophthalmitis, unspecified, left eye', '', 'H44122', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7167, 'Parasitic endophthalmitis, unspecified, bilateral', '', 'H44123', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7168, 'Parasitic endophthalmitis, unspecified, unspecified eye', '', 'H44129', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7169, 'Sympathetic uveitis, right eye', '', 'H44131', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7170, 'Sympathetic uveitis, left eye', '', 'H44132', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7171, 'Sympathetic uveitis, bilateral', '', 'H44133', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7172, 'Sympathetic uveitis, unspecified eye', '', 'H44139', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7173, 'Other endophthalmitis', '', 'H4419', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7174, 'Degenerative myopia, unspecified eye', '', 'H4420', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7175, 'Degenerative myopia, right eye', '', 'H4421', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7176, 'Degenerative myopia, left eye', '', 'H4422', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7177, 'Degenerative myopia, bilateral', '', 'H4423', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7178, 'Unspecified degenerative disorder of globe', '', 'H4430', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7179, 'Chalcosis, right eye', '', 'H44311', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7180, 'Chalcosis, left eye', '', 'H44312', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7181, 'Chalcosis, bilateral', '', 'H44313', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7182, 'Chalcosis, unspecified eye', '', 'H44319', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7183, 'Siderosis of eye, right eye', '', 'H44321', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7184, 'Siderosis of eye, left eye', '', 'H44322', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7185, 'Siderosis of eye, bilateral', '', 'H44323', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7186, 'Siderosis of eye, unspecified eye', '', 'H44329', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7187, 'Other degenerative disorders of globe, right eye', '', 'H44391', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7188, 'Other degenerative disorders of globe, left eye', '', 'H44392', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7189, 'Other degenerative disorders of globe, bilateral', '', 'H44393', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7190, 'Other degenerative disorders of globe, unspecified eye', '', 'H44399', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7191, 'Unspecified hypotony of eye', '', 'H4440', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7192, 'Flat anterior chamber hypotony of right eye', '', 'H44411', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7193, 'Flat anterior chamber hypotony of left eye', '', 'H44412', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7194, 'Flat anterior chamber hypotony of eye, bilateral', '', 'H44413', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7195, 'Flat anterior chamber hypotony of unspecified eye', '', 'H44419', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7196, 'Hypotony of right eye due to ocular fistula', '', 'H44421', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7197, 'Hypotony of left eye due to ocular fistula', '', 'H44422', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7198, 'Hypotony of eye due to ocular fistula, bilateral', '', 'H44423', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7199, 'Hypotony of unspecified eye due to ocular fistula', '', 'H44429', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7200, 'Hypotony of eye due to other ocular disorders, right eye', '', 'H44431', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7201, 'Hypotony of eye due to other ocular disorders, left eye', '', 'H44432', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7202, 'Hypotony of eye due to other ocular disorders, bilateral', '', 'H44433', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7203, 'Hypotony of eye due to other ocular disorders, unspecified eye', '', 'H44439', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7204, 'Primary hypotony of right eye', '', 'H44441', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7205, 'Primary hypotony of left eye', '', 'H44442', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7206, 'Primary hypotony of eye, bilateral', '', 'H44443', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7207, 'Primary hypotony of unspecified eye', '', 'H44449', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7208, 'Unspecified degenerated conditions of globe', '', 'H4450', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7209, 'Absolute glaucoma, right eye', '', 'H44511', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7210, 'Absolute glaucoma, left eye', '', 'H44512', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7211, 'Absolute glaucoma, bilateral', '', 'H44513', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7212, 'Absolute glaucoma, unspecified eye', '', 'H44519', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7213, 'Atrophy of globe, right eye', '', 'H44521', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7214, 'Atrophy of globe, left eye', '', 'H44522', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7215, 'Atrophy of globe, bilateral', '', 'H44523', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7216, 'Atrophy of globe, unspecified eye', '', 'H44529', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7217, 'Leucocoria, right eye', '', 'H44531', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7218, 'Leucocoria, left eye', '', 'H44532', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7219, 'Leucocoria, bilateral', '', 'H44533', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7220, 'Leucocoria, unspecified eye', '', 'H44539', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7221, 'Unspecified retained (old) intraocular foreign body, magnetic, right eye', '', 'H44601', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7222, 'Unspecified retained (old) intraocular foreign body, magnetic, left eye', '', 'H44602', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7223, 'Unspecified retained (old) intraocular foreign body, magnetic, bilateral', '', 'H44603', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7224, 'Unspecified retained (old) intraocular foreign body, magnetic, unspecified eye', '', 'H44609', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7225, 'Retained (old) magnetic foreign body in anterior chamber, right eye', '', 'H44611', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7226, 'Retained (old) magnetic foreign body in anterior chamber, left eye', '', 'H44612', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7227, 'Retained (old) magnetic foreign body in anterior chamber, bilateral', '', 'H44613', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7228, 'Retained (old) magnetic foreign body in anterior chamber, unspecified eye', '', 'H44619', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7229, 'Retained (old) magnetic foreign body in iris or ciliary body, right eye', '', 'H44621', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7230, 'Retained (old) magnetic foreign body in iris or ciliary body, left eye', '', 'H44622', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7231, 'Retained (old) magnetic foreign body in iris or ciliary body, bilateral', '', 'H44623', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7232, 'Retained (old) magnetic foreign body in iris or ciliary body, unspecified eye', '', 'H44629', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7233, 'Retained (old) magnetic foreign body in lens, right eye', '', 'H44631', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7234, 'Retained (old) magnetic foreign body in lens, left eye', '', 'H44632', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7235, 'Retained (old) magnetic foreign body in lens, bilateral', '', 'H44633', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7236, 'Retained (old) magnetic foreign body in lens, unspecified eye', '', 'H44639', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7237, 'Retained (old) magnetic foreign body in posterior wall of globe, right eye', '', 'H44641', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7238, 'Retained (old) magnetic foreign body in posterior wall of globe, left eye', '', 'H44642', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7239, 'Retained (old) magnetic foreign body in posterior wall of globe, bilateral', '', 'H44643', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7240, 'Retained (old) magnetic foreign body in posterior wall of globe, unspecified eye', '', 'H44649', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7241, 'Retained (old) magnetic foreign body in vitreous body, right eye', '', 'H44651', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7242, 'Retained (old) magnetic foreign body in vitreous body, left eye', '', 'H44652', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7243, 'Retained (old) magnetic foreign body in vitreous body, bilateral', '', 'H44653', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7244, 'Retained (old) magnetic foreign body in vitreous body, unspecified eye', '', 'H44659', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7245, 'Retained (old) intraocular foreign body, magnetic, in other or multiple sites, right eye', '', 'H44691', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7246, 'Retained (old) intraocular foreign body, magnetic, in other or multiple sites, left eye', '', 'H44692', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7247, 'Retained (old) intraocular foreign body, magnetic, in other or multiple sites, bilateral', '', 'H44693', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7248, 'Retained (old) intraocular foreign body, magnetic, in other or multiple sites, unspecified eye', '', 'H44699', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7249, 'Unspecified retained (old) intraocular foreign body, nonmagnetic, right eye', '', 'H44701', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7250, 'Unspecified retained (old) intraocular foreign body, nonmagnetic, left eye', '', 'H44702', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7251, 'Unspecified retained (old) intraocular foreign body, nonmagnetic, bilateral', '', 'H44703', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7252, 'Unspecified retained (old) intraocular foreign body, nonmagnetic, unspecified eye', '', 'H44709', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7253, 'Retained (nonmagnetic) (old) foreign body in anterior chamber, right eye', '', 'H44711', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7254, 'Retained (nonmagnetic) (old) foreign body in anterior chamber, left eye', '', 'H44712', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7255, 'Retained (nonmagnetic) (old) foreign body in anterior chamber, bilateral', '', 'H44713', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7256, 'Retained (nonmagnetic) (old) foreign body in anterior chamber, unspecified eye', '', 'H44719', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7257, 'Retained (nonmagnetic) (old) foreign body in iris or ciliary body, right eye', '', 'H44721', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7258, 'Retained (nonmagnetic) (old) foreign body in iris or ciliary body, left eye', '', 'H44722', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7259, 'Retained (nonmagnetic) (old) foreign body in iris or ciliary body, bilateral', '', 'H44723', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7260, 'Retained (nonmagnetic) (old) foreign body in iris or ciliary body, unspecified eye', '', 'H44729', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7261, 'Retained (nonmagnetic) (old) foreign body in lens, right eye', '', 'H44731', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7262, 'Retained (nonmagnetic) (old) foreign body in lens, left eye', '', 'H44732', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7263, 'Retained (nonmagnetic) (old) foreign body in lens, bilateral', '', 'H44733', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7264, 'Retained (nonmagnetic) (old) foreign body in lens, unspecified eye', '', 'H44739', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7265, 'Retained (nonmagnetic) (old) foreign body in posterior wall of globe, right eye', '', 'H44741', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7266, 'Retained (nonmagnetic) (old) foreign body in posterior wall of globe, left eye', '', 'H44742', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7267, 'Retained (nonmagnetic) (old) foreign body in posterior wall of globe, bilateral', '', 'H44743', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7268, 'Retained (nonmagnetic) (old) foreign body in posterior wall of globe, unspecified eye', '', 'H44749', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7269, 'Retained (nonmagnetic) (old) foreign body in vitreous body, right eye', '', 'H44751', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7270, 'Retained (nonmagnetic) (old) foreign body in vitreous body, left eye', '', 'H44752', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7271, 'Retained (nonmagnetic) (old) foreign body in vitreous body, bilateral', '', 'H44753', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7272, 'Retained (nonmagnetic) (old) foreign body in vitreous body, unspecified eye', '', 'H44759', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7273, 'Retained (old) intraocular foreign body, nonmagnetic, in other or multiple sites, right eye', '', 'H44791', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7274, 'Retained (old) intraocular foreign body, nonmagnetic, in other or multiple sites, left eye', '', 'H44792', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7275, 'Retained (old) intraocular foreign body, nonmagnetic, in other or multiple sites, bilateral', '', 'H44793', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7276, 'Retained (old) intraocular foreign body, nonmagnetic, in other or multiple sites, unspecified eye', '', 'H44799', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7277, 'Hemophthalmos, right eye', '', 'H44811', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7278, 'Hemophthalmos, left eye', '', 'H44812', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7279, 'Hemophthalmos, bilateral', '', 'H44813', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7280, 'Hemophthalmos, unspecified eye', '', 'H44819', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7281, 'Luxation of globe, right eye', '', 'H44821', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7282, 'Luxation of globe, left eye', '', 'H44822', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7283, 'Luxation of globe, bilateral', '', 'H44823', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7284, 'Luxation of globe, unspecified eye', '', 'H44829', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7285, 'Other disorders of globe', '', 'H4489', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7286, 'Unspecified disorder of globe', '', 'H449', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7287, 'Optic papillitis, unspecified eye', '', 'H4600', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7288, 'Optic papillitis, right eye', '', 'H4601', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7289, 'Optic papillitis, left eye', '', 'H4602', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7290, 'Optic papillitis, bilateral', '', 'H4603', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7291, 'Retrobulbar neuritis, unspecified eye', '', 'H4610', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7292, 'Retrobulbar neuritis, right eye', '', 'H4611', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7293, 'Retrobulbar neuritis, left eye', '', 'H4612', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7294, 'Retrobulbar neuritis, bilateral', '', 'H4613', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7295, 'Nutritional optic neuropathy', '', 'H462', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7296, 'Toxic optic neuropathy', '', 'H463', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7297, 'Other optic neuritis', '', 'H468', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7298, 'Unspecified optic neuritis', '', 'H469', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7299, 'Ischemic optic neuropathy, right eye', '', 'H47011', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7300, 'Ischemic optic neuropathy, left eye', '', 'H47012', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7301, 'Ischemic optic neuropathy, bilateral', '', 'H47013', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7302, 'Ischemic optic neuropathy, unspecified eye', '', 'H47019', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7303, 'Hemorrhage in optic nerve sheath, right eye', '', 'H47021', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7304, 'Hemorrhage in optic nerve sheath, left eye', '', 'H47022', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7305, 'Hemorrhage in optic nerve sheath, bilateral', '', 'H47023', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7306, 'Hemorrhage in optic nerve sheath, unspecified eye', '', 'H47029', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7307, 'Optic nerve hypoplasia, right eye', '', 'H47031', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7308, 'Optic nerve hypoplasia, left eye', '', 'H47032', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7309, 'Optic nerve hypoplasia, bilateral', '', 'H47033', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7310, 'Optic nerve hypoplasia, unspecified eye', '', 'H47039', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7311, 'Other disorders of optic nerve, not elsewhere classified, right eye', '', 'H47091', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7312, 'Other disorders of optic nerve, not elsewhere classified, left eye', '', 'H47092', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7313, 'Other disorders of optic nerve, not elsewhere classified, bilateral', '', 'H47093', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7314, 'Other disorders of optic nerve, not elsewhere classified, unspecified eye', '', 'H47099', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1);");

DB::statement("INSERT INTO `symptoms` (`id`, `symptoms_title`, `description`, `code`, `status`, `priority`, `created_at`, `updated_at`, `type`) VALUES
(7315, 'Unspecified papilledema', '', 'H4710', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7316, 'Papilledema associated with increased intracranial pressure', '', 'H4711', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7317, 'Papilledema associated with decreased ocular pressure', '', 'H4712', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7318, 'Papilledema associated with retinal disorder', '', 'H4713', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7319, 'Foster-Kennedy syndrome, right eye', '', 'H47141', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7320, 'Foster-Kennedy syndrome, left eye', '', 'H47142', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7321, 'Foster-Kennedy syndrome, bilateral', '', 'H47143', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7322, 'Foster-Kennedy syndrome, unspecified eye', '', 'H47149', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7323, 'Unspecified optic atrophy', '', 'H4720', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7324, 'Primary optic atrophy, right eye', '', 'H47211', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7325, 'Primary optic atrophy, left eye', '', 'H47212', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7326, 'Primary optic atrophy, bilateral', '', 'H47213', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7327, 'Primary optic atrophy, unspecified eye', '', 'H47219', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7328, 'Hereditary optic atrophy', '', 'H4722', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7329, 'Glaucomatous optic atrophy, right eye', '', 'H47231', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7330, 'Glaucomatous optic atrophy, left eye', '', 'H47232', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7331, 'Glaucomatous optic atrophy, bilateral', '', 'H47233', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7332, 'Glaucomatous optic atrophy, unspecified eye', '', 'H47239', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7333, 'Other optic atrophy, right eye', '', 'H47291', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7334, 'Other optic atrophy, left eye', '', 'H47292', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7335, 'Other optic atrophy, bilateral', '', 'H47293', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7336, 'Other optic atrophy, unspecified eye', '', 'H47299', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7337, 'Coloboma of optic disc, right eye', '', 'H47311', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7338, 'Coloboma of optic disc, left eye', '', 'H47312', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7339, 'Coloboma of optic disc, bilateral', '', 'H47313', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7340, 'Coloboma of optic disc, unspecified eye', '', 'H47319', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7341, 'Drusen of optic disc, right eye', '', 'H47321', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7342, 'Drusen of optic disc, left eye', '', 'H47322', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7343, 'Drusen of optic disc, bilateral', '', 'H47323', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7344, 'Drusen of optic disc, unspecified eye', '', 'H47329', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7345, 'Pseudopapilledema of optic disc, right eye', '', 'H47331', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7346, 'Pseudopapilledema of optic disc, left eye', '', 'H47332', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7347, 'Pseudopapilledema of optic disc, bilateral', '', 'H47333', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7348, 'Pseudopapilledema of optic disc, unspecified eye', '', 'H47339', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7349, 'Other disorders of optic disc, right eye', '', 'H47391', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7350, 'Other disorders of optic disc, left eye', '', 'H47392', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7351, 'Other disorders of optic disc, bilateral', '', 'H47393', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7352, 'Other disorders of optic disc, unspecified eye', '', 'H47399', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7353, 'Disorders of optic chiasm in (due to) inflammatory disorders', '', 'H4741', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7354, 'Disorders of optic chiasm in (due to) neoplasm', '', 'H4742', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7355, 'Disorders of optic chiasm in (due to) vascular disorders', '', 'H4743', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7356, 'Disorders of optic chiasm in (due to) other disorders', '', 'H4749', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7357, 'Disorders of visual pathways in (due to) inflammatory disorders, right side', '', 'H47511', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7358, 'Disorders of visual pathways in (due to) inflammatory disorders, left side', '', 'H47512', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7359, 'Disorders of visual pathways in (due to) inflammatory disorders, unspecified side', '', 'H47519', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7360, 'Disorders of visual pathways in (due to) neoplasm, right side', '', 'H47521', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7361, 'Disorders of visual pathways in (due to) neoplasm, left side', '', 'H47522', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7362, 'Disorders of visual pathways in (due to) neoplasm, unspecified side', '', 'H47529', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7363, 'Disorders of visual pathways in (due to) vascular disorders, right side', '', 'H47531', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7364, 'Disorders of visual pathways in (due to) vascular disorders, left side', '', 'H47532', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7365, 'Disorders of visual pathways in (due to) vascular disorders, unspecified side', '', 'H47539', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7366, 'Cortical blindness, right side of brain', '', 'H47611', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7367, 'Cortical blindness, left side of brain', '', 'H47612', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7368, 'Cortical blindness, unspecified side of brain', '', 'H47619', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7369, 'Disorders of visual cortex in (due to) inflammatory disorders, right side of brain', '', 'H47621', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7370, 'Disorders of visual cortex in (due to) inflammatory disorders, left side of brain', '', 'H47622', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7371, 'Disorders of visual cortex in (due to) inflammatory disorders, unspecified side of brain', '', 'H47629', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7372, 'Disorders of visual cortex in (due to) neoplasm, right side of brain', '', 'H47631', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7373, 'Disorders of visual cortex in (due to) neoplasm, left side of brain', '', 'H47632', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7374, 'Disorders of visual cortex in (due to) neoplasm, unspecified side of brain', '', 'H47639', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7375, 'Disorders of visual cortex in (due to) vascular disorders, right side of brain', '', 'H47641', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7376, 'Disorders of visual cortex in (due to) vascular disorders, left side of brain', '', 'H47642', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7377, 'Disorders of visual cortex in (due to) vascular disorders, unspecified side of brain', '', 'H47649', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7378, 'Unspecified disorder of visual pathways', '', 'H479', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7379, 'Third [oculomotor] nerve palsy, unspecified eye', '', 'H4900', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7380, 'Third [oculomotor] nerve palsy, right eye', '', 'H4901', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7381, 'Third [oculomotor] nerve palsy, left eye', '', 'H4902', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7382, 'Third [oculomotor] nerve palsy, bilateral', '', 'H4903', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7383, 'Fourth [trochlear] nerve palsy, unspecified eye', '', 'H4910', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7384, 'Fourth [trochlear] nerve palsy, right eye', '', 'H4911', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7385, 'Fourth [trochlear] nerve palsy, left eye', '', 'H4912', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7386, 'Fourth [trochlear] nerve palsy, bilateral', '', 'H4913', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7387, 'Sixth [abducent] nerve palsy, unspecified eye', '', 'H4920', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7388, 'Sixth [abducent] nerve palsy, right eye', '', 'H4921', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7389, 'Sixth [abducent] nerve palsy, left eye', '', 'H4922', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7390, 'Sixth [abducent] nerve palsy, bilateral', '', 'H4923', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7391, 'Total (external) ophthalmoplegia, unspecified eye', '', 'H4930', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7392, 'Total (external) ophthalmoplegia, right eye', '', 'H4931', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7393, 'Total (external) ophthalmoplegia, left eye', '', 'H4932', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7394, 'Total (external) ophthalmoplegia, bilateral', '', 'H4933', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7395, 'Progressive external ophthalmoplegia, unspecified eye', '', 'H4940', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7396, 'Progressive external ophthalmoplegia, right eye', '', 'H4941', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7397, 'Progressive external ophthalmoplegia, left eye', '', 'H4942', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7398, 'Progressive external ophthalmoplegia, bilateral', '', 'H4943', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7399, 'Kearns-Sayre syndrome, right eye', '', 'H49811', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7400, 'Kearns-Sayre syndrome, left eye', '', 'H49812', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7401, 'Kearns-Sayre syndrome, bilateral', '', 'H49813', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7402, 'Kearns-Sayre syndrome, unspecified eye', '', 'H49819', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7403, 'Other paralytic strabismus, right eye', '', 'H49881', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7404, 'Other paralytic strabismus, left eye', '', 'H49882', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7405, 'Other paralytic strabismus, bilateral', '', 'H49883', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7406, 'Other paralytic strabismus, unspecified eye', '', 'H49889', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7407, 'Unspecified paralytic strabismus', '', 'H499', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7408, 'Unspecified esotropia', '', 'H5000', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7409, 'Monocular esotropia, right eye', '', 'H50011', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7410, 'Monocular esotropia, left eye', '', 'H50012', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7411, 'Monocular esotropia with A pattern, right eye', '', 'H50021', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7412, 'Monocular esotropia with A pattern, left eye', '', 'H50022', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7413, 'Monocular esotropia with V pattern, right eye', '', 'H50031', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7414, 'Monocular esotropia with V pattern, left eye', '', 'H50032', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7415, 'Monocular esotropia with other noncomitancies, right eye', '', 'H50041', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7416, 'Monocular esotropia with other noncomitancies, left eye', '', 'H50042', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7417, 'Alternating esotropia', '', 'H5005', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7418, 'Alternating esotropia with A pattern', '', 'H5006', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7419, 'Alternating esotropia with V pattern', '', 'H5007', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7420, 'Alternating esotropia with other noncomitancies', '', 'H5008', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7421, 'Unspecified exotropia', '', 'H5010', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7422, 'Monocular exotropia, right eye', '', 'H50111', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7423, 'Monocular exotropia, left eye', '', 'H50112', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7424, 'Monocular exotropia with A pattern, right eye', '', 'H50121', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7425, 'Monocular exotropia with A pattern, left eye', '', 'H50122', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7426, 'Monocular exotropia with V pattern, right eye', '', 'H50131', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7427, 'Monocular exotropia with V pattern, left eye', '', 'H50132', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7428, 'Monocular exotropia with other noncomitancies, right eye', '', 'H50141', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7429, 'Monocular exotropia with other noncomitancies, left eye', '', 'H50142', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7430, 'Alternating exotropia', '', 'H5015', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7431, 'Alternating exotropia with A pattern', '', 'H5016', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7432, 'Alternating exotropia with V pattern', '', 'H5017', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7433, 'Alternating exotropia with other noncomitancies', '', 'H5018', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7434, 'Vertical strabismus, right eye', '', 'H5021', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7435, 'Vertical strabismus, left eye', '', 'H5022', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7436, 'Unspecified intermittent heterotropia', '', 'H5030', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7437, 'Intermittent monocular esotropia, right eye', '', 'H50311', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7438, 'Intermittent monocular esotropia, left eye', '', 'H50312', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7439, 'Intermittent alternating esotropia', '', 'H5032', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7440, 'Intermittent monocular exotropia, right eye', '', 'H50331', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7441, 'Intermittent monocular exotropia, left eye', '', 'H50332', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7442, 'Intermittent alternating exotropia', '', 'H5034', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7443, 'Unspecified heterotropia', '', 'H5040', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7444, 'Cyclotropia, right eye', '', 'H50411', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7445, 'Cyclotropia, left eye', '', 'H50412', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7446, 'Monofixation syndrome', '', 'H5042', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7447, 'Accommodative component in esotropia', '', 'H5043', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7448, 'Unspecified heterophoria', '', 'H5050', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7449, 'Esophoria', '', 'H5051', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7450, 'Exophoria', '', 'H5052', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7451, 'Vertical heterophoria', '', 'H5053', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7452, 'Cyclophoria', '', 'H5054', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7453, 'Alternating heterophoria', '', 'H5055', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7454, 'Mechanical strabismus, unspecified', '', 'H5060', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7455, 'Brown\'s sheath syndrome, right eye', '', 'H50611', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7456, 'Brown\'s sheath syndrome, left eye', '', 'H50612', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7457, 'Other mechanical strabismus', '', 'H5069', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7458, 'Duane\'s syndrome, right eye', '', 'H50811', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7459, 'Duane\'s syndrome, left eye', '', 'H50812', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7460, 'Other specified strabismus', '', 'H5089', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7461, 'Unspecified strabismus', '', 'H509', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7462, 'Palsy (spasm) of conjugate gaze', '', 'H510', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7463, 'Convergence insufficiency', '', 'H5111', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7464, 'Convergence excess', '', 'H5112', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7465, 'Internuclear ophthalmoplegia, unspecified eye', '', 'H5120', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7466, 'Internuclear ophthalmoplegia, right eye', '', 'H5121', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7467, 'Internuclear ophthalmoplegia, left eye', '', 'H5122', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7468, 'Internuclear ophthalmoplegia, bilateral', '', 'H5123', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7469, 'Other specified disorders of binocular movement', '', 'H518', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7470, 'Unspecified disorder of binocular movement', '', 'H519', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7471, 'Hypermetropia, unspecified eye', '', 'H5200', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7472, 'Hypermetropia, right eye', '', 'H5201', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7473, 'Hypermetropia, left eye', '', 'H5202', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7474, 'Hypermetropia, bilateral', '', 'H5203', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7475, 'Myopia, unspecified eye', '', 'H5210', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7476, 'Myopia, right eye', '', 'H5211', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7477, 'Myopia, left eye', '', 'H5212', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7478, 'Myopia, bilateral', '', 'H5213', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7479, 'Unspecified astigmatism, right eye', '', 'H52201', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7480, 'Unspecified astigmatism, left eye', '', 'H52202', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7481, 'Unspecified astigmatism, bilateral', '', 'H52203', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7482, 'Unspecified astigmatism, unspecified eye', '', 'H52209', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7483, 'Irregular astigmatism, right eye', '', 'H52211', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7484, 'Irregular astigmatism, left eye', '', 'H52212', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7485, 'Irregular astigmatism, bilateral', '', 'H52213', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7486, 'Irregular astigmatism, unspecified eye', '', 'H52219', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7487, 'Regular astigmatism, right eye', '', 'H52221', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7488, 'Regular astigmatism, left eye', '', 'H52222', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7489, 'Regular astigmatism, bilateral', '', 'H52223', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7490, 'Regular astigmatism, unspecified eye', '', 'H52229', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7491, 'Anisometropia', '', 'H5231', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7492, 'Aniseikonia', '', 'H5232', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7493, 'Presbyopia', '', 'H524', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7494, 'Internal ophthalmoplegia (complete) (total), right eye', '', 'H52511', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7495, 'Internal ophthalmoplegia (complete) (total), left eye', '', 'H52512', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7496, 'Internal ophthalmoplegia (complete) (total), bilateral', '', 'H52513', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7497, 'Internal ophthalmoplegia (complete) (total), unspecified eye', '', 'H52519', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7498, 'Paresis of accommodation, right eye', '', 'H52521', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7499, 'Paresis of accommodation, left eye', '', 'H52522', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7500, 'Paresis of accommodation, bilateral', '', 'H52523', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7501, 'Paresis of accommodation, unspecified eye', '', 'H52529', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7502, 'Spasm of accommodation, right eye', '', 'H52531', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7503, 'Spasm of accommodation, left eye', '', 'H52532', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7504, 'Spasm of accommodation, bilateral', '', 'H52533', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7505, 'Spasm of accommodation, unspecified eye', '', 'H52539', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7506, 'Other disorders of refraction', '', 'H526', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7507, 'Unspecified disorder of refraction', '', 'H527', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7508, 'Unspecified amblyopia, right eye', '', 'H53001', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7509, 'Unspecified amblyopia, left eye', '', 'H53002', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7510, 'Unspecified amblyopia, bilateral', '', 'H53003', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7511, 'Unspecified amblyopia, unspecified eye', '', 'H53009', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7512, 'Deprivation amblyopia, right eye', '', 'H53011', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7513, 'Deprivation amblyopia, left eye', '', 'H53012', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7514, 'Deprivation amblyopia, bilateral', '', 'H53013', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7515, 'Deprivation amblyopia, unspecified eye', '', 'H53019', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7516, 'Refractive amblyopia, right eye', '', 'H53021', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7517, 'Refractive amblyopia, left eye', '', 'H53022', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7518, 'Refractive amblyopia, bilateral', '', 'H53023', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7519, 'Refractive amblyopia, unspecified eye', '', 'H53029', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7520, 'Strabismic amblyopia, right eye', '', 'H53031', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7521, 'Strabismic amblyopia, left eye', '', 'H53032', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7522, 'Strabismic amblyopia, bilateral', '', 'H53033', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7523, 'Strabismic amblyopia, unspecified eye', '', 'H53039', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7524, 'Amblyopia suspect, right eye', '', 'H53041', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7525, 'Amblyopia suspect, left eye', '', 'H53042', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7526, 'Amblyopia suspect, bilateral', '', 'H53043', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7527, 'Amblyopia suspect, unspecified eye', '', 'H53049', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7528, 'Unspecified subjective visual disturbances', '', 'H5310', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7529, 'Day blindness', '', 'H5311', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7530, 'Transient visual loss, right eye', '', 'H53121', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7531, 'Transient visual loss, left eye', '', 'H53122', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7532, 'Transient visual loss, bilateral', '', 'H53123', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7533, 'Transient visual loss, unspecified eye', '', 'H53129', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7534, 'Sudden visual loss, right eye', '', 'H53131', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7535, 'Sudden visual loss, left eye', '', 'H53132', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7536, 'Sudden visual loss, bilateral', '', 'H53133', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7537, 'Sudden visual loss, unspecified eye', '', 'H53139', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7538, 'Visual discomfort, right eye', '', 'H53141', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7539, 'Visual discomfort, left eye', '', 'H53142', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7540, 'Visual discomfort, bilateral', '', 'H53143', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7541, 'Visual discomfort, unspecified', '', 'H53149', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7542, 'Visual distortions of shape and size', '', 'H5315', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7543, 'Psychophysical visual disturbances', '', 'H5316', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7544, 'Other subjective visual disturbances', '', 'H5319', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7545, 'Diplopia', '', 'H532', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7546, 'Unspecified disorder of binocular vision', '', 'H5330', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7547, 'Abnormal retinal correspondence', '', 'H5331', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7548, 'Fusion with defective stereopsis', '', 'H5332', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7549, 'Simultaneous visual perception without fusion', '', 'H5333', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7550, 'Suppression of binocular vision', '', 'H5334', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7551, 'Unspecified visual field defects', '', 'H5340', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7552, 'Scotoma involving central area, right eye', '', 'H53411', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7553, 'Scotoma involving central area, left eye', '', 'H53412', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7554, 'Scotoma involving central area, bilateral', '', 'H53413', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7555, 'Scotoma involving central area, unspecified eye', '', 'H53419', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7556, 'Scotoma of blind spot area, right eye', '', 'H53421', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7557, 'Scotoma of blind spot area, left eye', '', 'H53422', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7558, 'Scotoma of blind spot area, bilateral', '', 'H53423', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7559, 'Scotoma of blind spot area, unspecified eye', '', 'H53429', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7560, 'Sector or arcuate defects, right eye', '', 'H53431', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7561, 'Sector or arcuate defects, left eye', '', 'H53432', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7562, 'Sector or arcuate defects, bilateral', '', 'H53433', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1),
(7563, 'Sector or arcuate defects, unspecified eye', '', 'H53439', 1, 1.00, '0000-00-00 00:00:00', '0000-00-00 00:0