<?php

namespace Database\Seeders;

use App\Models\TaskCharges;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class TaskChargesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
       $charge = [
            [
             'name'       => 'Free',
             'code'       => 'FREE',
             'priority'   => 1,
             'is_default'    => 1,
             'created_at' => now(),
             'updated_at' => now(),
            ],
            [
             'name'       => 'Chargeable',
             'code'       => 'CHARGEABLE',
             'priority'   => 2,
             'is_default'    => 0,
             'created_at' => now(),
             'updated_at' => now(),
            ],

        ];
        foreach ($charge as $data) {
            TaskCharges::firstOrCreate(
                ['code' => $data['code']],
                $data
            );
        }
    }
}
