<?php

namespace Database\Seeders;

use App\Models\TaskPriority;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class TaskPriorityTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
       $floor = [
            [
             'name'       => 'Normal Priority',
             'code'       => 'NORMAL_PRIORITY',
             'priority'   => 1,
             'bg_color'   => '#ffffff',
             'color'      => '#000000',
             'created_at' => now(),
             'updated_at' => now(),
            ],
            [
             'name'       => 'High Priority',
             'code'       => 'HIGH_PRIORITY',
             'priority'   => 2,
             'bg_color'   => '#ff9500',
             'color'      => '#000000',
             'created_at' => now(),
             'updated_at' => now(),
            ],
            [
             'name'       => 'Urgent Priority',
             'code'       => 'URGENT_PRIORITY',
             'priority'   => 3,
             'bg_color'   => '#FF6347',
             'color'      => '#000000',
             'created_at' => now(),
             'updated_at' => now(),
            ],
            [
             'name'       => 'HOLD',
             'code'       => 'HOLD',
             'priority'   => 3,
             'bg_color'   => '#c7fff4',
             'color'      => '#000000',
             'created_at' => now(),
             'updated_at' => now(),
            ],
        ];
        foreach ($floor as $data) {
            TaskPriority::firstOrCreate(
                ['code' => $data['code']],
                $data
            );
        }
    }
}
