<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\TaskStatus;

class TaskStatusTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        /**
         * Reset the TaskStatus table
         */
        // if (\App::environment('local')) {
        //     TaskStatus::truncate();
        // }
        $statuses = [
            [
                'name'       => 'Recheck',
                'code'       => 'RESULT_RECHECK',
                'bg_color'   => null,
                'color'      => null,
                'priority'   => '1',
                'status'     => '1',
                'is_default' => '0',
            ],
            [
                'name'       => 'Updated',
                'code'       => 'RESULT_UPDATED',
                'bg_color'   => null,
                'color'      => null,
                'status'     => '1',
                'priority'   => '2',
                'is_default' => '0',
            ],
            [
                'name'       => 'Sample Collected',
                'code'       => 'SAMPLE_COLLECTED',
                'bg_color'   => null,
                'color'      => null,
                'status'     => '1',
                'priority'   => '2',
                'is_default' => '0',
            ],
            [
                'name'       => 'Done',
                'code'       => 'RESULT_REVIEWED',
                'bg_color'   => null,
                'color'      => null,
                'status'     => '1',
                'priority'   => '2',
                'is_default' => '0',
            ],
            [
                'name'       => 'Hold',
                'code'       => 'HOLD',
                'bg_color'   => null,
                'color'      => null,
                'priority'   => '3',
                'status'     => '1',
                'is_default' => '0',
            ],
            [
                'name'       => 'Pending',
                'code'       => 'PENDING',
                'bg_color'   => null,
                'color'      => null,
                'priority'   => '4',
                'status'     => '1',
                'is_default' => '1',
            ],
        ];

        foreach ($statuses as $value) {
            TaskStatus::firstOrCreate(
                ['code' => $value['code']],
                $value
            );
        }
    }
}
