<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\TaskType;

class TaskTypesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $statuses = [
            [
				'title'       => 'Bug',
				'description' => 'A software bug or error',
				'priority'    => 1,
				'status'      => 1
            ],
            [
				'title'       => 'Feature',
				'description' => 'A new feature to be implemented',
				'priority'    => 2,
				'status'      => 1
            ],
            [
				'title'       => 'Improvement',
				'description' => 'An enhancement to an existing feature',
				'priority'    => 3,
				'status'      => 1
            ],
        ];

        foreach ($statuses as $value) {
            TaskType::firstOrCreate(
                ['title' => $value['title']],
                $value
            );
        }
    }
}
