<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use App\Models\TaxCategory;

class TaxCategoryTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
    	$category = [
			[
	            'name'          => 'Regular',
	            'code'          => 1,
	            'description'   => 'Supplies are taxable but do not attract GST and for which ITC cannot be claimed',
	            'priority'      => 1,
	            'default'       => 0,
	            'created_at'    => null,
	            'updated_at'    => null,
	        ],
	        [
	            'name'          => 'Nil Rated',
	            'code'          => 2,
	            'description'   => 'Supplies that have a declared rate of 0% GST.
Example: Salt, grains, jaggery etc',
	            'priority'      => 2,
	            'default'       => 0,
	            'created_at'    => null,
	            'updated_at'    => null,
	        ],
	        [
	            'name'          => 'Non-GST',
	            'code'          => 3,
	            'description'   => 'These supplies do not come under the purview of GST law.
Alchol for human consumption etc',
	            'priority'      => 3,
	            'default'       => 0,
	            'created_at'    => null,
	            'updated_at'    => null,
			],
			[
	            'name'          => 'Zero-Rated',
	            'code'          => 4,
	            'description'   => 'Exports Supplies made to SEZ or SEZ Developers',
	            'priority'      => 4,
	            'default'       => '1',
	            'created_at'    => null,
	            'updated_at'    => null,
	        ],
	        [
	            'name'          => 'Exempt',
	            'code'          => 5,
	            'description'   => 'Export supplies made to SEZ or SEZ developers',
	            'priority'      => 5,
	            'default'       => 0,
	            'created_at'    => null,
	            'updated_at'    => null,
	        ]
	    ];

        foreach ($category as $value) {
            TaxCategory::firstOrCreate(
                ['code' => $value['code']],
                $value
            );
        }
    }
}
