<?php

namespace Database\Seeders;

use App\Models\TaxMasterSub;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class TaxMasterSubTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        /**
         * Reset the MasterType table
         */
        // if (\App::environment('local')) {
        //     TaxMasterSub::truncate();
        // }

        $data = [
            [
                'tax_master_id' => 1,
                'name'          => 'IGST',
                'code'          => 'IGST',
                'percentage'    => 0.00,
                'calculation'   => 'ON-BASIC',
                'Description'   => '',
                'priority'      => 1,
                'status'        => '1',
            ],
            [
                'tax_master_id' => 1,
                'name'          => 'CGST',
                'code'          =>'CGST',
                'percentage'    => 0.00,
                'calculation'   => 'ON-BASIC',
                'Description'   => '',
                'priority'      => 1,
                'status'        => '1',
            ],
            [
                'tax_master_id' => 1,
                'name'          => 'SGST',
                'code'          => 'SGST',
                'percentage'    => 0.00,
                'calculation'   => 'ON-BASIC',
                'Description'   => '',
                'priority'      => 1,
                'status'        => '1',
            ],
            [
                'tax_master_id' => 2,
                'name'          => 'IGST',
                'code'          => 'IGST/',
                'percentage'    => 3.00,
                'calculation'   => 'ON-BASIC',
                'Description'   => '',
                'priority'      => 1,
                'status'        => '1',
            ],
            [
                'tax_master_id' => 2,
                'name'          => 'CGST',
                'code'          => 'CGST',
                'percentage'    => 1.50,
                'calculation'   => 'ON-BASIC',
                'Description'   => '',
                'priority'      => 1,
                'status'        => '1',
            ],
            [
                'tax_master_id' => 2,
                'name'          => 'SGST',
                'code'          => 'SGST/',
                'percentage'    => 1.50,
                'calculation'   => 'ON-BASIC',
                'Description'   => '',
                'priority'      => 1,
                'status'        => '1',
            ],
            [
                'tax_master_id' => 3,
                'name'          => 'IGST',
                'code'          => 'IGST',
                'percentage'    => 5.00,
                'calculation'   => 'ON-BASIC',
                'Description'   => '',
                'priority'      => 1,
                'status'        => '1',
            ],
            [
                'tax_master_id' => 3,
                'name'          => 'CGST',
                'code'          => 'CGST',
                'percentage'    => 2.50,
                'calculation'   => 'ON-BASIC',
                'Description'   => '',
                'priority'      => 1,
                'status'        => '1',
            ],
            [
                'tax_master_id' => 3,
                'name'          => 'SGST',
                'code'          => 'SGST',
                'percentage'    => 2.50,
                'calculation'   => 'ON-BASIC',
                'Description'   => '',
                'priority'      => 1,
                'status'        => '1',
            ],
            [
                'tax_master_id' => 4,
                'name'          => 'IGST',
                'code'          => 'IGST',
                'percentage'    => 12.00,
                'calculation'   => 'ON-BASIC',
                'Description'   => '',
                'priority'      => 1,
                'status'        => '1',
            ],
            [
                'tax_master_id' => 4,
                'name'          => 'CGST',
                'code'          => 'CGST',
                'percentage'    => 6.00,
                'calculation'   => 'ON-BASIC',
                'Description'   => '',
                'priority'      => 1,
                'status'        => '1',
            ],
            [
                'tax_master_id' => 4,
                'name'          => 'SGST',
                'code'          => 'SGST',
                'percentage'    => 6.00,
                'calculation'   => 'ON-BASIC',
                'Description'   => '',
                'priority'      => 1,
                'status'        => '1',
            ],
            [
                'tax_master_id' => 5,
                'name'          => 'IGST',
                'code'          => 'IGST',
                'percentage'    => 18.00,
                'calculation'   => 'ON-BASIC',
                'Description'   => '',
                'priority'      => 1,
                'status'        => '1',
            ],
            [
                'tax_master_id' => 5,
                'name'          => 'CGST',
                'code'          => 'CGST',
                'percentage'    => 9.00,
                'calculation'   => 'ON-BASIC',
                'Description'   => '',
                'priority'      => 1,
                'status'        => '1',
            ],
            [
                'tax_master_id' => 5,
                'name'          => 'SGST',
                'code'          => 'SGST',
                'percentage'    => 9.00,
                'calculation'   => 'ON-BASIC',
                'Description'   => '',
                'priority'      => 1,
                'status'        => '1',
            ],
            [
                'tax_master_id' => 6,
                'name'          => 'IGST',
                'code'          => 'IGST',
                'percentage'    => 28.00,
                'calculation'   => 'ON-BASIC',
                'Description'   => '',
                'priority'      => 1,
                'status'        => '1',
            ],
            [
                'tax_master_id' => 6,
                'name'          => 'CGST',
                'code'          => 'CGST',
                'percentage'    => 14.00,
                'calculation'   => 'ON-BASIC',
                'Description'   => '',
                'priority'      => 1,
                'status'        => '1',
            ],
            [
                'tax_master_id' => 6,
                'name'          => 'SGST',
                'code'          =>  'SGST',
                'percentage'    => 14.00,
                'calculation'   => 'ON-BASIC',
                'Description'   => '',
                'priority'      => 1,
                'status'        => '1',
            ],
            [
                'tax_master_id' => 7,
                'name'          => 'IGST',
                'code'          => 'IGST',
                'percentage'    => 28.00,
                'calculation'   => 'ON-BASIC',
                'Description'   => '',
                'priority'      => 1,
                'status'        => '1',
            ],
            [
                'tax_master_id' => 7,
                'name'          => 'CGST',
                'code'          => 'CGST',
                'percentage'    => 14.00,
                'calculation'   => 'ON-BASIC',
                'Description'   => '',
                'priority'      => 1,
                'status'        => '1',
            ],
            [
                'tax_master_id' => 7,
                'name'          => 'SGST',
                'code'          => 'SGST',
                'percentage'    => 14.00,
                'calculation'   => 'ON-BASIC',
                'Description'   => '',
                'priority'      => 1,
                'status'        => '1',
            ],
            [
                'tax_master_id' => 7,
                'name'          => 'CESS',
                'code'          => 'CESS',
                'percentage'    => 0.00,
                'calculation'   => 'ON-BASIC',
                'Description'   => '',
                'priority'      => 1,
                'status'        => '1',
            ],
        ];

        foreach ($data as $value) {
            TaxMasterSub::updateOrCreate(
                ['tax_master_id' => $value['tax_master_id'], 'code' => $value['code']],
                $value
            );
        }
    }
}
