<?php

namespace Database\Seeders;

use App\Models\TaxMaster;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class TaxMasterTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $data = [
            [
                'account_id'       => 1,
                'name'             => 'Tax Free',
                'code'             => 'TAX_FREE',
                'Description'      => 'GST- Goods and Service Tax',
                'total_percentage' => 0,
                'calculation'      => 'ON-BASIC',
                'tax_category_id'  => 1,
                'default'          => '1',
                'priority'         => 1,
                'status'           => '1',
            ],
            [
                'account_id'       => 2,
                'name'             => '3% GST',
                'code'             => '3%_GST',
                'Description'      => 'GST - Goods and Service Tax',
                'total_percentage' => 3,
                'calculation'      => 'ON-BASIC',
                'tax_category_id'  => 1,
                'default'          => '0',
                'priority'         => 2,
                'status'           => '1',
            ],
            [
                'account_id'       => 3,
                'name'             => '5% GST',
                'code'             => '5%_GST',
                'Description'      => 'GST - Goods and Service Tax',
                'total_percentage' => 5,
                'calculation'      => 'ON-BASIC',
                'tax_category_id'  => 1,
                'default'          => '0',
                'priority'         => 3,
                'status'           => '1',
            ],
            [
                'account_id'       => 4,
                'name'             => '12% GST',
                'code'             => '12%_GST',
                'Description'      => 'GST - Goods and Service Tax',
                'total_percentage' => 12,
                'calculation'      => 'ON-BASIC',
                'tax_category_id'  => 1,
                'default'          => '0',
                'priority'         => 4,
                'status'           => '1',
            ],
            [
                'account_id'       => 5,
                'name'             => '18% GST',
                'code'             => '18%_GST',
                'Description'      => 'GST - Goods and Service Tax',
                'total_percentage' => 18,
                'calculation'      => 'ON-BASIC',
                'tax_category_id'  => 1,
                'default'          => '0',
                'priority'         => 5,
                'status'           => '1',
            ],
            [
                'account_id'       => 6,
                'name'             => '28% GST',
                'code'             => '28%_GST',
                'Description'      => 'GST - Goods and Service Tax',
                'total_percentage' => 28,
                'calculation'      => 'ON-BASIC',
                'tax_category_id'  => 1,
                'default'          => '0',
                'priority'         => 6,
                'status'           => '1',
            ],
            [
                'account_id'       => 7,
                'name'             => '28% + Cess GST',
                'code'             => '28%+CESS_GST',
                'Description'      => 'GST - Goods and Service Tax',
                'total_percentage' => 28,
                'calculation'      => 'ON-BASIC',
                'tax_category_id'  => 1,
                'default'          => '0',
                'priority'         => 7,
                'status'           => '1',
            ],
        ];

        foreach ($data as $value) {
            TaxMaster::firstOrCreate(
                ['code' => $value['code']],
                $value
            );
        }

    }
}
