<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\TaxRegisterCategory;

class TaxRegisterCategoryTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $tax_register_categories = [
            [
                'name'       => 'Regular Registration',
                'code'       => 'REGULAR_REGISTRATION',
                'is_default' => 1,
            ],
            [
                'name' => 'Composition Scheme Registration',
                'code' => 'COMPOSITION_SCHEME_REGISTRATION',
                'is_default' => 0,
            ],
            [
                'name' => 'Casual Registration',
                'code' => 'CASUAL_REGISTRATION',
                'is_default' => 0,
            ],
            [
                'name' => 'Non-Resident Registration',
                'code' => 'NON_RESIDENT_REGISTRATION',
                'is_default' => 0,
            ],
            [
                'name' => 'SEZ Registration',
                'code' => 'SEZ_REGISTRATION',
                'is_default' => 0,
            ]
        ];
        foreach ($tax_register_categories as $value) {
            TaxRegisterCategory::firstOrCreate(
                ['code' => $value['code']],
                $value
            );
        }
    }
}
