<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Department;

class TestDepartmentsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Disable foreign key checks
        \DB::statement('SET FOREIGN_KEY_CHECKS=0');
        Department::truncate();
        // Enable foreign key checks
        \DB::statement('SET FOREIGN_KEY_CHECKS=1');

        \DB::statement("
            INSERT INTO `test_departments` (`id`, `name`, `code`, `priority`, `description`, `page_break`, `show_in_report`, `show_report_heading`, `status`) VALUES
            (1, 'URINE EXAMINATION', 'URINE_EXAMINATION', 1, NULL, 0, 1, 1, 1),
            (2, 'IMMUNOLOGY', 'IMMUNOLOGY', 2, NULL, 0, 1, 1, 1),
            (3, 'BLOOD GROUP', 'BLOOD_GROUP', 3, NULL, 0, 1, 1, 1),
            (4, 'IMMUNOASSAY', 'IMMUNOASSAY', 4, NULL, 0, 1, 1, 1),
            (5, 'CST', 'CST', 5, NULL, 0, 1, 1, 1),
            (6, 'DRUG OF ABUSE ( DOA ) 6.1 PANNEL', 'DRUG_OF_ABUSE_(_DOA_)_6.1_PANNEL', 6, NULL, 0, 1, 1, 1),
            (7, 'ELECTROLYTE PROFILE', 'ELECTROLYTE_PROFILE', 7, NULL, 0, 1, 1, 1),
            (8, 'EXAMINATION OF BLOOD', 'EXAMINATION_OF_BLOOD', 8, NULL, 0, 1, 1, 1),
            (9, 'EXAMINATION OF SPUTUM', 'EXAMINATION_OF_SPUTUM', 9, NULL, 0, 1, 1, 1),
            (10, 'GLYCOSYLATED HAEMOGLOBIN', 'GLYCOSYLATED_HAEMORGLOBIN', 10, NULL, 0, 1, 1, 1),
            (11, 'HAEMATOLOGY EXAMINATION', 'HAEMATOLOGY_EXAMINATION', 11, NULL, 0, 1, 1, 1),
            (12, 'MICROALBUMINURIA, URINE', 'MICROALBUMINURIA__URINE', 12, NULL, 0, 1, 1, 1),
            (13, 'NAIL CLIPING', 'NAIL_CLIPPING', 13, NULL, 0, 1, 1, 1),
            (14, 'Oral Glucose Tolerance Test (OGTT)', 'ORAL_GLUCOSE_TOLERANCE_TEST_(OGTT)', 14, NULL, 0, 1, 1, 1),
            (15, 'PERIPHERAL BLOOD SMEAR', 'PERIPHERAL_BLOOD_SMEAR', 15, NULL, 0, 1, 1, 1),
            (16, 'RENAL FUNCTION TEST', 'RENAL_FUNCTION_TEST', 16, NULL, 0, 1, 1, 1),
            (17, 'SEMEN APPRAISAL REPORT', 'SEMEN_APPRAISAL_REPORT', 17, NULL, 0, 1, 1, 1),
            (18, 'SEROLOGY', 'SEROLOGY', 18, NULL, 0, 1, 1, 1),
            (19, 'SKIN SCRAPING', 'SKIN_SCRAPING', 19, NULL, 0, 1, 1, 1),
            (20, 'SPUTUM GRAMSTAIN', 'SPUTUM_GRAMSTAIN', 20, NULL, 0, 1, 1, 1),
            (21, 'SPUTUM ROUTINE EXAMINATION', 'SPUTUM_ROUTINE_EXAMINATION', 21, NULL, 0, 1, 1, 1),
            (22, 'STOOL EXAMINATION', 'STOOL_EXAMINATION', 22, NULL, 0, 1, 1, 1),
            (23, 'URINALYSIS', 'URINALYSIS', 23, NULL, 0, 1, 1, 1),
            (24, 'URINE', 'URINE', 24, NULL, 0, 1, 1, 1),
            (25, 'URINE BENCE JONES PROTEIN', 'URINE_BENCE_JONES_PROTEIN', 25, NULL, 0, 1, 1, 1),
            (26, 'Urine For Pregnancy Test', 'URINE_FOR_PREGNANCY_TEST', 26, NULL, 0, 1, 1, 1),
            (27, 'VAGINAL SWAB GRAM STAIN', 'VAGINAL_SWAB_GRAM_STAIN', 27, NULL, 0, 1, 1, 1),
            (28, 'VAGINAL SWAB KOH', 'VAGINAL_SWAB_KOH', 28, NULL, 0, 1, 1, 1),
            (29, 'VAGINAL SWAB pH', 'VAGINAL_SWAB_PH', 29, NULL, 0, 1, 1, 1),
            (30, 'TURBIDIMETRY TEST', 'TURBIDIMETRY_TEST', 30, NULL, 0, 1, 1, 1),
            (31, 'BIO-CHEMISTRY EXAMINATION', 'BIO_LOGICAL_CHEMISTRY', 31, NULL, 0, 1, 1, 1),
            (32, 'THYROID  TEST', 'THYROID_TEST', 32, NULL, 0, 1, 1, 1),
            (33, 'SEMEN ANALYSIS', 'SEMEN_ANALYSIS', 33, NULL, 0, 1, 1, 1),
            (34, 'SPECIAL HAEMATOLOGY', 'SPECIAL_HAEMATOLOGY', 34, NULL, 0, 1, 1, 1),
            (35, 'MICRO-BIOLOGY', 'MICROBIOLOGY', 35, NULL, 0, 1, 1, 1),
            (36, 'ROUTINE EXAMINATION OF FLUID', 'ROUTINE_EXAMINATION_OF_FLUID', 36, NULL, 0, 1, 1, 1),
            (37, 'COAGULATION', 'COAGULATION', 37, NULL, 0, 1, 1, 1),
            (38, 'SPECTROPHOTOMETRY', 'SPECTROPHOTOMETRY', 38, NULL, 0, 1, 1, 1),
            (39, 'Enzymatic', 'ENZYMATIC', 39, NULL, 0, 1, 1, 1),
            (40, 'ECLIA', 'ECLIA', 40, NULL, 0, 1, 1, 1),
            (41, 'CYTOPATHOLOGY', 'CYTOPATHOLOGY', 41, NULL, 0, 1, 1, 1),
            (42, 'CLINICAL PATHOLOGY', 'CLINICAL_PATHOLOGY', 42, NULL, 0, 1, 1, 1),
            (43, 'Ketone Bodies', 'KETONE_BODIES', 43, NULL, 0, 1, 1, 1),
            (44, 'USG W/A + F/P', 'USG_W/A_+_F/P', 44, NULL, 0, 1, 1, 1),
            (45, 'USG', 'USG', 45, NULL, 0, 1, 1, 1),
            (46, 'QUADRUPLE MARKER', 'QUADRUPLE_MARKER', 46, NULL, 0, 1, 1, 1),
            (47, 'ALLERGY PROFILE', 'ALLERGY_PROFILE', 47, NULL, 0, 1, 1, 1),
            (48, 'URINE ALBUMIN', 'URINE_ALBUMIN', 48, NULL, 0, 1, 1, 1),
            (49, 'SICKLING', 'SICKLING', 49, NULL, 0, 1, 1, 1),
            (50, 'HAEMATOLOGY', 'HAEMATOLOGY', 50, NULL, 0, 1, 1, 1),
            (51, 'COAGULATION PROFILE', 'COAGULATION_PROFILE', 51, NULL, 0, 1, 1, 1),
            (52, 'COVID', 'COVID', 52, NULL, 0, 1, 1, 1),
            (53, 'SCL 70', 'SCL_70', 53, NULL, 0, 1, 1, 1),
            (54, 'CD4', 'CD4', 54, NULL, 0, 1, 1, 1),
            (55, 'RBS WITH 50 GM GLUCOSE', 'RBS_WITH_50_GM_GLUCOSE', 55, NULL, 0, 1, 1, 1),
            (56, 'ECG', 'ECG', 56, NULL, 0, 1, 1, 1);
        ");
    }
}
