<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\TestPackageGroupTestItem;
use App\Models\TestItem;

class TestItemsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
      // Disable foreign key checks
      \DB::statement('SET FOREIGN_KEY_CHECKS=0');
      TestItem::truncate();
      TestPackageGroupTestItem::truncate();
      // Enable foreign key checks
      \DB::statement('SET FOREIGN_KEY_CHECKS=1');

      \DB::statement("INSERT INTO `test_items` (`id`, `name`, `short_name`, `formula_code`, `input_type`, `code`, `item_type`, `test_number`, `default_result`, `result_source`, `result_guide`, `reference_value`, `reference_value_type`, `details`, `is_read_only`, `status`, `primary_unit_id`, `test_method_id`, `machine_id`, `created_at`, `updated_at`, `deleted_at`) VALUES
            (1, 'ALT (SGPT)', NULL, '', 'TEXT', 'ALT_(SGPT)', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, 'Male: Up to 40 Female: Up to 35', 'RANGE', NULL, 0, 0, 21, 0, NULL, '2024-04-20 04:40:06', '2024-05-07 06:48:06', NULL),
            (2, 'GLOBULIN', NULL, '', 'TEXT', 'GLOBULIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '2.5 - 3.6', 'RANGE', NULL, 0, 1, 17, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (3, 'NEUTROPHILS', NULL, '', 'TEXT', 'NEUTROPHILS', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '40 - 75', 'RANGE', NULL, 0, 1, 1, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (4, 'LYMPHOCYTES', NULL, '', 'TEXT', 'LYMPHOCYTES', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '20 - 40', 'RANGE', NULL, 0, 1, 1, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (5, 'MONOCYTES', NULL, '', 'TEXT', 'MONOCYTES', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '0 - 10', 'RANGE', NULL, 0, 1, 1, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (6, 'EOSINOPHILS', NULL, '', 'TEXT', 'EOSINOPHILS', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '44932', 'RANGE', NULL, 0, 1, 1, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (7, 'BASOPHILS', NULL, '', 'TEXT', 'BASOPHILS', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '< 1', 'RANGE', NULL, 0, 1, 1, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (8, 'TOTAL RBC COUNT', NULL, 'CBC-RBC', 'NUMBER', 'TOTAL_RBC_COUNT', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, 'Male: 4.5-5.5 Female: 3.8-4.8', 'RANGE', NULL, 0, 1, 31, NULL, NULL, '2024-04-20 04:40:06', '2024-04-20 10:21:31', NULL),
            (9, 'HEMOGLOBIN (Hb%)', NULL, 'CBC-HEMOGLOBIN', 'TEXT', 'HEMOGLOBIN_(HB%)', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, 'Male:13.5-16.5 Female:12-15', 'RANGE', NULL, 0, 1, 15, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (10, 'MCV (Mean Corpuscular Volume)', NULL, 'CBC-MCV', 'TEXT', 'MCV_(MEAN_CORPUSCULAR_VOLUME)', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '80 - 99', 'RANGE', NULL, 0, 1, 2, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (11, 'MCH (Mean Corpuscular Haemoglobin)', NULL, 'CBC-MCH', 'TEXT', 'MCH_(MEAN_CORPUSCULAR_HAEMOGLOBIN)', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '27 - 32', 'RANGE', NULL, 0, 1, 44, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (12, 'MCHC', NULL, 'CBC-MCHC', 'TEXT', 'MCHC', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '32-36', 'RANGE', NULL, 0, 1, 15, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (13, 'RDW-CV', NULL, '', 'TEXT', 'RDW-CV', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '45244', 'RANGE', NULL, 0, 1, 1, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (14, 'RDW-SD', NULL, '', 'TEXT', 'RDW-SD', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '39 - 45', 'RANGE', NULL, 0, 1, 2, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (15, 'PLATELET COUNT', NULL, '', 'TEXT', 'PLATELET_COUNT', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '1.5 - 4.0', 'RANGE', NULL, 0, 1, 23, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (16, 'TLC (WBC)', NULL, '', 'TEXT', 'TLC_(WBC)', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '4000-11000', 'RANGE', NULL, 0, 1, 3, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (17, 'DIFFERENTIAL COUNT  NEUTROPHILS', NULL, NULL, 'TEXT', 'DIFFERENTIAL_COUNT_NEUTROPHILS', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '40 - 70', 'RANGE', NULL, 0, 1, 1, NULL, NULL, '2024-04-20 04:40:06', '2024-04-27 11:34:42', NULL),
            (18, 'LYMPHOCYTES', NULL, NULL, 'TEXT', 'LYMPHOCYTES', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '20-40', 'RANGE', NULL, 0, 1, 1, NULL, NULL, '2024-04-20 04:40:06', '2024-04-27 11:34:53', NULL),
            (19, 'MONOCYTES', NULL, NULL, 'TEXT', 'MONOCYTES', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '00-10', 'RANGE', NULL, 0, 1, 1, NULL, NULL, '2024-04-20 04:40:06', '2024-04-27 11:35:01', NULL),
            (20, 'EOSINOPHILS', NULL, NULL, 'TEXT', 'EOSINOPHILS', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '44932', 'RANGE', NULL, 0, 1, 1, NULL, NULL, '2024-04-20 04:40:06', '2024-04-27 11:36:21', NULL),
            (21, 'BASOPHILS', NULL, NULL, 'TEXT', 'BASOPHILS', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '00-01', 'RANGE', NULL, 0, 1, 1, NULL, NULL, '2024-04-20 04:40:06', '2024-04-27 11:36:29', NULL),
            (22, 'RED BLOOD CELL COUNT', NULL, '', 'TEXT', 'RED_BLOOD_CELL_COUNT', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '4.50-5.50', 'RANGE', NULL, 0, 1, 30, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (23, 'HEMOGLOBIN (Hb%)', NULL, NULL, 'TEXT', 'HEMOGLOBIN_(HB%)', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, 'Male:13-16 Female:11-13 Birth to 3 Days:_x005F_x000D_14-22 1 Month-12 Years: 11.5-15.5_x005F_x000D_', 'RANGE', NULL, 0, 1, 18, 11, NULL, '2024-04-20 04:40:06', '2024-04-29 10:36:48', NULL),
            (24, 'ERYTHROCYTE SEDIMENTATION RATE (ESR)', NULL, '', 'TEXT', 'ERYTHROCYTE_SEDIMENTATION_RATE_(ESR)', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '0 to 20', 'RANGE', NULL, 0, 1, 37, 60, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (25, 'PLATELET COUNT', NULL, NULL, 'TEXT', 'PLATELET_COUNT', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '1.5-4.5', 'RANGE', NULL, 0, 1, 23, NULL, NULL, '2024-04-20 04:40:06', '2024-05-01 09:15:34', NULL),
            (26, 'BAND CELL', NULL, NULL, 'TEXT', 'BAND_CELL', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 1, NULL, NULL, '2024-04-20 04:40:06', '2024-04-30 09:48:26', NULL),
            (27, 'TOXIC GRANULAR', NULL, NULL, 'TEXT', 'TOXIC_GRANULAR', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-05-01 11:11:42', NULL),
            (28, 'BLEEDING TIME', NULL, NULL, 'TEXT', 'BLEEDING_TIME', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-04-30 09:53:47', NULL),
            (29, 'CLOTTING TIME', NULL, NULL, 'TEXT', 'CLOTTING_TIME', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-04-30 10:48:41', NULL),
            (30, 'ABSOLUTE EOSINOPHILS COUNT', NULL, NULL, 'TEXT', 'ABSOLUTE_EOSINOPHILS_COUNT', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '40 - 440', 'RANGE', NULL, 0, 1, 3, NULL, NULL, '2024-04-20 04:40:06', '2024-05-04 06:18:29', NULL),
            (31, 'ABSOLUTE NEUTROPHIL COUNT', NULL, '', 'TEXT', 'ABSOLUTE_NEUTROPHIL_COUNT', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'RANGE', NULL, 0, 1, 3, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (32, 'RETICULOCYTE COUNT', NULL, NULL, 'TEXT', 'RETICULOCYTE_COUNT', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 1, NULL, NULL, '2024-04-20 04:40:06', '2024-05-01 10:04:39', NULL),
            (33, 'BLOOD GROUP (ABO)', NULL, NULL, 'TEXT', 'BLOOD_GROUP_(ABO)', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-04-29 11:06:38', NULL),
            (34, 'Rh (D) FACTOR', NULL, NULL, 'TEXT', 'RH_(D)_FACTOR', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-04-29 11:06:44', NULL),
            (35, 'TROP - T', NULL, '', 'TEXT', 'TROP_-_T', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'RANGE', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (36, 'SPUTUM 1st DAY RESULT', NULL, NULL, 'TEXT', 'SPUTUM_1ST_DAY_RESULT', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-05-06 11:48:40', NULL),
            (37, 'TSH', NULL, '', 'TEXT', 'TSH', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '0.25 to 5.0', 'RANGE', NULL, 0, 1, 44, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (38, 'S. ALBUMIN', NULL, '', 'TEXT', 'S._ALBUMIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '3.5 Ã¢â‚¬â€œ 5.2', 'RANGE', NULL, 0, 1, 20, 3, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (39, 'AST (SGOT)', NULL, '', 'TEXT', 'AST_(SGOT)', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, 'Male:- Upto 40 Female :- Upto 40', 'RANGE', NULL, 0, 1, 18, 35, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (40, 'BLOOD GLUCOSE (F)', NULL, NULL, 'TEXT', 'BLOOD_GLUCOSE_(F)', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, 'Normal : 70-110_x005F_x000D_Pre-Diabetes : 111-125_x005F_x000D_Diabetes : > 126', 'OPTIONS', NULL, 0, 1, 7, 19, NULL, '2024-04-20 04:40:06', '2024-05-06 07:23:49', NULL),
            (41, 'BLOOD GLUCOSE (PP)', NULL, '', 'TEXT', 'BLOOD_GLUCOSE_(PP)', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, 'Normal < 140_x005F_x000D_Pre diabetes 140-199_x005F_x000D_Diabetes >200', 'RANGE', NULL, 0, 1, 7, 19, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (42, 'BLOOD GLUCOSE (R)', NULL, '', 'TEXT', 'BLOOD_GLUCOSE_(R)', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, 'Upto 140', 'RANGE', NULL, 0, 1, 7, 19, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (43, 'UREA', NULL, '', 'TEXT', 'UREA', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '16711', 'RANGE', NULL, 0, 1, 7, 18, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (44, 'C-REACTIVE PROTIEN (CRP)', NULL, '', 'TEXT', 'C-REACTIVE_PROTIEN_(CRP)', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, 'up to 6.0', 'RANGE', NULL, 0, 1, 47, 39, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (45, 'CALCIUM', NULL, '', 'TEXT', 'CALCIUM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '2.20 - 2.70', 'RANGE', NULL, 0, 1, 11, 40, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (46, 'CHLORIDE (Cl-)', NULL, '', 'TEXT', 'CHLORIDE_(CL-)', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '98 - 106', 'RANGE', NULL, 0, 1, 11, 29, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (47, 'TOTAL CHOLESTEROL', NULL, NULL, 'TEXT', 'TOTAL_CHOLESTEROL', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, 'Up to 200', 'RANGE', NULL, 0, 1, 7, 8, NULL, '2024-04-20 04:40:06', '2024-04-26 09:46:20', NULL),
            (48, 'QUANTITY', NULL, '', 'TEXT', 'QUANTITY', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'OPTIONS', NULL, 0, 1, 53, 2, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (49, 'APPEARANCE', NULL, '', 'TEXT', 'APPEARANCE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'OPTIONS', NULL, 0, 1, 0, 2, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (50, 'COLOUR', NULL, '', 'TEXT', 'COLOUR', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'OPTIONS', NULL, 0, 1, 0, 2, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (51, 'SPECIFIC GRAVITY', NULL, '', 'TEXT', 'SPECIFIC_GRAVITY', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '1.001 - 1.030', 'RANGE', NULL, 0, 1, 0, 2, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (52, 'PROTEIN', NULL, '', 'TEXT', 'PROTEIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'OPTIONS', NULL, 0, 1, 0, 2, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (53, 'SUGAR', NULL, '', 'TEXT', 'SUGAR', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'OPTIONS', NULL, 0, 1, 0, 2, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (54, 'KETONEBODY', NULL, '', 'TEXT', 'KETONEBODY', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'OPTIONS', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (55, 'BILIRUBIN', NULL, '', 'TEXT', 'BILIRUBIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'OPTIONS', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (56, 'NITRITE', NULL, '', 'TEXT', 'NITRITE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'OPTIONS', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (57, 'LEUCOCYTE', NULL, '', 'TEXT', 'LEUCOCYTE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'OPTIONS', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (58, 'R.B.C.', NULL, '', 'TEXT', 'R.B.C.', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '0 - 2', 'OPTIONS', NULL, 0, 1, 28, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (59, 'EPITHELIAL CELLS', NULL, '', 'TEXT', 'EPITHELIAL_CELLS', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 28, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (60, 'CRYSTAL', NULL, '', 'TEXT', 'CRYSTAL', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'OPTIONS', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (61, 'CAST', NULL, '', 'TEXT', 'CAST', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'OPTIONS', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (62, 'ORGANISM', NULL, '', 'TEXT', 'ORGANISM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'OPTIONS', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (63, 'TETRAHYDROCANNABINOL DONE BY RAPID COMPETITIVE TEST', NULL, NULL, 'TEXT', 'TETRAHYDROCANNABINOL_DONE_BY_RAPID_COMPETITIVE_TEST', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-04-30 11:17:45', NULL),
            (64, 'AMPHETAMINE DONE BY RAPID COMPETITIVE TEST', NULL, NULL, 'TEXT', 'AMPHETAMINE_DONE_BY_RAPID_COMPETITIVE_TEST', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-04-30 11:17:55', NULL),
            (65, 'BARBITURATES DONE BY RAPID COMPETITIVE TEST', NULL, '', 'TEXT', 'BARBITURATES_DONE_BY_RAPID_COMPETITIVE_TEST', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (66, 'BENZODIAZEPINE DONE BY RAPID COMPETITIVE TEST', NULL, '', 'TEXT', 'BENZODIAZEPINE_DONE_BY_RAPID_COMPETITIVE_TEST', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (67, 'COCAINE DONE BY RAPID COMPETITIVE TEST', NULL, '', 'TEXT', 'COCAINE_DONE_BY_RAPID_COMPETITIVE_TEST', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (68, 'OPIATES DONE BY RAPID COMPETITIVE TEST', NULL, '', 'TEXT', 'OPIATES_DONE_BY_RAPID_COMPETITIVE_TEST', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (69, 'ALKALINE PHOSPHATASE', NULL, '', 'TEXT', 'ALKALINE_PHOSPHATASE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '{Children upto 15 years} - (180-1200)_x005F_x000D_Male - (80 - 306)_x005F_x000D_Female - (64 - 306)_x005F_x000D__x005F_x000D__x005F_x000D_', 'RANGE', NULL, 0, 1, 19, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (70, 'SR. BILIRUBIN (TOTAL)', NULL, '', 'TEXT', 'SR._BILIRUBIN_(TOTAL)', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '0.2 to 1.0', 'RANGE', NULL, 0, 1, 7, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (71, 'TOTAL PROTEIN', NULL, '', 'TEXT', 'TOTAL_PROTEIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '6.4 - 7.8', 'RANGE', NULL, 0, 1, 20, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (72, 'SR. BILLIRUBIN (TOTAL)', NULL, NULL, 'TEXT', 'SR._BILLIRUBIN_(TOTAL)', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, 'Neonates_x005F_x000D__x000D_ (premature) _x005F_x000D__x000D_ 1 d < 8.2 mg/dL _x005F_x000D__x000D_ 2d < 12 mg/dL _x005F_x000D__x000D_ 3Ã¢â‚¬â€œ5 d < 24 mg/dL _x005F_x000D__x000D_ > 4 w < 1.5 mg/dL _x005F_x000D__x000D_ Newborns (full term)_x005F_x000D__x00', 'RANGE', NULL, 0, 1, 7, 12, NULL, '2024-04-20 04:40:06', '2024-04-30 12:29:35', NULL),
            (73, 'TROPONIN-I', NULL, NULL, 'TEXT', 'TROPONIN-I', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-05-07 07:51:59', NULL),
            (74, 'PHOSPHATE', NULL, '', 'TEXT', 'PHOSPHATE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '2.5 - 5.0', 'RANGE', NULL, 0, 1, 7, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (75, 'SODIUM [Na+],', NULL, '', 'TEXT', 'SODIUM_[NA+],', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '135-145', 'TEXT', NULL, 0, 1, 11, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (76, 'POTASSIUM [K+],', NULL, NULL, 'TEXT', 'POTASSIUM_[K+],', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '3.5-5.5', 'RANGE', NULL, 0, 1, 11, NULL, NULL, '2024-04-20 04:40:06', '2024-05-03 10:01:15', NULL),
            (77, 'TRIGLYCERIDES', NULL, '', 'TEXT', 'TRIGLYCERIDES', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, 'Upto 160', 'RANGE', NULL, 0, 1, 7, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (78, 'TEST VALUE', NULL, '', 'TEXT', 'TEST_VALUE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '< 1 YEARS - 1.35 - 19.5_x000D_ _x005F_x000D__x000D_ 1 - 3 YEARS - 5.24 - 30.0_x000D_ _x005F_x000D__x000D_ 4 - 6 YEARS - 5.20 - 112.0_x000D_ _x005F_x000D__x000D_ 6 Ã¢â‚¬â€œ 9 YEARS - 13.12 - 142.0_x000D_ _x005F_x000D__x000D_ 10 Ã¢â‚¬â€œ 12 YEARS - 11.2 - 1', 'RANGE', NULL, 0, 1, 33, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (79, 'UREA', NULL, NULL, 'TEXT', 'UREA', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '14 - 40', 'RANGE', NULL, 0, 1, 7, NULL, NULL, '2024-04-20 04:40:06', '2024-04-30 06:07:21', NULL),
            (80, 'S. CREATININE', NULL, '', 'TEXT', 'S._CREATININE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, 'M : - 0.6 - 1.2 F : -0.5 - 1.1', 'RANGE', NULL, 0, 1, 7, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (81, 'URIC ACID', NULL, '', 'TEXT', 'URIC_ACID', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, 'M - 3.4 - 7.0 F - 2.5 - 6.0', 'RANGE', NULL, 0, 1, 7, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (82, 'LIPASE', NULL, '', 'TEXT', 'LIPASE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, 'Upto 60', 'RANGE', NULL, 0, 1, 50, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (83, 'AMYLASE', NULL, '', 'TEXT', 'AMYLASE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, 'Up to 90', 'RANGE', NULL, 0, 1, 50, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (84, 'PHOSPHORUS', NULL, '', 'TEXT', 'PHOSPHORUS', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, 'Adults-2.5- 5.0 Children- 4.0- 6.5', 'RANGE', NULL, 0, 1, 7, 58, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (85, 'MAGNESIUM (Mg+)', NULL, NULL, 'TEXT', 'MAGNESIUM_(MG+)', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, 'New born(02 -04days):1.5 - 2.2_x005F_x000D__x000D_ 05months-06Years:1.7 - 2.3_x005F_x000D__x000D_ 06 - 12Years:1.7 - 2.1_x005F_x000D__x000D_ >12Years:1.6 - 2.6_x005F_x000D__x000D_', 'RANGE', NULL, 0, 1, 7, 61, NULL, '2024-04-20 04:40:06', '2024-05-01 07:15:22', NULL),
            (86, 'POTASSIUM (K+)', NULL, '', 'TEXT', 'POTASSIUM_(K+)', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '3.5 - 5.5', 'RANGE', NULL, 0, 1, 43, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (87, 'SODIUM (Na+)', NULL, '', 'TEXT', 'SODIUM_(NA+)', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '135-145', 'RANGE', NULL, 0, 1, 43, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (88, 'CPK (CREATINE KINASE)', NULL, '', 'TEXT', 'CPK_(CREATINE_KINASE)', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, 'M Ã¢â‚¬â€œ 24 to 195 F Ã¢â‚¬â€œ 24 to 170', 'TEXT', NULL, 0, 1, 50, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (89, 'CPK-MB', NULL, '', 'TEXT', 'CPK-MB', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '0 - 24', 'RANGE', NULL, 0, 1, 50, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (90, 'URIC ACID', NULL, NULL, 'TEXT', 'URIC_ACID', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, 'Male : 3.5 - 7.2 _x005F_x000D_Female: 2.6 - 6.0', 'RANGE', NULL, 0, 1, 7, NULL, NULL, '2024-04-20 04:40:06', '2024-05-01 11:17:08', NULL),
            (91, 'S. CREATININE', NULL, NULL, 'TEXT', 'S._CREATININE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, 'Male:0.6- 1.2 _x005F_x000D_Female: 0.5- 1.1', 'RANGE', NULL, 0, 1, 7, 38, NULL, '2024-04-20 04:40:06', '2024-05-01 10:35:20', NULL),
            (92, 'Microbiology Chart Report', NULL, NULL, 'TEXT', 'MICROBIOLOGY_CHART_REPORT', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-05-01 10:52:06', NULL),
            (93, 'Sample', NULL, NULL, 'TEXT', 'SAMPLE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-05-07 06:04:49', NULL),
            (94, 'Quantity', NULL, NULL, 'TEXT', 'QUANTITY', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-05-07 06:12:07', NULL),
            (95, 'Appearance', NULL, NULL, 'TEXT', 'APPEARANCE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-05-07 06:17:29', NULL),
            (96, 'Wet mount(normal saline) preparation', NULL, NULL, 'TEXT', 'WET_MOUNT(NORMAL_SALINE)_PREPARATION', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-05-07 06:24:58', NULL),
            (97, 'Selected organism', NULL, NULL, 'TEXT', 'SELECTED_ORGANISM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-05-07 06:27:50', NULL),
            (98, 'Colony count', NULL, NULL, 'TEXT', 'COLONY_COUNT', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-05-07 06:32:45', NULL),
            (99, 'Antimicrobial Susceptibility Information of isolated organism', NULL, NULL, 'TEXT', 'ANTIMICROBIAL_SUSCEPTIBILITY_INFORMATION_OF_ISOLATED_ORGANISM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-05-01 10:53:27', NULL),
            (100, 'Drugs', NULL, NULL, 'TEXT', 'DRUGS', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-05-01 10:53:39', NULL),
            (101, 'Meropenem', NULL, NULL, 'TEXT', 'MEROPENEM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-05-07 06:43:01', NULL),
            (102, 'Amikacin', NULL, NULL, 'TEXT', 'AMIKACIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-05-07 06:46:47', NULL),
            (103, 'Levofloxacin', NULL, NULL, 'TEXT', 'LEVOFLOXACIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-05-07 06:48:17', NULL),
            (104, 'Ceftriaxone', NULL, NULL, 'TEXT', 'CEFTRIAXONE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-05-07 06:49:25', NULL),
            (105, 'Amoxy-clav', NULL, NULL, 'TEXT', 'AMOXY-CLAV', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-05-01 10:54:30', NULL),
            (106, 'Piperacillin-Tazobactum', NULL, NULL, 'TEXT', 'PIPERACILLIN-TAZOBACTUM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-05-07 06:52:03', NULL),
            (107, 'Co-trimoxazole', NULL, NULL, 'TEXT', 'CO-TRIMOXAZOLE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-05-07 06:54:54', NULL),
            (108, 'Cefixime', NULL, NULL, 'TEXT', 'CEFIXIME', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-05-07 06:57:02', NULL),
            (109, 'Microbiology Chart report', NULL, NULL, 'TEXT', 'MICROBIOLOGY_CHART_REPORT', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-04-27 09:01:05', NULL),
            (110, 'Sample', NULL, NULL, 'TEXT', 'SAMPLE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-05-06 10:34:36', NULL),
            (111, 'Grama\'s stain', NULL, NULL, 'TEXT', 'GRAMA\'S_STAIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-05-06 10:35:50', NULL),
            (112, 'Selected organism', NULL, NULL, 'TEXT', 'SELECTED_ORGANISM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-05-06 10:36:54', NULL),
            (113, 'Antimicrobial Susceptibility Information of isolated organism', NULL, NULL, 'TEXT', 'ANTIMICROBIAL_SUSCEPTIBILITY_INFORMATION_OF_ISOLATED_ORGANISM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-04-27 09:01:56', NULL),
            (114, 'Drugs', NULL, NULL, 'TEXT', 'DRUGS', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-04-27 09:02:04', NULL),
            (115, 'Meropenem', NULL, NULL, 'TEXT', 'MEROPENEM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-05-06 10:38:58', NULL),
            (116, 'Amikacin', NULL, NULL, 'TEXT', 'AMIKACIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-05-06 10:40:20', NULL),
            (117, 'Levofloxacin', NULL, NULL, 'TEXT', 'LEVOFLOXACIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-05-06 10:42:42', NULL),
            (118, 'Co-trimoxazole', NULL, NULL, 'TEXT', 'CO-TRIMOXAZOLE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-05-06 10:44:17', NULL),
            (119, 'Amoxy-clav', NULL, NULL, 'TEXT', 'AMOXY-CLAV', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-05-06 10:45:48', NULL),
            (120, 'Piperacillin-Tazobactum', NULL, NULL, 'TEXT', 'PIPERACILLIN-TAZOBACTUM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-05-06 10:48:16', NULL),
            (121, 'Cefixime', NULL, NULL, 'TEXT', 'CEFIXIME', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-05-06 10:50:10', NULL),
            (122, 'Ceftriaxone', NULL, NULL, 'TEXT', 'CEFTRIAXONE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-05-06 10:52:07', NULL),
            (123, 'Ofloxacin', NULL, NULL, 'TEXT', 'OFLOXACIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-05-06 10:53:30', NULL),
            (124, 'Linezolid', NULL, NULL, 'TEXT', 'LINEZOLID', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-05-06 10:54:51', NULL),
            (125, 'Vancomycin', NULL, NULL, 'TEXT', 'VANCOMYCIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-05-06 10:55:24', NULL),
            (126, 'GENTAMICIN', NULL, NULL, 'TEXT', 'GENTAMICIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-05-06 10:55:55', NULL),
            (127, 'Microbiology Chart Report Sample', NULL, '', 'TEXT', 'MICROBIOLOGY_CHART_REPORT_SAMPLE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (128, 'Quantity', NULL, '', 'TEXT', 'QUANTITY', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (129, 'Appearance', NULL, '', 'TEXT', 'APPEARANCE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (130, 'Selected organism', NULL, '', 'TEXT', 'SELECTED_ORGANISM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (131, 'Antimicrobial Susceptibility Information of isolated organism', NULL, '', 'TEXT', 'ANTIMICROBIAL_SUSCEPTIBILITY_INFORMATION_OF_ISOLATED_ORGANISM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (132, 'Drugs Meropenem', NULL, '', 'TEXT', 'DRUGS_MEROPENEM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (133, 'Amikacin', NULL, '', 'TEXT', 'AMIKACIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (134, 'Levofloxacin', NULL, '', 'TEXT', 'LEVOFLOXACIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (135, 'Co-trimoxazole', NULL, '', 'TEXT', 'CO-TRIMOXAZOLE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (136, 'Amoxy-clav', NULL, '', 'TEXT', 'AMOXY-CLAV', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (137, 'Piperacillin-Tazobactum', NULL, '', 'TEXT', 'PIPERACILLIN-TAZOBACTUM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (138, 'Cefixime', NULL, '', 'TEXT', 'CEFIXIME', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (139, 'Ceftriaxone', NULL, '', 'TEXT', 'CEFTRIAXONE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (140, 'VANCOMYCIN', NULL, '', 'TEXT', 'VANCOMYCIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (141, 'LINEZOLIT', NULL, '', 'TEXT', 'LINEZOLIT', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'OPTIONS', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (142, 'PENICILLIN G', NULL, '', 'TEXT', 'PENICILLIN_G', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'OPTIONS', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (143, 'Microbiology Chart report', NULL, '', 'TEXT', 'MICROBIOLOGY_CHART_REPORT', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (144, 'Sample', NULL, NULL, 'TEXT', 'SAMPLE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:06', '2024-05-06 11:54:27', NULL),
            (145, 'Quantity', NULL, NULL, 'TEXT', 'QUANTITY', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:06', '2024-05-06 11:55:51', NULL),
            (146, 'Appearance', NULL, NULL, 'TEXT', 'APPEARANCE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:06', '2024-05-06 11:58:47', NULL),
            (147, 'GramÃ¢â‚¬â„¢s stain', NULL, NULL, 'TEXT', 'GRAMÃ¢â‚¬â„¢S_STAIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:06', '2024-05-06 11:59:57', NULL),
            (148, 'Selected organism', NULL, NULL, 'TEXT', 'SELECTED_ORGANISM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:06', '2024-05-06 12:01:11', NULL),
            (149, 'Antimicrobial Susceptibility Information of isolated organism', NULL, '', 'TEXT', 'ANTIMICROBIAL_SUSCEPTIBILITY_INFORMATION_OF_ISOLATED_ORGANISM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (150, 'Drugs', NULL, '', 'TEXT', 'DRUGS', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (151, 'Meropenem', NULL, NULL, 'TEXT', 'MEROPENEM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:06', '2024-05-06 12:03:01', NULL),
            (152, 'Amikacin', NULL, NULL, 'TEXT', 'AMIKACIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:06', '2024-05-06 12:04:13', NULL),
            (153, 'Levofloxacin', NULL, NULL, 'TEXT', 'LEVOFLOXACIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:06', '2024-05-06 12:05:46', NULL);");

      \DB::statement("
            INSERT INTO `test_items` (`id`, `name`, `short_name`, `formula_code`, `input_type`, `code`, `item_type`, `test_number`, `default_result`, `result_source`, `result_guide`, `reference_value`, `reference_value_type`, `details`, `is_read_only`, `status`, `primary_unit_id`, `test_method_id`, `machine_id`, `created_at`, `updated_at`, `deleted_at`) VALUES 
            (154, 'Co-trimoxazole', NULL, NULL, 'TEXT', 'CO-TRIMOXAZOLE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:06', '2024-05-06 12:06:47', NULL),
            (155, 'Amoxy-clav', NULL, NULL, 'TEXT', 'AMOXY-CLAV', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:06', '2024-05-06 12:08:21', NULL),
            (156, 'Piperacillin-Tazobactum', NULL, NULL, 'TEXT', 'PIPERACILLIN-TAZOBACTUM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:06', '2024-05-06 12:10:49', NULL),
            (157, 'Cefixime', NULL, NULL, 'TEXT', 'CEFIXIME', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:06', '2024-05-06 12:14:08', NULL),
            (158, 'Ceftriaxone', NULL, NULL, 'TEXT', 'CEFTRIAXONE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:06', '2024-05-06 12:15:07', NULL),
            (159, 'Ofloxacin', NULL, NULL, 'TEXT', 'OFLOXACIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:06', '2024-05-06 12:16:13', NULL),
            (160, 'Gantamicin', NULL, NULL, 'TEXT', 'GANTAMICIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:06', '2024-05-06 12:17:20', NULL),
            (161, 'GENTAMICIN', NULL, NULL, 'TEXT', 'GENTAMICIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:06', '2024-05-06 12:18:32', NULL),
            (162, 'Linezolid', NULL, '', 'TEXT', 'LINEZOLID', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (163, 'Vancomycin', NULL, '', 'TEXT', 'VANCOMYCIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (164, 'Penicillin- G', NULL, '', 'TEXT', 'PENICILLIN-_G', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (165, 'SPUTUM RE', NULL, '', 'TEXT', 'SPUTUM_RE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (166, 'AURAL SWAB CST', NULL, '', 'TEXT', 'AURAL_SWAB_CST', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (167, 'Microbiology Chart report', NULL, '', 'TEXT', 'MICROBIOLOGY_CHART_REPORT', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (168, 'Sample', NULL, '', 'TEXT', 'SAMPLE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (169, 'GramÃ¢â‚¬â„¢s stain', NULL, '', 'TEXT', 'GRAMÃ¢â‚¬â„¢S_STAIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (170, 'Selected organism', NULL, '', 'TEXT', 'SELECTED_ORGANISM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (171, 'Antimicrobial Susceptibility Information of isolated organism', NULL, '', 'TEXT', 'ANTIMICROBIAL_SUSCEPTIBILITY_INFORMATION_OF_ISOLATED_ORGANISM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (172, 'Drugs', NULL, '', 'TEXT', 'DRUGS', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (173, 'Meropenem', NULL, '', 'TEXT', 'MEROPENEM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (174, 'Amikacin', NULL, '', 'TEXT', 'AMIKACIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (175, 'Levofloxacin', NULL, '', 'TEXT', 'LEVOFLOXACIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (176, 'Co-trimoxazole', NULL, '', 'TEXT', 'CO-TRIMOXAZOLE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (177, 'Amoxy-clav', NULL, '', 'TEXT', 'AMOXY-CLAV', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (178, 'Piperacillin-Tazobactum', NULL, '', 'TEXT', 'PIPERACILLIN-TAZOBACTUM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (179, 'Cefixime', NULL, '', 'TEXT', 'CEFIXIME', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (180, 'Ofloxacin', NULL, '', 'TEXT', 'OFLOXACIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (181, 'Nitrofurantoin', NULL, '', 'TEXT', 'NITROFURANTOIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'OPTIONS', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (182, 'Piperacillin Ã¢â‚¬â€œTazobactum', NULL, '', 'TEXT', 'PIPERACILLIN_Ã¢â‚¬â€œTAZOBACTUM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (183, 'Cefpodoxime', NULL, '', 'TEXT', 'CEFPODOXIME', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (184, 'Linazolid', NULL, '', 'TEXT', 'LINAZOLID', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (185, 'Vancomycin', NULL, '', 'TEXT', 'VANCOMYCIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (186, 'Ceftriazone', NULL, '', 'TEXT', 'CEFTRIAZONE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (187, 'AURAL SWAB CST', NULL, '', 'TEXT', 'AURAL_SWAB_CST', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (188, 'Microbiology Chart report', NULL, '', 'TEXT', 'MICROBIOLOGY_CHART_REPORT', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (189, 'Sample', NULL, '', 'TEXT', 'SAMPLE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (190, 'GramÃ¢â‚¬â„¢s stain', NULL, '', 'TEXT', 'GRAMÃ¢â‚¬â„¢S_STAIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (191, 'Selected organism', NULL, '', 'TEXT', 'SELECTED_ORGANISM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (192, 'Antimicrobial Susceptibility Information of isolated organism', NULL, '', 'TEXT', 'ANTIMICROBIAL_SUSCEPTIBILITY_INFORMATION_OF_ISOLATED_ORGANISM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (193, 'Drugs', NULL, '', 'TEXT', 'DRUGS', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (194, 'Meropenem', NULL, '', 'TEXT', 'MEROPENEM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (195, 'Amikacin', NULL, '', 'TEXT', 'AMIKACIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (196, 'Levofloxacin', NULL, '', 'TEXT', 'LEVOFLOXACIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (197, 'Co-trimoxazole', NULL, '', 'TEXT', 'CO-TRIMOXAZOLE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (198, 'Amoxy-clav', NULL, '', 'TEXT', 'AMOXY-CLAV', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (199, 'Piperacillin-Tazobactum', NULL, '', 'TEXT', 'PIPERACILLIN-TAZOBACTUM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (200, 'Cefixime', NULL, '', 'TEXT', 'CEFIXIME', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (201, 'Ofloxacin', NULL, '', 'TEXT', 'OFLOXACIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (202, 'Nitrofurantoin', NULL, '', 'TEXT', 'NITROFURANTOIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (203, 'Piperacillin Ã¢â‚¬â€œTazobactum', NULL, '', 'TEXT', 'PIPERACILLIN_Ã¢â‚¬â€œTAZOBACTUM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (204, 'Cefpodoxime', NULL, '', 'TEXT', 'CEFPODOXIME', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (205, 'Linazolid', NULL, '', 'TEXT', 'LINAZOLID', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (206, 'Vancomycin', NULL, '', 'TEXT', 'VANCOMYCIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (207, 'Ceftriazone', NULL, '', 'TEXT', 'CEFTRIAZONE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (208, 'POTASSIUM (K+)', NULL, NULL, 'TEXT', 'POTASSIUM_(K+)', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '3.5 - 5.0', 'RANGE', NULL, 0, 1, 43, 30, NULL, '2024-04-20 04:40:06', '2024-04-27 08:01:08', NULL),
            (209, 'CALCIUM (Ca+ +)', NULL, '', 'TEXT', 'CALCIUM_(CA+_+)', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '8.7-11.0', 'RANGE', NULL, 0, 1, 7, 40, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (210, 'CHLORIDE (Cl)', NULL, '', 'TEXT', 'CHLORIDE_(CL)', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '98 Ã¢â‚¬â€œ 106', 'RANGE', NULL, 0, 1, 43, 30, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (211, 'MAGNASIUM(Mg+)', NULL, '', 'TEXT', 'MAGNASIUM(MG+)', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, 'Up to 2.6', 'RANGE', NULL, 0, 1, 7, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (212, 'PHOSPHORUS', NULL, NULL, 'TEXT', 'PHOSPHORUS', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, 'Adults-2.5- 5.0 Children- 4.0- 6.5', 'RANGE', NULL, 0, 1, 7, NULL, NULL, '2024-04-20 04:40:06', '2024-04-27 08:01:18', NULL),
            (213, 'SODIUM [Na+],', NULL, NULL, 'TEXT', 'SODIUM_[NA+],', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '135-145', 'RANGE', NULL, 0, 1, 43, 30, NULL, '2024-04-20 04:40:06', '2024-04-27 08:01:29', NULL),
            (214, 'HBSAG', NULL, NULL, 'TEXT', 'HBSAG', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, 26, NULL, '2024-04-20 04:40:06', '2024-05-06 09:48:26', NULL),
            (215, 'RANDOM URINE MICRO ALBUMIN', NULL, '', 'TEXT', 'RANDOM_URINE_MICRO_ALBUMIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, 'URINE- 0 - 25', 'RANGE', NULL, 0, 1, 47, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (216, 'CREATININE, URINE', NULL, '', 'TEXT', 'CREATININE,_URINE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, 'UNDEFINED', 'TEXT', NULL, 0, 1, 7, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (217, 'ALBUMIN/CREATININE RATIO', NULL, '', 'TEXT', 'ALBUMIN/CREATININE_RATIO', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, 'Normal < 30.0_x005F_x000D__x000D_ Microalbuminuria 30.0 - 299.0_x005F_x000D__x000D_ Clinical Albuminuria =or>300.0', 'RANGE', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (218, 'NAIL CLIPING FOR FUNGAL ELEMENTS BY 20 % KOH WET MOUNT', NULL, NULL, 'TEXT', 'NAIL_CLIPING_FOR_FUNGAL_ELEMENTS_BY_20_%_KOH_WET_MOUNT', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-05-01 07:36:52', NULL),
            (219, 'Sample Taken On Fasting :', NULL, '', 'TEXT', 'SAMPLE_TAKEN_ON_FASTING_:', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '<92', 'RANGE', NULL, 0, 1, 7, 20, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (220, 'Sample Taken after 60 minutes :', NULL, '', 'TEXT', 'SAMPLE_TAKEN_AFTER_60_MINUTES_:', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '<180', 'RANGE', NULL, 0, 1, 7, 20, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (221, 'Sample Taken after 120 minutes :', NULL, '', 'TEXT', 'SAMPLE_TAKEN_AFTER_120_MINUTES_:', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '<153', 'RANGE', NULL, 0, 1, 7, 20, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL);");

      \DB::statement("
            INSERT INTO `test_items` (`id`, `name`, `short_name`, `formula_code`, `input_type`, `code`, `item_type`, `test_number`, `default_result`, `result_source`, `result_guide`, `reference_value`, `reference_value_type`, `details`, `is_read_only`, `status`, `primary_unit_id`, `test_method_id`, `machine_id`, `created_at`, `updated_at`, `deleted_at`) VALUES 
            (222, 'PERIPHERAL BOLLD SMEAR', NULL, NULL, 'TEXT', 'PERIPHERAL__BOLLD__SMEAR_RBC', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-05-01 09:09:46', NULL),
            (223, 'WBC', NULL, NULL, 'TEXT', 'WBC', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-05-01 09:09:08', NULL),
            (224, 'PLATELETS', NULL, NULL, 'TEXT', 'PLATELETS', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-05-01 09:09:15', NULL),
            (225, 'BLOOD UREA', NULL, '', 'TEXT', 'BLOOD_UREA', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '14 Ã¢â‚¬â€œ 40', 'RANGE', NULL, 0, 1, 7, 17, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (226, 'S. CREATININE', NULL, NULL, 'TEXT', 'S._CREATININE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, 'M : -0.6 Ã¢â‚¬â€œ 1.2 F : -0.5 Ã¢â‚¬â€œ 1.1', 'RANGE', NULL, 0, 1, 7, 5, NULL, '2024-04-20 04:40:06', '2024-05-03 08:18:24', NULL),
            (227, 'URIC ACID', NULL, NULL, 'TEXT', 'URIC_ACID', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, 'M - 3.4 Ã¢â‚¬â€œ 7.0 F Ã¢â‚¬â€œ 2.5 Ã¢â‚¬â€œ 6.0', 'RANGE', NULL, 0, 1, 7, 56, NULL, '2024-04-20 04:40:06', '2024-05-03 08:09:47', NULL),
            (228, 'CHLORIDE', NULL, '', 'TEXT', 'CHLORIDE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '98 Ã¢â‚¬â€œ 106', 'RANGE', NULL, 0, 1, 11, 52, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (229, 'SKIN SCRAPING FOR FUNGAL ELEMENTS BY 10 % KOH WET MOUNT', NULL, NULL, 'TEXT', 'SKIN_SCRAPING_FOR_FUNGAL_ELEMENTS_BY_10_%_KOH_WET_MOUNT', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-05-01 10:38:25', NULL),
            (230, 'SPUTUM GRAMSTAIN', NULL, NULL, 'TEXT', 'SPUTUM_GRAMSTAIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:06', '2024-05-01 10:48:17', NULL),
            (231, 'PHYSICAL EXAMINATION', NULL, NULL, 'TEXT', 'PHYSICAL_EXAMINATION_COLOR', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:06', '2024-05-01 11:00:44', NULL),
            (232, 'CONSISTENCY', NULL, NULL, 'TEXT', 'CONSISTENCY', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:06', '2024-05-01 10:57:48', NULL),
            (233, 'MUCUS', NULL, NULL, 'TEXT', 'MUCUS', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:06', '2024-05-01 10:57:55', NULL),
            (234, 'CHEMICAL EXAMINATION REACTION', NULL, NULL, 'TEXT', 'CHEMICAL_EXAMINATION_REACTION', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:06', '2024-05-07 07:38:47', NULL),
            (235, 'pH', NULL, NULL, 'TEXT', 'PH', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:06', '2024-05-01 10:58:20', NULL),
            (236, 'MICROSCOPICAL EXAMINATION PUS CELLS', NULL, NULL, 'TEXT', 'MICROSCOPICAL_EXAMINATION_PUS_CELLS', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '/ HPF', 'RANGE', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:06', '2024-05-01 10:58:45', NULL),
            (237, 'R.B.C.', NULL, NULL, 'TEXT', 'R.B.C.', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '/HPF', 'RANGE', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:06', '2024-05-01 10:58:59', NULL),
            (238, 'OVA', NULL, NULL, 'TEXT', 'OVA', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:06', '2024-05-01 10:59:09', NULL),
            (239, 'CYST', NULL, NULL, 'TEXT', 'CYST', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:06', '2024-05-01 10:59:20', NULL),
            (240, 'WORM', NULL, NULL, 'TEXT', 'WORM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:06', '2024-05-01 10:59:40', NULL),
            (241, 'VEGETABLE CELLS', NULL, NULL, 'TEXT', 'VEGETABLE_CELLS', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 40, NULL, NULL, '2024-04-20 04:40:06', '2024-05-07 07:41:33', NULL),
            (242, 'STARCH', NULL, NULL, 'TEXT', 'STARCH', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:06', '2024-05-01 11:00:02', NULL),
            (243, 'BACTERIA FLORA', NULL, NULL, 'TEXT', 'BACTERIA_FLORA', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:06', '2024-05-07 07:43:01', NULL);");

      \DB::statement("
            INSERT INTO `test_items` (`id`, `name`, `short_name`, `formula_code`, `input_type`, `code`, `item_type`, `test_number`, `default_result`, `result_source`, `result_guide`, `reference_value`, `reference_value_type`, `details`, `is_read_only`, `status`, `primary_unit_id`, `test_method_id`, `machine_id`, `created_at`, `updated_at`, `deleted_at`) VALUES
            (244, 'OTHERS', NULL, NULL, 'TEXT', 'OTHERS', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:06', '2024-05-01 11:00:27', NULL),
            (245, 'Stool Reducing Sugar', NULL, '', 'TEXT', 'STOOL_REDUCING_SUGAR', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (246, 'PHYSICAL EXAMINATION COLOUR', NULL, NULL, 'TEXT', 'PHYSICAL_EXAMINATION_COLOUR', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:06', '2024-05-01 11:18:47', NULL),
            (247, 'TRANSPARENCY', NULL, NULL, 'TEXT', 'TRANSPARENCY', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:06', '2024-05-01 11:18:54', NULL),
            (248, 'ODOUR', NULL, NULL, 'TEXT', 'ODOUR', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:06', '2024-05-01 11:19:01', NULL),
            (249, 'SEDIMENT', NULL, NULL, 'TEXT', 'SEDIMENT', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:06', '2024-05-01 11:19:11', NULL),
            (250, 'CHEMICAL EXAMINATION REACTION', NULL, NULL, 'TEXT', 'CHEMICAL_EXAMINATION_REACTION', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:06', '2024-05-01 11:19:18', NULL),
            (251, 'ALBUMIN', NULL, '', 'TEXT', 'ALBUMIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'RANGE', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:06', '2024-04-20 04:40:06', NULL),
            (252, 'SUGAR', NULL, NULL, 'TEXT', 'SUGAR', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:06', '2024-05-01 11:19:25', NULL),
            (253, 'BILE SALT', NULL, NULL, 'TEXT', 'BILE_SALT', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 11:19:37', NULL),
            (254, 'BILE PIGMENT', NULL, NULL, 'TEXT', 'BILE_PIGMENT', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 11:19:52', NULL),
            (255, 'ACETONE', NULL, NULL, 'TEXT', 'ACETONE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 11:20:14', NULL),
            (256, 'UROBILINOGEN', NULL, NULL, 'TEXT', 'UROBILINOGEN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 11:20:22', NULL),
            (257, 'MICROSCOPICAL EXAMINATION PUS CELL', NULL, NULL, 'TEXT', 'MICROSCOPICAL_EXAMINATION_PUS_CELL', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '/ HPF', 'RANGE', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 11:20:31', NULL);");

      \DB::statement("
            INSERT INTO `test_items` (`id`, `name`, `short_name`, `formula_code`, `input_type`, `code`, `item_type`, `test_number`, `default_result`, `result_source`, `result_guide`, `reference_value`, `reference_value_type`, `details`, `is_read_only`, `status`, `primary_unit_id`, `test_method_id`, `machine_id`, `created_at`, `updated_at`, `deleted_at`) VALUES 
            (258, 'EPITHELIAL CELLS', NULL, NULL, 'TEXT', 'EPITHELIAL_CELLS', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '/ HPF', 'RANGE', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 11:20:53', NULL),
            (259, 'R.B.C.', NULL, NULL, 'TEXT', 'R.B.C.', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 11:21:01', NULL),
            (260, 'CRYSTAL', NULL, NULL, 'TEXT', 'CRYSTAL', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 11:21:08', NULL),
            (261, 'CAST', NULL, NULL, 'TEXT', 'CAST', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 11:21:15', NULL),
            (262, 'BACTERIA FLORA', NULL, NULL, 'TEXT', 'BACTERIA_FLORA', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 11:22:38', NULL),
            (263, 'OTHERS', NULL, NULL, 'TEXT', 'OTHERS', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 11:22:48', NULL),
            (264, 'URINE ACETONE', NULL, NULL, 'TEXT', 'URINE_ACETONE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, 57, NULL, '2024-04-20 04:40:07', '2024-05-01 11:23:29', NULL),
            (265, 'URINE FOR PROTEIN', NULL, NULL, 'TEXT', 'URINE_FOR_PROTEIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 11:28:35', NULL),
            (266, 'SPUTUM ROUTINE EXAMINATION', NULL, NULL, 'TEXT', 'SPUTUM_ROUTINE_EXAMINATION', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 10:49:02', NULL),
            (267, 'URINE ALBUMINE', NULL, NULL, 'TEXT', 'URINE_ALBUMINE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-04-29 08:08:54', NULL),
            (268, 'SPECIFIC GRAVITY', NULL, NULL, 'TEXT', 'SPECIFIC_GRAVITY', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '1.002 - 1.025', 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 10:45:58', NULL),
            (269, 'GRAM STAIN OF URETHRAL DISCHARGE', NULL, NULL, 'TEXT', 'GRAM_STAIN_OF_URETHRAL_DISCHARGE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 11:15:46', NULL),
            (270, 'URINE BENCE JONES PROTIEN', NULL, '', 'TEXT', 'URINE_BENCE_JONES_PROTIEN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (271, 'Urine For Pregnancy Test', NULL, NULL, 'TEXT', 'URINE_FOR_PREGNANCY_TEST', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-07 08:11:26', NULL),
            (272, 'CST REPORT', NULL, '', 'TEXT', 'CST_REPORT', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (273, 'NS1 Antigen :', NULL, NULL, 'TEXT', 'NS1_ANTIGEN_:', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-04 11:59:32', NULL),
            (274, 'ANTI HCV', NULL, NULL, 'TEXT', 'ANTI_HCV', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, 26, NULL, '2024-04-20 04:40:07', '2024-05-06 09:51:22', NULL),
            (275, 'HIV I & II', NULL, NULL, 'TEXT', 'HIV_I_&_II', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, 26, NULL, '2024-04-20 04:40:07', '2024-04-30 12:01:57', NULL),
            (276, 'ZONE OF INDURATION', NULL, NULL, 'TEXT', 'ZONE_OF_INDURATION', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 07:53:11', NULL),
            (277, 'REPORTING TIME', NULL, NULL, 'TEXT', 'REPORTING_TIME', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 07:52:54', NULL),
            (278, 'MANTOUX GIVEN DATE', NULL, NULL, 'TEXT', 'MANTOUX_GIVEN_DATE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 07:49:33', NULL),
            (279, 'SPECIMEN SOURCE', NULL, '', 'TEXT', 'SPECIMEN_SOURCE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (280, 'EPITHELIAL CELLS', NULL, '', 'TEXT', 'EPITHELIAL_CELLS', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (281, 'POLYMORPHO NUCLEAR LEUKOCYTES', NULL, '', 'TEXT', 'POLYMORPHO_NUCLEAR_LEUKOCYTES', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (282, 'MACROPHAGES', NULL, '', 'TEXT', 'MACROPHAGES', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (283, 'GRAM`S STAIN', NULL, '', 'TEXT', 'GRAM`S_STAIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (284, 'SPOREBEARING BACILLI', NULL, '', 'TEXT', 'SPOREBEARING_BACILLI', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (285, 'ACIDFAST BACILLI', NULL, '', 'TEXT', 'ACIDFAST_BACILLI', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (286, 'FUNGAL ELEMENTS', NULL, '', 'TEXT', 'FUNGAL_ELEMENTS', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (287, 'CULTURE', NULL, '', 'TEXT', 'CULTURE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (288, 'ORGANISM', NULL, '', 'TEXT', 'ORGANISM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (289, 'ORGANISM 2', NULL, '', 'TEXT', 'ORGANISM_2', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (290, 'REMARKS', NULL, '', 'TEXT', 'REMARKS', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'RANGE', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (291, 'COTRIMOXAZOLE', NULL, '', 'TEXT', 'COTRIMOXAZOLE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (292, 'AMPICILLIN', NULL, '', 'TEXT', 'AMPICILLIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'OPTIONS', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (293, 'CEFUROXIME', NULL, '', 'TEXT', 'CEFUROXIME', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'OPTIONS', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (294, 'NALIDIXIC ACID', NULL, '', 'TEXT', 'NALIDIXIC_ACID', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (295, 'NORFLOXACIN', NULL, '', 'TEXT', 'NORFLOXACIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (296, 'CIPROFLOXACIN', NULL, '', 'TEXT', 'CIPROFLOXACIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'OPTIONS', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (297, 'NITROFURANTOIN', NULL, '', 'TEXT', 'NITROFURANTOIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (298, 'GENTAMICIN', NULL, '', 'TEXT', 'GENTAMICIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (299, 'AMOXY/CLAV', NULL, '', 'TEXT', 'AMOXY/CLAV', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (300, 'AMPICILLINSULBACTAM', NULL, '', 'TEXT', 'AMPICILLINSULBACTAM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (301, 'CEPHALOTHIN', NULL, '', 'TEXT', 'CEPHALOTHIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (302, 'TETRACYCLINE', NULL, '', 'TEXT', 'TETRACYCLINE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (303, 'DOXYCYCLINE', NULL, '', 'TEXT', 'DOXYCYCLINE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (304, 'OFLOXACIN', NULL, '', 'TEXT', 'OFLOXACIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (305, 'CEPHALEXIN', NULL, '', 'TEXT', 'CEPHALEXIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (306, 'PIPERACILLIN', NULL, '', 'TEXT', 'PIPERACILLIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (307, 'TICARCILLIN', NULL, '', 'TEXT', 'TICARCILLIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (308, 'CEFAZOLIN', NULL, '', 'TEXT', 'CEFAZOLIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (309, 'CEFTRIAXONE', NULL, '', 'TEXT', 'CEFTRIAXONE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (310, 'CEFTAZIDIME', NULL, '', 'TEXT', 'CEFTAZIDIME', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'OPTIONS', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (311, 'CEFOTAXIME', NULL, '', 'TEXT', 'CEFOTAXIME', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (312, 'VANCOMYCIN', NULL, '', 'TEXT', 'VANCOMYCIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (313, 'LEVOFLOXACIN', NULL, '', 'TEXT', 'LEVOFLOXACIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (314, 'NETILMICIN', NULL, '', 'TEXT', 'NETILMICIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (315, 'AMIKACIN', NULL, '', 'TEXT', 'AMIKACIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (316, 'PIPERACILLIN/TAZOBACTUM', NULL, '', 'TEXT', 'PIPERACILLIN/TAZOBACTUM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (317, 'CEFOPERAZONE/SULBACTUM', NULL, '', 'TEXT', 'CEFOPERAZONE/SULBACTUM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (318, 'CEFPODOXIME', NULL, '', 'TEXT', 'CEFPODOXIME', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (319, 'CEFOPERAZONE', NULL, '', 'TEXT', 'CEFOPERAZONE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (320, 'CEFTIZOXIME', NULL, '', 'TEXT', 'CEFTIZOXIME', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (321, 'CEFOXITIN', NULL, '', 'TEXT', 'CEFOXITIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (322, 'CEFOTETAN', NULL, '', 'TEXT', 'CEFOTETAN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (323, 'CEFEPIME', NULL, '', 'TEXT', 'CEFEPIME', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (324, 'CEFPIROME', NULL, '', 'TEXT', 'CEFPIROME', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (325, 'IMIPENEM', NULL, '', 'TEXT', 'IMIPENEM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'OPTIONS', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (326, 'MEROPENEM', NULL, '', 'TEXT', 'MEROPENEM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (327, 'TEICOPLANIN', NULL, '', 'TEXT', 'TEICOPLANIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (328, 'LINEZOLID', NULL, '', 'TEXT', 'LINEZOLID', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL);");

      \DB::statement("
            INSERT INTO `test_items` (`id`, `name`, `short_name`, `formula_code`, `input_type`, `code`, `item_type`, `test_number`, `default_result`, `result_source`, `result_guide`, `reference_value`, `reference_value_type`, `details`, `is_read_only`, `status`, `primary_unit_id`, `test_method_id`, `machine_id`, `created_at`, `updated_at`, `deleted_at`) VALUES 
            (329, 'DALFOPRISTIN/QUINOPRISTIN', NULL, '', 'TEXT', 'DALFOPRISTIN/QUINOPRISTIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (330, 'TOBRAMYCIN', NULL, '', 'TEXT', 'TOBRAMYCIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (331, 'SPARFLOXACIN', NULL, '', 'TEXT', 'SPARFLOXACIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (332, 'GATIFLOXACIN', NULL, '', 'TEXT', 'GATIFLOXACIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (333, 'AZTREONAM', NULL, '', 'TEXT', 'AZTREONAM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (334, 'ERTAPENEM', NULL, '', 'TEXT', 'ERTAPENEM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (335, 'DORIPENEM', NULL, '', 'TEXT', 'DORIPENEM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (336, 'POLYMYXIN B', NULL, '', 'TEXT', 'POLYMYXIN_B', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (337, 'TIGECYCLINE', NULL, '', 'TEXT', 'TIGECYCLINE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'OPTIONS', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (338, 'REMARKS 2', NULL, '', 'TEXT', 'REMARKS_2', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 0, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (339, 'Scrub Typhus IgM', NULL, NULL, 'TEXT', 'SCRUB_TYPHUS_IGM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 11:14:39', NULL),
            (340, 'Scrub Typhus IgG', NULL, NULL, 'TEXT', 'SCRUB_TYPHUS_IGG', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 11:14:46', NULL),
            (341, 'SPECIMEN', NULL, NULL, 'TEXT', 'SPECIMEN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 10:49:11', NULL),
            (342, 'REMARKS', NULL, NULL, 'TEXT', 'REMARKS', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 10:49:18', NULL),
            (343, 'TYPHI DOT IgM', NULL, '', 'TEXT', 'TYPHI__DOT__IGM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'OPTIONS', NULL, 0, 1, 12, 27, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (344, 'TYPHI DOT IgG', NULL, '', 'TEXT', 'TYPHI__DOT__IGG', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'OPTIONS', NULL, 0, 1, 12, 27, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (345, 'HEMOGLOBIN', NULL, '', 'TEXT', 'HEMOGLOBIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, 'Male:13-17 Female:12-15 Birth to 3 Days:_x005F_x000D__x000D_ 14-22 1 Month-12 Years: 11.5-15.5_x005F_x000D__x000D_ ', 'RANGE', NULL, 0, 1, 1, 48, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (346, 'TLC (WBC)', NULL, NULL, 'TEXT', 'TLC_(WBC)', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '4000-11000', 'RANGE', NULL, 0, 1, 32, 23, NULL, '2024-04-20 04:40:07', '2024-04-29 11:13:44', NULL),
            (347, 'NEUTROPHILS', NULL, NULL, 'TEXT', 'NEUTROPHILS', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '40-70', 'RANGE', NULL, 0, 1, 3, 15, NULL, '2024-04-20 04:40:07', '2024-04-29 11:13:52', NULL),
            (348, 'LYMPHOCYTES', NULL, NULL, 'TEXT', 'LYMPHOCYTES', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '20-40', 'RANGE', NULL, 0, 1, 3, 15, NULL, '2024-04-20 04:40:07', '2024-04-29 11:13:59', NULL),
            (349, 'MONOCYTES', NULL, NULL, 'TEXT', 'MONOCYTES', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '0 - 10', 'RANGE', NULL, 0, 1, 3, 15, NULL, '2024-04-20 04:40:07', '2024-04-29 11:14:08', NULL),
            (350, 'EOSINOPHILS', NULL, NULL, 'TEXT', 'EOSINOPHILS', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '44932', 'RANGE', NULL, 0, 1, 3, 15, NULL, '2024-04-20 04:40:07', '2024-04-29 11:14:31', NULL),
            (351, 'BASOPHILS', NULL, NULL, 'TEXT', 'BASOPHILS', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '00-01', 'RANGE', NULL, 0, 1, 3, 15, NULL, '2024-04-20 04:40:07', '2024-04-29 11:14:40', NULL),
            (352, 'HCT (Hematocrit)', NULL, 'CBC-PCV', 'TEXT', 'HCT__(HEMATOCRIT)', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, 'Male: 40 - 50 Female: 36-46', 'RANGE', NULL, 0, 1, 3, 0, NULL, '2024-04-20 04:40:07', '2024-04-29 11:31:53', NULL),
            (353, 'TOTAL BILIRUBIN', NULL, 'TOTAL-BILIRUBIN', 'TEXT', 'TOTAL_BILIRUBIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '0.2 - 1.0', 'RANGE', NULL, 0, 1, 7, 36, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (354, 'CONJUGATED BILIRUBIN', NULL, '', 'TEXT', 'CONJUGATED_BILIRUBIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '0.-0.60', 'RANGE', NULL, 0, 1, 7, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (355, 'UNCONJUGATED BILIRUBIN', NULL, 'UNCONJUGATED-BILIRUBIN', 'TEXT', 'UNCONJUGATED_BILIRUBIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '0.2 - 0.8', 'TEXT', NULL, 0, 1, 7, 6, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (356, 'S.G.P.T [ALT],', NULL, NULL, 'TEXT', 'S.G.P.T_[ALT],', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, 'Male: Up to 40_x005F_x000D__x000D_ Female: Up to 35', 'RANGE', NULL, 0, 1, 19, 25, NULL, '2024-04-20 04:40:07', '2024-05-02 12:25:14', NULL),
            (357, 'S.G.O.T [AST],', NULL, NULL, 'TEXT', 'S.G.O.T_[AST],', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, 'Men: Up to 40_x005F_x000D__x000D_ Female: Up to 35', 'RANGE', NULL, 0, 1, 19, 25, NULL, '2024-04-20 04:40:07', '2024-05-02 12:26:58', NULL),
            (358, 'ALKALINE PHOSPHATASE', NULL, NULL, 'TEXT', 'ALKALINE_PHOSPHATASE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '{Children upto 15 years} - (180-1200)_x005F_x000D__x000D_ Male - ( 80 - 306 )_x005F_x000D__x000D_ Female - ( 64 - 306 )_x005F_x000D__x000D_ _x005F_x000D__x000D_ _x005F_x000D__x000D_', 'RANGE', NULL, 0, 1, 19, 25, NULL, '2024-04-20 04:40:07', '2024-05-02 12:30:49', NULL),
            (359, 'TOTAL PROTEIN', NULL, 'TOTAL-PROTEIN', 'TEXT', 'TOTAL_PROTEIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '6.0 - 8.3', 'RANGE', NULL, 0, 1, 20, 4, NULL, '2024-04-20 04:40:07', '2024-05-02 12:36:14', NULL),
            (360, 'ALBUMIN', NULL, 'ALBUMIN', 'TEXT', 'ALBUMIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '3.5 - 5.5', 'RANGE', NULL, 0, 1, 20, 3, NULL, '2024-04-20 04:40:07', '2024-05-02 12:37:29', NULL),
            (361, 'GLOBULIN', NULL, 'GLOBULIN', 'TEXT', 'GLOBULIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '2.0 - 4.0', 'RANGE', NULL, 0, 1, 20, 6, NULL, '2024-04-20 04:40:07', '2024-05-02 12:38:31', NULL),
            (362, 'A/G RATIO', NULL, 'AG-RATIO', 'TEXT', 'A/G_RATIO', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '1.0 - 2.3', 'TEXT', NULL, 0, 1, 12, 6, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (363, 'E.S.R', NULL, '', 'TEXT', 'E.S.R', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '0-20', 'RANGE', NULL, 0, 1, 6, 59, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (364, 'ZONE OF ERYTHEMA', NULL, NULL, 'TEXT', 'ZONE_OF_ERYTHEMA', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 07:53:21', NULL),
            (365, 'IMPRESSION', NULL, NULL, 'TEXT', 'IMPRESSION', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 07:53:28', NULL),
            (366, 'HAEMOPARASITE', NULL, NULL, 'TEXT', 'HAEMOPARASITE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 09:09:24', NULL),
            (367, 'ABNORMAL CELL', NULL, NULL, 'TEXT', 'ABNORMAL__CELL', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 09:09:31', NULL),
            (368, 'FASTING PLASMA GLUCOSE', NULL, '', 'TEXT', 'FASTING_PLASMA_GLUCOSE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '70-110', 'RANGE', NULL, 0, 1, 7, 20, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (369, 'SODIUM', NULL, '', 'TEXT', 'SODIUM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '136-145', 'RANGE', NULL, 0, 1, 43, 30, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (370, 'POTASSIUM', NULL, '', 'TEXT', 'POTASSIUM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '3.5-5.0', 'RANGE', NULL, 0, 1, 43, 30, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (371, 'A.S.O', NULL, '', 'TEXT', 'A.S.O', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, 'Adult < 250_x005F_x000D__x000D_ Children[<5 years], <100', 'RANGE', NULL, 0, 1, 33, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (372, 'SPUTUM 2nd DAY RESULT', NULL, NULL, 'TEXT', 'SPUTUM_2ND_DAY_RESULT', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 11:48:49', NULL),
            (373, 'SPUTUM 3rd DAY RESULT', NULL, NULL, 'TEXT', 'SPUTUM_3RD_DAY_RESULT', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 11:48:56', NULL),
            (374, 'DIRECT BILIRUBIN', NULL, NULL, 'TEXT', 'DIRECT___BILIRUBIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, 'Neonates <0.6 mg/dL', 'RANGE', NULL, 0, 1, 7, 16, NULL, '2024-04-20 04:40:07', '2024-04-30 12:29:43', NULL),
            (375, 'INDIRECT BILIRUBIN', NULL, NULL, 'TEXT', 'INDIRECT_BILIRUBIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 7, NULL, NULL, '2024-04-20 04:40:07', '2024-04-30 12:29:51', NULL),
            (376, 'CONJUGATED BILIRUBIN', NULL, 'CONJUGATED-BILIRUBIN', 'TEXT', 'CONJUGATED___BILIRUBIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '0-0.60', 'RANGE', NULL, 0, 1, 7, 36, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (377, 'UN CONJUGATED BILIRUBIN', NULL, '', 'TEXT', 'UN_CONJUGATED_BILIRUBIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '0.1-0.90', 'TEXT', NULL, 0, 1, 7, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (378, 'BILE SALT', NULL, NULL, 'TEXT', 'BILE_SALT', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-07 07:58:33', NULL),
            (379, 'BILE PIGMENT', NULL, NULL, 'TEXT', 'BILE_PIGMENT', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-07 07:58:40', NULL),
            (380, 'MICROALBUMIN : CREATININE RATIO, URINE [Immunoturbidimetry, Modified Jaffe Kinetic], MICROALBUMIN', NULL, '', 'TEXT', 'MICROALBUMIN_:_CREATININE_RATIO,_URINE_[IMMUNOTURBIDIMETRY,_MODIFIED_JAFFE_KINETIC],_MICROALBUMIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 47, 0, NULL, '2024-04-20 04:40:07', '2024-04-25 10:01:24', NULL),
            (381, 'CREATININE', NULL, '', 'TEXT', 'CREATININE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '15.00 - 278.00', 'RANGE', NULL, 0, 1, 7, 0, NULL, '2024-04-20 04:40:07', '2024-04-25 10:01:24', NULL),
            (382, 'MICROALBUMIN : CREATININE RATIO', NULL, '', 'TEXT', 'MICROALBUMIN_:_CREATININE__RATIO', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '<30.00', 'RANGE', NULL, 0, 1, 54, 0, NULL, '2024-04-20 04:40:07', '2024-04-25 10:01:24', NULL),
            (383, 'REDUCING SUGAR', NULL, NULL, 'TEXT', 'REDUCING_SUGAR', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 10:58:36', NULL),
            (384, 'YEAST CELL', NULL, NULL, 'TEXT', 'YEAST_CELL', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 11:00:18', NULL),
            (385, 'OVA', NULL, '', 'TEXT', 'OVA', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (386, 'PARASITES', NULL, '', 'TEXT', 'PARASITES', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (387, 'CYSTS', NULL, '', 'TEXT', 'CYSTS', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (388, 'HBA1C', NULL, NULL, 'TEXT', 'HBA1C', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '>8 Action Suggested_x005F_x000D__x000D_ <7 Goal _x005F_x000D__x000D_ <6 Non Diabetic level_x005F_x000D__x000D_', 'RANGE', NULL, 0, 1, 3, 21, NULL, '2024-04-20 04:40:07', '2024-04-30 11:54:03', NULL),
            (389, 'FOETAL HAEMOGLOBIN [HB F],', NULL, NULL, 'TEXT', 'FOETAL_HAEMOGLOBIN_[HB_F],', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '0.0-2.0', 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-04-30 11:54:11', NULL),
            (390, 'HAEMOGLOBIN A2 [HB A2],', NULL, NULL, 'TEXT', 'HAEMOGLOBIN_A2_[HB_A2],', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '1.5 - 3.7', 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-04-30 11:54:18', NULL),
            (391, 'HAEMOGLOBIN A0 (HB A0)', NULL, NULL, 'TEXT', 'HAEMOGLOBIN_A0_(HB_A0)', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '94.3 - 98.5', 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-04-30 11:54:27', NULL),
            (392, 'HB%', NULL, NULL, 'TEXT', 'HB%', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '12.0 - 16.0 (M)_x005F_x000D__x000D_ 11.5 Ã¢â‚¬â€œ 14.5 (F)_x005F_x000D__x000D_ 11.0 - 15.5 (C)', 'RANGE', NULL, 0, 1, 14, NULL, NULL, '2024-04-20 04:40:07', '2024-04-30 11:54:41', NULL),
            (393, 'RBC', NULL, NULL, 'TEXT', 'RBC', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '4.2-5.5', 'RANGE', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:07', '2024-04-30 11:54:50', NULL),
            (394, 'PCV', NULL, '', 'TEXT', 'PCV', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '37-47', 'RANGE', NULL, 0, 1, 3, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (395, 'MCV', NULL, NULL, 'TEXT', 'MCV', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '76-96', 'RANGE', NULL, 0, 1, 25, NULL, NULL, '2024-04-20 04:40:07', '2024-04-30 11:54:59', NULL),
            (396, 'MCH', NULL, NULL, 'TEXT', 'MCH', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '27-32', 'RANGE', NULL, 0, 1, 5, NULL, NULL, '2024-04-20 04:40:07', '2024-04-30 11:55:10', NULL),
            (397, 'MCHC', NULL, NULL, 'TEXT', 'MCHC', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '31-35', 'RANGE', NULL, 0, 1, 14, NULL, NULL, '2024-04-20 04:40:07', '2024-04-30 11:55:18', NULL),
            (398, 'RDW-SD', NULL, NULL, 'TEXT', 'RDW-SD', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 25, NULL, NULL, '2024-04-20 04:40:07', '2024-04-30 11:55:25', NULL),
            (399, 'INTERPRETATION :', NULL, NULL, 'TEXT', 'INTERPRETATION_:', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-04-30 11:55:33', NULL),
            (400, 'ADVICE :', NULL, NULL, 'TEXT', 'ADVICE_:', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-04-30 11:55:42', NULL),
            (401, 'Blood for Glycosylated Heamoglobin (HBA1C)', NULL, '', 'TEXT', 'BLOOD_FOR_GLYCOSYLATED_HEAMOGLOBIN_(HBA1C)', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '>8 Action Suggested,_x005F_x000D__x000D_ <7 Goal,_x005F_x000D__x000D_ <6 Non Diabetic level', 'RANGE', NULL, 0, 1, 3, 39, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (402, 'NOTE :', NULL, '', 'TEXT', 'NOTE_:', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (403, 'ADVICE :', NULL, '', 'TEXT', 'ADVICE_:', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (404, 'T3', NULL, '', 'TEXT', 'T3', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '0.5 to 1.8', 'RANGE', NULL, 0, 1, 51, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (405, 'T4', NULL, '', 'TEXT', 'T4', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, ' 4.6 to 12 ', 'RANGE', NULL, 0, 1, 51, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (406, 'TSH', NULL, NULL, 'TEXT', 'TSH', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '0.3 to 5.5', 'RANGE', NULL, 0, 1, 44, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 11:03:01', NULL),
            (407, 'T4', NULL, NULL, 'TEXT', 'T4', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, 'Male: 4.4 - 10.8_x005F_x000D__x000D_ Female: 4.8 - 11.6', 'RANGE', NULL, 0, 1, 44, 13, NULL, '2024-04-20 04:40:07', '2024-05-03 10:35:11', NULL),
            (408, 'TSH', NULL, NULL, 'TEXT', 'TSH', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '0.25 - 5.0', 'RANGE', NULL, 0, 1, 44, 13, NULL, '2024-04-20 04:40:07', '2024-05-03 10:35:18', NULL),
            (411, 'CPK-MB', NULL, '', 'TEXT', 'CPK-MB', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, 'Upto24', 'TEXT', NULL, 0, 1, 19, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (412, 'SPECIMEN', NULL, NULL, 'TEXT', 'SPECIMEN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 11:19:25', NULL),
            (413, 'TIME OF ARRIVED IN LAB', NULL, NULL, 'TEXT', 'TIME_OF_ARRIVED_IN_LAB', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 11:20:57', NULL),
            (414, 'PERIOD OF SEXUAL ABSTINENCE', NULL, NULL, 'TEXT', 'PERIOD_OF_SEXUAL_ABSTINENCE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 11:21:32', NULL),
            (415, 'MODE OF COLLECTION', NULL, NULL, 'TEXT', 'MODE_OF_COLLECTION', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 11:23:31', NULL),
            (416, 'PHYSICAL CHARACTERISTIC', NULL, NULL, 'TEXT', 'PHYSICAL_CHARACTERISTIC', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 11:26:21', NULL),
            (417, 'COLOUR', NULL, NULL, 'TEXT', 'COLOUR', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 11:26:55', NULL),
            (418, 'VOLUME', NULL, NULL, 'TEXT', 'VOLUME', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 11:27:58', NULL),
            (419, 'VISCOSITY', NULL, NULL, 'TEXT', 'VISCOSITY', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 11:28:53', NULL),
            (420, 'REACTION', NULL, NULL, 'TEXT', 'REACTION', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 11:30:37', NULL),
            (421, 'pH', NULL, NULL, 'TEXT', 'PH', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 11:32:28', NULL),
            (422, 'MICROSCOPIC CHARACTERISTIC', NULL, NULL, 'TEXT', 'MICROSCOPIC_CHARACTERISTIC_SPERM_CONCENTRATION', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 27, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 10:19:37', NULL);");

      \DB::statement("
            INSERT INTO `test_items` (`id`, `name`, `short_name`, `formula_code`, `input_type`, `code`, `item_type`, `test_number`, `default_result`, `result_source`, `result_guide`, `reference_value`, `reference_value_type`, `details`, `is_read_only`, `status`, `primary_unit_id`, `test_method_id`, `machine_id`, `created_at`, `updated_at`, `deleted_at`) VALUES 
            (423, 'TOTAL SPERM COUNT', NULL, NULL, 'TEXT', 'TOTAL_SPERM_COUNT', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 10:14:59', NULL),
            (424, 'TOTAL MOTILITY COUNT', NULL, NULL, 'TEXT', 'TOTAL_MOTILITY_COUNT', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 3, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 10:15:07', NULL),
            (425, 'GRADING', NULL, NULL, 'TEXT', 'GRADING_RAPIDLY_PROGRESSIVE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 3, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 10:19:50', NULL),
            (426, 'SLUGGISHLY PROGRESSIVE', NULL, NULL, 'TEXT', 'SLUGGISHLY_PROGRESSIVE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 3, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 10:15:29', NULL),
            (427, 'NON-MOTILE', NULL, NULL, 'TEXT', 'NON-MOTILE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 3, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 10:15:42', NULL),
            (428, 'MORPHOLOGY', NULL, NULL, 'TEXT', 'MORPHOLOGY_NORMAL', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 3, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 10:20:12', NULL),
            (429, 'PIN HEAD', NULL, NULL, 'TEXT', 'PIN_HEAD', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 3, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 10:16:13', NULL),
            (430, 'HEAD DEFECT', NULL, NULL, 'TEXT', 'HEAD_DEFECT', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 3, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 10:16:26', NULL),
            (431, 'NECK DEFECT', NULL, NULL, 'TEXT', 'NECK_DEFECT', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 3, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 10:16:34', NULL),
            (432, 'TAIL DEFECT', NULL, NULL, 'TEXT', 'TAIL_DEFECT', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 3, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 10:16:45', NULL),
            (433, 'PUS CELL', NULL, NULL, 'TEXT', 'PUS_CELL', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 28, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 10:16:57', NULL),
            (434, 'R.B.C', NULL, NULL, 'TEXT', 'R.B.C', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 28, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 10:17:10', NULL),
            (435, 'SPERMATOLOGICAL DIAGNOSIS', NULL, NULL, 'TEXT', 'SPERMATOLOGICAL_DIAGNOSIS', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 11:36:49', NULL),
            (436, 'PLATELET COUNT', NULL, NULL, 'TEXT', 'PLATELET_COUNT', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '1.5-4.5', 'RANGE', NULL, 0, 1, 52, 23, NULL, '2024-04-20 04:40:07', '2024-04-29 11:14:47', NULL),
            (437, 'RBC COUNT', NULL, '', 'TEXT', 'RBC_COUNT', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '3.8-4.8', 'RANGE', NULL, 0, 1, 54, 22, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (438, 'PCV', NULL, NULL, 'TEXT', 'PCV', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '37-47', 'RANGE', NULL, 0, 1, 3, 41, NULL, '2024-04-20 04:40:07', '2024-04-29 11:14:56', NULL),
            (439, '', NULL, '', 'TEXT', '', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'OPTIONS', NULL, 0, 1, 12, 24, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (440, '', NULL, '', 'TEXT', '', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 24, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (441, '', NULL, '', 'TEXT', '', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 24, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (442, '', NULL, '', 'TEXT', '', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 55, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (443, 'SPECIMEN', NULL, NULL, 'TEXT', 'SPECIMEN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-04 09:16:51', NULL),
            (444, 'RESULT', NULL, NULL, 'TEXT', 'RESULT', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, NULL, NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-04 09:16:33', NULL),
            (445, 'COMMENTS', NULL, NULL, 'TEXT', 'COMMENTS', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-04 09:58:42', NULL),
            (446, 'COMMENTS :', NULL, NULL, 'TEXT', 'COMMENTS_:', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 11:49:04', NULL),
            (447, 'Antimicrobial Susceptibility Information AMPICILLIN', NULL, NULL, 'TEXT', 'ANTIMICROBIAL_SUSCEPTIBILITY_INFORMATION_AMPICILLIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-04 10:15:39', NULL),
            (448, 'AMOXYCILLIN + CLAVULANIC ACID', NULL, '', 'TEXT', 'AMOXYCILLIN_+_CLAVULANIC__ACID', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'OPTIONS', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (449, 'COLONY COUNT', NULL, NULL, 'TEXT', 'COLONY_COUNT', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-04 10:09:24', NULL),
            (450, 'ORGANISM', NULL, NULL, 'TEXT', 'ORGANISM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-04 10:03:12', NULL),
            (451, '', NULL, '', 'TEXT', '', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (452, 'COMMENTS:', NULL, '', 'TEXT', 'COMMENTS:', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (453, 'COMMENTS:', NULL, '', 'TEXT', 'COMMENTS:', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (454, '', NULL, '', 'TEXT', '', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (455, 'METHOD:', NULL, NULL, 'TEXT', 'METHOD:', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-04 10:01:42', NULL),
            (456, 'CEFOPERAZONE + SULBACTAM', NULL, '', 'TEXT', 'CEFOPERAZONE_+_SULBACTAM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'OPTIONS', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (457, 'PIPERACILLIN + TAZOBACTAM', NULL, '', 'TEXT', 'PIPERACILLIN_+_TAZOBACTAM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'OPTIONS', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (458, 'CEFIPIME+ TAZOBATAM', NULL, '', 'TEXT', 'CEFIPIME+_TAZOBATAM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'OPTIONS', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (459, 'CEFTAZIDIME', NULL, NULL, 'TEXT', 'CEFTAZIDIME', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-04 10:39:44', NULL),
            (460, 'IMIPENEM', NULL, NULL, 'TEXT', 'IMIPENEM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-04 10:50:38', NULL),
            (461, 'MEROPENEM', NULL, NULL, 'TEXT', 'MEROPENEM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-04 10:58:02', NULL),
            (462, 'AMIKACIN', NULL, NULL, 'TEXT', 'AMIKACIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-04 11:02:34', NULL),
            (463, 'GENTAMICIN', NULL, NULL, 'TEXT', 'GENTAMICIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-04 11:06:27', NULL),
            (464, 'NALADIXIC ACID', NULL, '', 'TEXT', 'NALADIXIC_ACID', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'OPTIONS', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (465, 'CIPROFLOXACIN', NULL, NULL, 'TEXT', 'CIPROFLOXACIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-04 11:13:34', NULL),
            (466, 'TIGECYCLINE', NULL, NULL, 'TEXT', 'TIGECYCLINE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-04 11:14:14', NULL),
            (467, 'COLISTIN', NULL, '', 'TEXT', 'COLISTIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'OPTIONS', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (468, 'NITROFURANTOIN', NULL, NULL, 'TEXT', 'NITROFURANTOIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-04 11:17:02', NULL),
            (469, 'CO-TRIMOXAZOLE', NULL, NULL, 'TEXT', 'CO-TRIMOXAZOLE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-04 11:30:48', NULL),
            (470, 'CEFUROXIME', NULL, NULL, 'TEXT', 'CEFUROXIME', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-04 10:46:33', NULL),
            (471, 'LEVOFLOXACIN', NULL, NULL, 'TEXT', 'LEVOFLOXACIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-04 11:48:58', NULL),
            (472, 'COMMENTS :', NULL, NULL, 'TEXT', 'COMMENTS_:', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-07 08:11:32', NULL),
            (473, 'RANDOM PLASMA GLUCOSE', NULL, '', 'TEXT', 'RANDOM_PLASMA__GLUCOSE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '80 - 140', 'TEXT', NULL, 0, 1, 7, 19, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (474, 'SPECIMEN:', NULL, NULL, 'TEXT', 'SPECIMEN:', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 07:32:02', NULL),
            (475, 'Physical Examination', NULL, NULL, 'TEXT', 'PHYSICAL_EXAMINATION', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 07:32:09', NULL),
            (476, 'Colour :', NULL, NULL, 'TEXT', 'COLOUR_:', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 07:32:18', NULL),
            (477, 'Appearance :', NULL, NULL, 'TEXT', 'APPEARANCE_:', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 07:32:25', NULL),
            (478, 'Reaction :', NULL, NULL, 'TEXT', 'REACTION_:', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 07:32:46', NULL),
            (479, 'pH :', NULL, NULL, 'TEXT', 'PH_:', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 07:33:01', NULL),
            (480, 'Deposit :', NULL, NULL, 'TEXT', 'DEPOSIT_:', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 07:36:25', NULL),
            (481, 'Coagulum :', NULL, NULL, 'TEXT', 'COAGULUM_:', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 07:36:42', NULL),
            (482, 'Chemical Examination Total Protein', NULL, NULL, 'TEXT', 'CHEMICAL_EXAMINATION_TOTAL_PROTEIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 20, 4, NULL, '2024-04-20 04:40:07', '2024-05-06 07:36:52', NULL),
            (483, 'Sugar', NULL, NULL, 'TEXT', 'SUGAR', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 7, 20, NULL, '2024-04-20 04:40:07', '2024-05-06 07:37:02', NULL),
            (484, 'Chloride', NULL, NULL, 'TEXT', 'CHLORIDE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 43, 53, NULL, '2024-04-20 04:40:07', '2024-05-06 07:37:43', NULL),
            (485, 'Microscopic Examination Cell count', NULL, NULL, 'TEXT', 'MICROSCOPIC_EXAMINATION_CELL_COUNT', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 32, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 07:37:54', NULL),
            (486, 'Cell type Neutrophils', NULL, NULL, 'TEXT', 'CELL_TYPE_NEUTROPHILS', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 3, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 07:38:08', NULL),
            (487, 'Lymphocytes', NULL, NULL, 'TEXT', 'LYMPHOCYTES', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 3, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 07:38:27', NULL),
            (488, 'Eosinophils', NULL, NULL, 'TEXT', 'EOSINOPHILS', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 3, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 07:38:42', NULL),
            (489, 'Monocytes', NULL, NULL, 'TEXT', 'MONOCYTES', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 3, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 07:39:20', NULL),
            (490, 'Basophils', NULL, NULL, 'TEXT', 'BASOPHILS', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 3, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 07:39:47', NULL),
            (491, 'Atypical Cells', NULL, NULL, 'TEXT', 'ATYPICAL_CELLS', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 3, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 07:40:21', NULL),
            (492, 'Mesothelial', NULL, NULL, 'TEXT', 'MESOTHELIAL', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 3, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 07:41:01', NULL),
            (493, 'Macrophage', NULL, NULL, 'TEXT', 'MACROPHAGE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 3, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 07:41:34', NULL),
            (494, 'Gram stain', NULL, NULL, 'TEXT', 'GRAM_STAIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 07:41:52', NULL),
            (495, 'ZN Stain', NULL, '', 'TEXT', 'ZN_STAIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'OPTIONS', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (496, 'Blood', NULL, '', 'TEXT', 'BLOOD', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'OPTIONS', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (497, 'GAMMA GLUTAMYL TRANSFERASE', NULL, '', 'TEXT', 'GAMMA_GLUTAMYL_TRANSFERASE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '<55', 'RANGE', NULL, 0, 1, 18, 7, NULL, '2024-04-20 04:40:07', '2024-04-30 06:53:49', NULL),
            (498, 'RESULT', NULL, '', 'TEXT', 'RESULT', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'OPTIONS', NULL, 0, 1, 12, 45, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL);");

      \DB::statement("
            INSERT INTO `test_items` (`id`, `name`, `short_name`, `formula_code`, `input_type`, `code`, `item_type`, `test_number`, `default_result`, `result_source`, `result_guide`, `reference_value`, `reference_value_type`, `details`, `is_read_only`, `status`, `primary_unit_id`, `test_method_id`, `machine_id`, `created_at`, `updated_at`, `deleted_at`) VALUES
            (499, 'Control', NULL, '', 'TEXT', 'CONTROL', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 45, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (500, 'Patient Value', NULL, '', 'TEXT', 'PATIENT_VALUE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '11.5 - 14.6', 'RANGE', NULL, 0, 1, 45, 10, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (501, 'Prothrombin Ratio (PR)', NULL, '', 'TEXT', 'PROTHROMBIN_RATIO_(PR)', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (502, 'International Normalized Ratio (INR)', NULL, '', 'TEXT', 'INTERNATIONAL_NORMALIZED_RATIO_(INR)', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '0.93 - 1.16', 'RANGE', NULL, 0, 1, 45, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (503, 'Physical Examination COLOUR', NULL, NULL, 'TEXT', 'PHYSICAL_EXAMINATION_COLOUR', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 08:31:05', NULL),
            (504, 'TURBIDITY', NULL, NULL, 'TEXT', 'TURBIDITY', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 08:31:37', NULL),
            (505, 'COAGULUM', NULL, NULL, 'TEXT', 'COAGULUM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 08:31:58', NULL),
            (506, 'BLOOD', NULL, NULL, 'TEXT', 'BLOOD', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 08:32:12', NULL),
            (507, 'DEPOSIT', NULL, NULL, 'TEXT', 'DEPOSIT', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 08:32:23', NULL),
            (508, 'Chemical Examination GLUCOSE', NULL, NULL, 'TEXT', 'CHEMICAL_EXAMINATION_GLUCOSE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 7, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 08:32:44', NULL),
            (509, 'CHLORIDE', NULL, NULL, 'TEXT', 'CHLORIDE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 11, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 08:32:51', NULL),
            (510, 'TOTAL PROTEIN', NULL, NULL, 'TEXT', 'TOTAL_PROTEIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 08:32:58', NULL),
            (511, 'GLOBULIN', NULL, NULL, 'TEXT', 'GLOBULIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 08:33:05', NULL),
            (512, 'Cytological Examination CELL COUNT', NULL, NULL, 'TEXT', 'CYTOLOGICAL_EXAMINATION_CELL_COUNT', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, NULL, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 08:33:19', NULL),
            (513, 'NEUTROPHILS', NULL, NULL, 'TEXT', 'NEUTROPHILS', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 3, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 08:33:31', NULL),
            (514, 'LYMPHOCYTES', NULL, NULL, 'TEXT', 'LYMPHOCYTES', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 3, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 08:33:41', NULL),
            (515, 'ALBUMIN, ASCITIC FLUID', NULL, '', 'TEXT', 'ALBUMIN,_ASCITIC_FLUID', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 58, 0, NULL, '2024-04-20 04:40:07', '2024-04-25 10:01:13', NULL),
            (516, 'ALBUMIN, SERUM', NULL, '', 'TEXT', 'ALBUMIN,_SERUM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 58, 0, NULL, '2024-04-20 04:40:07', '2024-04-25 10:01:13', NULL),
            (517, 'SAAG', NULL, '', 'TEXT', 'SAAG', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 58, 0, NULL, '2024-04-20 04:40:07', '2024-04-25 10:01:13', NULL),
            (518, 'CA 125; OVARIAN CANCER MARKER, SERUM', NULL, '', 'TEXT', 'CA_125;_OVARIAN_CANCER_MARKER,_SERUM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '<35', 'RANGE', NULL, 0, 1, 60, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (519, 'CYTOPATH NO', NULL, NULL, 'TEXT', 'CYTOPATH_NO', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-04-30 11:04:26', NULL),
            (520, 'Specimen type / collection method', NULL, NULL, 'TEXT', 'SPECIMEN_TYPE_/_COLLECTION_METHOD', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-04-30 11:04:33', NULL),
            (521, 'Clinical History', NULL, NULL, 'TEXT', 'CLINICAL_HISTORY', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-04-30 11:04:41', NULL),
            (522, 'Gross', NULL, NULL, 'TEXT', 'GROSS', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-04-30 11:04:50', NULL),
            (523, 'Specimen Preparation & Stains', NULL, NULL, 'TEXT', 'SPECIMEN_PREPARATION_&_STAINS', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-04-30 11:04:58', NULL),
            (524, 'Specimen Adequacy', NULL, NULL, 'TEXT', 'SPECIMEN_ADEQUACY', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-04-30 11:05:07', NULL),
            (525, 'Microscopic', NULL, NULL, 'TEXT', 'MICROSCOPIC', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-04-30 11:05:14', NULL),
            (526, 'General Categorization', NULL, NULL, 'TEXT', 'GENERAL_CATEGORIZATION', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-04-30 11:05:22', NULL),
            (527, 'Impression', NULL, '', 'TEXT', 'IMPRESSION', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (528, 'DEGENERATED CELLS', NULL, NULL, 'TEXT', 'DEGENERATED_CELLS', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 08:33:58', NULL),
            (529, 'MESOTHELIAL CELL', NULL, NULL, 'TEXT', 'MESOTHELIAL_CELL', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 08:34:05', NULL),
            (530, 'Anti DS DNA Antibody', NULL, '', 'TEXT', 'ANTI_DS_DNA_ANTIBODY', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'RANGE', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (531, 'Vitamin D3', NULL, '', 'TEXT', 'VITAMIN_D3', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 7, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (532, 'Luteinizing Hormone [LH],', NULL, NULL, 'TEXT', 'LUTEINIZING_HORMONE_[LH],', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 07:02:18', NULL),
            (533, 'PVC', NULL, NULL, 'TEXT', 'PVC', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 3, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 08:32:51', NULL),
            (534, 'HDL', NULL, '', 'TEXT', 'HDL', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, 'male 40 to 60 _x000D_ _x005F_x000D__x000D_ female 35 to 60', 'TEXT', NULL, 0, 1, 7, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (535, 'Very low density lipoprotein (VLDL)', NULL, NULL, 'TEXT', 'VERY_LOW_DENSITY_LIPOPROTEIN_(VLDL)', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '10 to 50', 'RANGE', NULL, 0, 1, 7, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 11:33:05', NULL),
            (536, 'Mantoux', NULL, '', 'TEXT', 'MANTOUX', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 3, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (537, 'LDL', NULL, '', 'TEXT', 'LDL', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '10 to 150', 'TEXT', NULL, 0, 1, 7, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (538, 'UROBILINOGEN', NULL, '', 'TEXT', 'UROBILINOGEN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:07', '2024-04-30 08:22:23', NULL),
            (539, 'PUS CELLS', NULL, '', 'TEXT', 'PUS_CELLS', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '0 - 5', 'TEXT', NULL, 0, 1, 28, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (540, 'FRANK BLOOD', NULL, '', 'TEXT', 'FRANK_BLOOD', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'RANGE', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (541, 'PARASITE', NULL, '', 'TEXT', 'PARASITE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'RANGE', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (542, 'OCCULT BLOOD', NULL, NULL, 'TEXT', 'OCCULT_BLOOD', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 10:58:27', NULL),
            (543, 'LARVAE', NULL, NULL, 'TEXT', 'LARVAE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 10:59:31', NULL),
            (544, 'FAT GLOBULES', NULL, '', 'TEXT', 'FAT_GLOBULES', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'RANGE', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (545, 'CATEGORY', NULL, '', 'TEXT', 'CATEGORY', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'RANGE', NULL, 0, 1, 55, 0, NULL, '2024-04-20 04:40:07', '2024-04-25 10:01:24', NULL),
            (546, 'NORMAL / NON DIABETIC', NULL, '', 'TEXT', 'NORMAL_/_NON_DIABETIC', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'RANGE', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:07', '2024-04-25 10:01:24', NULL),
            (547, 'MICROALBUMINURIA', NULL, '', 'TEXT', 'MICROALBUMINURIA', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'RANGE', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:07', '2024-04-25 10:01:24', NULL),
            (548, 'CLINICAL ALBUMINURIA', NULL, '', 'TEXT', 'CLINICAL_ALBUMINURIA', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:07', '2024-04-25 10:01:24', NULL),
            (549, 'PCV', NULL, NULL, 'TEXT', 'PCV', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '40 to 50', 'RANGE', NULL, 0, 1, 3, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 08:28:49', NULL),
            (550, 'IMPRESSION', NULL, NULL, 'TEXT', 'IMPRESSION', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-08 09:45:18', NULL),
            (551, 'IMPRESSION', NULL, '', 'TEXT', 'IMPRESSION', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (552, 'URINE FOR HCG (PREGNANCY TEST)', NULL, NULL, 'TEXT', 'URINE_FOR_HCG_(PREGNANCY_TEST)', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 09:22:00', NULL),
            (553, '-', NULL, '', 'TEXT', '-', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'OPTIONS', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (554, 'BLOOD GLUCOSE (PP)', NULL, NULL, 'TEXT', 'BLOOD_GLUCOSE_(PP)', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '80-145', 'RANGE', NULL, 0, 1, 7, 19, NULL, '2024-04-20 04:40:07', '2024-04-30 10:01:05', NULL),
            (555, 'REMARKS', NULL, NULL, 'TEXT', 'REMARKS', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-04-30 10:01:13', NULL),
            (556, 'Urine For Ketone Bodies Test', NULL, NULL, 'TEXT', 'URINE_FOR_KETONE_BODIES_TEST', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-07 08:05:15', NULL),
            (557, 'COMMENTS :', NULL, NULL, 'TEXT', 'COMMENTS_:', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-07 08:05:20', NULL),
            (558, 'Urine Bilesalt', NULL, NULL, 'TEXT', 'URINE_BILESALT', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-04-30 08:32:09', NULL),
            (559, 'Urine Pigment', NULL, NULL, 'TEXT', 'URINE_PIGMENT', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-04-30 08:32:01', NULL),
            (560, 'URINE- UROBILINOGEN', NULL, '', 'TEXT', 'URINE-_UROBILINOGEN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'RANGE', NULL, 0, 1, 60, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (561, 'CARDIAC TROPONIN-I', NULL, NULL, 'TEXT', 'CARDIAC_TROPONIN-I', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-04 08:06:57', NULL),
            (562, 'IMPRESSION', NULL, NULL, 'TEXT', 'IMPRESSION', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 12:04:27', NULL),
            (563, 'MANTOUX GIVEN TIME', NULL, NULL, 'TEXT', 'MANTOUX_GIVEN_TIME', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 07:52:37', NULL),
            (564, 'REPORTING DATE', NULL, NULL, 'TEXT', 'REPORTING_DATE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 07:52:45', NULL),
            (565, 'PLASMODIUM FALCIPARUM ANTIGEN', NULL, NULL, 'TEXT', 'PLASMODIUM_FALCIPARUM_ANTIGEN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 07:31:28', NULL),
            (566, 'PLASMODIUM VIVAX ANTIGEN', NULL, NULL, 'TEXT', 'PLASMODIUM_VIVAX_ANTIGEN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 07:31:37', NULL),
            (567, 'Serum CPK (Total)', NULL, '', 'TEXT', 'SERUM_CPK_(TOTAL)', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, 'Male upto 24 - 195 U/L at 37Ã‚Â° C _x000D_ _x005F_x000D__x000D_ Female upto 24 - 170 U/L at 37Ã‚Â° C', 'RANGE', NULL, 0, 1, 57, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (568, 'Sample Taken after 150 minutes :', NULL, NULL, 'TEXT', 'SAMPLE_TAKEN_AFTER_150_MINUTES_:', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 7, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 10:29:36', NULL),
            (569, 'GAMMA-GLUTAMYL TRANSFERASE (GGT)', NULL, NULL, 'TEXT', 'GAMMA-GLUTAMYL_TRANSFERASE_(GGT)', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, 'Male - 10 to 50, Female - 7 to 35', 'RANGE', NULL, 0, 1, 50, NULL, NULL, '2024-04-20 04:40:07', '2024-04-29 08:17:50', NULL),
            (570, 'BLOOD GLUCOSE (PP)', NULL, '', 'TEXT', 'BLOOD_GLUCOSE_(PP)', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '80 -145', 'TEXT', NULL, 0, 1, 7, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (571, 'REMARKS', NULL, '', 'TEXT', 'REMARKS', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (572, 'BACTERIA', NULL, '', 'TEXT', 'BACTERIA', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (573, 'FREE-T3', NULL, '', 'TEXT', 'FREE-T3', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '2.80 to 8.3', 'RANGE', NULL, 0, 1, 52, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (574, 'FREE-T4', NULL, '', 'TEXT', 'FREE-T4', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '9 to 23', 'RANGE', NULL, 0, 1, 52, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (575, 'TIME OF EXAMINATION', NULL, NULL, 'TEXT', 'TIME_OF_EXAMINATION', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 11:24:11', NULL),
            (576, 'Total Leukocyte Count', NULL, '', 'TEXT', 'TOTAL_LEUKOCYTE_COUNT', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '4000 - 11000', 'RANGE', NULL, 0, 1, 35, 0, NULL, '2024-04-20 04:40:07', '2024-04-29 11:30:54', NULL),
            (577, 'RBC INDICES', NULL, NULL, 'TEXT', 'RBC_INDICES', 'TEST_LABEL', NULL, NULL, 'MANUAL', NULL, '0', 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-04-29 11:31:48', NULL),
            (578, 'DIFFERENTIAL LEUKOCYTE COUNT', NULL, NULL, 'TEXT', 'DIFFERENTIAL_LEUKOCYTE_COUNT', 'TEST_LABEL', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-02 10:24:29', NULL),
            (579, 'S. CHOLESTEROL', NULL, 'LIPID-SCHOLESTEROL', 'TEXT', 'S._CHOLESTEROL', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, 'Up to 200', 'RANGE', NULL, 0, 1, 7, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (580, 'HDL CHOLESTEROL', NULL, 'LIPID-HDLCHOLESTEROL', 'TEXT', 'HDL_CHOLESTEROL', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '30-70', 'RANGE', NULL, 0, 1, 20, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (581, 'TRIGLYCERIDES', NULL, 'LIPID-TRIGLYCERIDES', 'TEXT', 'TRIGLYCERIDES', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, 'Normal <150,Borderline High 150 - 199,High 200 - 499,Very high >499', 'RANGE', NULL, 0, 1, 7, NULL, NULL, '2024-04-20 04:40:07', '2024-05-02 12:16:05', NULL),
            (582, 'LDL CHOLESTEROL', NULL, 'LIPID-DIRECTLDLCHOLESTEROL', 'TEXT', 'LDL_CHOLESTEROL', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '<150', 'RANGE', NULL, 0, 1, 7, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (583, 'VLDL', NULL, 'LIPID-VLDL', 'TEXT', 'VLDL', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '15-35', 'RANGE', NULL, 0, 1, 7, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (584, 'CHOL/HDL RATIO', NULL, 'LIPID-CHOLHDLRATIO', 'TEXT', 'CHOL/HDL_RATIO', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '<6', 'RANGE', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (585, 'LDL/HDL RATIO', NULL, 'LIPID-LDLHDLRATIO', 'TEXT', 'LDL/HDL_RATIO', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (586, 'PHYSICAL EXAMINATION', NULL, '', 'TEXT', 'PHYSICAL_EXAMINATION', 'TEST_LABEL', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (587, 'CHEMICAL EXAMINATION', NULL, '', 'TEXT', 'CHEMICAL_EXAMINATION', 'TEST_LABEL', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (588, 'REACTION', NULL, '', 'TEXT', 'REACTION', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (589, 'MICROSCOPICAL EXAMINATION', NULL, '', 'TEXT', 'MICROSCOPICAL_EXAMINATION', 'TEST_LABEL', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (590, 'Specimen', NULL, NULL, 'TEXT', 'SPECIMEN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 06:45:48', NULL),
            (591, 'Method', NULL, NULL, 'TEXT', 'METHOD', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 06:45:56', NULL),
            (592, 'Impression', NULL, NULL, 'TEXT', 'IMPRESSION', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 06:46:15', NULL),
            (593, 'Organism Grown', NULL, NULL, 'TEXT', 'ORGANISM_GROWN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 06:47:10', NULL),
            (594, 'Ampicillin', NULL, NULL, 'TEXT', 'AMPICILLIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 06:47:19', NULL),
            (595, 'Amoxycillin + CV', NULL, NULL, 'TEXT', 'AMOXYCILLIN_+_CV', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 06:48:04', NULL),
            (596, 'Ciprofloxacin', NULL, NULL, 'TEXT', 'CIPROFLOXACIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 06:48:22', NULL),
            (597, 'Ofloxacin', NULL, NULL, 'TEXT', 'OFLOXACIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 06:48:56', NULL),
            (598, 'Ceftriaxone', NULL, NULL, 'TEXT', 'CEFTRIAXONE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 06:49:06', NULL),
            (599, 'Cefoperazone', NULL, NULL, 'TEXT', 'CEFOPERAZONE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 06:50:25', NULL),
            (600, 'Chloramphenicol', NULL, NULL, 'TEXT', 'CHLORAMPHENICOL', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 06:50:44', NULL),
            (601, 'Piperacillin +TV', NULL, NULL, 'TEXT', 'PIPERACILLIN_+TV', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 06:51:10', NULL),
            (602, 'Gentamicin', NULL, NULL, 'TEXT', 'GENTAMICIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 06:51:19', NULL),
            (603, 'Meropenem', NULL, NULL, 'TEXT', 'MEROPENEM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 06:51:45', NULL),
            (604, 'Linezolid', NULL, NULL, 'TEXT', 'LINEZOLID', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 06:51:58', NULL),
            (605, 'Rifampicin', NULL, NULL, 'TEXT', 'RIFAMPICIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 06:52:24', NULL),
            (606, 'Nitrofurantion', NULL, NULL, 'TEXT', 'NITROFURANTION', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 06:52:37', NULL),
            (607, 'REMARKS :', NULL, '', 'TEXT', 'REMARKS_:', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (608, 'REMARKS :', NULL, NULL, 'TEXT', 'REMARKS_:', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-02 10:33:32', NULL),
            (609, 'ALBUMIN', NULL, NULL, 'TEXT', 'ALBUMIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '3.7 ÃƒÂ¢Ã¢â€šÂ¬Ã¢â‚¬Å“ 5.3', 'RANGE', NULL, 0, 1, 7, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 11:10:59', NULL),
            (610, 'GLOBULIN', NULL, NULL, 'TEXT', 'GLOBULIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '2.5 - 3.6', 'RANGE', NULL, 0, 1, 7, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 11:11:05', NULL),
            (611, 'AG RATIO', NULL, NULL, 'TEXT', 'AG_RATIO', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 11:11:11', NULL),
            (612, 'CALCIUM', NULL, NULL, 'TEXT', 'CALCIUM', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '8.7 - 11.0', 'RANGE', NULL, 0, 1, 7, 40, NULL, '2024-04-20 04:40:07', '2024-04-30 06:07:35', NULL),
            (613, 'SODIUM (Na+)', NULL, NULL, 'TEXT', 'SODIUM_(NA+)', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '135 - 145', 'RANGE', NULL, 0, 1, 43, 14, NULL, '2024-04-20 04:40:07', '2024-04-30 06:07:43', NULL),
            (614, 'POTASSIUM (K+)', NULL, NULL, 'TEXT', 'POTASSIUM_(K+)', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '3.5 - 5.0', 'RANGE', NULL, 0, 1, 43, 14, NULL, '2024-04-20 04:40:07', '2024-04-30 06:07:51', NULL),
            (615, 'CHLORIDE(Cl-)', NULL, '', 'TEXT', 'CHLORIDE(CL-)', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '98 - 107', 'RANGE', NULL, 0, 1, 43, 14, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (616, 'NOTE :', NULL, NULL, 'TEXT', 'NOTE_:', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-04-30 06:08:11', NULL),
            (617, 'ESR', NULL, '', 'TEXT', 'ESR', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '0 - 20', 'RANGE', NULL, 0, 1, 42, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (618, 'VITAMIN-B12', NULL, '', 'TEXT', 'VITAMIN-B12', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '197 - 771', 'RANGE', NULL, 0, 1, 15, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (619, 'Anti Mullerian Hormone (AMH)', NULL, NULL, 'TEXT', 'ANTI_MULLERIAN_HORMONE_(AMH)', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, 'Optimal fertility 4.0 - 6.8 _x000D_ _x005F_x000D__x000D_ Satisfactory Fertility 2.20 - 4.0_x000D_ _x005F_x000D__x000D_ Low Fertility 0.3 - 2.20_x000D_ _x005F_x000D__x000D_ Undetectable less than 0.3_x000D_ _x005F_x000D__x000D_ High level above 6.8 ng/dl (', 'RANGE', NULL, 0, 1, 17, NULL, NULL, '2024-04-20 04:40:07', '2024-04-30 09:20:40', NULL),
            (620, 'Serum Prolactin', NULL, '', 'TEXT', 'SERUM_PROLACTIN', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, 'Men: 3 - 25_x000D_ _x005F_x000D__x000D_ Women : 5 - 35', 'RANGE', NULL, 0, 1, 17, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (621, 'ELECTROLYTE 2 PARAMETER', NULL, NULL, 'TEXT', 'ELECTROLYTE_2_PARAMETER', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '135 - 145', 'RANGE', NULL, 0, 1, 51, 30, NULL, '2024-04-20 04:40:07', '2024-04-27 08:01:40', NULL),
            (622, 'USG', NULL, '', 'TEXT', 'USG', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (623, 'RHEUMATOID FACTOR (RA)', NULL, '', 'TEXT', 'RHEUMATOID_FACTOR_(RA)', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '<20', 'RANGE', NULL, 0, 1, 33, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (624, 'IMPRESSION', NULL, NULL, 'TEXT', 'IMPRESSION', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-06 11:12:01', NULL),
            (625, 'CALCIUM - Ionized', NULL, '', 'TEXT', 'CALCIUM_-_IONIZED', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '1.15 - 1.40', 'RANGE', NULL, 0, 1, 11, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (626, 'ALBUMIN -', NULL, NULL, 'TEXT', 'ALBUMIN_-', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-05-01 11:23:57', NULL),
            (627, 'CALCIUM- Ionized', NULL, '', 'TEXT', 'CALCIUM-_IONIZED', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '1.15 - 1.40', 'TEXT', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL);");

      \DB::statement("
            INSERT INTO `test_items` (`id`, `name`, `short_name`, `formula_code`, `input_type`, `code`, `item_type`, `test_number`, `default_result`, `result_source`, `result_guide`, `reference_value`, `reference_value_type`, `details`, `is_read_only`, `status`, `primary_unit_id`, `test_method_id`, `machine_id`, `created_at`, `updated_at`, `deleted_at`) VALUES 
            (628, 'PHOSPHOROUS', NULL, NULL, 'TEXT', 'PHOSPHOROUS', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '2.50-5.00', 'RANGE', NULL, 0, 1, 7, 58, NULL, '2024-04-20 04:40:07', '2024-04-30 06:07:59', NULL),
            (629, 'COMMENTS', NULL, '', 'TEXT', 'COMMENTS', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'TEXT', NULL, 0, 1, 12, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (630, 'SICKLING', NULL, 'H042', 'TEXT', 'SICKLING', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '', 'RANGE', NULL, 0, 1, 20, 0, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (631, 'LDH', NULL, '', 'TEXT', 'LDH', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '103 - 227', 'RANGE', NULL, 0, 1, 18, 31, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (632, 'HAV IGM RAPID', NULL, NULL, 'TEXT', 'HAV_IGM_RAPID', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, 42, NULL, '2024-04-20 04:40:07', '2024-04-29 09:27:14', NULL),
            (633, 'Comment -', NULL, NULL, 'TEXT', 'COMMENT_-', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-04-29 09:27:21', NULL),
            (634, 'HEV IGM RAPID', NULL, NULL, 'TEXT', 'HEV_IGM_RAPID', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, 42, NULL, '2024-04-20 04:40:07', '2024-05-06 10:04:20', NULL),
            (635, 'Comment -', NULL, NULL, 'TEXT', 'COMMENT_-', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:07', '2024-04-29 10:54:38', NULL),
            (636, 'IgE', NULL, '', 'TEXT', 'IGE', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, ' AGE RANGE_x000D_ _x005F_x000D__x000D_ < 1 Yrs 1.4 - 53_x000D_ _x005F_x000D__x000D_ 1 - 4 yrs 0.4 - 352_x000D_ _x005F_x000D__x000D_ 5 - 10 yrs 0.5 - 393_x000D_ _x005F_x000D__x000D_ 11 - 15 yrs 1.9 - 170_x000D_ _x005F_x000D__x000D_ > 15yrs 2.0 - 306', 'RANGE', NULL, 0, 1, 16, 9, NULL, '2024-04-20 04:40:07', '2024-04-20 04:40:07', NULL),
            (637, 'Vitamin D3', NULL, NULL, 'TEXT', 'VITAMIN_D3', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 7, NULL, NULL, '2024-04-20 04:40:08', '2024-05-01 11:35:25', NULL),
            (638, 'HELICOBACTER PYLORI ANTIGEN :', NULL, NULL, 'TEXT', 'HELICOBACTER_PYLORI_ANTIGEN_:', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:08', '2024-05-06 09:10:37', NULL),
            (639, 'D-DIMER', NULL, '', 'TEXT', 'D-DIMER', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, '<0.5', 'RANGE', NULL, 0, 1, 47, 39, NULL, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
            (640, 'DIFFERENTIAL LEUKOCYTE COUNT', NULL, NULL, 'TEXT', 'DIFFERENTIAL_LEUKOCYTE_COUNT', 'TEST_LABEL', NULL, NULL, 'MANUAL', NULL, NULL, 'RANGE', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:08', '2024-04-29 11:15:28', NULL),
            (641, 'IgG Antigen :', NULL, NULL, 'TEXT', 'IGG_ANTIGEN_:', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:08', '2024-05-04 11:55:29', NULL),
            (642, 'IgM Antigen :', NULL, NULL, 'TEXT', 'IGM_ANTIGEN_:', 'TEST_ITEM', NULL, NULL, 'MANUAL', NULL, NULL, 'OPTIONS', NULL, 0, 1, 12, NULL, NULL, '2024-04-20 04:40:08', '2024-05-04 11:55:36', NULL),
            (643, 'PLCR', 'PLCR', NULL, 'NUMBER', 'PLCR', 'TEST_ITEM', NULL, NULL, NULL, NULL, NULL, 'RANGE', NULL, 0, 1, 1, NULL, NULL, '2024-04-20 10:31:45', '2024-04-26 09:39:28', NULL),
            (644, 'CPK ( CREATINE KINASE )', NULL, NULL, 'NUMBER', 'CPK_(_CREATINE_KINASE_)', 'TEST_ITEM', NULL, NULL, NULL, NULL, NULL, 'RANGE', NULL, 0, 1, NULL, NULL, NULL, '2024-04-22 07:43:53', '2024-04-27 08:48:05', NULL),
            (645, 'CST REPORT', 'CST REPORT', NULL, 'NUMBER', 'CST_REPORT', 'TEST_ITEM', NULL, NULL, NULL, NULL, NULL, 'RANGE', NULL, 0, 1, NULL, 4, NULL, '2024-04-29 11:48:22', '2024-05-01 09:51:21', NULL),
            (646, 'AURAL SWAB CST', 'AURAL SWAB CST', NULL, 'NUMBER', 'AURAL_SWAB_CST', 'TEST_ITEM', NULL, NULL, NULL, NULL, NULL, 'RANGE', NULL, 0, 1, NULL, NULL, NULL, '2024-04-29 11:48:53', '2024-05-01 09:51:24', NULL),
            (647, 'ACTIVATED PARTIAL THROMBOPLASTIN TIME (APTT)', 'ACTIVATED PARTIAL THROMBOPLASTIN TIME (APTT)', NULL, 'NUMBER', 'ACTIVATED_PARTIAL_THROMBOPLASTIN_TIME_(APTT)', 'TEST_ITEM', NULL, NULL, NULL, NULL, NULL, 'RANGE', NULL, 0, 1, NULL, NULL, NULL, '2024-05-02 07:11:12', '2024-05-02 07:11:12', NULL),
            (648, 'ADENOSINE DEAMINASE (AD)', 'ADENOSINE DEAMINASE (AD)', NULL, 'NUMBER', 'ADENOSINE_DEAMINASE_(AD)', 'TEST_ITEM', NULL, NULL, NULL, NULL, NULL, 'RANGE', NULL, 0, 1, NULL, NULL, NULL, '2024-05-02 07:18:34', '2024-05-02 07:18:43', NULL),
            (649, 'ALT (SGPT)', 'ALT (SGPT)', NULL, 'NUMBER', 'ALT_(SGPT)', 'TEST_ITEM', NULL, NULL, NULL, NULL, NULL, 'RANGE', NULL, 0, 1, NULL, NULL, NULL, '2024-05-02 07:28:24', '2024-05-02 07:28:32', NULL),
            (650, 'DIRECT -LDL CHOLESTEROL', NULL, NULL, 'NUMBER', 'DIRECT_-LDL_CHOLESTEROL', 'TEST_ITEM', NULL, NULL, NULL, NULL, NULL, 'OPTIONS', NULL, 0, 1, NULL, NULL, NULL, '2024-05-02 10:37:52', '2024-05-04 07:54:38', NULL),
            (651, 'GLOBULIN', 'GLOBULIN', NULL, 'NUMBER', 'GLOBULIN', 'TEST_ITEM', NULL, NULL, NULL, NULL, NULL, 'RANGE', NULL, 0, 1, NULL, NULL, NULL, '2024-05-02 11:29:13', '2024-05-02 11:29:19', NULL),
            (652, 'PUS CST- CULTURE AEROBIC & SUSCEPTIBILITY', 'PUS CST- CULTURE AEROBIC & SUSCEPTIBILITY', NULL, 'NUMBER', 'PUS_CST-_CULTURE_AEROBIC_&_SUSCEPTIBILITY', 'TEST_ITEM', NULL, NULL, NULL, NULL, NULL, 'RANGE', NULL, 0, 1, NULL, NULL, NULL, '2024-05-03 08:03:32', '2024-05-03 08:03:32', NULL),
            (653, 'SEROLOGY PROFILE', 'SEROLOGY PROFILE', NULL, 'NUMBER', 'SEROLOGY_PROFILE', 'TEST_ITEM', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, NULL, NULL, NULL, '2024-05-03 09:19:12', '2024-05-03 09:19:12', NULL),
            (654, 'SERUM AMYLASE', 'SERUM AMYLASE', NULL, 'NUMBER', 'SERUM_AMYLASE', 'TEST_ITEM', NULL, NULL, NULL, NULL, NULL, 'RANGE', NULL, 0, 1, NULL, NULL, NULL, '2024-05-03 09:20:43', '2024-05-03 09:20:43', NULL),
            (655, 'SERUM UREA', 'SERUM UREA', NULL, 'NUMBER', 'SERUM_UREA', 'TEST_ITEM', NULL, NULL, NULL, NULL, NULL, 'RANGE', NULL, 0, 1, NULL, NULL, NULL, '2024-05-03 09:25:58', '2024-05-03 09:25:58', NULL),
            (656, 'SERUM ASCITES ALBUMIN GRADIENT (SAAG)', 'SERUM ASCITES ALBUMIN GRADIENT (SAAG)', NULL, 'NUMBER', 'SERUM_ASCITES_ALBUMIN_GRADIENT_(SAAG)', 'TEST_ITEM', NULL, NULL, NULL, NULL, NULL, 'RANGE', NULL, 0, 1, NULL, NULL, NULL, '2024-05-03 09:38:17', '2024-05-03 09:38:17', NULL),
            (657, 'STOOL OBT', 'STOOL OBT', NULL, 'NUMBER', 'STOOL_OBT', 'TEST_ITEM', NULL, NULL, NULL, NULL, NULL, 'OPTIONS', NULL, 0, 1, NULL, NULL, NULL, '2024-05-03 10:30:16', '2024-05-06 12:37:41', NULL),
            (658, 'THROAT SWAB', 'THROAT SWAB', NULL, 'NUMBER', 'THROAT_SWAB', 'TEST_ITEM', NULL, NULL, NULL, NULL, NULL, 'RANGE', NULL, 0, 1, NULL, NULL, NULL, '2024-05-03 10:39:42', '2024-05-03 10:39:42', NULL),
            (659, 'URETHRAL DISCHARGE', 'URETHRAL DISCHARGE', NULL, 'NUMBER', 'URETHRAL_DISCHARGE', 'TEST_ITEM', NULL, NULL, NULL, NULL, NULL, 'RANGE', NULL, 0, 1, NULL, NULL, NULL, '2024-05-03 11:17:10', '2024-05-03 11:17:10', NULL),
            (660, 'URINE- UROBILINOGEN', 'URINE- UROBILINOGEN', NULL, 'NUMBER', 'URINE-_UROBILINOGEN', 'TEST_ITEM', NULL, NULL, NULL, NULL, NULL, 'RANGE', NULL, 0, 1, NULL, NULL, NULL, '2024-05-03 11:49:13', '2024-05-03 11:49:13', NULL),
            (661, 'Vitamin D Hydroxy', 'Vitamin D Hydroxy', NULL, 'NUMBER', 'VITAMIN_D_HYDROXY', 'TEST_ITEM', NULL, NULL, NULL, NULL, NULL, 'RANGE', NULL, 0, 1, NULL, NULL, NULL, '2024-05-03 11:59:23', '2024-05-03 11:59:23', NULL),
            (662, 'BLOOD SMEAR FOR MP', 'BLOOD SMEAR FOR MP', NULL, 'NUMBER', 'BLOOD_SMEAR_FOR_MP', 'TEST_ITEM', NULL, NULL, NULL, NULL, NULL, 'OPTIONS', NULL, 0, 1, NULL, NULL, NULL, '2024-05-04 07:42:25', '2024-05-04 07:42:25', NULL),
            (663, 'IMPRESSION', 'IMPRESSION', NULL, 'NUMBER', 'IMPRESSION', 'TEST_ITEM', NULL, NULL, NULL, NULL, NULL, 'OPTIONS', NULL, 0, 1, NULL, NULL, NULL, '2024-05-04 08:19:09', '2024-05-04 08:19:18', NULL),
            (664, 'CHLORIDE (Cl-)', 'CHLORIDE (Cl-)', NULL, 'NUMBER', 'CHLORIDE_(CL-)', 'TEST_ITEM', NULL, NULL, NULL, NULL, NULL, 'OPTIONS', NULL, 0, 1, NULL, NULL, NULL, '2024-05-04 08:44:12', '2024-05-04 08:44:12', NULL),
            (665, 'Semple Collection Date:', 'Semple Collection Date:', NULL, 'NUMBER', 'SEMPLE_COLLECTION_DATE:', 'TEST_ITEM', NULL, NULL, NULL, NULL, NULL, 'OPTIONS', NULL, 0, 1, NULL, NULL, NULL, '2024-05-04 09:07:19', '2024-05-04 09:07:19', NULL),
            (666, 'Semple Collection Time:', 'Semple Collection Time:', NULL, 'NUMBER', 'SEMPLE_COLLECTION_TIME:', 'TEST_ITEM', NULL, NULL, NULL, NULL, NULL, 'OPTIONS', NULL, 0, 1, NULL, NULL, NULL, '2024-05-04 09:08:05', '2024-05-04 09:08:05', NULL),
            (667, 'Reporting Date:', 'Reporting Date:', NULL, 'NUMBER', 'REPORTING_DATE:', 'TEST_ITEM', NULL, NULL, NULL, NULL, NULL, 'OPTIONS', NULL, 0, 1, NULL, NULL, NULL, '2024-05-04 09:09:01', '2024-05-04 09:09:01', NULL),
            (668, 'Reporting Time:', 'Reporting Time:', NULL, 'NUMBER', 'REPORTING_TIME:', 'TEST_ITEM', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, NULL, NULL, NULL, '2024-05-04 09:17:40', '2024-05-04 09:17:40', NULL),

            (670, 'VENEREAL DISEASE RESEARCH L..', 'VENEREAL DISEASE RESEARCH L..', NULL, 'NUMBER', 'VENEREAL_DISEASE_RESEARCH_L..', 'TEST_ITEM', NULL, NULL, NULL, NULL, NULL, 'OPTIONS', NULL, 0, 1, NULL, NULL, NULL, '2024-05-07 08:20:07', '2024-05-07 08:20:07', NULL),
            (671, 'S PARATYPHI \"BH\" ANTIGEN TITRE', 'S PARATYPHI \"BH\" ANTIGEN TITRE', NULL, 'NUMBER', 'S_PARATYPHI_\"BH\"_ANTIGEN_TITRE', 'TEST_ITEM', NULL, NULL, NULL, NULL, NULL, 'OPTIONS', NULL, 0, 1, NULL, NULL, NULL, '2024-05-07 08:28:18', '2024-05-07 09:35:26', NULL),
            (672, 'S PARATYPHI \"AH\" ANTIGEN TITRE', 'S PARATYPHI \"AH\" ANTIGEN TITRE', NULL, 'NUMBER', 'S_PARATYPHI_\"AH\"_ANTIGEN_TITRE', 'TEST_ITEM', NULL, NULL, NULL, NULL, NULL, 'OPTIONS', NULL, 0, 1, NULL, NULL, NULL, '2024-05-07 09:35:59', '2024-05-07 09:35:59', NULL),
            (673, 'S TYPHI \"H\" ANTIGEN TITRE', 'S TYPHI \"H\" ANTIGEN TITRE', NULL, 'NUMBER', 'S_TYPHI_\"H\"_ANTIGEN_TITRE', 'TEST_ITEM', NULL, NULL, NULL, NULL, NULL, 'OPTIONS', NULL, 0, 1, NULL, NULL, NULL, '2024-05-07 09:36:24', '2024-05-07 09:36:24', NULL),
            (674, 'S TYPHI \"O\" ANTIGEN TITRE', 'S TYPHI \"O\" ANTIGEN TITRE', NULL, 'NUMBER', 'S_TYPHI_\"O\"_ANTIGEN_TITRE', 'TEST_ITEM', NULL, NULL, NULL, NULL, NULL, 'OPTIONS', NULL, 0, 1, NULL, NULL, NULL, '2024-05-07 09:36:46', '2024-05-07 09:37:12', NULL),
            (675, 'ACIDIC FLUID', 'ACIDIC FLUID', NULL, 'NUMBER', 'ACIDIC_FLUID', 'TEST_ITEM', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 1, NULL, NULL, NULL, '2024-05-07 12:19:37', '2024-05-07 12:19:37', NULL),
            (676, 'ASO(SLIDE)', 'ASO(SLIDE)', NULL, 'NUMBER', 'ASO(SLIDE)', 'TEST_ITEM', NULL, NULL, NULL, NULL, NULL, 'OPTIONS', NULL, 0, 1, NULL, NULL, NULL, '2024-05-08 09:47:06', '2024-05-08 09:47:06', NULL);
      ");


      
      \DB::statement("INSERT INTO `test_package_group_test_items` (`id`, `test_package_id`, `test_package_group_id`, `status`, `priority`, `test_item_id`, `created_at`, `updated_at`, `deleted_at`) VALUES
              (1, 19, 19, 1, 1, 1, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (2, 45, 45, 1, 2, 2, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (3, 1, 1, 1, 27, 3, '2024-04-20 04:40:08', '2024-05-02 10:33:26', NULL),
              (4, 1, 1, 1, 28, 4, '2024-04-20 04:40:08', '2024-05-02 10:33:26', NULL),
              (5, 1, 1, 1, 29, 5, '2024-04-20 04:40:08', '2024-05-02 10:33:26', NULL),
              (6, 1, 1, 1, 30, 6, '2024-04-20 04:40:08', '2024-05-02 10:33:26', NULL),
              (7, 1, 1, 1, 31, 7, '2024-04-20 04:40:08', '2024-05-02 10:33:26', NULL),
              (8, 1, 1, 1, 3, 8, '2024-04-20 04:40:08', '2024-05-02 10:33:26', NULL),
              (9, 1, 1, 1, 1, 9, '2024-04-20 04:40:08', '2024-05-02 10:33:26', NULL),
              (10, 1, 1, 1, 7, 10, '2024-04-20 04:40:08', '2024-05-02 10:33:26', NULL),
              (11, 1, 1, 1, 8, 11, '2024-04-20 04:40:08', '2024-05-02 10:33:26', NULL),
              (12, 1, 1, 1, 9, 12, '2024-04-20 04:40:08', '2024-05-02 10:33:26', NULL),
              (13, 1, 1, 1, 10, 13, '2024-04-20 04:40:08', '2024-05-02 10:33:26', NULL),
              (14, 1, 1, 1, 12, 14, '2024-04-20 04:40:08', '2024-05-02 10:33:26', NULL),
              (15, 1, 1, 1, 4, 15, '2024-04-20 04:40:08', '2024-05-02 10:33:26', NULL),
              (16, 2, 2, 1, 16, 16, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (17, 3, 3, 1, 17, 17, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (18, 3, 3, 1, 18, 18, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (19, 3, 3, 1, 19, 19, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (20, 3, 3, 1, 20, 20, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (21, 3, 3, 1, 21, 21, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (22, 4, 4, 1, 22, 22, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (23, 5, 5, 1, 23, 23, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (24, 6, 6, 1, 24, 24, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (25, 7, 7, 1, 25, 25, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (26, 10, 10, 1, 26, 26, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (27, 11, 11, 1, 27, 27, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (28, 8, 8, 1, 28, 28, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (29, 9, 9, 1, 29, 29, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (30, 12, 12, 1, 30, 30, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (31, 13, 13, 1, 31, 31, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (32, 16, 16, 1, 32, 32, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (33, 51, 51, 1, 33, 33, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (34, 51, 51, 1, 34, 34, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (35, 56, 56, 1, 35, 35, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (36, 57, 57, 1, 36, 36, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (37, 96, 96, 1, 37, 37, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (38, 23, 23, 1, 38, 38, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (39, 19, 19, 1, 39, 39, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (40, 38, 38, 1, 40, 40, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (41, 39, 39, 1, 41, 41, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (42, 37, 37, 1, 42, 42, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (43, 24, 24, 1, 43, 43, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (44, 74, 74, 1, 44, 44, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (45, 34, 34, 1, 45, 45, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (46, 31, 31, 1, 46, 46, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (47, 43, 43, 1, 47, 47, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (48, 52, 52, 1, 2, 48, '2024-04-20 04:40:08', '2024-04-30 08:13:59', NULL),
              (49, 52, 52, 1, 4, 49, '2024-04-20 04:40:08', '2024-04-30 08:13:59', NULL),
              (50, 52, 52, 1, 3, 50, '2024-04-20 04:40:08', '2024-04-30 08:13:59', NULL),
              (51, 52, 52, 1, 5, 51, '2024-04-20 04:40:08', '2024-04-30 08:13:59', NULL),
              (52, 52, 52, 1, 8, 52, '2024-04-20 04:40:08', '2024-04-30 08:13:59', NULL),
              (53, 52, 52, 1, 9, 53, '2024-04-20 04:40:08', '2024-04-30 08:13:59', NULL),
              (54, 52, 52, 1, 10, 54, '2024-04-20 04:40:08', '2024-04-30 08:13:59', NULL),
              (55, 52, 52, 1, 11, 55, '2024-04-20 04:40:08', '2024-04-30 08:13:59', NULL),
              (56, 52, 52, 1, 13, 56, '2024-04-20 04:40:08', '2024-04-30 08:13:59', NULL),
              (57, 52, 52, 1, 12, 57, '2024-04-20 04:40:08', '2024-04-30 08:13:59', NULL),
              (58, 52, 52, 1, 15, 58, '2024-04-20 04:40:08', '2024-04-30 08:13:59', NULL),
              (59, 52, 52, 1, 17, 59, '2024-04-20 04:40:08', '2024-04-30 08:13:59', NULL),
              (60, 52, 52, 1, 19, 60, '2024-04-20 04:40:08', '2024-04-30 08:13:59', NULL),
              (61, 52, 52, 1, 20, 61, '2024-04-20 04:40:08', '2024-04-30 08:13:59', NULL),
              (62, 52, 52, 1, 21, 62, '2024-04-20 04:40:08', '2024-04-30 08:13:59', NULL),
              (63, 54, 54, 1, 63, 63, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (64, 54, 54, 1, 64, 64, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (65, 54, 54, 1, 65, 65, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (66, 54, 54, 1, 66, 66, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (67, 54, 54, 1, 67, 67, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (68, 54, 54, 1, 68, 68, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (69, 17, 17, 1, 69, 69, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (70, 18, 18, 1, 70, 70, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (71, 21, 21, 1, 71, 71, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (72, 22, 22, 1, 72, 72, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (73, 49, 49, 1, 73, 73, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (74, 46, 46, 1, 74, 74, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (75, 45, 45, 1, 75, 75, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (76, 45, 45, 1, 76, 76, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (77, 44, 44, 1, 77, 77, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (78, 42, 42, 1, 78, 78, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (79, 41, 41, 1, 1, 79, '2024-04-20 04:40:08', '2024-04-30 06:07:05', NULL),
              (80, 41, 41, 1, 2, 80, '2024-04-20 04:40:08', '2024-04-30 06:07:05', NULL),
              (81, 41, 41, 1, 3, 81, '2024-04-20 04:40:08', '2024-04-30 06:07:05', NULL),
              (82, 36, 36, 1, 82, 82, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (83, 35, 35, 1, 83, 83, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (84, 33, 33, 1, 84, 84, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (85, 32, 32, 1, 85, 85, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (86, 30, 30, 1, 86, 86, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (87, 29, 29, 1, 87, 87, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (88, 28, 28, 1, 88, 88, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (89, 27, 27, 1, 89, 89, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (90, 26, 26, 1, 90, 90, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (91, 25, 25, 1, 91, 91, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (92, 53, 53, 1, 92, 92, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (93, 53, 53, 1, 93, 93, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (94, 53, 53, 1, 94, 94, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (95, 53, 53, 1, 95, 95, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (96, 53, 53, 1, 96, 96, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (97, 53, 53, 1, 97, 97, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (98, 53, 53, 1, 98, 98, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (99, 53, 53, 1, 99, 99, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (100, 53, 53, 1, 100, 100, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (101, 53, 53, 1, 101, 101, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (102, 53, 53, 1, 102, 102, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (103, 53, 53, 1, 103, 103, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (104, 53, 53, 1, 104, 104, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (105, 53, 53, 1, 105, 105, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (106, 53, 53, 1, 106, 106, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (107, 53, 53, 1, 107, 107, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (108, 53, 53, 1, 108, 108, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (109, 15, 15, 1, 1, 109, '2024-04-20 04:40:08', '2024-05-01 09:52:54', NULL),
              (110, 15, 15, 1, 2, 110, '2024-04-20 04:40:08', '2024-05-01 09:52:54', NULL),
              (111, 15, 15, 1, 3, 111, '2024-04-20 04:40:08', '2024-05-01 09:52:54', NULL),
              (112, 15, 15, 1, 4, 112, '2024-04-20 04:40:08', '2024-05-01 09:52:54', NULL),
              (113, 15, 15, 1, 5, 113, '2024-04-20 04:40:08', '2024-05-01 09:52:54', NULL),
              (114, 15, 15, 1, 6, 114, '2024-04-20 04:40:08', '2024-05-01 09:52:54', NULL),
              (115, 15, 15, 1, 7, 115, '2024-04-20 04:40:08', '2024-05-01 09:52:54', NULL),
              (116, 15, 15, 1, 8, 116, '2024-04-20 04:40:08', '2024-05-01 09:52:54', NULL),
              (117, 15, 15, 1, 9, 117, '2024-04-20 04:40:08', '2024-05-01 09:52:54', NULL),
              (118, 15, 15, 1, 10, 118, '2024-04-20 04:40:08', '2024-05-01 09:52:54', NULL),
              (119, 15, 15, 1, 11, 119, '2024-04-20 04:40:08', '2024-05-01 09:52:54', NULL),
              (120, 15, 15, 1, 12, 120, '2024-04-20 04:40:08', '2024-05-01 09:52:54', NULL),
              (121, 15, 15, 1, 13, 121, '2024-04-20 04:40:08', '2024-05-01 09:52:54', NULL),
              (122, 15, 15, 1, 14, 122, '2024-04-20 04:40:08', '2024-05-01 09:52:54', NULL),
              (123, 15, 15, 1, 15, 123, '2024-04-20 04:40:08', '2024-05-01 09:52:54', NULL),
              (124, 15, 15, 1, 16, 124, '2024-04-20 04:40:08', '2024-05-01 09:52:54', NULL),
              (125, 15, 15, 1, 17, 125, '2024-04-20 04:40:08', '2024-05-01 09:52:54', NULL),
              (126, 15, 15, 1, 18, 126, '2024-04-20 04:40:08', '2024-05-01 09:52:54', NULL),
              (127, 70, 70, 1, 127, 127, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (128, 70, 70, 1, 128, 128, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (129, 70, 70, 1, 129, 129, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (130, 70, 70, 1, 130, 130, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (131, 70, 70, 1, 131, 131, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (132, 70, 70, 1, 132, 132, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (133, 70, 70, 1, 133, 133, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (134, 70, 70, 1, 134, 134, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (135, 70, 70, 1, 135, 135, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (136, 70, 70, 1, 136, 136, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (137, 70, 70, 1, 137, 137, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (138, 70, 70, 1, 138, 138, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (139, 70, 70, 1, 139, 139, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (140, 70, 70, 1, 140, 140, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (141, 70, 70, 1, 141, 141, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (142, 70, 70, 1, 142, 142, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (143, 90, 90, 1, 143, 143, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (144, 90, 90, 1, 144, 144, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (145, 90, 90, 1, 145, 145, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (146, 90, 90, 1, 146, 146, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (147, 90, 90, 1, 147, 147, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (148, 90, 90, 1, 148, 148, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (149, 90, 90, 1, 149, 149, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (150, 90, 90, 1, 150, 150, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (151, 90, 90, 1, 151, 151, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (152, 90, 90, 1, 152, 152, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (153, 90, 90, 1, 153, 153, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (154, 90, 90, 1, 154, 154, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (155, 90, 90, 1, 155, 155, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (156, 90, 90, 1, 156, 156, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (157, 90, 90, 1, 157, 157, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (158, 90, 90, 1, 158, 158, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (159, 90, 90, 1, 159, 159, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (160, 90, 90, 1, 160, 160, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (161, 90, 90, 1, 161, 161, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (162, 90, 90, 1, 162, 162, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (163, 90, 90, 1, 163, 163, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (164, 90, 90, 1, 164, 164, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (165, 90, 90, 1, 165, 165, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (166, 103, 103, 1, 166, 166, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (167, 103, 103, 1, 167, 167, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (168, 103, 103, 1, 168, 168, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (169, 103, 103, 1, 169, 169, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (170, 103, 103, 1, 170, 170, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (171, 103, 103, 1, 171, 171, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (172, 103, 103, 1, 172, 172, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (173, 103, 103, 1, 173, 173, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (174, 103, 103, 1, 174, 174, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (175, 103, 103, 1, 175, 175, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (176, 103, 103, 1, 176, 176, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (177, 103, 103, 1, 177, 177, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (178, 103, 103, 1, 178, 178, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (179, 103, 103, 1, 179, 179, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (180, 103, 103, 1, 180, 180, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (181, 103, 103, 1, 181, 181, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (182, 103, 103, 1, 182, 182, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (183, 103, 103, 1, 183, 183, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (184, 103, 103, 1, 184, 184, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (185, 103, 103, 1, 185, 185, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (186, 103, 103, 1, 186, 186, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (187, 105, 105, 1, 2, 187, '2024-04-20 04:40:08', '2024-05-02 09:59:55', NULL),
              (188, 105, 105, 1, 3, 188, '2024-04-20 04:40:08', '2024-05-02 09:59:55', NULL),
              (189, 105, 105, 1, 4, 189, '2024-04-20 04:40:08', '2024-05-02 09:59:55', NULL),
              (190, 105, 105, 1, 5, 190, '2024-04-20 04:40:08', '2024-05-02 09:59:55', NULL),
              (191, 105, 105, 1, 6, 191, '2024-04-20 04:40:08', '2024-05-02 09:59:55', NULL),
              (192, 105, 105, 1, 7, 192, '2024-04-20 04:40:08', '2024-05-02 09:59:55', NULL),
              (193, 105, 105, 1, 8, 193, '2024-04-20 04:40:08', '2024-05-02 09:59:55', NULL),
              (194, 105, 105, 1, 9, 194, '2024-04-20 04:40:08', '2024-05-02 09:59:55', NULL),
              (195, 105, 105, 1, 10, 195, '2024-04-20 04:40:08', '2024-05-02 09:59:55', NULL),
              (196, 105, 105, 1, 11, 196, '2024-04-20 04:40:08', '2024-05-02 09:59:55', NULL),
              (197, 105, 105, 1, 12, 197, '2024-04-20 04:40:08', '2024-05-02 09:59:55', NULL),
              (198, 105, 105, 1, 13, 198, '2024-04-20 04:40:08', '2024-05-02 09:59:55', NULL),
              (199, 105, 105, 1, 14, 199, '2024-04-20 04:40:08', '2024-05-02 09:59:55', NULL),
              (200, 105, 105, 1, 15, 200, '2024-04-20 04:40:08', '2024-05-02 09:59:55', NULL),
              (201, 105, 105, 1, 16, 201, '2024-04-20 04:40:08', '2024-05-02 09:59:55', NULL),
              (202, 105, 105, 1, 17, 202, '2024-04-20 04:40:08', '2024-05-02 09:59:55', NULL),
              (203, 105, 105, 1, 18, 203, '2024-04-20 04:40:08', '2024-05-02 09:59:55', NULL),
              (204, 105, 105, 1, 19, 204, '2024-04-20 04:40:08', '2024-05-02 09:59:55', NULL),
              (205, 105, 105, 1, 20, 205, '2024-04-20 04:40:08', '2024-05-02 09:59:55', NULL),
              (206, 105, 105, 1, 21, 206, '2024-04-20 04:40:08', '2024-05-02 09:59:55', NULL),
              (207, 105, 105, 1, 22, 207, '2024-04-20 04:40:08', '2024-05-02 09:59:55', NULL),
              (208, 55, 55, 1, 3, 208, '2024-04-20 04:40:08', '2024-04-29 12:23:29', NULL),
              (209, 55, 55, 1, 4, 209, '2024-04-20 04:40:08', '2024-04-29 12:23:29', NULL),
              (210, 55, 55, 1, 7, 210, '2024-04-20 04:40:08', '2024-04-29 12:23:29', NULL),
              (211, 55, 55, 1, 5, 211, '2024-04-20 04:40:08', '2024-04-29 12:23:29', NULL),
              (212, 55, 55, 1, 6, 212, '2024-04-20 04:40:08', '2024-04-29 12:23:29', NULL),
              (213, 55, 55, 1, 2, 213, '2024-04-20 04:40:08', '2024-04-29 12:23:29', NULL),
              (214, 64, 64, 1, 214, 214, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (215, 58, 58, 1, 215, 215, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (216, 58, 58, 1, 216, 216, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (217, 58, 58, 1, 217, 217, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (218, 59, 59, 1, 218, 218, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (219, 60, 60, 1, 219, 219, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (220, 60, 60, 1, 220, 220, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (221, 60, 60, 1, 221, 221, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (222, 61, 61, 1, 222, 222, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (223, 61, 61, 1, 223, 223, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (224, 61, 61, 1, 224, 224, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (225, 62, 62, 1, 4, 225, '2024-04-20 04:40:08', '2024-05-01 10:03:40', NULL),
              (226, 62, 62, 1, 5, 226, '2024-04-20 04:40:08', '2024-05-01 10:03:40', NULL),
              (227, 62, 62, 1, 3, 227, '2024-04-20 04:40:08', '2024-05-01 10:03:40', NULL),
              (228, 62, 62, 1, 8, 228, '2024-04-20 04:40:08', '2024-05-01 10:03:40', NULL),
              (229, 79, 79, 1, 229, 229, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (230, 80, 80, 1, 230, 230, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (231, 82, 82, 1, 1, 231, '2024-04-20 04:40:08', '2024-04-30 07:24:17', NULL),
              (232, 82, 82, 1, 2, 232, '2024-04-20 04:40:08', '2024-04-30 07:24:17', NULL),
              (233, 82, 82, 1, 3, 233, '2024-04-20 04:40:08', '2024-04-30 07:24:17', NULL),
              (234, 82, 82, 1, 6, 234, '2024-04-20 04:40:08', '2024-04-30 07:24:17', NULL),
              (235, 82, 82, 1, 7, 235, '2024-04-20 04:40:08', '2024-04-30 07:24:17', NULL),
              (236, 82, 82, 1, 10, 236, '2024-04-20 04:40:08', '2024-04-30 07:24:17', NULL),
              (237, 82, 82, 1, 11, 237, '2024-04-20 04:40:08', '2024-04-30 07:24:17', NULL),
              (238, 82, 82, 1, 12, 238, '2024-04-20 04:40:08', '2024-04-30 07:24:17', NULL),
              (239, 82, 82, 1, 13, 239, '2024-04-20 04:40:08', '2024-04-30 07:24:17', NULL),
              (240, 82, 82, 1, 15, 240, '2024-04-20 04:40:08', '2024-04-30 07:24:17', NULL),
              (241, 82, 82, 1, 16, 241, '2024-04-20 04:40:08', '2024-04-30 07:24:17', NULL),
              (242, 82, 82, 1, 17, 242, '2024-04-20 04:40:08', '2024-04-30 07:24:17', NULL),
              (243, 82, 82, 1, 19, 243, '2024-04-20 04:40:08', '2024-04-30 07:24:17', NULL),
              (244, 82, 82, 1, 21, 244, '2024-04-20 04:40:08', '2024-04-30 07:24:17', NULL),
              (245, 83, 83, 1, 245, 245, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (246, 85, 85, 1, 246, 246, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (247, 85, 85, 1, 247, 247, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (248, 85, 85, 1, 248, 248, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (249, 85, 85, 1, 249, 249, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (250, 85, 85, 1, 250, 250, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (251, 85, 85, 1, 251, 251, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (252, 85, 85, 1, 252, 252, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (253, 85, 85, 1, 253, 253, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (254, 85, 85, 1, 254, 254, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (255, 85, 85, 1, 255, 255, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (256, 85, 85, 1, 256, 256, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (257, 85, 85, 1, 257, 257, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (258, 85, 85, 1, 258, 258, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (259, 85, 85, 1, 259, 259, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (260, 85, 85, 1, 260, 260, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (261, 85, 85, 1, 261, 261, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (262, 85, 85, 1, 262, 262, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (263, 85, 85, 1, 263, 263, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (264, 164, 164, 1, 264, 264, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (265, 87, 87, 1, 265, 265, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (266, 81, 81, 1, 266, 266, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (267, 99, 99, 1, 267, 267, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (268, 91, 91, 1, 268, 268, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (269, 92, 92, 1, 269, 269, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (270, 93, 93, 1, 270, 270, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (271, 94, 94, 1, 271, 271, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (272, 105, 105, 1, 1, 272, '2024-04-20 04:40:08', '2024-05-02 09:59:55', NULL),
              (273, 71, 71, 1, 273, 273, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (274, 66, 66, 1, 274, 274, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (275, 65, 65, 1, 275, 275, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (276, 75, 75, 1, 5, 276, '2024-04-20 04:40:08', '2024-04-30 06:56:55', NULL),
              (277, 75, 75, 1, 4, 277, '2024-04-20 04:40:08', '2024-04-30 06:56:55', NULL),
              (278, 75, 75, 1, 1, 278, '2024-04-20 04:40:08', '2024-04-30 06:56:55', NULL),
              (279, 109, 109, 1, 279, 279, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (280, 109, 109, 1, 280, 280, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (281, 109, 109, 1, 281, 281, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (282, 109, 109, 1, 282, 282, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (283, 109, 109, 1, 283, 283, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (284, 109, 109, 1, 284, 284, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (285, 109, 109, 1, 285, 285, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (286, 109, 109, 1, 286, 286, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (287, 109, 109, 1, 287, 287, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (288, 109, 109, 1, 288, 288, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (289, 109, 109, 1, 289, 289, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (290, 109, 109, 1, 290, 290, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (291, 109, 109, 1, 291, 291, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (292, 109, 109, 1, 292, 292, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (293, 109, 109, 1, 293, 293, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (294, 109, 109, 1, 294, 294, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (295, 109, 109, 1, 295, 295, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (296, 109, 109, 1, 296, 296, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (297, 109, 109, 1, 297, 297, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (298, 109, 109, 1, 298, 298, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (299, 109, 109, 1, 299, 299, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (300, 109, 109, 1, 300, 300, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (301, 109, 109, 1, 301, 301, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (302, 109, 109, 1, 302, 302, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (303, 109, 109, 1, 303, 303, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (304, 109, 109, 1, 304, 304, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (305, 109, 109, 1, 305, 305, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (306, 109, 109, 1, 306, 306, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (307, 109, 109, 1, 307, 307, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (308, 109, 109, 1, 308, 308, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (309, 109, 109, 1, 309, 309, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (310, 109, 109, 1, 310, 310, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (311, 109, 109, 1, 311, 311, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (312, 109, 109, 1, 312, 312, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (313, 109, 109, 1, 313, 313, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (314, 109, 109, 1, 314, 314, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (315, 109, 109, 1, 315, 315, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (316, 109, 109, 1, 316, 316, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (317, 109, 109, 1, 317, 317, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (318, 109, 109, 1, 318, 318, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (319, 109, 109, 1, 319, 319, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (320, 109, 109, 1, 320, 320, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (321, 109, 109, 1, 321, 321, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (322, 109, 109, 1, 322, 322, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (323, 109, 109, 1, 323, 323, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (324, 109, 109, 1, 324, 324, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (325, 109, 109, 1, 325, 325, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (326, 109, 109, 1, 326, 326, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (327, 109, 109, 1, 327, 327, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (328, 109, 109, 1, 328, 328, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (329, 109, 109, 1, 329, 329, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (330, 109, 109, 1, 330, 330, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (331, 109, 109, 1, 331, 331, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (332, 109, 109, 1, 332, 332, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (333, 109, 109, 1, 333, 333, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (334, 109, 109, 1, 334, 334, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (335, 109, 109, 1, 335, 335, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (336, 109, 109, 1, 336, 336, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (337, 109, 109, 1, 337, 337, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (338, 109, 109, 1, 338, 338, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (339, 78, 78, 1, 339, 339, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (340, 78, 78, 1, 340, 340, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (341, 81, 81, 1, 341, 341, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (342, 81, 81, 1, 342, 342, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (343, 69, 69, 1, 343, 343, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (344, 69, 69, 1, 344, 344, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (345, 111, 111, 1, 1, 345, '2024-04-20 04:40:08', '2024-04-29 11:16:16', NULL),
              (346, 111, 111, 1, 2, 346, '2024-04-20 04:40:08', '2024-04-29 11:16:16', NULL),
              (347, 111, 111, 1, 4, 347, '2024-04-20 04:40:08', '2024-04-29 11:16:16', NULL),
              (348, 111, 111, 1, 5, 348, '2024-04-20 04:40:08', '2024-04-29 11:16:16', NULL),
              (349, 111, 111, 1, 6, 349, '2024-04-20 04:40:08', '2024-04-29 11:16:16', NULL),
              (350, 111, 111, 1, 7, 350, '2024-04-20 04:40:08', '2024-04-29 11:16:16', NULL),
              (351, 111, 111, 1, 8, 351, '2024-04-20 04:40:08', '2024-04-29 11:16:16', NULL),
              (352, 1, 1, 1, 6, 352, '2024-04-20 04:40:08', '2024-05-02 10:33:26', NULL),
              (353, 112, 112, 1, 1, 353, '2024-04-20 04:40:08', '2024-04-30 06:51:55', NULL),
              (354, 18, 18, 1, 354, 354, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (355, 112, 112, 1, 3, 355, '2024-04-20 04:40:08', '2024-04-30 06:51:55', NULL),
              (356, 112, 112, 1, 4, 356, '2024-04-20 04:40:08', '2024-04-30 06:51:55', NULL),
              (357, 112, 112, 1, 5, 357, '2024-04-20 04:40:08', '2024-04-30 06:51:55', NULL),
              (358, 112, 112, 1, 6, 358, '2024-04-20 04:40:08', '2024-04-30 06:51:55', NULL),
              (359, 112, 112, 1, 7, 359, '2024-04-20 04:40:08', '2024-04-30 06:51:55', NULL),
              (360, 112, 112, 1, 8, 360, '2024-04-20 04:40:08', '2024-04-30 06:51:55', NULL),
              (361, 112, 112, 1, 9, 361, '2024-04-20 04:40:08', '2024-04-30 06:51:55', NULL),
              (362, 112, 112, 1, 10, 362, '2024-04-20 04:40:08', '2024-04-30 06:51:55', NULL),
              (363, 111, 111, 1, 12, 363, '2024-04-20 04:40:08', '2024-04-29 11:16:16', NULL),
              (364, 75, 75, 1, 6, 364, '2024-04-20 04:40:08', '2024-04-30 06:56:55', NULL),
              (365, 75, 75, 1, 7, 365, '2024-04-20 04:40:08', '2024-04-30 06:56:55', NULL),
              (366, 61, 61, 1, 366, 366, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (367, 61, 61, 1, 367, 367, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (368, 62, 62, 1, 2, 368, '2024-04-20 04:40:08', '2024-05-01 10:03:40', NULL),
              (369, 62, 62, 1, 6, 369, '2024-04-20 04:40:08', '2024-05-01 10:03:40', NULL),
              (370, 62, 62, 1, 7, 370, '2024-04-20 04:40:08', '2024-05-01 10:03:40', NULL),
              (371, 72, 72, 1, 371, 371, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (372, 57, 57, 1, 372, 372, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (373, 57, 57, 1, 373, 373, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (374, 22, 22, 1, 374, 374, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (375, 22, 22, 1, 375, 375, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (376, 112, 112, 1, 2, 376, '2024-04-20 04:40:08', '2024-04-30 06:51:55', NULL),
              (377, 18, 18, 1, 377, 377, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (378, 88, 88, 1, 378, 378, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (379, 88, 88, 1, 379, 379, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (380, 116, 116, 1, 380, 380, '2024-04-20 04:40:08', '2024-04-25 10:01:24', '2024-04-25 10:01:24'),
              (381, 116, 116, 1, 381, 381, '2024-04-20 04:40:08', '2024-04-25 10:01:24', '2024-04-25 10:01:24'),
              (382, 116, 116, 1, 382, 382, '2024-04-20 04:40:08', '2024-04-25 10:01:24', '2024-04-25 10:01:24'),
              (383, 82, 82, 1, 9, 383, '2024-04-20 04:40:08', '2024-04-30 07:24:17', NULL),
              (384, 82, 82, 1, 20, 384, '2024-04-20 04:40:08', '2024-04-30 07:24:17', NULL),
              (385, 117, 117, 1, 385, 385, '2024-04-20 04:40:08', '2024-04-20 04:40:08', NULL),
              (386, 117, 117, 1, 386, 386, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (387, 117, 117, 1, 387, 387, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (388, 118, 118, 1, 388, 388, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (389, 118, 118, 1, 389, 389, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (390, 118, 118, 1, 390, 390, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (391, 118, 118, 1, 391, 391, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (392, 118, 118, 1, 392, 392, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (393, 118, 118, 1, 393, 393, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (394, 118, 118, 1, 394, 394, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (395, 118, 118, 1, 395, 395, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (396, 118, 118, 1, 396, 396, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (397, 118, 118, 1, 397, 397, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (398, 118, 118, 1, 398, 398, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (399, 118, 118, 1, 399, 399, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (400, 118, 118, 1, 400, 400, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (401, 119, 119, 1, 401, 401, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (402, 119, 119, 1, 402, 402, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (403, 119, 119, 1, 403, 403, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (404, 97, 97, 1, 404, 404, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (405, 97, 97, 1, 405, 405, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (406, 97, 97, 1, 406, 406, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (407, 120, 120, 1, 407, 407, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (408, 120, 120, 1, 408, 408, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (409, 27, 27, 1, 411, 411, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (410, 110, 110, 1, 1, 412, '2024-04-20 04:40:09', '2024-04-30 07:11:22', NULL),
              (411, 110, 110, 1, 2, 413, '2024-04-20 04:40:09', '2024-04-30 07:11:22', NULL),
              (412, 110, 110, 1, 3, 414, '2024-04-20 04:40:09', '2024-04-30 07:11:22', NULL),
              (413, 110, 110, 1, 4, 415, '2024-04-20 04:40:09', '2024-04-30 07:11:22', NULL),
              (414, 110, 110, 1, 6, 416, '2024-04-20 04:40:09', '2024-04-30 07:11:22', NULL),
              (415, 110, 110, 1, 7, 417, '2024-04-20 04:40:09', '2024-04-30 07:11:22', NULL),
              (416, 110, 110, 1, 8, 418, '2024-04-20 04:40:09', '2024-04-30 07:11:22', NULL),
              (417, 110, 110, 1, 9, 419, '2024-04-20 04:40:09', '2024-04-30 07:11:22', NULL),
              (418, 110, 110, 1, 10, 420, '2024-04-20 04:40:09', '2024-04-30 07:11:22', NULL),
              (419, 110, 110, 1, 11, 421, '2024-04-20 04:40:09', '2024-04-30 07:11:22', NULL),
              (420, 110, 110, 1, 12, 422, '2024-04-20 04:40:09', '2024-04-30 07:11:22', NULL),
              (421, 110, 110, 1, 13, 423, '2024-04-20 04:40:09', '2024-04-30 07:11:22', NULL),
              (422, 110, 110, 1, 14, 424, '2024-04-20 04:40:09', '2024-04-30 07:11:22', NULL),
              (423, 110, 110, 1, 15, 425, '2024-04-20 04:40:09', '2024-04-30 07:11:22', NULL),
              (424, 110, 110, 1, 16, 426, '2024-04-20 04:40:09', '2024-04-30 07:11:22', NULL),
              (425, 110, 110, 1, 17, 427, '2024-04-20 04:40:09', '2024-04-30 07:11:22', NULL),
              (426, 110, 110, 1, 18, 428, '2024-04-20 04:40:09', '2024-04-30 07:11:22', NULL),
              (427, 110, 110, 1, 19, 429, '2024-04-20 04:40:09', '2024-04-30 07:11:22', NULL),
              (428, 110, 110, 1, 20, 430, '2024-04-20 04:40:09', '2024-04-30 07:11:22', NULL),
              (429, 110, 110, 1, 21, 431, '2024-04-20 04:40:09', '2024-04-30 07:11:22', NULL),
              (430, 110, 110, 1, 22, 432, '2024-04-20 04:40:09', '2024-04-30 07:11:22', NULL),
              (431, 110, 110, 1, 23, 433, '2024-04-20 04:40:09', '2024-04-30 07:11:22', NULL),
              (432, 110, 110, 1, 24, 434, '2024-04-20 04:40:09', '2024-04-30 07:11:22', NULL),
              (433, 110, 110, 1, 25, 435, '2024-04-20 04:40:09', '2024-04-30 07:11:22', NULL),
              (434, 111, 111, 1, 9, 436, '2024-04-20 04:40:09', '2024-04-29 11:16:16', NULL),
              (435, 111, 111, 1, 10, 437, '2024-04-20 04:40:09', '2024-04-29 11:16:16', NULL),
              (436, 111, 111, 1, 11, 438, '2024-04-20 04:40:09', '2024-04-29 11:16:16', NULL),
              (437, 111, 111, 1, 13, 439, '2024-04-20 04:40:09', '2024-04-29 11:16:16', NULL),
              (438, 111, 111, 1, 14, 440, '2024-04-20 04:40:09', '2024-04-29 11:16:16', NULL),
              (439, 111, 111, 1, 15, 441, '2024-04-20 04:40:09', '2024-04-29 11:16:16', NULL),
              (440, 111, 111, 1, 16, 442, '2024-04-20 04:40:09', '2024-04-29 11:16:16', NULL),
              (441, 113, 113, 1, 5, 443, '2024-04-20 04:40:09', '2024-05-04 09:56:25', NULL),
              (442, 113, 113, 1, 6, 444, '2024-04-20 04:40:09', '2024-05-04 09:56:25', NULL),
              (443, 113, 113, 1, 7, 445, '2024-04-20 04:40:09', '2024-05-04 09:56:25', NULL),
              (444, 57, 57, 1, 446, 446, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (445, 113, 113, 1, 11, 447, '2024-04-20 04:40:09', '2024-05-04 09:56:25', NULL),
              (446, 113, 113, 1, 12, 448, '2024-04-20 04:40:09', '2024-05-04 09:56:25', NULL),
              (447, 113, 113, 1, 10, 449, '2024-04-20 04:40:09', '2024-05-04 09:56:25', NULL),
              (448, 113, 113, 1, 9, 450, '2024-04-20 04:40:09', '2024-05-04 09:56:25', NULL),
              (449, 65, 65, 1, 451, 451, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (450, 64, 64, 1, 452, 452, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (451, 66, 66, 1, 453, 453, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (452, 63, 63, 1, 454, 454, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (453, 113, 113, 1, 8, 455, '2024-04-20 04:40:09', '2024-05-04 09:56:25', NULL),
              (454, 113, 113, 1, 13, 456, '2024-04-20 04:40:09', '2024-05-04 09:56:25', NULL),
              (455, 113, 113, 1, 14, 457, '2024-04-20 04:40:09', '2024-05-04 09:56:25', NULL),
              (456, 113, 113, 1, 15, 458, '2024-04-20 04:40:09', '2024-05-04 09:56:25', NULL),
              (457, 113, 113, 1, 16, 459, '2024-04-20 04:40:09', '2024-05-04 09:56:25', NULL),
              (458, 113, 113, 1, 18, 460, '2024-04-20 04:40:09', '2024-05-04 09:56:25', NULL),
              (459, 113, 113, 1, 19, 461, '2024-04-20 04:40:09', '2024-05-04 09:56:25', NULL),
              (460, 113, 113, 1, 20, 462, '2024-04-20 04:40:09', '2024-05-04 09:56:25', NULL),
              (461, 113, 113, 1, 21, 463, '2024-04-20 04:40:09', '2024-05-04 09:56:25', NULL),
              (462, 113, 113, 1, 22, 464, '2024-04-20 04:40:09', '2024-05-04 09:56:25', NULL),
              (463, 113, 113, 1, 23, 465, '2024-04-20 04:40:09', '2024-05-04 09:56:25', NULL),
              (464, 113, 113, 1, 24, 466, '2024-04-20 04:40:09', '2024-05-04 09:56:25', NULL),
              (465, 113, 113, 1, 25, 467, '2024-04-20 04:40:09', '2024-05-04 09:56:25', NULL),
              (466, 113, 113, 1, 26, 468, '2024-04-20 04:40:09', '2024-05-04 09:56:25', NULL),
              (467, 113, 113, 1, 27, 469, '2024-04-20 04:40:09', '2024-05-04 09:56:25', NULL),
              (468, 113, 113, 1, 17, 470, '2024-04-20 04:40:09', '2024-05-04 09:56:25', NULL),
              (469, 113, 113, 1, 28, 471, '2024-04-20 04:40:09', '2024-05-04 09:56:25', NULL),
              (470, 94, 94, 1, 472, 472, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (471, 62, 62, 1, 1, 473, '2024-04-20 04:40:09', '2024-05-01 10:03:40', NULL),
              (472, 98, 98, 1, 474, 474, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (473, 98, 98, 1, 475, 475, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (474, 98, 98, 1, 476, 476, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (475, 98, 98, 1, 477, 477, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (476, 98, 98, 1, 478, 478, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (477, 98, 98, 1, 479, 479, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (478, 98, 98, 1, 480, 480, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (479, 98, 98, 1, 481, 481, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (480, 98, 98, 1, 482, 482, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (481, 98, 98, 1, 483, 483, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (482, 98, 98, 1, 484, 484, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (483, 98, 98, 1, 485, 485, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (484, 98, 98, 1, 486, 486, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (485, 98, 98, 1, 487, 487, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (486, 98, 98, 1, 488, 488, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (487, 98, 98, 1, 489, 489, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (488, 98, 98, 1, 490, 490, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (489, 98, 98, 1, 491, 491, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (490, 98, 98, 1, 492, 492, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (491, 98, 98, 1, 493, 493, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (492, 98, 98, 1, 494, 494, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (493, 98, 98, 1, 495, 495, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (494, 98, 98, 1, 496, 496, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (495, 112, 112, 1, 11, 497, '2024-04-20 04:40:09', '2024-04-30 06:53:49', '2024-04-30 06:53:49'),
              (496, 293, 293, 1, 498, 498, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (497, 124, 124, 1, 4, 499, '2024-04-20 04:40:09', '2024-05-01 09:43:07', NULL),
              (498, 124, 124, 1, 1, 500, '2024-04-20 04:40:09', '2024-05-01 09:43:07', NULL),
              (499, 124, 124, 1, 2, 501, '2024-04-20 04:40:09', '2024-05-01 09:43:07', NULL),
              (500, 124, 124, 1, 3, 502, '2024-04-20 04:40:09', '2024-05-01 09:43:07', NULL),
              (501, 125, 125, 1, 503, 503, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (502, 125, 125, 1, 504, 504, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (503, 125, 125, 1, 505, 505, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (504, 125, 125, 1, 506, 506, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (505, 125, 125, 1, 507, 507, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (506, 125, 125, 1, 508, 508, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (507, 125, 125, 1, 509, 509, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (508, 125, 125, 1, 510, 510, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (509, 125, 125, 1, 511, 511, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (510, 125, 125, 1, 512, 512, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (511, 125, 125, 1, 513, 513, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (512, 125, 125, 1, 514, 514, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (513, 126, 126, 1, 515, 515, '2024-04-20 04:40:09', '2024-04-25 10:01:13', '2024-04-25 10:01:13'),
              (514, 126, 126, 1, 516, 516, '2024-04-20 04:40:09', '2024-04-25 10:01:13', '2024-04-25 10:01:13'),
              (515, 126, 126, 1, 517, 517, '2024-04-20 04:40:09', '2024-04-25 10:01:13', '2024-04-25 10:01:13'),
              (516, 128, 128, 1, 518, 518, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (517, 129, 129, 1, 519, 519, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (518, 129, 129, 1, 520, 520, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (519, 129, 129, 1, 521, 521, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (520, 129, 129, 1, 522, 522, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (521, 129, 129, 1, 523, 523, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (522, 129, 129, 1, 524, 524, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (523, 129, 129, 1, 525, 525, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (524, 129, 129, 1, 526, 526, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (525, 129, 129, 1, 527, 527, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (526, 125, 125, 1, 528, 528, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (527, 125, 125, 1, 529, 529, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (528, 130, 130, 1, 530, 530, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (529, 302, 302, 1, 531, 531, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (530, 133, 133, 1, 532, 532, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (531, 134, 134, 1, 533, 533, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (532, 135, 135, 1, 534, 534, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (533, 136, 136, 1, 535, 535, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (534, 308, 308, 1, 536, 536, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (535, 50, 50, 1, 537, 537, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (536, 52, 52, 1, 22, 538, '2024-04-20 04:40:09', '2024-04-30 08:22:23', '2024-04-30 08:22:23'),
              (537, 52, 52, 1, 16, 539, '2024-04-20 04:40:09', '2024-04-30 08:13:59', NULL),
              (538, 82, 82, 1, 4, 540, '2024-04-20 04:40:09', '2024-04-30 07:24:17', NULL),
              (539, 82, 82, 1, 5, 541, '2024-04-20 04:40:09', '2024-04-30 07:24:17', NULL),
              (540, 82, 82, 1, 8, 542, '2024-04-20 04:40:09', '2024-04-30 07:24:17', NULL),
              (541, 82, 82, 1, 14, 543, '2024-04-20 04:40:09', '2024-04-30 07:24:17', NULL),
              (542, 82, 82, 1, 18, 544, '2024-04-20 04:40:09', '2024-04-30 07:24:17', NULL),
              (543, 116, 116, 1, 545, 545, '2024-04-20 04:40:09', '2024-04-25 10:01:24', '2024-04-25 10:01:24'),
              (544, 116, 116, 1, 546, 546, '2024-04-20 04:40:09', '2024-04-25 10:01:24', '2024-04-25 10:01:24'),
              (545, 116, 116, 1, 547, 547, '2024-04-20 04:40:09', '2024-04-25 10:01:24', '2024-04-25 10:01:24'),
              (546, 116, 116, 1, 548, 548, '2024-04-20 04:40:09', '2024-04-25 10:01:24', '2024-04-25 10:01:24'),
              (547, 132, 132, 1, 549, 549, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (548, 72, 72, 1, 550, 550, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (549, 74, 74, 1, 551, 551, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (550, 122, 122, 1, 552, 552, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (551, 39, 39, 1, 553, 553, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (552, 138, 138, 1, 554, 554, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (553, 138, 138, 1, 555, 555, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (554, 139, 139, 1, 556, 556, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (555, 139, 139, 1, 557, 557, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (556, 140, 140, 1, 558, 558, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (557, 140, 140, 1, 559, 559, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (558, 141, 141, 1, 560, 560, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (559, 142, 142, 1, 561, 561, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (560, 121, 121, 1, 562, 562, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (561, 75, 75, 1, 2, 563, '2024-04-20 04:40:09', '2024-04-30 06:56:55', NULL),
              (562, 75, 75, 1, 3, 564, '2024-04-20 04:40:09', '2024-04-30 06:56:55', NULL),
              (563, 143, 143, 1, 565, 565, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (564, 143, 143, 1, 566, 566, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (565, 144, 144, 1, 567, 567, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (566, 60, 60, 1, 568, 568, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (567, 48, 48, 1, 569, 569, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (568, 145, 145, 1, 570, 570, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (569, 145, 145, 1, 571, 571, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (570, 52, 52, 1, 18, 572, '2024-04-20 04:40:09', '2024-04-30 08:13:59', NULL),
              (571, 146, 146, 1, 573, 573, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (572, 147, 147, 1, 574, 574, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (573, 110, 110, 1, 5, 575, '2024-04-20 04:40:09', '2024-04-30 07:11:22', NULL),
              (574, 1, 1, 1, 2, 576, '2024-04-20 04:40:09', '2024-05-02 10:33:26', NULL),
              (575, 1, 1, 1, 5, 577, '2024-04-20 04:40:09', '2024-05-02 10:33:26', NULL),
              (576, 1, 1, 1, 13, 578, '2024-04-20 04:40:09', '2024-05-02 10:33:26', NULL),
              (577, 40, 40, 1, 1, 579, '2024-04-20 04:40:09', '2024-04-30 06:47:49', NULL),
              (578, 40, 40, 1, 3, 580, '2024-04-20 04:40:09', '2024-04-30 06:47:49', NULL),
              (579, 40, 40, 1, 2, 581, '2024-04-20 04:40:09', '2024-04-30 06:47:49', NULL),
              (580, 40, 40, 1, 4, 582, '2024-04-20 04:40:09', '2024-04-30 06:47:49', NULL),
              (581, 40, 40, 1, 5, 583, '2024-04-20 04:40:09', '2024-04-30 06:47:49', NULL),
              (582, 40, 40, 1, 7, 584, '2024-04-20 04:40:09', '2024-04-30 06:47:49', NULL),
              (583, 40, 40, 1, 6, 585, '2024-04-20 04:40:09', '2024-04-30 06:47:49', NULL),
              (584, 52, 52, 1, 1, 586, '2024-04-20 04:40:09', '2024-04-30 08:13:59', NULL),
              (585, 52, 52, 1, 6, 587, '2024-04-20 04:40:09', '2024-04-30 08:13:59', NULL),
              (586, 52, 52, 1, 7, 588, '2024-04-20 04:40:09', '2024-04-30 08:13:59', NULL),
              (587, 52, 52, 1, 14, 589, '2024-04-20 04:40:09', '2024-04-30 08:13:59', NULL),
              (588, 148, 148, 1, 590, 590, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (589, 148, 148, 1, 591, 591, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (590, 148, 148, 1, 592, 592, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (591, 148, 148, 1, 593, 593, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (592, 148, 148, 1, 594, 594, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (593, 148, 148, 1, 595, 595, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (594, 148, 148, 1, 596, 596, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (595, 148, 148, 1, 597, 597, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (596, 148, 148, 1, 598, 598, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (597, 148, 148, 1, 599, 599, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (598, 148, 148, 1, 600, 600, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (599, 148, 148, 1, 601, 601, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (600, 148, 148, 1, 602, 602, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (601, 148, 148, 1, 603, 603, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (602, 148, 148, 1, 604, 604, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (603, 148, 148, 1, 605, 605, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (604, 148, 148, 1, 606, 606, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (605, 52, 52, 1, 23, 607, '2024-04-20 04:40:09', '2024-04-30 08:13:59', NULL),
              (606, 1, 1, 1, 34, 608, '2024-04-20 04:40:09', '2024-05-02 10:33:26', NULL),
              (607, 21, 21, 1, 609, 609, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (608, 21, 21, 1, 610, 610, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (609, 21, 21, 1, 611, 611, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (610, 41, 41, 1, 4, 612, '2024-04-20 04:40:09', '2024-04-30 06:07:05', NULL),
              (611, 41, 41, 1, 5, 613, '2024-04-20 04:40:09', '2024-04-30 06:07:05', NULL),
              (612, 41, 41, 1, 6, 614, '2024-04-20 04:40:09', '2024-04-30 06:07:05', NULL),
              (613, 41, 41, 1, 7, 615, '2024-04-20 04:40:09', '2024-04-30 06:07:05', NULL),
              (614, 41, 41, 1, 9, 616, '2024-04-20 04:40:09', '2024-04-30 06:07:05', NULL),
              (615, 1, 1, 1, 23, 617, '2024-04-20 04:40:09', '2024-05-02 10:33:26', NULL),
              (616, 149, 149, 1, 618, 618, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (617, 150, 150, 1, 619, 619, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (618, 151, 151, 1, 620, 620, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (619, 55, 55, 1, 1, 621, '2024-04-20 04:40:09', '2024-04-29 12:23:29', NULL),
              (620, 153, 153, 1, 622, 622, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (621, 137, 137, 1, 623, 623, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (622, 137, 137, 1, 624, 624, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (623, 73, 73, 1, 625, 625, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (624, 157, 157, 1, 626, 626, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (625, 62, 62, 1, 9, 627, '2024-04-20 04:40:09', '2024-05-01 10:03:40', NULL),
              (626, 41, 41, 1, 8, 628, '2024-04-20 04:40:09', '2024-04-30 06:07:05', NULL),
              (627, 112, 112, 1, 12, 629, '2024-04-20 04:40:09', '2024-04-30 06:51:55', NULL),
              (628, 163, 163, 1, 630, 630, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (629, 89, 89, 1, 631, 631, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (630, 165, 165, 1, 632, 632, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (631, 165, 165, 1, 633, 633, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (632, 166, 166, 1, 634, 634, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (633, 166, 166, 1, 635, 635, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (634, 167, 167, 1, 636, 636, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (635, 168, 168, 1, 637, 637, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (636, 152, 152, 1, 638, 638, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (637, 169, 169, 1, 639, 639, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL);
              ");

      \DB::statement("INSERT INTO `test_package_group_test_items` (`id`, `test_package_id`, `test_package_group_id`, `status`, `priority`, `test_item_id`, `created_at`, `updated_at`, `deleted_at`) VALUES
              (638, 111, 111, 1, 3, 640, '2024-04-20 04:40:09', '2024-04-29 11:16:16', NULL),
              (639, 170, 170, 1, 641, 641, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (640, 170, 170, 1, 642, 642, '2024-04-20 04:40:09', '2024-04-20 04:40:09', NULL),
              (641, 1, 1, 1, 11, 643, '2024-04-20 10:31:45', '2024-05-02 10:33:26', NULL),
              (642, 171, 171, 1, 643, 644, '2024-04-22 07:43:53', '2024-04-22 07:43:53', NULL),
              (643, 1, 1, 1, 14, 3, '2024-04-24 13:52:28', '2024-05-02 10:33:26', NULL),
              (644, 1, 1, 1, 15, 4, '2024-04-24 13:52:28', '2024-05-02 10:33:26', NULL),
              (645, 1, 1, 1, 16, 5, '2024-04-24 13:52:28', '2024-05-02 10:33:26', NULL),
              (646, 1, 1, 1, 17, 6, '2024-04-24 13:52:28', '2024-05-02 10:33:26', NULL),
              (647, 1, 1, 1, 18, 7, '2024-04-24 13:52:28', '2024-05-02 10:33:26', NULL),
              (648, 1, 1, 1, 19, 8, '2024-04-24 13:52:28', '2024-05-02 10:33:26', NULL),
              (649, 1, 1, 1, 20, 9, '2024-04-24 13:52:28', '2024-05-02 10:33:26', NULL),
              (650, 1, 1, 1, 21, 10, '2024-04-24 13:52:28', '2024-05-02 10:33:26', NULL),
              (651, 1, 1, 1, 22, 11, '2024-04-24 13:52:28', '2024-05-02 10:33:26', NULL),
              (652, 1, 1, 1, 24, 12, '2024-04-24 13:52:28', '2024-05-02 10:33:26', NULL),
              (653, 1, 1, 1, 25, 13, '2024-04-24 13:52:28', '2024-05-02 10:33:26', NULL),
              (654, 1, 1, 1, 26, 14, '2024-04-24 13:52:28', '2024-05-02 10:33:26', NULL),
              (655, 1, 1, 1, 33, 15, '2024-04-24 13:52:28', '2024-05-02 10:33:26', NULL),
              (656, 1, 1, 1, 36, 352, '2024-04-24 13:52:28', '2024-04-29 11:31:53', '2024-04-29 11:31:53'),
              (657, 1, 1, 1, 37, 576, '2024-04-24 13:52:29', '2024-04-29 11:30:54', '2024-04-29 11:30:54'),
              (658, 1, 1, 1, 38, 577, '2024-04-24 13:52:29', '2024-04-29 11:31:48', '2024-04-29 11:31:48'),
              (659, 1, 1, 1, 39, 578, '2024-04-24 13:52:29', '2024-04-29 11:31:26', '2024-04-29 11:31:26'),
              (660, 1, 1, 1, 35, 608, '2024-04-24 13:52:29', '2024-05-02 10:33:32', '2024-05-02 10:33:32'),
              (661, 1, 1, 1, 32, 617, '2024-04-24 13:52:29', '2024-05-02 10:33:26', NULL),
              (662, 15, 15, 1, 1, 645, '2024-04-29 11:48:22', '2024-05-01 09:51:21', '2024-05-01 09:51:21'),
              (663, 15, 15, 1, 2, 646, '2024-04-29 11:48:53', '2024-05-01 09:51:24', '2024-05-01 09:51:24'),
              (664, 115, 115, 1, 644, 647, '2024-05-02 07:11:12', '2024-05-02 07:11:12', NULL),
              (665, 127, 127, 1, 645, 648, '2024-05-02 07:18:34', '2024-05-02 07:18:34', NULL),
              (666, 20, 20, 1, 646, 649, '2024-05-02 07:28:24', '2024-05-02 07:28:24', NULL),
              (667, 177, 177, 1, 647, 650, '2024-05-02 08:28:57', '2024-05-02 08:28:57', NULL),
              (668, 172, 172, 1, 648, 650, '2024-05-02 10:37:52', '2024-05-02 10:37:52', NULL),
              (669, 47, 47, 1, 649, 651, '2024-05-02 11:29:13', '2024-05-02 11:29:13', NULL),
              (670, 173, 173, 1, 650, 652, '2024-05-03 08:03:32', '2024-05-03 08:03:32', NULL),
              (671, 63, 63, 1, 651, 653, '2024-05-03 09:19:12', '2024-05-03 09:19:12', NULL),
              (672, 174, 174, 1, 652, 654, '2024-05-03 09:20:43', '2024-05-03 09:20:43', NULL),
              (673, 175, 175, 1, 653, 655, '2024-05-03 09:25:58', '2024-05-03 09:25:58', NULL),
              (674, 178, 178, 1, 654, 656, '2024-05-03 09:38:17', '2024-05-03 09:38:17', NULL),
              (675, 84, 84, 1, 655, 657, '2024-05-03 10:30:16', '2024-05-03 10:30:16', NULL),
              (676, 100, 100, 1, 656, 658, '2024-05-03 10:39:42', '2024-05-03 10:39:42', NULL),
              (677, 92, 92, 1, 657, 659, '2024-05-03 11:17:10', '2024-05-03 11:17:10', NULL),
              (678, 176, 176, 1, 658, 660, '2024-05-03 11:49:13', '2024-05-03 11:49:13', NULL),
              (679, 131, 131, 1, 659, 661, '2024-05-03 11:59:23', '2024-05-03 11:59:23', NULL),
              (680, 108, 108, 1, 660, 662, '2024-05-04 07:42:25', '2024-05-04 07:42:25', NULL),
              (681, 181, 181, 1, 661, 663, '2024-05-04 08:19:09', '2024-05-04 08:19:09', NULL),
              (682, 182, 182, 1, 662, 664, '2024-05-04 08:44:12', '2024-05-04 08:44:12', NULL),
              (683, 113, 113, 1, 1, 665, '2024-05-04 09:07:19', '2024-05-04 09:56:25', NULL),
              (684, 113, 113, 1, 2, 666, '2024-05-04 09:08:05', '2024-05-04 09:56:25', NULL),
              (685, 113, 113, 1, 4, 667, '2024-05-04 09:09:01', '2024-05-04 09:56:25', NULL),
              (686, 113, 113, 1, 3, 668, '2024-05-04 09:17:40', '2024-05-04 09:56:25', NULL),
              (687, 183, 183, 1, 663, 669, '2024-05-06 06:26:45', '2024-05-06 06:26:45', NULL),
              (688, 68, 68, 1, 664, 670, '2024-05-07 08:20:07', '2024-05-07 08:20:07', NULL),
              (689, 121, 121, 1, 665, 671, '2024-05-07 08:28:18', '2024-05-07 08:28:18', NULL),
              (690, 121, 121, 1, 666, 672, '2024-05-07 09:35:59', '2024-05-07 09:35:59', NULL),
              (691, 121, 121, 1, 667, 673, '2024-05-07 09:36:24', '2024-05-07 09:36:24', NULL),
              (692, 121, 121, 1, 668, 674, '2024-05-07 09:36:46', '2024-05-07 09:36:46', NULL),
              (693, 158, 158, 1, 669, 675, '2024-05-07 12:19:37', '2024-05-07 12:19:37', NULL),
              (694, 123, 123, 1, 670, 676, '2024-05-08 09:47:06', '2024-05-08 09:47:06', NULL);
            ");
    }
}
